---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Журналы в пакете crwdaq

Здесь содержится описание **Журналов** (_log_) пакета **crwdaq**.

**Журналы** - это средства (файлы, базы данных) для сохранения событий, обычно с привязкой ко времени.
Чаще всего события - это строки сообщений, фиксирующих некоторую информацию о системе,
вместе с указанием источника информации и степени важности этой информации.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Системный журнал SysLog

### Назначение SysLog

Системный журнал **SysLog** служит для сбора информации о работе всех подсистем пакета **crwdaq**.

Подробность ведения журнала зависит от уровня чувствительности **TriggerLevel**.
События с уровнем значимости ниже этого уровня не записываются в журнал.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Расположение SysLog

Системный журнал **SysLog**:

- пишется в файл с именем **`sys.log`** в каталоге **`$CRW_DAQ_VAR_TMP_DIR`**.

- пишется в базу данных (пока не реализовано).  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Формат файла SysLog

Файл **SysLog** - текстовый, с разделителем строк **EOL**.  
Каждая (непустая) строка содержит описание события.

Общий формат строк/событий файла **SysLog**:

``` 
TIMESTAMP => SEVERITY SENDER - BODY

где TIMESTAMP - метка времени
    SEVERITY  - уровень значимости события
    SENDER    - описание источника события
    BODY      - тело сообщения в кодировке pct-encode
```

Маркеры **`' => '`**, **`' - '`** играют роль и не должны искажаться.

Кодирование **pct-encode** применяется к строке сообщения только в случае необходимости,
т.е. при наличии в сообщении "вредных" символов (управляющие символы, знак процента).

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Метка времени TimeStamp

Метка времени содержит календарное время наступления события.  
Формат времени такой:  

``` bash
# Формат метки времени:
yyyy.mm.dd-HH:MM:SS.ZZZ
 
# yyyy - год          формат %4.4d
# mm   - месяц        формат %2.2d
# dd   - день         формат %2.2d
# HH   - часы         формат %2.2d
# MM   - минуты       формат %2.2d
# SS   - секунды      формат %2.2d
# ZZZ  - миллисекунды формат %3.3d
 
# Пример метки времени:
2025.08.21-16:17:38.992
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Уровни значимости Severity

Поле события **Severity** означает его **уровень значимости**.

Уровни значимости занимают диапазон **`0..50`** и делятся на группы,  
в каждой группе (кроме последней - **OFF**) десять уровней,  
начинающихся с базовых уровней каждой группы.  

Базовые уровни групп упорядочены:  

 **`DEBUG < INFO < WARN < ERROR < FATAL < OFF`**

При этом система журналирования имеет уровень срабатываения **TriggerLevel**,
а также флаг значимости - **Notable**:  

 **`Notable = (Severity >= TriggerLevel)`**

Это значит, что все события уровнем ниже **TriggerLevel** считаются незначимыми и не записываются в журнал.  
Это нужно для исключения "спама", то есть избыточно подробной информации, когда она не нужна.

Уровень срабатывания **TriggerLevel** можно узнать/задать командой **`@syslog -t`** в окне **Главная Консоль**.  
Задавать значение уровня срабатывания можно в виде **числа** или **имени** уровня.  
Например:  

``` bash
# Задать TriggerLevel:
@syslog -t info/notify

# Сделать запись в журнал:
@syslog info/notify Demo - Test Message.

# Запись в файле SysLog:
2025.08.21-16:17:38.992 => INFO/NOTIFY: y510p/crwdaq_1/Demo - Test Message.
```

Группы **Severity** имеют такой смысл:  

0. **DEBUG** - отладочные сообщения, интересные только программистам,  
1. **INFO** - информационные сообщения о событиях в нормальной (штатной) ситуации,  
2. **WARN** - предупреждающие сообщения о выходе параметров из нормального диапазона,  
3. **ERROR** - сообщения об устранимых ошибках, подлежащих сравнительно простому исправлению,  
4. **FATAL** - сообщения об неустранимых ошибках, требующих серьезных усилий для исправления,  
5. **OFF** - система журналирования отключена (у этой группы нет подуровней).

Уровни значимости **Severity** можно получить командой **`@syslog -l`**.  
Она выдает примерно такую таблицу:  

```
0  DEBUG
1  DEBUG/REMARK
2  DEBUG/COMMENT
3  DEBUG/LEVEL3
4  DEBUG/LEVEL4
5  DEBUG/DETAILS
6  DEBUG/VIEWEXP
7  DEBUG/VIEWIMP
8  DEBUG/LEVEL8
9  DEBUG/LEVEL9
10 INFO
11 INFO/VOICE
12 INFO/TOOLTIP
13 INFO/INPUT
14 INFO/PRINT
15 INFO/NOTIFY
16 INFO/SUCCESS
17 INFO/LEVEL7
18 INFO/LEVEL8
19 INFO/LEVEL9
20 WARN
21 WARN/LEVEL1
22 WARN/LEVEL2
23 WARN/LEVEL3
24 WARN/HARDSHIP
25 WARN/PROBLEM
26 WARN/MISTIMES
27 WARN/EXCEPTION
28 WARN/WATCHDOG
29 WARN/LEVEL9
30 ERROR
31 ERROR/BUG
32 ERROR/GLITCH
33 ERROR/FAIL
34 ERROR/FAULT
35 ERROR/TROUBLE
36 ERROR/ALARM
37 ERROR/ALERT
38 ERROR/SIREN
39 ERROR/CRITICAL
40 FATAL
41 FATAL/FAILURE
42 FATAL/ABORT
43 FATAL/CRASH
44 FATAL/MISFORTUNE
45 FATAL/EMERGENCY
46 FATAL/ACCIDENT
47 FATAL/CALAMITY
48 FATAL/DISASTER
49 FATAL/DOOMSDAY
50 OFF
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Настройки Severity

Каждый тип событий в пакете **crwdaq** имеет свой уровень **Severity**.

Настройки уровней **Severity** - в файле **[crwdaq.sever.ini](../crwdaq.sever.ini)**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Источник сообщения Sender

Источник сообщения имеет вид: **`HostName/Session/ObjectPath`**, где

- **HostName** - имя компьютера,  
- **Session** - имя сеанса, 
- **ObjectPath** - путь объекта.  

Например: 

``` bash
# Пример сообщения от ядра пакета crwdaq:
crwbox/crwdaq_1/System - …
# crwdox     - имя компьютера
# crwdaq_1   - имя сеанса программы
# System     - указание на системное сообщение

# Пример сообщения от прикладной программы DAQ:
crwbox/crwdaq_1/DAQ/!demo_testbench.cfg/&DEMOTESTBENCH - …

# crwdox                              - имя компьютера
# crwdaq_1                            - имя сеанса программы
# DAQ/!demo_testbench/&DEMOTESTBENCH  - путь объекта:
#  DAQ                                - подсистема сбора данных
#  !demo_testbench                    - имя файла конфигурации
#  &DEMOTESTBENCH                     - имя программы DAQ
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="syslog_serviсе"></a>

## Служба обслуживания журналов SysLog

Системный журнал **SysLog** и другие журналы пакета **crwdaq** находятся в папке **$CRW_DAQ_VAR_TMP_DIR**.
Поскольку журналы копятся, а место на дисках ограничено, журналам требуется (само)обслуживание, которое
заключается в (своевременной) чистке устаревших журналов.
Это - задача службы обслуживания журналов **SysLog**.
Процесс обслуживания журналов называется **[ротацией](#syslog_rotation)** (_rotate_ или _roll_),
так как при этом происходит цикличекое переименование (ротация) файлов старых копий журналов.
Ротация журналов выполняется в автоматическом режиме, но её надо (правильно) настроить.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="syslog_rotation"></a>

### Ротация журналов SysLog

**Ротация** (обслуживание, сжатие) журналов **вызывается**:

- При старте в сценарии входа **[crwdaq.logon.sh](../crwdaq.logon.sh)**,  
- При завершении в сценарии выхода **[crwdaq.logout.sh](../crwdaq.logout.sh)**,  
- В сеансе работы примерно **раз в минуту**  в сценарии наблюдения **[crwdaqwatcher.sh](../crwdaqwatcher.sh)**.  

**Алгоритм ротации**:

- Ротацию журналов выполняет сценарий **[crwdaqlogroll.sh](../crwdaqlogroll.sh)**.  
  Вызов этого сценария возможен только из среды пакета **crwdaq** и обычно выполняется автоматически.  
- При ротации выполняется поиск файлов **`*.log`** с размером не менее порога **`SizeLimit`**.  
  В настоящее время этот порог задается в тексте сценария и равен **32MB**.  
- Для каждого из найденных файлов применяется утилита **[unix logroll](#unix_logroll)**.  
  При сжатии используются параметры **`nmaxkeep compressor`** равные **`9 gz`**.  
  **nmaxkeep** = **9** - число поколений журнала для сохранения,  
  **compress** = **gz** - компрессор, используемый для сжатия.  

**Поколения** журналов:

Утилита **`unix logroll`** сохраняет старые копии журнала в виде "**поколений**" (_generation_) с номерами от **1** до **9**.  
При этом поколения старше первого сжимаются компрессором (**gzip**), а самое старое поколение **nmaxkeep** удаляется.  
Допустим, имеется журнал **sys.log**, тогда:  

- **sys.log** - текущий (актуальный) журнал,  
- **sys.log.1** - первое (несжатое) поколение копий старого журнала,  
- **sys.log.2.gz** - второе (сжатое) поколение копий старого журнала,  
- ...
- **sys.log.9.gz** - девятое (сжатое) поколение копий старого журнала.  

При ротации журнал начинается "с нуля", а старые копии журнала циклически сдвигаются на одно поколение,
при этом самое старое поколение **nmaxkeep** удаляется, а первое поколение при сдвиге также сжимается.

Принятый алгоритм ротации журналов позволяет хранить **9** поколений копий журналов, при этом первое
(самое недавнее) поколение не сжато, чтобы его было удобно смотреть, а остальные сжаты, чтобы сэкономить
место на диске. Однако при необходимости журналы легко развернуть и использовать для просмотра и поиска.
Это хороший компромисс между удобством и экономией дискового пространства.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

<a name="unix_logroll"></a>

### Утилита ротации журналов unix logroll

Утилита **`unix logroll`**, входящая в состав пакета **crwkit**, служит
для выполнения обслуживания журнальных файлов, когда это потребуется,
см. **[logroll.sh](../../../crwkit/add/src/logroll_sh/logroll.sh)**.

Эта утилита осуществляет **ротацию** (_rotate_ или _roll_) журнальных файлов.
Она работает аналогично штатной программе **logrotate**, которая обслуживает системные
журналы **Linux**, но гораздо проще и разработана специально для журналов пакета **crwdaq**.

Утилита **logroll** - это простой автомат, выполняющий ротацию файлов без какой-либо проверки предварительных условий.
За все проверки (например, ротация журналов по достижению определенного размера) отвечает вызывающий код.
Утилита **logroll** лишь исполняет ротацию, когда её необходимость возникла.

Пример:

``` bash
# Вызов с явными параметрами
unix logroll -t demo.log 9 gz

# Ротирует журнал demo.log с 9 поколениями и сжатием gzip
# Сжатие применяется к 2-му и выше поколению копий журнала
# Опция -t (--touch) значит, что при ротации надо создать
# новый журнал нулевой длины

# Создает файлы:
# demo.log      - новый текущий журнал нулевой длины
# demo.log.1    - старая копия журнала 1-го поколения
# demo.log.2.gz - сжатая копия журнала 2-го поколения
# demo.log.3.gz - сжатая копия журнала 3-го поколения
# ...
# demo.log.9.gz - сжатая копия журнала 9-го поколения

# Вызов с параметрами по умолчанию 9 gz
unix logroll -t demo.log
```

Утилита ротации **logroll** применяется для (само)обслуживания **sys.log**
и других журналов **crwdaq** в автоматическом режиме.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

> CrwDaq Copyright © 2001-2025 Alexey Kuryakin <daqgroup@mail.ru>

---
