This list has been extracted from [https://www.worldstandards.eu/other/tlds/](https://www.worldstandards.eu/other/tlds/).

For JSON format, copy-paste the following in the developer console (Chrome):

```javascript
results=[]; jQuery('table tr').each(function(){
  tds = jQuery.map(
    jQuery(this).find('td'), 
    (elt) => jQuery(elt).text()
  );
  if(tds.length == 2){
    tlds = tds[1].match(/\.[a-z]+/g);
    if(tlds){
      results.push({
        'country': tds[0],
        'tlds': tlds
      });
    }
  }
});
copy(results); // copy to clipboard
```

For CSV format:

```javascript
results=['country, tld']; 
jQuery('table tr').each(function(){
  tds = jQuery.map(
    jQuery(this).find('td'), 
    (elt) => jQuery(elt).text()
  );
  if(tds.length == 2){
    tlds = tds[1].match(/\.[a-z]+/g) || [];
    tlds.forEach(function(tld){
        results.push(`"${tds[0]}", ${tld}`);
    });
  }
});
copy(results.join("\n")); // copy to clipboard
```