@echo off
SetLocal EnableExtensions EnableDelayedExpansion

if exist "%~dpn0.exe" ( "%~dpn0.exe" %* & goto :EOF )

:CheckArguments
if "%~1" == "" goto :EOF
if not exist "%~f1" goto :EOF
set id="%~2"
set tip="%~3"
set mix="%~4"
set alt="%~5"
set obs="%~6"
set src="%~7"

:InitVariables
set tz=0
set ta=0
set tb=0
set uz=0.000
set ua=0.000
set ub=0.000
set /a line=0
set /a step=0
set /a zero=0
set /a maxline=1000000
set tabfile=%~dpnx1
set inifile=%~dpn1.INI
set initemp=%~dpn1.INI.TMP
set calfile=%~dpn1.CAL
set caltemp=%~dpn1.CAL.TMP
:InitializeFiles
call :DeleteFiles "%inifile%" "%initemp%" "%calfile%" "%caltemp%"
:ProcessTabFile
for /f "delims=" %%a in ('type "%tabfile%" ^| unix tr "," "\.-" ^| unix u2d') do call :ProcessTab %%a
if exist "%initemp%" call :PrintIniHead "%inifile%"
if exist "%initemp%" type "%initemp%" | unix sort -u -k1g | unix u2d | unix tee -a "%inifile%"
if exist "%initemp%" call :PrintIniTail "%inifile%"
call :PrintCalibrTC "%caltemp%"
if exist "%caltemp%" type "%caltemp%" | unix uniq | unix u2d | unix tee -a "%calfile%"
unix filecase /u "%inifile%"
unix filecase /u "%calfile%"
:CleanupFiles
call :DeleteFiles "%initemp%" "%caltemp%"
goto :EOF

:ProcessTab
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if %line% GTR %maxline% goto :EOF
set /a T=%1
if %T% LSS 0 set /a step=-1
if %T% GTR 0 set /a step=+1
if "%T%" == "0" set /a zero+=1
if "%zero%" == "2" set /a step=+1
if "%T%" == "0" if "%step%" == "0" set /a step=+1
set /a iter=0
:Iteration
if "%~2" == "" goto :EOF
set /a relerr=1
if "%T%" == "0" set /a relerr=0
if "%line%" == "0" unix printf "%%-4s %%-7s %%-6s %%6s\r\n" Data Celsius mV RelErr                  | unix tee -a "%initemp%"
                   unix printf "%%-4s %%-7s %%-6s %%6s\r\n" ""   %T%     %2 %relerr%                | unix tee -a "%initemp%"
if "%T%" == "0"    set tz=%T%
if "%T%" == "0"    set uz=%2
if "%line%" == "0" set ta=%T%
if "%line%" == "0" set ua=%2
set tb=%T%
set ub=%2
set /a T+=step
set /a iter+=1
set /a line+=1
shift
if %iter% LEQ 10 goto :Iteration
goto :EOF

:PrintIniHead
if "%~1" == "" goto :EOF
set target="%~f1"
unix printf "[]\r\n"                                                                                | unix tee -a %target%
unix printf ";*******************************************************************************\r\n"  | unix tee -a %target%
unix printf ";** ThermoCouple type:    %%s (%%s)\r\n" %tip% %mix%                                   | unix tee -a %target%
unix printf ";** Actual/Obsolete id:   %%s / %%s\r\n" %id%  %obs%                                   | unix tee -a %target%
unix printf ";** Alternative names:    %%s\r\n" %alt%                                               | unix tee -a %target%
unix printf ";** Reference source:     %%s\r\n" %src%                                               | unix tee -a %target%
unix printf ";*******************************************************************************\r\n"  | unix tee -a %target%
unix printf ";** Data table contains:\r\n"                                                          | unix tee -a %target%
unix printf ";** Celsius - thermocouple temperature, \xB0C\r\n"                                     | unix tee -a %target%
unix printf ";** mV      - thermoelectric voltage, milliVolts\r\n"                                  | unix tee -a %target%
unix printf ";** RelErr  - relative error of this point, 0 = interpolation\r\n"                     | unix tee -a %target%
unix printf ";*******************************************************************************\r\n"  | unix tee -a %target%
unix printf "[]\r\n"                                                                                | unix tee -a %target%
unix printf "[ThermoCoupleList]\r\n"                                                                | unix tee -a %target%
unix printf "ThermoCouple = %%s\r\n" %id%                                                           | unix tee -a %target%
unix printf "[]\r\n"                                                                                | unix tee -a %target%
unix printf "[%%s]\r\n" %id%                                                                        | unix tee -a %target%
unix printf "FitMethod = Spline ; Use smoothing spline to fit\r\n"                                  | unix tee -a %target%
unix printf "Smooth = 20        ; Smooth parametr for spline\r\n"                                   | unix tee -a %target%
goto :EOF

:PrintIniTail
if "%~1" == "" goto :EOF
set target="%~f1"
unix printf "End Data\r\n"                                                                          | unix tee -a %target%
unix printf "[]\r\n"                                                                                | unix tee -a %target%
goto :EOF

:PrintCalibrTC
if "%~1" == "" goto :EOF
set target="%~f1"
unix printf "[U(mV)-T(C) calibration]\r\n"                                                         | unix tee -a %target%
unix printf "FitMethod = Polynom\r\n"                                                               | unix tee -a %target%
unix printf "TransformX = Line\r\n"                                                                 | unix tee -a %target%
unix printf "TransformY = %%s\r\n" %id%                                                             | unix tee -a %target%
unix printf "Power = 1\r\n"                                                                         | unix tee -a %target%
unix printf "Center = 0\r\n"                                                                        | unix tee -a %target%
unix printf "Scale = 1\r\n"                                                                         | unix tee -a %target%
unix printf "Bounds = %%s %%s\r\n" %ua% %ub%                                                        | unix tee -a %target%
unix printf "%%-4s %%-6s %%-6s %%-6s %%s\r\n" "Data" "U(mV)" "T(C)" "Weight" "Tcj(C)"             | unix tee -a %target%
unix printf "%%-4s %%-6s %%-6s %%-6s %%s\r\n" "" %ua% %ta% 1 0                                      | unix tee -a %target%
unix printf "%%-4s %%-6s %%-6s %%-6s %%s\r\n" "" %uz% %tz% 1 0                                      | unix tee -a %target%
unix printf "%%-4s %%-6s %%-6s %%-6s %%s\r\n" "" %ub% %tb% 1 0                                      | unix tee -a %target%
unix printf "End Data\r\n"                                                                          | unix tee -a %target%
unix printf "Notice Text\r\n"                                                                       | unix tee -a %target%
unix printf "Standard calibration of thermocouple type %%s (%%s) %%s\r\n" %tip% %mix% %alt%         | unix tee -a %target%
unix printf "Reference source: %%s\r\n" %src%                                                       | unix tee -a %target%
unix printf "Configuration example:\r\n"                                                            | unix tee -a %target%
unix printf "Link AnalogInput  0 with curve ThermoCoupleVoltage(mV)\r\n"                            | unix tee -a %target%
unix printf "Link AnalogInput  1 with curve TemperatureColdJunction(C)\r\n"                        | unix tee -a %target%
unix printf "Link AnalogOutput 0 with curve TemperatureThermoCouple(C) history 100\r\n"            | unix tee -a %target%
unix printf "Calibration#0 = ~~\Resource\DaqSite\StdLib\Calibr\%~n1 U(mV) T(C) Tcj(C) Line %%s %%s %%s\r\n" %id% %ua% %ub% | unix tee -a %target%
unix printf "End Notice Text\r\n"                                                                   | unix tee -a %target%
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~f1" del /f /q "%~f1"
call :DeleteFiles %2 %3 %4 %5 %6 %7 %8 %9
goto :EOF
