@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:Main
if /I "%~1" == "--help" ( 1>&2 call :Usage & goto :EOF )
set keyfonts=HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Fonts
set /a fontcount=0 & set /a filecount=0 & set /a errocount=0
call :WindowsFontsView %*
goto :EOF

:Usage
echo ################################################
echo Copyright(c) 2016 Alexey Kuryakin, Sarov Russia.
echo Use the script to view Windows registered fonts.
echo ################################################
echo.
echo Usage:
echo  %~n0         View fonts registered in system
echo  %~n0 mono    View fonts by seach string "mono"
echo  %~n0 --help  Show this help screen
echo.
goto :EOF

:CodePageSave
set /a codepage=0 & for /F "tokens=1,2 delims=:" %%a in ('chcp') do set /a codepage=%%b
goto :EOF

:CodePageAnsi
if "%codepage%" == "866" chcp 1251 1>nul 2>nul
goto :EOF

:CodePageOem
if "%codepage%" == "866" chcp %codepage% 1>nul 2>nul
goto :EOF

:ProcessLine
if "%~1" == "" goto :EOF
for /F "tokens=1,2,3 delims=~" %%j in ('echo %*') do (
 set file=%%l
 set type=%%k
 set name=%%j
 set orig=%%j
 set bold=
 set ital=
 unix -n printf "%%-40s %%-15s" "!file!" "(!type!)" & echo !name!
 for /F "delims=" %%m in ('echo !name! ^| unix -n grep -i " Bold"') do (
  for  /F "delims=" %%n in ('echo !name! ^| unix -n sed -e "s/ Bold//i"') do set name=%%n
  set bold=!bold! bold
 )
 for /F "delims=" %%m in ('echo !name! ^| unix -n grep -i " Italic"') do (
  for  /F "delims=" %%n in ('echo !name! ^| unix -n sed -e "s/ Italic//i"') do set name=%%n
  set ital=!ital! italic
 )
 for /F "delims=" %%m in ('echo !name! ^| unix -n grep -i " Oblique"') do (
  for  /F "delims=" %%n in ('echo !name! ^| unix -n sed -e "s/ Oblique//i"') do set name=%%n
  set ital=!ital! oblique
 )
 if not "%codepage%" == "866" goto :SkipOem
 call :CodePageAnsi
 for /F "delims=" %%m in ('echo !name! ^| unix -n grep -i " "') do (
  for  /F "delims=" %%n in ('echo !name! ^| unix -n sed -e "s/ //i"') do set name=%%n
  set bold=!bold! bold
 )
 for /F "delims=" %%m in ('echo !name! ^| unix -n grep -i ""') do (
  for  /F "delims=" %%n in ('echo !name! ^| unix -n sed -e "s/ //i"') do set name=%%n
  set bold=!bold! bold
 )
 for /F "delims=" %%m in ('echo !name! ^| unix -n grep -i " "') do (
  for  /F "delims=" %%n in ('echo !name! ^| unix -n sed -e "s/ //i"') do set name=%%n
  set ital=!ital! italic
 )
 call :CodePageOem
 :SkipOem
 echo ^<tr^> >> "%filehtm%"
 echo ^<td^>^<strong^>!file!^</strong^>^<small^>^<br^>!type! !bold! !ital!^</small^>^</td^> >> "%filehtm%"
 echo ^<td^>^<strong^>!name!^</strong^>^<small^>^<br^>!orig! ^(!type!^)^</small^>^</td^> >> "%filehtm%"
 if "!bold!" == "" set bold=normal
 if "!ital!" == "" set ital=normal
 echo ^<td^> >> "%filehtm%"
 echo ^<span style=^"color:black; font-weight:!bold!; font-style:!ital!; font-size:100%%; font-family: !name!^"^> >> "%filehtm%"
 echo 0123456789^&nbsp;^"^'#$%%^&amp;^(^)*+,-./^&lt;^&gt;   ^<br^> >> "%filehtm%"
 echo abcdefjhijklmnopqrstuvwxyz                                   >> "%filehtm%"
 echo ABCDEFGHIJKLMNOPQRSTUVWXYZ                            ^<br^> >> "%filehtm%"
 echo                             >> "%filehtm%"
 echo Ũ                     ^<br^> >> "%filehtm%"
 echo ^</span^> >> "%filehtm%"
 echo ^</td^> >> "%filehtm%"
 echo ^</tr^> >> "%filehtm%"
 set /a fontcount=fontcount+1
 if exist "%SystemRoot%\Fonts\!file!" ( set /a filecount=filecount+1 ) else ( set /a errocount=errocount+1 )
)
goto :EOF

:WindowsFontsView
call :CodePageSave
unix cltimer -start 1>nul 2>nul
set caption=%~n0.htm
set filehtm=%temp%\%~n0.htm
if exist "%filehtm%" del /f /q "%filehtm%"
echo ^<html lang=ru^> >> "%filehtm%"
echo ^<body^> >> "%filehtm%"
echo ^<h1^>Registered fonts table:^</h1^> >> "%filehtm%"
if not "%~1" == "" echo Search string: "%~1" >> "%filehtm%"
echo ^<table border=1^> >> "%filehtm%"
echo ^<tr^>^<td^>^<strong^>^<big^>File^</big^>^</strong^> / Type^</td^>^<td^>^<strong^>^<big^>Font name^</big^>^</strong^> / Registry^</td^>^<td^>^<strong^>^<big^>Sample text^</big^>^</strong^>^</td^>^</tr^> >> "%filehtm%"
for /F "delims=" %%i in ('reg query "%keyfonts%" ^| unix -n sed -e "s/\t/ /g" -e "s/  */ /g" ^| unix -n grep "(.*) REG_SZ " ^| unix -n grep -i "%~1" ^| unix -n sed -e "s/(/~/" -e "s/) REG_SZ /~/" ^| unix -n sort') do call :ProcessLine %%i
echo ^</table^> >> "%filehtm%"
echo Found !fontcount! font^(s^) in registry, !filecount! file(s), !errocount! error(s) ^<br^> >> "%filehtm%"
unix cltimer -stop 2>nul | unix tail -n 1 2>nul >> "%filehtm%"
echo ^</body^> >> "%filehtm%"
echo ^</html^> >> "%filehtm%"
start "%caption%" "%filehtm%"
goto :EOF
