 {
 ****************************************************************************
 CRW32 project
 Copyright (C) by Kuryakin Alexey, Sarov, Russia, 2002, <kouriakine@mail.ru>
 DAQ system events and some other routines to process events.
 Modifications:
 20020220 - Creation (uses CRW16) & test
 20030330 - Struggle for safety (add some try/except checks)...
 ****************************************************************************
 }
unit _daqevnt; { DAQ events }

{$I _sysdef}

interface

uses
 sysutils, math, _alloc, _ef, _curves;

 {
 *******************************************************************************
  CRW-DAQ  - .
          
   DispatchEvent,     
    .     .
        :
 1.       What.
   What        :
   evAnalog/Digital    -        
                         .
   evNormal/Important  -    ''. '' 
                           .
   evNo/Compress       -      
                         .    
                             .
   evNo/Spectral       -    .
                               .
                              .
                         . .
      ,  ''   
     ,       
    , ''   .
 2.Chan     -    
     ,      .
 3.Time  ,   .    
     DAQ: Daq.Timer.LocalTime.  ,   
        ,   .
 4.Data[0],Data[1] - .
       Data[0],  Data[1]   .
     Data[0]- , Data[1]-  .
 5. What  Chan      
   DispatchEvent        .
 6.   ,      
     (     ),
     -    (  ).
      .
 *******************************************************************************
 }
type
 TDaqEvent = packed record                {   DAQ}
  What  : Cardinal;                       {  -   evXXXX}
  Chan  : Cardinal;                       {  }
  Time  : Double;                         {   DAQ}
  Data  : packed array[0..1] of Double;   {}
 end;

function DaqEvent(What  : Cardinal;
                  Chan  : Cardinal;
                  Time  : Double;
                  Data0 : Double;
                  Data1 : Double = 0
                      ) : TDaqEvent;

 {
 *******************************************************************************
   TDaqEvent.What
    -  -   .
 *******************************************************************************
 }
const
 evAnalog      = $00000000; evDigital     = $00000001;
 evNormal      = $00000000; evImportant   = $00000002;
 evNoCompress  = $00000000; evCompress    = $00000004;
 evNoSpectral  = $00000000; evSpectral    = $00000008;

 {
 *******************************************************************************
         
   evCompress.
     -     , 
        
    '' .      
    (    ).
    -  abstol   reltol.
       
  x = round( x / abstol ) * abstol
 ,  abstol = 0.01,      .
          
    abstol,      .
        :
 a)      (   [1..2[)
 b)      reltol
 c)   
 ,  reltol = 0.01,       .
          ,
        reltol.
       ,   .
     - ,     .
         ,  
 ,       .
 ,  abstol=0.001, reltol=0.01,     
 abstol/reltol=0.1   ,     -
 .
 :
       ,    
          .
 *******************************************************************************
 }
type
 TDaqCompressor = class(TMasterObject)
 private
  myModel   : Cardinal;
  myAbsTol  : Extended;
  myAbsVal  : Extended;
  myRelTol  : Extended;
  myRelVal  : Extended;
  myThresh  : Extended;
  function    GetAbsTol:Extended;
  procedure   SetAbsTol(aAbsTol:Extended);
  function    GetRelTol:Extended;
  procedure   SetRelTol(aRelTol:Extended);
  procedure   Update(aAbsTol,aRelTol:Extended);
 public
  constructor Create(aAbsTol,aRelTol:Extended);
  property    AbsTol : Extended read GetAbsTol write SetAbsTol;
  property    RelTol : Extended read GetRelTol write SetRelTol;
  function    Compress(What:Extended):Extended;
 end;

function  NewDaqCompressor(aAbsTol,aRelTol:Extended):TDaqCompressor;
procedure Kill(var TheObject:TDaqCompressor); overload;

type
 PDaqCompressorArray = ^TDaqCompressorArray;
 TDaqCompressorArray = array[0..MaxInt div sizeof(TDaqCompressor)-1] of TDaqCompressor;

 {
 *******************************************************************************
       DAQ.
   -    
      '' -
       (1-abs(x)^k1)^k2
 Window -   
 Power  -  -
 K1,K2  -    (1-abs(x)^k1)^k2  '' 
 *******************************************************************************
 }
type
 TDaqSmoother = class(TMasterObject)
 private
  myWindow : Double;
  myPower  : Integer;
  myK1     : Integer;
  myK2     : Integer;
  function    GetWindow:Double;
  procedure   SetWindow(aWindow:Double);
  function    GetPower:Integer;
  procedure   SetPower(aPower:Integer);
  function    GetK1:Integer;
  procedure   SetK1(aK1:Integer);
  function    GetK2:Integer;
  procedure   SetK2(aK2:Integer);
 public
  constructor Create(aWindow:Double; aPower,aK1,aK2:Integer);
  property    Window : Double  read GetWindow write SetWindow;
  property    Power  : Integer read GetPower  write SetPower;
  property    K1     : Integer read GetK1     write SetK1;
  property    K2     : Integer read GetK2     write SetK2;
  function    Smooth(aCurve:TCurve; Where:Double):Double;
 end;

function  NewDaqSmoother(aWindow:Double; aPower,aK1,aK2:Integer):TDaqSmoother;
procedure Kill(var TheObject:TDaqSmoother); overload;

type
 PDaqSmootherArray=^TDaqSmootherArray;
 TDaqSmootherArray=array[0..MaxInt div sizeof(TDaqSmoother)-1] of TDaqSmoother;

implementation

 {
 *******************************************************************************
 DaqEvent implementation
 *******************************************************************************
 }
function DaqEvent(What  : Cardinal;
                  Chan  : Cardinal;
                  Time  : Double;
                  Data0 : Double;
                  Data1 : Double = 0
                      ) : TDaqEvent;
begin
 Result.What:=What;
 Result.Chan:=Chan;
 Result.Time:=Time;
 Result.Data[0]:=Data0;
 Result.Data[1]:=Data1;
end;

 {
 *******************************************************************************
 TDaqCompressor implementation
 *******************************************************************************
 }
constructor TDaqCompressor.Create(aAbsTol,aRelTol:Extended);
begin
 inherited Create;
 Update(aAbsTol,aRelTol);
end;

function  TDaqCompressor.GetAbsTol:Extended;
begin
 if Assigned(Self) then Result:=myAbsTol else Result:=0;
end;

procedure TDaqCompressor.SetAbsTol(aAbsTol:Extended);
begin
 if Assigned(Self) then Update(aAbsTol,RelTol);
end;

function  TDaqCompressor.GetRelTol:Extended;
begin
 if Assigned(Self) then Result:=myRelTol else Result:=0;
end;

procedure TDaqCompressor.SetRelTol(aRelTol:Extended);
begin
 if Assigned(Self) then Update(AbsTol,aRelTol);
end;

procedure TDaqCompressor.Update(aAbsTol,aRelTol:Extended);
begin
 if Assigned(Self) then begin
  if (aAbsTol<=0) and (aRelTol<=0) then begin { }
   myModel:=0;
   myAbsTol:=0;
   myAbsVal:=0;
   myRelTol:=0;
   myRelVal:=0;
   myThresh:=0;
  end else
  if (aRelTol<=0) then begin                  {  Abs}
   myModel:=1;
   myAbsTol:=aAbsTol;
   myAbsVal:=1/aAbsTol;
   myRelTol:=0;
   myRelVal:=0;
   myThresh:=0;
  end else
  if (aAbsTol<=0) then begin                  {  RelTol}
   myModel:=2;
   myAbsTol:=0;
   myAbsVal:=0;
   myRelTol:=aRelTol;
   myRelVal:=1/aRelTol;
   myThresh:=0;
  end else begin                              {  }
   myModel:=3;
   myAbsTol:=aAbsTol;
   myAbsVal:=1/aAbsTol;
   myRelTol:=aRelTol;
   myRelVal:=1/aRelTol;
   myThresh:=aAbsTol/aRelTol;
  end;
 end;
end;

function  TDaqCompressor.Compress(What:Extended):Extended;
begin
 if Assigned(Self) then
 case myModel of
  1 : Result:=fabscompress(What,myAbsVal);
  2 : Result:=frelcompress(What,myRelVal);
  3 : if abs(What)<myThresh
      then Result:=fabscompress(What,myAbsVal)
      else Result:=frelcompress(What,myRelVal);
  else Result:=What;
 end else Result:=What;
end;

function  NewDaqCompressor(aAbsTol,aRelTol:Extended):TDaqCompressor;
begin
 Result:=nil;
 try
  Result:=TDaqCompressor.Create(aAbsTol,aRelTol);
 except
  on E:Exception do BugReport(E);
 end;
end;

procedure Kill(var TheObject:TDaqCompressor); overload;
begin
 try
  FreeAndNil(TheObject);
 except
  on E:Exception do BugReport(E);
 end; 
end;

 {
 *******************************************************************************
 TDaqSmoother implementation
 *******************************************************************************
 }
function    TDaqSmoother.GetWindow:Double;
begin
 if Assigned(Self) then Result:=myWindow else Result:=0;
end;

procedure   TDaqSmoother.SetWindow(aWindow:Double);
begin
 if Assigned(Self) then myWindow:=abs(aWindow);
end;

function    TDaqSmoother.GetPower:Integer;
begin
 if Assigned(Self) then Result:=myPower else Result:=0;
end;

procedure   TDaqSmoother.SetPower(aPower:Integer);
begin
 if Assigned(Self) then myPower:=max(-1,min(9,aPower));
end;

function    TDaqSmoother.GetK1:Integer;
begin
 if Assigned(Self) then Result:=myK1 else Result:=0;
end;

procedure   TDaqSmoother.SetK1(aK1:Integer);
begin
 if Assigned(Self) then myK1:=max(0,min(9,aK1));
end;

function    TDaqSmoother.GetK2:Integer;
begin
 if Assigned(Self) then Result:=myK2 else Result:=0;
end;

procedure   TDaqSmoother.SetK2(aK2:Integer);
begin
 if Assigned(Self) then myK2:=max(0,min(9,aK2));
end;

constructor TDaqSmoother.Create(aWindow:Double; aPower,aK1,aK2:Integer);
begin
 inherited Create;
 Window:=aWindow;
 Power:=aPower;
 K1:=aK1;
 K2:=aK2;
end;

function  TDaqSmoother.Smooth(aCurve:TCurve; Where:Double):Double;
begin
 if Assigned(Self)
 then Result:=aCurve.Smooth(Where, myWindow, myPower, myK1, myK2)
 else Result:=aCurve.Interpolate(Where);
end;

function  NewDaqSmoother(aWindow:Double; aPower,aK1,aK2:Integer):TDaqSmoother;
begin
 Result:=nil;
 try
  Result:=TDaqSmoother.Create(aWindow, aPower, aK1, aK2);
 except
  on E:Exception do BugReport(E);
 end;
end;

procedure Kill(var TheObject:TDaqSmoother); overload;
begin
 try
  FreeAndNil(TheObject);
 except
  on E:Exception do BugReport(E);
 end;
end;

end.
