 {
 ****************************************************************************
 CRW32 project
 Copyright (C) by Kuryakin Alexey, Sarov, Russia, 2003, <kouriakine@mail.ru>
 This unit contains API interface to use in DLL plugins for CRW32.
 ****************************************************************************
 }

unit _CrwApi;

{$I _sysdef}

interface

uses SysUtils, Windows, Math, Classes, Graphics;

 ///////////////////////////////////////////////////////////////////////////////
 //      .                           //
 ///////////////////////////////////////////////////////////////////////////////
const
 //  .
 KiloByte          = 1024;
 MegaByte          = KiloByte*KiloByte;
 GigaByte          = KiloByte*MegaByte;
 //   ASCII.
 ASCII_NUL         = char($00);                         // -- Null
 ASCII_SOH         = char($01);                         // ^A Start Of Header
 ASCII_STX         = char($02);                         // ^B Start of TeXt
 ASCII_ETX         = char($03);                         // ^C End of TeXt
 ASCII_EOT         = char($04);                         // ^D End Of Transfer
 ASCII_ENQ         = char($05);                         // ^E ENQuiry
 ASCII_ACK         = char($06);                         // ^F ACKnowledge
 ASCII_BEL         = char($07);                         // ^G Bell
 ASCII_BS          = char($08);                         // ^H Back Space
 ASCII_HT          = char($09);                         // ^I Horizontal Tabulation
 ASCII_LF          = char($0A);                         // ^J Line Feed
 ASCII_VT          = char($0B);                         // ^K Vertical Tabulation
 ASCII_FF          = char($0C);                         // ^L Form Feed
 ASCII_CR          = char($0D);                         // ^M Carriage Return
 ASCII_SO          = char($0E);                         // ^N     
 ASCII_SI          = char($0F);                         // ^O     
 ASCII_DLE         = char($10);                         // ^P  
 ASCII_DC1         = char($11);                         // ^Q Data Control 1
 ASCII_DC2         = char($12);                         // ^R Data Control 2
 ASCII_DC3         = char($13);                         // ^S Data Control 3
 ASCII_DC4         = char($14);                         // ^T Data Control 4
 ASCII_NAK         = char($15);                         // ^U NoAcKnowledge
 ASCII_SYN         = char($16);                         // ^V SYNcronize
 ASCII_ETB         = char($17);                         // ^W End Transfer Block
 ASCII_CAN         = char($18);                         // ^X CANcel
 ASCII_EM          = char($19);                         // ^Y End Media
 ASCII_SUB         = char($1A);                         // ^Z SUBstitute
 ASCII_ESC         = char($1B);                         // -- ESCape
 ASCII_FS          = char($1C);                         // -- File Separator
 ASCII_GS          = char($1D);                         // -- Group Separator
 ASCII_RS          = char($1E);                         // -- Record Separator
 ASCII_US          = char($1F);                         // -- Unit Separator
 ASCII_XON         = ASCII_DC1;                         // Uses for RS-232 software flow control
 ASCII_XOFF        = ASCII_DC3;                         // Uses for RS-232 software flow control
 CR                = ASCII_CR;                          // Carriage Return
 LF                = ASCII_LF;                          // Line Feed
 FF                = ASCII_FF;                          // Form Feed
 TAB               = ASCII_HT;                          // Tabulator
 CRLF              = CR+LF;                             // DOS & Win line break
 //   ModalResult.
 mrNone            = 0;
 mrOk              = idOk;
 mrCancel          = idCancel;
 mrAbort           = idAbort;
 mrRetry           = idRetry;
 mrIgnore          = idIgnore;
 mrYes             = idYes;
 mrNo              = idNo;
 mrAll             = mrNo + 1;
 mrNoToAll         = mrAll + 1;
 mrYesToAll        = mrNoToAll + 1;
 //   ScanVar.
 svNoCase          = 0;                                 //  Format  .
 svUpCase          = $0001;                             // Format    .
 svLoCase          = $0002;                             // Format    .
 svCaseMask        = svUpCase+svLoCase;                 //    .
 svLSpace          = $0004;                             //     .
 svRSpace          = $0008;                             //     .
 svSpaces          = svLSpace+svRSpace;                 //     -  (   ).
 svOrigin          = $0010;                             //      .
 svAsIs            = 0;                                 //   ,  .
 svConfig          = svUpCase+svSpaces+svOrigin;        //    ini-.
 //   ExtractTextSection.
 efNoCase          = 0;                                 //   .
 efUpCase          = $0001;                             //      .
 efLoCase          = $0002;                             //     .
 efCaseMask        = efUpCase+efLoCase;                 //    .
 efLTrim           = $0004;                             //    .
 efRTrim           = $0008;                             //    .
 efTrimMask        = efLTrim+efRTrim;                   //      .
 efDelCom          = $0010;                             //  .
 efAsIs            = 0;                                 //  .
 efConfig          = efUpCase+efLTrim+efRTrim+efDelCom; //    ini-.
 esComments        = [';'];                             //    ini-.
 //    DebugOut.
 stdfDebug         = 0;                                 //    .
 sdtfError         = 1;                                 //    .
 //     .
 DirDelimiters     = ['\','/'];                         //  .
 DosDelimiters     = ['\','/',':'];                     //    .
 ScanSpaces        = [' ',Tab,CR,LF,',',';','='];       //    .
 ScanWordDelims    = [CR,';'];                          //   .
 WordSet           = ['_', 'a'..'z', 'A'..'Z',''..'', ''..'', ''..'', ''..'','0'..'9'];
 //   CurveFlags.
 cfInvalid         = $00000001;                         //   .
 cfNoData          = $00000002;                         //    .
 cfNoComment       = $00000004;                         //    .
 cfTooSmall        = $00000008;                         //    .
 cfNotSortedX      = $00000010;                         //     x.
 cfNotSortedY      = $00000020;                         //     y.
 cfDuplicatesX     = $00000040;                         //       x.
 cfDuplicatesY     = $00000080;                         //       y.
 cfNotEquiDistantX = $00000100;                         //      x.
 cfNotEquiDistantY = $00000200;                         //      y.
 cfHaveZeroX       = $00000400;                         //     x=0.
 cfHaveZeroY       = $00000800;                         //     y=0.
 cfHavePozitivX    = $00001000;                         //     x>0.
 cfHavePozitivY    = $00002000;                         //     y>0.
 cfHaveNegativX    = $00004000;                         //     x<0.
 cfHaveNegativY    = $00008000;                         //     y<0.
 cfNaNX            = $00010000;                         //     x=NAN.
 cfNaNY            = $00020000;                         //     y=NAN.
 cfInfX            = $00040000;                         //     x=INF.
 cfInfY            = $00080000;                         //     y=INF.
 cfNanXY           = cfNanX+cfNanY;
 cfInfXY           = cfInfX+cfInfY;
 cfNanInf          = cfNanXY+cfInfXY;
 //   CurveSort
 sfPrimaryY        = $0001;                             //    - Y,   ,  
 sfReversPrimary   = $0002;                             //       
 sfReversSecondary = $0004;                             //       
 sfPack            = $0008;                             //      
 //   DaqApi.putev
 evAnalog          = $00000000;                         //    AnalogOutput
 evDigital         = $00000001;                         //    DigitalOutput
 evNormal          = $00000000;                         //  ,   
 evImportant       = $00000002;                         //  ,  
 evNoCompress      = $00000000;                         //   
 evCompress        = $00000004;                         //  
 evNoSpectral      = $00000000;                         //   ,    
 evSpectral        = $00000008;                         //  ,   
 //  DaqApi.DaqCommand
 Daq_Cmd_Init      = 1;                                 //  " "
 Daq_Cmd_Free      = 2;                                 //  " "
 Daq_Cmd_Poll      = 3;                                 //  " "
 Daq_Cmd_User      = $1000;                             //   
 //   
 mNelderMead             = 0;                           // NM  - -
 mDavidonFletcherPowell  = 1;                           // DFP - --
 mBroyden                = 2;                           // B   - 
 mPearson2               = 3;                           // P2  -  2
 mPearson3               = 4;                           // P3  -  3
 mZoutendijk             = 5;                           // Z   - 
 mSteward                = 6;                           // S   - 
 mFletcherReeves         = 7;                           // FR  - -
 mDavidon2               = 8;                           // D2  -  2
 //   , minimization error code
 mecOk             = 0;                                 // Ok,minimum found
 mecBadDim         = 1;                                 // Bad dimension
 mecBadMethod      = 2;                                 // Unknown method
 mecBadArg         = 3;                                 // Invalid argument
 mecBadVal         = 4;                                 // Invalid value
 mecUserBreak      = 5;                                 // User breaks minimization process
 mecFail           = 6;                                 // Convergence not achieved
 mecInfPassed      = 7;                                 // Function value < user-defined infimum
 mecBounds         = 8;                                 // Out of available bounds
 mecInitErr        = 9;                                 // Init error
 mecDoneErr        = 10;                                // Finit error
 mecBadScale       = 11;                                // Invalid scale in GenMinScaled
 mecBadWeight      = 12;                                // Invalid weights in least squares
 mecDLLError       = 13;                                // Error loading DLL
 mecOutOfMem       = 14;                                // Detect out of memory
 //  LinearProgrammingBySimplex
 si_Ok               = 0;                               //  , 
 si_SolutionInfinite = 1;                               //  
 si_ConditionsError  = 2;                               //  ,  
 si_OutOfMemory      = -1;                              //     
 si_InvalidInput     = -2;                              //     NIL-
 si_InvalidSignum    = -3;                              //     Signums
 si_InvalidRange     = -4;                              //    
 si_Exception        = -5;                              //  
 si_Input            = $0001;                           //   
 si_Result           = $0002;                           //  
 si_IterBasis        = $0004;                           //     
 si_IterFun          = $0008;                           //      
 si_IterSigm         = $0010;                           //  -
 si_Echo             = $8000;                           //      
 //     CGA, . CgaToRgbColor
 Black             = 0;
 Blue              = 1;
 Green             = 2;
 Cyan              = 3;
 Red               = 4;
 Magenta           = 5;
 Brown             = 6;
 LightGray         = 7;
 DarkGray          = 8;
 LightBlue         = 9;
 LightGreen        = 10;
 LightCyan         = 11;
 LightRed          = 12;
 LightMagenta      = 13;
 Yellow            = 14;
 White             = 15;
 //  AdamGetStatus.   Request Status.
 rs_NotAvail       = 0;                                 //  RS-485 
 rs_NoRequest      = 1;                                 //   ,  
 rs_WaitQueue      = 2;                                 //  ,      
 rs_WaitAnswer     = 3;                                 //  ,   ,  
 rs_Answer         = 4;                                 //       RS-485
 rs_TimeOut        = 5;                                 // TimeOut :      
 //     .
 ChemEl_H  = 1;    ChemEl_He = 2;     ChemEl_Li = 3;     ChemEl_Be = 4;     ChemEl_B  = 5;
 ChemEl_C  = 6;    ChemEl_N  = 7;     ChemEl_O  = 8;     ChemEl_F  = 9;     ChemEl_Ne = 10;
 ChemEl_Na = 11;   ChemEl_Mg = 12;    ChemEl_Al = 13;    ChemEl_Si = 14;    ChemEl_P  = 15;
 ChemEl_S  = 16;   ChemEl_Cl = 17;    ChemEl_Ar = 18;    ChemEl_K  = 19;    ChemEl_Ca = 20;
 ChemEl_Sc = 21;   ChemEl_Ti = 22;    ChemEl_V  = 23;    ChemEl_Cr = 24;    ChemEl_Mn = 25;
 ChemEl_Fe = 26;   ChemEl_Co = 27;    ChemEl_Ni = 28;    ChemEl_Cu = 29;    ChemEl_Zn = 30;
 ChemEl_Ga = 31;   ChemEl_Ge = 32;    ChemEl_As = 33;    ChemEl_Se = 34;    ChemEl_Br = 35;
 ChemEl_Kr = 36;   ChemEl_Rb = 37;    ChemEl_Sr = 38;    ChemEl_Y  = 39;    ChemEl_Zr = 40;
 ChemEl_Nb = 41;   ChemEl_Mo = 42;    ChemEl_Tc = 43;    ChemEl_Ru = 44;    ChemEl_Rh = 45;
 ChemEl_Pd = 46;   ChemEl_Ag = 47;    ChemEl_Cd = 48;    ChemEl_In = 49;    ChemEl_Sn = 50;
 ChemEl_Sb = 51;   ChemEl_Te = 52;    ChemEl_I  = 53;    ChemEl_Xe = 54;    ChemEl_Cs = 55;
 ChemEl_Ba = 56;   ChemEl_La = 57;    ChemEl_Ce = 58;    ChemEl_Pr = 59;    ChemEl_Nd = 60;
 ChemEl_Pm = 61;   ChemEl_Sm = 62;    ChemEl_Eu = 63;    ChemEl_Gd = 64;    ChemEl_Tb = 65;
 ChemEl_Dy = 66;   ChemEl_Ho = 67;    ChemEl_Er = 68;    ChemEl_Tm = 69;    ChemEl_Yb = 70;
 ChemEl_Lu = 71;   ChemEl_Hf = 72;    ChemEl_Ta = 73;    ChemEl_W  = 74;    ChemEl_Re = 75;
 ChemEl_Os = 76;   ChemEl_Ir = 77;    ChemEl_Pt = 78;    ChemEl_Au = 79;    ChemEl_Hg = 80;
 ChemEl_Tl = 81;   ChemEl_Pb = 82;    ChemEl_Bi = 83;    ChemEl_Po = 84;    ChemEl_At = 85;
 ChemEl_Rn = 86;   ChemEl_Fr = 87;    ChemEl_Ra = 88;    ChemEl_Ac = 89;    ChemEl_Th = 90;
 ChemEl_Pa = 91;   ChemEl_U  = 92;    ChemEl_Np = 93;    ChemEl_Pu = 94;    ChemEl_Am = 95;
 ChemEl_Cm = 96;   ChemEl_Bk = 97;    ChemEl_Cf = 98;    ChemEl_Es = 99;    ChemEl_Fm = 100;
 ChemEl_Md = 101;  ChemEl_No = 102;   ChemEl_Lr = 103;   ChemEl_Ku = 104;   ChemEl_Ns = 105;
 rfa_MinAtomId = ChemEl_H;
 rfa_MaxAtomId = ChemEl_Ns;

type
 //     
 TRfaFieldId=(                                          //    :
  rfa_ATOM_ID,        rfa_ATOM_SYMBOL,                  //    
  rfa_ATOM_NAME_RUS,  rfa_ATOM_NAME_ENG,                //   /
  rfa_ATOM_GROUP,     rfa_ATOM_PERIOD,                  //   
  rfa_ATOM_COLOR,     rfa_CROSS_SECTION,                //    
  rfa_ATOM_WEIGHT,    rfa_ATOM_DENSITY,                 //    
  rfa_EKAB,  rfa_EL1AB,  rfa_EL2AB,  rfa_EL3AB,         //    K,L1,L2,L3-  
  rfa_EKA,   rfa_IKA,                                   //   K a1 + a2
  rfa_EKA1,  rfa_IKA1,                                  //   K a1
  rfa_EKA2,  rfa_IKA2,                                  //   K a2
  rfa_EKB,   rfa_IKB,                                   //   K b1 + b2
  rfa_EKB1,  rfa_IKB1,                                  //   K b1
  rfa_EKB2,  rfa_IKB2,                                  //   K b2
  rfa_EKB3,  rfa_IKB3,                                  //   K b3
  rfa_ELA12, rfa_ILA12,                                 //   L3 a1 + a2
  rfa_ELA1,  rfa_ILA1,                                  //   L3 a1
  rfa_ELA2,  rfa_ILA2,                                  //   L3 a2
  rfa_ELB1,  rfa_ILB1,                                  //   L2 b1
  rfa_ELB2,  rfa_ILB2,                                  //   L3 b2
  rfa_ELB3,  rfa_ILB3,                                  //   L1 b3
  rfa_ELB4,  rfa_ILB4,                                  //   L1 b4
  rfa_ELB5,  rfa_ILB5,                                  //   L3 b5
  rfa_ELB6,  rfa_ILB6,                                  //   L3 b6
  rfa_ELB10, rfa_ILB10,                                 //   L1 b10
  rfa_ELB15, rfa_ILB15,                                 //   L3 b15
  rfa_ELB17, rfa_ILB17,                                 //   L2 b17
  rfa_ELG1,  rfa_ILG1,                                  //   L2 g1
  rfa_ELG2,  rfa_ILG2,                                  //   L1 g2
  rfa_ELG3,  rfa_ILG3,                                  //   L1 g3
  rfa_ELG4,  rfa_ILG4,                                  //   L1 g4
  rfa_ELG4_, rfa_ILG4_,                                 //   L1 g4_
  rfa_ELG5,  rfa_ILG5,                                  //   L2 g5
  rfa_ELG6,  rfa_ILG6,                                  //   L2 g6
  rfa_ELG8,  rfa_ILG8,                                  //   L2 g6
  rfa_ELG11, rfa_ILG11,                                 //   L1 g11
  rfa_ELmu,  rfa_ILmu,                                  //   L2 Mu
  rfa_ELnu,  rfa_ILnu,                                  //   L2 Nu
  rfa_ELL,   rfa_ILL,                                   //   L3 L
  rfa_RSRV01, rfa_RSRV02, rfa_RSRV03, rfa_RSRV04,       //   
  rfa_RSRV05, rfa_RSRV06, rfa_RSRV07, rfa_RSRV08,       //   
  rfa_RSRV09, rfa_RSRV10, rfa_RSRV11, rfa_RSRV12,       //   
  rfa_RSRV13, rfa_RSRV14, rfa_RSRV15, rfa_RSRV16,       //   
  rfa_RSRV17, rfa_RSRV18, rfa_RSRV19, rfa_RSRV20,       //   
  rfa_RSRV21, rfa_RSRV22, rfa_RSRV23, rfa_RSRV24,       //   
  rfa_RSRV25, rfa_RSRV26, rfa_RSRV27, rfa_RSRV28,       //   
  rfa_RSRV29, rfa_RSRV30, rfa_RSRV31, rfa_RSRV32,       //   
  rfa_RSRV33, rfa_RSRV34, rfa_RSRV35, rfa_RSRV36,       //   
  rfa_RSRV37, rfa_RSRV38, rfa_RSRV39, rfa_RSRV40,       //   
  rfa_RSRV41, rfa_RSRV42, rfa_RSRV43, rfa_RSRV44,       //   
  rfa_RSRV45, rfa_RSRV46, rfa_RSRV47, rfa_RSRV48,       //   
  rfa_RSRV49, rfa_RSRV50, rfa_RSRV51, rfa_RSRV52,       //   
  rfa_RSRV53, rfa_RSRV54, rfa_RSRV55, rfa_RSRV56,       //   
  rfa_RSRV57, rfa_RSRV58, rfa_RSRV59, rfa_RSRV60,       //   
  rfa_RSRV61, rfa_RSRV62, rfa_RSRV63, rfa_RSRV64,       //   
  rfa_RSRV65, rfa_RSRV66, rfa_RSRV67, rfa_RSRV68,       //   
  rfa_RSRV69, rfa_RSRV70, rfa_RSRV71, rfa_RSRV72,       //   
  rfa_RSRV73, rfa_RSRV74, rfa_RSRV75, rfa_RSRV76,       //   
  rfa_RSRV77, rfa_RSRV78, rfa_RSRV79, rfa_RSRV80,       //   
  rfa_RSRV81, rfa_RSRV82, rfa_RSRV83, rfa_RSRV84,       //   
  rfa_RSRV85, rfa_RSRV86, rfa_RSRV87, rfa_RSRV88,       //   
  rfa_RSRV89, rfa_RSRV90, rfa_RSRV91, rfa_RSRV92,       //   
  rfa_RSRV93, rfa_RSRV94, rfa_RSRV95, rfa_RSRV96,       //   
  rfa_RSRV97, rfa_RSRV98, rfa_RSRV99, rfa_RSRV100,      //   
  rfa_KEMISSION,   rfa_L31EMISSION, rfa_L32EMISSION,    //    
  rfa_L33EMISSION, rfa_L21EMISSION, rfa_L22EMISSION,    //    
  rfa_ATOMS_MM1,                                        //     
  rfa_ATOMS_M1,                                         //     
  rfa_ATOMS_M2,                                         //     
  rfa_ATOMS_RHO,                                        //  /.
  rfa_ATOMS_ATRHO,                                      //  , 10**22 /.
  rfa_ATOMS_VFERMI,                                     //      
  rfa_ATOMS_LFCTR,                                      //   
  rfa_STRAG_S1, rfa_STRAG_S2, rfa_STRAG_S3, rfa_STRAG_S4,   //    
  rfa_PSTOP_P1, rfa_PSTOP_P2, rfa_PSTOP_P3, rfa_PSTOP_P4,   //   
  rfa_PSTOP_P5, rfa_PSTOP_P6, rfa_PSTOP_P7, rfa_PSTOP_P8,   //   
  rfa_ELEMPOS_X, rfa_ELEMPOS_Y,                         //      
  rfa_INVALID_FIELD                                     //     
 );
 TRfaFieldIdSet = set of TRfaFieldId;                   //     
 TRfaCrossSectionFieldId = (                            //   
  rfa_ENERGY,                                           //   
  rfa_PHOTO,                                            //  
  rfa_COHER,                                            //   
  rfa_INCOHER,                                          //   
  rfa_TOTAL                                             //  
 );
 TRfaXRayLine = packed record Energy,Height:Double; end;//   
 //         .
 TRfaDataBaseWrap = class(TObject)
  //
  // 0    -  True,    ,         .
  //
  function  GetAccessible(AtomId:Integer):Boolean;                       virtual; abstract;
  //
  // 1    -         ;     /.
  //
  function  GetAsDouble(AtomId:Integer; FieldId:TRfaFieldId):Double;     virtual; abstract;
  //
  // 2    -         ;     .
  //
  function  GetAsString(AtomId:Integer; FieldId:TRfaFieldId):ShortString;virtual; abstract;
  //
  // 3    -      .  ,  LineId .
  //
  function  GetXRayLine(AtomId:Integer; LineId:TRfaFieldId):TRfaXRayLine;virtual; abstract;
  //
  // 4    -    .
  //
  function  GetAtomSymbol(AtomId:Integer):ShortString;                   virtual; abstract;
  //
  // 5    -      .
  //
  function  GetFieldName(FieldId:TRfaFieldId):ShortString;               virtual; abstract;
  //
  // 6    -    .
  //
  function  GetLineName(LineId:TRfaFieldId):ShortString;                 virtual; abstract;
  //
  // 7    -       .
  //
  function  GetCrossSectionTableCount(AtomId:Integer):Integer;           virtual; abstract;
  //
  // 8    -     .
  //
  function  GetCrossSectionTable(AtomId:Integer; aChan:TRfaCrossSectionFieldId;
                                 aIndex:Integer):Double;                 virtual; abstract;
  //
  // 9    -          0.
  //
  function  FindAtom(const aSymbol:ShortString):Integer;                 virtual; abstract;
  //
  // 10   -         rfa_INVALID_FIELD.
  //
  function  FindLine(const aLineName:ShortString):TRfaFieldId;           virtual; abstract;
  //
  // 11   -  ,     .
  //
  function  FindCrossSection(AtomID:Integer; CrossId:TRfaCrossSectionFieldId;
                               Energy:Double):Double;                    virtual; abstract;
 public
  property    Accessible[AtomId:Integer]                   : Boolean      read GetAccessible;
  property    AsDouble[AtomId:Integer;FieldId:TRfaFieldId] : Double       read GetAsDouble; default;
  property    AsString[AtomId:Integer;FieldId:TRfaFieldId] : ShortString  read GetAsString;
  property    XRayLine[AtomId:Integer;LineId:TRfaFieldId]  : TRfaXRayLine read GetXRayLine;
  property    AtomSymbol[AtomId:Integer]                   : ShortString  read GetAtomSymbol;
  property    FieldName[FieldId:TRfaFieldId]               : ShortString  read GetFieldName;
  property    LineName[LineId:TRfaFieldId]                 : ShortString  read GetLineName;
  property    CrossSectionTableCount[AtomId:Integer]       : Integer      read GetCrossSectionTableCount;
  property    CrossSectionTable[AtomId:Integer; Chan:TRfaCrossSectionFieldId; aIndex:Integer] : Double  read GetCrossSectionTable;
 end;

const
 rfa_FIRST_FIELD        = Low(TRfaFieldId);             //   
 rfa_LAST_FIELD         = Pred(rfa_INVALID_FIELD);      //   
 //  ,   .
 rfa_K_Series_Shorten   = [rfa_EKA,             rfa_EKB];
 rfa_K_Series_Perfect   = [rfa_EKA1, rfa_EKA2,  rfa_EKB1, rfa_EKB2, rfa_EKB3];
 rfa_L1_Series_Shorten  = [rfa_ELB3, rfa_ELB4,  rfa_ELB10, rfa_ELG2, rfa_ELG3, rfa_ELG4, rfa_ELG4_, rfa_ELG11];
 rfa_L1_Series_Perfect  = [rfa_ELB3, rfa_ELB4,  rfa_ELB10, rfa_ELG2, rfa_ELG3, rfa_ELG4, rfa_ELG4_, rfa_ELG11];
 rfa_L2_Series_Shorten  = [rfa_ELB1, rfa_ELB17, rfa_ELG1, rfa_ELG5, rfa_ELG6, rfa_ELG8, rfa_ELmu, rfa_ELnu];
 rfa_L2_Series_Perfect  = [rfa_ELB1, rfa_ELB17, rfa_ELG1, rfa_ELG5, rfa_ELG6, rfa_ELG8, rfa_ELmu, rfa_ELnu];
 rfa_L3_Series_Shorten  = [rfa_ELA12,           rfa_ELB2, rfa_ELB5, rfa_ELB6, rfa_ELB15, rfa_ELL];
 rfa_L3_Series_Perfect  = [rfa_ELA1,  rfa_ELA2, rfa_ELB2, rfa_ELB5, rfa_ELB6, rfa_ELB15, rfa_ELL];
 rfa_K_Series           = rfa_K_Series_Shorten  + rfa_K_Series_Perfect;
 rfa_L1_Series          = rfa_L1_Series_Shorten + rfa_L1_Series_Perfect;
 rfa_L2_Series          = rfa_L2_Series_Shorten + rfa_L2_Series_Perfect;
 rfa_L3_Series          = rfa_L3_Series_Shorten + rfa_L3_Series_Perfect;
 rfa_L_Series_Shorten   = rfa_L1_Series_Shorten + rfa_L2_Series_Shorten + rfa_L3_Series_Shorten;
 rfa_L_Series_Perfect   = rfa_L1_Series_Perfect + rfa_L2_Series_Perfect + rfa_L3_Series_Perfect;
 rfa_L_Series           = rfa_L_Series_Shorten + rfa_L_Series_Perfect;
 rfa_All_Series_Shorten = rfa_K_Series_Shorten + rfa_L_Series_Shorten;
 rfa_All_Series_Perfect = rfa_K_Series_Perfect + rfa_L_Series_Perfect;
 rfa_All_Series         = rfa_K_Series + rfa_L_Series;

type
 TCharSet        = set of char;
 TByteSet        = set of byte;
 LongString      = AnsiString;
 PByte           = ^Byte;
 PByteArray      = ^TByteArray;
 TByteArray      = packed array[0..(MaxInt div sizeof(Byte))-1]     of Byte;
 TCharArray      = packed array[0..(MaxInt div sizeof(Char))-1]     of Char;
 PShortInt       = ^ShortInt;
 PShortIntArray  = ^TShortIntArray;
 TShortIntArray  = packed array[0..(MaxInt div sizeof(ShortInt))-1] of ShortInt;
 PBoolean        = ^Boolean;
 PBooleanArray   = ^TBooleanArray;
 TBooleanArray   = packed array[0..(MaxInt div sizeof(Boolean))-1]  of Boolean;
 PWord           = ^Word;
 PWordArray      = ^TWordArray;
 TWordArray      = packed array[0..(MaxInt div sizeof(Word))-1]     of Word;
 PSmallInt       = ^SmallInt;
 PSmallIntArray  = ^TSmallIntArray;
 TSmallIntArray  = packed array[0..(MaxInt div sizeof(SmallInt))-1] of SmallInt;
 PLongWord       = ^LongWord;
 PLongWordArray  = ^TLongWordArray;
 TLongWordArray  = packed array[0..(MaxInt div sizeof(LongWord))-1] of LongWord;
 PDWord          = ^DWord;
 PDWordArray     = ^TDWordArray;
 TDWordArray     = packed array[0..(MaxInt div sizeof(DWord))-1]    of DWord;
 PLongInt        = ^LongInt;
 PLongIntArray   = ^TLongIntArray;
 TLongIntArray   = packed array[0..(MaxInt div sizeof(LongInt))-1]  of LongInt;
 PCardinal       = ^Cardinal;
 PCardinalArray  = ^TCardinalArray;
 TCardinalArray  = packed array[0..(MaxInt div sizeof(Cardinal))-1] of Cardinal;
 PInteger        = ^Integer;
 PIntegerArray   = ^TIntegerArray;
 TIntegerArray   = packed array[0..(MaxInt div sizeof(Integer))-1]  of Integer;
 PInt64          = ^Int64;
 PInt64Array     = ^TInt64Array;
 TInt64Array     = packed array[0..(MaxInt div sizeof(Int64))-1]    of Int64;
 PSingle         = ^Single;
 PSingleArray    = ^TSingleArray;
 TSingleArray    = packed array[0..(MaxInt div sizeof(Single))-1]   of Single;
 PDouble         = ^Double;
 PDoubleArray    = ^TDoubleArray;
 TDoubleArray    = packed array[0..(MaxInt div sizeof(Double))-1]   of Double;
 PComp           = ^Comp;
 PCompArray      = ^TCompArray;
 TCompArray      = packed array[0..(MaxInt div sizeof(Comp))-1]     of Comp;
 PExtended       = ^Extended;
 PExtendedArray  = ^TExtendedArray;
 TExtendedArray  = packed array[0..(MaxInt div sizeof(Extended))-1] of Extended;
 PPointerArray   = ^TPointerArray;
 TPointerArray   = packed array[0..(MaxInt div sizeof(Pointer))-1]  of Pointer;
 //   
 TPoint2I        = packed record x,y : Integer; end;
 TPoint2D        = packed record x,y : Double;  end;
 TPoint3D        = packed record x,y,z : Double; end;
 TRect2I         = packed record a,b : TPoint2I; end;
 TRect2D         = packed record a,b : TPoint2D; end;
 PPoint2IArray   = ^TPoint2IArray;
 TPoint2IArray   = packed array[0..MaxInt div sizeof(TPoint2I)-1] of TPoint2I;
 PPoint2DArray   = ^TPoint2DArray;
 TPoint2DArray   = packed array[0..MaxInt div sizeof(TPoint2D)-1] of TPoint2D;
 PPoint3DArray   = ^TPoint3DArray;
 TPoint3DArray   = packed array[0..MaxInt div sizeof(TPoint3D)-1] of TPoint3D;
 PRect2IArray    = ^TRect2IArray;
 TRect2IArray    = packed array[0..MaxInt div sizeof(TRect2I)-1] of TRect2I;
 PRect2DArray    = ^TRect2DArray;
 TRect2DArray    = packed array[0..MaxInt div sizeof(TRect2D)-1] of TRect2D;
 //   FindZero, FindMin  ..
 zmFunType       = function ( x : Double; Custom : Pointer ) : Double;
 //   ForEachFile.
 TForEachFileAction     = procedure ( const FileName    : ShortString;
                                      const FileDetails : TSearchRec;
                                            SubDirLevel : Integer;
                                        var Terminate   : Boolean;
                                            CustomData  : Pointer);
 //   ForEachTexLine.
 TForEachTextLineAction = procedure ( const FileName    : ShortString;
                                      const Line        : ShortString;
                                            Count       : LongInt;
                                        var Terminate   : Boolean;
                                            CustomData  : Pointer);
 //     
 // n=, x=, f=, g=, Custom= .
 TMinProblem  = function(n:Integer; var x:array of Double; var f:Double;
                                    var g:array of Double; Custom:Pointer):Integer;
 //     
 TMinReport  = procedure(n:Integer; var x:array of Double; var f:Double;
                                    var g:array of Double; Custom:Pointer;
                                    Count:Integer; const Method,Comment:ShortString);
 //    
 // t=, n= ,  x=, f=, g=  ,
 // Custom= .
 TFitProblem = function(t:Double; n:Integer; var x:array of Double; var f:Double;
                                             var g:array of Double; Custom:Pointer):Integer;
 //     
 TFitReport=procedure(m:Integer; const t,y,w:array of Double; n:Integer;
                      const x:array of Double; const f:Double; const g:array of Double;
                      Custom:Pointer; Count:Integer; const Method,Comment:ShortString);
 //       .
 // Compare(Data,Key1,Key2)   Key1,Key2  
 // 1  Key1^ > Key2^; 0  Key1^ = Key2^; -1  Key1^ < Key2^.
 //  Data   .
 TCompareFunction = function(Data,Key1,Key2:Pointer):Integer;
 //       .
 // KeyOf(Data,j)   Data[j]   j=0..Count-1   Data.
 TKeyOfFunction = function(Data:Pointer; i:Integer):Pointer;
 //      " ".
 // Swap(Data,i,j)    i,j  Data.
 TSwapProcedure = procedure(Data:Pointer; i,j:Integer);
 //      
 TSmoothKernel = function(x:Double; CustomData:Pointer):Double;
 //
 //  TScriptInterpreter     
 //       Daq Script.
 //
 TScriptInterpreter = class(TObject)
  //
  // 0    -   .
  //
  function  GetValue(aName:PChar; var aValue:Double):Boolean;            virtual; abstract;
  //
  // 1    -   .  .
  //
  function  SetValue(aName:PChar; var aValue:Double):Boolean;            virtual; abstract;
  //
  // 2    -   .
  //
  procedure Clear;                                                       virtual; abstract;
  //
  // 3    -  .
  //
  function  Evaluate(aExpression:PChar):Integer;                         virtual; abstract;
  //
  // 4    -   .
  //
  function  GetScript:LongString;                                        virtual; abstract;
  //
  // 5    -   .
  //
  procedure SetScript(const aScript:LongString);                         virtual; abstract;
  //
  // 6    -   Script.
  //
  function  RunScript:Integer;                                           virtual; abstract;
  //
  // 7    -    .
  //
  function  Status:Integer;                                              virtual; abstract;
  //
  // 8    -   .
  //
  function  StatusMessage:ShortString;                                   virtual; abstract;
 public
  property  Script : LongString read GetScript write SetScript;
 end;
 //
 //  TPolynomWrap      
 //        
 // .     :
 //  P(x) = P(z) = C[0]+C[1]*z+C[2]*z^2...,  z=(x-Center)/Scale
 //  Center   Scale ,    
 //     ,      
 //   .     ,   
 //  z    [0..1].
 //
 TPolynomWrap = class(TObject)
  //
  // 0    -   .
  //
  function  GetPower:Integer;                                            virtual; abstract;
  //
  // 1    -   .
  //
  procedure SetPower(aPower:Integer);                                    virtual; abstract;
  //
  // 2    -   .
  //
  function  GetCoeff(aIndex:Integer):Double;                             virtual; abstract;
  //
  // 3    -   .
  //
  procedure SetCoeff(aIndex:Integer; aValue:Double);                     virtual; abstract;
  //
  // 4    -   () .
  //
  function  GetCenter:Double;                                            virtual; abstract;
  //
  // 5    -   () .
  //
  procedure SetCenter(aCenter:Double);                                   virtual; abstract;
  //
  // 6    -    .
  //
  function  GetScale:Double;                                             virtual; abstract;
  //
  // 7    -    .
  //
  procedure SetScale(aScale:Double);                                     virtual; abstract;
  //
  // 8    -        
  //        aDerivNum   at.
  //
  function  Get(at:Double; aDerivNum:Integer=0):Double;                  virtual; abstract;
  //
  // 9    -      , 
  //          (X[i],Y[i]), i=0..NumPoints-1   
  //
  function  Find(const X,Y:array of Double; NumPoints:Integer;
                 Eps:double=1E-14):boolean;                              virtual; abstract;
  //
  // 10   -      , 
  //          (X[i],Y[i]), i=0..NumPoints-1  
  //          W[i].
  //
  function  FindWeight(const X,Y,W:array of Double; NumPoints:Integer;
                       Eps:double=1E-14):boolean;                        virtual; abstract;
 public
  property  Power:Integer                read GetPower  write SetPower;
  property  Coeff[aIndex:Integer]:Double read GetCoeff  write SetCoeff; default;
  property  Center:Double                read GetCenter write SetCenter;
  property  Scale:Double                 read GetScale  write SetScale;
 end;
 //
 //  TLongIntVectorWrap,TDoubleVectorWrap,TLongIntMatrixWrap,TDoubleMatrixWrap
 //           .
 // Lock/UnLock -   -    .
 // Origin      -    ,   .
 // Length      -   .
 // Rows        -    .
 // Cols        -    .
 // Exceptions  -        .
 // :
 //  var x:TDoubleVectorWrap; y:TDoubleMatrixWrap; i,j:Integer;
 //  x:=CreateDoubleVector(100);
 //  y:=CreateDoubleMatrix(100,100);
 //  x.Lock;
 //  y.Lock;
 //  try
 //   for i:=0 to x.Length-1 do x[i]:=i;
 //   for i:=0 to y.Rows-1 do for j:=0 to y.Cols-1 do y[i,j]:=x[i]*j;
 //  finally
 //   y.UnLock;
 //   x.UnLock;
 //  end;
 //  x.Free;
 //  y.Free;
 //
 TLongIntVectorWrap = class(TObject)
  procedure Lock;                                                        virtual; abstract;
  procedure UnLock;                                                      virtual; abstract;
  function  GetLength:LongInt;                                           virtual; abstract;
  procedure SetLength(aLength:LongInt);                                  virtual; abstract;
  function  GetOrigin:LongInt;                                           virtual; abstract;
  procedure SetOrigin(aOrigin:LongInt);                                  virtual; abstract;
  function  GetExceptions:Boolean;                                       virtual; abstract;
  procedure SetExceptions(aExcepts:Boolean);                             virtual; abstract;
  function  GetItem(aIndex:LongInt):LongInt;                             virtual; abstract;
  procedure SetItem(aIndex:LongInt; const aValue:LongInt);               virtual; abstract;
  function  GetItemPtr(aIndex:LongInt):PLongInt;                         virtual; abstract;
 public
  property    Length             : LongInt  read GetLength     write SetLength;
  property    Origin             : LongInt  read GetOrigin     write SetOrigin;
  property    Exceptions         : Boolean  read GetExceptions write SetExceptions;
  property    Item[i:LongInt]    : LongInt  read GetItem       write SetItem; default;
  property    ItemPtr[i:LongInt] : PLongInt read GetItemPtr;
 end;
 TDoubleVectorWrap = class(TObject)
  procedure Lock;                                                        virtual; abstract;
  procedure UnLock;                                                      virtual; abstract;
  function  GetLength:LongInt;                                           virtual; abstract;
  procedure SetLength(aLength:LongInt);                                  virtual; abstract;
  function  GetOrigin:LongInt;                                           virtual; abstract;
  procedure SetOrigin(aOrigin:LongInt);                                  virtual; abstract;
  function  GetExceptions:Boolean;                                       virtual; abstract;
  procedure SetExceptions(aExcepts:Boolean);                             virtual; abstract;
  function  GetItem(aIndex:LongInt):Double;                              virtual; abstract;
  procedure SetItem(aIndex:LongInt; const aValue:Double);                virtual; abstract;
  function  GetItemPtr(aIndex:LongInt):PDouble;                          virtual; abstract;
 public
  property    Length             : LongInt read GetLength     write SetLength;
  property    Origin             : LongInt read GetOrigin     write SetOrigin;
  property    Exceptions         : Boolean read GetExceptions write SetExceptions;
  property    Item[i:LongInt]    : Double  read GetItem       write SetItem; default;
  property    ItemPtr[i:LongInt] : PDouble read GetItemPtr;
 end;
 TLongIntMatrixWrap = class(TObject)
  procedure Lock;                                                        virtual; abstract;
  procedure UnLock;                                                      virtual; abstract;
  function  GetRows:LongInt;                                             virtual; abstract;
  procedure SetRows(aRows:LongInt);                                      virtual; abstract;
  function  GetColumns:LongInt;                                          virtual; abstract;
  procedure SetColumns(aColumns:LongInt);                                virtual; abstract;
  function  GetOrigin:LongInt;                                           virtual; abstract;
  procedure SetOrigin(aOrigin:LongInt);                                  virtual; abstract;
  function  GetExceptions:Boolean;                                       virtual; abstract;
  procedure SetExceptions(aExcepts:Boolean);                             virtual; abstract;
  function  GetItem(aRow,aColumn:LongInt):LongInt;                       virtual; abstract;
  procedure SetItem(aRow,aColumn:LongInt; const aValue:LongInt);         virtual; abstract;
  function  GetItemPtr(aRow,aColumn:LongInt):PLongInt;                   virtual; abstract;
 public
  property  Rows                 : LongInt  read GetRows       write SetRows;
  property  Cols                 : LongInt  read GetColumns    write SetColumns;
  property  Origin               : LongInt  read GetOrigin     write SetOrigin;
  property  Exceptions           : Boolean  read GetExceptions write SetExceptions;
  property  Item[r,c:LongInt]    : LongInt  read GetItem       write SetItem; default;
  property  ItemPtr[r,c:LongInt] : PLongInt read GetItemPtr;
 end;
 TDoubleMatrixWrap = class(TObject)
  procedure Lock;                                                        virtual; abstract;
  procedure UnLock;                                                      virtual; abstract;
  function  GetRows:LongInt;                                             virtual; abstract;
  procedure SetRows(aRows:LongInt);                                      virtual; abstract;
  function  GetColumns:LongInt;                                          virtual; abstract;
  procedure SetColumns(aColumns:LongInt);                                virtual; abstract;
  function  GetOrigin:LongInt;                                           virtual; abstract;
  procedure SetOrigin(aOrigin:LongInt);                                  virtual; abstract;
  function  GetExceptions:Boolean;                                       virtual; abstract;
  procedure SetExceptions(aExcepts:Boolean);                             virtual; abstract;
  function  GetItem(aRow,aColumn:LongInt):Double;                        virtual; abstract;
  procedure SetItem(aRow,aColumn:LongInt; const aValue:Double);          virtual; abstract;
  function  GetItemPtr(aRow,aColumn:LongInt):PDouble;                    virtual; abstract;
 public
  property  Rows                 : LongInt  read GetRows       write SetRows;
  property  Cols                 : LongInt  read GetColumns    write SetColumns;
  property  Origin               : LongInt  read GetOrigin     write SetOrigin;
  property  Exceptions           : Boolean  read GetExceptions write SetExceptions;
  property  Item[r,c:LongInt]    : Double   read GetItem       write SetItem; default;
  property  ItemPtr[r,c:LongInt] : PDouble  read GetItemPtr;
 end;
 //
 //  TSVDWrap -      ,
 //         ..
 // .
 //   (singular values decomposition,SVD)  A 
 // M   N  A[M*N] -      
 // U[M*M],W[M*N],V[N*N]  A=U*W*V',  V'  "V ".
 //  U[M*M], "left singular vectors",     A*A'.
 //  V[N*N], "right singular vectors",    A'*A.
 //  U  V ,  , U'*U=I(M), V'*V=I(N),  I(N),I(M)
 //     N  M.  W[M*N] - ,
 //   W[i,j]=0  i<>j.   W[i]=W[i,i],i=1..N - 
 //   (singular values)  A.   Sqr(W[i]) 
 //    A'*A.    ,
 //   W[i]>=0.      ,  
 //  .   ,  W[i]>0.   ,
 //      W[i].  ,     ,
 //    Eps   ""  .
 //  Cond(A)=Max(W[i])/Min(W[i])  " ".
 //     ,     , 
 //    .
 //   .
 //        A*X=Y, 
 // A[M*N],X[N],Y[M]  M>=N.       X, 
 //   ,     R=A*X-Y,  
 //     {R'*R}.    ?
 // -, |R|=|U'*R|,        
 //  .    A=U*W*V'.   
 //  Z=V'*X    D=U'*Y.
 // : |R|=|U'*(A*X-Y)|=|U'*U*W*V'*X-U'*Y|=|W*Z-D|,   U'*U=I.
 //   ,   W -  .
 //  Z=pinv(W,Eps)*D,  pinv(W,Eps) -  ""
 // : pinv(W,Eps)[i]=1/W[i], W[i]>Eps; pinv(W,Eps)[i]=0, W[i]<=Eps,
 //  Eps -  ""  . Eps   
 //  .  V'*X=pinv(W,Eps)*U'*Y,   
 //      X=V*pinv(W,Eps)*U'*Y.
 //  pinv(A,Eps)=V*pinv(W,Eps)*U' - ""   Eps.
 // ,   A*X=Y   X=pinv(A,Eps)*Y,  ""
 //  pinv(A,Eps)=V*pinv(W,Eps)*U'  Eps -    .
 //  1:
 //     U[M*N]  U[M*M]   W[N]  W[M*N].
 //   ,  W[i,j]=0,  i<>j.    
 //    W[i,j],    N..M-1  U.
 //  TSVDWrap     U[M*N]   W[N].
 // :
 // M,N   -    A[M*N]
 // Eps   -  ""         .
 // Rank  -  ,     ,    Eps.
 // Solve -     A*X=Y  M*N    , A=U*W*V'.
 // PInv  -  ()    N*M.
 //
 TSVDWrap=class(TObject)
  function  GetM:Integer;                                                virtual; abstract;
  function  GetN:Integer;                                                virtual; abstract;
  function  GetU(i,j:Integer):Double;                                    virtual; abstract;
  function  GetW(i:Integer):Double;                                      virtual; abstract;
  function  GetV(i,j:Integer):Double;                                    virtual; abstract;
  function  Eps(AbsEps:Double=0; RelEps:Double=1E-10):Double;            virtual; abstract;
  function  Rank(AbsEps:Double=0; RelEps:Double=1E-10):Integer;          virtual; abstract;
  function  Solve(X,Y:TDoubleVectorWrap;
                  AbsEps:Double=0; RelEps:Double=1E-10):Boolean;         virtual; abstract;
  function  PInvert(AbsEps:Double=0;
                    RelEps:Double=1E-10):TDoubleMatrixWrap;              virtual; abstract;
 public
  property M               : Integer read GetM;  //     A
  property N               : Integer read GetN;  //    A
  property U[i,j:Integer]  : Double  read GetU;  // U[0..M-1,0..N-1] -> A=U*W*V'
  property W[i:Integer]    : Double  read GetW;  // W[0..N-1]        -> A=U*W*V'
  property V[i,j:Integer]  : Double  read GetV;  // V[0..N-1,0..N-1] -> A=U*W*V'
 end;
 //
 //  TFifoWrap       
 //   FIFO.     ,  
 //  ,  .    
 //    .
 //
 TFifoWrap = class(TObject)
  procedure   Lock;                                                      virtual; abstract;
  procedure   UnLock;                                                    virtual; abstract;
  procedure   Clear;                                                     virtual; abstract;
  function    GetCount:LongInt;                                          virtual; abstract;
  function    GetSpace:LongInt;                                          virtual; abstract;
  function    GetSize:LongInt;                                           virtual; abstract;
  function    GetName:ShortString;                                       virtual; abstract;
  procedure   SetName(const NewName:ShortString);                        virtual; abstract;
  function    GetTag(i:Integer):LongWord;                                virtual; abstract;
  procedure   SetTag(i:Integer; NewTag:LongWord);                        virtual; abstract;
  function    GetLost:Int64;                                             virtual; abstract;
  procedure   SetLost(N:Int64);                                          virtual; abstract;
  function    Put(Buffer:Pointer; BufferSize:LongInt;
                  TryMode:Boolean=false):LongInt;                        virtual; abstract;
  function    Get(Buffer:Pointer; BufferSize:LongInt):LongInt;           virtual; abstract;
  function    PutText(const S:LongString;
                      TryMode:Boolean=false):Boolean;                    virtual; abstract;
  function    GetText(MaxLen:Integer=MaxInt):LongString;                 virtual; abstract;
 public
  property    Name           : ShortString read GetName  write SetName;  //  
  property    Tag[i:Integer] : LongWord    read GetTag   write SetTag;   //     
  property    Count          : LongInt     read GetCount;                //     
  property    Space          : LongInt     read GetSpace;                //     
  property    Size           : LongInt     read GetSize;                 //  
  property    Lost           : Int64       read GetLost  write SetLost;  //   
 end;
 //
 //
 //
 ///////////////////////////////////////////////////////////////////////////////
 //     CRW32.                    //
 // 1)    .                                                     //
 //    ,        ,   //
 //     .    ,  ,   //
 //    ,    ,  ,    //
 //      DLL.  DLL    , //
 //          ,  //
 //           .    //
 //        ,         //
 //     -   -       //
 //     .  CRW32, ,       //
 //     Delphi, ,  .                           //
 // 2)   .                                                   //
 //        .  ,   //
 //         ,    //
 //     DLL ()      ,   //
 //      (API).    (property),  //
 //        .        //
 //     -      ,      //
 //    .   ,  COM - ,  .         //
 //      ()   ,    //
 //      ,    ,    .   //
 //    ,   DLL,   :                        //
 //      function Plugin(Api:TPluginApi):Integer; StdCall;                    //
 //       API             //
 //    ,     .     //
 //         ,     //
 //     .    , ,    //
 //      .                                                //
 // 3)  .                                              //
 //        ,    //
 //       ,         //
 //            .     //
 //       ,            //
 //        .     //
 //    ,         ,  //
 //           .                          //
 //      0,   ,   .      //
 //           API.                   //
 ///////////////////////////////////////////////////////////////////////////////
const
 //
 //    DLL  CRW32.
 //
 CRW32_PLUGIN_ID    = 'CRW32_PLUGIN_FUNCTION';
 //
 //   .
 //
 ForCalculations    = 0; //    .
 ForDataAnalysis    = 1; //    .
 ForDataAcquisition = 2; //    .

type
 ///////////////////////////////////////////////////////////////////////////////
 //   ,              //
 //   CRW32.                                                  //
 ///////////////////////////////////////////////////////////////////////////////
 TPluginApi = class(TObject)
  //
  // 0    -      ,    .
  //
  procedure ServerActionsBeforeExecution;                                virtual; abstract;
  //
  // 1    -      ,    .
  //
  procedure ServerActionsAfterExecution;                                 virtual; abstract;
 end;
 //
 ///////////////////////////////////////////////////////////////////////////////
 //     CRW32          //
 //       CRW32_PLUGIN_ID.                      //
 ///////////////////////////////////////////////////////////////////////////////
 TPluginFun = function(Api:TPluginApi):Integer; StdCall;
 //
 //   CRW32.
 //
 TCrwApi    = class;            //    CRW32 API.
 TSysApi    = class;            // API    .
 TGuiApi    = class;            // API    .
 TDaqApi    = class;            // API    .
 TDanApi    = class;            // API   .
 //
 //   CRW32.
 //
 ECrwApi    = class(Exception);
 ESysApi    = class(Exception);
 EDaqApi    = class(Exception);
 EDanApi    = class(Exception);
 ///////////////////////////////////////////////////////////////////////////////
 //  CrwApi     CRW API           //
 //     -  .                //
 ///////////////////////////////////////////////////////////////////////////////
 TCrwApi    = class(TPluginApi)
  //
  // 0    -  API,   , , 20030215.
  //
  function  Version:Cardinal;                                            virtual; abstract;
  //
  // 1    -   .
  //           ForCalculations, ForDataAnalysis, ForDataAcquisition.
  //
  function  Target:Cardinal;                                             virtual; abstract;
  //
  // 2    - API    .
  //
  function  SysApi:TSysApi;                                              virtual; abstract;
  //
  // 3    - API    .
  //
  function  GuiApi:TGuiApi;                                              virtual; abstract;
  //
  // 4    - API    .
  //
  function  DaqApi:TDaqApi;                                              virtual; abstract;
  //
  // 5    - API    .
  //
  function  DanApi:TDanApi;                                              virtual; abstract;
 end;
 //
 ///////////////////////////////////////////////////////////////////////////////
 //  TSysApi    .        //
 //  Target.                                                         //
 ///////////////////////////////////////////////////////////////////////////////
 TSysApi = class(TPluginApi)
  //
  // 0    -         .
  //
  function  RedirectStdIn(var stdIn:Text):boolean;                       virtual; abstract;
  //
  // 1    -         .
  //
  function  RedirectStdOut(var stdOut:Text):boolean;                     virtual; abstract;
  //
  // 2    -  .
  //
  function  IncPtr(Base:Pointer; ByteOffset:LongInt):Pointer;            virtual; abstract;
  //
  // 3    -  .
  //
  function  DecPtr(Base:Pointer; ByteOffset:LongInt):Pointer;            virtual; abstract;
  //
  // 4    -     .
  //
  procedure SafeMove(const Source; var Dest; Count: LongInt);            virtual; abstract;
  //
  // 5    -     .
  //
  procedure SafeFillChar(var X; Count: LongInt; Value: Byte);            virtual; abstract;
  //
  // 6    -      Size   Step.
  //
  function  AdjustBufferSize(Size:LongInt; Step:LongInt):LongInt;        virtual; abstract;
  //
  // 7    -       nil  .
  //            .
  //
  function  Allocate(N:LongInt):Pointer;                                 virtual; abstract;
  //
  // 8    -   ,   Allocate.
  //
  procedure Deallocate(var P:Pointer);                                   virtual; abstract;
  //
  // 9    -    ,   Allocate.
  //
  function  AllocSize(P:Pointer):LongInt;                                virtual; abstract;
  //
  // 10   -  ,   Allocate.
  //           ,   .
  //
  function  Reallocate(var P:Pointer; N:LongInt):boolean;                virtual; abstract;
  //
  // 11   -      Not A Number.
  //
  function  isNAN(const X: Double): Boolean;                             virtual; abstract;
  //
  // 12   -      Infinity.
  //
  function  isINF(const X: Double): Boolean;                             virtual; abstract;
  //
  // 13   -   Not A Number, " ".
  //
  function  _NaN: Double;                                                virtual; abstract;
  //
  // 14   -   +Infinity, " ".
  //
  function  _PlusInf: Double;                                            virtual; abstract;
  //
  // 15   -   -Infinity, " ".
  //
  function  _MinusInf: Double;                                           virtual; abstract;
  //
  // 16   -    F(x)   [A,B]   Tol.
  //         Custom     F(x)  .
  //
  function  FindZero(F:zmFunType;A,B,Tol:Double;Custom:Pointer):Double;  virtual; abstract;
  //
  // 17   -    F(x)  [A,B]   Tol.
  //         Custom     F(x)  .
  //
  function  FindMin(F:zmFunType;A,B,Tol:Double;Custom:Pointer):Double;   virtual; abstract;
  //
  // 18   -   F(x)   [A,B]    AbsErr
  //          RelErr .   ,
  //            ErrEst,   Flag,   0
  //          ,      NoFun.
  //         Custom     F(x)  .
  //        
  function  Quanc8(F:zmFunType;A,B,AbsErr,RelErr:Double; var ErrEst:Double;
            var NoFun:Integer; var Flag:Double; Custom:Pointer):Double;  virtual; abstract;
  //
  // 19   -     .
  //
  function  MachEps:double;                                              virtual; abstract;
  //
  // 20   -     .
  //
  function  NativeTimeNow:TSystemTime;                                   virtual; abstract;
  //
  // 21   -        (01.01.0001-00:00:00).
  //
  function  MSecNow:double;                                              virtual; abstract;
  //
  // 22   -     .
  //
  function  AssignNativeTime(Year:word=1;Month:word=1;Day:word=1;
                             Hour:word=0;Minut:word=0;Sec:word=0;
                             mSec:word=0):TSystemTime;                   virtual; abstract;
  //
  // 23   -      .
  //
  function  MSecToNativeTime(mSecond:Double):TSystemTime;                virtual; abstract;
  //
  // 24   -      .
  //
  function  NativeTimeToMSec(const T:TSystemTime):double;                virtual; abstract;
  //
  // 25   -      .
  //
  function  DateTimeToMSec(Year:Word=1;Month:Word=1;Day:Word=1;
                           Hour:Word=0;Minut:Word=0;Sec:Word=0;
                           mSec:Word=0):Double;                          virtual; abstract;
  //
  // 26   -      .
  //
  procedure MSecToDateTime(T:Double;
                           var Year,Month,Day,Hour,Min,Sec,mSec:word);   virtual; abstract;
  //
  // 27   -          .
  //
  function  GetDateStr(ms:Double;Delim:Char='.';YMD_Order:Boolean=false;
                       ShortYear:Boolean=false):ShortString;             virtual; abstract;
  //
  // 28   -           .
  //
  function  GetTimeStr(ms:double;Delim:Char=':';
                       ShowMSec:Boolean=false):ShortString;              virtual; abstract;
  //
  // 29   -  ,  .
  //
  function  StrLen(Str: PChar): LongInt;                                 virtual; abstract;
  //
  // 30   -  ,    MaxLen.
  //
  function  StrLLen(Str: PChar; MaxLen: Integer): LongInt;               virtual; abstract;
  //
  // 31   -    ,   Str.
  //
  function  StrEnd(Str: PChar): PChar;                                   virtual; abstract;
  //
  // 32   -   Source   Dest   Dest.
  //
  function  StrCopy(Dest, Source: PChar): PChar;                         virtual; abstract;
  //
  // 33   -  Source  Dest   StrEnd(Dest).
  //
  function  StrECopy(Dest, Source: PChar): PChar;                        virtual; abstract;
  //
  // 34   -    MaxLen   Source  Dest   Dest.
  //
  function  StrLCopy(Dest, Source: PChar; MaxLen: LongInt): PChar;       virtual; abstract;
  //
  // 35   -  Pascal- Source   Dest   Dest.
  //
  function  StrPCopy(Dest: PChar; const Source: ShortString): PChar;     virtual; abstract;
  //
  // 36   -   Source    Dest   Dest.
  //
  function  StrCat(Dest, Source: PChar): PChar;                          virtual; abstract;
  //
  // 37   -   Pascal- Source   Dest   Dest.
  //
  function  StrPCat(Dest:PChar; const Source: ShortString): PChar;       virtual; abstract;
  //
  // 38   -    MaxLen - StrLen(Dest)   Source  
  //        Dest,  Dest.
  //
  function  StrLCat(Dest, Source: PChar; MaxLen: LongInt): PChar;        virtual; abstract;
  //
  // 39   -  Str1  Str2.   < 0  Str1 < Str2,
  //        0  Str1 = Str2,   > 0  Str1 > Str2.
  //
  function  StrComp(Str1, Str2: PChar): Integer;                         virtual; abstract;
  //
  // 40   -  Str1  Str2,  ,    .
  //
  function  StrIComp(Str1, Str2: PChar): Integer;                        virtual; abstract;
  //
  // 41   -  Str1  Str2,    MaxLen .
  //
  function  StrLComp(Str1, Str2: PChar; MaxLen: LongInt): Integer;       virtual; abstract;
  //
  // 42   -  Str1  Str2,    MaxLen ,   .
  //
  function  StrLIComp(Str1, Str2: PChar; MaxLen: LongInt): Integer;      virtual; abstract;
  //
  // 43   -       Chr   Str.
  //         Nil,      .
  //
  function  StrScan(Str: PChar; Chr: Char): PChar;                       virtual; abstract;
  //
  // 44   -       Chr   Str.
  //         Nil,      .
  //
  function  StrRScan(Str: PChar; Chr: Char): PChar;                      virtual; abstract;
  //
  // 45   -   Str      Str.
  //
  function  StrUpper(Str: PChar): PChar;                                 virtual; abstract;
  //
  // 46   -   Str      Str.
  //
  function  StrLower(Str: PChar): PChar;                                 virtual; abstract;
  //
  // 47   -       Str2   Str1.
  //         NIL,       .
  //
  function  StrPos(Str1, Str2: PChar): PChar;                            virtual; abstract;
  //
  // 48   -   Str     Pascal-.
  //
  function  StrPas(Str: PChar): ShortString;                             virtual; abstract;
  //
  // 49   -   ,    PassChars.
  //            ,    PassChars.
  //
  function  StrPass(Str:PChar; const PassChars:TCharSet):PChar;          virtual; abstract;
  //
  // 50   -    Count   Source  Dest   Dest.
  //        Source  Dest  .
  //
  function  StrMove(Dest, Source: PChar; Count: LongInt): PChar;         virtual; abstract;
  //
  // 51   -    ,     CRLF  1.
  //        Count     . UnixStyle  
  //        CR  CRLF.
  //
  function  GetTextNumLines(Text:PChar; Count:LongInt=MaxLongInt;
                            UnixStyle:boolean=false):LongInt;            virtual; abstract;
  //
  // 52   -    .
  //
  function  UpCase(c:Char):Char;                                         virtual; abstract;
  //
  // 53   -    .
  //
  function  LoCase(c:Char):Char;                                         virtual; abstract;
  //
  // 54   -    .
  //
  function  LoCaseStr(const S:ShortString):ShortString;                  virtual; abstract;
  //
  // 55   -    .
  //
  function  UpCaseStr(const S:ShortString):ShortString;                  virtual; abstract;
  //
  // 56   -   Windows(1251)   Dos(866).
  //
  function  WinToDos(c:Char):Char;                                       virtual; abstract;
  //
  // 57   -   Dos   Windows.
  //
  function  DosToWin(c:Char):Char;                                       virtual; abstract;
  //
  // 58   -   Windows   Dos.
  //
  function  WinToDosStr(const S:ShortString):ShortString;                virtual; abstract;
  //
  // 59   -   Dos   Windows.
  //
  function  DosToWinStr(const S:ShortString):ShortString;                virtual; abstract;
  //
  // 60   -   Windows   Dos.
  //
  function  WinToDosLongStr(const S:LongString):LongString;              virtual; abstract;
  //
  // 61   -   Dos   Windows.
  //
  function  DosToWinLongStr(const S:LongString):LongString;              virtual; abstract;
  //
  // 62   -   Windows   KOI-8.
  //
  function  WinToKoi(c:Char):Char;                                       virtual; abstract;
  //
  // 63   -   KOI-8   Windows.
  //
  function  KoiToWin(c:Char):Char;                                       virtual; abstract;
  //
  // 64   -   Windows   KOI-8.
  //
  function  WinToKoiStr(const S:ShortString):ShortString;                virtual; abstract;
  //
  // 65   -   KOI-8   Windows.
  //
  function  KoiToWinStr(const S:ShortString):ShortString;                virtual; abstract;
  //
  // 66   -   Windows   KOI-8.
  //
  function  WinToKoiLongStr(const S:LongString):LongString;              virtual; abstract;
  //
  // 67   -   KOI-8   Windows.
  //
  function  KoiToWinLongStr(const S:LongString):LongString;              virtual; abstract;
  //
  // 68   -    Format.
  //
  function  Format(const Fmt:LongString;
                   const Args: array of const):LongString;               virtual; abstract;
  //
  // 69   -   ,    S.
  //
  function  Str2CharSet(const S:ShortString):TCharSet;                   virtual; abstract;
  //
  // 70   -    ,    S.
  //
  function  CharSet2Str(const S:TCharSet):ShortString;                   virtual; abstract;
  //
  // 71   -    S  pos..length(S).
  //
  function  RightStr(const S:ShortString; pos:integer):ShortString;      virtual; abstract;
  //
  // 72   -     1..count.
  //
  function  LeftStr(const S:ShortString; count:integer):ShortString;     virtual; abstract;
  //
  // 73   -    len,   ch.
  //
  function  CharStr(Len:Byte; Ch:Char=' '):ShortString;                  virtual; abstract;
  //
  // 74   -   S,     len  ch.
  //
  function  Pad(const S:ShortString; Len:Byte; Ch:Char=' '):ShortString; virtual; abstract;
  //
  // 75   -   S,     len  ch.
  //
  function  LeftPad(const S:ShortString; Len:Byte;
                    Ch:Char=' '):ShortString;                            virtual; abstract;
  //
  // 76   -   S,       
  //        Width  Ch,       .
  //
  function  CenterStr(const S:ShortString; Width:Byte;
                      Ch:Char=' '):ShortString;                          virtual; abstract;
  //
  // 77   -       . TrimChars ,
  //          .
  //
  function  TrimLeadChars(const S:ShortString;
                          const TrimChars:TCharSet):ShortString;         virtual; abstract;
  //
  // 78   -       . TrimChars ,
  //          .
  //
  function  TrimTrailChars(const S:ShortString;
                           const TrimChars:TCharSet):ShortString;        virtual; abstract;
  //
  // 79   -          .
  //        LeadTrim,TrailTrim ,   .
  //
  function  TrimChars(const S:ShortString;
                      const LeadTrim,TrailTrim:TCharSet):ShortString;    virtual; abstract;
  //
  // 80   -       .
  //           [#0..' '].
  //
  function  TrimLead(const S:ShortString):ShortString;                   virtual; abstract;
  //
  // 81   -       .
  //           [#0..' '].
  //
  function  TrimTrail(const S:ShortString):ShortString;                  virtual; abstract;
  //
  // 82   -         .
  //           [#0..' '].
  //
  function  Trim(const S:ShortString):ShortString;                       virtual; abstract;
  //
  // 83   -      ,  
  //         . ,  " one "  "One" ,  
  //          .     "ONE".
  //               - .
  //          - UpcaseStr(Trim(Name)).
  //
  function  UnifyAlias(const Name:ShortString):ShortString;              virtual; abstract;
  //
  // 84   -      , 
  //             .   
  //             ,   ,
  //            . ,  
  //        "c:\daq\1110\config\1110.cfg"  "C:\DAQ\1110\DATA\..\CONFIG\1110.CFG"
  //        ,     . 
  //           "C:\DAQ\1110\CONFIG\1110.CFG".
  //         ,     Unix    -  
  //           .
  //          - UpcaseStr(Trim(FExpand(Name))).
  //
  function  UnifyFileAlias(const FileName:ShortString):ShortString;      virtual; abstract;
  //
  // 85   -       .
  //        ,  'Section', '[Section', 'Section]', '[Section]'
  //           '[SECTION]'.
  //
  function UnifySection(const aSectionName:ShortString):ShortString;     virtual; abstract;
  //
  // 86   -    InSt,      Margin,
  //          OutSt,     Overlap.
  //
  procedure WordWrap(const InSt:ShortString; var OutSt, Overlap:ShortString;
                     Margin:Byte; PadToMargin:Boolean);                  virtual; abstract;
  //
  // 87   -    Str    Find   Replace.
  //
  function ReplaceString(const Str,Find,Replace:ShortString):ShortString;virtual; abstract;
  //
  // 88   -     ^L,^R,^C,^N,^B  
  //        '^L','^R','^C','^N','^B'  .  :
  //        ^L -    
  //        ^R -    
  //        ^C -   
  //        ^N -    
  //
  function ReplaceAlignStr(const Str:ShortString;
                           Invert:Boolean):ShortString;                  virtual; abstract;
  //
  // 89   -    S  ,   WordDelims.
  //
  function  WordCount(const S:ShortString;
                      const WordDelims:TCharSet):Byte;                   virtual; abstract;
  //
  // 90   -    S   N.    WordDelims.
  //
  function  ExtractWord(N:Byte; const S:ShortString;
                                const WordDelims:TCharSet):ShortString;  virtual; abstract;
  //
  // 91   -     Name   , 
  //         Str.    WordDelims.
  //         ,    .
  //
  function  WordIndex(const Name,Str:ShortString;
                      const Delims:TCharSet):Byte;                       virtual; abstract;
  //
  // 92   -  ,        .
  //
  function  ExtractInt(N:Byte; const S:ShortString; const WordDelims:TCharSet;
                               var Value:LongInt):boolean;               virtual; abstract;
  //
  // 93   -  ,        .
  //
  function  ExtractReal(N:Byte; const S:ShortString; const WordDelims:TCharSet;
                                var Value:Double):boolean;               virtual; abstract;
  //
  // 94   -        .
  //
  function  BinB(x:Byte):ShortString;                                    virtual; abstract;
  //
  // 95   -        .
  //
  function  BinW(x:Word):ShortString;                                    virtual; abstract;
  //
  // 96   -         .
  //
  function  BinL(x:LongWord):ShortString;                                virtual; abstract;
  //
  // 97   -        .
  //
  function  OctB(x:Byte):ShortString;                                    virtual; abstract;
  //
  // 98   -        .
  //
  function  OctW(x:Word):ShortString;                                    virtual; abstract;
  //
  // 99   -         .
  //
  function  OctL(x:LongInt):ShortString;                                 virtual; abstract;
  //
  // 100  -        .
  //
  function  HexB(x:Byte):ShortString;                                    virtual; abstract;
  //
  // 101  -        .
  //
  function  HexW(x:Word):ShortString;                                    virtual; abstract;
  //
  // 102  -         .
  //
  function  HexL(x:LongWord):ShortString;                                virtual; abstract;
  //
  // 103  -     .
  //
  function  Long2Str(L:LongInt):ShortString;                             virtual; abstract;
  //
  // 104  -        .
  //
  function  Real2Str(R:Double; Width:Integer=0;
                     Places:Integer=0):ShortString;                      virtual; abstract;
  //
  // 105  -     .
  //
  function  d2s(d:LongInt; Width:Integer=0):ShortString;                 virtual; abstract;
  //
  // 106  -        .
  //           f2sFormat.
  //
  function  f2s(f:Double):ShortString;                                   virtual; abstract;
  //
  // 107  -     f2s -     .
  //
  procedure f2sFormat(Width:Integer=0; Decimals:Integer=14);             virtual; abstract;
  //
  // 108  -     f2s.
  //
  procedure f2sFormatOld;                                                virtual; abstract;
  //
  // 109  -        .
  //         Format('%w.dg',[X]).
  //
  function  FormatG(X:Double; w:integer; d:integer):ShortString;         virtual; abstract;
  //
  // 110  -   "a"    "i".
  //            "$",   .
  //
  function  atoi(a:PChar; var i:LongInt):boolean;                        virtual; abstract;
  //
  // 111  -   "a"    "f".
  //            "$",    .
  //
  function  atof(a:PChar; var f:double):boolean;                         virtual; abstract;
  //
  // 112  -     .
  //
  function  Str2Int(const S:ShortString; var I:Integer):Boolean;         virtual; abstract;
  //
  // 113  -     .
  //
  function  Str2Word(const S:ShortString; var I:Word):Boolean;           virtual; abstract;
  //
  // 114  -     .
  //
  function  Str2Long(const S:ShortString; var I:LongInt):Boolean;        virtual; abstract;
  //
  // 115  -     .
  //
  function  Str2Real(const S:ShortString; var R:Double):Boolean;         virtual; abstract;
  //
  // 116  -     .
  //         ,     
  //           .      .
  //
  function SmartStr2Real(const S:ShortString; var R:Double):Boolean;     virtual; abstract;
  //
  // 117  -        .
  //
  function  StrBin2Long(const S:ShortString; var L:LongInt):Boolean;     virtual; abstract;
  //
  // 118  -        .
  //
  function  StrOct2Long(const S:ShortString; var L:LongInt):Boolean;     virtual; abstract;
  //
  // 119  -        .
  //
  function  StrHex2Long(const S:ShortString; var L:LongInt):Boolean;     virtual; abstract;
  //
  // 120  -       .
  //           ,  CR  ; 
  //        prefix1%format1+CR+
  //        prefix2%format2+CR+
  //        ....
  //        prefixN%formatN
  //        -     ( )
  //              :
  //        %s -  ShortString(Data)     CR   ,
  //                255 
  //        %a -  ShortString(Data)     ,
  //             ,    (ScanSpaces),    255 
  //        %d -  LongInt(Data)    
  //        %w -  Word
  //        %i -  Integer
  //        %b -  Boolean (0,1,False,True,Yes,No-  )
  //        %f -  Double(Data)    
  //        %c -  Char(Data)   
  //        ScanVar       
  //            nil  :
  //                (     )
  //                %s,%f,%d,%c,%a,%w,%i,%b
  //           
  //        :
  //         var
  //          Data:record S:ShortString; D:LongInt; F:Double; C:Char end;
  //         const
  //          InputStr=' Var1=C'+CR+
  //                   '      Var2= 100'+CR+
  //                   '      Var3= -3.14'+CR+
  //                   '      Var4=&';
  //          begin
  //           if ScanVar(svAsIs,InputStr,'Var1=%s'+CR+
  //                                      'Var2=%d'+CR+
  //                                      'Var3=%f'+CR+
  //                                      'Var4=%c',Data)=nil then error;
  //         :
  //          Data.S='';
  //          Data.D=100;
  //          Data.F:=-3.14;
  //          Data.C='&';
  //             
  //        svUpCase/svLoCase
  //             /      
  //             ,     
  //            . :
  //          S=StrUpper('SomeVar=1000')
  //          ScanVar(svUpCase,S,'somevar%d'...    - 
  //          ScanVar(svNoCase,S,'somevar%d'...    -  ,  
  //        svLSpace/svRSpace
  //            /   , 
  //                .
  //         ,  
  //          S='Var10 = 1, Var1 = 10'
  //          Var1 -    , 
  //          ScanVar(0,S,'Var1%s'...  0,     
  //            Var1   Var10
  //          ScanVar(svRSpace+svLSpace  ,    
  //            Var1 (        )
  //               S='Sin(10)'  
  //         ScanVar(0,'Sin(%f'... ,   ScanVar(svRSpace,'Sin(%f'...
  //                 
  //        svOrigin
  //               ,   
  //             , 
  //          S='Var2 = 1, Var1 = 2', 
  //              ScanVar(0,'Var1%d;Var2%d' -     Var1 -  Var2
  //              ScanVar(svOrigin,'Var1%d;Var2%d'- 
  //                svOrigin  , 
  //          S='Var = 1 , 2, 3, 4',    ScanVar(0,'Var%w;,%w;,%w;,%w
  //             ScanVar(svOrigin,....  3, 4  
  //         2, 2 -      
  //         ,           
  //              ScanVar(0,'Var%w;%w;%w;%w'....
  //
  function  ScanVar(svMode:word; Str:PChar;
                    const Format:ShortString; var Data):PChar;           virtual; abstract;
  //
  // 121  - ,    S    .
  //
  function  IsEmptyStr(const S:ShortString):boolean;                     virtual; abstract;
  //
  // 122  -      -   
  //         Delimiters   S.  ,    
  //         - .
  //
  function  LastDelimiter(const Delimiters:TCharSet;
                          const S:ShortString):Integer;                  virtual; abstract;
  //
  // 123  -     DirName    
  //          "\"   ,   .  
  //           Windows.
  //
  function  AddBackSlash(const DirName:ShortString):ShortString;         virtual; abstract;
  //
  // 124  -      ,    
  //          .     .
  //
  function  DropBackSlash(const DirName:ShortString):ShortString;        virtual; abstract;
  //
  // 125  - ,      ,  "*.*"  "?.?".
  //
  function  IsWildCard(const FileName:ShortString):boolean;              virtual; abstract;
  //
  // 126  - ,       .
  //              ,  
  //           -  , ,
  //        ".\doc\readme.txt".
  //
  function  IsRelativePath(const S:ShortString):boolean;                 virtual; abstract;
  //
  // 127  -          ,
  //           ,    .
  //
  function  HasExtension(const Name:ShortString;
                         var DotPos:Integer):Boolean;                    virtual; abstract;
  //
  // 128  -       , 
  //           .    ,   
  //         .      .
  //
  function  DefaultExtension(const Name,Ext:ShortString):ShortString;    virtual; abstract;
  //
  // 129  -      ,    
  //          .     .
  //             .
  //
  function  DefaultPath(const Name,Path:ShortString):ShortString;        virtual; abstract;
  //
  // 130  -    .      , 
  //          .
  //
  function  ForceExtension(const Name,Ext:ShortString):ShortString;      virtual; abstract;
  //
  // 131  -    .      ,    .
  //
  function  ForcePath(const NewPath,Name:ShortString):ShortString;       virtual; abstract;
  //
  // 132  -     ,    .
  //
  function  ExtractFileNameExt(const FileName: ShortString):ShortString; virtual; abstract;
  //
  // 133  -       ,    .
  //
  function  ExtractFileName(const FileName: ShortString):ShortString;    virtual; abstract;
  //
  // 134  -      ,  .
  //
  function  ExtractFileExt(const FileName: ShortString): ShortString;    virtual; abstract;
  //
  // 135  -      ,    .
  //              .
  //
  function  ExtractFilePath(const FileName: ShortString): ShortString;   virtual; abstract;
  //
  // 136  -           .
  //
  function  ExtractFileDrive(FileName: ShortString): ShortString;        virtual; abstract;
  //
  // 137  -      ,   
  //        Delphi: 'Text files | *.txt | Data files | *.dat |'.
  //
  function  ExtractFilterExt(const Filter:LongString;
                             Index:Integer):ShortString;                 virtual; abstract;
  //
  // 138  -      ,   
  //        .      .
  //           ,   .
  //
  function  FExpand(const Path:ShortString):ShortString;                 virtual; abstract;
  //
  // 139  -    Path    , 
  //            Base.
  //
  function  MakeRelativePath(const Path,Base:ShortString):ShortString;   virtual; abstract;
  //
  // 140  -    Rus   Eng   
  //        ,     .
  //
  function  RusEng(const Rus:LongString='';
                   const Eng:LongString=''):LongString;                  virtual; abstract;
  //
  // 141  -     Windows   GetLastError.
  //
  function  SysErrorMessage(ErrorCode: Integer): ShortString;            virtual; abstract;
  //
  // 142  -      FileName.
  //         -1,     ,    
  //          (*,?),     .
  //
  function  GetFileAttr(const FileName:ShortString):Integer;             virtual; abstract;
  //
  // 143  -      FileName.
  //         false,     ,    
  //          (*,?),     .
  //
  function  SetFileAttr(const FileName: ShortString;
                        Attr: Integer):boolean;                          virtual; abstract;
  //
  // 144  -     -1,      .
  //
  function  GetFileSize(const FileName:ShortString):LongInt;             virtual; abstract;
  //
  // 145  -       -1,    .
  //               ,
  //         ConvertToMSec=true.      ,
  //            FileDateToDateTime.
  //
  function  GetFileDate(const FileName:ShortString;
                        ConvertToMsec:Boolean=false):Int64;              virtual; abstract;
  //
  // 146  -  true,      .
  //        FilePattern      , 
  //         ,  "*.*".
  //
  function  FileExists(const FilePattern:ShortString;
                       Attribut:Integer=faAnyFile):Boolean;              virtual; abstract;
  //
  // 147  - ,    .
  //              .
  //
  function  DirExists(const DirName: ShortString): Boolean;              virtual; abstract;
  //
  // 148  -  .  true,      
  //           .
  //
  function  FileErase(const FileName:ShortString;
                      CheckExistance:boolean=true):boolean;              virtual; abstract;
  //
  // 149  -   CopyFrom   CopyTo.
  //         false   -,   CopyFrom,
  //             CopyTo   FailIfExists=true.
  //
  function  FileCopy(const CopyFrom,CopyTo:ShortString;
                     FailIfExists:boolean=false):boolean;                virtual; abstract;
  //
  // 150  -  OldFileName   NewFileName.
  //         false   -,   OldFileName,
  //             NewFileName   FailIfExists=true.
  //
  function  FileRename(const OldFileName,NewFileName:ShortString;
                       FailIfExists:boolean=false):boolean;              virtual; abstract;
  //
  // 151  -        .
  //
  function  GetCurrDir: ShortString;                                     virtual; abstract;
  //
  // 152  -   .       .
  //
  function  SetCurrDir(const DirName: ShortString): Boolean;             virtual; abstract;
  //
  // 153  -         
  //         DirName.     ,  
  //        .  true,      
  //        .
  //
  function  MkDir(const DirName: ShortString): Boolean;                  virtual; abstract;
  //
  // 154  -   DirName.    .
  //         false,       .
  function  RmDir(const DirName: ShortString): Boolean;                  virtual; abstract;
  //
  // 155  -   FileName,   Offset    ,
  //         Count   Buffer.
  //             -1  .
  //
  function  ReadFileToBuffer(const FileName : ShortString;
                                   Buffer   : Pointer;
                                   Count    : LongInt;
                                   Offset   : LongInt = 0 ):LongInt;     virtual; abstract;
  //
  // 156  -    FileName,   Offset   
  //        ,  Count   Buffer.
  //             -1  .
  //        FLAGS   OPEN_EXISTING, OPEN_ALWAYS, CREATE_NEW, CREATE_ALWAYS
  //
  function  WriteBufferToFile(const FileName     : ShortString;
                                    Buffer       : Pointer;
                                    Count        : LongInt;
                                    Offset       : LongInt = 0;
                                    FLAGS        : DWORD = OPEN_ALWAYS
                                               ) : LongInt;              virtual; abstract;
  //
  // 157  -   .   ,  
  //         FilePatterns,    RootDir,  
  //        FileAction,       ,
  //              
  //        MaxSubDirLevels.  CustomData     
  //        FileAction  . FilePatterns  
  //               , ,
  //        "*.bmp, config.*, *.wav". Delimiters   ,
  //             FilePatterns.
  //        
  procedure ForEachFile(const RootDir         : ShortString;
                        const FilePatterns    : ShortString;
                              FileAction      : TForEachFileAction;
                              MaxSubDirLevels : Integer = 0;
                              CustomData      : Pointer = nil;
                        const Delimiters      : TCharSet = [' ',';',',',Tab,CR,LF]
                                             );                          virtual; abstract;
  //
  // 158  -     .    
  //         FileName   Action.  0,   
  //        , -1      IOResult  .
  //
  function  ForEachTextLine(const FileName   : ShortString;
                                  Action     : TForEachTextLineAction;
                                  CustomData : Pointer = nil
                                           ) : Integer;                  virtual; abstract;
  //
  // 159  -   S     n.   n 
  //          DebugOutOpenFile.    , 
  //         .      
  //        ,      .
  //
  procedure DebugOut(n:byte; const S:ShortString);                       virtual; abstract;
  //
  // 160  -      n.
  //          ,      .
  //
  function  DebugOutGetFile(n:byte):ShortString;                         virtual; abstract;
  //
  // 161  -  0   OK,      
  //         n  -1     .
  //
  function  DebugOutGetErrors(n:byte):Int64;                             virtual; abstract;
  //
  // 162  -     n.    
  //          FIFO,        .
  //        FlushPeriod -   FIFO    .
  //              DebugOutOpenFile
  //            FileName.
  //
  procedure DebugOutOpenFile(n           : byte;
                       const FileName    : ShortString;
                             FifoSize    : Integer = 1024*64;
                             FlushPeriod : Integer = 50;
                             CreateNew   : boolean = true;
                             Hello       : boolean = false);             virtual; abstract;
  //
  // 163  -    [SectionName]  ini- FileName.
  //         ExtractSectionFlags     .
  //           efAsIs  efConfig.
  //
  function  ExtractTextSection(const FileName            : ShortString;
                               const SectionName         : ShortString;
                                     ExtractSectionFlags : Word
                                                       ) : LongString;   virtual; abstract;
  //
  // 164  -       WordIndex  
  //        [SectionName]  ini- FileName.
  //
  //
  function  ExtractWordList(const FileName            : ShortString;
                            const SectionName         : ShortString;
                                  ExtractSectionFlags : word;
                                  WordIndex           : word;
                            const Delimiters          : TCharSet
                                                    ) : LongString;      virtual; abstract;
  //
  // 165  -    [SectionName]  ini- FileName  
  //          "Prefix = var1, var2, ..".
  //
  function  ExtractEnumWordList(const IniFile             : ShortString;
                                const SectionName         : ShortString;
                                const Prefix              : ShortString;
                                      ExtractSectionFlags : word
                                                        ) : LongString;  virtual; abstract;
  //
  // 166  -    ini-. FileName,SectionName  
  //          . Format    -  
  //         'Name%x',   CR  ";".  Name - 
  //        , %x - ,    
  //         %b - Boolean,
  //         %f - Double,
  //         %d - LongInt,
  //         %w - Word,
  //         %i - Integer,
  //         %s - ShortString,      ,
  //         %a - ShortString,  ,   .
  //          Data    (packed) 
  //            . ,   
  //         [Person]
  //         Age = 34
  //         Height = 182.5
  //         User = Alex, Physics department
  //         :
  //         var Person : packed record
  //              Age:Integer; Height:Double; Name,Comment:ShortString;
  //             end;
  //         if ReadIniFileVariable(File,'[Person]','Age%i;Height%f;User%a;%s',Data)
  //         then ... Data.Age=34, Data.Height=182.5, Data.Name='ALEX', Data.Comment='PHYSICS DEPARTMENT'
  //         :
  //         1)        $F123.
  //         2)      .   
  //            ,   ExtractTextSection  ScanVar.
  //
  function ReadIniFileVariable(const FileName    : ShortString;
                               const SectionName : ShortString;
                               const Format      : ShortString;
                                 var Data      ) : Boolean;              virtual; abstract;
  //
  // 167  -     ini-.    (
  //        )  .       ,
  //              StartupPath.
  //
  function ReadIniFilePath(const FileName    : ShortString;
                           const SectionName : ShortString;
                           const Name        : ShortString;
                           const StartupPath : ShortString;
                             var Path        : ShortString ) : Boolean;  virtual; abstract;
  //
  // 168  -    EXE-   .
  //
  function  ProgName:ShortString;                                        virtual; abstract;
  //
  // 169  -   ,   ,   EXE-
  //         .      
  //           .
  //
  function  HomeDir:ShortString;                                         virtual; abstract;
  //
  // 170  -   ,  HomeDir.
  //
  function  StartupPath:ShortString;                                     virtual; abstract;
  //
  // 171  -      .   
  //            .
  //
  function  StartAtDir:ShortString;                                      virtual; abstract;
  //
  // 172  -  ini- ,      
  //          .      .EXE
  //             .INI.
  //
  function  SysIniFile:ShortString;                                      virtual; abstract;
  //
  // 173  -     .
  //
  procedure GoHome;                                                      virtual; abstract;
  //
  // 174  - ,   Windows, ,  C:\Windows.
  //
  function  WindowsDir:ShortString;                                      virtual; abstract;
  //
  // 175  -    Windows, , C:\Windows\System32.
  //
  function  WindowsSystemDir:ShortString;                                virtual; abstract;
  //
  // 176  -    Windows.
  //
  function  WindowsTempDir:ShortString;                                  virtual; abstract;
  //
  // 177  -    .   SysIniFile,
  //          [System],  TempDir.
  //
  function  TempDir:ShortString;                                         virtual; abstract;
  //
  // 178  -    ,    
  //            .    ###NNNN.TMP, 
  //        ### -  , NNNN -  , .TMP - 
  //        .
  //
  function  CreateTempFile(const Template:ShortString='###.TMP'):ShortString;
                                                                         virtual; abstract;
  //
  // 179  -   -  Name   Key   Windows.
  //        RootKey  , , HKEY_CURRENT_USER.
  //
  function  ReadRegistryString(RootKey:HKEY;
                               const Key,Name:ShortString):ShortString;  virtual; abstract;
  //
  // 180  -   -  Name    Windows,
  //         HKEY_CURRENT_USER,
  //         'Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders'
  //
  function  GetWindowsShellFolder(const Name:ShortString):ShortString;   virtual; abstract;
  //
  // 181  -   " "    Windows.
  //
  function  GetWindowsShellDesktop:ShortString;                          virtual; abstract;
  //
  // 182  -   ""    Windows.
  //
  function  GetWindowsShellPrograms:ShortString;                         virtual; abstract;
  //
  // 183  -   "\"    Windows.
  //
  function  GetWindowsShellStartup:ShortString;                          virtual; abstract;
  //
  // 184  -   ""    Windows.
  //
  function  GetWindowsShellStartMenu:ShortString;                        virtual; abstract;
  //
  // 185  -   ""    Windows.
  //
  function  GetWindowsShellFavorites:ShortString;                        virtual; abstract;
  //
  // 186  -    Windows.
  //
  function  GetWindowsShellFonts:ShortString;                            virtual; abstract;
  //
  // 187  -   ""   Windows.
  //
  function  GetWindowsShellHistory:ShortString;                          virtual; abstract;
  //
  // 188  -   " "    Windows.
  //
  function  GetWindowsShellPersonal:ShortString;                         virtual; abstract;
  //
  // 189  -   "Send To"    Windows.
  //
  function  GetWindowsShellSendTo:ShortString;                           virtual; abstract;
  //
  // 190  -     LinkPath,     ObjectPath.
  //        Description     .
  //        Params    ,  .
  //
  procedure CreateFileLink(const ObjectPath, LinkPath, Description,
                           Params: ShortString);                         virtual; abstract;
  //
  // 191  -   .
  //
  function  Point2I(x,y:Integer):TPoint2I;                               virtual; abstract;
  //
  // 192  -   .
  //
  function  Point2D(x,y:Double):TPoint2D;                                virtual; abstract;
  //
  // 193  -    .
  //
  function  Point3D(x,y,z:Double):TPoint3D;                              virtual; abstract;
  //
  // 194  -   .
  //
  function  Rect2I(const a,b:TPoint2I):TRect2I;                          virtual; abstract;
  //
  // 195  -    .
  //
  function  Rect2D(const a,b:TPoint2D):TRect2D;                          virtual; abstract;
  //
  // 196  - ,     .
  //
  function  IsEqualPoint2I(const p1,p2:TPoint2I):Boolean;                virtual; abstract;
  //
  // 197  - ,     .
  //
  function  IsEqualPoint2D(const p1,p2:TPoint2D; AbsEps:Double=0;
                           RelEps:Double=1E-14):Boolean;                 virtual; abstract;
  //
  // 198  - ,     .
  //
  function  IsEqualRect2I(const r1,r2:TRect2I):Boolean;                  virtual; abstract;
  //
  // 199  - ,     .
  //
  function  IsEqualRect2D(const r1,r2:TRect2D; AbsEps:Double=0;
                          RelEps:Double=1E-14):Boolean;                  virtual; abstract;
  //
  // 200  - ,     .
  //
  function  IsEmptyRect2I(const r:TRect2I):Boolean;                      virtual; abstract;
  //
  // 201  - ,     .
  //
  function  IsEmptyRect2D(const r:TRect2D; AbsEps:Double=0;
                          RelEps:Double=1E-14):Boolean;                  virtual; abstract;
  //
  // 202  - ,      .
  //
  function  Rect2IContainsPoint(const r:TRect2I;
                                const p:TPoint2I):Boolean;               virtual; abstract;
  //
  // 203  - ,      .
  //
  function  Rect2DContainsPoint(const r:TRect2D;
                                const p:TPoint2D):Boolean;               virtual; abstract;
  //
  // 204  -    .
  //
  function  Rect2IIntersection(const R1,R2:TRect2I):TRect2I;             virtual; abstract;
  //
  // 205  -    .
  //
  function  Rect2DIntersection(const R1,R2:TRect2D):TRect2D;             virtual; abstract;
  //
  // 206  -    .
  //
  function  Rect2IUnion(const R1,R2:TRect2I):TRect2I;                    virtual; abstract;
  //
  // 207  -    .
  //
  function  Rect2DUnion(const R1,R2:TRect2D):TRect2D;                    virtual; abstract;
  //
  // 208  -   ,   " ".
  //           a.x  b.x  a.x > b.x;  a.y  b.y  a.y > b.y.
  //
  function  Rect2IValidate(const r:TRect2I):TRect2I;                     virtual; abstract;
  //
  // 209  -   ,   " ".
  //           a.x  b.x  a.x > b.x;  a.y  b.y  a.y > b.y.
  //
  function  Rect2DValidate(const r:TRect2D):TRect2D;                     virtual; abstract;
  //
  // 210  -   .
  //
  procedure Point2IMove(var p:TPoint2I; dx,dy:Integer);                  virtual; abstract;
  //
  // 211  -   .
  //
  procedure Point2DMove(var p:TPoint2D; dx,dy:Double);                   virtual; abstract;
  //
  // 212  -   .
  //
  procedure Rect2IMove(var r:TRect2I; dx,dy:Integer);                    virtual; abstract;
  //
  // 213  -   .
  //
  procedure Rect2DMove(var r:TRect2D; dx,dy:Double);                     virtual; abstract;
  //
  // 214  -   .
  //
  procedure Point2IMult(var p:TPoint2I; mx,my:Integer);                  virtual; abstract;
  //
  // 215  -   .
  //
  procedure Point2DMult(var p:TPoint2D; mx,my:Double);                   virtual; abstract;
  //
  // 216  -   .
  //
  procedure Rect2IMult(var r:TRect2I; mx,my:Integer);                    virtual; abstract;
  //
  // 217  -   .
  //
  procedure Rect2DMult(var r:TRect2D; mx,my:Double);                     virtual; abstract;
  //
  // 218  -    .
  //
  procedure Rect2IGrow(var r:TRect2I; dx,dy:Integer);                    virtual; abstract;
  //
  // 219  -    .
  //
  procedure Rect2DGrow(var r:TRect2D; dx,dy:double);                     virtual; abstract;
  //
  // 220  -    .
  //
  function  Rect2ISize(const r:TRect2I):TPoint2I;                        virtual; abstract;
  //
  // 221  -    .
  //
  function  Rect2DSize(const r:TRect2D):TPoint2D;                        virtual; abstract;
  //
  // 222  -    .
  //
  function  Rect2ICenter(const r:TRect2I):TPoint2I;                      virtual; abstract;
  //
  // 223  -    .
  //
  function  Rect2DCenter(const r:TRect2D):TPoint2D;                      virtual; abstract;
  //
  // 224  -    .
  //             .
  //
  function  CreateScriptInterpreter:TScriptInterpreter;                  virtual; abstract;
  //
  // 225  -  1 SHL BitNumber,   ,    
  //           0.
  //
  function  GetBitMask(BitNumber:Integer):Integer;                       virtual; abstract;
  //
  // 226  -    ,     
  //        ,        .
  //
  function  Precision(AbsEps,RelEps,Value:Double):Double;                virtual; abstract;
  //
  // 227  -    ,   
  //          Single. 16.777.216 <-> 24 bit
  //
  function  MaxIntSingle:Single;                                         virtual; abstract;
  //
  // 228  -    ,   
  //          Double. 9.007.199.254.740.992 <-> 53 bit
  //
  function  MaxIntDouble:Double;                                         virtual; abstract;
  //
  // 229  -    ,   
  //          Extended. 18.446.744.073.709.551.600 <-> 64 bit
  //
  function  MaxIntExtended:Extended;                                     virtual; abstract;
  //
  // 230  -   .     2:
  //        fscale(X,N) = X * 2 ^ N
  //
  function  fscale(X:Extended; N:integer): Extended;                     virtual; abstract;
  //
  // 231  -      X.
  //        X = Mantissa * 2 ^ Exponent, 1<=abs(Mantissa)<2
  //
  procedure fxtract(X: Extended; var Mantissa: Extended;
                                 var Exponent: Integer);                 virtual; abstract;
  //
  // 232  -  ,     ,    
  //         NumberOfSignificantBits   .
  //
  function  fbitcompress(Argument:Extended;
                         NumberOfSignificantBits:integer):Extended;      virtual; abstract;
  //
  // 233  -  ,     ,   
  //             , 
  //        1/ScaleFactor.
  //
  function  frelcompress(Arument,ScaleFactor:Extended):Extended;         virtual; abstract;
  //
  // 234  -  ,     ,   
  //             , 
  //        1/ScaleFactor.
  //
  function  fabscompress(Argument,ScaleFactor:Extended):Extended;        virtual; abstract;
  //
  // 235  -   - .    gamma(n+1) = n!
  //
  function  Gamma(x:Extended):Extended;                                  virtual; abstract;
  //
  // 236  -    -.
  //
  function  GammaLn(x:Extended):Extended;                                virtual; abstract;
  //
  // 237  -    - .
  //
  function  GammaInc(x,a:Extended):Extended;                             virtual; abstract;
  //
  // 238  -     .
  //
  function  GammaDistr(x,a,b:Extended):Extended;                         virtual; abstract;
  //
  // 239  -     - .
  //
  function  GammaCumDistr(x,a,b:Extended):Extended;                      virtual; abstract;
  //
  // 240  -     -.
  //
  function  GammaCumDistrInv(p,a,b:Extended):Extended;                   virtual; abstract;
  //
  // 241  -    -  v  .
  //
  function  Chi2Distr(x,v:Extended):Extended;                            virtual; abstract;
  //
  // 242  -    -  v  .
  //
  function  Chi2CumDistr(x,v:Extended):Extended;                         virtual; abstract;
  //
  // 243  -     -  v  .
  //
  function  Chi2CumDistrInv(p,v:Extended):Extended;                      virtual; abstract;
  //
  // 244  -      (x1,y1)-(x2,y2).
  //            , .
  //
  function  Trapezium(x1,y1,x2,y2:double):double;                        virtual; abstract;
  //
  // 245  -        N.
  //
  function  BesselN(N:integer; X:Double;Modify:boolean=false):Double;    virtual; abstract;
  //
  // 246  -      A*X=Y  N*N
  //              .
  //         A    ,    
  //          :
  //          A[i,j] <-> A[i*M+j], i,j=0..N-1
  //             A     
  //          M, :
  //         const N=3; M=5;
  //         var A:array[0..M-1,0..M-1] of double; X,Y:array[0..M-1] of double;
  //         if GaussSolverWithPartialPivoting(N,M,A[0,0],X[0],Y[0])=0 then ...
  //         Eps      ,
  //            .
  //          0 - Ok.
  //                            1 -   N  M.
  //                            2 -  ,   <= Eps.
  //
  function  GaussSolverWithPartialPivoting(N,M:Integer; var A,X,Y:array of Double;
                                           Eps:Double=1E-14):Integer;    virtual; abstract;
  //
  // 247  -       
  //         .
  //
  function  CreatePolynom(aPower  : Integer = 1;
                          aCenter : Double  = 0;
                          aScale  : Double  = 1):TPolynomWrap;           virtual; abstract;
  //
  // 248  -      .
  //        Problem= , Report= , n=,
  //        x[n]=, f=, g[n]=, Custom= , Count= ,
  //        MaxCount=   , Method=  0..8, tolx,tolf,tolg=  x,f,g,
  //        inf= , Size= , Step= , EvalTol=  ,
  //        v[]=    (n+9)*nv, nv>n, nv=  ,nv>=n+1.
  //
  function  GenMin(Problem:TMinProblem; Report:TMinReport; n:Integer; var x:array of Double;
                  var f:Double; var g:array of Double; Custom:Pointer; var Count:Integer;
                  MaxCount:Integer; Method:Integer; tolx,tolf,tolg,inf,Size,Step,EvalTol:Double;
                  var v:array of Double; nv:Integer):Integer;            virtual; abstract;
  //
  // 249  -      .
  //            Fix[n].
  //
  function  GenMinFix(Problem:TMinProblem; Report:TMinReport; n:Integer; var x:array of Double;
                  var f:Double; var g:array of Double; Custom:Pointer; var Count:Integer;
                  MaxCount:Integer; Method:Integer; tolx,tolf,tolg,inf,Size,Step,EvalTol:Double;
                  var v:array of Double; nv:Integer;
                  var Fix:array of Boolean):Integer;                     virtual; abstract;
  //
  // 250  -      .
  //           fscale    xLo[n]..xHi[n].
  //
  function  GenMinScaled(Problem:TMinProblem; Report:TMinReport; n:Integer; var x:array of Double;
                  var f:Double; var g:array of Double; Custom:Pointer; var Count:Integer;
                  MaxCount:Integer; Method:Integer; tolx,tolf,tolg,inf,Size,Step,EvalTol:Double;
                  var v:array of Double; nv:Integer; fscale:Double;
                  var xLo,xHi:array of Double):Integer;                  virtual; abstract;
  //
  // 251  -      .
  //           .
  //
  function GenMinFixScaled(Problem:TMinProblem; Report:TMinReport; n:Integer; var x:array of Double;
                  var f:Double; var g:array of Double; Custom:Pointer; var Count:Integer;
                  MaxCount:Integer; Method:Integer; tolx,tolf,tolg,inf,Size,Step,EvalTol:Double;
                  var v:array of Double; nv:Integer; var Fix:array of Boolean; fscale:Double;
                  var xLo,xHi:array of Double):Integer;                  virtual; abstract;
  //
  // 252  -     .
  //        m= , t[m],y[m],w[m]=,,  ,
  //        Fit= , Report= , n=,
  //        x[n]=, f= , g[n]=  , Custom= ,
  //        Count= , MaxCount=   , Method=  0..8,
  //        tolx,tolf,tolg=  x,f,g, inf= , Size= , Step= ,
  //        EvalTol=  , a[]=    (n+10)*(n+1),
  //        Fix[n]=  , fscale= , xLo[n],xHi[n]= 
  //
  function  LSQFit(m:Integer; var t,y,w:array of Double; Fit:TFitProblem; Report:TFitReport;
                   n:Integer; var x:array of Double; var f:Double; var g:array of Double;
                   Custom:Pointer; var Count:Integer; MaxCount:Integer; Method:Integer;
                   tolx,tolf,tolg,Inf,Size,Step,EvalTol:Double; var a:array of Double;
                   var Fix:array of Boolean; fscale:Double; var xLo:array of Double;
                   var xHi:array of Double):Integer;                     virtual; abstract;
  //
  // 253  -    ,    LSQFit.
  //
  function  LSQFitSumOfSquares(m:Integer; var t,y,w:array of Double; Fit:TFitProblem; n:Integer;
                               var x:array of Double; var f:Double; var g:array of Double;
                               Custom:Pointer):Integer;                  virtual; abstract;
  //
  // 254  -       (     ).
  //
  function  Rfa:TRfaDataBaseWrap;                                        virtual; abstract;
  //
  // 255  -         .
  //           "Compare"     ,
  //         "KeyOf"       .
  //         ,      :
  //         "SwapData"  -     " ".
  //         "Index"     -    "" .
  //           " ",   Data  
  //         ,     :
  //           Compare(Data,KeyOf(Data,i),KeyOf(Data,j))<=0, i<=j
  //         , Data[i]    Data[i]<=Data[j], i<=j.
  //         "SwapData"      .
  //          "Index"       nil.
  //                   , 
  //         ""  (  "SwapData"=nil).
  //         ""      .
  //             "Index",  :
  //           Compare(Data,KeyOf(Data,Index[i]),KeyOf(Data,Index[j]))<=0, i<=j
  //         ,  Data[Index[i]]  :
  //           Data[Index[i]]<=Data[Index[j]], i<=j
  //         "Method"   0=ShellSort, 1=QuickSort.
  //        ShellSort - " " ,   ,
  //            ,    
  //          .
  //        smQuickSort -     .  
  //               - 
  //         .     ShellSort.
  //        :
  //           Count    -   Data.
  //           Data     -    [0..Count-1]   .
  //           Compare  -   :Compare(Data,Key1,Key2)=-1/0/+1=LT/EQ/GT.
  //           KeyOf    - KeyOf(Data,j), j=0..N-1    j   Data.
  //           SwapData -      " ".
  //           Index    -    : Data[Index[i]]  .
  //           Method   - 0=ShellSort, 1=QuickSort.
  //
  function  Sort(Count:Integer; Data:Pointer; Compare:TCompareFunction;
                 KeyOf:TKeyOfFunction; SwapData:TSwapProcedure;
                 Index:PIntegerArray; Method:Integer=0):Boolean;         virtual; abstract;
  //
  // 256  -     .
  // 257 -       .
  //               , 
  //          " "  (   Index=nil)  
  //        ""  (   Index<>nil).
  //        QuickFind   i    
  //        Data[0..Count-1]   :
  //            i=0         Key <  Data[0],
  //            i=Count-2   Key >= Data[Count-1]
  //            Data[i] <= Key < Data[i+1]   
  //        QuickFind     , 
  //        ,  Key    ,    
  //           . QuickFind 
  //           x[i]..x[i+1],    .
  //        QuickSearch   Key    Data[0..Count-1]
  //          true/false   / ,   
  //        KeyIndex,  :
  //             KeyIndex=0         Key<=Data[0],
  //             KeyIndex=Count     Key>Data[Count-1]
  //             x[KeyIndex-1] < Key <= x[KeyIndex]   
  //         KeyIndex ,      Key,
  //             - .
  //        QuickSearch       
  //        ,        
  //          ,      .
  //
  function  QuickFind(Count:Integer; Data:Pointer; Compare:TCompareFunction;
                      KeyOf:TKeyOfFunction; KeyToSearch:Pointer;
                      Index:PIntegerArray=nil):Integer;                  virtual; abstract;
  function  QuickSearch(Count:Integer; Data:Pointer; Compare:TCompareFunction;
                        KeyOf:TKeyOfFunction; KeyToSearch:Pointer;
                        var KeyIndex:Integer; Index:PIntegerArray=nil;
                        Duplicates:Boolean=false):Boolean;               virtual; abstract;
  //
  // 258  -       .
  //        i:=FindIndex(N,x,at,index)   i   x[0..N-1],
  //          x[i]<=x[i+1],   , 
  //        x[i]<=at<x[i+1];   i=0,  at<x[0]; i=N-2,  at>x[N-2].
  //          index<>nil, x[i]    x[index[i]].
  //           ;   
  //        i:=QuickFind(N,@x,CompareDoubles,KeyOfDoubles,@at,index).
  //
  function  FindDoubleIndex(N:Integer; const x:array of Double; at:Double;
                            Index:PIntegerArray=nil):Integer;            virtual; abstract;
  //
  // 259  -      y(x)   t.
  //          (x[0..N-1],y[0..N-1])   
  //         x[i]<=x[i+1].     ,  
  //        .
  //
  function  LinearInterpolation(const x,y:array of Double; N:Integer;
                                t:Double):Double;                        virtual; abstract;
  //
  // 260  -    N-1,   P[0..N-1],   t.
  //            ,  
  //         P(t)=(..(P[N-1]*t+P[N-2])*t+..+P[1])*t+P[0]
  //
  function  EvaluatePolynomAt(const P:array of Double; N:Integer;
                              t:Double):Double;                          virtual; abstract;
  //
  // 261  -     P[0..N-1]  N-1, 
  //            y(x)=(x[0..M-1],y[0..M-1]).
  //             t=(x-X0)/Scale,
  //           .   
  //        EvaluatePolynomAt(P,N,(x-X0)/Scale);
  //
  function  FindLeastSquaresPolynom(var P:array of Double; N:Integer; X0,Scale:Double;
                        const x,y:array of Double; M:Integer):Boolean;   virtual; abstract;
  //
  // 262 -          t.
  //           x[0..N-1],  z[0..N-1],k[0..N-1]
  //         FindSmoothingSpline.  NDeriv=0/1/2/3
  //         /1/2/3 .
  //
  function  EvaluateSplineAt(N:Integer; const x,z,k:array of Double;
                             t:Double; NDeriv:Integer=0):Double;         virtual; abstract;
  //
  // 263 -   k[0..N-1],z[0..N-1]  
  //       ,   y(x),   
  //        x[0..N-1],y[0..N-1],  x[i]   .
  //        p[0..N-1]   .   p[i]=0, 
  //            (x[i],y[i]).   p[i]>0,
  //            1/p[i].    p[i]=0,
  //          . pL,pR,nL,nR 
  //             ,     
  //         .
  //
  function  FindSmoothingSpline(N:Integer; const x,y,p:array of Double;
                                var z,k:array of Double;
                                nL:Integer=2; pL:Double=0;
                                nR:Integer=2; pR:Double=0):Boolean;      virtual; abstract;
  //
  // 264 -   .
  // 265 -   .
  //            t  y(x),  
  //       (x[0..N-1],y[0..N-1]),   x  x[i+1]>=x[i].
  //          [t-Window..t+Window]    Window
  //             w(t)=Kernel((t-Window)/Window).
  //               
  //        Power.       
  //        .
  //
  function  WindowedKernelSmoothing(const x,y:array of Double; N:Integer;
                                    t,Window:Double; Power:Integer; Kernel:TSmoothKernel;
                                    Custom:Pointer=nil):Double;          virtual; abstract;
  function  WindowedIntegrationSmoothing(const x,y:array of Double; N:Integer;
                                         t,Window:Double; Kernel:TSmoothKernel;
                                         Custom:Pointer=nil):Double;     virtual; abstract;
  //
  // 266 -       .
  // 267 -       .
  // 268 -       .
  //          x[0..N-1]  :
  //       a[i]*x[i-1]+b[i]*x[i]+c[i]*x[i+1]=d[i]
  //          x[0..N-1]  :
  //       a[i]*x[i-2]+b[i]*x[i-1]+c[i]*x[i]+e[i]*x[i+1]+g[i]*x[i+2]=d[i]
  //           N     .
  //
  procedure Solve3DiagonalSetByProgonka(N:Integer;
                                        var a,b,c,x,d:array of Double);  virtual; abstract;
  procedure Solve3DiagonalSetByGauss(N:Integer;
                                     var a,b,c,x,d:array of Double);     virtual; abstract;
  procedure Solve5DiagonalSetByGauss(N:Integer;
                                     var a,b,c,e,g,x,d:array of Double); virtual; abstract;
  //
  // 269 -     .
  // 270 -      .
  // 271 -     .
  // 272 -      .
  //            /.
  //
  function  CreateLongIntVector(aLength:Integer; aOrigin:Integer=0;
                         aExceptions:Boolean=true):TLongIntVectorWrap;   virtual; abstract;
  function  CreateDoubleVector(aLength:Integer; aOrigin:Integer=0;
                         aExceptions:Boolean=true):TDoubleVectorWrap;    virtual; abstract;
  function  CreateLongIntMatrix(aRows,aColumns:Integer; aOrigin:Integer=0;
                         aExceptions:Boolean=true):TLongIntMatrixWrap;   virtual; abstract;
  function  CreateDoubleMatrix(aRows,aColumns:Integer; aOrigin:Integer=0;
                         aExceptions:Boolean=true):TDoubleMatrixWrap;    virtual; abstract;
  //
  // 273  -      .
  //        LinearProgrammingBySimplex     :
  //          F = minimum( F(X)=-G(X)= C(1)*X(1)+C(2)*X(2)+...+C(N)*X(N) ) 
  //          G = maximum( G(X)=-F(X)=-C(1)*X(1)-C(2)*X(2)-...-C(N)*X(N) )
  //         :
  //               A(1,1)*X(1)+A(1,2)*X(2)+....+A(1,N)*X(N) (<=,>=,=) B(1)
  //               ......
  //               A(M,1)*X(1)+A(M,2)*X(2)+....+A(M,N)*X(N) (<=,>=,=) B(M)
  //         
  //               X(i) >= 0, i=1..N
  //        B(i)    .
  //         :
  //         A(i,j)    MatrCoef[1..M,1..N];
  //         (i)            -   Problem[1..N];
  //           B(i) -   RightSide[1..M]
  //          (<=,>=,=)   -    Signums[1..M]:
  //         Signum =+1   '>='
  //         Signum = 0   '='
  //         Signum =-1   '<='
  //        ,    MatrCoef   Problem, RightSide 
  //          1.  ,   Origin    
  //         1.
  //        PrintMode- : 0- ; . si_XXXX
  //        OutPutFile-    .
  //           OutPut()  Null( ).
  //        :
  //          ,     
  //         nil,         .
  //              ,  , 
  //        -    ,  
  //             .   
  //          1.
  //           ,    Zero;  
  //        ,   ,    Zero     .
  //        Zero        MachEps.
  //           ErrorCode   ,  si_XXXX
  //          :
  //            Simplex   M*M + 5(2*M+N)
  //              
  //
  function  LinearProgrammingBySimplex(Problem:TDoubleVectorWrap; MatrCoef:TDoubleMatrixWrap;
                            Signums:TLongIntVectorWrap; RightSide:TDoubleVectorWrap;
                            var ErrorCode:Integer; PrintMode:Word; var OutPutFile:Text;
                            Zero:Double=1E-12):TDoubleMatrixWrap;        virtual; abstract;
  //
  // 274  -     .   
  //          .     .
  //
  function  CreateSingularDecomposition(A:TDoubleMatrixWrap):TSVDWrap;   virtual; abstract;
  //
  // 275  -   FIFO      .
  //            .
  //
  function CreateFifo(aSize:LongInt=1024;
                      const aName:ShortString=''):TFifoWrap;             virtual; abstract;
  //
  // 276  -     ,   
  //        .    2 ,  0.2 
  //          msecnow, ,   
  //         ,   msecnow.   ,
  //         msecnow    10 ,   mksecnow
  //         .  ,  ,   mksecnow
  //            ,   msecnow  .
  //              
  //        msecnow     mksecnow   ,
  //            ,    (53) 
  //        Double,   CRW-DAQ,    
  //           10 ,  .
  //
  function  MkSecNow:Extended;                                           virtual; abstract;
  //
  // 277  -   Target:=Target+Value,  Target+Value.
  //              .
  //        :
  //         const Latch:Integer=0;
  //         if LockedAdd(Latch,1)=1 then DoSomething;
  //         LockedSub(Latch,1);
  //          DoSomething     
  //          ,      .
  //          Target      32 . 
  //
  function  LockedAdd(var Target: Integer; Value: Integer): Integer;     virtual; abstract;
  //
  // 278  -   if Target=Comp then Target:=Exch,  Target.
  //              .
  //
  function  LockedCompareExchange(var Target: Integer;
                                  Exch, Comp: Integer): Integer;         virtual; abstract;
  //
  // 279  -   Target:=Target-1,  Target-1.
  //              .
  //
  function  LockedDec(var Target: Integer): Integer;                     virtual; abstract;
  //
  // 280  -   Target:=Value,  Target.
  //              .
  //
  function  LockedExchange(var Target: Integer;
                               Value: Integer): Integer;                 virtual; abstract;
  //
  // 281  -   Target:=Target+Value,  Target.
  //              .
  //
  function  LockedExchangeAdd(var Target: Integer;
                                   Value: Integer): Integer;             virtual; abstract;
  //
  // 282  -   Target:=Target-1,  Target.
  //              .
  //
  function  LockedExchangeDec(var Target: Integer): Integer;             virtual; abstract;
  //
  // 283  -   Target:=Target+1,  Target.
  //              .
  //
  function  LockedExchangeInc(var Target: Integer): Integer;             virtual; abstract;
  //
  // 284  -   Target:=Target-Value,  Target.
  //              .
  //
  function  LockedExchangeSub(var Target: Integer;
                                   Value: Integer): Integer;             virtual; abstract;
  //
  // 285  -   Target:=Target+1,  Target+1.
  //              .
  //
  function  LockedInc(var Target: Integer): Integer;                     virtual; abstract;
  //
  // 286  -   Target:=Target-Value,  Target-Value.
  //              .
  //
  function  LockedSub(var Target: Integer; Value: Integer): Integer;     virtual; abstract;
  //
  // 287 -     .    .
  //       , RemoveBrackets('[Section]')='Section'.
  //
  function  RemoveBrackets(const s:ShortString;
                           const Brackets:ShortString='[]'):ShortString; virtual; abstract;
  //
  // 288 -     MIME, 64-base.
  //      .
  //       a..z, A..Z, 0..9, +, /.
  //         .
  // :
  //  var x,y:double; i,j:integer; s:string;
  //  s:=mime_encode(r2dump(x)+r2dump(y)+i2dump(i)+i2dump(j));
  //  ... send data ...
  //  s:=mime_decode(s);
  //  x:=dump2r(copy(s,1,8));
  //  y:=dump2r(copy(s,9,8));
  //  i:=dump2i(copy(s,17,4));
  //  j:=dump2i(copy(s,21,4));
  //
  function  Mime_Encode(const S:LongString):LongString;                  virtual; abstract;
  //
  // 289 -  ,    Mime_Encode.
  //
  function  Mime_Decode(const S:LongString):LongString;                  virtual; abstract;
  //
  // 290 -  ,    .
  //
  function  IsSameText(const S1,S2:LongString):Boolean;                  virtual; abstract;
 end;
 //
 ///////////////////////////////////////////////////////////////////////////////
 //  TGuiApi          //
 // .      Target.     //
 //         .   //
 //   CRW-DAQ  ,   ,      //
 // ,   ,    , ,  //
 // .    ,   ,       //
 //   ,     ,   mrNone.    //
 ///////////////////////////////////////////////////////////////////////////////
 TGuiApi = class(TPluginApi)
  //
  // 0    -     .  ,    
  //         RedirectStdOut(..).  ,   ,
  //             FIFO.   
  //         Real Time .
  //
  procedure Echo(const Msg:LongString);                                  virtual; abstract;
  //
  // 1    -    .
  //
  function  Warning(const Msg:ShortString):word;                         virtual; abstract;
  //
  // 2    -     .
  //
  function  Information(const Msg:ShortString):word;                     virtual; abstract;
  //
  // 3    -     Yes/No.
  //
  function  YesNo(const Msg:ShortString):word;                           virtual; abstract;
  //
  // 4    -     Yes/No/Cancel.
  //
  function  YesNoCancel(const Msg:ShortString):word;                     virtual; abstract;
  //
  // 5    -      .
  //
  function  Error(const Msg:ShortString):word;                           virtual; abstract;
  //
  // 6    -   ,       .
  //
  function  Trouble(Check:boolean; const Msg:ShortString):Boolean;       virtual; abstract;
  //
  // 7    -    ,       .
  //
  function  NoProblem(Check:boolean; const Msg:ShortString):Boolean;     virtual; abstract;
  //
  // 8    -      ,   ItemList.
  //            (  ).
  //         -1,    .
  //
  function  ListBoxMenu(const Caption,Title:ShortString;
                        const ItemList:LongString):Integer;              virtual; abstract;
  //
  // 9    -       ,   ItemList.
  //               ,
  //            GetIndex.    
  //         .
  //
  function  ListBoxMultiSelection(const Caption,Title:ShortString;
                                  const ItemList : LongString;
                                        Extended : Boolean = false;
                                        GetIndex : Boolean = false
                                               ) : LongString;           virtual; abstract;
  //
  // 10   -     .
  //
  function  TextEditDialog(const Caption,Title:ShortString;
                           const TextToEdit:LongString):LongString;      virtual; abstract;
  //
  // 11  - ,     .
  //
  function UsesBlaster:Boolean;                                          virtual; abstract;
  //
  // 12   -    ,   PlayList.
  //                 FIFO 
  //          .   
  //          .  PlayList    wav-,
  //          ,  AddSoundLibrary.  
  //            
  //        .
  //
  procedure Voice(const PlayList:ShortString);                           virtual; abstract;
  //
  // 13   -  FIFO ,   ,   Voice.
  //
  procedure StopBlaster;                                                 virtual; abstract;
  //
  // 14   -         .
  //         *.WAV       .
  //
  procedure AddSoundLibrary(const Path:ShortString;
                                  MaxSubDirs:LongInt=0);                 virtual; abstract;
  //
  // 15   -  Application.ProcessMessages,   .
  //
  procedure ApplicationProcessMessages;                                  virtual; abstract;
  //
  // 16   -   ,   .
  //
  procedure UpdateSystemConsole;                                         virtual; abstract;
  //
  // 17   -      R,G,B,    0..255.
  //
  function  RGB(r,g,b:Integer):TColor;                                   virtual; abstract;
  //
  // 18   -       CGA.
  //
  function  CgaColorNameEng(CgaColor:Integer):ShortString;               virtual; abstract;
  //
  // 19   -       CGA.
  //
  function  CgaColorNameRus(CgaColor:Integer):ShortString;               virtual; abstract;
  //
  // 20   -     CGA  .
  //
  function  CgaColorByName(const S:ShortString):Integer;                 virtual; abstract;
  //
  // 21   -      CGA,   DOS,
  //           RGB,   Windows. CgaColor 
  //          0=Black...15=White.
  //
  function  CgaToRGBColor(CgaColor:Integer):TColor;                      virtual; abstract;
  //
  // 22   -  Application.Handle.
  //
  function  ApplicationHandle:THandle;                                   virtual; abstract;
 end;
 //
 ///////////////////////////////////////////////////////////////////////////////
 //  TDaqApi             //
 //   CRW-DAQ.   Target   ForDataAcquisition.     //
 //  .                                                          //
 // 1)  DLL.   CRW-DAQ   Program ( Daq Pascal)     //
 //       DLL,    Daq Pascal:      //
 //     DaqDllInit(DllPath)      -  DLL    .     //
 //     DaqDllFree(hDll)         -    DLL.             //
 //     DaqDllCall(hDll,Command) -  DLL    .//
 //     Command  ,  ,   .     //
 //       /  /.      //
 //    ,   ,   ,       //
 //         Daq Pascal  DLL.     //
 //       :                               //
 //     a)  CRW-DAQ   DLL   Daq_Cmd_Init        //
 //             .     //
 //       ,      ,  .  //
 //            ,   DLL           //
 //       ,     .                             //
 //     b)   DAQ   DLL   Daq_Cmd_Poll     //
 //          .              //
 //       ,    .       //
 //         ,     . //
 //          ,      ,   //
 //          .                                        //
 //     c)  CRW DAQ,   DLL   Daq_Cmd_Free    //
 //          ,      //
 //        ..                                                              //
 //  2)   .   DaqDllInit        //
 //      API,       .      //
 //       ,      DLL        //
 //     .     ,    //
 //       ,      API    //
 //       .       ,//
 //           .                    //
 //       DaqDllFree    .      //
 //              Daq_Cmd_Free    //
 //     DaqDataSheet(0),          //
 //      ,      . //
 //     ,            //
 //       DaqDataSheet(Size).            //
 //       , Size   sizeof(..)             //
 //     :                                                               //
 //          type TDataRec:record ... end;                                    //
 //          begin                                                            //
 //           with Daq, TDataRec(DaqDataSheet(sizeof(TDataRec))^) do ...      //
 //          end;                                                             //
 //  3) .  CRW DAQ    ,   DLL  //
 //       FindTag...sSetTag.            //
 //       CRW-DAQ         //
 //     .    , , ,  .     //
 //              //
 //      ( ).       //
 //          .     DAQ     //
 //         ,            //
 //       .            //
 //      1(Integer), 2(Double), 3(LongString).   ,    //
 //          .          //
 //       .                                                        //
 //  4)  .  Crw Daq     //
 //      - ,  ,   ..       //
 //            Thermocouple,Relationsheep.. //
 //  5) .  CRW DAQ    ,            //
 //       .        //
 //      .              //
 //     / /.           //
 //       Daq Pascal. ,         //
 //       -       putev,putao,putdo. //
 //            .               //
 //             ,  //
 //        refAI..refDO, FindObjectRef('Curve',..).         //
 //            ,     //
 //     WinDraw.        ,//
 //           (,      //
 //     ,   ).                                        //
 //  6) .    DaqPascal,     CRW DAQ //
 //        ,            //
 //     FindObjectRef('Device',..).                                           //
 ///////////////////////////////////////////////////////////////////////////////
 TDaqApi = class(TPluginApi)
  //
  // 0    -  ,   DLL   Daq Pascal
  //           DaqDllCall(..,Command).
  //
  function  DaqCommand:Integer;                                          virtual; abstract;
  //
  // 1    -      DAQ - .
  //         aSize    .    ,
  //          .     ,
  //         .     
  //           DLL,      -
  //              :
  //          type TDataRec:record ... end;
  //          begin
  //           with Daq, TDataRec(DaqDataSheet(sizeof(TDataRec))^) do ...
  //          end;
  //
  function  DaqDataSheet(aSize:Integer):Pointer;                         virtual; abstract;
  //
  // 2    - ,   DAQ - .
  //
  function  DaqIsLoaded:Boolean;                                         virtual; abstract;
  //
  // 3    - ,     DAQ - .
  //
  function  DaqIsStarted:Boolean;                                        virtual; abstract;
  //
  // 4    -      DAQ.
  //
  function  DaqConfigFile:ShortString;                                   virtual; abstract;
  //
  // 5    -        DAQ.
  //
  function  DaqDataPath:ShortString;                                     virtual; abstract;
  //
  // 6    -        DAQ.
  //
  function  DaqTempPath:ShortString;                                     virtual; abstract;
  //
  // 7    -      .    .
  //          ,       .
  //
  function  FindTag(const Name:ShortString):Integer;                     virtual; abstract;
  //
  // 8    -      ,   .
  //          ,     .
  //         ,       
  //           ,   .
  //
  function  CreateTag(const Name:ShortString; Typ:Integer):Integer;      virtual; abstract;
  //
  // 9    -  ,   tag.
  //
  function  FreeTag(tag:Integer):Boolean;                                virtual; abstract;
  //
  // 10    -   ,   tag.  :
  //        0 -   .
  //        1 -    Integer    (Integer  Daq Pascal).
  //        2 -    Double     (Real     Daq Pascal).
  //        3 -    LongString (String   Daq Pascal).
  //
  function  TypeTag(tag:Integer):Integer;                                virtual; abstract;
  //
  // 11   -       tag.
  //          ,    .
  //
  function  NameTag(tag:Integer):ShortString;                            virtual; abstract;
  //
  // 12   -     Integer.
  //         0,        .
  //
  function  iGetTag(tag:Integer):Integer;                                virtual; abstract;
  //
  // 13   -     Real.
  //         0,        .
  //
  function  rGetTag(tag:Integer):Double;                                 virtual; abstract;
  //
  // 14   -     String.
  //          ,        .
  //
  function  sGetTag(tag:Integer):LongString;                             virtual; abstract;
  //
  // 15   -      Integer.
  //         false,        .
  //
  function  iSetTag(tag:Integer; i:Integer):Boolean;                     virtual; abstract;
  //
  // 16   -      Real.
  //         false,        .
  //
  function  rSetTag(tag:Integer; r:Double):Boolean;                      virtual; abstract;
  //
  // 17   -      String.
  //         false,        .
  //
  function  sSetTag(tag:Integer; const s:LongString):Boolean;            virtual; abstract;
  //
  // 18   -     .
  //
  function  ThermoCoupleCount:Integer;                                   virtual; abstract;
  //
  // 19   -    0  ThermoCoupleCount-1  
  //          .  -1,      .
  //
  function  FindThermoCouple(const CoupleName:ShortString):Integer;      virtual; abstract;
  //
  // 20   -       .
  //
  function  ThermoCoupleName(CoupleID:Integer):ShortString;              virtual; abstract;
  //
  // 21   -     .
  //
  function  ThermoCoupleRange(CoupleID:Integer):TRect2D;                 virtual; abstract;
  //
  // 22   -       
  //        ,    Inverted.   
  //         .
  //
  function  ThermoCoupleValue(CoupleID:Integer; Argument:Double;
                              Inverted:Boolean):Double;                  virtual; abstract;
  //
  // 23   -     .
  //
  function  RelationshipCount:Integer;                                   virtual; abstract;
  //
  // 24   -    0  RelationshipCount-1  
  //          .  -1,    .
  //
  function  FindRelationship(const RelationName:ShortString):Integer;    virtual; abstract;
  //
  // 25   -       .
  //
  function  RelationshipName(RelationID:Integer):ShortString;            virtual; abstract;
  //
  // 26   -     .
  //
  function  RelationshipRange(RelationID:Integer):TRect2D;               virtual; abstract;
  //
  // 27   -       
  //        ,    Inverted.   
  //         .
  //
  function  RelationshipValue(RelationID:Integer; Argument:Double;
                              Inverted:Boolean):Double;                  virtual; abstract;
  //
  // 28   -      DAQ,    TimeUnits.
  //
  function  Time:Double;                                                 virtual; abstract;
  //
  // 29   -     DAQ  .
  //
  function  TimeUnits:Double;                                            virtual; abstract;
  //
  // 30   -       DAQ.
  //
  function  NumAIs:Integer;                                              virtual; abstract;
  //
  // 31   -       DAQ.
  //
  function  NumDIs:Integer;                                              virtual; abstract;
  //
  // 32   -       DAQ.
  //
  function  NumAOs:Integer;                                              virtual; abstract;
  //
  // 33   -       DAQ.
  //
  function  NumDOs:Integer;                                              virtual; abstract;
  //
  // 34   -      DAQ.
  //
  function  NumCals:Integer;                                             virtual; abstract;
  //
  // 35   -   ,     n.
  //                , 
  //              ,   
  //           .
  //
  function  RefAI(n:Integer):Integer;                                    virtual; abstract;
  //
  // 36   -   ,     n.
  //                , 
  //              ,   
  //           .
  //
  function  RefDI(n:Integer):Integer;                                    virtual; abstract;
  //
  // 37   -   ,     n.
  //                , 
  //              ,   
  //           .
  //
  function  RefAO(n:Integer):Integer;                                    virtual; abstract;
  //
  // 38   -   ,     n.
  //                , 
  //              ,   
  //           .
  //
  function  RefDO(n:Integer):Integer;                                    virtual; abstract;
  //
  // 39   -    n.
  //                , 
  //              ,   
  //           .
  //
  function  RefCalibr(n:Integer):Integer;                                virtual; abstract;
  //
  // 40   -   ,   .
  //
  function  GetCurveLength(c:Integer):Integer;                           virtual; abstract;
  //
  // 41   -     c.
  //
  procedure SetCurveLength(c,aLength:Integer);                           virtual; abstract;
  //
  // 42   -    i  ,   c.
  //        ,      0.
  //
  function  GetCurvePoint(c,i:Integer):TPoint2D;                         virtual; abstract;
  //
  // 43   -     i   c.
  //
  procedure SetCurvePoint(c,i:Integer; const aPoint:TPoint2D);           virtual; abstract;
  //
  // 44   -      c.
  //
  procedure CurveAddPoint(c:Integer; const aPoint:TPoint2D);             virtual; abstract;
  //
  // 45   -  aCount     c.
  //
  procedure CurveAddPoints(c:Integer; const aX,aY:array of Double;
                                            aCount:Integer);             virtual; abstract;
  //
  // 46   -   i   c.
  //
  procedure CurveDeletePoint(c,i:Integer);                               virtual; abstract;
  //
  // 47   -  aCount    i   c.
  //
  procedure CurveDeletePoints(c,i,aCount:Integer);                       virtual; abstract;
  //
  // 48   -     i  c.
  //
  procedure CurveInsertPoint(c,i:Integer; const aPoint:TPoint2D);        virtual; abstract;
  //
  // 49   -  aCount    i  c.
  //
  procedure CurveInsertPoints(c,i:Integer; const aX,aY:array of Double;
                              aCount:LongInt);                           virtual; abstract;
  //
  // 50   -   ,   c.
  //
  function  GetCurveName(c:Integer):ShortString;                         virtual; abstract;
  //
  // 51   -   ,   c.
  //
  function  GetCurveColor(c:Integer):Integer;                            virtual; abstract;
  //
  // 52   -   ,   c.
  //
  function  GetCurveStyle(c:Integer):Integer;                            virtual; abstract;
  //
  // 53   -   ,   c.
  //
  function  GetCurveComment(c:Integer):LongString;                       virtual; abstract;
  //
  // 54   -   ,   c.
  //
  procedure SetCurveComment(c:Integer; const aComment:LongString);       virtual; abstract;
  //
  // 55   -      t   c.
  //                  X.
  //
  function  CurveGetIndexAt(c:Integer; t:Double):Integer;                virtual; abstract;
  //
  // 56   -    c   t.
  //                  X.
  //
  function  CurveInterpolateAt(c:Integer; t:Double):Double;              virtual; abstract;
  //
  // 57   -   c   t   Window,   
  //         K(x)=(1-x^k1)^k2. Power -      Power=-1.
  //                  X.
  //
  function  CurveSmoothAt(c:Integer; t:Double;
                        Window:Double; Power,K1,K2:Integer):Double;      virtual; abstract;
  //
  // 58   -    c    [i..j].
  //          aIndex   aValue .
  //            0=Shell,1=Quick.
  //
  function  CurveMedianaAt(c,i,j:Integer; var aIndex:Integer; var aValue:Double;
                         SortMethod:Integer=1):Boolean;                  virtual; abstract;
  //
  // 59   -     " "  ..
  //           cfXXXX.
  //
  function  CurveFlags(c:Integer; AbsEps:Double=0;RelEps:Double=1E-10;
                       Small:Integer=2):LongInt;                         virtual; abstract;
  //
  // 60   -   ,     c.
  //
  function  GetCurveLimits(c:Integer):TRect2D;                           virtual; abstract;
  //
  // 61   -    (a,b)  c.
  //
  function  GetCurveIntegral(c:Integer; a,b:Double):Double;              virtual; abstract;
  //
  // 62   -     c.
  //
  function  GetCurveLastPoint(c:Integer):TPoint2D;                       virtual; abstract;
  //
  // 63   -     .
  //        w  -  , , evAnalog+evCompress  evDigital.
  //        n  -  ,      .
  //        t  -    DAQ, .  Time.
  //        d0 -   
  //        d1 -   
  //                
  //           ,     
  //          ,    
  //           .
  //
  function  PutEv(w,n:Integer; t,d0:Double; d1:Double=0):Boolean;        virtual; abstract;
  //
  // 64   -      .
  //         PutEv(evAnalog+evCompress,n,t,d,0).
  //                
  //           ,     
  //          ,    
  //           .
  //
  function  PutAO(n:Integer; t,d:Double):Boolean;                        virtual; abstract;
  //
  // 65   -      .
  //         PutEv(evDigital,n,t,d,0).
  //                
  //           ,     
  //          ,    
  //           .
  //
  function  PutDO(n:Integer; t,d:Double):Boolean;                        virtual; abstract;
  //
  // 66   -     n    t   .
  //           DaqPascal.
  //
  function  getai(n:Integer;t:Double):Double;                            virtual; abstract;
  //
  // 67   -        n.
  //           DaqPascal.
  //
  function  getai_n(n:Integer):Integer;                                  virtual; abstract;
  //
  // 68   -   X       n.
  //           DaqPascal.
  //
  function  getai_xn(n:Integer):Double;                                  virtual; abstract;
  //
  // 69   -   Y       n.
  //           DaqPascal.
  //
  function  getai_yn(n:Integer):Double;                                  virtual; abstract;
  //
  // 70   -   X[i]     n.
  //            1,   Daq Pascal.
  //           DaqPascal.
  //
  function  getai_xi(n,i:Integer):Double;                                virtual; abstract;
  //
  // 71   -   Y[i]     n.
  //            1,   Daq Pascal.
  //           DaqPascal.
  //
  function  getai_yi(n,i:Integer):Double;                                virtual; abstract;
  //
  // 72   -     n    t.
  //           DaqPascal.
  //
  function  getdi(n:Integer;t:Double):Double;                            virtual; abstract;
  //
  // 73   -        n.
  //           DaqPascal.
  //
  function  getdi_n(n:Integer):Integer;                                  virtual; abstract;
  //
  // 74   -   X       n.
  //           DaqPascal.
  //
  function  getdi_xn(n:Integer):Double;                                  virtual; abstract;
  //
  // 75   -   Y       n.
  //           DaqPascal.
  //
  function  getdi_yn(n:Integer):Double;                                  virtual; abstract;
  //
  // 76   -   X[i]     n.
  //            1,   Daq Pascal.
  //           DaqPascal.
  //
  function  getdi_xi(n,i:Integer):Double;                                virtual; abstract;
  //
  // 77   -   Y[i]     n.
  //            1,   Daq Pascal.
  //           DaqPascal.
  //
  function  getdi_yi(n,i:Integer):Double;                                virtual; abstract;
  //
  // 78   -   t    n,   d.
  //           DaqPascal.
  //
  function  calibr(n:Integer; t,d:Double):Double;                        virtual; abstract;
  //
  // 79   -     n.
  //           DaqPascal.
  //
  function  fixerror(n:Integer):Boolean;                                 virtual; abstract;
  //
  // 80   -  ,      
  //          i..i+n-1.     , 
  //            .
  //           DaqPascal.
  //
  function  aimap(i,n:Integer):Integer;                                  virtual; abstract;
  //
  // 81   -  ,      
  //          i..i+n-1.     , 
  //            .
  //           DaqPascal.
  //
  function  dimap(i,n:Integer):Integer;                                  virtual; abstract;
  //
  // 82   -  ,      
  //          i..i+n-1.     , 
  //            .
  //           DaqPascal.
  //
  function  aomap(i,n:Integer):Integer;                                  virtual; abstract;
  //
  // 83   -  ,      
  //          i..i+n-1.     , 
  //            .
  //           DaqPascal.
  //
  function  domap(i,n:Integer):Integer;                                  virtual; abstract;
  //
  // 84   -  ,      
  //           i..i+n-1.     , 
  //              .
  //           DaqPascal.
  //
  function  diword(i,n:Integer):Integer;                                 virtual; abstract;
  //
  // 85   -        .
  //        0 -   .
  //        1 -   .
  //        2 -   .
  //        3 -   .
  //           DaqPascal.
  //
  function  ClickButton:Integer;                                         virtual; abstract;
  //
  // 86   -    .
  //           DaqPascal.
  //
  function  ClickSensor:ShortString;                                     virtual; abstract;
  //
  // 87   -    .
  //           DaqPascal.
  //
  function  ClickTag:Integer;                                            virtual; abstract;
  //
  // 88   -   .     GuiApi.Voice.
  //        ,  DaqApi.Voice      DAQ.
  //           DaqPascal.
  //
  function  Voice(const msg:ShortString):Boolean;                        virtual; abstract;
  //
  // 89   -    ,   Caption.
  //           DaqPascal.
  //
  function  WinDraw(const Caption:ShortString):Boolean;                  virtual; abstract;
  //
  // 90   -    ,   Caption.
  //           DaqPascal.
  //
  function  WinShow(const Caption:ShortString):Boolean;                  virtual; abstract;
  //
  // 91   -    ,   Caption.
  //           DaqPascal.
  //
  function  WinHide(const Caption:ShortString):Boolean;                  virtual; abstract;
  //
  // 92   -    ,   Caption.
  //           DaqPascal.
  //
  function  WinSelect(const Caption:ShortString):Boolean;                virtual; abstract;
  //
  // 93   -    .    s:
  //         s = Var         -   Var   .
  //         s = Sec Var     -   Var   Sec  DAQ.
  //         s = Cfg Sec Var -   Var   Sec  Cfg.
  //           DaqPascal.
  //
  function  ReadIni(const s:ShortString):ShortString;                    virtual; abstract;
  //
  // 94   -     - .  !
  //
  function  GetPortB(Address:Word):Byte;                                 virtual; abstract;
  //
  // 95   -     - .  !
  //
  procedure SetPortB(Address:Word; Value:Byte);                          virtual; abstract;
  //
  // 96   -     - .  !
  //
  function  GetPortW(Address:Word):Word;                                 virtual; abstract;
  //
  // 97   -     - .  !
  //
  procedure SetPortW(Address:Word; Value:Word);                          virtual; abstract;
  //
  // 98   -      - .  !
  //
  function  GetPortL(Address:Word):LongWord;                             virtual; abstract;
  //
  // 99   -      - .  !
  //
  procedure SetPortL(Address:Word; Value:LongWord);                      virtual; abstract;
  //
  // 100  -    DAQ        s.
  //           DaqPascal.
  //
  function  RegisterErr(const s:ShortString):Integer;                    virtual; abstract;
  //
  // 101  -     n.
  //         n = -2       :    
  //         n = -1       :    
  //         n = 0..255   :     n
  //         n = 256..511 :      n-256
  //           DaqPascal.
  //
  function  GetErrCount(n:Integer):Double;                               virtual; abstract;
  //
  // 102  -     DAQ PASCAL,    DLL.
  //           DaqPascal.
  //
  function  RunCount:Double;                                             virtual; abstract;
  //
  // 103  -    What   Name    CRW DAQ.
  //         What   :
  //        TAG    -    ,   FindTag.
  //        CURVE  -       .
  //        DEVICE -     DAQ   .
  //                    ,   .
  //          ,   .
  //             , ,
  //           -        ..
  //                , 
  //              ,   
  //           .
  //
  function  FindObjectRef(const What,Name:ShortString):Integer;          virtual; abstract;
  //
  // 104  -      .
  //
  function  DeviceName(d:Integer):ShortString;                           virtual; abstract;
  //
  // 105  -       .
  //
  function  DeviceModel(d:Integer):ShortString;                          virtual; abstract;
  //
  // 106  -       .
  //
  function  DeviceFamily(d:Integer):ShortString;                         virtual; abstract;
  //
  // 107  -   Action ,   d, .FindObjectRef.
  //         ,   ,      VCL.
  //
  function  DeviceAction(d:Integer):Boolean;                             virtual; abstract;
  //
  // 108  -   Clear ,   d, .FindObjectRef.
  //         ,   ,      VCL.
  //
  function  DeviceClear(d:Integer):Boolean;                              virtual; abstract;
  //
  // 109  -   ClearDevice ,   d, .FindObjectRef.
  //         ,   ,      VCL.
  //
  function  DeviceClearDevice(d:Integer):Boolean;                        virtual; abstract;
  //
  // 110  -   Start ,   d, .FindObjectRef.
  //         ,   ,      VCL.
  //
  function  DeviceStart(d:Integer):Boolean;                              virtual; abstract;
  //
  // 111  -   Stop ,   d, .FindObjectRef.
  //         ,   ,      VCL.
  //
  function  DeviceStop(d:Integer):Boolean;                               virtual; abstract;
  //
  // 112  -   HandleMessage ,   d, .FindObjectRef.
  //
  function  DeviceMessage(d:Integer; const msg:ShortString):Double;      virtual; abstract;
  //
  // 113  -      *.CRW.
  //        arglist =  fname winname wintitle winlable curvelist
  //         fname     -  ,       
  //         winname   -        crw-
  //         wintitle  -     
  //         winlable  -     
  //         curvelist -   
  //        :
  //        SaveCrw('..\data\pressure.crw, Pressures, ^CP(t)^N^L{P}, ^R{t}^N^Ct, p1,p2,p3,p4,p5');
  //           DaqPascal.
  //
  function  SaveCrw(const ArgList:ShortString):Boolean;                  virtual; abstract;
  //
  // 114  -        Caption.
  //           DaqPascal.
  //
  function  SpecMarker(const Caption:ShortString):Double;                virtual; abstract;
  //
  // 115  -        Caption.
  //           DaqPascal.
  //
  function  SpecMarkerL(const Caption:ShortString):Double;               virtual; abstract;
  //
  // 116  -        Caption.
  //           DaqPascal.
  //
  function  SpecMarkerR(const Caption:ShortString):Double;               virtual; abstract;
  //
  // 117  -    ROI     Caption.
  //           DaqPascal.
  //
  function  SpecRoiL(const Caption:ShortString):Double;                  virtual; abstract;
  //
  // 118  -    ROI     Caption.
  //           DaqPascal.
  //
  function  SpecRoiR(const Caption:ShortString):Double;                  virtual; abstract;
  //
  // 119  -   Expression,   .
  //          global() DaqPascal.
  //
  function  GlobalCalc(const Expression:ShortString):Double;             virtual; abstract;
  //
  // 120    -   aPortNum   COM.
  //          aParity   = (NOPARITY,ODDPARITY,EVENPARITY,MARKPARITY,SPACEPARITY).
  //          aDataBits = 5..8.
  //          aStopBits = (ONESTOPBIT,ONE5STOPBITS,TWOSTOPBITS).
  //           .  Uartxxx    .
  //               RS-232,  
  //             ,     
  //           ADAM,    RS-485,   IC-7000.
  //                   .
  //
  function  UartOpen(aPortNum:Integer; aBaudrate:Integer=9600; aParity:Integer=NOPARITY;
                     aDataBits:Integer=8; aStopBits:Integer=ONESTOPBIT; aXonXoff:Boolean=false;
                     aFifoSize:Integer=4096;aDcbFlags:LongInt=0):Boolean;virtual; abstract;
  //
  // 121  -  ,    CRW-DAQ.
  //
  function  UartOpenConfig(const Section:ShortString='[SerialPort-COM1]'
                           ):Integer;                                    virtual; abstract;
  //
  // 122  -     .
  //
  procedure UartClose(aPortNum:Integer);                                 virtual; abstract;
  //
  // 123  - ,         .
  //
  function  UartActive(aPortNum:Integer):Boolean;                        virtual; abstract;
  //
  // 124  -        .
  //              .
  //
  function  UartWriteBuf(aPortNum:Integer; const Data:PChar;
                         Count:Cardinal):Cardinal;                       virtual; abstract;
  //
  // 125  -      .    .
  //
  function  UartReadBuf(aPortNum:Integer; var Data:PChar;
                        MaxCount:Cardinal):Cardinal;                     virtual; abstract;
  //
  // 126  -         .
  //
  function  UartWriteStr(aPortNum:Integer;
                         const Data:ShortString):Boolean;                virtual; abstract;
  //
  // 127  -      .
  //
  function  UartReadStr(aPortNum:Integer;
                        MaxCount:Byte=255):ShortString;                  virtual; abstract;
  //
  // 128  -     .
  //
  procedure UartRxClear(aPortNum:Integer);                               virtual; abstract;
  //
  // 129  -     .
  //
  procedure UartTxClear(aPortNum:Integer);                               virtual; abstract;
  //
  // 130  -      .
  //
  function  UartRxCount(aPortNum:Integer):Integer;                       virtual; abstract;
  //
  // 131  -      .
  //
  function  UartTxCount(aPortNum:Integer):Integer;                       virtual; abstract;
  //
  // 132  -      .
  //
  function  UartRxSpace(aPortNum:Integer):Integer;                       virtual; abstract;
  //
  // 133  -      .
  //
  function  UartTxSpace(aPortNum:Integer):Integer;                       virtual; abstract;
  //
  // 133 -    ,        .
  //         4         ADAM,IC-700  ..
  //
  function  UartFindCheckSum(Data:PChar; Length:Integer):Byte;           virtual; abstract;
  //
  // 134  -         HEX - .
  //
  function  UartCatCheckSum(const DataStr:ShortString):ShortString;      virtual; abstract;
  //
  // 135  -       CR     HEX - .
  //
  function  UartCatCheckSumCR(const DataStr:ShortString;
                              CR:Char=ASCII_CR):ShortString;             virtual; abstract;
  //
  // 136  -           .
  //           ,   .
  //
  function  UartTruncCheckSum(const DataStr:ShortString):ShortString;    virtual; abstract;
  //
  // 137  -           .
  //           ,   .     CR,  .
  //
  function  UartTruncCheckSumCR(const DataStr:ShortString;
                                CR:Char=ASCII_CR):ShortString;           virtual; abstract;
  //
  // 138  -     Adam_Slot.   .
  //          ,   Adam_Slot   
  //         program,    DLL.
  //           AdamXXX    
  //           RS-485  ADAM-4000,IC-7000,IC-87000  ..
  //            RS-485    
  //         -    ,   ,
  //               .  
  //        Adam_Slot   ,     
  //           RS-485.    
  //        , //    ,
  //           / ,    .
  //
  function  AdamFindSlot(const aSlotDeviceName:ShortString=''):Integer;  virtual; abstract;
  //
  // 139  -    Adam_Slot   RS-485.
  //        rs_NotAvail   =  RS-485 .  ,   Adam_Slot.
  //        rs_NoRequest  =    .   AdamSendRequest.
  //        rs_WaitQueue  =     . ,    
  //                        Adam_Slot,       - ,    . .
  //        rs_WaitAnswer =       ,  .
  //        rs_Answer     =    .  AdamGetAnswer.
  //        rs_TimeOut    =  TimeOut.          .
  //           Answer  TimeOut,     
  //           rs_NoRequest,   
  //             .
  //
  function  AdamGetStatus(aSlot:Integer):Integer;                        virtual; abstract;
  //
  // 140  -     RS-485.    AdamSlot,
  //             . 
  //            ,   
  //        "TimeOut".   ,  AdamGetStatus=rs_NoRequest.
  //          ,      CR.
  //         AdamDevice   ,  .
  //
  function  AdamSendRequest(aSlot:Integer; aRequest:ShortString;
                            aTimeOut:Integer):Boolean;                   virtual; abstract;
  //
  // 141  -     .
  //
  function  AdamGetRequest(aSlot:Integer):ShortString;                   virtual; abstract;
  //
  // 142  -       .
  //
  function  AdamGetRequestTime(aSlot:Integer):Double;                    virtual; abstract;
  //
  // 143  -       RS-485   .
  //                  CR.
  //        ,  AdamGetStatus=rs_Answer.
  //
  function  AdamGetAnswer(aSlot:Integer):ShortString;                    virtual; abstract;
  //
  // 144  -   ,    AdamSlot.
  //
  function  AdamGetPort(aSlot:Integer):Integer;                          virtual; abstract;
  //
  // 145  -    2-  HEX-  
  //        AdamSlot   RS-485.    .
  //
  function  AdamGetAddress(aSlot:Integer):ShortString;                   virtual; abstract;
  //
  // 146  -       AdamSlot.
  //        //     CR
  //         ,      
  //        ,     .
  //
  function  AdamGetUsesCheckSum(aSlot:Integer):Boolean;                  virtual; abstract;
  //
  // 147  -   Daq Pascal  clickparams.    CRW-DAQ.
  //
  function  ClickParams(const Args:ShortString):LongString;              virtual; abstract;
  //
  // 148  -   Daq Pascal  add3d.    CRW-DAQ.
  //
  function  Add3D(x,y,z:Double):Boolean;                                 virtual; abstract;
  //
  // 149  -   Daq Pascal  plot3d.    CRW-DAQ.
  //
  function  Plot3D(Nx,Ny:Integer; x1,y1,x2,y2:Double;
                   const opt:ShortString):Boolean;                       virtual; abstract;
  //
  // 150  -   Daq Pascal  edit.    CRW-DAQ.
  //
  function  Edit(const s:LongString):LongString;                         virtual; abstract;
  //
  // 151  -   Daq Pascal  editstate.    CRW-DAQ.
  //
  function  EditState:Integer;                                           virtual; abstract;
  //
  // 152  -   Daq Pascal  devsend.    CRW-DAQ.
  //
  function  DevSend(d:Integer; const msg:LongString):Double;             virtual; abstract;
  //
  // 153 -   Daq Pascal  daqfileref.    CRW-DAQ.
  //
  function  FileRef(const FileName : LongString;
                    const DefExt   : LongString='';
                    const BaseFile : LongString='*'):LongString;         virtual; abstract;
 public
  property  CurveLength[c:Integer]   : Integer     read GetCurveLength   write SetCurveLength;
  property  CurvePoint[c,i:Integer]  : TPoint2D    read GetCurvePoint    write SetCurvePoint;
  property  CurveName[c:Integer]     : ShortString read GetCurveName;
  property  CurveColor[c:Integer]    : Integer     read GetCurveColor;
  property  CurveStyle[c:Integer]    : Integer     read GetCurveStyle;
  property  CurveComment[c:Integer]  : LongString  read GetCurveComment  write SetCurveComment;
  property  CurveLimits[c:Integer]   : TRect2D     read GetCurveLimits;
  property  CurveLastPoint[c:Integer]: TPoint2D    read GetCurveLastPoint;
 public
  property  PortB[Address:Word]      : Byte        read GetPortB         write SetPortB;
  property  PortW[Address:Word]      : Word        read GetPortW         write SetPortW;
  property  PortL[Address:Word]      : LongWord    read GetPortL         write SetPortL;
 end;
 //
 ///////////////////////////////////////////////////////////////////////////////
 //  TDanApi       .      //
 //              //
 //  ,      GetArguments,GetArgumentAsXX.      //
 //      :                                       //
 // 1)  - ,        .      //
 //       ,   .               //
 // 2)  - ,        . //
 // 3)  -  ,   ,       //
 //       . ,            //
 //       - ,     .         //
 //          .   //
 //         c,   - w,      //
 //    - i.  :                                            //
 //   w > 0 -   -                                   //
 //   w < 0 -   -                                   //
 //   w = 0 -   -                                //
 //   c > 0 -     "+c"              //
 //   c < 0 -     "-c"              //
 //   c = 0 -  ,                 //
 //       1,          //
 //      ,  -   (+1 = ,    //
 // -1 = , 0 =  ).      ,   //
 // ,     ,    .          //
 //              //
 //    ,   .                             //
 //      0 .                                   //
 // ,    ,   ,   .  //
 // , :                                                          //
 //  WindowCaption[+1]:='Source' -                      //
 //  WindowCaption[-1]:='Target' -                      //
 //  WindowCaption[0]:='Clipbrd' -                             //
 //    ,    . //
 ///////////////////////////////////////////////////////////////////////////////
 //
 TDanApi = class(TPluginApi)
  //
  // 0    -    ,   
  //             .     
  //             [Arguments.Rus] 
  //        [Arguments.Eng]    .
  //
  function  GetArguments:LongString;                                     virtual; abstract;
  //
  // 1    -           
  //             .
  //
  function  GetArgumentAsString(const aName:ShortString):ShortString;    virtual; abstract;
  //
  // 2    -         .
  //
  function  GetArgumentAsInteger(const aName:ShortString;
                                 var aValue:Integer):boolean;             virtual; abstract;
  //
  // 3    -         .
  //
  function  GetArgumentAsDouble(const aName:ShortString;
                                 var aValue:Double):boolean;              virtual; abstract;
  //
  // 4    - ,   ,   w.
  //
  function  WindowExists(w:Integer):Boolean;                             virtual; abstract;
  //
  // 5    - ,   ,   c.
  //
  function  CurveExists(c:Integer):Boolean;                              virtual; abstract;
  //
  // 6    -   ,   w.
  //
  function  GetWindowCaption(w:Integer):ShortString;                     virtual; abstract;
  //
  // 7    -   ,   w.
  //
  procedure SetWindowCaption(w:Integer;const aCaption:ShortString);      virtual; abstract;
  //
  // 8    -    ,   w.
  //
  function  GetWindowTitle(w:Integer):ShortString;                       virtual; abstract;
  //
  // 9    -    ,   w.
  //
  procedure SetWindowTitle(w:Integer;const aTitle:ShortString);          virtual; abstract;
  //
  // 10   -    ,   w.
  //
  function  GetWindowLegend(w:Integer):ShortString;                      virtual; abstract;
  //
  // 11   -    ,   w.
  //
  procedure SetWindowLegend(w:Integer;const aLegend:ShortString);        virtual; abstract;
  //
  // 12   -   ROI - " "  w.
  //           NAN,  ROI  .
  //
  function  GetWindowRoi(w:Integer):TRect2D;                             virtual; abstract;
  //
  // 13   -   ROI - " "  w.
  //              NAN.
  //
  procedure SetWindowRoi(w:Integer; const aRoi:TRect2D);                 virtual; abstract;
  //
  // 14   -    ,   w.
  //
  function  GetWindowComment(w:Integer):LongString;                      virtual; abstract;
  //
  // 15   -    ,   w.
  //
  procedure SetWindowComment(w:Integer;const aComment:LongString);       virtual; abstract;
  //
  // 16   -       w  0,   .
  //               .
  //              0.
  //
  function  GetSelectedCurve(w:Integer):Integer;                         virtual; abstract;
  //
  // 17   -      w.    ,
  //           ,   c   .
  //
  procedure SetSelectedCurve(w,c:Integer);                               virtual; abstract;
  //
  // 18   -      ,   w.
  //
  function  GetCurvesCount(w:Integer):Integer;                           virtual; abstract;
  //
  // 19   -     ,   w.
  //                
  //        ,    ,      .
  //               
  //        CurveCreate,     . ,  
  //        CurveCount[-1]:=0;      .
  //
  procedure SetCurvesCount(w,aCount:Integer);                            virtual; abstract;
  //
  // 20   -    c.
  //
  function  GetCurveLength(c:Integer):Integer;                           virtual; abstract;
  //
  // 21   -     c.
  //
  procedure SetCurveLength(c,aLength:Integer);                           virtual; abstract;
  //
  // 22   -    i  ,   c.
  //        ,      0,    1.
  //
  function  GetCurvePoint(c,i:Integer):TPoint2D;                         virtual; abstract;
  //
  // 23   -     i   c.
  //
  procedure SetCurvePoint(c,i:Integer; const aPoint:TPoint2D);           virtual; abstract;
  //
  // 24   -      c.
  //
  procedure CurveAddPoint(c:Integer; const aPoint:TPoint2D);             virtual; abstract;
  //
  // 25   -  aCount     c.
  //
  procedure CurveAddPoints(c:Integer; const aX,aY:array of Double;
                                            aCount:Integer);             virtual; abstract;
  //
  // 26   -   i   c.
  //
  procedure CurveDeletePoint(c,i:Integer);                               virtual; abstract;
  //
  // 27   -  aCount    i   c.
  //
  procedure CurveDeletePoints(c,i,aCount:Integer);                       virtual; abstract;
  //
  // 28   -     i  c.
  //
  procedure CurveInsertPoint(c,i:Integer; const aPoint:TPoint2D);        virtual; abstract;
  //
  // 29   -  aCount    i  c.
  //
  procedure CurveInsertPoints(c,i:Integer; const aX,aY:array of Double;
                              aCount:LongInt);                           virtual; abstract;
  //
  // 30   -   ,   c.
  //
  function  GetCurveName(c:Integer):ShortString;                         virtual; abstract;
  //
  // 31   -   ,   c.
  //
  procedure SetCurveName(c:Integer; const aName:ShortString);            virtual; abstract;
  //
  // 32   -   ,   c.
  //
  function  GetCurveColor(c:Integer):Integer;                            virtual; abstract;
  //
  // 33   -   ,   c.
  //
  procedure SetCurveColor(c:Integer; aColor:Integer);                    virtual; abstract;
  //
  // 34   -   ,   c.
  //
  function  GetCurveStyle(c:Integer):Integer;                            virtual; abstract;
  //
  // 35   -   ,   c.
  //
  procedure SetCurveStyle(c:Integer; aStyle:Integer);                    virtual; abstract;
  //
  // 36   -   ,   c.
  //
  function  GetCurveComment(c:Integer):LongString;                       virtual; abstract;
  //
  // 37   -   ,   c.
  //
  procedure SetCurveComment(c:Integer; const aComment:LongString);       virtual; abstract;
  //
  // 38   -      t   c.
  //                  X.
  //
  function  CurveGetIndexAt(c:Integer; t:Double):Integer;                virtual; abstract;
  //
  // 39   -    c   t.
  //                  X.
  //
  function  CurveInterpolateAt(c:Integer; t:Double):Double;              virtual; abstract;
  //
  // 40   -   c   t   Window,   
  //         K(x)=(1-x^k1)^k2. Power -      Power=-1.
  //                  X.
  //
  function  CurveSmoothAt(c:Integer; t:Double;
                        Window:Double; Power,K1,K2:Integer):Double;      virtual; abstract;
  //
  // 41   -    c    [i..j].
  //          aIndex   aValue .
  //            0=Shell,1=Quick.
  //
  function  CurveMedianaAt(c,i,j:Integer; var aIndex:Integer; var aValue:Double;
                         SortMethod:Integer=1):Boolean;                  virtual; abstract;
  //
  // 42   -     " "  ..
  //           cfXXXX.
  //
  function  CurveFlags(c:Integer; AbsEps:Double=0;RelEps:Double=1E-10;
                       Small:Integer=2):LongInt;                         virtual; abstract;
  //
  // 43   -      c2   c1.
  //
  procedure CurveAssign(c1,c2:Integer);                                  virtual; abstract;
  //
  // 44   -    c1    c2.
  //
  procedure CurveCatenate(c1,c2:Integer);                                virtual; abstract;
  //
  // 45  -    w    , , , .
  //          .
  //
  function  CreateCurve(w:Integer; const aName:ShortString='';
                        aColor:Integer=0;  aStyle:Integer=0;
                        aComment:LongString=''):Integer;                 virtual; abstract;
  //
  // 46  -   c,   Flags,   sfXXXX.
  //         ,     
  //        .   ,     
  //         ,     .
  //           0=Shell,1=Quick.
  //
  procedure CurveSort(c:Integer; Flags:Integer=0; AbsEps:Double=0;
                      RelEps:Double=1E-10; Method:Integer=0);            virtual; abstract;
  //
  // 47   -   ,     c.
  //
  function  GetCurveLimits(c:Integer):TRect2D;                           virtual; abstract;
  //
  // 48   -   c  ,  .
  //
  procedure CurveIntegrate(c:Integer; AFreeConst:Double=0);              virtual; abstract;
  //
  // 49   -   c,  .
  //
  procedure CurveDifferentiate(c:Integer);                               virtual; abstract;
  //
  // 50   -    c   .
  //
  procedure CurveMedianFiltr(c:Integer; Width:Integer=1;
                             AbsEps:Double=0; RelEps:Double=1E-10);      virtual; abstract;
  //
  // 51   -    (a,b)  c.
  //
  function  GetCurveIntegral(c:Integer; a,b:Double):Double;              virtual; abstract;
  //
  // 52   -     c.
  //
  function  GetCurveLastPoint(c:Integer):TPoint2D;                       virtual; abstract;
 public
  property  WindowCaption[w:Integer] : ShortString read GetWindowCaption write SetWindowCaption;
  property  WindowTitle[w:Integer]   : ShortString read GetWindowTitle   write SetWindowTitle;
  property  WindowLegend[w:Integer]  : ShortString read GetWindowLegend  write SetWindowLegend;
  property  WindowRoi[w:Integer]     : TRect2D     read GetWindowRoi     write SetWindowRoi;
  property  WindowComment[w:Integer] : LongString  read GetWindowComment write SetWindowComment;
  property  SelectedCurve[w:Integer] : Integer     read GetSelectedCurve write SetSelectedCurve;
  property  CurvesCount[w:Integer]   : Integer     read GetCurvesCount   write SetCurvesCount;
  property  CurveLength[c:Integer]   : Integer     read GetCurveLength   write SetCurveLength;
  property  CurvePoint[c,i:Integer]  : TPoint2D    read GetCurvePoint    write SetCurvePoint;
  property  CurveName[c:Integer]     : ShortString read GetCurveName     write SetCurveName;
  property  CurveColor[c:Integer]    : Integer     read GetCurveColor    write SetCurveColor;
  property  CurveStyle[c:Integer]    : Integer     read GetCurveStyle    write SetCurveStyle;
  property  CurveComment[c:Integer]  : LongString  read GetCurveComment  write SetCurveComment;
  property  CurveLimits[c:Integer]   : TRect2D     read GetCurveLimits;
  property  CurveLastPoint[c:Integer]: TPoint2D    read GetCurveLastPoint;
 end;
 //
 //   ,     /.
 //
function  CompareDoubles(Data,Key1,Key2:Pointer):Integer;
function  KeyOfDoubles(Data:Pointer; KeyIndex:Integer):Pointer;
procedure SwapDoubles(Data:Pointer; i,j:Integer);
 //
 // Dump/undump routines to be used with MIME
 // For example:
 //  var x,y:double; i,j:integer; s:string;
 //  s:=mime_encode(r2dump(x)+r2dump(y)+i2dump(i)+i2dump(j));
 //  s:=mime_decode(s);
 //  x:=dump2r(copy(s,1,8));
 //  y:=dump2r(copy(s,9,8));
 //  i:=dump2i(copy(s,17,4));
 //  j:=dump2i(copy(s,21,4));
 //
function c2dump(const x:Char):LongString;
function b2dump(const x:Boolean):LongString;
function i2dump(const x:Integer):LongString;
function r2dump(const x:Double):LongString;
function x2dump(var x; Size:Integer):LongString;
function dump2c(const x:LongString):Char;
function dump2b(const x:LongString):Boolean;
function dump2i(const x:LongString):Integer;
function dump2r(const x:LongString):Double;

procedure ResetFpu;
procedure FpuSetExceptions(TurnOn : Boolean);
function  PatchBug_cwChop(OnOff:Boolean):Boolean;

implementation

function CompareDoubles(Data,Key1,Key2:Pointer):Integer;
begin
 if Double(Key1^)<Double(Key2^) then Result:=-1 else
 if Double(Key1^)>Double(Key2^) then Result:=+1 else Result:= 0;
end;

function KeyOfDoubles(Data:Pointer; KeyIndex:Integer):Pointer;
begin
 Result:=@TDoubleArray(Data^)[KeyIndex];
end;

procedure SwapDoubles(Data:Pointer; i,j:Integer);
var dummy:Double;
begin
 dummy:=TDoubleArray(Data^)[i];
 TDoubleArray(Data^)[i]:=TDoubleArray(Data^)[j];
 TDoubleArray(Data^)[j]:=dummy;
end;

function c2dump(const x:Char):LongString;
begin
 SetString(Result,PChar(@x),sizeof(x));
end;

function b2dump(const x:Boolean):LongString;
begin
 SetString(Result,PChar(@x),sizeof(x));
end;

function i2dump(const x:Integer):LongString;
begin
 SetString(Result,PChar(@x),sizeof(x));
end;

function r2dump(const x:Double):LongString;
begin
 SetString(Result,PChar(@x),sizeof(x));
end;

function x2dump(var x; Size:Integer):LongString;
begin
 SetString(Result,PChar(@x),Size);
end;

procedure SafeMove(const Source; var Dest; Count: LongInt);
begin
 if (Count>0) and (@Source<>nil) and (@Dest<>nil) then Move(Source,Dest,Count);
end;

function dump2b(const x:LongString):Boolean;
begin
 Result:=false;
 SafeMove(x[1],Result,min(sizeof(Result),Length(x)));
end;

function dump2c(const x:LongString):Char;
begin
 Result:=#0;
 SafeMove(x[1],Result,min(sizeof(Result),Length(x)));
end;

function dump2i(const x:LongString):Integer;
begin
 Result:=0;
 SafeMove(x[1],Result,min(sizeof(Result),Length(x)));
end;

function dump2r(const x:LongString):Double;
begin
 Result:=0;
 SafeMove(x[1],Result,min(sizeof(Result),Length(x)));
end;

procedure ResetFpu;
begin
 FpuSetExceptions(false);
 PatchBug_cwChop(true);
end;

const
 MaskAllIntr        = $133F;
 Saved8087CW : word = $133F;

function IncPtr(Base:Pointer; ByteOffset:LongInt):Pointer; register;
asm
 ADD EAX,EDX
end;

procedure FpuSetExceptions(TurnOn : Boolean);
begin
 if TurnOn then Set8087CW(Saved8087CW) else Set8087CW(MaskAllIntr);
end;

function PatchBug_cwChop(OnOff:Boolean):Boolean;
type
 TPatch = packed record
  cwChop    : Word;
  Dummy     : Word;
  two2neg32 : Double;
 end;
const
 cwChops : packed array[Boolean] of Word = ($1F3F, $1F32);
var
 Patch:^TPatch;
begin
 Result:=false;
 Patch:=IncPtr(@Default8087CW,$30);
 try
  if Patch.cwChop=cwChops[OnOff] then
  if Patch.two2neg32=((1.0/$10000) / $10000) then begin
   Patch.cwChop:=cwChops[not OnOff];
   Result:=true;
  end else begin
   if Default8087CW=0 then              // 00 This stuff uses
   if HeapAllocFlags=0 then             // 04 only to link
   if DebugHook=0 then                  // 08 variables & functions
   if JITEnable=0 then                  // 0C to give known cwChop
   if NoErrMsg then                     // 10 offset
   if VarDispProc=nil then              // 14
   if DispCallByIDProc=nil then         // 18
   if LibModuleList=nil then            // 1C
   if ModuleUnloadList=nil then         // 20, MemoryManager 24
   if trunc(Random)=0 then;             // 30 cwChop, 34 two2neg32
  end;
 except
  Result:=false;
 end;
end;

begin

 Saved8087CW := Default8087CW;
 if isLibrary then begin
  HeapAllocFlags := GMEM_MOVEABLE + GMEM_ZEROINIT;
  ResetFpu;
 end;

end.
