 {
 ***********************************************************************
 Daq Pascal application program WebSrv.
 Web server for CRW-DAQ (Daq Pascal part).
 Principle of client-server interaction is like that:
 Client(IE) ---> TinyWeb ---> WebSrv.cgi ---> WebSrv.Pas(CRW-DAQ)
 Click URL  HTTP         CGI             Pipe  `->send the message to clients
                                              @HTTP_REQUEST_ACCEPTED=...
                                              Wait until Reply ready ...
                                              Somebody put HTML text to Reply
                                              and Chr(0) as EndOfText marker.
 Client(IE) <--- TinyWeb <--- WebSrv.cgi <--- WebSrv.Pas(CRW-DAQ)
 See HTML   HTTP         CGI             Pipe
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|Command list: StdIn "@cmd=arg" or "@cmd arg"
|******************************************************
| @DebugEcho=n   - Switch HTTP debug echo page On/Off.
| @Browse n      - Call HTML browser to explore site n.
|                  If n is empty, see http://localhost/
|                  If n starts from '/' char, replace /
|                  with home site,like in this example:
|                  /index.html ->  http://host/index.html
| @HTTP_REQUEST_ACCEPTED=sender,reqtime,request,reply
|                - in DebugEcho mode generate HTTP echo
|                  Web page to see HTTP request params.
|                  See Message list for details.
|******************************************************
|Message list:
|******************************************************
| @HTTP_REQUEST_ACCEPTED=sender,reqtime,request,reply
|  sender  - Name of Web server device,who sent message.
|  reqtime - Request time in milliseconds,like  msecnow.
|  request - Request text id,to use in text_getln calls.
|  reply   - Reply   text id,to put HTML via text_addln.
|            Note that text_addln(Chr(0)) uses to notify
|            Web server that HTML text is ready.        
|  Server send the message to ClientList after each HTTP
|  request. ONE of clients should analize request text &
|  add HTML code to reply text,then put Chr(0) to inform
|  server that HTML document ready to send to Web server
|  Example:
|  @HTTP_REQUEST_ACCEPTED=&WEBSRV,63295844422438,1049397,1049374
|******************************************************
|Example of HTTP request:
|******************************************************
|   QUERY.COUNT=1
|   QUERY.ITEM0=action=echo
|   COOKIE.COUNT=2
|   COOKIE.ITEM0=RemoteUserName=fhJW7Y1eSfmCNvuGEe2w9eiQC0C/85woHa+uirM8qlM
|   COOKIE.ITEM1=RemotePassword=GXY0lxYhBnDAYD5w77TaASAf6F+//gI50OXam/QBVoM
|   CONTENT.COUNT=2
|   CONTENT.ITEM0=RemoteUserName=root
|   CONTENT.ITEM1=RemotePassword=123
|   GATEWAY_INTERFACE=CGI/1.1
|   REQUEST_METHOD=GET
|   QUERY_STRING=action=echo
|   CONTENT=RemoteUserName=root&RemotePassword=123
|   CONTENT_LENGTH=26
|   SERVER_NAME=RITLABS S.R.L.
|   SERVER_PORT=23816
|   SERVER_PROTOCOL=HTTP/1.1
|   SERVER_SOFTWARE=TinyWeb/1.93
|   REMOTE_HOST=localhost
|   REMOTE_ADDR=127.0.0.1
|   SCRIPT_NAME=/cgi-bin/websrv.cgi
|   PATH_INFO=/websrv.cgi
|   PATH_TRANSLATED=D:\DAQ32\DEMO_WEB4DAQ\websrv.cgi
|   WEBSRV.NAME=&WEBSRV
|   WEBSRV.SITE=http://main/
|   WEBSRV.ROOT=D:\DAQ32\DEMO_WEB4DAQ
|   WEBSRV.PORT=80
|   WEBSRV.INDEX=D:\DAQ32\DEMO_WEB4DAQ\INDEX.HTML
|******************************************************
|Configuration:
|******************************************************
|;*************************
|;*** WEB SERVER CONFIG ***
|;*************************
|***********************************************************************
|[DeviceList]                           ; Fix=Fixed, Var=Variable params
|&WebSrv = device software program      ; Fix &WebSrv device declaration
|[&WebSrv]                              ; Fix &WebSrv device section
|Comment       = WEB server for CRW-DAQ ; Fix &WebSrv device description
|InquiryPeriod = 1                      ; Var &WebSrv device poll period
|DevicePolling = 10, tpNormal           ; Var &WebSrv thread poll period
|ProgramSource = ~~\Resource\DaqSite\WebServer\websrv.pas
|WebScriptExe  = ~~\Resource\DaqSite\WebServer\websrv.exe
|WebScriptPath = ..\cgi-bin\websrv.cgi  ; Fix Location of cgi-bin script
|WebServerPath = ..\cgi-bin\web4daq.exe ; Fix Location of Web server bin
|WebRoot       = ..\index.html          ; Fix Location of main index.html
|WebPort       = 80                     ; Var Web server port, HTTP = 80
|WebPoll       = 60000                  ; Var Web server poll period, ms
|PipeSection   = [&WebSrv.Pipe]         ; Fix Section where pipe options
|PipeName      = WebSrv%Pid%            ; Fix Pipe name uses for CGI I/O
|PipeIniFile   = .\WebSrv.ini           ; Fix Pipe file, to set PipeName
|ClientList    = &WebSrv                ; Var List of clients (self too)
|OpenConsole   = 1                      ; Var 0/1/2=NO/SHOW/HIDE console
|DebugFlags    = 15                     ; Var 1/2/4/8= : ! > <  messages
|StdInFifo     = 128                    ; Var StdIn  FIFO size (console)
|StdOutFifo    = 128                    ; Var StdOut FIFO size (console)
|[&WebSrv.Pipe]                         ; Fix Section to set pipe params
|FifoSize      = 128                    ; Var Pipe uses FIFO size, in kB
|TimeOut       = 5000                   ; Var Timeout to wait CGI answer
|PipePolling   = 10, tpHigher           ; Var Pipe polling thread params
|[ConfigFileList]                       ; Fix Should include PipeIniFile
|ConfigFile    =  .\WebSrv.ini          ; Fix File uses to init PipeName
|[] 
|***********************************************************************
[]
 }
program WebSrv;                  { Web Server                       }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 DefWebPort   = 80;              { Default WebPort value            }
 DefWebPoll   = 60000;           { Default WebPoll value            }
 MaxLineLen   = 4096;            { Max line length                  }
 SendTimeOut  = 2000;            { TimeOut to send messages         }
 KillTimeOut  = 500;             { TimeOut to kill web server       }
 KillMethods  = '340';           { Kill methods,see task_kill       }
 WaitFactor   = 0.75;            { Wait reply factor*TimeOut        }
 NotifyAlive  = False;           { Print alive notification         }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 DebugEcho    : Boolean;         { FOR DEBUGGING ONLY               }
 ComIn_Buff   : String;          { Temporary variable               }
 ComIn_Line   : String;          { Temporary variable               }
 Reply_Line   : String;          { Temporary variable               }
 TheWEB       : record           { Web server data                  }
  DateTime    : String;          { Server date & time string        }
  PipeName    : String;          { Pipe uses by server              }
  PipeSect    : String;          { Pipe section                     }
  PipeFile    : String;          { Pipe *.ini file                  }
  FifoSize    : Integer;         { Pipe fifo size, kB               }
  Timeout     : Integer;         { Pipe timeout                     }
  Server      : String;          { WEB server *.exe path            }
  CgiBin      : String;          { WEB script *.cgi path            }
  CgiExe      : String;          { WEB script *.exe path            }
  CgiIni      : String;          { WEB script *.ini path            }
  SrvExe      : String;          { WEB server *.exe path            }
  Viewer      : String;          { WEB viewer for *.htm             }
  Index       : String;          { WEB server main index.html       }
  Timer       : Integer;         { Timer to check WEB task          }
  Root        : String;          { WEB server root path             }
  Site        : String;          { Site http://server:port/         }
  Port        : Integer;         { WEB server port                  }
  Tid         : Integer;         { WEB task ID                      }
  Reply       : Integer;         { Text of HTTP reply               }
  Request     : Integer;         { Text of HTTP request             }
  ReqTime     : Real;            { Time of AcceptRequest            }
  Clients     : Integer;         { List of registered clients       }
 end;

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {
 Get integer parameter by name aName from aText list of "Name=Value" items.
 }
 function GetIntegerVar(aText:Integer; aName:String; var aValue:Integer):Boolean;
 var r:Real; s:String;
 begin
  s:='';
  aValue:=0;
  GetIntegerVar:=False;
  if GetStringVar(aText,aName,s) then begin
   r:=rVal(s);
   if not IsNan(r) and not IsInf(r) then begin
    GetIntegerVar:=True;
    aValue:=Round(r);
   end;
  end;
  s:='';
 end;
 {
 Get real parameter by name aName from aText list of "Name=Value" items.
 }
 function GetRealVar(aText:Integer; aName:String; var aValue:Real):Boolean;
 var r:Real; s:String;
 begin
  s:='';
  aValue:=0;
  GetRealVar:=False;
  if GetStringVar(aText,aName,s) then begin
   r:=rVal(s);
   if not IsNan(r) and not IsInf(r) then begin
    GetRealVar:=True;
    aValue:=r;
   end;
  end;
  s:='';
 end;
 {
 Clear HTTP reply text etc.
 }
 procedure TheWEB_ClearReply;
 begin
  Reply_Line:='';
  ClearText(TheWEB.Reply);
 end; 
 {
 Clear HTTP request text etc.
 }
 procedure TheWEB_ClearRequest;
 begin
  TheWEB.ReqTime:=0;
  ComIn_Line:='';
  ClearText(TheWEB.Request);
 end; 
 {
 Clear WEB table.
 }
 procedure TheWEB_Clear(ForceFree:Boolean);
 var b:Boolean;
 begin
  TheWEB_ClearReply;
  TheWEB_ClearRequest;
  if ForceFree then begin
   if TheWEB.Timer<>0 then b:=tm_Free(TheWEB.Timer);
   if TheWEB.Reply<>0 then b:=text_Free(TheWEB.Reply);
   if TheWEB.Request<>0 then b:=text_Free(TheWEB.Request);
   if TheWEB.Clients<>0 then b:=text_Free(TheWEB.Clients);
  end;
  TheWEB.DateTime:='';
  TheWEB.PipeName:='';
  TheWEB.PipeSect:='';
  TheWEB.PipeFile:='';
  TheWEB.FifoSize:=0;
  TheWEB.TimeOut:=0;
  TheWEB.Server:='';
  TheWEB.CgiBin:='';
  TheWEB.CgiExe:='';
  TheWEB.CgiIni:='';
  TheWEB.SrvExe:='';
  TheWEB.Viewer:='';
  TheWEB.Clients:=0;
  TheWEB.Request:=0;
  TheWEB.ReqTime:=0;
  TheWEB.Index:='';
  TheWEB.Reply:=0;
  TheWEB.Timer:=0;
  TheWEB.Root:='';
  TheWEB.Site:='';
  TheWEB.Port:=0;
  TheWEB.Tid:=0;
 end;
 {
 Prepare WEB Reply text: clear all and add headers.
 }
 procedure TheWEB_InitReply;
 var b:Boolean;
 begin
  TheWEB_ClearReply;
  b:=text_AddLn(TheWEB.Reply,'Content-Type: text/html; charset=utf-8');
  b:=text_AddLn(TheWEB.Reply,'Cache-Control: no-cache, no-store, must-revalidate');
  b:=text_AddLn(TheWEB.Reply,'Pragma: no-cache');
  b:=text_AddLn(TheWEB.Reply,'');
  b:=text_AddLn(TheWEB.Reply,'<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">');
 end; 
 {
 Initialize WEB server.
 }
 procedure TheWEB_Init;
 var i,j,k,m,p,sect:Integer; b:Boolean;
 begin
  {---Clear WEB---}
  TheWEB_Clear(false);
  {---Create WEB request,reply&client texts---}
  TheWEB.Reply:=text_New;
  TheWEB.Request:=text_New;
  TheWEB.Clients:=text_New;
  {---Init WEB server section---}
  TheWEB.PipeSect:=ReadIni('PipeSection');
  if Length(TheWEB.PipeSect)>0
  then Success('PipeSection='+TheWEB.PipeSect)
  else Trouble('PipeSection=?');
  {---Init WEB server pipe *.ini file---}
  TheWEB.PipeFile:=AdaptFileName(ReadIni('PipeIniFile'));
  if Length(TheWEB.PipeFile)>0 then begin
   TheWEB.PipeFile:=DaqFileRef(TheWEB.PipeFile,'.ini');
   Success('PipeIniFile='+TheWEB.PipeFile);
  end else Trouble('PipeIniFile=?');
  {---Init WEB server pipe name---}
  TheWEB.PipeName:=AdaptFileName(ReadIni('PipeName'));
  if (Pos('%pid%',LoCaseStr(TheWEB.PipeName))>0)
  then TheWEB.PipeName:=StringReplace(TheWEB.PipeName,'%pid%',GetEnv('CRW_DAQ_SYS_EXE_PID'),rfReplaceAll);
  if TheWEB.PipeName<>''
  then Success('PipeName='+TheWEB.PipeName)
  else Trouble('PipeName=?');
  if TheWEB.PipeName<>'' then
  if Pos('.\',TheWEB.PipeName)=1
  then Trouble('Invalid PipeName: should be without .\');
  {---Write pipe name to *.ini file---}
  if f_rewrite(TheWEB.PipeFile,1)=0 then begin
   if f_write(TheWEB.PipeSect+EOL+'PipeName='+TheWEB.PipeName+EOL)=0
   then Trouble('Could not write '+TheWEB.PipeFile);
  end else Trouble('Could not create '+TheWEB.PipeFile);
  if not f_close or (IoResult<>0)
  then Trouble('File I/O error in '+TheWEB.PipeFile);
  {---Init pipe FIFO size---}
  TheWEB.FifoSize:=Val(ReadIni(TheWEB.PipeSect+' FifoSize'));
  if TheWEB.FifoSize<=0 then TheWEB.FifoSize:=16;
  if TheWEB.FifoSize>=65536 then TheWEB.FifoSize:=65536;
  Success('FifoSize='+Str(TheWEB.FifoSize));
  {---Init pipe TimeOut---}
  TheWEB.TimeOut:=Val(ReadIni(TheWEB.PipeSect+' TimeOut'));
  if TheWEB.TimeOut<=0 then TheWEB.TimeOut:=1000;
  Success('TimeOut='+Str(TheWEB.TimeOut));
  {---Find WEB server port---}
  TheWEB.Port:=Val(ReadIni('WebPort'));
  if TheWEB.Port=0 then TheWEB.Port:=Val(ReadIni(ForceExtension(ParamStr('ProgName'),'.ini')+' [WebServer] Port'));
  if TheWEB.Port=0 then TheWEB.Port:=DefWebPort;
  Success('WebPort='+Str(TheWEB.Port));
  {---Find WEB server site---}
  TheWEB.Site:='http://'+ParamStr('HostName');
  if TheWEB.Port=DefWebPort
  then TheWEB.Site:=TheWEB.Site+'/'
  else TheWEB.Site:=TheWEB.Site+':'+Str(TheWEB.Port)+'/';
  Success('WebSite='+TheWEB.Site);
  {---Find WEB server root and index.html---}
  TheWEB.Index:=DaqFileRef(AdaptFileName(LoCaseStr(ReadIni('WebRoot'))),'.html');
  TheWEB.Root:=ExtractFilePath(TheWEB.Index);
  if DirExists(TheWEB.Root)
  then Success('WebRoot='+TheWEB.Root)
  else Trouble('Could not find WebRoot: '+TheWEB.Root);
  if FileExists(TheWEB.Index)
  then Success('WebIndex='+TheWEB.Index)
  else Trouble('Could not find WebIndex: '+TheWEB.Index);
  {---Find WEB viewer---}
  TheWEB.Viewer:=GetEnv('WantedWebBrowser');
  if IsEmptyStr(TheWEB.Viewer) then TheWEB.Viewer:=ParamStr('GetExeByFile '+TheWEB.Index);
  if Length(TheWEB.Viewer)>0 then begin
   if FileExists(TheWEB.Viewer)
   then Success('WebViewer='+TheWEB.Viewer)
   else Success('WebViewer='+TheWEB.Viewer+' - not found.');
  end else Success('Default browser not found.');
  {---Find WEB server executable---}
  TheWEB.Server:=DaqFileRef(AdaptExeFileName(DefaultExtension(ReadIni('WebServerPath'),'.exe')),'');
  TheWEB.SrvExe:=DefaultPath(AdaptExeFileName(ReadIni(ForceExtension(ParamStr('ProgName'),'.ini')
                +' [WebServer] Path')),ParamStr('HomeDir'));
  if not FileExists(TheWEB.Server) then
  if MkDir(ExtractFilePath(LoCaseStr(TheWEB.Server))) then begin
   if FileExists(TheWEB.SrvExe) then begin
    if not FileCopy(TheWEB.SrvExe+' '+LoCaseStr(TheWEB.Server))
    then Trouble('Could not copy "'+TheWEB.SrvExe+'" to "'+TheWEB.Server+'"');
   end else Trouble('Could not find file "'+TheWEB.SrvExe+'"');
  end else Trouble('Could not mkdir: '+ExtractFilePath(TheWEB.Server));
  if IsUnix and FileExists(TheWEB.Server) then begin
   p:=ExecuteProcessSafe('chmod','755 '+TheWEB.Server,'',3000);
   Assertion(p=0,'chmod 755 '+TheWEB.Server);
  end;
  if FileExists(TheWEB.Server)
  then Success('WebServerPath='+TheWEB.Server)
  else Trouble('Could not find WebServerPath: '+TheWEB.Server);
  {---Find WEB script executable---}
  TheWEB.CgiBin:=DaqFileRef(AdaptFileName(ReadIni('WebScriptPath')),'.cgi');
  TheWEB.CgiExe:=DaqFileRef(AdaptExeFileName(DefaultExtension(ReadIni('WebScriptExe'),'.exe')),'');
  if not FileExists(TheWEB.CgiBin) then
  if not MkDir(ExtractFilePath(LoCaseStr(TheWEB.CgiBin)))
  then Trouble('Could not mkdir: '+ExtractFilePath(TheWEB.CgiBin));
  if FileExists(TheWEB.CgiExe) then begin
   if not FileCopy(TheWEB.CgiExe+' '+LoCaseStr(TheWEB.CgiBin))
   then Trouble('Could not copy "'+TheWEB.CgiExe+'" to "'+TheWEB.CgiBin+'"');
  end else Trouble('Could not find file "'+TheWEB.CgiExe+'"');
  if IsUnix and FileExists(TheWEB.CgiBin) then begin
   p:=ExecuteProcessSafe('chmod','755 '+TheWEB.CgiBin,'',3000);
   Assertion(p=0,'chmod 755 '+TheWEB.CgiBin);
  end;
  if FileExists(TheWEB.CgiBin)
  then Success('WebScriptPath='+TheWEB.CgiBin)
  else Trouble('Could not find WebScriptPath: '+TheWEB.CgiBin);
  {---Create WEB script *.ini file---}
  TheWEB.CgiIni:=ForceExtension(TheWEB.CgiBin,'.ini');
  if f_rewrite(LoCaseStr(TheWEB.CgiIni),1)=0 then begin
   if f_write('[Pipe]'+EOL+
              'PipeName=.\'+TheWEB.PipeName+EOL+
              'FifoSize='+Str(TheWEB.FifoSize)+EOL+
              'TimeOut='+Str(TheWEB.TimeOut)+EOL)=0
   then Trouble('Could not write '+TheWEB.CgiIni);
  end else Trouble('Could not create '+TheWEB.CgiIni);
  if not f_close or (IoResult<>0)
  then Trouble('File I/O error in '+TheWEB.CgiIni);
  {---Initialize WEB timer---}
  TheWEB.Timer:=tm_new;
  p:=Val(ReadIni('WebPoll'));
  if p<=0 then p:=DefWebPoll;
  if not tm_addint(TheWEB.Timer,p) then Trouble('tm_addint fails.');
  if not tm_start(TheWEB.Timer) then Trouble('tm_start fails.');
  {---Initialize WEB clients---}
  b:=text_Addln(TheWEB.Clients,DevName);
  sect:=ReadIniSection(text_New,28,'','');
  for i:=0 to text_NumLn(sect)-1 do begin
   p:=Pos('=',text_GetLn(sect,i));
   if IsSameText(Trim(Copy(text_GetLn(sect,i),1,p-1)),'ClientList') then
   for j:=1 to WordCount(Copy(text_GetLn(sect,i),p+1)) do begin
    k:=RefFind('Device '+ExtractWord(j,Copy(text_GetLn(sect,i),p+1)));
    if (k<>0) then begin
     for m:=text_NumLn(TheWEB.Clients)-1 downto 0 do
     if IsSameText(text_GetLn(TheWEB.Clients,m),RefInfo(k,'Name'))
     then b:=text_DelLn(TheWEB.Clients,m);
     b:=text_Addln(TheWEB.Clients,RefInfo(k,'Name'));
    end else Trouble('Could not find client '+Copy(text_GetLn(sect,i),p+1));
   end;
  end;
  b:=text_Free(sect);
  for i:=0 to text_NumLn(TheWEB.Clients)-1 do Success('ClientList#'+Str(i)+'='+text_GetLn(TheWEB.Clients,i));
 end;
 {
 Stop WEB server task if one started.
 }
 procedure TheWEB_Stop;
 var b:Boolean; i,m:Integer;
 begin
  if TheWEB.Tid>0 then begin
   if task_wait(TheWEB.Tid,0) then begin
    for i:=1 to Length(KillMethods) do
    if task_wait(TheWEB.Tid,0) then begin
     m:=Val(Copy(KillMethods,i,1));
     b:=task_kill(TheWEB.Tid,m,0,KillTimeOut);
     if task_wait(TheWEB.Tid,0)
     then Success('WEB Server '+Str(task_pid(TheWEB.Tid))+' kill mode = '+Str(m)+' - ignore')
     else Success('WEB Server '+Str(task_pid(TheWEB.Tid))+' kill mode = '+Str(m)+' - killed');
    end;
    Success('WEB Server exit code = '+Str(task_result(TheWEB.Tid)));
   end;
   b:=task_free(TheWEB.Tid);
   b:=SetEnv('WEB4DAQ_PIPENAME','');
   b:=SetEnv('WEB4DAQ_FIFOSIZE','');
   b:=SetEnv('WEB4DAQ_TIMEOUT','');
  end;
  TheWEB.Tid:=0;
  if ComClose then Success('Pipe '+TheWEB.PipeName+' closed.');
  TheWEB_ClearRequest;
  TheWEB_ClearReply;
 end;
 {
 Finalize WEB server.
 }
 procedure TheWEB_Free;
 begin
  TheWEB_Stop;
  TheWEB_Clear(True);
 end;
 {
 Start WEB server if one not started.
 }
 procedure TheWEB_Start;
 var i,j:Integer; b:Boolean;
 begin
  if TheWEB.Tid=0 then begin
   {
   Prepare environment variables
   }
   b:=SetEnv('WEB4DAQ_PIPENAME','.\'+TheWEB.PipeName);
   b:=SetEnv('WEB4DAQ_FIFOSIZE',Str(TheWEB.FifoSize));
   b:=SetEnv('WEB4DAQ_TIMEOUT',Str(TheWEB.TimeOut));
   {
   Initialize Web server task, run it invisible...
   }
   TheWEB.Tid:=task_init('"'+TheWEB.Server+'" "'+TheWEB.Root+'" '+Str(TheWEB.Port));
   if pos('?',task_ctrl(TheWEB.Tid,'HomeDir='+ExtractFilePath(ParamStr('DaqBackupFile')))
             +task_ctrl(TheWEB.Tid,'Display=0')
          )>0
   then begin
    Trouble('User task setup error!');
    TheWEB_Stop;
   end;
   {
   Run task if one was created...
   }
   if TheWEB.Tid>0 then
   if task_run(TheWEB.Tid) then begin
    Success('TaskId  = '+str(TheWEB.Tid));
    Success('TaskPid = '+str(task_pid(TheWEB.Tid)));
    Success('TaskRef = '+str(task_ref(TheWEB.Tid)));
    Success('CmdLine = '+task_ctrl(TheWEB.Tid,'CmdLine'));
    Success('HomeDir = '+task_ctrl(TheWEB.Tid,'HomeDir'));
    Success('PipeIn  = '+task_ctrl(TheWEB.Tid,'StdInPipeSize'));
    Success('PipeOut = '+task_ctrl(TheWEB.Tid,'StdOutPipeSize'));
    Success('Display = '+task_ctrl(TheWEB.Tid,'Display'));
   end else begin
    Trouble('Could not start WEB Server!');
    TheWEB_Stop;
   end;
   {
   Open pipe to interact with CGI script.
   }
   if ComOpen(TheWEB.PipeSect)
   then Success('Pipe '+TheWEB.PipeName+' opened.')
   else begin
    Trouble('Could not open pipe '+TheWEB.PipeName);
    TheWEB_Stop;
   end;
   {
   Start Ok?
   }
   if TheWEB.Tid>0 then begin
    TheWEB.DateTime:=GetDateTime(mSecNow);
    Success('Web server '+Str(task_pid(TheWEB.Tid))+' started at '+TheWEB.DateTime);
   end;
  end;
 end;
 {
 WEB server polling.
 }
 procedure TheWEB_Poll;
 begin
  {
  If WEB server on DAQ start.
  If WEB server is not started, try to start periodically.
  }
  if TheWEB.Tid=0 then begin
   if RunCount=2 then TheWEB_Start;
   if tm_Event(TheWEB.Timer) then TheWEB_Start;
  end;
  {
  If WEB server is started, but not running, fix bug.
  }
  if TheWEB.Tid>0 then
  if task_wait(TheWEB.Tid,0) then begin
   if tm_Event(TheWEB.Timer) then begin
    TheWEB.DateTime:=GetDateTime(mSecNow);
    if NotifyAlive then
    Success('Web server '+Str(task_pid(TheWEB.Tid))+' is still alive at '+TheWEB.DateTime);
   end;
  end else begin
   TheWEB.DateTime:=GetDateTime(mSecNow);
   Trouble('Web server '+Str(task_pid(TheWEB.Tid))+' died with exit code '
          +Str(task_result(TheWEB.Tid))+' at '+TheWEB.DateTime);
   TheWEB_Stop;
  end;
 end;
 {
 Accept HTTP request: initialize reply and send @HTTP_REQUEST_ACCEPTED to ClientList.
 In DebugEcho mode send @HTTP_REQUEST_ACCEPTED message for himself only.
 Also clear pipe input buffer to ignore any text after Chr(0) marker.
 }
 procedure TheWEB_AcceptRequest;
 var i:Integer; b:Boolean;
 begin
  TheWEB_InitReply;
  TheWEB.ReqTime:=msecnow;
  TheWEB.DateTime:=GetDateTime(mSecNow);
  b:=text_Addln(TheWEB.Request,'WEBSRV.NAME='+DevName);
  b:=text_Addln(TheWEB.Request,'WEBSRV.SITE='+TheWEB.Site);
  b:=text_Addln(TheWEB.Request,'WEBSRV.ROOT='+TheWEB.Root);
  b:=text_Addln(TheWEB.Request,'WEBSRV.PORT='+Str(TheWEB.Port));
  b:=text_Addln(TheWEB.Request,'WEBSRV.INDEX='+TheWEB.Index);
  Success('HTTP request received at '+TheWEB.DateTime);
  if DebugFlagEnabled(dfViewImp) then
  for i:=0 to text_NumLn(TheWEB.Request)-1 do ViewImp('CGI: '+text_GetLn(TheWEB.Request,i));
  for i:=0 to text_NumLn(TheWEB.Clients)-1 do
  if IsSameText(text_GetLn(TheWEB.Clients,i),DevName) or not DebugEcho then
  if DevSendMsg(text_GetLn(TheWEB.Clients,i)+' @HTTP_REQUEST_ACCEPTED='+DevName+','+Str(TheWEB.ReqTime)
                                     +','+Str(TheWEB.Request)+','+Str(TheWEB.Reply)+EOL)=0
  then Trouble('Failed DevSendMsg '+text_GetLn(TheWEB.Clients,i));
  while ComCount>0 do ComIn_Buff:=ComRead(255);
  ComIn_Buff:='';
 end;
 {
 Accept HTTP reply: send reply text to pipe and clear reply & request.
 }
 procedure TheWEB_AcceptReply;
 var i,Lost:Integer; ms:Real; b:Boolean;
 begin
  Success('HTTP reply ready, '+Str(msecnow-TheWEB.ReqTime)+' ms elapsed.');
  if DebugFlagEnabled(dfViewExp) then
  for i:=0 to text_NumLn(TheWEB.Reply)-2 do ViewExp('CGI: '+text_GetLn(TheWEB.Reply,i));
  if text_NumLn(TheWEB.Reply)>0 then
  if ComSpace>0 then begin
   Lost:=0;
   ms:=msecnow;
   for i:=0 to text_NumLn(TheWEB.Reply)-1 do begin
    Reply_Line:=text_GetLn(TheWEB.Reply,i)+EOL;
    if ComSpace<Length(Reply_Line) then
    while (msecnow-ms<SendTimeOut) and (ComSpace<Length(Reply_Line)) do b:=Sleep(1);
    if not ComWrite(Reply_Line) then Lost:=Lost+Length(Reply_Line);
   end;
   if Lost>0 then Trouble('CGI: Send error, '+Str(Lost)+' byte(s) lost!');
  end else Trouble('CGI: not connected.');
  TheWEB_ClearRequest;
  TheWEB_ClearReply;
 end;
 {
 Add string to TheWEB.Reply text.
 }
 procedure TheWEB_Reply(s:String);
 var b:Boolean;
 begin
  b:=text_Addln(TheWEB.Reply,s);
 end;
 {
 Send this page on TimeOut.
 }
 procedure TheWEB_TimeOutPage;
 var b:Boolean;
 begin
  TheWEB_InitReply;
  TheWEB_Reply('<html>');
  TheWEB_Reply('<head>');
  TheWEB_Reply('<title>Error!</title>');
  TheWEB_Reply('</head>');
  TheWEB_Reply('<body>');
  TheWEB_Reply('<hr>');
  TheWEB_Reply('<font color="red"><h1>Error!</h1></font>');
  TheWEB_Reply('<hr>');
  TheWEB_Reply('Timeout detected, no reply from DAQ CGI script!');
  TheWEB_Reply('<hr>');
  TheWEB_Reply('</body>');
  TheWEB_Reply('</html>');
  TheWEB_Reply(dump(0)); {Notify that HTML page ready!}
 end;
 {
 Send this HTTP echo page in DebugEcho mode, for tests only.
 }
 procedure TheWEB_EchoPage(RequestText,ReplyText:Integer);
 var i:Integer; b:Boolean;
 begin
  b:=text_Addln(ReplyText,'<html>');
  b:=text_Addln(ReplyText,'<head>');
  b:=text_Addln(ReplyText,'<title>HTTP echo</title>');
  b:=text_Addln(ReplyText,'</head>');
  b:=text_Addln(ReplyText,'<body>');
  b:=text_Addln(ReplyText,'<hr>');
  b:=text_Addln(ReplyText,'<font color="red"><h1>HTTP request echo</h1></font>');
  b:=text_Addln(ReplyText,'<hr>');
  b:=text_Addln(ReplyText,'<pre>');
  for i:=0 to text_Numln(RequestText)-1 do
  b:=text_Addln(ReplyText,'   '+text_Getln(RequestText,i));
  b:=text_Addln(ReplyText,'</pre>');
  b:=text_Addln(ReplyText,'<hr>');
  b:=text_Addln(ReplyText,'</body>');
  b:=text_Addln(ReplyText,'</html>');
  b:=text_Addln(ReplyText,dump(0));
 end;
 {
 Pipe polling to get request from  CGI script.
 }
 procedure TheCGI_Poll;
 var p:Integer; EndOfText:Boolean;
 begin
  {
  If server do not wait answer to previous request, read pipe etc.
  }
  if TheWEB.ReqTime=0 then begin
   {
   Read COM port: data coming from CGI script pipe.
   }
   while (ComCount>0) and (Length(ComIn_Buff)<MaxLineLen) do ComIn_Buff:=ComIn_Buff+ComRead(255);
   {
   Extract and process lines with CR,LF delimiter.
   }
   EndOfText:=False;
   repeat
    p:=PosEol(ComIn_Buff,1,0);
    if (p>0) then begin
     ComIn_Line:=Copy(ComIn_Buff,1,p-1);
     ComIn_Buff:=Copy(ComIn_Buff,PosEol(ComIn_Buff,p,1));
     if Pos(Chr(0),ComIn_Line)=0 then begin
      if not text_AddLn(TheWEB.Request,ComIn_Line)
      then Trouble('Could not add request line.');
     end else EndOfText:=True;
    end;
   until (p=0) or EndOfText;
   {
   Check if incoming line is too long.
   }
   if Length(ComIn_Buff)>=MaxLineLen then begin
    Trouble('Input line is too long!');
    ComIn_Buff:='';
   end;
   {
   Chr(0) means that CGI script stop data transfer.
   We should accept request.
   }
   if Pos(Chr(0),ComIn_Buff)>0 then EndOfText:=True;
   if EndOfText then TheWEB_AcceptRequest;
  end;
  {
  If request accepted, wait for answer.
  }
  if TheWEB.ReqTime>0 then begin
   {
   Ignore any pipe input while handle request.
   }
   while ComCount>0 do ComIn_Buff:=ComRead(255);
   ComIn_Buff:='';
   {
   Show error page if timeout detected.
   }
   if msecnow-TheWEB.ReqTime>TheWEB.TimeOut*WaitFactor then TheWEB_TimeOutPage;
   {
   If last text line of Reply contains #0, user finished with reply, accept it.
   }
   if text_NumLn(TheWEB.Reply)>0 then
   if Pos(Chr(0),text_GetLn(TheWEB.Reply,text_NumLn(TheWEB.Reply)-1))>0 then TheWEB_AcceptReply;
  end;
 end;
 {
 Handle @HTTP_REQUEST_ACCEPTED=ArgList message.
 ArgList is Sender,RequestTime,RequestText,ReplyText.
 Client should analyse RequestText, and put HTML page
 to ReplyText. Last line of ReplyText should be dump(0).
 }
 procedure TheWEB_HandleRequest(Msg:String);
 const MessageId='@HTTP_REQUEST_ACCEPTED';
 var Sender,Request,Reply:Integer; ReqTime:Real;
 begin
  Msg:=Trim(Msg);
  if IsSameText(ExtractWord(1,Msg),MessageId) then begin
   Msg:=Copy(Msg,Length(MessageId)+2);
   Sender:=RefFind('Device '+ExtractWord(1,Msg));
   ReqTime:=rVal(ExtractWord(2,Msg));
   Request:=Val(ExtractWord(3,Msg));
   Reply:=Val(ExtractWord(4,Msg));
   if IsSameText(RefInfo(Sender,'Type'),'Device') and
      IsSameText(RefInfo(Request,'Type'),'Text') and
      IsSameText(RefInfo(Reply,'Type'),'Text') and
      not IsNaN(ReqTime) and not IsInf(ReqTime)
   then begin
    {
    Now Sender,Request,Reply checked and ready
    We should use Request information, add HTML
    page text and dump(0) as end-marker to Reply.
    }
    if DebugEcho then TheWEB_EchoPage(Request,Reply);
   end else Trouble('Invalid HTTP request: '+Msg);
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ComIn_Buff:='';
  ComIn_Line:='';
  Reply_Line:='';
  TheWEB_Clear(false);
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  DebugEcho:=False;
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,MaxInt,0);
  Success('WEB server initialization:');
  TheWEB_Init;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  TheWEB_Free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  TheCGI_Poll;
  TheWEB_Poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; i,p,sect:Integer; t:Real; b:Boolean;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {}
   if IsSameText(cmd,'@DebugEcho') then begin
    if not IsNan(rVal(arg)) then DebugEcho:=(rVal(arg)>0);
    Success(cmd+'='+Str(Ord(DebugEcho)));
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@HTTP_REQUEST_ACCEPTED') then begin
    TheWEB_HandleRequest(Data);
    Data:='';
   end else
   {}
   if IsSameText(cmd,'@BROWSE') then begin
    if IsEmptyStr(arg) then begin
     if (TheWEB.Port=80)
     then arg:='http://localhost/'
     else arg:='http://localhost:'+Str(TheWEB.Port)+'/';
    end;
    if Copy(arg,1,1)='/' then arg:=TheWEB.Site+Copy(arg,2);
    if FileExists(TheWEB.Viewer) then begin
     p:=task_init('"'+TheWEB.Viewer+'" "'+arg+'"');
     if task_run(p)
     then Success('Start pid '+Str(task_pid(p))+': '+task_ctrl(p,'CmdLine'))
     else Success('Could not browse '+arg);
     b:=task_Free(p);
    end else begin
     if ShellExecute('open|'+arg)<=32
     then Success('Could not open '+arg);
    end;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
