#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

################################################################
## Make UniHeater`s configuration with specified parameters.  ##
################################################################

function fatal(){
 unix tooltip-notifier text "$scriptname: $2" preset stdError delay 60000;
 1>&2 echo -ne "\n$2\n\n";
 exit $1;
};
function call(){
 if [ $# -gt 0 ]; then
  eval "$@";
 fi;
};

source "$(dirname $(realpath ${BASH_SOURCE[0]}))/$(basename ${BASH_SOURCE[0]} | sed 's/_make/_init/')";
if [ -z "$UH_PrefixName" ]; then fatal 1 "Error: not defined UH_PrefixName."; fi;

################################
# Current script identification.
################################
declare startupdir="$(pwd -LP)";
declare scriptfile="${BASH_SOURCE[0]}";
declare scriptname="$(basename $scriptfile)";
declare scriptbase="$(basename $scriptfile .sh)";
declare scripthome="$(dirname  $scriptfile)";
declare scriptFILE="$(realpath $scriptfile)";
declare scriptHOME="$(dirname  $scriptFILE)";

function  MakeUniHeater(){
 call "$scriptHOME/${scriptbase/_make/_zero}.sh";
 cp -fvu $CRW_DAQ_SYS_HOME_DIR/resource/daqsite/uniheater/uniheater_make.sh ./;
 chmod ugo+x ./uniheater_make.sh;
 call ./uniheater_make.sh $UH_PrefixName $UH_NumHeaters $UH_TileNumber;
};

function uniheater_make(){
 if pushd "$scriptHOME" >/dev/null 2>&1; then
  call MakeUniHeater
 fi;
 popd >/dev/null 2>&1;
};

uniheater_make "$@";

##############
## END OF FILE
##############
