@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion

call :Main %*
goto :EOF

:Main
chcp 65001 > nul
set Bitmaps=..\Bitmaps
set Bitmaps=~~\Resource\DaqSite\UniHeat\Bitmaps
call :UniHeatTable 8  8  > "%~dp0uh_8.crc"
call :UniHeatTable 16 8  > "%~dp0uh_16.crc"
call :UniHeatTable 24 8  > "%~dp0uh_24.crc"
call :UniHeatTable 32 8  > "%~dp0uh_32.crc"
call :UniHeatTable 10 10 > "%~dp0uh_10.crc"
call :UniHeatTable 20 10 > "%~dp0uh_20.crc"
call :UniHeatTable 30 10 > "%~dp0uh_30.crc"
call :UniHeatProperties  > "%~dp0uh_prop.crc"
goto :EOF

:UniHeatTable
call :GeneralMap %1
for /L %%n in (1,1,%1) do call :UniHeat %%n %2
goto :EOF

:GeneralMap
echo [Circuit]
echo GeneralMap = %Bitmaps%\UH_%1.BMP
echo Name = ***_КОНТРОЛЬ_НАГРЕВАТЕЛЕЙ_UNIHEAT_***
echo Hint = UniHeat: Панель контроля нагревателей
echo []
echo.
echo [LedNarrowFont]
echo CharSet = 204
echo Color   = $000000
echo Height  = -13
echo Name    = PT Sans Narrow
echo Pitch   = Default
echo Style   = []
echo []
echo.
echo [BigLedFont]
echo CharSet = 204
echo Color   = $000000
echo Height  = -20
echo Name    = PT Mono
echo Pitch   = Fixed
echo Style   = [Bold]
echo []
echo.
goto :EOF

:UniHeat
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
set /a dx=( ( %~1 - 1 ) %% %~2 ) * 125
set /a dy=( ( %~1 - 1 ) /  %~2 ) * 119
echo ;**********************
echo ;  Universal Heater %1
echo ;**********************
echo.
set /a x=!dx!+30
set /a y=!dy!+6
echo [SensorList]
echo Sensor = UH_PROP%1
echo [UH_PROP%1]
echo Pos = !x!, !y!
echo LED = 7, 0, 0, %%7s, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7G.BMP
echo Hint = UniHeat: Наименование нагревателя %1
echo []
echo.
set /a x=!dx!+4
set /a y=!dy!+30
echo [SensorList]
echo Sensor = UH_BT%1
echo [UH_BT%1]
echo Pos = !x!, !y!
echo Tag#1 = 0, %Bitmaps%\UH_BT0.BMP
echo Tag#2 = 1, %Bitmaps%\UH_BT1.BMP
echo Tag#3 = 2, %Bitmaps%\UH_BT2.BMP
echo Tag#4 = 3, %Bitmaps%\UH_BT3.BMP
echo Tag#5 = 4, %Bitmaps%\UH_BT4.BMP
echo tag#6 = 5, %Bitmaps%\UH_BT5.BMP
echo Hint = UniHeat: Кнопка включения нагревателя %1
echo []
echo.
set /a x=!dx!+59
set /a y=!dy!+31
echo [SensorList]
echo Sensor = UH_TNUM%1
echo [UH_TNUM%1]
echo Pos = !x!, !y!
echo LED = 2, 0, 0, *, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED2W.BMP
echo Hint = UniHeat: Номер температурного канала нагревателя %1
echo []
echo.
set /a x=!dx!+44
set /a y=!dy!+52
echo [SensorList]
echo Sensor = UH_TNAME%1
echo [UH_TNAME%1]
echo Pos = !x!, !y!
echo LED = 4, 0, 0, *, [LedNarrowFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED4G.BMP
echo Hint = UniHeat: Имя температурного канала нагревателя %1
echo []
echo.
set /a x=!dx!+30
set /a y=!dy!+71
echo [SensorList]
echo Sensor = UH_TGOAL%1
echo [UH_TGOAL%1]
echo Pos = !x!, !y!
echo LED = 7, 1, 0, %%7.1f, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7W.BMP
echo Hint = UniHeat: Целевая температура нагревателя %1, °C
echo []
echo.
set /a x=!dx!+30
set /a y=!dy!+93
echo [SensorList]
echo Sensor = UH_TREAL%1
echo [UH_TREAL%1]
echo Pos = !x!, !y!
echo LED = 7, 1, 0, %%7.1f, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7C.BMP
echo Hint = UniHeat: Реальная температура нагревателя %1, °C
echo []
echo.
set /a x=!dx!+104
set /a y=!dy!+31
echo [SensorList]
echo Sensor = UH_GATE%1
echo [UH_GATE%1]
echo Pos = !x!, !y!
echo Tag#1 = 0, %Bitmaps%\UH_GATE0.BMP
echo Tag#2 = 1, %Bitmaps%\UH_GATE1.BMP
echo Hint = UniHeat: Индикатор сигнала на включение нагревателя %1
echo []
echo.
set /a x=!dx!+104
set /a y=!dy!+50
echo [SensorList]
echo Sensor = UH_BLK%1
echo [UH_BLK%1]
echo Pos = !x!, !y!
echo Tag#1 = 0, %Bitmaps%\UH_GATE0.BMP
echo Tag#2 = 1, %Bitmaps%\UH_GATE1.BMP
echo Hint = UniHeat: Индикатор сигнала блокировки нагревателя %1
echo []
echo.
set /a x=!dx!+6
set /a y=!dy!+7
echo [SensorList]
echo Sensor = UH_HENABL%1
echo [UH_HENABL%1]
echo Pos = !x!, !y!
echo LED = 0, 0, 0, *, [LedNarrowFont]
echo Tag#1 = 0, %Bitmaps%\UH_ENABLE0.BMP     Off
echo Tag#2 = 1, %Bitmaps%\UH_ENABLE1.BMP     On
echo Hint = UniHeat: Включение (разрешение) нагревателя %1
echo []
echo.
goto :EOF

:UniHeatProperties
echo [Circuit]
echo GeneralMap = %Bitmaps%\UH_PROP.BMP
echo Name = ***_НАСТРОЙКА_НАГРЕВАТЕЛЕЙ_UNIHEAT_***
echo Hint = UniHeat: Настройка нагревателей
echo []
echo.
echo [LedNarrowFont]
echo CharSet = 204
echo Color   = $000000
echo Height  = -16
echo Name    = PT Sans
echo Pitch   = Default
echo Style   = []
echo []
echo.
echo [BigLedFont]
echo CharSet = 204
echo Color   = $000000
echo Height  = -20
echo Name    = PT Mono
echo Pitch   = Fixed
echo Style   = [Bold]
echo []
echo.
echo [ButtonFont]
echo CharSet = 204
echo Color   = $000000
echo Height  = -13
echo Name    = PT Mono
echo Pitch   = Fixed
echo Style   = [Bold]
echo []
echo.
echo [BoxFont]
echo CharSet = 204
echo Color   = $000000
echo Height  = -13
echo Name    = PT Mono
echo Pitch   = Fixed
echo Style   = [Bold]
echo []
echo.
echo [SensorList]
echo Sensor = UH_HENABLX
echo [UH_HENABLX]
echo Pos = 10, 15
echo LED = 0, 0, 0, *, [BoxFont]
echo Tag#1 = 0, %Bitmaps%\UH_ENABLE0.BMP     X
echo Tag#2 = 1, %Bitmaps%\UH_ENABLE1.BMP     V
echo Hint = UniHeat: Разрешение работы нагревателя
echo []
echo.
echo [SensorList]
echo Sensor = UH_HNAMEX
echo [UH_HNAMEX]
echo Pos = 169, 15
echo LED = 7, 0, 0, %%7s, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7G.BMP
echo Hint = UniHeat: Наименование нагревателя
echo []
echo.
echo [SensorList]
echo Sensor = UH_PENABLX
echo [UH_PENABLX]
echo Pos = 10, 55
echo LED = 0, 0, 0, *, [BoxFont]
echo Tag#1 = 0, %Bitmaps%\UH_ENABLE0.BMP     X
echo Tag#2 = 1, %Bitmaps%\UH_ENABLE1.BMP     V
echo Hint = UniHeat: Разрешение блокировки по давлению
echo []
echo.
echo [SensorList]
echo Sensor = UH_PBLKX
echo [UH_PBLKX]
echo Pos = 36, 76
echo LED = 7, 1, 0, %%7.1f, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7W.BMP
echo Hint = UniHeat: Верхнее давление блокировки
echo []
echo.
echo [SensorList]
echo Sensor = UH_PREALX
echo [UH_PREALX]
echo Pos = 36, 98
echo LED = 7, 1, 0, %%7.1f, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7C.BMP
echo Hint = UniHeat: Реальное (текущее) давление
echo []
echo.
echo [SensorList]
echo Sensor = UH_PNAMEX
echo [UH_PNAMEX]
echo Pos = 36, 120
echo LED = 5, 0, 0, *, [LedNarrowFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED5G.BMP
echo Hint = UniHeat: Имя датчика давления блокировки
echo []
echo.
echo [SensorList]
echo Sensor = UH_PNUMX
echo [UH_PNUMX]
echo Pos = 102, 120
echo LED = 2, 0, 0, *, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED2W.BMP
echo Hint = UniHeat: Номер датчика давления блокировки
echo []
echo.
echo [SensorList]
echo Sensor = UH_TENABLX
echo [UH_TENABLX]
echo Pos = 10, 145
echo LED = 0, 0, 0, *, [BoxFont]
echo Tag#1 = 0, %Bitmaps%\UH_ENABLE0.BMP     X
echo Tag#2 = 1, %Bitmaps%\UH_ENABLE1.BMP     V
echo Hint = UniHeat: Разрешение блокировки по температуре
echo []
echo.
echo [SensorList]
echo Sensor = UH_TBLKX
echo [UH_TBLKX]
echo Pos = 36, 166
echo LED = 7, 1, 0, %%7.1f, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7W.BMP
echo Hint = UniHeat: Верхняя тепература блокировки, °C
echo []
echo.
echo [SensorList]
echo Sensor = UH_TREALX
echo [UH_TREALX]
echo Pos = 36, 188
echo LED = 7, 1, 0, %%7.1f, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7C.BMP
echo Hint = UniHeat: Реальная (текущая) температура, °C
echo []
echo.
echo [SensorList]
echo Sensor = UH_TNAMEX
echo [UH_TNAMEX]
echo Pos = 36, 210
echo LED = 4, 0, 0, *, [LedNarrowFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED5G.BMP
echo Hint = UniHeat: Имя датчика температуры блокировки
echo []
echo.
echo [SensorList]
echo Sensor = UH_TNUMX
echo [UH_TNUMX]
echo Pos = 102, 210
echo LED = 2, 0, 0, *, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED2W.BMP
echo Hint = UniHeat: Номер датчика температуры блокировки
echo []
echo.
echo [SensorList]
echo Sensor = UH_WENABLX
echo [UH_WENABLX]
echo Pos = 10, 235
echo LED = 0, 0, 0, *, [BoxFont]
echo Tag#1 = 0, %Bitmaps%\UH_ENABLE0.BMP     X
echo Tag#2 = 1, %Bitmaps%\UH_ENABLE1.BMP     V
echo Hint = UniHeat: Разрешение блокировки по таймеру
echo []
echo.
echo [SensorList]
echo Sensor = UH_WDTX
echo [UH_WDTX]
echo Pos = 69, 256
echo LED = 4, 1, 0, %%4.1f, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED4W.BMP
echo Hint = UniHeat: Сторожевой таймер, сек
echo []
echo.
echo [SensorList]
echo Sensor = UH_MODE
echo [UH_MODE]
echo Pos = 142, 59
echo LED = 0, 0, 0, *, [BoxFont]
echo Tag#1 = 0, %Bitmaps%\UH_MODE0.BMP
echo Tag#2 = 1, %Bitmaps%\UH_MODE1.BMP
echo Hint = UniHeat: Режим работы нагревателя
echo []
echo.
echo [SensorList]
echo Sensor = UH_MODE_N
echo [UH_MODE_N]
echo Pos = 165, 59
echo LED = 0, 0, 0, *, [BoxFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7G.BMP     Нагрев
echo Tag#2 = 1, %Bitmaps%\UH_LED7G.BMP     Охлаждение
echo Hint = UniHeat: Режим работы нагревателя
echo []
echo.
echo [SensorList]
echo Sensor = UH_TGOALX
echo [UH_TGOALX]
echo Pos = 165, 110
echo LED = 7, 1, 0, %%7.1f, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7W.BMP
echo Hint = UniHeat: Целевая тепература стабилизации, °C
echo []
echo.
echo [SensorList]
echo Sensor = UH_DT2X
echo [UH_DT2X]
echo Pos = 165, 132
echo LED = 7, 1, 0, %%7.1f, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7W.BMP
echo Hint = UniHeat: dT2 - Верхний порог температуры, °C
echo []
echo.
echo [SensorList]
echo Sensor = UH_DT1X
echo [UH_DT1X]
echo Pos = 165, 154
echo LED = 7, 1, 0, %%7.1f, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7W.BMP
echo Hint = UniHeat: dT1 - Нижний порог температуры, °C
echo []
echo.
echo [SensorList]
echo Sensor = UH_Q1X
echo [UH_Q1X]
echo Pos = 165, 212
echo LED = 7, 1, 0, %%7.1f, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7W.BMP
echo Hint = UniHeat: Q1 - мощность начального нагрева
echo []
echo.
echo [SensorList]
echo Sensor = UH_Q2X
echo [UH_Q2X]
echo Pos = 165, 234
echo LED = 7, 1, 0, %%7.1f, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7W.BMP
echo Hint = UniHeat: Q2 - мощность медленного нагрева (dT1)
echo []
echo.
echo [SensorList]
echo Sensor = UH_Q3X
echo [UH_Q3X]
echo Pos = 165, 256
echo LED = 7, 1, 0, %%7.1f, [BigLedFont]
echo Tag#1 = 0, %Bitmaps%\UH_LED7W.BMP
echo Hint = UniHeat: Q3 - мощность легкого подогрева (dT2)
echo []
echo.
echo [SensorList]
echo Sensor = UH_SOUNDX
echo [UH_SOUNDX]
echo Pos = 10, 297
echo Tag#1 = 0, %Bitmaps%\UH_SND0.BMP
echo Tag#2 = 1, %Bitmaps%\UH_SND1.BMP
echo Hint = UniHeat: Разрешение звуковых эффектов
echo []
echo.
echo [SensorList]
echo Sensor = UH_CHECKX
echo [UH_CHECKX]
echo Pos = 70, 295
echo LED = 0, 0, 0, *
echo Tag#1 = 0, %Bitmaps%\UH_BTN.BMP     Применить
echo Hint = UniHeat: Применить внесенные изменения
echo []
echo.
echo [SensorList]
echo Sensor = UH_CANCELX
echo [UH_CANCELX]
echo Pos = 168, 295
echo LED = 0, 0, 0, *
echo Tag#1 = 0, %Bitmaps%\UH_BTN.BMP     Отмена
echo Hint = UniHeat: Отменить внесенные изменения
echo []
echo.
echo [SensorList]
echo Sensor = UH_SAVEINIX
echo [UH_SAVEINIX]
echo Pos = 345, 303
echo Tag#1 = 0, %Bitmaps%\UH_INI.BMP     Запись
echo Hint = UniHeat: Записать параметры в INI файл
echo []
echo.
echo [SensorList]
echo Sensor = UH_LOADINIX
echo [UH_LOADINIX]
echo Pos = 402, 303
echo Tag#1 = 0, %Bitmaps%\UH_INI.BMP     Чтение
echo Hint = UniHeat: Прочитать параметры из INI файла
echo []
goto :EOF
