 {
 Functions for SysLog.
 function SeverityOfTrouble:Integer;
 function SeverityOfProblem:Integer;
 function SeverityOfFailure:Integer;
 function SeverityOfSuccess:Integer;
 function SeverityOfSucceed:Integer;
 function SeverityOfViewExp:Integer;
 function SeverityOfViewImp:Integer;
 function SeverityOfDetails:Integer;
 procedure InitSysLogInternals;
 procedure FreeSysLogInternals;
 }
 {
 Severity of Trouble/Problem/Success depends of RunCount.
 }
 function SeverityOfTrouble:Integer;
 begin
  if Starting then SeverityOfTrouble:=SeverityOfTroubleStarting else
  if Stopping then SeverityOfTrouble:=SeverityOfTroubleStopping else
  if Polling  then SeverityOfTrouble:=SeverityOfTroublePolling  else
  SeverityOfTrouble:=sev_OFF;
 end;
 function SeverityOfProblem:Integer;
 begin
  if Starting then SeverityOfProblem:=SeverityOfProblemStarting else
  if Stopping then SeverityOfProblem:=SeverityOfProblemStopping else
  if Polling  then SeverityOfProblem:=SeverityOfProblemPolling  else
  SeverityOfProblem:=sev_OFF;
 end;
 function SeverityOfFailure:Integer;
 begin
  if Starting then SeverityOfFailure:=SeverityOfFailureStarting else
  if Stopping then SeverityOfFailure:=SeverityOfFailureStopping else
  if Polling  then SeverityOfFailure:=SeverityOfFailurePolling  else
  SeverityOfFailure:=sev_OFF;
 end;
 function SeverityOfSuccess:Integer;
 begin
  if Starting then SeverityOfSuccess:=SeverityOfSuccessStarting else
  if Stopping then SeverityOfSuccess:=SeverityOfSuccessStopping else
  if Polling  then SeverityOfSuccess:=SeverityOfSuccessPolling  else
  SeverityOfSuccess:=sev_OFF;
 end;
 function SeverityOfSucceed:Integer;
 begin
  if Starting then SeverityOfSucceed:=SeverityOfSucceedStarting else
  if Stopping then SeverityOfSucceed:=SeverityOfSucceedStopping else
  if Polling  then SeverityOfSucceed:=SeverityOfSucceedPolling  else
  SeverityOfSucceed:=sev_OFF;
 end;
 function SeverityOfViewExp:Integer;
 begin
  if Starting then SeverityOfViewExp:=SeverityOfViewExpStarting else
  if Stopping then SeverityOfViewExp:=SeverityOfViewExpStopping else
  if Polling  then SeverityOfViewExp:=SeverityOfViewExpPolling  else
  SeverityOfViewExp:=sev_OFF;
 end;
 function SeverityOfViewImp:Integer;
 begin
  if Starting then SeverityOfViewImp:=SeverityOfViewImpStarting else
  if Stopping then SeverityOfViewImp:=SeverityOfViewImpStopping else
  if Polling  then SeverityOfViewImp:=SeverityOfViewImpPolling  else
  SeverityOfViewImp:=sev_OFF;
 end;
 function SeverityOfDetails:Integer;
 begin
  if Starting then SeverityOfDetails:=SeverityOfDetailsStarting else
  if Stopping then SeverityOfDetails:=SeverityOfDetailsStopping else
  if Polling  then SeverityOfDetails:=SeverityOfDetailsStarting else
  SeverityOfDetails:=sev_OFF;
 end;
 {
 Init SysLog internals.
 }
 procedure InitSysLogInternals;
  procedure ReadSev(var sev:Integer; id:String);
  var rv:Real;
  begin
   id:=Trim(ReadIni(ParamStr('SysIniFile')+' [DAQ.SysLog.Severity.Settings] '+id));
   if (id<>'') then rv:=rValDef(ParamStr('SysLogSeverityCode '+id),sev) else rv:=-1;
   if (rv>=sev_DEBUG) and (rv<=sev_OFF) then sev:=Round(rv);
  end;
 begin
  // Default severity values
  SeverityOfTroubleStarting := sev_Failure;
  SeverityOfTroubleStopping := sev_Failure;
  SeverityOfTroublePolling  := sev_Trouble;
  SeverityOfProblemStarting := sev_Fail;
  SeverityOfProblemStopping := sev_Fail;
  SeverityOfProblemPolling  := sev_Problem;
  SeverityOfFailureStarting := sev_Failure;
  SeverityOfFailureStopping := sev_Failure;
  SeverityOfFailurePolling  := sev_Trouble;
  SeverityOfSuccessStarting := sev_Print;
  SeverityOfSuccessStopping := sev_Print;
  SeverityOfSuccessPolling  := sev_Print;
  SeverityOfSucceedStarting := sev_Success;
  SeverityOfSucceedStopping := sev_Success;
  SeverityOfSucceedPolling  := sev_Print;
  SeverityOfViewImpStarting := sev_ViewImp;
  SeverityOfViewImpStopping := sev_ViewImp;
  SeverityOfViewImpPolling  := sev_ViewImp;
  SeverityOfViewExpStarting := sev_ViewExp;
  SeverityOfViewExpStopping := sev_ViewExp;
  SeverityOfViewExpPolling  := sev_ViewExp;
  SeverityOfDetailsStarting := sev_Details;
  SeverityOfDetailsStopping := sev_Details;
  SeverityOfDetailsPolling  := sev_Details;
  // Load values from INI file
  ReadSev( SeverityOfTroubleStarting , 'SeverityOfTroubleStarting' );
  ReadSev( SeverityOfTroubleStopping , 'SeverityOfTroubleStopping' );
  ReadSev( SeverityOfTroublePolling  , 'SeverityOfTroublePolling'  );
  ReadSev( SeverityOfProblemStarting , 'SeverityOfProblemStarting' );
  ReadSev( SeverityOfProblemStopping , 'SeverityOfProblemStopping' );
  ReadSev( SeverityOfProblemPolling  , 'SeverityOfProblemPolling'  );
  ReadSev( SeverityOfFailureStarting , 'SeverityOfFailureStarting' );
  ReadSev( SeverityOfFailureStopping , 'SeverityOfFailureStopping' );
  ReadSev( SeverityOfFailurePolling  , 'SeverityOfFailurePolling'  );
  ReadSev( SeverityOfSuccessStarting , 'SeverityOfSuccessStarting' );
  ReadSev( SeverityOfSuccessStopping , 'SeverityOfSuccessStopping' );
  ReadSev( SeverityOfSuccessPolling  , 'SeverityOfSuccessPolling'  );
  ReadSev( SeverityOfSucceedStarting , 'SeverityOfSucceedStarting' );
  ReadSev( SeverityOfSucceedStopping , 'SeverityOfSucceedStopping' );
  ReadSev( SeverityOfSucceedPolling  , 'SeverityOfSucceedPolling'  );
  ReadSev( SeverityOfViewImpStarting , 'SeverityOfViewImpStarting' );
  ReadSev( SeverityOfViewImpStopping , 'SeverityOfViewImpStopping' );
  ReadSev( SeverityOfViewImpPolling  , 'SeverityOfViewImpPolling'  );
  ReadSev( SeverityOfViewExpStarting , 'SeverityOfViewExpStarting' );
  ReadSev( SeverityOfViewExpStopping , 'SeverityOfViewExpStopping' );
  ReadSev( SeverityOfViewExpPolling  , 'SeverityOfViewExpPolling'  );
  ReadSev( SeverityOfDetailsStarting , 'SeverityOfDetailsStarting' );
  ReadSev( SeverityOfDetailsStopping , 'SeverityOfDetailsStopping' );
  ReadSev( SeverityOfDetailsPolling  , 'SeverityOfDetailsPolling'  ); 
 end;
 {
 Free SysLog internals.
 }
 procedure FreeSysLogInternals;
 begin
 end;
