 {
 Standard routines for Library:
 procedure ClearStdLibrary;
 procedure InitStdLibrary;
 procedure FreeStdLibrary;
 procedure PollStdLibrary;
 procedure StdIn_DefaultHandler(var Data,cmd,arg:String);
 }
 {$I _fun_StdErrors}             { Standard functions for Errors    }
 {$I _fun_StdStrings}            { Standard functions for Strings   }
 {$I _fun_StdConsole}            { Standard functions for Console   }
 {$I _fun_StdDevices}            { Standard functions for Devices   }
 {$I _fun_StdCurves}             { Standard functions for Curves    }
 {$I _fun_StdSounds}             { Standard functions for Sounds    }
 {$I _fun_StdVector}             { Standard functions for Vector    }
 {$I _fun_StdTags}               { Standard functions for Tags      }
 {$I _fun_StdTimes}              { Standard functions for Times     }
 {$I _fun_StdTexts}              { Standard functions for Texts     }
 {$I _fun_StdTools}              { Standard functions for Tools     }
 {$I _fun_StdTasks}              { Standard functions for Tasks     }
 {$I _fun_StdPipes}              { Standard functions for Pipes     }
 {$I _fun_StdEdits}              { Standard functions for Edits     }
 {$I _fun_StdDims}               { Standard functions for Dims      }
 {$I _fun_StdWebs}               { Standard functions for Webs      }
 {$I _fun_StdDLLs}               { Standard functions for DLLs      }
 {$I _fun_StdUtils}              { Standard functions for Utils     }
 {$I _fun_StdDiesel}             { Standard functions for Diesel    }
 {$I _fun_StdAddons}             { Standard functions for Addons    }
 {
 Clearing...
 }
 procedure ClearStdLibrary;
 begin
  ClearStdErrors;
  ClearStdStrings;
  ClearStdConsole;
  ClearStdDevices;
  ClearStdCurves;
  ClearStdSounds;
  ClearStdVector;
  ClearStdTags;
  ClearStdTimes;
  ClearStdTexts;
  ClearStdTools;
  ClearStdTasks;
  ClearStdPipes;
  ClearStdEdits;
  ClearStdDims;
  ClearStdWebs;
  ClearStdDLLs;
  ClearStdUtils;
  ClearStdDiesel;
  ClearStdAddons;
 end;
 {
 Initialization...
 }
 procedure InitStdLibrary;
  procedure DefaultPostMortalWill;
  var sec,i:Integer;
   procedure Check(sec:Integer;cfg,pmw:String);
   begin
    if not IsEmptyStr(pmw) then
    if IsEmptyText(sec) then iNul(ReadIniSection(sec,12,cfg,pmw));
   end;
  begin
   sec:=text_New;
   if IsEmptyText(sec) then Check(sec,ParamStr('DaqConfigFile'),Trim(ReadIni('PostMortalWill')));
   if IsEmptyText(sec) then Check(sec,ParamStr('DaqConfigFile'),Trim(ReadIni('[DAQ] PostMortalWill')));
   if IsEmptyText(sec) then Check(sec,ParamStr('DaqConfigFile'),'[DAQ.Devices.Default.PostMortalWill]');
   if IsEmptyText(sec) then Check(sec,ParamStr('SysIniFile'),'[DAQ.Devices.Default.PostMortalWill]');
   iNul(Text_StrReplace(sec,'$DeviceName$',DevName,3));
   iNul(Text_StrReplace(sec,'%DeviceName%',DevName,3));
   if not IsEmptyText(sec) then
   if GetTextLength(sec)<16*1024 then begin
    PostMortalWill:=TextToString(sec);
    Details('[PostMortalWill]');
    for i:=0 to text_NumLn(sec) do Details(text_GetLn(sec,i));
    Details('[]');
   end;
   bNul(text_Free(sec));
  end;
  procedure DefaultFatal(var x:Integer; Name:String);
  var n:Integer;
   procedure Check(s:String);
   begin
    if not IsEmptyStr(s) then if n<0 then n:=iValDef(s,n);
   end;
  begin
   n:=-1;
   if n<0 then Check(ReadIni(Name));
   if n<0 then Check(ReadIni('[DAQ] '+Name));
   if n<0 then Check(ReadIni(ParamStr('SysIniFile')+' [DaqSys] '+Name));
   if n>=0 then x:=n;
  end;
 begin
  InitStdErrors;
  InitStdStrings;
  InitStdConsole;
  InitStdDevices;
  InitStdCurves;
  InitStdSounds;
  InitStdVector;
  InitStdTags;
  InitStdTimes;
  InitStdTexts;
  InitStdTools;
  InitStdTasks;
  InitStdPipes;
  InitStdEdits;
  InitStdDims;
  InitStdWebs;
  InitStdDLLs;
  InitStdUtils;
  InitStdDiesel;
  InitStdAddons;
  DefaultPostMortalWill;
  DefaultFatal(FatalMaxAvail,'FatalMaxAvail');
  DefaultFatal(FatalVitalBugs,'FatalVitalBugs');
  DefaultFatal(FatalHangsBugs,'FatalHangsBugs');
  bNul(text_Addln(StdIn_HelpLines,' @Help          - This help.'));
  bNul(text_Addln(StdIn_HelpLines,' @Eval ex       - Evaluate expression ex.'));
  bNul(text_Addln(StdIn_HelpLines,' @DebugFlags n  - Enable console messages: 1=Trouble,'));
  bNul(text_Addln(StdIn_HelpLines,'                  2=Success,   4=ViewImp,  8=ViewExp.'));
  bNul(text_Addln(StdIn_HelpLines,' @CpuProfiler c - c=Start/Stop/View CPU% load profiler.'));
  bNul(text_Addln(StdIn_HelpLines,' @StartupScript - Run StartupScript commands.'));
  bNul(text_Addln(StdIn_HelpLines,' @FinallyScript - Run FinallyScript commands.'));
  bNul(text_Addln(StdIn_HelpLines,' @Cron cmd      - Post command cmd to &CronSrv server.'));
  bNul(text_Addln(StdIn_HelpLines,' @Async cmd     - Execute command cmd asynchronously.'));
  bNul(text_Addln(StdIn_HelpLines,' @Speak s       - Speak text s with speech engine.'));
  bNul(text_Addln(StdIn_HelpLines,' @Voice s       - Play sound s with wave sound player.'));
  bNul(text_Addln(StdIn_HelpLines,' @DevMsg &d s   - Send message s to device &d and awake.'));
  bNul(text_Addln(StdIn_HelpLines,' @DevSend &d s  - Send message s to device &d and awake.'));
  bNul(text_Addln(StdIn_HelpLines,' @DevPost &d s  - Post message s to device &d not awake.'));
  bNul(text_Addln(StdIn_HelpLines,' @DevSendMsg &d s Send message s to device &d and awake.'));
  bNul(text_Addln(StdIn_HelpLines,' @DevPostMsg &d s Post message s to device &d not awake.'));
  bNul(text_Addln(StdIn_HelpLines,' @WinHide w     - Hide window w.'));
  bNul(text_Addln(StdIn_HelpLines,' @WinShow w     - Show window w.'));
  bNul(text_Addln(StdIn_HelpLines,' @WinDraw w|o   - Draw window w with options o.'));
  bNul(text_Addln(StdIn_HelpLines,' @WinSelect w   - Show and select window w.'));
  bNul(text_Addln(StdIn_HelpLines,' @SilentEval n  - 0/1=verbose/silent @SysEval evaluation mode.'));
  bNul(text_Addln(StdIn_HelpLines,' @SysEval ex    - Evaluate expression ex globally, i.e. @Eval @System @Async ex.'));
  bNul(text_Addln(StdIn_HelpLines,' @LoadIni       - load params from INI file.'));
  bNul(text_Addln(StdIn_HelpLines,' @SaveIni       - save params to   INI file.'));
  bNul(text_Addln(StdIn_HelpLines,' @DimGuiClick   - handle remote DIM GUI click.'));
  bNul(text_Addln(StdIn_HelpLines,' @ParamStr      - print ParamStr(arg) in device console to get information.'));
  bNul(text_Addln(StdIn_HelpLines,' @Local arg     - post message (arg) locally, like @Async (to self console).'));
  bNul(text_Addln(StdIn_HelpLines,' @Remote arg    - post message (arg) remotely, via Dim_GuiConsoleSend().'));
  bNul(text_Addln(StdIn_HelpLines,' @Tooltip arg   - show tooltip (popup window) with message specified by arg.'));
  bNul(text_Addln(StdIn_HelpLines,' @OpenConsole d - open console window for device (d) or current device.'));
  bNul(text_Addln(StdIn_HelpLines,' @BrowseHelp f  - open HTM help file (f) or ([DAQ] HelpFile) if (f) is empty.'));
  bNul(text_Addln(StdIn_HelpLines,' @DimServiceUp  - message comes on DIM service up (connected).'));
  bNul(text_Addln(StdIn_HelpLines,' @DimServiceDie - message comes on DIM service die (disconnect).'));
  cmd_Std_Help          := RegisterStdInCmd('@Help',          '');
  cmd_Std_Eval          := RegisterStdInCmd('@Eval',          '');
  cmd_Std_DebugFlags    := RegisterStdInCmd('@DebugFlags',    '');
  cmd_Std_CpuProfiler   := RegisterStdInCmd('@CpuProfiler',   '');
  cmd_Std_StartupScript := RegisterStdInCmd('@StartupScript', '');
  cmd_Std_FinallyScript := RegisterStdInCmd('@FinallyScript', '');
  cmd_Std_Cron          := RegisterStdInCmd('@Cron',          '');
  cmd_Std_Async         := RegisterStdInCmd('@Async',         '');
  cmd_Std_Speak         := RegisterStdInCmd('@Speak',         '');
  cmd_Std_Voice         := RegisterStdInCmd('@Voice',         '');
  cmd_Std_DevMsg        := RegisterStdInCmd('@DevMsg',        '');
  cmd_Std_DevSend       := RegisterStdInCmd('@DevSend',       '');
  cmd_Std_DevPost       := RegisterStdInCmd('@DevPost',       '');
  cmd_Std_DevSendMsg    := RegisterStdInCmd('@DevSendMsg',    '');
  cmd_Std_DevPostMsg    := RegisterStdInCmd('@DevPostMsg',    '');
  cmd_Std_WinHide       := RegisterStdInCmd('@WinHide',       '');
  cmd_Std_WinShow       := RegisterStdInCmd('@WinShow',       '');
  cmd_Std_WinDraw       := RegisterStdInCmd('@WinDraw',       '');
  cmd_Std_WinSelect     := RegisterStdInCmd('@WinSelect',     '');
  cmd_Std_SilentEval    := RegisterStdInCmd('@SilentEval',    '');
  cmd_Std_SysEval       := RegisterStdInCmd('@SysEval',       '');
  cmd_Std_LoadIni       := RegisterStdInCmd('@LoadIni',       '');
  cmd_Std_SaveIni       := RegisterStdInCmd('@SaveIni',       '');
  cmd_Std_DimGuiClick   := RegisterStdInCmd('@DimGuiClick',   '');
  cmd_Std_ParamStr      := RegisterStdInCmd('@ParamStr',      '');
  cmd_Std_Local         := RegisterStdInCmd('@Local',         '');
  cmd_Std_Remote        := RegisterStdInCmd('@Remote',        '');
  cmd_Std_Tooltip       := RegisterStdInCmd('@Tooltip',       '');
  cmd_Std_OpenConsole   := RegisterStdInCmd('@OpenConsole',   '');
  cmd_Std_BrowseHelp    := RegisterStdInCmd('@BrowseHelp',    '');
  cmd_Std_DimServiceUp  := RegisterStdInCmd('@DimServiceUp',  '');
  cmd_Std_DimServiceDie := RegisterStdInCmd('@DimServiceDie', '');
  StdSilentEvalMode:=false;
 end;
 {
 Finalization...
 }
 procedure FreeStdLibrary;
 begin
  FreeStdAddons;
  FreeStdDiesel;
  FreeStdUtils;
  FreeStdDLLs;
  FreeStdWebs;
  FreeStdDims;
  FreeStdEdits;
  FreeStdPipes;
  FreeStdTasks;
  FreeStdTools;
  FreeStdTexts;
  FreeStdTimes;
  FreeStdTags;
  FreeStdVector;
  FreeStdSounds;
  FreeStdCurves;
  FreeStdDevices;
  FreeStdConsole;
  FreeStdStrings;
  FreeStdErrors;
 end;
 {
 Polling...
 }
 procedure PollStdLibrary;
  procedure PrintParam(id:String); begin if not IsEmptyStr(id) then Success(id+' = '+ParamStr(id)); end;
  procedure PrintParams(arg:String); var i:Integer; begin for i:=1 to WordCount(arg) do PrintParam(ExtractWord(i,arg)); end;
 begin
  if (RunCount=2) then PrintParams('Polling.Delay,Polling.UseMsgPump,CurrentThreadID,Polling.ThreadID,Polling.Priority');
  if ShouldPollStdErrors  then PollStdErrors;
  if ShouldPollStdStrings then PollStdStrings;
  if ShouldPollStdConsole then PollStdConsole;
  if ShouldPollStdDevices then PollStdDevices;
  if ShouldPollStdCurves  then PollStdCurves;
  if ShouldPollStdSounds  then PollStdSounds;
  if ShouldPollStdVector  then PollStdVector;
  if ShouldPollStdTags    then PollStdTags;
  if ShouldPollStdTimes   then PollStdTimes;
  if ShouldPollStdTexts   then PollStdTexts;
  if ShouldPollStdTools   then PollStdTools;
  if ShouldPollStdTasks   then PollStdTasks;
  if ShouldPollStdPipes   then PollStdPipes;
  if ShouldPollStdEdits   then PollStdEdits;
  if ShouldPollStdDims    then PollStdDims;
  if ShouldPollStdWebs    then PollStdWebs;
  if ShouldPollStdDlls    then PollStdDLLs;
  if ShouldPollStdUtils   then PollStdUtils;
  if ShouldPollStdDiesel  then PollStdDiesel;
  if ShouldPollStdAddons  then PollStdAddons;
 end;
 {
 Default StdIn_Processor handler.
 }
 procedure StdIn_DefaultHandler(var Data,cmd,arg:String);
 var cmdid:Integer; r:Real; i,n:Integer;
  {
  Evaluate expression via system calculator in Main Console.
  }
  function SysEval(expr:String):Real;
  begin
   if StdSilentEvalMode
   then SysEval:=Eval('@system @async @silent '+Trim(expr))
   else SysEval:=Eval('@system @async '        +Trim(expr));
  end;
  {
  Speak, i.e. send message to speech server.
  }
  function SpeakMsg(msg:String):Integer;
  var n:Integer;
  begin
   n:=0; msg:=Trim(msg);
   if Length(msg)>0 then if devSpeakSrv<>0 then
   n:=Round(DevSend(devSpeakSrv,'@speak='+msg+EOL));
   if n>0 then Details('Speak: '+msg);
   SpeakMsg:=n;
  end;
 begin
  if Length(Data)>0 then begin
   {
   Get command Id from console command registry
   }
   cmdid:=HashList_GetLink(StdIn_CmdHashTab,cmd);
   {
   @Cron @Run -hide cmd
   }
   if (cmdid = cmd_Std_Cron) then begin
    Cron(arg);
    Data:='';
   end else
   {
   @StartupScript
   }
   if (cmdid = cmd_Std_StartupScript) then begin
    RunStartupScript;
    Data:='';
   end else
   {
   @FinallyScript
   }
   if (cmdid = cmd_Std_FinallyScript) then begin
    RunFinallyScript;
    Data:='';
   end else
   {
   @Eval=2*2
   }
   if (cmdid = cmd_Std_Eval) then begin
    r:=rEvalDef(arg,_NaN);
    Success(cmd+'='+Str(r));
    Data:='';
   end else
   {
   @SysEval @run cmd
   }
   if (cmdid = cmd_Std_SysEval) then begin
    r:=SysEval(arg);
    Success(cmd+'='+Str(r));
    Data:='';
   end else
   {
   @SilentEval 1
   }
   if (cmdid = cmd_Std_SilentEval) then begin
    StdSilentEvalMode:=(iValDef(Trim(Arg),Ord(StdSilentEvalMode))<>0);
    Success(cmd+'='+Str(Ord(StdSilentEvalMode)));
    Data:='';
   end else
   {
   @Async @Help
   }
   if (cmdid = cmd_Std_Async) then begin
    if IsEmptyStr(arg) then n:=0 else n:=Round(DevPost(devMySelf,Trim(arg)+EOL));
    if DebugFlagEnabled(dfDetails) then Details(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @DevMsg     &SpeakSrv @Speak=Hello
   @DevSend    &SpeakSrv @Speak=Hello
   @DevSendMsg &SpeakSrv @Speak=Hello
   }
   if (cmdid = cmd_Std_DevMsg)
   or (cmdid = cmd_Std_DevSend)
   or (cmdid = cmd_Std_DevSendMsg) then begin
    if IsEmptyStr(arg) then i:=0 else i:=RefFind('Device '+ExtractWord(1,arg));
    if i=0 then n:=0 else n:=Round(DevSend(i,Trim(SkipWords(1,arg))+EOL));
    if DebugFlagEnabled(dfDetails) then Details(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @DevPost    &SpeakSrv @Speak=Hello
   @DevPostMsg &SpeakSrv @Speak=Hello
   }
   if (cmdid = cmd_Std_DevPost)
   or (cmdid = cmd_Std_DevPostMsg) then begin
    if IsEmptyStr(arg) then i:=0 else i:=RefFind('Device '+ExtractWord(1,arg));
    if i=0 then n:=0 else n:=Round(DevPost(i,Trim(SkipWords(1,arg))+EOL));
    if DebugFlagEnabled(dfDetails) then Details(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @DimGuiClick=<mime_encoded_encrypted_remote_click>
   }
   if (cmdid=cmd_Std_DimGuiClick) then begin
    DIM_GuiClickDefaultHandler(arg);
    Data:='';
   end else
   {
   @Local @cmd arg
   }
   if (cmdid=cmd_Std_Local) then begin
    if not IsEmptyStr(arg) then DevPostCmdLocal(Trim(arg));
    Data:='';
   end else
   {
   @Remote @cmd arg
   }
   if (cmdid=cmd_Std_Remote) then begin
    if not IsEmptyStr(arg) then Dim_GuiConsoleSend(DevName,Trim(arg));
    Data:='';
   end else
   {
   @WinHide DEMO.GUI
   }
   if (cmdid = cmd_Std_WinHide) then begin
    if IsEmptyStr(arg) then n:=0 else n:=Ord(WinHide(Trim(arg)));
    if DebugFlagEnabled(dfDetails) then Details(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @WinShow DEMO.GUI
   }
   if (cmdid = cmd_Std_WinShow) then begin
    if IsEmptyStr(arg) then n:=0 else n:=Ord(WinShow(Trim(arg)));
    if DebugFlagEnabled(dfDetails) then Details(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @WinDraw DEMO.GUI
   }
   if (cmdid = cmd_Std_WinDraw) then begin
    if IsEmptyStr(arg) then n:=0 else n:=Ord(WinDraw(Trim(arg)));
    if DebugFlagEnabled(dfDetails) then Details(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @WinSelect DEMO.GUI
   }
   if (cmdid = cmd_Std_WinSelect) then begin
    if IsEmptyStr(arg) then n:=0 else n:=Ord(WinSelect(Trim(arg)));
    if DebugFlagEnabled(dfDetails) then Details(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @Voice Siren
   }
   if (cmdid = cmd_Std_Voice) then begin
    if IsEmptyStr(arg) then n:=0 else n:=Ord(Voice(Trim(arg)));
    if DebugFlagEnabled(dfDetails) then Details(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @Speak Hello, world!
   }
   if (cmdid = cmd_Std_Speak) then begin
    if IsEmptyStr(arg) then n:=0 else n:=SpeakMsg(Trim(arg));
    if DebugFlagEnabled(dfDetails) then Details(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @LoadIni
   }
   if (cmdid=cmd_Std_LoadIni) then begin
    n:=CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg)));
    if DebugFlagEnabled(dfDetails) then Details(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @SaveIni
   }
   if (cmdid=cmd_Std_SaveIni) then begin
    n:=CustomIniRW('W',arg,2*Ord(not IsEmptyStr(arg)));
    if DebugFlagEnabled(dfDetails) then Details(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @ParamStr
   }
   if (cmdid=cmd_Std_ParamStr) then begin
    Success(ParamStr(Trim(arg)));
    Data:='';
   end else
   {
   @CpuProfiler Stop
   @CpuProfiler View
   @CpuProfiler Start 1 60 7 0
   }
   if (cmdid = cmd_Std_CpuProfiler) then begin
    CpuProfilerProcess(arg);
    Success(cmd+'='+Str(CpuProfiler.Poll.Period/1000)+','+Str(CpuProfiler.View.Period/1000)+','
                   +Str(CpuProfiler.View.Mode)+','+Str(CpuProfiler.Poll.Stress/10/Max(1,CpuProfiler.Poll.Period)));
    Data:='';
   end else
   {
   @DebugFlags=3
   }
   if (cmdid = cmd_Std_DebugFlags) then begin
    DebugFlags:=iEvalDef(arg,DebugFlags);
    Success(cmd+'='+Str(DebugFlags));
    Data:='';
   end else
   {
   @Help
   }
   if (cmdid = cmd_Std_Help) then begin
    if WordCount(arg)>0 then begin
     if IsSameText(ExtractWord(1,arg),'echo') then StdIn_HelpEchoOn:=(iValDef(ExtractWord(2,arg),Ord(StdIn_HelpEchoOn))<>0);
     if IsSameText(ExtractWord(1,arg),'browse') then StdIn_HelpBrowseOn:=(iValDef(ExtractWord(2,arg),Ord(StdIn_HelpBrowseOn))<>0);
    end;
    ShowHelp(StdIn_HelpEchoOn);
    Data:='';
   end else
   {
   @Tooltip text "Hello world" preset stdNotify delay 15000
   }
   if (cmdid=cmd_Std_Tooltip) then begin
    if not IsEmptyStr(arg) then ShowTooltip(Trim(arg));
    Data:='';
   end else
   {
   @OpenConsole &Device
   }
   if (cmdid=cmd_Std_OpenConsole) then begin
    if IsEmptyStr(arg) then arg:=DevName;
    bNul(WinShow(ParamStr('Console '+Trim(arg))));
    bNul(WinSelect(ParamStr('Console '+Trim(arg))));
    Data:='';
   end else
   {
   @BrowseHelp ..\Help\index.htm
   }
   if (cmdid=cmd_Std_BrowseHelp) then begin
    arg:=Trim(arg);
    if IsEmptyStr(arg) then arg:=AdaptFileName(ReadIni('[DAQ] HelpFile'));
    if not IsEmptyStr(arg) then arg:=DaqFileRef(arg,'.htm');
    if not IsEmptyStr(arg) then if FileExists(arg) then begin
     if (devCronSrv<>0) then Cron('@Browse '+arg) else
     rNul(Eval('@System @Async @Silent @Run WebBrowser '+arg));
    end;
    Data:='';
   end else
   {
   @DimServiceUp Dim/Service/Name
   }
   if (cmdid=cmd_Std_DimServiceUp) then begin
    Success('DIM SERVICE UP: '+Trim(arg));
    Data:='';
   end else
   {
   @DimServiceDie Dim/Service/Name
   }
   if (cmdid=cmd_Std_DimServiceDie) then begin
    Problem('DIM SERVICE DIE: '+Trim(arg));
    Data:='';
   end else
   {
   All other strings
   }
   if Length(Data)>0 then begin
    if StdIn_StrictErr
    then Trouble(' Unrecognized command "'+Data+'".')
    else Problem(' Unrecognized command "'+Data+'".');
    Data:='';
   end;
  end;
 end;
