 {
 Standard routines for Dims:
 function  ShouldRefresh(var upd:Real; val:Real):Integer;
 function  GetStampOfTag(tag:Integer; def:Real):Real;
 function  ClickIsLocal:Boolean;
 function  ClickIsRemote:Boolean;
 function  DIM_Avail:Boolean;
 function  DIM_GuiAvail:Boolean;
 function  DIM_GuiClickAvail:Boolean;
 function  DIM_GuiClickFallBackMode:Integer;
 function  DIM_IsClientMode:Boolean;
 function  DIM_IsServerMode:Boolean;
 procedure DIM_Send(msg:String);
 procedure DIM_Post(msg:String);
 procedure DIM_UpdateTag(tag:Integer; data:String);
 function  DIM_Encrypt(Data,Key:String):String;
 function  DIM_Decrypt(Data,Key:String):String;
 function  DIM_EncryptCommand(Data:String):String;
 function  DIM_DecryptCommand(Data:String):String;
 function  DIM_EncryptAccess(Data:String):String;
 function  DIM_DecryptAccess(Data:String):String;
 function  GrantAccessDim(Guard,User,Host,IP,MAC:String):Boolean;
 function  DIM_GuardParams(Name:String):String;
 procedure DIM_GuiClickSendToServer(data:String);
 procedure DIM_GuiClickSendLoopBack(data:String);
 procedure DIM_GuiClickSend(data:String);
 function  DIM_GuiClickCopy:String;
 function  DIM_GuiClickScan(var ClickBuff:String; ParamName:String):String;
 function  DIM_GuiClickWhat(var ClickBuff:String):Integer;
 function  DIM_GuiClickPack(What,Button,X,Y:Integer; ms:Real; Device,Window,Sensor,Tag,Curve,Value:String):String;
 procedure Dim_GuiConsoleSend(DevName,data:String);
 function  Dim_GuiConsoleRecv(DevName,ClickBuff:String):String;
 procedure DIM_GuiClickDefaultHandler(arg:String);
 procedure DIM_GuiClickInit(GuiClickParams:String);
 procedure ClearStdDims;
 procedure InitStdDims;
 procedure FreeStdDims;
 procedure PollStdDims;
 }
 {
 Check if refresh needed.
 }
 function ShouldRefresh(var upd:Real; val:Real):Integer;
 begin
  ShouldRefresh:=0;
  if upd<>val then begin
   ShouldRefresh:=1;
   upd:=val;
  end;
 end;
 {
 Get stamp of tag for refreshment.
 }
 function GetStampOfTag(tag:Integer; def:Real):Real;
 var typ:Integer; v:Real;
 begin
  typ:=TypeTag(tag);
  if typ=1 then v:=iGetTag(tag) else
  if typ=2 then v:=rGetTag(tag) else
  if typ=3 then v:=HashIndexOf(sGetTag(tag),0,0) else v:=def;
  GetStampOfTag:=v;
 end;
 {
 Check if GUI click is remote or local, i.e. was received and written by ClickWrite or not.
 }
 function ClickIsLocal:Boolean;
 begin
  ClickIsLocal:=(ClickWhat>0) and (ClickWrote=0);
 end;
 function ClickIsRemote:Boolean;
 begin
  ClickIsRemote:=(ClickWhat>0) and (ClickWrote>0);
 end;
 {
 DIM available? DIM GUI available?
 }
 function DIM_Avail:Boolean;
 begin
  DIM_Avail:=(devDimSrv<>0);
 end;
 function DIM_GuiAvail:Boolean;
 begin
  DIM_GuiAvail:=(devDimSrv<>0) and (TypeTag(DIM_GuiClickTag)=3);
 end;
 function DIM_GuiClickAvail:Boolean;
 begin
  DIM_GuiClickAvail:=(TypeTag(DIM_GuiClickTag)=3);
 end;
 function DIM_GuiClickFallBackMode:Integer;
 var mode:Integer;
 begin
  mode:=0;
  if (devDimSrv=0) then mode:=-1 else
  if (TypeTag(DIM_GuiClickFallBackModeTag)=1)
  then mode:=iGetTag(DIM_GuiClickFallBackModeTag);
  DIM_GuiClickFallBackMode:=mode;
 end;
 {
 Is device declared as DIM client? Is device declared as DIM server?
 }
 function DIM_IsClientMode:Boolean;
 begin
  DIM_IsClientMode:=HasFlags(DIM_ClientServerMode,1);
 end;
 function DIM_IsServerMode:Boolean;
 begin
  DIM_IsServerMode:=HasFlags(DIM_ClientServerMode,2);
 end;
 {
 Send a message to DIM server.
 }
 procedure DIM_Send(msg:String);
 begin
  if devDimSrv<>0 then
  if Length(msg)>0 then
  if devSend(devDimSrv,msg)=0
  then Trouble('Failed devSend to '+DimSrv);
 end;
 {
 Post a message to DIM server.
 }
 procedure DIM_Post(msg:String);
 begin
  if devDimSrv<>0 then
  if Length(msg)>0 then
  if devPost(devDimSrv,msg)=0
  then Trouble('Failed devPost to '+DimSrv);
 end;
 {
 Post message to DIM server to update tag.
 Post also new tag value if data specified.
 }
 procedure DIM_UpdateTag(tag:Integer; data:String);
 begin
  if devDimSrv<>0 then
  if TypeTag(tag)>0 then begin
   if Length(data)=0
   then DIM_Post('##'+Str(tag)+EOL)
   else DIM_Post('##'+Str(tag)+'='+Mime_Encode(data)+EOL);
  end;
 end;
 {
 Encrypt/decrypt DIM data (commands, access table) by DIM_CryptKind method.
 0=CURRENT,1=Blowfish,2=Gost,3=RC2,4=RC4,5=RC5,6=RC6,7=BASE64,8=HEX,9=NONE.
 }
 function DIM_Encrypt(Data,Key:String):String;
 begin
  Cryptographer(Data,Key,True,DIM_CryptKind);
  DIM_Encrypt:=Data;
 end;
 function DIM_Decrypt(Data,Key:String):String;
 begin
  Cryptographer(Data,Key,False,DIM_CryptKind);
  DIM_Decrypt:=Data;
 end;
 function DIM_EncryptCommand(Data:String):String;
 begin
  DIM_EncryptCommand:=DIM_Encrypt(Data,'DIM-Command');
 end;
 function DIM_DecryptCommand(Data:String):String;
 begin
  DIM_DecryptCommand:=DIM_Decrypt(Data,'DIM-Command');
 end;
 function DIM_EncryptAccess(Data:String):String;
 begin
  DIM_EncryptAccess:=DIM_Encrypt(Data,'DIM-Access');
 end;
 function DIM_DecryptAccess(Data:String):String;
 begin
  DIM_DecryptAccess:=DIM_Decrypt(Data,'DIM-Access');
 end;
 {
 DIM-based grant access function.
 Check if given (Guard,User,Host,IP,MAC) have access rights.
 Device should contain "TrustedUsers = [TrustedUsers]" declaration.
 [TrustedUsers] ; Access right table. Use: * = any; . = current
 ;----------------------------------------------------------------
 ;guard      user        host            IP          MAC
 ;----------------------------------------------------------------
 *           *           *               *           *
 root        alex        crwbox          127.1.1.1   00-00-00-00-00-00
 user        dima        frodo           .           *
 guest       nina        bilbo           *           .
 ;----------------------------------------------------------------
 [] 
 }
 function GrantAccessDim(Guard,User,Host,IP,MAC:String):Boolean;
 var i:Integer; s,w1,w2,w3,w4,w5:String; g,g1,g2,g3,g4,g5:Boolean;
  function IsSameAddr(a,b:String):Boolean;
  var i,j:Integer; flag:Boolean;
  begin
   flag:=false;
   for i:=1 to WordCount(a) do for j:=1 to WordCount(b) do
   flag:=flag or IsSameText(ExtractWord(i,a),ExtractWord(j,b));
   IsSameAddr:=flag;
  end;
 begin
  g:=False;
  s:=''; w1:='';w2:='';w3:='';w4:='';w5:='';
  if (DIM_TrustedUsersList=0) then begin
   DIM_TrustedUsersList:=ReadIniSection(text_New,16,'',DIM_TrustedUsersSection);
   for i:=text_numln(DIM_TrustedUsersList)-1 downto 0 do
   if IsEmptyStr(text_GetLn(DIM_TrustedUsersList,i))
   then bNul(text_DelLn(DIM_TrustedUsersList,i));
  end;
  for i:=0 to text_numln(DIM_TrustedUsersList)-1 do
  if WordCount(text_GetLn(DIM_TrustedUsersList,i))=5 then begin
   s:=text_GetLn(DIM_TrustedUsersList,i);
   w1:=ExtractWord(1,s); if w1='.' then w1:=ParamStr('Guard');
   w2:=ExtractWord(2,s); if w2='.' then w2:=ParamStr('UserName');
   w3:=ExtractWord(3,s); if w3='.' then w3:=ParamStr('HostName');
   w4:=ExtractWord(4,s); if w4='.' then w4:=ParamStr('IPAddress');
   w5:=ExtractWord(5,s); if w5='.' then w5:=ParamStr('MACAddress');
   g1:=IsSameText(w1,'*') or (CompareGuards(w1,Guard)>=0);
   g2:=IsSameText(w2,'*') or IsSameText(w2,User);
   g3:=IsSameText(w3,'*') or IsSameText(w3,Host);
   g4:=IsSameText(w4,'*') or IsSameAddr(w4,IP);
   g5:=IsSameText(w5,'*') or IsSameAddr(w5,MAC);
   if g1 and g2 and g3 and g4 and g5 then g:=True;
  end;
  s:=''; w1:='';w2:='';w3:='';w4:='';w5:='';
  GrantAccessDim:=g;
 end;
 {
 Get DIM security parameters: Guard,User,Host,IP,MAC.
 This parameters uses to check access rights via GrantAccessDim.
 }
 function DIM_GuardParams(Name:String):String;
 begin
  if Length(Name)=0
  then DIM_GuardParams:='Guard='+ParamStr('Guard')+EOL
                       +'User=' +ParamStr('UserName')+EOL
                       +'Host=' +ParamStr('HostName')+EOL
                       +'IP='   +ParamStr('IPAddress')+EOL
                       +'MAC='  +ParamStr('MACAddress')+EOL
                       +'FallBackMode='+Str(DIM_GuiClickFallBackMode)
  else 
  if IsSameText(Name,'Guard') then DIM_GuardParams:=ParamStr('Guard')      else
  if IsSameText(Name,'User')  then DIM_GuardParams:=ParamStr('UserName')   else
  if IsSameText(Name,'Host')  then DIM_GuardParams:=ParamStr('HostName')   else
  if IsSameText(Name,'IP')    then DIM_GuardParams:=ParamStr('IPAddress')  else
  if IsSameText(Name,'MAC')   then DIM_GuardParams:=ParamStr('MACAddress') else
  if IsSameText(Name,'FallBackMode') then DIM_GuardParams:=Str(DIM_GuiClickFallBackMode) else
  DIM_GuardParams:='';
 end;
 {
 Send DIM GUI click command to server. Uses encryption for network security.
 DIM_GuiClickTag should be initialized and registered as DIM command service.
 }
 procedure DIM_GuiClickSendToServer(data:String);
 begin
  if (Length(data)>0) then
  if (devDimSrv<>0) and (DIM_GuiClickTag<>0) then
  DIM_UpdateTag(DIM_GuiClickTag,DIM_EncryptCommand(data));
 end;
 {
 Send GUI Click loopback, i.e. send data to self console.
 Uses as fallback solution in case of network falldown.
 }
 procedure DIM_GuiClickSendLoopBack(data:String);
 begin
  if (Length(data)>0) then
  if (devMySelf<>0) and (DIM_GuiClickTag<>0) then
  DevPostCmdLocal(DIM_GuiClickCmnd+'='+mime_encode(DIM_EncryptCommand(data)));
 end;
 {
 Send DIM GUI click command to server or loopback.
 }
 procedure DIM_GuiClickSend(data:String);
 begin
  if (Length(data)>0) then
  if (DIM_GuiClickFallBackMode=0)
  then DIM_GuiClickSendToServer(data)
  else if DIM_IsServerMode
  then DIM_GuiClickSendLoopBack(data);
 end;
 {
 Copy DIM GUI click to long string buffer. Skip empty (clickwhat=0) or remote (clickwrote>0) events.
 }
 function DIM_GuiClickCopy:String;
 begin
  if (ClickWhat>0) and (ClickWrote=0) then begin
   DIM_GuiClickCopy:=DIM_GuiClickCmnd+'='+Str(DIM_GuiClickNum+1)+EOL+ClickParams('')+EOL+DIM_GuardParams('')+EOL;
   DIM_GuiClickNum:=DIM_GuiClickNum+1;
  end else DIM_GuiClickCopy:='';
 end;
 {
 Read parameter (Param) from long text string (ClickBuff) contains DIM click sensor information.
 }
 function DIM_GuiClickScan(var ClickBuff:String; ParamName:String):String;
 var r:Real; s:String;
 begin
  s:=''; ParamName:=Trim(ParamName);
  if (Length(ClickBuff)>0) and (Length(ParamName)>0) then begin
   r:=rVal(TextVarScan(ClickBuff,DIM_GuiClickCmnd));
   if not IsNan(r) then s:=TextVarScan(ClickBuff,ParamName);
  end;
  DIM_GuiClickScan:=s; s:='';
 end;
 {
 Check remote DIM GUI click buffer and return event type (ClickWhat) or zero if access denied.
 }
 function DIM_GuiClickWhat(var ClickBuff:String):Integer;
 var What:Integer;
 begin
  What:=0;
  if Length(ClickBuff)>0 then begin
   What:=WordIndex(DIM_GuiClickScan(ClickBuff,'What'),cw_NameList)-1;
   if What>0 then begin
    if GrantAccessDim(DIM_GuiClickScan(ClickBuff,'Guard'), DIM_GuiClickScan(ClickBuff,'User'),
                      DIM_GuiClickScan(ClickBuff,'Host'),  DIM_GuiClickScan(ClickBuff,'IP'),
                      DIM_GuiClickScan(ClickBuff,'MAC'))
    then begin
     if DebugFlagEnabled(dfDetails) then Details('DIM GUI Click: Access granted.');
    end else begin
     if DebugFlagEnabled(dfDetails) then Details('DIM GUI Click: Access denied.');
     What:=0;
    end;
   end;
  end;
  DIM_GuiClickWhat:=What;
 end;
 {
 Pack DIM GUI click sensor information (minimal subset) into long text string.
 Uses to simulate GUI clicks from program code.
 }
 function DIM_GuiClickPack(What,Button,X,Y:Integer; ms:Real; Device,Window,Sensor,Tag,Curve,Value:String):String;
 begin
  if (What>0) and (What<WordCount(cw_NameList)) then begin
   DIM_GuiClickPack:=DIM_GuiClickCmnd+'='+Str(DIM_GuiClickNum+1)+EOL
   +'What='+ExtractWord(1+What,cw_NameList)+EOL
   +'Where='+Str(X)+','+Str(Y)+EOL
   +'When='+Str(ms)+EOL
   +'Button='+Str(Button)+EOL
   +'Device='+Trim(Device)+EOL
   +'Window='+Trim(Window)+EOL
   +'Sensor='+Trim(Sensor)+EOL
   +'Value='+Trim(Value)+EOL
   +'Curve='+Trim(Curve)+EOL
   +'Tag='+Trim(Tag)+EOL
   +DIM_GuardParams('')+EOL;
   DIM_GuiClickNum:=DIM_GuiClickNum+1;
  end else DIM_GuiClickPack:='';
 end;
 {
 Send data to virtual device console on server side.
 }
 procedure Dim_GuiConsoleSend(DevName,data:String);
 begin
  DIM_GuiClickSend(Dim_GuiClickPack(cw_MouseDown,VK_LBUTTON,0,0,mSecNow,
                   DevName,'Console '+DevName,'Input','','',data));
 end;
 {
 Extract command received from virtual console.
 }
 function Dim_GuiConsoleRecv(DevName,ClickBuff:String):String;
 begin
  if IsEmptyStr(DevName) then Dim_GuiConsoleRecv:='' else
  if Length(ClickBuff)>0 then begin
   if (DIM_GuiClickWhat(ClickBuff)=cw_MouseDown)
   and (Val(DIM_GuiClickScan(ClickBuff,'Button'))=VK_LBUTTON)
   and IsSameText(DIM_GuiClickScan(ClickBuff,'Device'),DevName)
   and IsSameText(DIM_GuiClickScan(ClickBuff,'Sensor'),'Input')
   and IsSameText(DIM_GuiClickScan(ClickBuff,'Window'),'Console '+DevName)
   then Dim_GuiConsoleRecv:=DIM_GuiClickScan(ClickBuff,'Value')
   else Dim_GuiConsoleRecv:='';
  end else begin
   if (ClickWhat=cw_MouseDown) and (ClickButton=VK_LBUTTON) and (ClickWrote>0)
   and IsSameText(ClickParams('Device'),DevName)
   and IsSameText(ClickParams('Sensor'),'Input')
   and IsSameText(ClickParams('Window'),'Console '+DevName)
   then Dim_GuiConsoleRecv:=ClickParams('Value')
   else Dim_GuiConsoleRecv:='';
  end;
 end;
 {
 Default handler for remote DIM GUI clicks. Uses to process @DimGuiClick command.
 DIM_GuiClickTag should be initialized as string tag.
 }
 procedure DIM_GuiClickDefaultHandler(arg:String);
 var What,Button,Num:Integer; ClickBuff:String;
 begin
  ClickBuff:='';
  if DIM_GuiClickAvail then begin
   if Length(arg)>0
   then arg:=mime_decode(arg)
   else arg:=sGetTag(DIM_GuiClickTag);
   bNul(sSetTag(DIM_GuiClickTag,''));
   if Length(arg)>0 then ClickBuff:=DIM_DecryptCommand(arg);
   if Length(ClickBuff)>0 then What:=DIM_GuiClickWhat(ClickBuff) else What:=0;
   if What>0 then begin
    if ClickWrite(ClickBuff)>0 then begin
     if DebugFlagEnabled(dfDetails) then begin
      Button:=Val(DIM_GuiClickScan(ClickBuff,'Button'));
      Num:=Val(DIM_GuiClickScan(ClickBuff,DIM_GuiClickCmnd));
      Details('Remote event['+Str(Num)+']: '+ExtractWord(1+What,cw_NameList)+','+Str(Button));
     end;
    end else Problem('Fail ClickWrite '+ExtractWord(1+What,cw_NameList));
   end;
  end;
  ClickBuff:='';
 end;
 {
 Initialize DIM GUI.
 GuiClickParams: w1 w2
 w1 = name of string  tag DIM_GuiClickTag
 w2 = name of integer tag DIM_GuiClickFallBackModeTag
 }
 procedure DIM_GuiClickInit(GuiClickParams:String);
 const em_List='DEFAULT,BLOWFISH,GOST,RC2,RC4,RC5,RC6,BASE64,HEX,NONE';
 var ck:Integer;
 begin
  DIM_CryptKind:=0;
  DIM_GuiClickTag:=0;
  DIM_GuiClickFallBackModeTag:=0;
  DIM_GuiClickNum:=0;
  DIM_GuiClickBuff:='';
  DIM_ClientServerMode:=0;
  DIM_TrustedUsersSection:=ReadIni('TrustedUsers');
  if (DIM_TrustedUsersSection='') then DIM_TrustedUsersSection:='[TrustedUsers]';
  if (DIM_TrustedUsersList<>0) then begin
   bNul(text_Free(DIM_TrustedUsersList));
   DIM_TrustedUsersList:=0;
  end;
  if (WordCount(GuiClickParams)>=1) then begin
   InitTag(DIM_GuiClickTag,ExtractWord(1,GuiClickParams),3);
   if (TypeTag(DIM_GuiClickTag)=3) then begin
    DIM_ClientServerMode:=1*Ord(iValDef(ReadIni('DimClientMode'),0)=1)+2*Ord(iValDef(ReadIni('DimServerMode'),0)=1);
    ck:=WordIndex(UpCaseStr(ReadIni('EncryptMethod')),em_List)-1; if ck>=0 then DIM_CryptKind:=ck else DIM_CryptKind:=7;
    Success('Init DIM: '+DIM_TrustedUsersSection+','+ExtractWord(1+DIM_CryptKind,em_List)+','+Str(DIM_ClientServerMode)
           +Chr(Ord(' ')+(Ord(',')-Ord(' '))*Ord(DIM_GuiClickTag<>0))+NameTag(DIM_GuiClickTag));
   end;
   if (devDimSrv<>0) then begin
    if (WordCount(GuiClickParams)>=2) then
    if (DIM_GuiClickFallBackModeTag=0) then begin
     DIM_GuiClickFallBackModeTag:=FindTag(ExtractWord(2,GuiClickParams));
     if (TypeTag(DIM_GuiClickFallBackModeTag)<>1) then DIM_GuiClickFallBackModeTag:=0;
    end;
    if (DIM_GuiClickFallBackModeTag=0) then begin
     DIM_GuiClickFallBackModeTag:=FindTag(RefInfo(devDimSrv,'Name')+'.FallBackMode');
     if (TypeTag(DIM_GuiClickFallBackModeTag)<>1) then DIM_GuiClickFallBackModeTag:=0;
    end;
   end;
  end;
 end;
 {
 Clear standard Dims.
 }
 procedure ClearStdDims;
 begin
  DIM_CryptKind:=0;
  DIM_GuiClickTag:=0;
  DIM_GuiClickFallBackModeTag:=0;
  DIM_GuiClickNum:=0;
  DIM_GuiClickBuff:='';
  DIM_ClientServerMode:=0;
  DIM_TrustedUsersList:=0;
  DIM_TrustedUsersSection:='';
 end;
 {
 Initialize standard Dims.
 }
 procedure InitStdDims;
 begin
  DIM_GuiClickInit('');
  ShouldPollStdDims:=false;
 end;
 {
 Finalize standard Dims.
 }
 procedure FreeStdDims;
 begin
  DIM_GuiClickInit('');
 end;
 {
 Poll standard Dims.
 }
 procedure PollStdDims;
 begin
 end;
