 {
 Include FsmManager
 }
 {$I _fun_FsmManager}
 {
 Functions for SmiuiSrv.
 function  smiuisrv_fsm:Integer;
 function  smiuisrv_prompt:String;
 function  smiuisrv_smitagprefix:String;
 function  smiuisrv_create_command(obj,act:String):String;
 function  smiuisrv_add_param_to_command(cmd,name,value:String; typ:Integer):String;
 function  smiuisrv_color_default:Integer;
 function  smiuisrv_color_btnface:Integer;
 function  smiuisrv_color_neutral:Integer;
 function  smiuisrv_color_dormant:Integer;
 function  smiuisrv_color_working:Integer;
 function  smiuisrv_color_success:Integer;
 function  smiuisrv_color_refused:Integer;
 function  smiuisrv_color_offline:Integer;
 function  smiuisrv_color_warning:Integer;
 function  smiuisrv_color_trouble:Integer;
 function  smiuisrv_color_online:Integer;
 function  smiuisrv_color_error:Integer;
 function  smiuisrv_color_fatal:Integer;
 function  smiuisrv_color_dead:Integer;
 function  smiuisrv_color_edit:Integer;
 function  smiuisrv_color_text:Integer;
 function  smiuisrv_color_info:Integer;
 function  smiuisrv_color_alert(severity:Integer):Integer;
 function  smiuisrv_substitute_keywords(ref:Integer; s:String):String;
 function  smiuisrv_smimenufont:String;
 function  smiuisrv_task_dnsnode:String;
 function  smiuisrv_task_fsmargs:String;
 function  smiuisrv_task_fsmline:String;
 function  smiuisrv_task_exefile:String;
 function  smiuisrv_task_cmdargs:String;
 function  smiuisrv_task_cmdline:String;
 function  smiuisrv_task_tid:Integer;
 function  smiuisrv_task_pid:Integer;
 function  smiuisrv_task_running:Boolean;
 procedure smiuisrv_task_send(msg:String);
 procedure smiuisrv_task_watchdog_timer_reset;
 procedure smiuisrv_task_processing(var Data:String);
 procedure smiuisrv_task_clear;
 procedure smiuisrv_task_stop(exitcode:Integer);
 procedure smiuisrv_task_start;
 procedure smiuisrv_task_poll;
 procedure smiuisrv_watchdog_poll;
 procedure smiuisrv_update_linked_tag(ref:Integer; link,data:String; color:Integer);
 procedure smiuisrv_clear_all;
 procedure smiuisrv_initialize;
 procedure smiuisrv_finalize;
 function  smiuisrv_find_fsm_max_length(ref:Integer):Integer;
 function  smiuisrv_find_fsm_by_linked_tag(tag:Integer):Integer;
 function  smiuisrv_click_fsm:Integer;
 procedure smiuisrv_start_menu_state_click(state:Integer; click:String);
 procedure smiuisrv_menu_state_default_handler;
 procedure smiuisrv_click_fsm_default_handler(click:String);
 function  smiuisrv_parse_csv(var arg,w1,w2,w3,w4,w5,w6:String; nlast:Integer):Integer;
 procedure smiuisrv_update_object_state(objname,state,busy:String);
 procedure smiuisrv_default_fsm_poll;
 function  smiuisrv_default_handler(var Data,cmd,arg:String; cmdid:Integer):Boolean;
 procedure ClearSmiuiSrv;
 procedure InitSmiuiSrv;
 procedure FreeSmiuiSrv;
 procedure PollSmiuiSrv;
 }
 //
 // SMIUISRV: FSM reference.
 //
 function smiuisrv_fsm:Integer;
 begin
  smiuisrv_fsm:=smiuisrv_tab.fsm;
 end;
 //
 // SMIUISRV: Console prompt like SMIUISRV => message.
 //
 function smiuisrv_prompt:String;
 begin
  smiuisrv_prompt:='SMIUISRV => ';
 end;
 //
 // SMIUISRV: common tag prefix, set by parameter SmiTagPrefix = SMI.
 //
 function smiuisrv_smitagprefix:String;
 begin
  smiuisrv_smitagprefix:=smiuisrv_tab.SmiTagPrefix;
 end;
 //
 // SMIUISRV: create command to be send to local console to call action (act) of object (obj).
 // The command (assume obj=DOMAIN::OBJECT, act=ACTION) has format:
 // @smiuisrv_send @smiui_send_command=DOMAIN::OBJECT,ACTION
 //
 function smiuisrv_create_command(obj,act:String):String;
 begin
  obj:=Trim(obj); act:=Trim(act);
  if (obj<>'') and (act<>'') and (Pos('::',obj)>0)
  then smiuisrv_create_command:='@smiuisrv_send @smiui_send_command='+obj+','+act
  else smiuisrv_create_command:='';
 end;
 //
 // Example:
 //  cmd:=smiuisrv_create_command('DEMO::LOGGER','LOG');
 //  cmd:=smiuisrv_add_param_to_command(cmd,'TYPE','TEST',SMI_STRING);
 //  cmd:=smiuisrv_add_param_to_command(cmd,'NR',Str(123),SMI_INTEGER);
 //  DevPostCmdLocal(cmd);
 //
 function smiuisrv_add_param_to_command(cmd,name,value:String; typ:Integer):String;
 var ct:Char;
 begin
  cmd:=Trim(cmd); name:=Trim(name);
  if (typ=SMI_STRING)  or (typ=fsm_type_string) then ct:='S' else
  if (typ=SMI_INTEGER) or (typ=fsm_type_int)    then ct:='I' else
  if (typ=SMI_FLOAT)   or (typ=fsm_type_float)  then ct:='F' else ct:=' ';
  if (cmd<>'') and (name<>'') and (ct<>' ') then begin
   if (typ=SMI_STRING) then begin
    sNul(backslash_encoder_ctrl('hexlist=/,;"'' '));
    value:=backslash_encode(value);
    sNul(backslash_encoder_ctrl('hexlist='));
   end;
   cmd:=cmd+'/'+name+'('+ct+')='+value;
  end;
  smiuisrv_add_param_to_command:=cmd;
 end;
 //
 // SMIUISRV: functional colors.
 //
 function smiuisrv_color_default:Integer;    begin smiuisrv_color_default := smiuisrv_tab.color_default; end;
 function smiuisrv_color_btnface:Integer;    begin smiuisrv_color_btnface := smiuisrv_tab.color_btnface; end;
 function smiuisrv_color_neutral:Integer;    begin smiuisrv_color_neutral := smiuisrv_tab.color_neutral; end;
 function smiuisrv_color_dormant:Integer;    begin smiuisrv_color_dormant := smiuisrv_tab.color_dormant; end;
 function smiuisrv_color_working:Integer;    begin smiuisrv_color_working := smiuisrv_tab.color_working; end;
 function smiuisrv_color_success:Integer;    begin smiuisrv_color_success := smiuisrv_tab.color_success; end;
 function smiuisrv_color_refused:Integer;    begin smiuisrv_color_refused := smiuisrv_tab.color_refused; end;
 function smiuisrv_color_offline:Integer;    begin smiuisrv_color_offline := smiuisrv_tab.color_offline; end;
 function smiuisrv_color_warning:Integer;    begin smiuisrv_color_warning := smiuisrv_tab.color_warning; end;
 function smiuisrv_color_trouble:Integer;    begin smiuisrv_color_trouble := smiuisrv_tab.color_trouble; end;
 function smiuisrv_color_online:Integer;     begin smiuisrv_color_online  := smiuisrv_tab.color_online;  end;
 function smiuisrv_color_error:Integer;      begin smiuisrv_color_error   := smiuisrv_tab.color_error;   end;
 function smiuisrv_color_fatal:Integer;      begin smiuisrv_color_fatal   := smiuisrv_tab.color_fatal;   end;
 function smiuisrv_color_dead:Integer;       begin smiuisrv_color_dead    := smiuisrv_tab.color_dead;    end;
 function smiuisrv_color_edit:Integer;       begin smiuisrv_color_edit    := smiuisrv_tab.color_edit;    end;
 function smiuisrv_color_text:Integer;       begin smiuisrv_color_text    := smiuisrv_tab.color_text;    end;
 function smiuisrv_color_info:Integer;       begin smiuisrv_color_info    := smiuisrv_tab.color_info;    end;
 function smiuisrv_color_alert(severity:Integer):Integer;
 begin
  if (severity>=smi_severity_norm) and (severity<=smi_severity_fatal)
  then smiuisrv_color_alert:=smiuisrv_tab.color_alert[severity]
  else smiuisrv_color_alert:=smiuisrv_tab.color_dead;
 end;
 //
 // SMIUISRV: Replace _DOMAIN_, _OBJECT_, _STATE_, _ACTION_ to reference names.
 //
 function smiuisrv_substitute_keywords(ref:Integer; s:String):String;
 begin
  if (ref<>0) and (s<>'') then
  if (fsm_type(ref)=fsm_type_action) then begin
   s:=regexp_replace(smiuisrv_tab.rexRefAction,s,fsm_name(ref)); ref:=fsm_parent(ref);
   s:=regexp_replace(smiuisrv_tab.rexRefState,s,fsm_name(ref));  ref:=fsm_parent(ref);
   s:=regexp_replace(smiuisrv_tab.rexRefObject,s,fsm_name(ref)); ref:=fsm_parent(ref);
   s:=regexp_replace(smiuisrv_tab.rexRefDomain,s,fsm_name(ref));
  end else
  if (fsm_type(ref)=fsm_type_state) then begin
   s:=regexp_replace(smiuisrv_tab.rexRefState,s,fsm_name(ref));  ref:=fsm_parent(ref);
   s:=regexp_replace(smiuisrv_tab.rexRefObject,s,fsm_name(ref)); ref:=fsm_parent(ref);
   s:=regexp_replace(smiuisrv_tab.rexRefDomain,s,fsm_name(ref));
  end else
  if (fsm_type(ref)=fsm_type_object) then begin
   s:=regexp_replace(smiuisrv_tab.rexRefObject,s,fsm_name(ref)); ref:=fsm_parent(ref);
   s:=regexp_replace(smiuisrv_tab.rexRefDomain,s,fsm_name(ref));
  end else
  if (fsm_type(ref)=fsm_type_domain) then begin
   s:=regexp_replace(smiuisrv_tab.rexRefDomain,s,fsm_name(ref));
  end;
  smiuisrv_substitute_keywords:=s;
 end;
 //
 // SMIUISRV: SmiMenuFont is description of font font uses for menu's.
 // Set by configuration parameter like SmiMenuFont = Name:PT_Mono\Size:14\Color:Black\Style:[Bold]
 //
 function smiuisrv_smimenufont:String;
 begin
  if IsEmptyStr(smiuisrv_tab.SmiMenuFont)
  then smiuisrv_smimenufont:=smi_default_menu_font
  else smiuisrv_smimenufont:=smiuisrv_tab.SmiMenuFont;
 end;
 //
 // SMIUISRV: uses DIM DNS node.
 // Configure by SMIUISRV_DNS parameter.
 //
 function smiuisrv_task_dnsnode:String;
 begin
  smiuisrv_task_dnsnode:=smiuisrv_tab.task.dnsnode;
 end;
 //
 // SMIUISRV: uses EXE file, arguments and command line.
 // Configure by SMIUISRV_FSM, SMIUISRV_DNS parameters.
 // Example:
 //   fsmargs : -name SMITEST -dom DEMO -sml run_con.sml
 //   fsmline : -dns localhost -name SMITEST -dom DEMO -sml run_con.sml
 //
 function smiuisrv_task_fsmargs:String;
 begin
  smiuisrv_task_fsmargs:=smiuisrv_tab.task.fsmargs;
 end;
 function smiuisrv_task_fsmline:String;
 begin
  smiuisrv_task_fsmline:=smiuisrv_tab.task.fsmline;
 end;
 //
 // SMIUISRV: task EXE file, arguments and command line.
 // Configure by SMIUISRV_EXE, SMIUISRV_ARG, SMIUISRV_DNS parameters.
 // Example:
 //   exefile: C:\Crw32exe\Resource\DaqSite\SmiServer\SMIUISRV.EXE
 //   cmdargs: -auto -dom DEMO -sleep 1000
 //   cmdline: C:\Crw32exe\Resource\DaqSite\SmiServer\SMIUISRV.EXE -dns localhost -auto -dom DEMO -sleep 1000
 //
 function smiuisrv_task_exefile:String;
 begin
  smiuisrv_task_exefile:=smiuisrv_tab.task.exefile;
 end;
 function smiuisrv_task_cmdargs:String;
 begin
  smiuisrv_task_cmdargs:=smiuisrv_tab.task.cmdargs;
 end;
 function smiuisrv_task_cmdline:String;
 begin
  smiuisrv_task_cmdline:=smiuisrv_tab.task.cmdline;
 end;
 //
 // SMIUISRV: task ID or 0.
 //
 function smiuisrv_task_tid:Integer;
 begin
  smiuisrv_task_tid:=smiuisrv_tab.task.tid;
 end;
 //
 // SMIUISRV: task PID or 0 if not running.
 //
 function smiuisrv_task_pid:Integer;
 begin
  if (smiuisrv_tab.task.tid<>0)
  then smiuisrv_task_pid:=task_pid(smiuisrv_tab.task.tid)
  else smiuisrv_task_pid:=0;
 end;
 //
 // SMIUISRV: task is running?
 //
 function smiuisrv_task_running:Boolean;
 begin
  if (smiuisrv_tab.task.tid<>0)
  then smiuisrv_task_running:=task_wait(smiuisrv_tab.task.tid,0)
  else smiuisrv_task_running:=false;
 end;
 //
 // SMIUISRV: Send message (command) to StdIn pipe of SMIUISRV task.
 // Wait for some time if transmitter FIFO is over.
 //
 procedure smiuisrv_task_send(msg:String);
 var ms:Real;
 begin
  msg:=Trim(msg);
  if (smiuisrv_tab.task.tid<>0) and (Length(msg)>0) then begin
   if (task_txspace(smiuisrv_tab.task.tid)<Length(msg)+2) then begin
    ms:=msecnow; while(msecnow-ms<100) and (task_txspace(smiuisrv_tab.task.tid)<Length(msg)+2) do bNul(Sleep(1));
   end;
   if (task_send(smiuisrv_tab.task.tid,msg+EOL)=0)
   then Trouble('Send error!') else if DebugFlagEnabled(dfViewExp) then ViewExp(msg);
  end;
 end;
 //
 // SMIUISRV: Reset Task Watchdog Timer.
 //
 procedure smiuisrv_task_watchdog_timer_reset;
 begin
  smiuisrv_tab.Task.WatchdogTimer:=msecnow;
 end;
 //
 // SMIUISRV task StdOut processing.
 // Handle some command in place, resend other commands to local console for smiuisrv_default_handler processing.
 //
 // DIM sample string:
 //   PID 7344 - Thu Dec 03 20:00:19 2020 - (INFO) Server Connection established to DIM_DNS@localhost
 //   PID 7344 - Thu Dec 03 21:00:12 2020 - (ERROR) Server Connecting to DIM_DNS@localhost: Connection refused
 // Note: DIM output uses to detect DIM server state.
 //
 procedure smiuisrv_task_processing(var Data:String);
 const DimMsgSign='PID ';
 var cmd,arg,name:String; cmdid:Integer; i,n,p:Integer;
 begin
  cmd:=''; arg:=''; name:='';
  if Length(Data)>0 then begin
   if DebugFlagEnabled(dfViewImp) then ViewImp(smiuisrv_prompt+Data);
   if (Copy(Data,1,Length(DimMsgSign))=DimMsgSign) then begin       // Message came from DIM:
    Success(smiuisrv_prompt+Data);                                  // Print this to console.
    Data:='';                                                       // Done.
   end else
   if GotCommandId(Data,cmd,arg,cmdid) then begin
    //
    // @Exit=n
    //
    if (cmdid=smiuisrv_tab.cmd_exit) then begin
     Success(smiuisrv_prompt+'Server request to stop with exit code '+Trim(arg));
     Data:='';
    end else
    //
    // @Errors=n
    //
    if (cmdid=smiuisrv_tab.cmd_errors) then begin
     smiuisrv_task_watchdog_timer_reset; // !!! Reset Watchdog !!!
     n:=Val(Trim(arg));
     if n>0 then begin
      for i:=1 to n-1 do bNul(FixError(errorcode));
      Trouble(StrFmt('Server errors detected (%d).',n));
     end;
     if DebugFlagEnabled(dfDetails) then
     Details(smiuisrv_prompt+Data);
     Data:='';
    end else
    //
    // @Memory=n
    //
    if (cmdid=smiuisrv_tab.cmd_memory) then begin
     smiuisrv_task_watchdog_timer_reset; // !!! Reset Watchdog !!!
     if DebugFlagEnabled(dfDetails) then
     Details(smiuisrv_prompt+Data);
     Data:='';
    end else
    //
    // @ProcessPriority=p
    //
    if (cmdid=smiuisrv_tab.cmd_processpriority) then begin
     Success(smiuisrv_prompt+Data);
     Data:='';
    end else
    //
    // @ThreadPriority=p
    //
    if (cmdid=smiuisrv_tab.cmd_threadpriority) then begin
     Success(smiuisrv_prompt+Data);
     Data:='';
    end else
    //
    // @OnException=message
    //
    if (cmdid=smiuisrv_tab.cmd_onexception) then begin
     rNul(Eval('@System @Async @Silent @OnException '+smiuisrv_prompt+Trim(arg)));
     Trouble('Server task exception detected.');
     Success(smiuisrv_prompt+Data);
     Data:='';
    end else
    //
    // @Sleep=n
    //
    if (cmdid=smiuisrv_tab.cmd_sleep) then begin
     Success(smiuisrv_prompt+Data);
     Data:='';
    end else
    //
    // @dim_dns_node=n
    //
    if (cmdid=smiuisrv_tab.cmd_dim_dns_node) then begin
     Success(smiuisrv_prompt+Data);
     Data:='';
    end else
    //
    // Alternative case: resend command to local console
    //
    begin
     DevPostCmdLocal(Data);
     Data:='';
    end;
   end;
  end;
  cmd:=''; arg:=''; name:='';
 end;
 //
 // SMIUISRV Mark task become dead, i.e. clear task, watchdog and buffers.
 //
 procedure smiuisrv_task_clear;
 begin
  smiuisrv_tab.task.tid:=0;
  smiuisrv_tab.task.Line:='';
  smiuisrv_tab.task.Buff:='';
  smiuisrv_tab.task.WatchdogTimer:=0;
 end;
 //
 // Stop SMIUISRV task if one started.
 //
 procedure smiuisrv_task_stop(exitcode:Integer);
 begin
  if (smiuisrv_tab.task.tid<>0) then begin
   if task_wait(smiuisrv_tab.task.tid,0) then begin
    Success(smiuisrv_prompt+'Terminating Server...');
    smiuisrv_task_send('@exit='+Str(exitcode));
    bNul(task_wait(smiuisrv_tab.task.tid,2000));
    if task_wait(smiuisrv_tab.task.tid,0) then bNul(task_kill(smiuisrv_tab.task.tid,1,0,1000)); // Send Ctrl+C
    if task_wait(smiuisrv_tab.task.tid,0) then bNul(task_kill(smiuisrv_tab.task.tid,0,1,0));    // Terminate
    if task_rxcount(smiuisrv_tab.task.tid)>0 then
    while task_readln(smiuisrv_tab.task.tid,smiuisrv_tab.task.line,smiuisrv_tab.task.buff) do begin
     smiuisrv_task_processing(smiuisrv_tab.task.line);
     smiuisrv_tab.task.line:='';
    end;
    Success(smiuisrv_prompt+'Server stopped with exit code '+Str(task_result(smiuisrv_tab.task.tid)));
   end;
   bNul(task_free(smiuisrv_tab.task.tid));
   smiuisrv_task_clear;
  end;
 end;
 //
 // Start SMIUISRV task.
 //
 procedure smiuisrv_task_start;
 begin
  if smiuisrv_tab.task.tid=0 then begin
   smiuisrv_tab.task.tid:=task_init(smiuisrv_task_cmdline);
   if pos('?',task_ctrl(smiuisrv_tab.task.tid,'StdOutPipeSize='+Str(smiuisrv_tab.task.StdOutPipeSize))
             +task_ctrl(smiuisrv_tab.task.tid,'StdInPipeSize='+Str(smiuisrv_tab.task.StdInPipeSize))
             +task_ctrl(smiuisrv_tab.task.tid,'HomeDir='+ExtractFilePath(smiuisrv_task_exefile))
             +task_ctrl(smiuisrv_tab.task.tid,'Display='+Str(smiuisrv_tab.task.display))
             )>0
   then begin
    Trouble(smiuisrv_prompt+'Task setup error!');
    smiuisrv_task_stop(0);
   end;
   //
   // Run task if one was created...
   //
   if smiuisrv_tab.task.tid>0 then
   if task_run(smiuisrv_tab.task.tid) then begin
    Success('TaskId  = '+str(smiuisrv_tab.task.tid));
    Success('TaskPid = '+str(task_pid(smiuisrv_tab.task.tid)));
    Success('TaskRef = '+str(task_ref(smiuisrv_tab.task.tid)));
    Success('CmdLine = '+task_ctrl(smiuisrv_tab.task.tid,'CmdLine'));
    Success('HomeDir = '+task_ctrl(smiuisrv_tab.task.tid,'HomeDir'));
    Success('PipeIn  = '+task_ctrl(smiuisrv_tab.task.tid,'StdInPipeSize'));
    Success('PipeOut = '+task_ctrl(smiuisrv_tab.task.tid,'StdOutPipeSize'));
    Success('Display = '+task_ctrl(smiuisrv_tab.task.tid,'Display'));
   end else begin
    Trouble(smiuisrv_prompt+'Could not start Server!');
    smiuisrv_task_stop(0);
   end;
   //
   // Is it Ok with user task? Send startup parameters.
   //
   if smiuisrv_tab.task.tid>0 then
   if task_wait(smiuisrv_tab.task.tid,0) then begin
    smiuisrv_task_watchdog_timer_reset; // !!!Start watchdog!!!
    smiuisrv_task_send('@memory');
    smiuisrv_task_send('@errors');
    smiuisrv_tab.task.line:='';
    smiuisrv_tab.task.buff:='';
   end else begin
    Trouble(smiuisrv_prompt+'Failed start Server!');
    smiuisrv_task_stop(0);
   end;
  end;
 end;
 //
 // Poll SMIUISRV task.
 //
 procedure smiuisrv_task_poll;
  procedure smiuisrv_ping_domains;
  var fsm,dom,idom:Integer;
  begin
   fsm:=smiuisrv_fsm;
   smiuisrv_task_send('@smiui_dns_version');
   for idom:=0 to fsm_count(fsm,fsm_type_domain)-1 do begin
    dom:=fsm_items(fsm,fsm_type_domain,idom);
    smiuisrv_task_send('@smiui_number_of_objects='+fsm_name(dom));
   end;
  end;
 begin
  //
  // If server is not still running,
  // try to start server periodically.
  //
  if smiuisrv_tab.task.tid=0 then
  if smiuisrv_tab.task.RecoveryPeriod>0 then
  if msecnow>smiuisrv_tab.task.RecoveryTimer+smiuisrv_tab.task.RecoveryPeriod then begin
   smiuisrv_tab.task.RecoveryTimer:=msecnow;
   smiuisrv_task_start;
  end;
  //
  // Communicate with server if one still running...
  //
  if smiuisrv_tab.task.tid>0 then
  if task_wait(smiuisrv_tab.task.tid,0) then begin
   //
   // If got data from Task StdOut, analyse it...
   //
   if task_rxcount(smiuisrv_tab.task.tid)>0 then
   while Task_Readln(smiuisrv_tab.task.tid,smiuisrv_tab.task.line,smiuisrv_tab.task.buff) do begin
    smiuisrv_task_processing(smiuisrv_tab.task.line);
    smiuisrv_tab.task.line:='';
   end;
   //
   // Reset recovery timer...
   //
   smiuisrv_tab.task.RecoveryTimer:=msecnow;
   //
   // Server timer actions...
   //
   if SysTimer_Pulse(1000)>0 then begin
    smiuisrv_task_send('@Errors=0'); // !!! Required to reset watchdog !!!
    smiuisrv_task_send('@Memory');   // !!! Required to reset watchdog !!!
    smiuisrv_ping_domains;
   end;
  end else begin
   Trouble(smiuisrv_prompt+'Server terminated with exit code '+Str(task_result(smiuisrv_tab.task.tid)));
   smiuisrv_task_stop(0);
  end;
 end;
 //
 // SMIUISRV: watchdog.
 //
 procedure smiuisrv_watchdog_poll;
 var DEADLINE:Real;
  procedure Restart(msg:String);
  begin
   Trouble(msg+' DEADLINE. Server restart.');
   smiuisrv_task_stop(0);
   smiuisrv_tab.task.RecoveryTimer:=msecnow-smiuisrv_tab.task.RecoveryPeriod;
  end;
 begin
  DEADLINE:=smiuisrv_tab.task.RecoveryPeriod;
  if smiuisrv_tab.task.tid>0 then
  if msElapsedSinceMarker(smiuisrv_tab.task.WatchdogTimer)>DEADLINE
  then Restart('TASK WATCHDOG');
 end;
 //
 // Update tag linked to fsm_link(ref,link) with given data.
 //
 procedure smiuisrv_update_linked_tag(ref:Integer; link,data:String; color:Integer);
 var tag,typ:Integer;
 begin
  tag:=fsm_link(ref,link); typ:=typetag(tag);
  if (typ=3) then bNul(sSetTag(tag,data)) else
  if (typ=1) then bNul(iSetTag(tag,Val(data))) else
  if (typ=2) then bNul(rSetTag(tag,rValDef(data,0)));
  if (typ>0) and (color<>-1) then bNul(SetTagColor(tag,color));
 end;
 //
 // Clear all SMIUISRV data.
 //
 procedure smiuisrv_clear_all;
 begin
  smiuisrv_tab.fsm:=0;
  smiuisrv_tab.task.tid:=0;
  smiuisrv_tab.task.ExeFile:='';
  smiuisrv_tab.task.CmdArgs:='';
  smiuisrv_tab.task.CmdLine:='';
  smiuisrv_tab.task.DnsNode:='';
  smiuisrv_tab.task.FsmArgs:='';
  smiuisrv_tab.task.FsmLine:='';
  smiuisrv_tab.task.Line:='';
  smiuisrv_tab.task.Buff:='';
  smiuisrv_tab.task.RecoveryTimer:=0;
  smiuisrv_tab.task.WatchdogTimer:=0;
  smiuisrv_tab.TooltipSeverityDelays:='';
  smiuisrv_tab.SmiuiSrvMessagesLogFile:='';
  smiuisrv_tab.SmiTagPrefix:='';
  smiuisrv_tab.SmiMenuFont:='';
  smiuisrv_tab.tagLinks:=0;
  smiuisrv_tab.rexRefDomain:=0;
  smiuisrv_tab.rexRefObject:=0;
  smiuisrv_tab.rexRefAction:=0;
  smiuisrv_tab.rexRefState:=0;
 end;
 //
 // SMIUISRV initialize params from INI file.
 //
 procedure smiuisrv_initialize;
  procedure smiuisrv_fsm_init(arg:String);
  begin
   smiuisrv_tab.fsm:=fsm_init(arg);
  end;
  procedure smiuisrv_init_tagLinks;
  begin
   smiuisrv_tab.tagLinks:=hashlist_init(0);
  end;
  procedure smiuisrv_register_commands;
  begin
   smiuisrv_tab.cmd_exit                          := RegisterStdInCmd('@Exit',                          '@Exit=n - Exit server with code n');
   smiuisrv_tab.cmd_sleep                         := RegisterStdInCmd('@Sleep',                         '@Sleep=n - Sleep for n milliseconds');
   smiuisrv_tab.cmd_memory                        := RegisterStdInCmd('@Memory',                        '@Memory=n - Check memory usage');
   smiuisrv_tab.cmd_errors                        := RegisterStdInCmd('@Errors',                        '@Errors=n - Return server errors');
   smiuisrv_tab.cmd_ProcessPriority               := RegisterStdInCmd('@ProcessPriority',               '@ProcessPriority=p - Process priority');
   smiuisrv_tab.cmd_ThreadPriority                := RegisterStdInCmd('@ThreadPriority',                '@ThreadPriority=p - Thread priority');
   smiuisrv_tab.cmd_OnException                   := RegisterStdInCmd('@OnException',                   '@OnException=msg - Exception handler test.');
   smiuisrv_tab.cmd_smiuisrv_send                 := RegisterStdInCmd('@smiuisrv_send',                 '@smiuisrv_send @COMMAND - send command to SMIUISRV.EXE');
   smiuisrv_tab.cmd_smiuisrv_restart              := RegisterStdInCmd('@smiuisrv_restart',              '@smiuisrv_restart=ExitCode - Restart SMIUISRV.EXE');
   smiuisrv_tab.cmd_smiuisrv_fsm_dump             := RegisterStdInCmd('@smiuisrv_fsm_dump',             '@smiuisrv_fsm_dump=m f - FSM dump with mode m and filter f');
   smiuisrv_tab.cmd_dim_dns_node                  := RegisterStdInCmd('@dim_dns_node',                  '@dim_dns_node=HOSTNAME');
   smiuisrv_tab.cmd_smiui_dns_version             := RegisterStdInCmd('@smiui_dns_version',             '@smiui_dns_version=2023,localhost,DIS_DNS@bilbo,4032');
   smiuisrv_tab.cmd_smiui_current_state           := RegisterStdInCmd('@smiui_current_state',           '@smiui_current_state=OBJECTNAME');
   smiuisrv_tab.cmd_smiui_send_command            := RegisterStdInCmd('@smiui_send_command',            '@smiui_send_command=OBJECTNAME,STATE/PARAMS');
   smiuisrv_tab.cmd_smiui_ep_send_command         := RegisterStdInCmd('@smiui_ep_send_command',         '@smiui_ep_send_command=OBJECTNAME,STATE/PARAMS');
   smiuisrv_tab.cmd_smiui_send_command_wait       := RegisterStdInCmd('@smiui_send_command_wait',       '@smiui_send_command_wait=OBJECTNAME,STATE/PARAMS');
   smiuisrv_tab.cmd_smiui_ep_send_command_wait    := RegisterStdInCmd('@smiui_ep_send_command_wait',    '@smiui_ep_send_command_wait=OBJECTNAME,STATE/PARAMS');
   smiuisrv_tab.cmd_smiui_change_option           := RegisterStdInCmd('@smiui_change_option',           '@smiui_change_option=...');
   smiuisrv_tab.cmd_smiui_change_option_wait      := RegisterStdInCmd('@smiui_change_option_wait',      '@smiui_change_option_wait=...');
   smiuisrv_tab.cmd_smiui_get_options             := RegisterStdInCmd('@smiui_get_options',             '@smiui_get_options=...');
   smiuisrv_tab.cmd_smiui_number_of_objects       := RegisterStdInCmd('@smiui_number_of_objects',       '@smiui_number_of_objects=DOMAIN');
   smiuisrv_tab.cmd_smiui_connect_domain          := RegisterStdInCmd('@smiui_connect_domain',          '@smiui_connect_domain=DOMAIN');
   smiuisrv_tab.cmd_smiui_book_connect_domain     := RegisterStdInCmd('@smiui_book_connect_domain',     '@smiui_book_connect_domain=DOMAIN,auto');
   smiuisrv_tab.cmd_smiui_cancel_connect_domain   := RegisterStdInCmd('@smiui_cancel_connect_domain',   '@smiui_cancel_connect_domain=DOMAIN');
   smiuisrv_tab.cmd_smiui_shutdown_domain         := RegisterStdInCmd('@smiui_shutdown_domain',         '@smiui_shutdown_domain=DOMAIN');
   smiuisrv_tab.cmd_smiui_check_proxy             := RegisterStdInCmd('@smiui_check_proxy',             '@smiui_check_proxy=OBJECTNAME');
   smiuisrv_tab.cmd_smiui_kill                    := RegisterStdInCmd('@smiui_kill',                    '@smiui_kill=DOMAIN');
   smiuisrv_tab.cmd_smiui_book_statechange        := RegisterStdInCmd('@smiui_book_statechange',        '@smiui_book_statechange=OBJECTNAME');
   smiuisrv_tab.cmd_smiui_cancel_statechange      := RegisterStdInCmd('@smiui_cancel_statechange',      '@smiui_cancel_statechange=OBJECTNAME');
   smiuisrv_tab.cmd_smiui_book_smi_message        := RegisterStdInCmd('@smiui_book_smi_message',        '@smiui_book_smi_message=DOMAIN');
   smiuisrv_tab.cmd_smiui_cancel_smi_message      := RegisterStdInCmd('@smiui_cancel_smi_message',      '@smiui_cancel_smi_message=DOMAIN');
   smiuisrv_tab.cmd_smiui_book_user_message       := RegisterStdInCmd('@smiui_book_user_message',       '@smiui_book_user_message=DOMAIN');
   smiuisrv_tab.cmd_smiui_cancel_user_message     := RegisterStdInCmd('@smiui_cancel_user_message',     '@smiui_cancel_user_message=DOMAIN');
   smiuisrv_tab.cmd_smiui_list_domain_objects     := RegisterStdInCmd('@smiui_list_domain_objects',     '@smiui_list_domain_objects=DOMAIN');
   smiuisrv_tab.cmd_smiui_list_domain_objectsets  := RegisterStdInCmd('@smiui_list_domain_objectsets',  '@smiui_list_domain_objectsets=DOMAIN,auto');
   smiuisrv_tab.cmd_smiui_book_objectsetchange    := RegisterStdInCmd('@smiui_book_objectsetchange',    '@smiui_book_objectsetchange=OBJSET');
   smiuisrv_tab.cmd_smiui_cancel_objectsetchange  := RegisterStdInCmd('@smiui_cancel_objectsetchange',  '@smiui_cancel_objectsetchange=OBJSET');
   smiuisrv_tab.cmd_smiui_connect_domain_handler  := RegisterStdInCmd('@smiui_connect_domain_handler',  '@smiui_connect_domain_handler=COUNT,DOMAIN,NUMOBJ,OBJ1|OBJ2...');
   smiuisrv_tab.cmd_smiui_statechange_handler     := RegisterStdInCmd('@smiui_statechange_handler',     '@smiui_statechange_handler=COUNT,OBJECT,STATE,BUSYACTION,ACTIONLIST,PARAMLIST');
   smiuisrv_tab.cmd_smiui_smi_message_handler     := RegisterStdInCmd('@smiui_smi_message_handler',     '@smiui_smi_message_handler=COUNT,DOMAIN,MESSAGE');
   smiuisrv_tab.cmd_smiui_user_message_handler    := RegisterStdInCmd('@smiui_user_message_handler',    '@smiui_user_message_handler=COUNT,DOMAIN,MESSAGE');
   smiuisrv_tab.cmd_smiui_objectsetchange_handler := RegisterStdInCmd('@smiui_objectsetchange_handler', '@smiui_objectsetchange_handler=COUNT,OBJSET,NUMOBJ,OBJ1|OBJ2...');
   smiuisrv_tab.cmd_smiui_report                  := RegisterStdInCmd('@smiui_report',                  '@smiui_report=MESSAGE');
   smiuisrv_tab.cmd_smiui_errors                  := RegisterStdInCmd('@smiui_errors',                  '@smiui_errors=COUNT');
  end;
  procedure smiuisrv_init_colors;
  begin
   smiuisrv_tab.color_default := StringToColorDef('_3DFace'                     , clSilver  );
   smiuisrv_tab.color_btnface := StringToColorDef('_3DFace'                     , clSilver  );
   smiuisrv_tab.color_neutral := StringToColorDef('Silver'                      , clSilver  );
   smiuisrv_tab.color_dormant := StringToColorDef('FwStateOKNotPhysics'         , clAqua    );
   smiuisrv_tab.color_working := StringToColorDef('FwStateOKPhysics'            , clLime    );
   smiuisrv_tab.color_success := StringToColorDef('Lime'                        , clLime    );
   smiuisrv_tab.color_refused := StringToColorDef('FwAlarmWarnAck'              , clYellow  );
   smiuisrv_tab.color_offline := StringToColorDef('FwAlarmFatalAck'             , clRed     );
   smiuisrv_tab.color_warning := StringToColorDef('FwAlarmWarnAck'              , clYellow  );
   smiuisrv_tab.color_trouble := StringToColorDef('FwBackgroundUserAttention'   , clRed     );
   smiuisrv_tab.color_online  := StringToColorDef('FwStateOKPhysics'            , clLime    );
   smiuisrv_tab.color_error   := StringToColorDef('FwAlarmErrorAck'             , clRed     );
   smiuisrv_tab.color_fatal   := StringToColorDef('FwAlarmFatalAck'             , clRed     );
   smiuisrv_tab.color_dead    := StringToColorDef('FwDead'                      , clSilver  );
   smiuisrv_tab.color_edit    := StringToColorDef('FwBackgroundInputText'       , clWhite   );
   smiuisrv_tab.color_text    := StringToColorDef('FwForegroundInputText'       , clBlack   );
   smiuisrv_tab.color_info    := StringToColorDef('FwTableSelection'            , clAqua    );
   smiuisrv_tab.color_alert[smi_severity_norm]    := StringToColorDef('FwStateOKPhysics'    , clLime    );
   smiuisrv_tab.color_alert[smi_severity_info]    := StringToColorDef('FwStateOKNotPhysics' , clAqua    );
   smiuisrv_tab.color_alert[smi_severity_warning] := StringToColorDef('FwAlarmWarnAck'      , clYellow  );
   smiuisrv_tab.color_alert[smi_severity_error]   := StringToColorDef('FwAlarmErrorAck'     , clYellow  );
   smiuisrv_tab.color_alert[smi_severity_fatal]   := StringToColorDef('FwAlarmFatalAck'     , clRed     );
  end;
  procedure smiuisrv_init_rexrefs;
  begin
   smiuisrv_tab.rexRefDomain:=regexp_init(0,'/\b_domain_\b/ig');
   smiuisrv_tab.rexRefObject:=regexp_init(0,'/\b_object_\b/ig');
   smiuisrv_tab.rexRefAction:=regexp_init(0,'/\b_action_\b/ig');
   smiuisrv_tab.rexRefState:=regexp_init(0,'/\b_state_\b/ig');
  end;
  procedure smiuisrv_init_domains;
  var fsm,dom,idom,color:Integer;
  begin
   fsm:=smiuisrv_fsm;
   for idom:=0 to fsm_count(fsm,fsm_type_domain)-1 do begin
    dom:=fsm_items(fsm,fsm_type_domain,idom);
    if IsEmptyStr(fsm_get_cookie(dom,smi_sym_busy_title)) then fsm_set_cookie(dom,smi_sym_busy_title,'&BUSY');
    if IsEmptyStr(fsm_get_cookie(dom,smi_sym_busy_color)) then fsm_set_cookie(dom,smi_sym_busy_color,'Yellow');
    color:=StringToColorDef(fsm_get_cookie(dom,smi_sym_busy_color),smiuisrv_color_warning);
    iNul(fsm_link(dom,smi_sym_busy_color+'='+Str(color)));
    iNul(fsm_link(dom,smi_sym_see_number_of_objects+'='+Str(0)));
    fsm_add_iparam(dom,smi_sym_number_of_objects,0);
   end;
  end;
  procedure smiuisrv_init_tags(tagPrefix:String);
  var fsm,dom,idom,obj,iobj,objset,iobjset,par,ipar,typ:Integer;
   procedure LinkTag(ref:Integer; link,name:String; typ,color:Integer);
   var tag:Integer;
   begin
    if (fsm_type(ref)>fsm_type_nil) then begin
     InitTag(tag,tagPrefix+fsm_path(ref)+name,typ);
     iNul(fsm_link(ref,link+'='+Str(tag)));
     if (typetag(tag)>0) then begin
      bNul(hashlist_setlink(smiuisrv_tab.tagLinks,nametag(tag),ref));
      if (color>=0) and (color<clNone) then bNul(SetTagColor(tag,color));
     end;
    end;
   end;
  begin
   tagPrefix:=Trim(tagPrefix);
   if (tagPrefix='') then tagPrefix:='SMI.';
   smiuisrv_tab.SmiTagPrefix:=tagPrefix;
   if (tagPrefix<>'') then begin
    fsm:=smiuisrv_fsm;
    LinkTag(fsm, smi_sym_tag_hostname,      smi_sym_hostname,     -3, smiuisrv_color_info   );
    LinkTag(fsm, smi_sym_tag_datetime,      smi_sym_datetime,     -3, smiuisrv_color_info   );
    LinkTag(fsm, smi_sym_tag_dns_node,      smi_sym_dns_node,     -3, smiuisrv_color_default);
    LinkTag(fsm, smi_sym_tag_dns_task,      smi_sym_dns_task,     -3, smiuisrv_color_default);
    LinkTag(fsm, smi_sym_tag_dns_pid,       smi_sym_dns_pid,      -1, smiuisrv_color_default);
    LinkTag(fsm, smi_sym_tag_dns_version,   smi_sym_dns_version,  -1, smiuisrv_color_default);
    for idom:=0 to fsm_count(fsm,fsm_type_domain)-1 do begin
     dom:=fsm_items(fsm,fsm_type_domain,idom);
     LinkTag(dom, smi_sym_tag_smi_message,       '.'+smi_sym_smi_message,       -3, smiuisrv_color_default);
     LinkTag(dom, smi_sym_tag_user_message,      '.'+smi_sym_user_message,      -3, smiuisrv_color_default);
     LinkTag(dom, smi_sym_tag_domain_name,       '.'+smi_sym_domain_name,       -3, smiuisrv_color_default);
     LinkTag(dom, smi_sym_tag_number_of_objects, '.'+smi_sym_number_of_objects, -1, smiuisrv_color_default);
     smiuisrv_update_linked_tag(dom,smi_sym_tag_domain_name,fsm_name(dom),smiuisrv_color_offline);
     smiuisrv_update_linked_tag(dom,smi_sym_tag_number_of_objects,Str(0),smiuisrv_color_offline);
     for iobj:=0 to fsm_count(dom,fsm_type_object)-1 do begin
      obj:=fsm_items(dom,fsm_type_object,iobj);
      LinkTag(obj, smi_sym_tag_object_name,     '.'+smi_sym_object_name,    -3, smiuisrv_color_default);
      LinkTag(obj, smi_sym_tag_object_title,    '.'+smi_sym_object_title,   -3, smiuisrv_color_default);
      LinkTag(obj, smi_sym_tag_object_param,    '.'+smi_sym_object_param,   -3, smiuisrv_color_default);
      LinkTag(obj, smi_sym_tag_state_name,      '.'+smi_sym_state_name,     -3, smiuisrv_color_default);
      LinkTag(obj, smi_sym_tag_state_title,     '.'+smi_sym_state_title,    -3, smiuisrv_color_default);
      LinkTag(obj, smi_sym_tag_busy_action,     '.'+smi_sym_busy_action,    -3, smiuisrv_color_default);
      for ipar:=0 to fsm_count(obj,fsm_type_parameter)-1 do begin
       par:=fsm_items(obj,fsm_type_parameter,ipar);
       typ:=fsm_type(par);
       if (typ>0) then begin
        LinkTag(par, smi_sym_tag_parameter,      '',                      -typ, smiuisrv_color_info);
       end;
      end;
     end;
     for iobjset:=0 to fsm_count(dom,fsm_type_objectset)-1 do begin
      objset:=fsm_items(dom,fsm_type_objectset,iobjset);
      LinkTag(objset, smi_sym_tag_objectset_list,   '.'+smi_sym_objectset_list,     -3, smiuisrv_color_default);
      LinkTag(objset, smi_sym_tag_objectset_name,   '.'+smi_sym_objectset_name,     -3, smiuisrv_color_default);
      LinkTag(objset, smi_sym_tag_objectset_title,  '.'+smi_sym_objectset_title,    -3, smiuisrv_color_default);
     end;
    end;
   end;
  end;
  procedure smiuisrv_init_last(v:Real);
  begin
   smiuisrv_tab.last.dns_node:=v;
   smiuisrv_tab.last.dns_task:=v;
   smiuisrv_tab.last.dns_pid:=v;
   smiuisrv_tab.last.dns_version:=v;
  end;
  procedure smiuisrv_init_fonts;
  begin
   smiuisrv_tab.SmiMenuFont:=Trim(ReadIni('SmiMenuFont'));
   if IsEmptyStr(smiuisrv_tab.SmiMenuFont) then smiuisrv_tab.SmiMenuFont:=smi_default_menu_font;
  end;
 begin
  smiuisrv_clear_all;
  smiuisrv_init_fonts;
  smiuisrv_init_colors;
  smiuisrv_init_rexrefs;
  smiuisrv_init_tagLinks;
  smiuisrv_register_commands;
  // SMIUISRV_EXE = ~~\Resource\DaqSite\SmiServer\SMIUISRV.EXE
  smiuisrv_tab.task.ExeFile:=DaqFileRef(AdaptExeFileName(DefaultExtension(ReadIni('SMIUISRV_EXE'),'.exe')),'');
  if not FileExists(smiuisrv_task_exefile)
  then smiuisrv_tab.task.ExeFile:=DaqFileRef(AdaptExeFileName('~~\Resource\DaqSite\SmiServer\SMIUISRV.EXE'),'');
  Assertion(FileExists(smiuisrv_task_exefile),'SMIUISRV_EXE = '+smiuisrv_task_exefile);
  // SMIUISRV_ARG = -auto -dom DEMO -sleep 1000
  smiuisrv_tab.task.CmdArgs:=Trim(ReadIniVar('SMIUISRV_ARG',4+8+16));
  Assertion((smiuisrv_task_cmdargs<>''),'SMIUISRV_ARG = '+smiuisrv_task_cmdargs);
  // SMIUISRV_DNS      = [&DimSrv] DIM_DNS_NODE %DIM_DNS_NODE% localhost
  smiuisrv_tab.task.DnsNode:=LoCaseStr(ExtractWord(1,ReadIniAlter('SMIUISRV_DNS',risModeDefault+risModeAlter)));
  Assertion((smiuisrv_task_dnsnode<>''),'SMIUISRV_DNS = '+smiuisrv_task_dnsnode);
  // SMIUISRV_FSM = -dom DEMO -sml run_con.sml
  smiuisrv_tab.task.FsmArgs:=Trim(ReadIniVar('SMIUISRV_FSM',4+8+16));
  Assertion((smiuisrv_task_fsmargs<>''),'SMIUISRV_FSM = '+smiuisrv_task_fsmargs);
  // SMIUISRV_WDT = 5
  smiuisrv_tab.task.RecoveryPeriod:=iValDef(ReadIni('SMIUISRV_WDT'),5)*1000;
  Assertion(smiuisrv_tab.task.RecoveryPeriod>=1000,StrFmt('SMIUISRV_WDT = %d',smiuisrv_tab.task.RecoveryPeriod div 1000));
  // SMIUISRV_SWM = 0
  smiuisrv_tab.task.display:=iValDef(ReadIni('SMIUISRV_SWM'),0);
  Assertion(smiuisrv_tab.task.display>=0,StrFmt('SMIUISRV_SWM = %d',smiuisrv_tab.task.display));
  // StdInPipeSize = 16
  smiuisrv_tab.task.StdInPipeSize:=iValDef(ReadIni('StdInPipeSize'),16)*1024;
  Assertion(smiuisrv_tab.task.StdInPipeSize>=1024,'StdInPipeSize = '+Str(smiuisrv_tab.task.StdInPipeSize div 1024));
  // StdOuPipeSize = 16
  smiuisrv_tab.task.StdOutPipeSize:=iValDef(ReadIni('StdOutPipeSize'),16)*1024;
  Assertion(smiuisrv_tab.task.StdOutPipeSize>=1024,'StdOutPipeSize = '+Str(smiuisrv_tab.task.StdOutPipeSize div 1024));
  // CMD : ~~\Resource\DaqSite\SmiServer\SMIUISRV.EXE -dns localhost -auto -dom DEMO -sleep 1000
  smiuisrv_tab.task.CmdLine:=smiuisrv_task_exefile;
  if (smiuisrv_task_dnsnode<>'') then smiuisrv_tab.task.CmdLine:=smiuisrv_task_cmdline+' -dns '+smiuisrv_task_dnsnode;
  if (smiuisrv_task_cmdargs<>'') then smiuisrv_tab.task.CmdLine:=smiuisrv_task_cmdline+' '+smiuisrv_tab.task.CmdArgs;
  smiuisrv_tab.task.CmdLine:=Trim(smiuisrv_task_cmdline);
  Success('CmdLine = '+smiuisrv_task_cmdline);
  // FSM
  smiuisrv_tab.task.FsmLine:='';
  if (smiuisrv_task_dnsnode<>'') then smiuisrv_tab.task.FsmLine:=smiuisrv_task_fsmline+' -dns '+smiuisrv_task_dnsnode;
  if (smiuisrv_task_fsmargs<>'') then smiuisrv_tab.task.FsmLine:=smiuisrv_task_fsmline+' '+smiuisrv_tab.task.FsmArgs;
  smiuisrv_tab.task.FsmLine:=Trim(smiuisrv_task_fsmline);
  Success('FsmLine = '+smiuisrv_task_fsmline);
  // FSM Manager
  smiuisrv_fsm_init(smiuisrv_task_fsmline);
  Assertion(fsm_ref(smiuisrv_fsm)<>0,'FSM Manager: '+fsm_name(smiuisrv_fsm));
  // Tooltip settings
  smiuisrv_tab.TooltipSeverityDelays:=StrFmt('%d',       60*1000)  // Delay for INFO
                                 +','+StrFmt('%d',     5*60*1000)  // Delay for WARNING
                                 +','+StrFmt('%d',    60*60*1000)  // Delay for ERROR
                                 +','+StrFmt('%d', 24*60*60*1000); // Delay for FATAL
  smiuisrv_tab.SmiuiSrvMessagesLogFile:=AddPathDelim(GetEnv('CRW_DAQ_VAR_TMP_DIR'))+AdaptFileName('SmiuiSrvMessages.log');
  smiuisrv_init_domains;
  // Initialize SMI tags
  smiuisrv_init_tags(ReadIni('SmiTagPrefix'));
  smiuisrv_init_last(MaxReal);
  // Task initialization
  smiuisrv_task_clear;
 end;
 //
 // SMIUISRV finalization.
 //
 procedure smiuisrv_finalize;
  procedure smiuisrv_fsm_free;
  begin
   fsm_kill(smiuisrv_tab.fsm);
  end;
  procedure smiuisrv_free_tagLinks;
  begin
   if (smiuisrv_tab.tagLinks<>0) then begin
    bNul(hashlist_free(smiuisrv_tab.tagLinks));
    smiuisrv_tab.tagLinks:=0;
   end;
  end;
  procedure smiuisrv_free_rexrefs;
  begin
   bNul(regexp_free(smiuisrv_tab.rexRefDomain));
   bNul(regexp_free(smiuisrv_tab.rexRefObject));
   bNul(regexp_free(smiuisrv_tab.rexRefAction));
   bNul(regexp_free(smiuisrv_tab.rexRefState));
  end;
 begin
  smiuisrv_free_tagLinks;
  smiuisrv_free_rexrefs;
  smiuisrv_task_stop(0);
  smiuisrv_fsm_free;
  smiuisrv_clear_all;
 end;
 //
 // SMIUISRV: find max length of FSM entity names in parent list.
 // Uses for nice formatting in list of object/state/action menus.
 //
 function smiuisrv_find_fsm_max_length(ref:Integer):Integer;
 var i,m,item:Integer;
 begin
  m:=0;
  if (fsm_type(ref)>fsm_type_nil) then
  if (fsm_type(fsm_parent(ref))>fsm_type_nil) then begin
   m:=fsm_link(fsm_parent(ref),fsm_ctrl(ref,'type')+'_'+smi_sym_max_length);
   if (m=0) then begin
    for i:=0 to fsm_count(fsm_parent(ref),fsm_type(ref))-1 do begin
     m:=imax(m,length(fsm_name(fsm_items(fsm_parent(ref),fsm_type(ref),i))));
    end;
    iNul(fsm_link(fsm_parent(ref),fsm_ctrl(ref,'type')+'_'+smi_sym_max_length+'='+Str(m)));
   end;
  end;
  smiuisrv_find_fsm_max_length:=m;
 end;
 //
 // SMIUISRV: find FSM entity by linked tag.
 //
 function smiuisrv_find_fsm_by_linked_tag(tag:Integer):Integer;
 var ref:Integer;
 begin
  ref:=0;
  if (typetag(tag)>0) then begin
   ref:=hashlist_getlink(smiuisrv_tab.tagLinks,nametag(tag));
   if (fsm_ref(ref)=0) then ref:=0;
  end;
  smiuisrv_find_fsm_by_linked_tag:=ref;
 end;
 //
 // SMIUISRV: return FSM entity associated with ClickTag.
 //
 function smiuisrv_click_fsm:Integer;
 begin
  if (ClickButton=0)
  then smiuisrv_click_fsm:=0
  else smiuisrv_click_fsm:=smiuisrv_find_fsm_by_linked_tag(ClickTag);
 end;
 //
 // SMIUISRV: Start menu for given state click.
 //
 procedure smiuisrv_start_menu_state_click(state:Integer; click:String);
 var n,act,iact,nact,wact:Integer;
  function ActionTitle(act,wact:Integer):String;
  var atitle,ctitle:String;
  begin
   atitle:=''; ctitle:='';
   if (fsm_type(act)>fsm_type_nil) then begin
    atitle:=RightPad(fsm_name(act),wact,' ');
    ctitle:=UpCaseStr(ExtractWord(1,fsm_get_cookie(act,smi_sym_title)));
    if (ctitle<>'') then atitle:=atitle+' - '+ctitle;
   end;
   ActionTitle:=atitle;
   atitle:=''; ctitle:='';
  end;
 begin
  if (fsm_type(state)=fsm_type_state) then
  if (fsm_count(state,fsm_type_action)>0) then begin
   act:=fsm_items(state,fsm_type_action,0);
   wact:=smiuisrv_find_fsm_max_length(act);
   nact:=0; wact:=0;
   for iact:=0 to fsm_count(state,fsm_type_action)-1 do begin
    act:=fsm_items(state,fsm_type_action,iact);
    if (Val(fsm_ctrl(act,fsm_sym_visible))>0) then begin
     wact:=imax(wact,length(fsm_name(act)));
     nact:=nact+1;
    end;
   end;
   if (nact>0) and (wact>0) then
   if EditStateReady then begin
    //////////////////////////////////////////
    n:=0+EditAddOpening('Действия для '+fsm_path(state)+'... ');
    n:=n+EditAddInputLn('Какое действие выполнить:');
    //////////////////////////////////////////
    for iact:=0 to fsm_count(state,fsm_type_action)-1 do begin
     act:=fsm_items(state,fsm_type_action,iact);
     if (Val(fsm_ctrl(act,fsm_sym_visible))>0) then begin
      n:=n+EditAddInputLn(ActionTitle(act,wact));
      if (fsm_get_cookie(act,smi_sym_confirm)='1')
      then n:=n+EditAddConfirm(EditGetLastInputLn)
      else n:=n+EditAddConfirm('');
      n:=n+EditAddCommand(smiuisrv_create_command(fsm_path(fsm_parent(state)),fsm_name(act)));
     end;
    end;
    //////////////////////////////////////////
    n:=n+EditAddText(SetFormUnderSensorLeftBottom(Click),'','@!>');
    n:=n+EditAddSetting('@set ListBox.Font '+smiuisrv_smimenufont);
    //////////////////////////////////////////
    n:=n+EditAddClosing('MenuList',EditGetUID(fsm_path(state)),'');
    if (n>0) then Problem('Error initializing MenuList!');
   end else Problem('Cannot edit right now!');
  end;
 end;
 //
 // SMIUISRV: FSM Menu Default Handler to handle menu state editing.
 //
 procedure smiuisrv_menu_state_default_handler;
 var fsm,dom,idom,obj,iobj,sta,ista:Integer;
 begin
  if EditStateDone then begin
   fsm:=smiuisrv_fsm;
   for idom:=0 to fsm_count(fsm,fsm_type_domain)-1 do begin
    dom:=fsm_items(fsm,fsm_type_domain,idom);
    for iobj:=0 to fsm_count(dom,fsm_type_object)-1 do begin
     obj:=fsm_items(dom,fsm_type_object,iobj);
     for ista:=0 to fsm_count(obj,fsm_type_state)-1 do begin
      sta:=fsm_items(obj,fsm_type_state,ista);
      EditMenuDefaultHandler(EditGetUID(fsm_path(sta)));
     end;
    end;
   end;
  end;
 end;
 //
 // SMIUISRV: Default handler of FSM clicks.
 // Example: if (smiuisrv_click_fsm<>0) then smiuisrv_click_fsm_default_handler(ClickParams(''));
 //
 procedure smiuisrv_click_fsm_default_handler(click:String);
 var ref,tag,ver,obj,sta:Integer; msg,pnl:String;
  procedure ClearLocals;
  begin
   msg:=''; pnl:='';
  end;
  function HasWindow(win,wintypes:String):Boolean;
  var n,l,wi,wt:Integer;
  begin
   n:=0;
   if not IsEmptyStr(win) then
   for wt:=1 to WordCount(wintypes) do
   if (n=0) then begin
    wi:=0;
    repeat
     if IsEmptyStr(ParamStr(ExtractWord(wt,wintypes)+' '+Str(wi))) then wi:=-1 else
     if IsSameText(win,ParamStr(ExtractWord(wt,wintypes)+' '+Str(wi))) then n:=n+1 else wi:=wi+1;
    until (n>0) or (wi<=0);
   end; 
   HasWindow:=(n>0);
  end;
 begin
  ClearLocals;
  tag:=findtag(CookieScan(click,'Tag',0));
  ref:=smiuisrv_find_fsm_by_linked_tag(tag);
  if (fsm_ref(ref)<>0) then begin
   // FsmManager
   if (fsm_type(ref)=fsm_type_manager) then begin
    if IsSameText(ExtractFileExt(nametag(tag)),'.'+smi_sym_hostname)
    or IsSameText(ExtractFileExt(nametag(tag)),'.'+smi_sym_datetime) then begin
     msg:=GetDateTime(mSecNow)+' => '
         +' SMI Server: '+TagAsText(fsm_link(ref,smi_sym_tag_hostname))
         +', Date-Time: '+TagAsText(fsm_link(ref,smi_sym_tag_datetime));
     DevPostCmdLocal('@tooltip guid SMI/INFO preset stdInformation delay 60000 text '+AnsiQuotedIfNeed(msg,QuoteMark));
    end;
    if IsSameText(ExtractFileExt(nametag(tag)),'.'+smi_sym_dns_version) then begin
     ver:=iGetTag(tag);
     msg:=GetDateTime(mSecNow)+' => DIM DNS IS NOT RUNNING.';
     if (ver>0) then
     msg:=GetDateTime(mSecNow)+' => '
         +' DIM DNS Version: '+TagAsText(fsm_link(ref,smi_sym_tag_dns_version))
         +', Node: '+TagAsText(fsm_link(ref,smi_sym_tag_dns_node))
         +', Task: '+TagAsText(fsm_link(ref,smi_sym_tag_dns_task))
         +', PID: '+TagAsText(fsm_link(ref,smi_sym_tag_dns_pid));
     DevPostCmdLocal('@tooltip guid SMI/INFO preset stdInformation delay 60000 text '+AnsiQuotedIfNeed(msg,QuoteMark));
    end;
   end;
   // FsmDomain
   if (fsm_type(ref)=fsm_type_domain) then begin
    if IsSameText(ExtractFileExt(nametag(tag)),'.'+smi_sym_domain_name) then begin
     msg:=GetDateTime(mSecNow)+' => '
         +' SMI Domain: '+TagAsText(fsm_link(ref,smi_sym_tag_domain_name))
         +', Num Objects: '+TagAsText(fsm_link(ref,smi_sym_tag_number_of_objects));
     DevPostCmdLocal('@tooltip guid SMI/INFO preset stdInformation delay 60000 text '+AnsiQuotedIfNeed(msg,QuoteMark));
    end;
    if IsSameText(ExtractFileExt(CookieScan(click,'Sensor',0)),'.'+smi_sym_logo) then begin
     DevPostCmdLocal('@BrowseHelp');
    end;
   end;
   // FsmObject
   if (fsm_type(ref)=fsm_type_object) then begin
    obj:=ref; sta:=fsm_get_state(obj); // get object and current state
    if IsSameText(ExtractFileExt(nametag(tag)),'.'+smi_sym_object_name)
    or IsSameText(ExtractFileExt(nametag(tag)),'.'+smi_sym_object_title) then begin
     pnl:=fsm_get_cookie(ref,fsm_sym_panel);
     pnl:=smiuisrv_substitute_keywords(ref,pnl);
     if IsEmptyStr(pnl) or not HasWindow(pnl,'CIRWINNAME,CURWINNAME,TABWINNAME') then begin
      msg:=GetDateTime(mSecNow)+' => '+' SMI FSM Object: '+fsm_path(ref)+', State: '+fsm_name(fsm_get_state(ref));
      DevPostCmdLocal('@tooltip guid SMI/INFO preset stdInformation delay 15000 text '+AnsiQuotedIfNeed(msg,QuoteMark));
     end else begin
      bNul(WinDraw(pnl) and WinSelect(pnl));
      Success('Requested Panel '+pnl);
     end;
    end;
    if IsSameText(ExtractFileExt(nametag(tag)),'.'+smi_sym_state_name)
    or IsSameText(ExtractFileExt(nametag(tag)),'.'+smi_sym_state_title) then begin
     smiuisrv_start_menu_state_click(sta,click);
    end;
   end;
  end;
  ClearLocals;
 end;
 //
 // SMIUISRV: Parse comma separated line (arg) to words (w1-w6), return number of words found.
 //
 function smiuisrv_parse_csv(var arg,w1,w2,w3,w4,w5,w6:String; nlast:Integer):Integer;
 const nmax=6;
 var i,p,n,len:Integer;
  procedure AssignParam(n:Integer; s:String);
  begin
   if (n>=1) then
   if (n<=nmax) then begin
    s:=Trim(s);
    if (s='-') then s:='';
    case n of
     1: w1:=s;
     2: w2:=s;
     3: w3:=s;
     4: w4:=s;
     5: w5:=s;
     6: w6:=s;
    end;
   end;
  end;
 begin
  w1:=''; w2:=''; w3:=''; w4:=''; w5:=''; w6:='';
  n:=0; len:=Length(arg);
  if (len>0) then begin
   i:=0; p:=1;
   repeat
    i:=PosEx(',',arg,i+1);
    if (i>0) then begin
     n:=n+1;
     if (n=nlast)
     then begin AssignParam(n,Copy(arg,p,len-p+1)); i:=0; end
     else begin AssignParam(n,Copy(arg,p,i-p)); end;
     p:=i+1;
    end else begin
     if (p<=len) then begin
      n:=n+1;
      AssignParam(n,Copy(arg,p,len-p+1));
     end;
    end;
   until (i<=0) or (n>=nmax);
  end;
  smiuisrv_parse_csv:=n;
 end;
 //
 // SMIUISRV: Update FSM state and mark it as modified.
 //
 procedure smiuisrv_update_object_state(objectName,stateName,busyAction:String);
 var fsm,obj,sta,act:Integer;
 begin
  fsm:=smiuisrv_fsm;
  obj:=fsm_find(fsm,fsm_type_object,objectName);
  sta:=fsm_find(obj,fsm_type_state,stateName);
  act:=fsm_find(sta,fsm_type_action,busyAction);
  iNul(fsm_set_state(obj,sta)+fsm_modified(obj,1));
  iNul(fsm_link(obj,smi_sym_busy_action+'='+Str(act)));
 end;
 //
 // SMIUISRV: Get title of FSM entity (ref).
 //
 function smiuisrv_get_title(ref:Integer):String;
 var title:String;
 begin
  title:='';
  if (fsm_type(ref)=fsm_type_state) then begin
   title:=ExtractWord(1,fsm_get_cookie(ref,smi_sym_title));
   if (title='') then title:=fsm_name(ref);
  end else
  if (fsm_type(ref)=fsm_type_object) then begin
   title:=ExtractWord(1,fsm_get_cookie(ref,smi_sym_title));
   if (title<>'') then title:=smiuisrv_get_title(fsm_parent(ref))+'::'+title;
   if (title='') then title:=fsm_path(ref);
  end else
  if (fsm_type(ref)=fsm_type_objectset) then begin
   title:=ExtractWord(1,fsm_get_cookie(ref,smi_sym_title));
   if (title<>'') then title:=smiuisrv_get_title(fsm_parent(ref))+'::'+title;
   if (title='') then title:=fsm_path(ref);
  end else
  if (fsm_type(ref)=fsm_type_domain) then begin
   title:=ExtractWord(1,fsm_get_cookie(ref,smi_sym_title));
   if (title='') then title:=fsm_name(ref);
  end;
  smiuisrv_get_title:=title;
  title:='';
 end;
 //
 // SMIUISRV default FSM polling.
 //
 procedure smiuisrv_default_fsm_poll;
  //
  procedure Notify(msg:String);
  begin
   if (msg<>'') then Details(msg);
  end;
  //
  procedure update_manager(fsm:Integer);
  begin
   Notify('Modified Manager '+fsm_name(fsm)+': '+fsm_ctrl(fsm,fsm_sym_declaration));
  end;
  procedure update_domain(dom:Integer);
  var n,color:Integer;
  begin
   Notify('Modified Domain '+fsm_path(dom)+': '+fsm_ctrl(dom,fsm_sym_declaration));
   n:=fsm_ask_iparam(dom,smi_sym_number_of_objects);
   if (n>0) then color:=smiuisrv_color_online else color:=smiuisrv_color_offline;
   smiuisrv_update_linked_tag(dom,smi_sym_tag_number_of_objects,Str(n),color);
   smiuisrv_update_linked_tag(dom,smi_sym_tag_domain_name,fsm_name(dom),color);
  end;
  //
  procedure update_object(obj:Integer);
  var dom,sta,act,statecolor:Integer; name,title:String;
  begin
   name:=''; title:='';
   Notify('Modified Object '+fsm_path(obj)+': '+fsm_ctrl(obj,fsm_sym_declaration));
   dom:=fsm_parent(obj);
   sta:=fsm_get_state(obj);
   act:=fsm_link(obj,smi_sym_busy_action);
   if (act=0) then begin
    statecolor:=StringToColorDef(fsm_ctrl(sta,fsm_sym_color),smiuisrv_color_neutral);
    Success('State '+fsm_path(sta)+' '+ColorToString(statecolor));
   end else begin
    statecolor:=fsm_link(dom,smi_sym_busy_color);
    Success('State '+fsm_path(sta)+' '+fsm_get_cookie(dom,smi_sym_busy_title)+' '+fsm_name(act)+' '+ColorToString(statecolor));
   end;
   name:=fsm_path(obj); title:=smiuisrv_get_title(obj);
   smiuisrv_update_linked_tag(obj,smi_sym_tag_object_name,name,smiuisrv_color_default);
   smiuisrv_update_linked_tag(obj,smi_sym_tag_object_title,title,smiuisrv_color_default);
   name:=fsm_name(sta); title:=smiuisrv_get_title(sta);
   if (act<>0) then begin
    name:=ExtractWord(1,fsm_get_cookie(dom,smi_sym_busy_title));
    title:=ExtractWord(1,fsm_get_cookie(dom,smi_sym_busy_title));
   end;
   smiuisrv_update_linked_tag(obj,smi_sym_tag_state_name,name,statecolor);
   smiuisrv_update_linked_tag(obj,smi_sym_tag_state_title,title,statecolor);
   smiuisrv_update_linked_tag(obj,smi_sym_tag_busy_action,fsm_name(act),statecolor);
   name:=''; title:='';
  end;
  //
  procedure update_objectset(objset:Integer);
  var dom:Integer; name,title,list:String;
  begin
   name:=''; title:=''; list:='';
   Notify('Modified Objectset '+fsm_path(objset)+': '+fsm_ctrl(objset,fsm_sym_declaration));
   dom:=fsm_parent(objset);
   list:=fsm_ctrl(objset,fsm_sym_unionlist);
   name:=fsm_path(objset); title:=smiuisrv_get_title(objset);
   smiuisrv_update_linked_tag(objset,smi_sym_tag_objectset_list,list,smiuisrv_color_default);
   smiuisrv_update_linked_tag(objset,smi_sym_tag_objectset_name,name,smiuisrv_color_default);
   smiuisrv_update_linked_tag(objset,smi_sym_tag_objectset_title,title,smiuisrv_color_default);
   name:=''; title:=''; list:='';
  end;
  //
  procedure update_state(sta:Integer);
  begin
   Notify('Modified State '+fsm_path(sta)+': '+fsm_ctrl(sta,fsm_sym_declaration));
  end;
  //
  procedure update_action(act:Integer);
  begin
   Notify('Modified Action '+fsm_path(act)+': '+fsm_ctrl(act,fsm_sym_declaration));
  end;
  //
  procedure update_parameter(par:Integer);
  var tag,typ:Integer;
  begin
   Notify('Modified Parameter '+fsm_path(par)+': '+fsm_ctrl(par,fsm_sym_declaration));
   typ:=fsm_type(par);
   tag:=fsm_link(par,smi_sym_tag_parameter);
   if (typ>0) then
   if (typetag(tag)=typ) then begin
    if (typ=fsm_type_int) then begin
     bNul(iSetTag(tag,fsm_get_iparam(par)));
    end;
    if (typ=fsm_type_float) then begin
     bNul(rSetTag(tag,fsm_get_fparam(par)));
    end;
    if (typ=fsm_type_string) then begin
     bNul(sSetTag(tag,fsm_get_sparam(par)));
    end;
   end;
  end;
  procedure handle_modified(ref:Integer);
  var i,typ,item:Integer;
  begin
   typ:=fsm_type(ref);
   if (typ>fsm_type_nil) then
   if (fsm_modified(ref,0)>0) then begin
    if (typ=fsm_type_state)     then update_state(ref)     else
    if (typ=fsm_type_action)    then update_action(ref)    else
    if (typ=fsm_type_object)    then update_object(ref)    else
    if (typ=fsm_type_int)       then update_parameter(ref) else
    if (typ=fsm_type_float)     then update_parameter(ref) else
    if (typ=fsm_type_string)    then update_parameter(ref) else
    if (typ=fsm_type_objectset) then update_objectset(ref) else
    if (typ=fsm_type_domain)    then update_domain(ref)    else
    if (typ=fsm_type_manager)   then update_manager(ref);
    for i:=0 to fsm_count(ref,fsm_type_any)-1 do begin
     // Recursive call of modified FSM entity handler
     item:=fsm_items(ref,fsm_type_any,i);
     if (fsm_modified(item,-1)>0)
     then handle_modified(item);
    end;
   end;
  end;
  procedure UpdateHostTime;
  var fsm,tag:Integer; ms:Real;
  begin
   fsm:=smiuisrv_fsm; ms:=mSecNow;
   tag:=fsm_link(fsm,smi_sym_tag_datetime);
   if (typetag(tag)=3) then begin
    bNul(sSetTag(tag,GetDateTime(ms)));
    bNul(SetTagTimer(tag,ms));
   end;
   tag:=fsm_link(fsm,smi_sym_tag_hostname);
   if (typetag(tag)=3) then begin
    bNul(sSetTag(tag,ParamStr('COMPUTERNAME')));
    bNul(SetTagTimer(tag,ms));
   end;
  end;
 begin
  handle_modified(smiuisrv_fsm);
  if (SysTimer_Pulse(1000)>0) then UpdateHostTime;
  if EditStateDone then smiuisrv_menu_state_default_handler;
 end;
 //
 // SMIUISRV default console handler.
 //
 function smiuisrv_default_handler(var Data,cmd,arg:String; cmdid:Integer):Boolean;
 var complete:Boolean; status,id,n,m,dom,obj:Integer; w1,w2,w3,w4,w5,w6:String;
  procedure ClearLocals;
  begin
   w1:=''; w2:=''; w3:=''; w4:=''; w5:=''; w6:='';
  end;
  procedure WrongDataFormat(var Data:String);
  begin
   Trouble('Error: wrong data format: '+Data);
  end;
  procedure smiuisrv_send_filter(var arg:String);
  var cid,dom:Integer; c,a:String;
  begin
   c:=''; a:='';
   if GotCommandId(arg,c,a,cid) then begin
    if (cid=smiuisrv_tab.cmd_smiui_number_of_objects) then begin
     dom:=fsm_find(smiuisrv_fsm,fsm_type_domain,ExtractWord(1,a));
     iNul(fsm_link(dom,smi_sym_see_number_of_objects+'=1'));
    end;
   end;
   c:=''; a:='';
  end;
  function TooltipSeverityPresetDelay(severity:String):String;
  var s:String; sev,del:Integer;
  begin
   s:='';
   sev:=WordIndex(severity,smi_severity_names);
   if (sev>=smi_severity_info) and (sev<=smi_severity_fatal) then begin
    s:='preset '+ExtractWord(sev,smi_severity_presets);
    del:=Val(ExtractWord(sev,smiuisrv_tab.TooltipSeverityDelays));
    if (del>0) then s:=s+' delay '+Str(del);
   end;
   TooltipSeverityPresetDelay:=s;
   s:='';
  end;
  procedure smiui_parse_object_params(obj:integer; paramList:String);
  var list,i,pe,pt,typ,iv:Integer; line,sn,sv,st:String; fv:Real;
  begin
   line:=''; sn:=''; sv:=''; st:='';
   if (fsm_type(obj)=fsm_type_object) then begin
    list:=StringToText(StringReplace(paramList,'/',EOL,rfReplaceAll));
    for i:=0 to text_numln(list)-1 do begin
     line:=text_getln(list,i); pe:=Pos('=',line); sn:=line; sv:='';
     if (pe>0) then begin sn:=Trim(Copy(line,1,pe-1)); sv:=Trim(Copy(line,pe+1)); end;
     pt:=Pos('(',sn); st:='(S)'; if (pt>0) then begin st:=Copy(sn,pt); sn:=Copy(sn,1,pt-1); end;
     if IsLexeme(sn,lex_name) and (sv<>'') then begin
      if IsSameText(st,'(I)') then begin
       if IsLexeme(sv,lex_iparam) then begin
        iv:=Val(sv); fsm_put_iparam(obj,sn,iv);
        iNul(fsm_modified(fsm_find(obj,fsm_type_int,sn),1));
       end else Problem(fsm_path(obj)+': Invalid data in '+line);
      end else
      if IsSameText(st,'(F)') then begin
       if IsLexeme(sv,lex_fparam) then begin
        fv:=rVal(sv); fsm_put_fparam(obj,sn,fv);
        iNul(fsm_modified(fsm_find(obj,fsm_type_float,sn),1));
       end else Problem(fsm_path(obj)+': Invalid data in '+line);
      end else
      if IsSameText(st,'(S)') then begin
       if IsLexeme(sv,lex_sparam) then begin
        if (StrFetch(sv,1)=QuoteMark) then sv:=ExtractFirstParam(sv,QuoteMark);
        sv:=backslash_decode(sv); fsm_put_sparam(obj,sn,sv);
        iNul(fsm_modified(fsm_find(obj,fsm_type_string,sn),1));
       end else Problem(fsm_path(obj)+': Invalid data in '+line);
      end else
      Problem(fsm_path(obj)+': Unknown type in '+line);
     end;
    end;
    bNul(text_free(list));
   end;
   line:=''; sn:=''; sv:=''; st:='';
  end;
  //
  // Domain connect handler.
  //
  procedure smiui_connect_domain_handler(var callCount,domainName,numObjects,objectList:String);
  var fsm,dom,count,numobjs:Integer;
  begin
   fsm:=smiuisrv_fsm;
   count:=Val(callCount); numobjs:=Val(numObjects);
   dom:=fsm_find(fsm,fsm_type_domain,domainName);
   fsm_add_iparam(dom,smi_sym_number_of_objects,numobjs);
   Success('Connected domain '+fsm_name(dom)+' with '+Str(numobjs)+' objects.');
   iNul(fsm_modified(dom,1));
  end;
  //
  // Object state change handler.
  //
  procedure smiui_statechange_handler(var callCount,objectName,stateName,busyAction,actionList,paramList:String);
  var fsm,obj,sta,act,count:Integer;
  begin
   fsm:=smiuisrv_fsm; count:=Val(callCount);
   obj:=fsm_find(fsm,fsm_type_object,objectName);
   sta:=fsm_find(obj,fsm_type_state,stateName);
   act:=fsm_find(sta,fsm_type_action,busyAction);
   smiui_parse_object_params(obj,paramList);
   iNul(fsm_set_state(obj,sta)+fsm_modified(obj,1));
   iNul(fsm_link(obj,smi_sym_busy_action+'='+Str(act)));
   smiuisrv_update_linked_tag(obj,smi_sym_tag_object_param,paramList,smiuisrv_color_btnface);
   //Success('State '+fsm_path(sta)+' has actions '+actionList);
   //smiuisrv_update_object_state(objectName,stateName,busyAction);
  end;
  //
  // Objectset change handler.
  //
  procedure smiui_objectsetchange_handler(var callCount,objsetName,objList:String);
  var fsm,objset,count:Integer;
  begin
   fsm:=smiuisrv_fsm; count:=Val(callCount);
   objset:=fsm_find(fsm,fsm_type_objectset,objsetName);
   sNul(fsm_ctrl(objset,fsm_sym_unionlist+'='+StringReplace(objList,'|',',',rfReplaceAll)));
   iNul(fsm_modified(objset,1));
  end;
  //
  // smiSM options handler.
  //
  procedure smiui_options_handler(domainName,optionsList:String);
  var fsm,dom:Integer;
  begin
   fsm:=smiuisrv_fsm;
   dom:=fsm_find(fsm,fsm_type_domain,domainName);
   Success('Domain '+fsm_name(dom)+' options:'+EOL+StringReplace(optionsList,'|',EOL,rfReplaceAll));
  end;
  //
  // Calculate GUID for tooltip.
  //
  function smiui_calc_guid(smi,severity,name:String):String;
  const useSeverity=false;
  begin
   if useSeverity
   then smiui_calc_guid:='guid '+smi+'/'+severity+'/'+name
   else smiui_calc_guid:='guid '+smi+'/'+name;
  end;
  //
  // SMI and User message handler.
  //
  procedure smiui_message_handler(var callCount,domain,msg:String; tagId:String);
  var s,w1,w2,w3,btn:String; dom,tag,count:Integer;
  begin
   s:=''; w1:=''; w2:=''; w3:=''; btn:='';
   msg:=Trim(msg);
   if (msg<>'') then begin
    count:=Val(callCount);
    dom:=fsm_find(smiuisrv_fsm,fsm_type_domain,domain);
    if IsSameText(msg,'No link') then msg:='SMI ERROR '+domain+', '+msg;
    tag:=fsm_link(dom,tagId); if (typetag(tag)=3) then bNul(sSetTag(tag,msg));
    rNul(Eval('@system @async @silent @log --event '+smiuisrv_tab.SmiuiSrvMessagesLogFile+' '+msg));
    w1:=ExtractWord(1,msg); w2:=ExtractWord(2,msg); w3:=ExtractWord(3,msg);
    s:='@tooltip '+smiui_calc_guid(w1,w2,w3)+' '+TooltipSeverityPresetDelay(w2);
    s:=s+' text '+AnsiQuotedIfNeed(GetDateTime(msecnow)+' => '+msg,QuoteMark);
    btn:=' btn1 Log cmd1 '+AnsiQuotedIfNeed(DaqFileRef(AdaptExeFileName('~~\Resource\SmiuiSrvMessages.cmd'),''),QuoteMark);
    if (Length(s+btn)<250) then s:=s+btn;
    DevPostCmdLocal(s);
   end;
   s:=''; w1:=''; w2:=''; w3:=''; btn:='';
  end;
  procedure smiui_smi_message_handler(var callCount,domain,msg:String);
  begin
   smiui_message_handler(callCount,domain,msg,smi_sym_tag_smi_message);
  end;
  procedure smiui_user_message_handler(var callCount,domain,msg:String);
  begin
   smiui_message_handler(callCount,domain,msg,smi_sym_tag_user_message);
  end;
  procedure smiui_number_of_objects_handler(var numObjects,domName:String);
  var fsm,dom,n,m:Integer;
  begin
   n:=Val(numObjects); fsm:=smiuisrv_fsm;
   dom:=fsm_find(fsm,fsm_type_domain,domName);
   m:=fsm_ask_iparam(dom,smi_sym_number_of_objects);
   if (n<>m) then begin
    fsm_add_iparam(dom,smi_sym_number_of_objects,n);
    iNul(fsm_modified(dom,1));
    if (n>0)
    then Success('Domain '+fsm_name(dom)+' connected.')
    else Problem('Domain '+fsm_name(dom)+' disconnected.');
   end;
   if (fsm_link(dom,smi_sym_see_number_of_objects)>0) then begin
    iNul(fsm_link(dom,smi_sym_see_number_of_objects+'=0'));
    if (n>0)
    then Success(smiuisrv_prompt+Data)
    else Problem(smiuisrv_prompt+Data);
   end else begin
    if DebugFlagEnabled(dfDetails)
    then Details(smiuisrv_prompt+Data);
   end;
  end;
  procedure smiui_dns_version_handler(var dnsVersion,dnsNode,dnsTask,dnsPID:String);
  var fsm,ver,pid,color:Integer;
  begin
   fsm:=smiuisrv_fsm;
   ver:=Val(dnsVersion); pid:=Val(dnsPid);
   if ShouldRefresh(smiuisrv_tab.last.dns_pid,pid)
     +ShouldRefresh(smiuisrv_tab.last.dns_version,ver)
     +ShouldRefresh(smiuisrv_tab.last.dns_node,hashindexof(dnsNode,0,0))
     +ShouldRefresh(smiuisrv_tab.last.dns_task,hashindexof(dnsTask,0,0))>0
   then begin
    ver:=imax(ver,0);
    if (dnsTask='') or (pid=0) or (ver<0) then dnsTask:='OFFLINE';
    if (ver>0) then color:=smiuisrv_color_online else color:=smiuisrv_color_offline;
    smiuisrv_update_linked_tag(fsm,smi_sym_tag_dns_version,Str(ver),color);
    smiuisrv_update_linked_tag(fsm,smi_sym_tag_dns_node,dnsNode,color);
    smiuisrv_update_linked_tag(fsm,smi_sym_tag_dns_task,dnsTask,color);
    smiuisrv_update_linked_tag(fsm,smi_sym_tag_dns_pid,dnsPID,color);
   end;
  end;
  procedure WorkIsCompleted;
  begin
   complete:=true;
   Data:='';
  end;
 begin
  ClearLocals;
  complete:=false;
  if Length(Data)>0 then begin
   if (cmdid>0) then begin
    //
    // Send a command to SMIUISRV server console:
    // @smiuisrv_send @smiui_send_command=DEMO::LOGGER,LOG
    //
    if (cmdid = smiuisrv_tab.cmd_smiuisrv_send) then begin
     arg:=Trim(arg);
     if LooksLikeCommand(arg) then begin
      smiuisrv_send_filter(arg);
      smiuisrv_task_send(arg);
      if DebugFlagEnabled(dfDetails)
      then Details(smiuisrv_prompt+Data);
     end;
     WorkIsCompleted;
    end else
    //
    // @smiuisrv_restart=0
    //
    if (cmdid=smiuisrv_tab.cmd_smiuisrv_restart) then begin
     smiuisrv_task_stop(Val(ExtractWord(1,arg)));
     smiuisrv_tab.task.RecoveryTimer:=msecnow-smiuisrv_tab.task.RecoveryPeriod;
     Success(smiuisrv_prompt+Trim(Data));
     WorkIsCompleted;
    end else
    //
    // @smiuisrv_fsm_dump 1 DEMO::LOGGER ^CLASS
    //
    if (cmdid=smiuisrv_tab.cmd_smiuisrv_fsm_dump) then begin
     Success(smiuisrv_prompt+Trim(Data));
     m:=Val(ExtractWord(1,arg));
     writeln(fsm_dump(smiuisrv_fsm,m,SkipWords(1,arg)));
     WorkIsCompleted;
    end else
    //
    // @smiui_connect_domain_handler=1,DEMO,3,DEMO::RUN|DEMO::LOGGER/ASSOCIATED|DEMO::EVT_BUILDER/ASSOCIATED
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_connect_domain_handler) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=4) then begin
      smiui_connect_domain_handler(w1,w2,w3,w4);
      Success(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_statechange_handler=2,DEMO::EVT_BUILDER,ERROR,-,RECOVER,NUMBER_T(I)=145/NUMBER_P(I)=28
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_statechange_handler) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=6) then begin
      smiui_statechange_handler(w1,w2,w3,w4,w5,w6);
      Success(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_smi_message_handler=1,DEMO,SMI INFO DEMO, State Manager started
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_smi_message_handler) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,3)=3) then begin
      smiui_smi_message_handler(w1,w2,w3);
      Success(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_user_message_handler=2,DEMO,SMI INFO DEMO::AUTO_PILOT, doing ACTIVATE
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_user_message_handler) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,3)=3) then begin
      smiui_user_message_handler(w1,w2,w3);
      Success(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_objectsetchange_handler=1,DEMO::LOW_SET,DEMO::LOGGER|DEMO::EVT_BUILDER
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_objectsetchange_handler) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=3) then begin
      smiui_objectsetchange_handler(w1,w2,w3);
      Success(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_dns_version=2033,localhost,DIS_DNS@ak-xp-vm,4032
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_dns_version) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=4) then begin
      smiui_dns_version_handler(w1,w2,w3,w4);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_current_state=1,DEMO::LOGGER,NOT_LOGGING,-
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_current_state) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=4) then begin
      status:=Val(w1);
      if (status>0) then smiuisrv_update_object_state(w2,w3,w4);
      if (status>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_send_command=1,DEMO::LOGGER,LOG
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_send_command) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,3)=3) then begin
      status:=Val(w1);
      if (status>0)
      then Details(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_ep_send_command=1,DEMO::LOGGER,LOG
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_ep_send_command) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,3)=3) then begin
      status:=Val(w1);
      if (status>0)
      then Details(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_send_command_wait=1,DEMO::LOGGER,LOG
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_send_command_wait) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,3)=3) then begin
      status:=Val(w1);
      if (status>0)
      then Details(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_ep_send_command_wait=1,DEMO::LOGGER,LOG
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_ep_send_command_wait) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,3)=3) then begin
      status:=Val(w1);
      if (status>0)
      then Details(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_change_option=1,DEMO,d,8
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_change_option) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=4) then begin
      status:=Val(w1);
      if (status>0)
      then Details(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_change_option_wait=1,DEMO,d,8
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_change_option_wait) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=4) then begin
      status:=Val(w1);
      if (status>0)
      then Details(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_get_options=1,DEMO,d/INT/9/Diagnostic Level|...
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_get_options) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,3)=3) then begin
      status:=Val(w1);
      if (status>0) then smiui_options_handler(w2,w3);
      if (status>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_number_of_objects=6,DEMO
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_number_of_objects) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      smiui_number_of_objects_handler(w1,w2);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_connect_domain=6,DEMO
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_connect_domain) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      status:=Val(w1);
      if (status>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_book_connect_domain=0,DEMO
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_book_connect_domain) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      status:=Val(w1);
      dom:=fsm_find(smiuisrv_fsm,fsm_type_domain,w2);
      fsm_add_iparam(dom,smi_sym_book_user_message_id,0);
      fsm_add_iparam(dom,smi_sym_book_smi_message_id,0);
      fsm_add_iparam(dom,smi_sym_number_of_objects,0);
      if (status=0) // expected ZERO !!!
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_cancel_connect_domain=1,DEMO
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_cancel_connect_domain) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      status:=Val(w1);
      dom:=fsm_find(smiuisrv_fsm,fsm_type_domain,w2);
      fsm_add_iparam(dom,smi_sym_book_user_message_id,0);
      fsm_add_iparam(dom,smi_sym_book_smi_message_id,0);
      fsm_add_iparam(dom,smi_sym_number_of_objects,0);
      if (status>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_shutdown_domain=1,DEMO
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_shutdown_domain) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      status:=Val(w1);
      if (status>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_check_proxy=1,DEMO::LOGGER
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_check_proxy) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      status:=Val(w1);
      if (status>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_kill=1,DEMO
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_kill) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      status:=Val(w1);
      if (status>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_book_statechange=18,DEMO::LOGGER
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_book_statechange) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      id:=Val(w1);
      obj:=fsm_find(smiuisrv_fsm,fsm_type_object,w2);
      fsm_add_iparam(obj,smi_sym_book_statechange_id,id);
      if (id>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_cancel_statechange=1,DEMO::LOGGER
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_cancel_statechange) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      status:=Val(w1);
      obj:=fsm_find(smiuisrv_fsm,fsm_type_object,w2);
      fsm_add_iparam(obj,smi_sym_book_statechange_id,0);
      if (status>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_book_smi_message=10,DEMO
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_book_smi_message) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      id:=Val(w1);
      dom:=fsm_find(smiuisrv_fsm,fsm_type_domain,w2);
      fsm_add_iparam(dom,smi_sym_book_smi_message_id,id);
      if (id>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_cancel_smi_message=1,DEMO
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_cancel_smi_message) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      status:=Val(w1);
      dom:=fsm_find(smiuisrv_fsm,fsm_type_domain,w2);
      fsm_add_iparam(dom,smi_sym_book_smi_message_id,0);
      if (status>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_book_user_message=11,DEMO
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_book_user_message) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      id:=Val(w1);
      dom:=fsm_find(smiuisrv_fsm,fsm_type_domain,w2);
      fsm_add_iparam(dom,smi_sym_book_user_message_id,id);
      if (id>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_cancel_user_message=1,DEMO
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_cancel_user_message) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      status:=Val(w1);
      dom:=fsm_find(smiuisrv_fsm,fsm_type_domain,w2);
      fsm_add_iparam(dom,smi_sym_book_user_message_id,0);
      if (status>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_list_domain_objects=6,DEMO,DEMO::RUN|DEMO::LOGGER/ASSOCIATED|DEMO::EVT_BUILDER/ASSOCIATED
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_list_domain_objects) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=3) then begin
      n:=Val(w1);
      if (n>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_list_domain_objectsets=2,DEMO,DEMO::LOW_SET|DEMO::TOP_SET
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_list_domain_objectsets) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=3) then begin
      n:=Val(w1);
      if (n>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_book_objectsetchange=1,DEMO::LOW_SET
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_book_objectsetchange) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      id:=Val(w1);
      obj:=fsm_find(smiuisrv_fsm,fsm_type_objectset,w2);
      fsm_add_iparam(obj,smi_sym_book_objectsetchange_id,id);
      if (id>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_cancel_objectsetchange=1,DEMO::LOW_SET
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_cancel_objectsetchange) then begin
     if (smiuisrv_parse_csv(arg,w1,w2,w3,w4,w5,w6,0)=2) then begin
      status:=Val(w1);
      obj:=fsm_find(smiuisrv_fsm,fsm_type_objectset,w2);
      fsm_add_iparam(obj,smi_sym_book_objectsetchange_id,0);
      if (status>0)
      then Success(smiuisrv_prompt+Data)
      else Problem(smiuisrv_prompt+Data);
     end else WrongDataFormat(Data);
     WorkIsCompleted;
    end else
    //
    // @smiui_errors=0
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_errors) then begin
     n:=Val(ExtractWord(1,arg));
     if n=0
     then Success(smiuisrv_prompt+Trim(Data))
     else Problem(smiuisrv_prompt+Trim(Data));
     WorkIsCompleted;
    end else
    //
    // @smiui_report=ERROR: message
    //
    if (cmdid=smiuisrv_tab.cmd_smiui_report) then begin
     if IsSameText(ExtractWord(1,arg),'ERROR:')
     then Problem(smiuisrv_prompt+Trim(Data))
     else Success(smiuisrv_prompt+Trim(Data));
     WorkIsCompleted;
    end else
    complete:=false;
   end;
  end;
  ClearLocals;
  smiuisrv_default_handler:=complete;
 end;
 {
 Clear SmiuiSrv.
 }
 procedure ClearSmiuiSrv;
 begin
  ClearFsmManager;
  smiuisrv_clear_all;
 end;
 {
 Initialize SmiuiSrv.
 }
 procedure InitSmiuiSrv;
 begin
  InitFsmManager;
  smiuisrv_initialize;
  ShouldPollSmiuiSrv:=true;
  ShouldPollSmiuiSrvDefFsm:=true;
 end;
 {
 Finalize SmiuiSrv.
 }
 procedure FreeSmiuiSrv;
 begin
  smiuisrv_finalize;
  FreeFsmManager;
 end;
 {
 Poll SmiuiSrv.
 }
 procedure PollSmiuiSrv;
 begin
  smiuisrv_task_poll;
  smiuisrv_watchdog_poll;
  if ShouldPollSmiuiSrvDefFsm
  then smiuisrv_default_fsm_poll;
  if ShouldPollFsmManager then PollFsmManager;
 end;
