 {
 Standard constants for Strings:
 }
 _NUL          = 0;    // ASCII code Null
 _SOH          = 1;    // ASCII code Start of heading
 _STX          = 2;    // ASCII code Start of Text
 _ETX          = 3;    // ASCII code End of Text
 _EOT          = 4;    // ASCII code End of Transmission
 _ENQ          = 5;    // ASCII code Enquire
 _ACK          = 6;    // ASCII code Acknowledgement
 _BEL          = 7;    // ASCII code Bell
 _BS           = 8;    // ASCII code Backspace
 _HT           = 9;    // ASCII code Horizontal Tabulation
 _LF           = 10;   // ASCII code Line Feed
 _VT           = 11;   // ASCII code Vertical Tab
 _FF           = 12;   // ASCII code Form Feed
 _CR           = 13;   // ASCII code Carriage Return
 _SO           = 14;   // ASCII code Shift Out
 _SI           = 15;   // ASCII code Shift In
 _DLE          = 16;   // ASCII code Data Link Escape
 _DC1          = 17;   // ASCII code Device Control 1
 _DC2          = 18;   // ASCII code Device Control 2
 _DC3          = 19;   // ASCII code Device Control 3
 _DC4          = 20;   // ASCII code Device Control 4
 _NAK          = 21;   // ASCII code Negative Acknowledgment
 _SYN          = 22;   // ASCII code Synchronization
 _ETB          = 23;   // ASCII code End of Text Block
 _CAN          = 24;   // ASCII code Cancel
 _EM           = 25;   // ASCII code End of Medium
 _SUB          = 26;   // ASCII code Substitute
 _ESC          = 27;   // ASCII code Escape
 _FS           = 28;   // ASCII code File Separator
 _GS           = 29;   // ASCII code Group Separator
 _RS           = 30;   // ASCII code Record Separator
 _US           = 31;   // ASCII code Unit Separator
 _SP           = 32;   // ASCII code Space
 _DEL          = 127;  // ASCII code Delete
 _Space        = ' ';  // Char Space
 _NBSP         = ' ';  // U+00A0 NO-BREAK SPACE
 _Exclamation  = '!';  // Char Exclamation Mark
 _DoubleQuote  = '"';  // Char Double Quote or Quotation Mark
 _NumberSign   = '#';  // Char Number Sign
 _DollarSign   = '$';  // Char Dollar Sign
 _PercentSign  = '%';  // Char Percent Sign
 _Ampersand    = '&';  // Char Ampersand
 _SingleQuote  = ''''; // Char Single Quote or Apostrophe
 _LeftParent   = '(';  // Char Left Parenthesis
 _RightParent  = ')';  // Char Right Parenthesis
 _Asterisk     = '*';  // Char Asterisk
 _PlusSign     = '+';  // Char Plus Sign
 _Comma        = ',';  // Char Comma
 _MinusSign    = '-';  // Char Minus Sign or Hypen-Minus
 _Dot          = '.';  // Char Dot or Period or Full Stop
 _Slash        = '/';  // Char Slash or Solidus
 _Colon        = ':';  // Char Colon
 _SemiColon    = ';';  // Char SemiColon
 _LessSign     = '<';  // Char Less-Then Sign
 _EqualsSign   = '=';  // Char Equals Sign
 _GreaterSign  = '>';  // Char Greater-Then Sign
 _Question     = '?';  // Char Question Mark
 _AtSign       = '@';  // Char At Sign
 _LeftBracket  = '[';  // Char Left Square Bracket
 _BackSlash    = '\';  // Char BackSlash or Reverse Solidus
 _RightBracket = ']';  // Char Right Square Bracket
 _Caret        = '^';  // Char Caret or Circumflex Accent
 _Underscore   = '_';  // Char Underscore or Low Line
 _GraveAccent  = '`';  // Char Grave Accent
 _LeftCurly    = '{';  // Char Left Curly Bracket
 _PipeSign     = '|';  // Char Pipe Sign or Vertical Line
 _RightCurly   = '}';  // Char Right Curly Bracket
 _Tilde        = '~';  // Char Tilde
 _CurrencySign = '¤';  // Char Currency Sign
 _TripleDot    = '…';  // Char Horizontal Ellipsis or Triple Dot
 _Dagger       = '†';  // Char Dagger
 _DoubleDagger = '‡';  // Char Double Dagger
 _EuroSign     = '€';  // Char Euro Sign
 _PerMilleSign = '‰';  // Char Per Mille Sign
 _Bullet       = '•';  // Char Bullet
 _Trademark    = '®';  // Char Trademark Sign
 _SectionSign  = '§';  // Char Section Sign
 _Copyright    = '©';  // Char Copyright Sign
 _NotSign      = '¬';  // Char Not Sign
 _DegreeSign   = '°';  // Char Degree Sign
 _PlusMinus    = '±';  // Char Plus-Minus Sign
 _MicroSign    = 'µ';  // Char Micro Sign
 _PilcrowSign  = '¶';  // Char Pilcrow Sign
 _NumeroSign   = '№';  // Char Numero Sign
 {
 ClickWhat codes:
 }
 cw_Nothing    = 0;    // Nothing happened
 cw_MouseDown  = 1;    // Mouse button down
 cw_MouseUp    = 2;    // Mouse button up
 cw_MouseMove  = 3;    // Mouse cursor moved
 cw_KeyDown    = 4;    // Keyboard key down
 cw_KeyUp      = 5;    // Keyboard key up
 cw_NameList   = 'NOTHING,MOUSEDOWN,MOUSEUP,MOUSEMOVE,KEYDOWN,KEYUP,MOUSEWHEEL,MOUSEWHEELDOWN,MOUSEWHEELUP';
 cw_MouseWheel     = 6;    // Mouse wheel move
 cw_MouseWheelDown = 7;    // Mouse wheel down
 cw_MouseWheelUp   = 8;    // Mouse wheel up
 {
 Virtual Key codes:
 }
 VK_LBUTTON    = 1;    // 0x01 Left mouse button
 VK_RBUTTON    = 2;    // 0x02 Right mouse button
 VK_CANCEL     = 3;    // 0x03 Control-break processing
 VK_MBUTTON    = 4;    // 0x04 Middle mouse button (three-button mouse)
 VK_BACK       = 8;    // 0x08 BACKSPACE key
 VK_TAB        = 9;    // 0x09 TAB key
 VK_CLEAR      = 12;   // 0x0C CLEAR key
 VK_RETURN     = 13;   // 0x0D ENTER key
 VK_SHIFT      = 16;   // 0x10 SHIFT key
 VK_CONTROL    = 17;   // 0x11 CTRL key
 VK_MENU       = 18;   // 0x12 ALT key
 VK_PAUSE      = 19;   // 0x13 PAUSE key
 VK_CAPITAL    = 20;   // 0x14 CAPS LOCK key
 VK_ESCAPE     = 27;   // 0x1B ESC key
 VK_SPACE      = 32;   // 0x20 SPACEBAR
 VK_PRIOR      = 33;   // 0x21 PAGE UP key
 VK_NEXT       = 34;   // 0x22 PAGE DOWN key
 VK_END        = 35;   // 0x23 END key
 VK_HOME       = 36;   // 0x24 HOME key
 VK_LEFT       = 37;   // 0x25 LEFT ARROW key
 VK_UP         = 38;   // 0x26 UP ARROW key
 VK_RIGHT      = 39;   // 0x27 RIGHT ARROW key
 VK_DOWN       = 40;   // 0x28 DOWN ARROW key
 VK_SELECT     = 41;   // 0x29 SELECT key
 VK_PRINT      = 42;   // 0x2A PRINT key
 VK_EXECUTE    = 43;   // 0x2B EXECUTE key
 VK_SNAPSHOT   = 44;   // 0x2C PRINT SCREEN key
 VK_INSERT     = 45;   // 0x2D INS key
 VK_DELETE     = 46;   // 0x2E DEL key
 VK_HELP       = 47;   // 0x2F HELP key
 VK_F1         = 112;  // 0x70 F1 key
 VK_F2         = 113;  // 0x71 F2 key
 VK_F3         = 114;  // 0x72 F3 key
 VK_F4         = 115;  // 0x73 F4 key
 VK_F5         = 116;  // 0x74 F5 key
 VK_F6         = 117;  // 0x75 F6 key
 VK_F7         = 118;  // 0x76 F7 key
 VK_F8         = 119;  // 0x77 F8 key
 VK_F9         = 120;  // 0x78 F9 key
 VK_F10        = 121;  // 0x79 F10 key
 VK_F11        = 122;  // 0x7A F11 key
 VK_F12        = 123;  // 0x7B F12 key
 VK_NUMLOCK    = 144;  // 0x90 NUM LOCK key
 VK_SCROLL     = 145;  // 0x91 SCROLL LOCK key
 VK_LSHIFT     = 160;  // 0xA0 Left SHIFT key
 VK_RSHIFT     = 161;  // 0xA1 Right SHIFT key
 VK_LCONTROL   = 162;  // 0xA2 Left CONTROL key
 VK_RCONTROL   = 163;  // 0xA3 Right CONTROL key
 VK_LMENU      = 164;  // 0xA4 Left MENU key
 VK_RMENU      = 165;  // 0xA5 Right MENU key
 //
 // ReadIniSection and ReadIniAlter Modes
 //
 risModeUpper   = 1;   // To upper
 risModeLower   = 2;   // To lower
 risModeTrimL   = 4;   // Trim left
 risModeTrimR   = 8;   // Trim right
 risModeRemComm = 16;  // Remove semicolon comment
 risModeDefault = 29;  // Default mode for readini
 risModeDefCase = 28;  // Default with case sensivity
 risAlterSecRef = 32;  // ReadIniAlter use section reference [alterSection] alterName
 risAlterEnvRef = 64;  // ReadIniAlter use environ reference %alterName%
 risModeAlter   = 96;  // risAlterSecRef+risAlterEnvRef
