 //////////////////////////////////////////
 ////// SQLDB related constants: //////////
 //////////////////////////////////////////
 //
 // TSchemaType
 //
 stNoSchema        = 0;   // No schema
 stTables          = 1;   // User Tables in database
 stSysTables       = 2;   // System tables in database
 stProcedures      = 3;   // Stored procedures in database
 stColumns         = 4;   // Columns in a table
 stProcedureParams = 5;   // Parameters for a stored procedure
 stIndexes         = 6;   // Indexes for a table
 stPackages        = 7;   // Packages (for databases that support them)
 stSchemata        = 8;   // List of schemas in database(s) (for databases that support them)
 stSequences       = 9;   // Sequences (for databases that support them)
 //
 // TStatementType
 //
 stUnknown         = 0;   // The statement type could not be detected.
 stSelect          = 1;   // The statement is a SQL SELECT statement
 stInsert          = 2;   // The statement is a SQL INSERT statement
 stUpdate          = 3;   // The statement is a SQL UPDATE statement
 stDelete          = 4;   // The statement is a SQL DELETE statement
 stDDL             = 5;   // The statement is a SQL DDL (Data Definition Language) statement
 stGetSegment      = 6;   // The statement is a SQL get segment statement
 stPutSegment      = 7;   // The statement is a SQL put segment statement
 stExecProcedure   = 8;   // The statement executes a stored procedure
 stStartTrans      = 9;   // The statement starts a transaction
 stCommit          = 10;  // The statement commits a transaction
 stRollback        = 11;  // The statement rolls back a transaction
 stSelectForUpd    = 12;  // The statement selects data for update
 //
 // TDBEventType
 //
 detCustom         = 0;  // Custom event message
 detPrepare        = 1;  // SQL prepare message
 detExecute        = 2;  // SQLExecute message
 detFetch          = 3;  // Fetch data message
 detCommit         = 4;  // Transaction Commit message
 detRollBack       = 5;  // Transaction rollback message
 detParamValue     = 6;  // Parameter name and value message
 detActualSQL      = 7;  // Actual SQL as sent to engine message
 //
 // TDataSetState for db_state(datarecord)
 //
 dsInactive        = 0;  // The dataset is not active. No data is available.
 dsBrowse          = 1;  // The dataset is active, and the cursor can be used to navigate the data.
 dsEdit            = 2;  // The dataset is in editing mode: the current record can be modified.
 dsInsert          = 3;  // The dataset is in insert mode: the current record is a new record which can be edited.
 dsSetKey          = 4;  // The dataset is calculating the primary key.
 dsCalcFields      = 5;  // The dataset is calculating it's calculated fields.
 dsFilter          = 6;  // The dataset is filtering records.
 dsNewValue        = 7;  // The dataset is showing the new values of a record.
 dsOldValue        = 8;  // The dataset is showing the old values of a record.
 dsCurValue        = 9;  // The dataset is showing the current values of a record.
 dsBlockRead       = 10; // The dataset is open, but no events are transferred to datasources.
 dsInternalCalc    = 11; // The dataset is calculating it's internally calculated fields.
 dsOpening         = 12; // The dataset is currently opening, but is not yet completely open.
 dsRefreshFields   = 13; // The dataset is refreshing field values from server after update.
 //
 // TConnOption
 //
 sqSupportParams            = 0; // The connection type has native support for parameters.
 sqSupportEmptyDatabaseName = 1; // Does the connection allow empty database names ?
 sqEscapeSlash              = 2; // Escapes in string literals are done with backslash characters.
 sqEscapeRepeat             = 3; // Escapes in string literals are done by repeating the character.
 sqImplicitTransaction      = 4; // Does the connection support implicit transaction management
 sqLastInsertID             = 5; // Does the connection support getting the ID for the last insert operation.
 sqSupportReturning         = 6; // The connection type supports INSERT/UPDATE with RETURNING clause
 sqSequences                = 7; // Are sequences supported.
 //
 // TFieldType for db_fieldstypes
 //
 ftUnknown         = 0;  // Unknown data type
 ftString          = 1;  // String data value (ansistring)
 ftSmallint        = 2;  // Small integer value(1 byte, signed)
 ftInteger         = 3;  // Regular integer value (4 bytes, signed)
 ftWord            = 4;  // Word-sized value(2 bytes, unsigned)
 ftBoolean         = 5;  // Boolean value
 ftFloat           = 6;  // Floating point value (double)
 ftCurrency        = 7;  // Currency value (4 decimal points)
 ftBCD             = 8;  // Binary Coded Decimal value (DECIMAL and NUMERIC SQL types)
 ftDate            = 9;  // Date value
 ftTime            = 10; // Time value
 ftDateTime        = 11; // Date/Time (timestamp) value
 ftBytes           = 12; // Array of bytes value, fixed size (unytped)
 ftVarBytes        = 13; // Array of bytes value, variable size (untyped)
 ftAutoInc         = 14; // Auto-increment integer value (4 bytes)
 ftBlob            = 15; // Binary data value (no type, no size)
 ftMemo            = 16; // Binary text data (no size)
 ftGraphic         = 17; // Graphical data value (no size)
 ftFmtMemo         = 18; // Formatted memo data value (no size)
 ftParadoxOle      = 19; // Paradox OLE field data (no size)
 ftDBaseOle        = 20; // Paradox OLE field data
 ftTypedBinary     = 21; // Binary typed data (no size)
 ftCursor          = 22; // Cursor data value (no size)
 ftFixedChar       = 23; // Fixed character array (string)
 ftWideString      = 24; // Widestring (2 bytes per character)
 ftLargeint        = 25; // Large integer value (8-byte)
 ftADT             = 26; // ADT value
 ftArray           = 27; // Array data
 ftReference       = 28; // Reference data
 ftDataSet         = 29; // Dataset data (blob)
 ftOraBlob         = 30; // Oracle BLOB data
 ftOraClob         = 31; // Oracle CLOB data
 ftVariant         = 32; // Variant data value
 ftInterface       = 33; // interface data value
 ftIDispatch       = 34; // Dispatch data value
 ftGuid            = 35; // GUID data value
 ftTimeStamp       = 36; // Timestamp data value
 ftFMTBcd          = 37; // Formatted BCD (Binary Coded Decimal) value.
 ftFixedWideChar   = 38; // Fixed wide character date (2 bytes per character)
 ftWideMemo        = 39; // Widestring memo data
 //
 // TDataPacketFormat for db_save
 //
 dfBinary          = 0; // Data packets are in binary format
 dfXML             = 1; // Data packets are in XML format
 dfXMLUTF8         = 2; // Data packets are in UTF-8-encoded XML format
 dfAny             = 3; // Data packets can be in any supported format (detected by the packet reader)
 dfDefault         = 4; // Use the default XML format. Same as using dfAny.

