 {
 ***********************************************************************
 Daq Pascal application program _Tag2Crv.
 Copy data tag(s) to Analog/DigitalOutput curve(s).
 Copy data curve(s) from Analog/DigitalInput to tag(s).
 Tag names defined by tagAI#n, tagDI#n, tagAO#n, tagDO#n parameters.
 If not, use same tag names as Analog/Digital Input/Output curve names.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Report n    - print report with verbosity level n=0/1.
|********************************************************
[]
 Example:
  [DeviceList]
  &DEMO.TAG2CRV = device software program
  [&DEMO.TAG2CRV]
  Comment        = Tag(s) <==> curve(s) data copier.
  InquiryPeriod  = 1
  DevicePolling  = 100, tpNormal
  ProgramSource  = ~~\Resource\DaqSite\StdLib\DaqPas\_tag2crv.pas
  OpenConsole    = 2
  DebugFlags     = 3
  AnalogFifo     = 1024
  DigitalFifo    = 1024
  DigitalOutputs = 2
  ;1) Copy Demo1,Demo2 tags to curves
  tagDO#0        = Demo1 ; Use specified name of tag
  Link DigitalOutput 0 with curve Demo1 history 100
  ;If name not specified - Use tag with same name as curve
  Link DigitalOutput 1 with curve Demo2 history 100
  ;1) Copy Data1,Data2 curves to tags
  AnalogInputs   = 2
  tagAI#0        = Data1 ; Use specified name of tag
  Link AnalogInput 1 with curve Data1
  ;If name not specified - Use tag with same name as curve
  Link AnalogInput 1 with curve Data2 history 100
  []
 ***********************************************************************
 }
program _tag2crv;                { Tags <==> Curves data copier     }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 mTab = 1024;                    { Maximum number of tags/curves    }
 
type
 TTagRef = record tag,nai,nao,ndi,ndo:Integer; end; {               }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 cmd_Report           : Integer; { Command @Report                  }
 Count                : Integer; { Number of items                  }
 Tab : array[1..mTab] of TTagRef;{ Table of tag references          }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 //
 // Add item to table.
 //
 procedure AddTab(tag,nai,nao,ndi,ndo:Integer);
 begin
  if (Count<mTab) then
  if (TypeTag(tag)>0) then begin
   Count:=Count+1;
   Tab[Count].tag:=tag;
   Tab[Count].nai:=nai;
   Tab[Count].nao:=nao;
   Tab[Count].ndi:=ndi;
   Tab[Count].ndo:=ndo;
  end;
 end;
 //
 // Print report table.
 //
 procedure ReportTab(verb:Integer);
 var i,tip,tag,nai,nao,ndi,ndo:Integer;
 begin
  Success(Str(Count)+' item(s) found.');
  if (verb>0) then begin
   for i:=1 to Count do begin
    tag:=Tab[i].tag; tip:=TypeTag(tag);
    nai:=Tab[i].nai; nao:=Tab[i].nao;
    ndi:=Tab[i].ndi; ndo:=Tab[i].ndo;
    if (tag<>0) and (nai>=0) then begin
     Success(Str(i)+') Tag['+NameTag(tag)+'] <== AI['+Str(nai)+'] Curve['+CrvName(RefAi(nai))+']');
    end;
    if (tag<>0) and (nao>=0) then begin
     Success(Str(i)+') Tag['+NameTag(tag)+'] ==> AO['+Str(nao)+'] Curve['+CrvName(RefAo(nao))+']');
    end;
    if (tag<>0) and (ndi>=0) then begin
     Success(Str(i)+') Tag['+NameTag(tag)+'] <== DI['+Str(ndi)+'] Curve['+CrvName(RefDi(ndi))+']');
    end;
    if (tag<>0) and (ndo>=0) then begin
     Success(Str(i)+') Tag['+NameTag(tag)+'] ==> DO['+Str(ndo)+'] Curve['+CrvName(RefDo(ndo))+']');
    end;
   end;
  end;
 end;
 //
 // Initialize table.
 //
 procedure InitTab;
 var i,tag:Integer;
 begin
  Count:=0;
  for i:=0 to NumAis-1 do if (RefAi(i)<>_nil) then begin
   tag:=FindTag(ReadIni('tagAI#'+Str(i)));
   if (tag=0) then tag:=FindTag(CrvName(RefAi(i)));
   if (tag>0) then AddTab(tag,i,-1,-1,-1);
  end;
  for i:=0 to NumAos-1 do if (RefAo(i)<>_nil) then begin
   tag:=FindTag(ReadIni('tagAO#'+Str(i)));
   if (tag=0) then tag:=FindTag(CrvName(RefAo(i)));
   if (tag>0) then AddTab(tag,-1,i,-1,-1);
  end;
  for i:=0 to NumDis-1 do if (RefDi(i)<>_nil) then begin
   tag:=FindTag(ReadIni('tagDI#'+Str(i)));
   if (tag=0) then tag:=FindTag(CrvName(RefDi(i)));
   if (tag>0) then AddTab(tag,-1,-1,i,-1);
  end;
  for i:=0 to NumDos-1 do if (RefDo(i)<>_nil) then begin
   tag:=FindTag(ReadIni('tagDO#'+Str(i)));
   if (tag=0) then tag:=FindTag(CrvName(RefDo(i)));
   if (tag>0) then AddTab(tag,-1,-1,-1,i);
  end;
  ReportTab(0);
 end;
 //
 // Poll table of items.
 //
 procedure PollTab;
 var i,tip,tag,nai,nao,ndi,ndo:Integer;
 begin
  for i:=1 to Count do begin
   tag:=Tab[i].tag; tip:=TypeTag(tag);
   nai:=Tab[i].nai; nao:=Tab[i].nao;
   ndi:=Tab[i].ndi; ndo:=Tab[i].ndo;
   if (nai>=0) then begin
    if (tip=1) then bNul(iSetTag(tag,Round(GetAi_Yn(nai)))) else
    if (tip=2) then bNul(rSetTag(tag,GetAi_Yn(nai)));
   end else
   if (nao>=0) then begin
    if (tip=1) then UpdateAo(nao,time,iGetTag(tag)) else
    if (tip=2) then UpdateAo(nao,time,rGetTag(tag));
   end else
   if (ndi>=0) then begin
    if (tip=1) then bNul(iSetTag(tag,Round(GetDi_Yn(ndi)))) else
    if (tip=2) then bNul(rSetTag(tag,GetDi_Yn(ndi)));
   end else
   if (ndo>=0) then begin
    if (tip=1) then UpdateDo(ndo,time,iGetTag(tag)) else
    if (tip=2) then UpdateDo(ndo,time,rGetTag(tag));
   end;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  Count:=0;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  cmd_Report:=RegisterStdInCmd('@Report','');
  InitTab;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  PollTab;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @Report 1
   }
   if (cmdid = cmd_Report) then begin
    ReportTab(iValDef(ExtractWord(1,arg),0));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
