 {
 Программный драйвер DAQ PASCAL для одновременного перевода нескольких
 каналов милливольт в физические единицы.
 Конфигурирование (пример для 3-х канального преобразователя):
 [DeviceList]
 Polynoms = device software program
 [Polynoms]
 Comment = Устройство для калибровочных преобразований
 InquiryPeriod = 50
 DigitalInputs = 3
 DigitalOutputs = 0
 AnalogInputs = 3
 AnalogOutputs = 3
 Calibrations = 3
 DebugMode = 0
 Link AnalogInput  0 with curve МиллиВолты#0
 Link AnalogOutput 0 with curve ФизЕдиницы#0 tolerance 1 0.001
 Calibration#0 = ..\calibr\_ch0.cal U(mV) PhysUnit * Line Line 0 10
 Link AnalogInput  1 with curve МиллиВолты#1
 Link AnalogOutput 1 with curve ФизЕдиницы#1 tolerance 1 0.001
 Calibration#1 = ..\calibr\_ch1.cal U(mV) PhysUnit * Line Line 0 10
 Link AnalogInput  2 with curve МиллиВолты#2
 Link AnalogOutput 2 with curve ФизЕдиницы#2 tolerance 1 0.001
 Calibration#2 = ..\calibr\_ch2.cal U(mV) PhysUnit * Line Line 0 10
 Link DigitalInput 0 with curve Ворота bit 0
 Link DigitalInput 1 with curve Ворота bit 1
 Link DigitalInput 2 with curve Ворота bit 2
 ProgramSource = ..\daqpas\_mv2pu
 }
 {
 ***************************************
 Milli Volts to Physical Units converter
 ***************************************
 }
program _mv2pu;
var nch:integer; tm,mv,pu:real; ok:boolean;
begin
 for nch:=0 to numaos-1 do begin {цикл по каналам:}
  if getai_n(nch)>0 then         {если есть точки на кривой милливольт}
  {канал разрешен если нет цифрового входа или на входе есть ненулевой бит}
  if (refdi(nch)=_nil) or (diword(nch,1)<>0) then begin
   tm:=getai_xn(nch);            {время последней точки кривой термоэдс}
   mv:=getai(nch,tm);            {милливольты кривой термоэдс}
   pu:=calibr(nch,mv,0);         {температура в градусах Цельсия}
   ok:=putao(nch,tm,pu);         {запоминаем точку}
  end;
 end;
end.
