 {
 ***********************************************************************
 Daq Pascal application program SpeakSrv.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
|********************************************************
[]
 }
program SpeakSrv;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SendTimeOut = 100;              { timeout on message send          }
 TimerPeriod = 1000;             { poll period of Speak.Timer       }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 TheSpeak    : record            { Speak server data                }
  Server     : String;           { Speak server path                }
  Buff       : String;           { Speak task input buffer          }
  Line       : String;           { Temporary variable               }
  Tid        : Integer;          { Speak task identifier            }
  IPipeSize  : Integer;          { StdInPipeSize                    }
  OPipeSize  : Integer;          { StdOutPipeSize                   }
  spchapi    : String;           { Path of spchapi.exe              }
  lhttsrur   : String;           { Path of lhttsrur.exe             }
  lhttseng   : String;           { Path of lhttseng.exe             }
  BadSAPI    : Boolean;          { Speech Api failure flag          }
  VoiceMap   : Integer;          { Hash list of voices              }
 end;
 cmd_Help            : Integer;  { @Help                            }
 cmd_Exit            : Integer;  { @Exit                            }
 cmd_Stop            : Integer;  { @Stop                            }
 cmd_Errors          : Integer;  { @Errors                          }
 cmd_Memory          : Integer;  { @Memory                          }
 cmd_ProcessPriority : Integer;  { @ProcessPriority                 }
 cmd_ThreadPriority  : Integer;  { @ThreadPriority                  }
 cmd_Speak           : Integer;  { @Speak                           }
 cmd_Wait            : Integer;  { @Wait                            }
 cmd_Pause           : Integer;  { @Pause                           }
 cmd_Speed           : Integer;  { @Speed                           }
 cmd_Pitch           : Integer;  { @Pitch                           }
 cmd_Volume          : Integer;  { @Volume                          }
 cmd_Engine          : Integer;  { @Engine                          }
 cmd_Engines         : Integer;  { @Engines                         }
 cmd_Demo            : Integer;  { @Demo                            }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {
 Check SpeechApi existance.
 Flags = (1: check SpeechApi), (2: check Russian) (4: check English)
 }
 procedure CheckSpeechApi(Flags:Integer);
 var sApi,sDct,sRus,sEng:String;
 begin
  sApi:=''; sDct:=''; sRus:=''; sEng:='';
  if IsWindows then begin
   { Read engine versions }
   sApi:=ParamStr('Registry HKLM SOFTWARE\Microsoft\SpeechAPI InstallDir');
   sDct:=ParamStr('Registry HKLM SOFTWARE\L&H\TTS\V6.0\System UDCT+Version');
   sRus:=ParamStr('Registry HKLM SOFTWARE\L&H\TTS\V6.0\TTS3000\Russian Version');
   sEng:=ParamStr('Registry HKLM SOFTWARE\L&H\TTS\V6.0\TTS3000\British+English Version');
   { Print engine versions }
   if Length(sApi)>0
   then Success('SAPI: '+sApi)
   else Success('SAPI: not found');
   if Length(sDct)>0
   then Success('TTS - UDCT version: '+sDct)
   else Success('TTS - UDCT version: not found');
   if Length(sRus)>0
   then Success('TTS - Russian version: '+sRus)
   else Success('TTS - Russian version: not found');
   if Length(sEng)>0
   then Success('TTS - British English version: '+sEng)
   else Success('TTS - British English version: not found');
   { Install absent engines }
   if (iAnd(Flags,1)<>0) and (Length(sApi)=0) and (Length(TheSpeak.spchapi)>0)
   then rNul(Eval('@system @async @silent @run -idle '+DaqFileRef(TheSpeak.spchapi,'.exe')+' /Q'));
   if (iAnd(Flags,2)<>0) and (Length(sApi)>0) and (Length(sRus)=0) and (Length(TheSpeak.lhttsrur)>0)
   then rNul(Eval('@system @async @silent @run -idle '+DaqFileRef(TheSpeak.lhttsrur,'.exe')+' /Q'));
   if (iAnd(Flags,4)<>0) and (Length(sApi)>0) and (Length(sEng)=0) and (Length(TheSpeak.lhttseng)>0)
   then rNul(Eval('@system @async @silent @run -idle '+DaqFileRef(TheSpeak.lhttseng,'.exe')+' /Q'));
  end;
  sApi:=''; sDct:=''; sRus:=''; sEng:='';
 end;
 {
 Add voice mapping.
 }
 procedure AddVoiceMapping(s:String);
 var p:Integer; n,v:String;
 begin
  n:=''; v:='';
  p:=ExtractNameValuePair(s,n,v,'=',3);
  if (p>0) and (n<>'') and (v<>'') then begin
   if hashlist_setpara(TheSpeak.VoiceMap,n,v)
   then Success('AddVoiceMapping: '+n+' = '+v);
  end;
  n:=''; v:='';
 end;
 {
 Apply voice mapping.
 }
 procedure ApplyVoiceMapping(var s:String);
 begin
  s:=Trim(s);
  if (hashlist_indexof(TheSpeak.VoiceMap,s)>=0) then
  if (hashlist_getpara(TheSpeak.VoiceMap,s)<>'')
  then s:=hashlist_getpara(TheSpeak.VoiceMap,s);
 end;
 {
 Initialize voice mapping.
 }
 procedure InitVoiceMapping(section:String);
 var i,t:Integer;
 begin
  t:=ReadIniSection(text_new,28,'',section);
  for i:=0 to text_numln(t)-1 do AddVoiceMapping(text_getln(t,i));
  FreeAndZero(t);
 end;
 {
 Clear Speak table.
 }
 procedure Speak_Clear;
 begin
  TheSpeak.Tid:=0;
  TheSpeak.Buff:='';
  TheSpeak.Line:='';
  TheSpeak.Server:='';
  TheSpeak.spchapi:='';
  TheSpeak.lhttsrur:='';
  TheSpeak.lhttseng:='';
  TheSpeak.BadSAPI:=False;
  TheSpeak.VoiceMap:=0;
 end;
 {
 Initialize Speak table.
 }
 procedure Speak_Init;
 begin
  {---Clear Speak---}
  Speak_Clear;
  {---Read FIFO size---}
  TheSpeak.IPipeSize:=val(ReadIni('StdInPipe'));
  TheSpeak.OPipeSize:=val(ReadIni('StdOutPipe'));
  if (TheSpeak.IPipeSize<=0) or (TheSpeak.IPipeSize>64*1024) then TheSpeak.IPipeSize:=64;
  if (TheSpeak.OPipeSize<=0) or (TheSpeak.OPipeSize>64*1024) then TheSpeak.OPipeSize:=64;
  TheSpeak.IPipeSize:=TheSpeak.IPipeSize*1024;
  TheSpeak.OPipeSize:=TheSpeak.OPipeSize*1024;
  {---Find Speak server executable---}
  TheSpeak.Server:=DaqFileRef(AdaptExeFileName(ReadIni('SPEAK_SERVER')),'');
  if FileExists(TheSpeak.Server)
  then Success('SPEAK_SERVER='+TheSpeak.Server)
  else Trouble('Could not find SPEAK_SERVER: '+TheSpeak.Server);
  {---Initialize SpeechApi files---}
  if IsWindows then begin
   TheSpeak.spchapi:=Trim(ParamStr('FileSearch spchapi.exe'));
   TheSpeak.lhttsrur:=Trim(ParamStr('FileSearch lhttsrur.exe'));
   TheSpeak.lhttseng:=Trim(ParamStr('FileSearch lhttseng.exe'));
   Success('spchapi  = '+TheSpeak.spchapi);
   Success('lhttsrur = '+TheSpeak.lhttsrur);
   Success('lhttseng = '+TheSpeak.lhttseng);
   CheckSpeechApi(Val(ReadIni('CheckSpeechApi')));
  end;
  TheSpeak.VoiceMap:=hashlist_init(0);
  if IsUnix then InitVoiceMapping('[SpeechApi.Engines.Mapping:Unix]');
  if IsWindows then InitVoiceMapping('[SpeechApi.Engines.Mapping:Windows]');
 end;
 {
 Send message to Speak task.
 Wait for some time if transmitter FIFO is over.
 }
 procedure Speak_Send(msg:string);
 var ms:real;
 begin
  if TheSpeak.Tid<>0 then
  if Length(msg)>0 then begin
   if task_txspace(TheSpeak.Tid)<Length(msg) then begin
    ms:=msecnow;
    while(msecnow-ms<SendTimeOut) and (task_txspace(TheSpeak.Tid)<Length(msg)) do bNul(Sleep(1));
   end;
   if task_send(TheSpeak.Tid,msg+EOL)=0
   then Trouble('Send error!')
   else ViewImp(msg);
  end;
 end;
 {
 Analyse data coming from Speak task stdout.
 }
 procedure Speak_Process(var s:string);
 begin
  if length(s)>0 then ViewExp(s);
  if length(s)>0 then begin
   if (Pos('Fails ITTSCentral.TextData',s)>0)
   or (Pos('Fails ITTSCentral.AudioPause',s)>0)
   or (Pos('Fails ITTSCentral.AudioResume',s)>0)
   then Speak_Send('@exit');
  end;
 end;
 {
 Stop Speak server task if one started.
 }
 procedure Speak_Stop;
 begin
  if TheSpeak.Tid>0 then begin
   if task_wait(TheSpeak.Tid,0) then begin
    Speak_Send('@exit');
    DevSendCmd(devMySelf,'@FinallyScript');
    if task_wait(TheSpeak.Tid,1000) then bNul(task_kill(TheSpeak.Tid,0,1,1000));
    if task_rxcount(TheSpeak.Tid)>0 then
    while Task_Readln(TheSpeak.Tid,TheSpeak.Line,TheSpeak.Buff) do Speak_Process(TheSpeak.Line);
    Success('Speak Server exit code = '+str(task_result(TheSpeak.Tid)));
   end;
   bNul(task_free(TheSpeak.Tid));
  end;
  TheSpeak.Tid:=0;
  TheSpeak.Buff:='';
  TheSpeak.Line:='';
 end;
 {
 Finalize Speak table.
 }
 procedure Speak_Free;
 begin
  FreeAndZero(TheSpeak.VoiceMap);
  Speak_Stop;
  Speak_Clear;
 end;
 {
 Start Speak server if one not started.
 }
 procedure Speak_Start;
 var i,p,txt:Integer; b:Boolean; s,sn,sv:String;
 begin
  s:=''; sn:=''; sv:='';
  if TheSpeak.Tid=0 then begin
   {
   Initialize separate user task, run it invisible...
   }
   TheSpeak.Tid:=task_init(TheSpeak.Server);
   if pos('?',task_ctrl(TheSpeak.Tid,'HomeDir='+ExtractFilePath(TheSpeak.Server))
             +task_ctrl(TheSpeak.Tid,'StdInPipeSize='+str(TheSpeak.IPipeSize))
             +task_ctrl(TheSpeak.Tid,'StdOutPipeSize='+str(TheSpeak.OPipeSize))
             +task_ctrl(TheSpeak.Tid,'Display=0')
          )>0
   then begin
    Trouble('User task setup error!');
    Speak_Stop;
   end;
   {
   Set CodePage for non-Unicode system.
   }
   if IsWindows and (TheSpeak.Tid<>0)
   then sNul(task_ctrl(TheSpeak.Tid,'CodePage='+ParamStr('OemCodePage')));
   {
   Run task if one was created...
   }
   if TheSpeak.Tid>0 then
   if task_run(TheSpeak.Tid) then begin
    Success('TaskId  = '+str(TheSpeak.Tid));
    Success('TaskPid = '+str(task_pid(TheSpeak.Tid)));
    Success('TaskRef = '+str(task_ref(TheSpeak.Tid)));
    Success('CmdLine = '+task_ctrl(TheSpeak.Tid,'CmdLine'));
    Success('HomeDir = '+task_ctrl(TheSpeak.Tid,'HomeDir'));
    Success('PipeIn  = '+task_ctrl(TheSpeak.Tid,'StdInPipeSize'));
    Success('PipeOut = '+task_ctrl(TheSpeak.Tid,'StdOutPipeSize'));
    Success('IPrior. = '+task_ctrl(TheSpeak.Tid,'StdInPriority'));
    Success('OPrior. = '+task_ctrl(TheSpeak.Tid,'StdOutPriority'));
    Success('TPrior. = '+task_ctrl(TheSpeak.Tid,'ThreadPriority'));
    Success('PPrior. = '+task_ctrl(TheSpeak.Tid,'ProcessPriority'));
    Success('Display = '+task_ctrl(TheSpeak.Tid,'Display'));
   end else begin
    Trouble('Could not start Speak Server!');
    Speak_Stop;
   end;
   {
   Is it Ok with user task? Send preset parameters.
   }
   if TheSpeak.Tid>0 then
   if task_wait(TheSpeak.Tid,0) then begin
    s:='';
    txt:=ReadIniSection(text_new,28,'','');
    for i:=0 to text_numln(txt)-1 do begin
     p:=ExtractNameValuePair(text_getln(txt,i),sn,sv,'=',3);
     if (p>0) and (s='') and IsSameText('Engine',sn) then s:=sv;
    end;
    bNul(text_free(txt));
    if Length(s)=0 then s:='0';
    Speak_Send('@engine='+s);
    DevSendCmd(devMySelf,'@StartupScript');
   end else Trouble('Could not config Speak Server!');
  end;
  s:=''; sn:=''; sv:='';
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  Speak_Clear;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,MaxInt,0);
  Speak_Init;
  cmd_Help            := RegisterStdInCmd('@Help',            '');
  cmd_Exit            := RegisterStdInCmd('@Exit',            '@Exit [n]      - exit (restart) speaksrv with code n.');
  cmd_Stop            := RegisterStdInCmd('@Stop',            '@Stop          - stop (cancel) speaking queue.');
  cmd_Errors          := RegisterStdInCmd('@Errors',          '@Errors [n]    - get/set speaksrv errors counter.');
  cmd_Memory          := RegisterStdInCmd('@Memory',          '@Memory        - return speaksrv memory usage.');
  cmd_ProcessPriority := RegisterStdInCmd('@ProcessPriority', '@ProcessPriority [p] - get/set speaksrv process priority.');
  cmd_ThreadPriority  := RegisterStdInCmd('@ThreadPriority',  '@ThreadPriority [p]  - get/set speaksrv thread priority');
  cmd_Speak           := RegisterStdInCmd('@Speak',           '@Speak s       - speak phrase "s" with speech server.');
  cmd_Wait            := RegisterStdInCmd('@Wait',            '@Wait [w]      - get/set flag to wait until speaking complete.');
  cmd_Pause           := RegisterStdInCmd('@Pause',           '@Pause [p]     - get/set state of Pause speaking.');
  cmd_Speed           := RegisterStdInCmd('@Speed',           '@Speed [s]     - get/set speed (-100,100) percent, default 0.');
  cmd_Pitch           := RegisterStdInCmd('@Pitch',           '@Pitch [p]     - get/set pitch (-100,100) percent, default 0.');
  cmd_Volume          := RegisterStdInCmd('@Volume',          '@Volume [v]    - get/set volume (-100,100) percent, default 100.');
  cmd_Engine          := RegisterStdInCmd('@Engine',          '@Engine [n]    - get/set engine by name [n] or number.');
  cmd_Engines         := RegisterStdInCmd('@Engines',         '@Engines       - list engines available.');
  cmd_Demo            := RegisterStdInCmd('@Demo',            '@Demo          - run speech demo.');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  Speak_Free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  {
  If Speak server is not still running,
  try to start Speak server periodically.
  }
  if TheSpeak.Tid=0 then
  if not TheSpeak.BadSAPI then
  if SysTimer_Pulse(TimerPeriod)>0 then Speak_Start;
  {
  Communicate with Speak server if one still running...
  }
  if TheSpeak.Tid>0 then
  if task_wait(TheSpeak.Tid,0) then begin
   {
   If has data coming from Task StdOut, analyse it...
   }
   if task_rxcount(TheSpeak.Tid)>0 then
   while Task_Readln(TheSpeak.Tid,TheSpeak.Line,TheSpeak.Buff) do Speak_Process(TheSpeak.Line);
  end else begin
   if task_result(TheSpeak.Tid)=13 then begin
    Success('Terminated, exit code = '+str(task_result(TheSpeak.Tid)));
    Success('It seems, Speech API and/or Speech Engines is not installed!');
    Success('Please, install Speech API first!');
    bNul(Echo(devname+' : SpeakSrv terminated, exit code = '+str(task_result(TheSpeak.Tid))));
    bNul(Echo(devname+' : Maybe Speech API & Speech Engines is not installed!'));
    bNul(Echo(devname+' : Please, install Speech API first!'));
    TheSpeak.BadSAPI:=True;
   end else begin
    Trouble('SpeakSrv terminated, exit code = '+str(task_result(TheSpeak.Tid)));
   end;
   Speak_Stop;
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @Help
   @Exit
   ......
   @Speak Hello world.
   .....
   @Demo
   See SPEAKSRV.DPR for details.
   }
   if (cmdid=cmd_Help)
   or (cmdid=cmd_Exit)
   or (cmdid=cmd_Stop)
   or (cmdid=cmd_Errors)
   or (cmdid=cmd_Memory)
   or (cmdid=cmd_ProcessPriority)
   or (cmdid=cmd_ThreadPriority)
   or (cmdid=cmd_Speak)
   or (cmdid=cmd_Wait)
   or (cmdid=cmd_Pause)
   or (cmdid=cmd_Speed)
   or (cmdid=cmd_Pitch)
   or (cmdid=cmd_Volume)
   or (cmdid=cmd_Engine)
   or (cmdid=cmd_Engines) then begin
    if (cmdid=cmd_Engine) then ApplyVoiceMapping(arg);
    if IsEmptyStr(arg)
    then Speak_Send(cmd)
    else Speak_Send(cmd+'='+Trim(arg));
    if (cmdid=cmd_Help) then StdIn_DefaultHandler(Data,cmd,arg);
    Data:='';
   end else
   if (cmdid=cmd_Demo) then begin
    DevSendCmd(devMySelf,'@Wait 1'+EOL+'@Speak Привет. Это демонстрационный тест для речевого синтезатора SpeakSrv.');
    DevSendCmd(devMySelf,'@Engine Russian_Male'+EOL+'@Speak Есть мужские голоса.'+EOL+'@Engine Russian_Female');
    DevSendCmd(devMySelf,'@Engine Russian_Female'+EOL+'@Speak Есть женские голоса.'+EOL+'@Engine Russian_Female');
    DevSendCmd(devMySelf,'@Volume -50'+EOL+'@Speak Поддерживается понижение уровня.'+EOL+'@Volume 100');
    DevSendCmd(devMySelf,'@Volume +50'+EOL+'@Speak Поддерживается повышение уровня.'+EOL+'@Volume 100');
    DevSendCmd(devMySelf,'@Speed -50'+EOL+'@Speak Поддерживается понижение скорости.'+EOL+'@Speed 0');
    DevSendCmd(devMySelf,'@Speed +50'+EOL+'@Speak Поддерживается повышение скорости.'+EOL+'@Speed 0');
    DevSendCmd(devMySelf,'@Pitch -50'+EOL+'@Speak Поддерживается понижение тембра.'+EOL+'@Pitch 0');
    DevSendCmd(devMySelf,'@Pitch +50'+EOL+'@Speak Поддерживается повышение тембра.'+EOL+'@Pitch 0');
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}

