@echo off
SetLocal EnableExtensions EnableDelayedExpansion

:Main
chcp 1251
set /a UseProfiler=0
set /a UseSimulation=0
set "NameLib=GuiLib"
set "target=%~n0.crc"
if exist %target% del /f %target%
call :SimpleButton     >> %target%
call :RadioButton      >> %target%
call :CheckBox         >> %target%
call :ProgressBar      >> %target%
call :SimpleBorder     >> %target%
call :SimpleBar        >> %target%
call :SimpleCross      >> %target%
call :Indicator.Circle >> %target%
call :ListButtons      >> %target%
call :ToolbarIcon:     >> %target%
call :Cmd.Home         >> %target%
call :Cmd.Open         >> %target%
call :Cmd.Save         >> %target%
call :Cmd.LoadIni      >> %target%
call :Cmd.SaveIni      >> %target%
call :Cmd.Navigator    >> %target%
call :Cmd.Tools        >> %target%
call :Cmd.Sound        >> %target%
call :Cmd.Smile        >> %target%
call :Cmd.Help         >> %target%
call :Cmd.Close        >> %target%
call :Cmd.Loupe        >> %target%
call :Cmd.Favorite     >> %target%
call :Cmd.Lock         >> %target%
call :Cmd.Key          >> %target%
call :Cmd.Calculator   >> %target%
call :Cmd.Erase        >> %target%
call :Cmd.Setting      >> %target%
call :Cmd.Console      >> %target%
call :Cmd.Flash        >> %target%
call :Cmd.FlashAlt     >> %target%
call :Cmd.Lightning    >> %target%
call :Cmd.LightningAlt >> %target%
call :Cmd.Ok           >> %target%
call :Cmd.Cancel       >> %target%
call :Cmd.Snowflake    >> %target%
call :Cmd.Menu         >> %target%
call :Cmd.Options      >> %target%
call :Cmd.ArrowCircCW  >> %target%
call :Cmd.ArrowCircCCW >> %target%
call :Cmd.ArrowCW      >> %target%
call :Cmd.ArrowCCW     >> %target%
call :Cmd.ArrowUp      >> %target%
call :Cmd.ArrowDown    >> %target%
call :Cmd.ArrowLeft    >> %target%
call :Cmd.ArrowRight   >> %target%
call :Cmd.PowerOn      >> %target%
echo Done.
Sleep 10
goto :EOF

:Profiler
if "%~1" == "" goto :EOF
if not "%UseProfiler%" == "1" goto :EOF
if /i "%~1" == "Start" (
 if "%UseSimulation%" == "1" echo setsimulation^(1^)
 echo _profile_=mksecnow^(^)
) else (
 echo _profile_=mksecnow^(^)-_profile_
 if "%UseSimulation%" == "1" echo setsimulation^(0^)
 echo @echo Profile: %~1 takes %%_profile_ mks
)
goto :EOF

:SimpleButton
echo ;===========================================================
echo ; Draw simple Button.
echo ; Parameters required:
echo ; 1) glButtonBit   - bit number of On/Off state    (0)
echo ; 2) glButtonBevel - bevel thickness               (1)
echo ; 3) glButtonMoveX - LED text move X to show press (1)
echo ; 4) glButtonMoveY - LED text move Y to show press (1)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = Button
echo ;  [Button]
echo ;  Pos = 10, 10
echo ;  LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:14
echo ;  Painter(v) = (glButtonBit=0)+(glButtonBevel=3)+(glButtonMoveX=2)+(glButtonMoveY=2)
echo ;  Painter(v) = [Painter(v).%NameLib%.SimpleButton]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_100_40_4_silver.bmp, Button
echo ;  Hint = Demo Button
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.SimpleButton]
call :Profiler Start
echo var glButtonBit,glButtonBevel,glButtonMoveX,glButtonMoveY
echo (_bt_=isbit(v,glButtonBit))+(_x1_=0)+(_y1_=0)+(_x2_=sensorWidth()-1)+(_y2_=sensorHeight()-1)+(_ct_=clGray*_bt_+clWhite*not(_bt_))+(_cb_=clGray*not(_bt_)+clWhite*_bt_)
echo (_wb_=glButtonBevel*(1+gt(glButtonBevel,2)))+(_wb_=_wb_+eq(_wb_,0))+(_wt_=_wb_+gt(_wb_,1))+setPen(_cb_,psSolid,pmCopy,_wb_)+drawLine(_x2_,_y1_,_x2_,_y2_+1)+drawLine(_x1_,_y2_,_x2_+1,_y2_)
echo setPen(_ct_,psSolid,pmCopy,_wt_)+drawLine(_x1_,_y1_,_x2_+1,_y1_)+drawLine(_x1_,_y1_,_x1_,_y2_+1)+moveLed((_bt_-0.499999999999)*glButtonMoveX,(_bt_-0.499999999999)*glButtonMoveY)
echo (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
call :Profiler SimpleButton
echo []
echo [Circuit.StartupScript]
echo (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo []
echo.
goto :EOF

:RadioButton
echo ;===========================================================
echo ; Draw RadioButton.
echo ; Parameters required:
echo ; 1) glRadioValue - value to choose (0)
echo ; 2) glRadioColor - back color  (white)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = RadioButton
echo ;  [RadioButton]
echo ;  Pos = 10, 10
echo ;  LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:13
echo ;  Painter(v) = (glRadioValue=0)+(glRadioColor=clWhite)
echo ;  Painter(v) = [Painter(v).%NameLib%.RadioButton]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_14_13_4_silver_ptmono.bmp %%A0+RadioButton
echo ;  Hint = Demo RadioButton
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.RadioButton]
call :Profiler Start
echo var glRadioValue,glRadioColor
echo (_bt_=eq(round(v),round(glRadioValue)))+(_x1_=0)+(_y1_=0)+(_x2_=min(sensorWidth(),sensorHeight()))+(_y2_=_x2_)+(_cl_=clBlack*_bt_+glRadioColor*not(_bt_))+(_cf_=clGray*_bt_+glRadioColor*not(_bt_))
echo setPen(clGray,psSolid,pmCopy,1)+setBrush(glRadioColor,bsSolid)+drawEllipse(_x1_,_y1_,_x2_,_y2_)+setPen(clGray,psSolid,pmMask,2)+setBrush(glRadioColor,bsClear)+drawEllipse(_x1_,_y1_,_x2_,_y2_)
echo setPen(clBlack,psSolid,pmCopy,1)+setBrush(glRadioColor,bsClear)+drawEllipse(_x1_,_y1_,_x2_,_y2_)+setPen(_cf_,psSolid,pmMask,2)+setBrush(_cl_,bsSolid)+drawEllipse(_x1_+_x2_/4+0.5,_y1_+_y2_/4+0.5,_x2_-_x2_/4-0.5,_y2_-_y2_/4-0.5)
echo setPen(_cl_,psSolid,pmCopy,1)+drawEllipse(_x1_+_x2_/4+0.5,_y1_+_y2_/4+0.5,_x2_-_x2_/4-0.5,_y2_-_y2_/4-0.5)
echo (glRadioValue=0)+(glRadioColor=clWhite)
call :Profiler RadioButton
echo []
echo [Circuit.StartupScript]
echo (glRadioValue=0)+(glRadioColor=clWhite)
echo []
echo.
goto :EOF

:CheckBox
echo ;===========================================================
echo ; Draw CheckBox.
echo ; Parameters required:
echo ; 1) glCheckBoxBit   - bit number (0)
echo ; 2) glCheckBoxColor - back color (white)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = CheckBox
echo ;  [CheckBox]
echo ;  Pos = 10, 10
echo ;  LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:12
echo ;  Painter(v) = (glCheckBoxBit=0)+(glCheckBoxColor=clWhite)
echo ;  Painter(v) = [Painter(v).%NameLib%.CheckBox]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_11_12_4_silver_ptmono.bmp %%A0+CheckBox
echo ;  Hint = Demo CheckBox
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.CheckBox]
call :Profiler Start
echo var glCheckBoxBit,glCheckBoxColor
echo (_bt_=isbit(v,glCheckBoxBit))+(_x1_=0)+(_y1_=_x1_)+(_x2_=min(sensorWidth(),sensorHeight()))+(_y2_=_x2_)
echo setPen(clBlack,psSolid,pmCopy,1)+setBrush(glCheckBoxColor,bsSolid)+drawBar(_x1_,_y1_,_x2_,_y2_)+(_x2_=min(sensorWidth(),sensorHeight()))
echo (_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x7_=int(_x2_/7))+(_x15_=int(_x2_/15))+setPen(clBlack,psSolid,pmCopy,1)+setBrush(clBlack,bsSolid)
echo drawPoly(_xc_-2*_x7_-_x15_,_yc_-_x7_,plAddPoint)+drawPoly(_xc_-2*_x7_-_x15_,_yc_,plAddPoint)+drawPoly(_xc_-_x15_,_yc_+2*_x7_,plAddPoint)+drawPoly(_xc_+3*_x7_-_x15_,_yc_-_x7_,plAddPoint)
echo drawPoly(_xc_+3*_x7_-_x15_,_yc_-2*_x7_,plAddPoint)+drawPoly(_xc_-_x15_,_yc_+_x7_,plAddPoint)+drawPoly(_xc_-2*_x7_-_x15_,_yc_-_x7_,plAddPoint)+drawPoly(0,0,_bt_*plPolygon)+drawPoly(0,0,plClear)
echo (glCheckBoxBit=0)+(glCheckBoxColor=clWhite)
call :Profiler CheckBox
echo []
echo [Circuit.StartupScript]
echo (glCheckBoxBit=0)+(glCheckBoxColor=clWhite)
echo []
echo.
goto :EOF

:ProgressBar
echo ;===========================================================
echo ; Draw Progress Bar.
echo ; Parameters required:
echo ; 1) glProgBarMin   - minimum value                          (0)
echo ; 2) glProgBarMax   - maximum value                          (100)
echo ; 3) glProgBarHor   - orientation: 1/0 = horizontal/vertical (1)
echo ; 4) glProgBarColor - fill  color                            (lime)
echo ; 5) glProgBarBevel - bevel thickness                        (0)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = ProgressBar
echo ;  [ProgressBar]
echo ;  Pos = 10, 10
echo ;  LED = 20, 3, 0, %%20.3f, Name:PT_Mono\Style:[Bold]\
echo ;  Painter(v) = (glProgBarMin=0)+(glProgBarMax=100)+(glProgBarHor=1)+(glProgBarColor=clLime)+(glProgBarBevel=0)
echo ;  Painter(v) = [Painter(v).%NameLib%.ProgressBar]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_21_10_4_silver_ptmono.bmp
echo ;  Hint = Demo ProgressBar
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.ProgressBar]
call :Profiler Start
echo var glProgBarMin,glProgBarMax,glProgBarHor,glProgBarColor,glProgBarBevel
echo (_hgt_=sensorHeight())+(_cVal_=v-glProgBarMin)+(_min_=glProgBarMin)+(_max_=glProgBarMax)+(_bv_=abs(glProgBarBevel))+(_x1_=_bv_)
echo (_by1_=eq(glProgBarHor,0)*(_hgt_+1))+(_y1_=eq(glProgBarHor,1)*(_by1_+_bv_)+eq(glProgBarHor,0)*(_by1_-_bv_))
echo (_bx2_=sensorWidth()+1)+(_x2_=eq(glProgBarHor,1)*(_bx2_-2*_bv_)+eq(glProgBarHor,0)*(_bx2_-_bv_))
echo (_by2_=eq(glProgBarHor,1)*(_hgt_+1))+(_y2_=eq(glProgBarHor,1)*(_by2_-_bv_)+eq(glProgBarHor,0)*(_by2_+_bv_))
echo (_xx_=eq(glProgBarHor,1)*(_x1_+_cVal_*_x2_/(_max_-_min_))+(eq(glProgBarHor,0)*(_x2_)))
echo (_yy_=eq(glProgBarHor,0)*(_y1_-_cVal_*(_y1_-_y2_)/(_max_-_min_))+(eq(glProgBarHor,1)*(_y2_)))
echo setPen(clBlack,psClear,pmCopy,1)+setBrush(glProgBarColor,bsSolid)+drawBar(_x1_,_y1_,_xx_,_yy_)
echo (glProgBarMin=0)+(glProgBarMax=100)+(glProgBarHor=1)+(glProgBarColor=clLime)+(glProgBarBevel=0)
call :Profiler ProgressBar
echo []
echo [Circuit.StartupScript]
echo (glProgBarMin=0)+(glProgBarMax=100)+(glProgBarHor=1)+(glProgBarColor=clLime)+(glProgBarBevel=0)
echo []
echo.
goto :EOF

:SimpleBorder
echo ;===========================================================
echo ; Draw simple Border.
echo ; Parameters required:
echo ; 1) glBorderBevel - bevel thickness (1)
echo ; 2) glBorderColor - border color    (gray)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = Border
echo ;  [Border]
echo ;  Pos = 10, 10
echo ;  Painter(v) = (glBorderBevel=2)+(glBorderColor=clLime)
echo ;  Painter(v) = [Painter(v).%NameLib%.SimpleBorder]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_30_4_silver.bmp
echo ;  Hint = Demo Border
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.SimpleBorder]
call :Profiler Start
echo var glBorderBevel,glBorderColor
echo (_x1_=0)+(_y1_=0)+(_x2_=sensorWidth()-1)+(_y2_=sensorHeight()-1)+(_wb_=glBorderBevel*(1+gt(glBorderBevel,2)))+(_wb_=_wb_+eq(_wb_,0))+(_wt_=_wb_+gt(_wb_,1))
echo setPen(glBorderColor,psSolid,pmCopy,_wb_)+drawLine(_x2_,_y1_,_x2_,_y2_+1)+drawLine(_x1_,_y2_,_x2_+1,_y2_)
echo setPen(glBorderColor,psSolid,pmCopy,_wt_)+drawLine(_x1_,_y1_,_x2_+1,_y1_)+drawLine(_x1_,_y1_,_x1_,_y2_+1)
echo (glBorderBevel=1)+(glBorderColor=clGray)
call :Profiler SimpleBorder
echo []
echo [Circuit.StartupScript]
echo (glBorderBevel=1)+(glBorderColor=clGray)
echo []
echo.
goto :EOF

:SimpleBar
echo ;===========================================================
echo ; Draw simple Bar.
echo ; Parameters required:
echo ; 1) glBarColor - bar color (silver)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = Bar
echo ;  [Bar]
echo ;  Pos = 10, 10
echo ;  Painter(v) = (glBarColor=clAqua)
echo ;  Painter(v) = [Painter(v).%NameLib%.SimpleBar]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_30_4_silver.bmp
echo ;  Hint = Demo Bar
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.SimpleBar]
call :Profiler Start
echo var glBarColor
echo setPen(glBarColor,psSolid,pmCopy,1)+setBrush(glBarColor,bsSolid)+drawBar(0,0,sensorWidth(),sensorHeight())
echo (glBarColor=clSilver)
call :Profiler SimpleBar
echo []
echo [Circuit.StartupScript]
echo (glBarColor=clSilver)
echo []
echo.
goto :EOF

:SimpleCross
echo ;===========================================================
echo ; Draw Cross.
echo ; Parameters required:
echo ; 1) glCrossBevel - bevel thickness (2)
echo ; 2) glCrossWidth - cross width     (1)
echo ; 3) glCrossColor - cross color     (black)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = Cross
echo ;  [Cross]
echo ;  Pos = 10, 10
echo ;  Painter(v) = (glCrossBevel=2)+(glCrossWidth=2)+(glCrossColor=clBlack)
echo ;  Painter(v) = [Painter(v).%NameLib%.SimpleCross]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_18_18_4_white.bmp
echo ;  Hint = Demo Cross
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.SimpleCross]
call :Profiler Start
echo var glCrossBevel,glCrossWidth,glCrossColor
echo (_x1_=0)+(_y1_=0)+(_x2_=min(sensorWidth(),sensorHeight()))+(_y2_=_x2_)+(glCrossBevel=abs(glCrossBevel))+(_sh_=ge(glCrossWidth,2))+setPen(glCrossColor,(eq(glCrossWidth,0)*psClear),pmCopy,glCrossWidth)
echo drawLine(_x1_+glCrossBevel,_y1_+glCrossBevel,_x2_-glCrossBevel-_sh_,_y2_-glCrossBevel-_sh_)     ; Draw cross line \
echo drawLine(_x2_-glCrossBevel-1,_y1_+glCrossBevel,_x1_+glCrossBevel-1+_sh_,_y2_-glCrossBevel-_sh_) ; Draw cross line /
echo (glCrossBevel=2)+(glCrossWidth=1)+(glCrossColor=clBlack)
call :Profiler SimpleCross
echo []
echo [Circuit.StartupScript]
echo (glCrossBevel=2)+(glCrossWidth=1)+(glCrossColor=clBlack)
echo []
echo.
goto :EOF

:Indicator.Circle
echo ;===========================================================
echo ; Draw Circle indicator.
echo ; Parameters required:
echo ; 1) glCircleBevel     - circle bevel thickness   (0)
echo ; 2) glCircleWidth     - circle width             (1)
echo ; 3) glCircleFaceColor - face (contour) color     (black)
echo ; 4) glCircleBackColor - back (fill)    color     (silver)
echo ; 5) glCircleAlignment - circle alignment bitmask (1)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = Indicator
echo ;  [Indicator]
echo ;  Pos = 10, 10
echo ;  Painter(v) = (glCircleBevel=2)+(glCircleWidth=2)+(glCircleFaceColor=clBlack)
echo ;  Painter(v) = (glCircleBackColor=eq(v,0)*clLime+eq(v,1)*clRed)
echo ;  Painter(v) = (glCircleBackColor=glCircleBackColor+eq(glCircleBackColor,0)*clSilver)
echo ;  Painter(v) = [Painter(v).%NameLib%.Indicator.Circle]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_32_32_24_silver.bmp
echo ;  Hint = Demo Indicator
echo ;  []
echo ;===========================================================
echo [Painter(v).%NameLib%.Indicator.Circle]
call :Profiler Start
echo var glCircleBevel,glCircleWidth,glCircleFaceColor,glCircleBackColor,glCircleAlignment
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_al_=glCircleAlignment)+(_lw_=glCircleWidth)
echo (_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)+(_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)
echo (_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)+(_Cm_=clGray*eq(glCircleFaceColor,clBlack)+glCircleFaceColor*ne(glCircleFaceColor,clBlack))
echo (_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))+(_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))+(_xc_=_xc_+_ha_)+(_yc_=_yc_+_va_)
echo (_lw_=le(_lw_,1)+ge(_lw_,2)*2-lt(_x2_,22))+(_pw_=ne(_lw_,0)*_lw_+eq(_lw_,0))+(_x3_=int(_x2_/3)-glCircleBevel)+setPen(glCircleBackColor,psSolid,pmCopy,1)+setBrush(glCircleBackColor,bsSolid)+drawEllipse(_xc_-_x3_,_yc_-_x3_,_xc_+_x3_,_yc_+_x3_)
echo setPen(_Cm_,psSolid,pmMask,_pw_+1)+setBrush(clSilver,bsClear)+drawEllipse(_xc_-_x3_,_yc_-_x3_,_xc_+_x3_,_yc_+_x3_)+setPen(glCircleFaceColor,psSolid,pmCopy,_pw_)+drawEllipse(_xc_-_x3_,_yc_-_x3_,_xc_+_x3_,_yc_+_x3_)
echo (glCircleBevel=0)+(glCircleWidth=1)+(glCircleFaceColor=clBlack)+(glCircleBackColor=clSilver)+(glCircleAlignment=1)
call :Profiler IndicatorCircle
echo []
echo [Circuit.StartupScript]
echo (glCircleBevel=0)+(glCircleWidth=1)+(glCircleFaceColor=clBlack)+(glCircleBackColor=clSilver)+(glCircleAlignment=1)
echo []
echo.
goto :EOF

:ListButtons
echo ;===========================================================
echo ; Draw ListBox button as arrow.
echo ; Parameters required:
echo ; 1) glListBtnArrowLeft        - left side button (0)
echo ; 2) glListBtnArrowLineColor   - line color       (black)
echo ; 3) glListBtnArrowLineWidth   - line width       (1)
echo ; 4) glListBtnArrowBorderWidth - border width     (1)
echo ; 5) glListBtnArrowBorderColor - border color     (gray)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = ListBoxButton
echo ;  [ListBoxButton]
echo ;  Pos = 10, 10
echo ;  LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:12
echo ;  Painter(v) = (glListBtnArrowLeft=0)+(glListBtnArrowLineColor=clBlack)+(glListBtnArrowLineWidth=1)+(glListBtnArrowBorderWidth=1)+(glListBtnArrowBorderColor=clGray)
echo ;  Painter(v) = [Painter(v).GuiLib.ListButton.Arrow]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_12_4_white_ptmono.bmp %A0+List+1
echo ;  Hint = Demo ListBox button
echo ;  []
echo ;===========================================================
echo [Painter(v).GuiLib.ListButton.Arrow]
call :Profiler Start
echo var glListBtnArrowLeft,glListBtnArrowLineColor,glListBtnArrowLineWidth,glListBtnArrowBorderWidth,glListBtnArrowBorderColor
echo (_c1_=glListBtnArrowLineColor)+(_c2_=glListBtnArrowBorderColor)+(_lw_=glListBtnArrowLineWidth)+(_bw_=glListBtnArrowBorderWidth)+(_al_=glListBtnArrowLeft)
echo (_x1_=0)+(_y1_=_x1_)+(_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0)*1)+(_y2_=_x2_)+(_sw_=sensorWidth()*eq(_al_,0))+setPen(_c2_,eq(_bw_,0)*psClear+gt(_bw_,0)*psSolid,pmCopy,_bw_)+setBrush(_c2_,bsClear)
echo drawBar(((_sw_-_x2_)*eq(_al_,0))+(_x1_*ne(_al_,0)),_y1_,(_sw_*eq(_al_,0))+(_x2_*ne(_al_,0)),_y2_-eq(frac(min(sensorWidth(),sensorHeight())/2),0)*1)
echo (_sw_=(_sw_-1)*eq(_al_,0))+(_sh_=le(_lw_,1)*1+gt(_lw_,1)*0)+(_xl1_=int(_x1_)+int(_x2_/4))+(_yl1_=int(_y2_/2)+int(_y2_/4))+(_xd2_=int(_x2_/2))+(_yd2_=int(_y2_-1))
echo (_xr2_=int(_x2_-1)-int(_x2_/4)+_sh_)+(_yr2_=int(_y2_/2)+int(_y2_/4)-_sh_)+setPen(_c1_,psSolid,pmCopy,_lw_)
echo drawLine(abs(_sw_-(_xl1_)),(_yl1_-int(_y2_/3)),abs(_sw_-(_xd2_)),(_yd2_-int(_y2_/3))) ; \  - left
echo drawLine(abs(_sw_-(_xd2_)),(_yd2_-int(_y2_/3)),abs(_sw_-(_xr2_)),(_yr2_-int(_y2_/3))) ;  / - right
echo (glListBtnArrowLeft=0)+(glListBtnArrowLineColor=clBlack)+(glListBtnArrowLineWidth=1)+(glListBtnArrowBorderWidth=1)+(glListBtnArrowBorderColor=clGray)
call :Profiler ListButtonArrow
echo []
echo [Circuit.StartupScript]
echo (glListBtnArrowLeft=0)+(glListBtnArrowLineColor=clBlack)+(glListBtnArrowLineWidth=1)+(glListBtnArrowBorderWidth=1)+(glListBtnArrowBorderColor=clGray)
echo []
echo.
echo ;===========================================================
echo ; Draw ListBox button as triangle.
echo ; Parameters required:
echo ; 1) glListBtnTriangleLeft        - left side button (0)
echo ; 2) glListBtnTriangleLineColor   - line color       (black)
echo ; 3) glListBtnTriangleFillColor   - fill color       (gray)
echo ; 4) glListBtnTriangleBorderWidth - border width     (1)
echo ; 5) glListBtnTriangleBorderColor - border color     (gray)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = ListBoxButton
echo ;  [ListBoxButton]
echo ;  Pos = 10, 10
echo ;  LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:12
echo ;  Painter(v) = (glListBtnTriangleLeft=0)+(glListBtnTriangleLineColor=clBlack)+(glListBtnTriangleFillColor=1)+(glListBtnTriangleBorderWidth=1)+(glListBtnTriangleBorderColor=clGray)
echo ;  Painter(v) = [Painter(v).GuiLib.ListButton.Triangle]
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_12_4_white_ptmono.bmp %A0+List+1
echo ;  Hint = Demo ListBox button
echo ;  []
echo ;===========================================================
echo [Painter(v).GuiLib.ListButton.Triangle]
echo var glListBtnTriangleLeft,glListBtnTriangleLineColor,glListBtnTriangleFillColor,glListBtnTriangleBorderWidth,glListBtnTriangleBorderColor
echo (_c1_=glListBtnTriangleLineColor)+(_c2_=glListBtnTriangleBorderColor)+(_c3_=glListBtnTriangleFillColor)+(_bw_=glListBtnTriangleBorderWidth)+(_tl_=glListBtnTriangleLeft)
echo (_x1_=0)+(_y1_=_x1_)+(_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0)*1)+(_y2_=_x2_)+(_sw_=sensorWidth()*eq(_tl_,0))+setPen(_c2_,eq(_bw_,0)*psClear+gt(_bw_,0)*psSolid,pmCopy,_bw_)+setBrush(_c2_,bsClear)
echo drawBar(((_sw_-_x2_)*eq(_tl_,0))+(_x1_*ne(_tl_,0)),_y1_,(_sw_*eq(_tl_,0))+(_x2_*ne(_tl_,0)),_y2_-eq(frac(min(sensorWidth(),sensorHeight())/2),0)*1)
echo (_sw_=(_sw_-1)*eq(_tl_,0))+(_xl1_=int(_x1_)+int(_x2_/4))+(_yl1_=int(_y2_/2)+int(_y2_/4))
echo (_xl2_=int(_x2_/2))+(_yl2_=int(_y2_-1))+(_xr2_=int(_x2_-1)-int(_x2_/4))+(_yr2_=int(_y2_/2)+int(_y2_/4))+setPen(_c1_,psSolid,pmCopy,1)+setBrush(_c3_,bsSolid)
echo drawPoly(abs(_sw_-(_xl1_)),(_yl1_-int(_y2_/3)),plAddPoint)+drawPoly(abs(_sw_-(_xl2_)),(_yl2_-int(_y2_/3)),plAddPoint)
echo drawPoly(abs(_sw_-(_xr2_)),(_yr2_-int(_y2_/3)),plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glListBtnTriangleLeft=0)+(glListBtnTriangleLineColor=clBlack)+(glListBtnTriangleFillColor=clGray)+(glListBtnTriangleBorderWidth=1)+(glListBtnTriangleBorderColor=clGray)
echo []
echo [Circuit.StartupScript]
echo (glListBtnTriangleLeft=0)+(glListBtnTriangleLineColor=clBlack)+(glListBtnTriangleFillColor=clGray)+(glListBtnTriangleBorderWidth=1)+(glListBtnTriangleBorderColor=clGray)
echo []
echo.
goto :EOF

:ToolbarIcon
echo ;===========================================================
echo ; Draw ToolBar icon.
echo ; Parameters required:
echo ; 1) glCmdToolbarColor0 - image color 0
echo ; 2) glCmdToolbarColor1 - image color 1
echo ; 3) glCmdToolbarColor2 - image color 2 (for Smile only)
echo ; Example:
echo ;  [SensorList]
echo ;  Sensor = Home
echo ;  [Home]
echo ;  Pos = 10, 10
echo ;  Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_32_32_4_silver.bmp
echo ;  Painter(v) = (glCmdHomeColor0=clYellow)+(glCmdHomeColor1=clOlive)
echo ;  Painter(v) = [Painter(v).%NameLib%.Cmd.Home]
echo ;  Hint = Demo Home Toolbar Icon
echo ;  []
echo ;===========================================================
goto :EOF

:Cmd.Home
echo [Painter(v).%NameLib%.Cmd.Home]
call :Profiler Start
echo var glCmdHomeColor0,glCmdHomeColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x3_=int(_x2_/3))+(_x4_=int(_x2_/4))+(_x10_=int(_x2_/10))+(_y3_=_x3_)+(_y6_=int(_y2_/6))
echo (_Cl_=isbit(v,glButtonBit)*glCmdHomeColor1+not(isbit(v,glButtonBit))*glCmdHomeColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)
echo drawPoly(_xc_,_yc_-_y3_,plAddPoint)+drawPoly(_xc_-_x3_,_yc_,plAddPoint)+drawPoly(_xc_-_x4_,_yc_,plAddPoint)+drawPoly(_xc_-_x4_,_yc_+_y3_,plAddPoint)
echo drawPoly(_xc_-_x10_,_yc_+_y3_,plAddPoint)+drawPoly(_xc_-_x10_,_yc_+_y6_-1,plAddPoint)+drawPoly(_xc_+_x10_+1,_yc_+_y6_,plAddPoint)+drawPoly(_xc_+_x10_+1,_yc_+_y3_,plAddPoint)
echo drawPoly(_xc_+_x4_+1,_yc_+_y3_,plAddPoint)+drawPoly(_xc_+_x4_+1,_yc_-1,plAddPoint)+drawPoly(_xc_+_x3_,_yc_,plAddPoint)+drawPoly(_xc_,_yc_-_y3_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdHomeColor0=clYellow)+(glCmdHomeColor1=clOlive)
call :Profiler CmdHome
echo []
echo [Circuit.StartupScript]
echo (glCmdHomeColor0=clYellow)+(glCmdHomeColor1=clOlive)
echo []
echo.
goto :EOF

:Cmd.Open
echo [Painter(v).%NameLib%.Cmd.Open]
call :Profiler Start
echo var glCmdOpenColor0,glCmdOpenColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x3_=int(_x2_/3))+(_x5_=int(_x2_/5))+(_x6_=int(_x2_/6))+(_y3_=_x3_)+(_y6_=_x6_)+(_y18_=int(_y2_/18))
echo (_Cl_=isbit(v,glButtonBit)*glCmdOpenColor1+not(isbit(v,glButtonBit))*glCmdOpenColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_-_x3_,_yc_-_y3_,plAddPoint)
echo drawPoly(_xc_-_x3_,_yc_+_y3_,plAddPoint)+drawPoly(_xc_+_x3_,_yc_+_y3_,plAddPoint)+drawPoly(_xc_+_x3_,_yc_-_y6_,plAddPoint)+drawPoly(_xc_+_x6_,_yc_-_y3_,plAddPoint)+drawPoly(_xc_-_x3_-1,_yc_-_y3_,plAddPoint)
echo drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(clSilver,bsSolid)+drawBar(_xc_-_x5_,_yc_-_y3_,_xc_+_x6_,_yc_-int(_y2_/15))
echo setPen(clBlack,psSolid,pmCopy,1)+setBrush(clBlack,bsSolid)+drawBar(_xc_-_x5_,_yc_+_y18_,_xc_+_x6_,_yc_+_y18_+2)+drawBar(_xc_-_x5_,_yc_+_y6_,_xc_+_x6_,_yc_+_y6_+2)
echo (glCmdOpenColor0=clLime)+(glCmdOpenColor1=clGreen)
call :Profiler CmdOpen
echo []
echo [Circuit.StartupScript]
echo (glCmdOpenColor0=clLime)+(glCmdOpenColor1=clGreen)
echo []
echo.
goto :EOF

:Cmd.Save
echo [Painter(v).%NameLib%.Cmd.Save]
call :Profiler Start
echo var glCmdSaveColor0,glCmdSaveColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x3_=int(_x2_/3))+(_x6_=int(_x2_/6))+(_x8_=int(_x2_/8))+(_y3_=_x3_)
echo (_Cl_=isbit(v,glButtonBit)*glCmdSaveColor1+not(isbit(v,glButtonBit))*glCmdSaveColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_-_x3_,_yc_-_y3_,plAddPoint)
echo drawPoly(_xc_-_x3_,_yc_+_y3_,plAddPoint)+drawPoly(_xc_+_x3_,_yc_+_y3_,plAddPoint)+drawPoly(_xc_+_x3_,_yc_-_x6_,plAddPoint)+drawPoly(_xc_+_x6_,_yc_-_y3_,plAddPoint)+drawPoly(_xc_-_x3_-1,_yc_-_y3_,plAddPoint)
echo drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(clSilver,bsSolid)+drawEllipse(_xc_-_x8_,_yc_,_xc_+_x8_+1,_yc_+int(_y2_/4)+1)+drawBar(_xc_-int(_x2_/5),_yc_-_y3_,_xc_+_x6_,_yc_-int(_y2_/15))
echo (glCmdSaveColor0=clGray)+(glCmdSaveColor1=clAqua)
call :Profiler CmdSave
echo []
echo [Circuit.StartupScript]
echo (glCmdSaveColor0=clGray)+(glCmdSaveColor1=clAqua)
echo []
echo.
goto :EOF

:Cmd.LoadIni
echo [Painter(v).%NameLib%.Cmd.LoadIni]
call :Profiler Start
echo var glCmdLoadIniColor0,glCmdLoadIniColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x4_=int(_x2_/4))+(_x8_=int(_x2_/8))+(_y3_=int(_y2_/3))+(_y4_=_x4_)+(_y6_=int(_y2_/6))
echo (_Cl_=isbit(v,glButtonBit)*glCmdLoadIniColor1+not(isbit(v,glButtonBit))*glCmdLoadIniColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_-_x4_,_yc_-_y3_,plAddPoint)+drawPoly(_xc_-_x4_,_yc_+_y3_,plAddPoint)
echo drawPoly(_xc_+_x4_,_yc_+_y3_,plAddPoint)+drawPoly(_xc_+_x4_,_yc_-_y6_,plAddPoint)+drawPoly(_xc_+int(_x2_/12),_yc_-_y3_,plAddPoint)+drawPoly(_xc_-_x4_-1,_yc_-_y3_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo setPen(clBlack,psSolid,pmCopy,2)+setBrush(clSilver,bsSolid)+drawLine(_xc_,_yc_-_x8_-_x8_,_xc_,_yc_)+drawLine(_xc_,_yc_-_x8_-_x8_,_xc_-_x8_,_yc_-_x8_)+drawLine(_xc_-1,_yc_-_x8_-_x8_,_xc_+_x8_-1,_yc_-_x8_) ; Draw Arrow
echo setBrush(_Cl_,bsClear)+(_fh_=-round(1.33*(_x2_/6)))+(setCursor(_xc_-int(_x2_/5),_yc_+int(_y2_/15)))
echo @font height %%_fh_
echo @font color %%clBlack
echo @font style 1
echo @font name PT Sans
echo @print INI
echo (glCmdLoadIniColor0=clWhite)+(glCmdLoadIniColor1=clLime)
call :Profiler CmdLoadIni
echo []
echo [Circuit.StartupScript]
echo (glCmdLoadIniColor0=clWhite)+(glCmdLoadIniColor1=clLime)
echo []
echo.
goto :EOF

:Cmd.SaveIni
echo [Painter(v).%NameLib%.Cmd.SaveIni]
call :Profiler Start
echo var glCmdSaveIniColor0,glCmdSaveIniColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x4_=int(_x2_/4))+(_x8_=int(_x2_/8))+(_y3_=int(_y2_/3))+(_y6_=int(_y2_/6))
echo (_Cl_=isbit(v,glButtonBit)*glCmdSaveIniColor1+not(isbit(v,glButtonBit))*glCmdSaveIniColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_-_x4_,_yc_-_y3_,plAddPoint)+drawPoly(_xc_-_x4_,_yc_+_y3_,plAddPoint)
echo drawPoly(_xc_+_x4_,_yc_+_y3_,plAddPoint)+drawPoly(_xc_+_x4_,_yc_-_y6_,plAddPoint)+drawPoly(_xc_+int(_x2_/12),_yc_-_y3_,plAddPoint)+drawPoly(_xc_-_x4_-1,_yc_-_y3_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo setPen(clBlack,psSolid,pmCopy,2)+setBrush(clSilver,bsSolid)+drawLine(_xc_,_yc_-_x8_-_x8_,_xc_,_yc_)+drawLine(_xc_,_yc_,_xc_-_x8_,_yc_-_x8_)+drawLine(_xc_-1,_yc_,_xc_+_x8_-1,_yc_-_x8_) ; Draw Arrow
echo setBrush(_Cl_,bsClear)+(_fh_=-round(1.33*(_x2_/6)))+(setCursor(_xc_-int(_x2_/5),_yc_+int(_y2_/15)))
echo @font height %%_fh_
echo @font color %%clBlack
echo @font style 1
echo @font name PT Sans
echo @print INI
echo (glCmdSaveIniColor0=clWhite)+(glCmdSaveIniColor1=clAqua)
call :Profiler CmdSaveIni
echo []
echo [Circuit.StartupScript]
echo (glCmdSaveIniColor0=clWhite)+(glCmdSaveIniColor1=clAqua)
echo []
echo.
goto :EOF

:Cmd.Navigator
echo [Painter(v).%NameLib%.Cmd.Navigator]
call :Profiler Start
echo var glCmdNavigatorColor0,glCmdNavigatorColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x3_=int(_x2_/3))+(_x4_=int(_x2_/4))+(_y3_=_x3_)+(_y4_=_x4_)
echo (_Cl_=isbit(v,glButtonBit)*glCmdNavigatorColor1+not(isbit(v,glButtonBit))*glCmdNavigatorColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawLine(_xc_-_x3_,_yc_,_xc_+_x3_,_yc_)+drawLine(_xc_,_yc_-_y3_,_xc_,_yc_+_y3_) ; Draw +
echo drawLine(_xc_-_x4_,_yc_-_y4_,_xc_+_x4_,_yc_+_y4_)+drawLine(_xc_-_x4_,_yc_+_y4_,_xc_+_x4_,_yc_-_y4_)+drawEllipse(_xc_-_x4_,_yc_-_y4_,_xc_+_x4_+1,_yc_+_y4_+1) ; Draw X ; Draw O
echo setPen(clBlack,psSolid,pmCopy,2)+setBrush(clSilver,bsSolid)+drawEllipse(_xc_-_x4_+3,_yc_-_y4_+3,_xc_+_x4_-2,_yc_+_y4_-2) ; Draw o
echo (glCmdNavigatorColor0=clYellow)+(glCmdNavigatorColor1=clOlive)
call :Profiler CmdNavigator
echo []
echo [Circuit.StartupScript]
echo (glCmdNavigatorColor0=clYellow)+(glCmdNavigatorColor1=clOlive)
echo []
echo.
goto :EOF

:Cmd.Tools
echo [Painter(v).%NameLib%.Cmd.Tools]
call :Profiler Start
echo var glCmdToolsColor0,glCmdToolsColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x3_=int(_x2_/3))+(_x8_=int(_x2_/8))+(_x14_=int(_x2_/14))+(_y3_=_x3_)+(_y8_=_x8_)
echo (_Cl_=isbit(v,glButtonBit)*glCmdToolsColor1+not(isbit(v,glButtonBit))*glCmdToolsColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawBar(_xc_-_x3_,_yc_-_y3_,_xc_+_x3_+1,_yc_+_y3_+1) ; Draw border
echo setPen(clSilver,psSolid,pmCopy,3)+setBrush(clSilver,bsSolid)+drawBar(_xc_-3,_yc_+_y3_,_xc_+3,_y2_)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(clBlack,bsSolid)+drawBar(_xc_-1,_yc_+_y3_+1,_xc_+2,_yc_) ; Draw brake border
echo setPen(clBlack,psSolid,pmCopy,3)+setBrush(clBlack,bsSolid)+drawEllipse(_xc_-_x8_-1,_yc_-_y8_-1,_xc_+_x8_+1,_yc_+_y8_)+setPen(clBlack,psClear,pmCopy,1)+setBrush(_Cl_,bsSolid)+drawBar(_xc_-_x14_,_yc_-int(_y2_/4),_xc_+int(_x2_/10),_yc_+_x14_) ; Draw wrench
echo (glCmdToolsColor0=clYellow)+(glCmdToolsColor1=clOlive)
call :Profiler CmdTools
echo []
echo [Circuit.StartupScript]
echo (glCmdToolsColor0=clYellow)+(glCmdToolsColor1=clOlive)
echo []
echo.
goto :EOF

:Cmd.Sound
echo [Painter(v).%NameLib%.Cmd.Sound]
call :Profiler Start
echo var glCmdSoundColor0
echo (_y1_=0)+(_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))
echo (_x3_=int(_x2_/3))+(_x4_=int(_x2_/4))+(_x5_=int(_x2_/5))+(_x8_=int(_x2_/8))+(_x20_=int(_x2_/20))+(_y3_=_x3_)+(_y4_=_x4_)+(_y5_=_x5_)+(_y6_=int(_y2_/6))
echo setPen(clBlack,psSolid,pmCopy,2)+setBrush(clSilver,bsSolid)+drawBar(_xc_-_x3_,_yc_-_y3_,_xc_+_x3_+1,_yc_+_y3_+1)+setPen(clBlack,psSolid,pmCopy,1)+setBrush(clBlack,bsSolid) ; Draw border
echo drawPoly(_xc_+_x20_-1,_yc_-_y4_,plAddPoint)+drawPoly(_xc_+_x20_-_x4_-1,_yc_,plAddPoint)+drawPoly(_xc_+_x20_-1,_yc_+_y4_,plAddPoint)+drawBar(_xc_-_x4_,_yc_-_y6_+2,_xc_+_x20_-1,_yc_+_y6_-1) ; Draw speaker
echo drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)+setPen(clBlack,psSolid,pmCopy,2)+drawArc(_xc_-_x5_-1,_yc_-_y5_-1,_xc_+_x5_-1,_yc_+_y5_+1,_x2_-3,_y2_-1,_x2_-3,_y1_+1)+drawArc(_xc_-_x3_,_yc_-_y3_,_xc_+_x4_+1,_yc_+_y3_,_x2_,_y2_,_x2_,_y1_) ; Draw sound wave
echo setPen(clSilver,(isbit(v,glButtonBit)*psClear),pmCopy,3)+drawLine(_xc_-_x4_+2,_yc_-_y4_,_xc_+_x4_,_yc_+_y4_-2)+setPen(glCmdSoundColor0,(isbit(v,glButtonBit)*psClear),pmCopy,3)+drawLine(_xc_-_x4_,_yc_-_y4_,_xc_+_x4_-1,_yc_+_y4_-1) ; Draw cross out line
echo (glCmdSoundColor0=clRed)
call :Profiler CmdSound
echo []
echo [Circuit.StartupScript]
echo (glCmdSoundColor0=clRed)
echo []
echo.
goto :EOF

:Cmd.Smile
echo [Painter(v).%NameLib%.Cmd.Smile]
call :Profiler Start
echo var glCmdSmileColor0,glCmdSmileColor1,glCmdSmileColor2
echo (_x1_=0)+(_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))
echo (_x3_=int(_x2_/3))+(_x4_=int(_x2_/4))+(_x5_=int(_x2_/5))+(_x6_=int(_x2_/6))+(_y3_=_x3_)+(_y5_=_x5_)+(_y8_=int(_y2_/8))+(_y15_=int(_y2_/15))
echo (_happy_=eq(v,0))+(_hurt_=eq(v,2))+(_sad_=eq(v,1))+(_Cl_=_happy_*glCmdSmileColor0+_sad_*glCmdSmileColor1+_hurt_*glCmdSmileColor2) ; Feeling and face color calculate
echo setPen(clBlack,psSolid,pmCopy,3)+setBrush(_Cl_,bsSolid)+drawEllipse(_xc_-_x3_-2,_yc_-_y3_-2,_xc_+_x3_+2,_yc_+_y3_+2) ; Draw facial contours
echo setPen(clBlack,not(_happy_)*psClear,pmCopy,2)+drawArc(_xc_-_x4_,_yc_-_y3_,_xc_+_x4_,_yc_+_x4_,_x1_,_y2_-2,_x2_,_y2_-2) ; Draw happy
echo setPen(clBlack,not(_hurt_)*psClear,pmCopy,2)+drawBar(_xc_-_x6_-1,_yc_+_y5_,_xc_+_x6_+2,_yc_+_y5_+1)+setPen(clBlack,not(_sad_)*psClear,pmCopy,2)+drawArc(_xc_-_x5_,_yc_+_y8_,_xc_+_x5_,_yc_+_y8_+_y5_,_x2_-_x6_,_yc_+_y5_,_x1_+_x6_,_yc_+_y5_) ; Draw hurt ; Draw sad
echo setPen(clBlack,psSolid,pmCopy,1)+setBrush(clBlack,bsSolid)+DrawEllipse(_xc_-_x6_-2,_yc_-_y15_-2,_xc_-_x6_+2,_yc_-_y15_+2)+DrawEllipse(_xc_+_x6_-2,_yc_-_y15_-2,_xc_+_x6_+2,_yc_-_y15_+2) ; Draw oculi
echo (glCmdSmileColor0=clLime)+(glCmdSmileColor1=clRed)+(glCmdSmileColor2=clYellow)
call :Profiler CmdSmile
echo []
echo [Circuit.StartupScript]
echo (glCmdSmileColor0=clLime)+(glCmdSmileColor1=clRed)+(glCmdSmileColor2=clYellow)
echo []
echo.
goto :EOF

:Cmd.Help
echo [Painter(v).%NameLib%.Cmd.Help]
call :Profiler Start
echo var glCmdHelpColor0,glCmdHelpColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x3_=int(_x2_/3))+(_y3_=_x3_)
echo (_Cl_=isbit(v,glButtonBit)*glCmdHelpColor1+not(isbit(v,glButtonBit))*glCmdHelpColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid) ; Draw border
echo drawBar(_xc_-_x3_,_yc_-_y3_,_xc_+_x3_+1,_yc_+_y3_+1)+setBrush(clAqua,bsClear)+(_fh_=-round(1.33*(_xc_-_x2_/25)))+(setCursor(_xc_-_x2_/8,_yc_-_y3_-1))
echo @font height %%_fh_
echo @font color %%clBlack
echo @font style 1
echo @font name PT Sans
echo @print ?
echo (glCmdHelpColor0=clAqua)+(glCmdHelpColor1=clTeal)
call :Profiler CmdHelp
echo []
echo [Circuit.StartupScript]
echo (glCmdHelpColor0=clAqua)+(glCmdHelpColor1=clTeal)
echo []
echo.
goto :EOF

:Cmd.Close
echo [Painter(v).%NameLib%.Cmd.Close]
call :Profiler Start
echo var glCmdCloseColor0,glCmdCloseColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x6_=int(_x2_/6))+(_x20_=int(_x2_/20))+(_y3_=int(_y2_/3))+(_y6_=_x6_)+(_y9_=int(_y2_/9))
echo (_Cl_=isbit(v,glButtonBit)*glCmdCloseColor1+not(isbit(v,glButtonBit))*glCmdCloseColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid) ; Draw border
echo drawBar(_xc_-int(_x2_/3),_yc_-_y3_,_xc_+_x20_,_yc_+_y3_+1)+setPen(clSilver,psSolid,pmCopy,1)+setBrush(clSilver,bsSolid)+drawBar(_xc_+_x20_-2,_yc_-_y9_,_xc_+_x20_+2,_yc_+_y9_) ; Draw brake border
echo setPen(clBlack,psSolid,pmCopy,2)+drawBar(_xc_-_x6_,_yc_,_xc_+_x6_+_x6_,_yc_+1)+drawLine(_xc_+_x6_,_yc_-_y6_,_xc_+_x6_+_x6_,_yc_)+drawLine(_xc_+_x6_,_yc_+_y6_-1,_xc_+_x6_+_x6_,_yc_-1) ; Draw arrow
echo (glCmdCloseColor0=clGray)+(glCmdCloseColor1=clYellow)
call :Profiler CmdClose
echo []
echo [Circuit.StartupScript]
echo (glCmdCloseColor0=clGray)+(glCmdCloseColor1=clYellow)
echo []
echo.
goto :EOF

:Cmd.Loupe
echo [Painter(v).%NameLib%.Cmd.Loupe]
call :Profiler Start
echo var glCmdLoupeColor0,glCmdLoupeColor1
echo (_x1_=0)+(_y1_=_x1_)+(_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x3_=int(_x2_/3))+(_y3_=_x3_)
echo (_Cl_=isbit(v,glButtonBit)*glCmdLoupeColor1+not(isbit(v,glButtonBit))*glCmdLoupeColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawLine(_xc_,_yc_,_xc_+_x3_,_yc_+_y3_)+drawEllipse(_xc_-_x3_+2,_yc_-_y3_+2,_xc_+_x3_-2,_yc_+_y3_-2)
echo (glCmdLoupeColor0=clAqua)+(glCmdLoupeColor1=clLime)
call :Profiler CmdLoupe
echo []
echo [Circuit.StartupScript]
echo (glCmdLoupeColor0=clAqua)+(glCmdLoupeColor1=clLime)
echo []
echo.
goto :EOF

:Cmd.Favorite
echo [Painter(v).%NameLib%.Cmd.Favorite]
call :Profiler Start
echo var glCmdFavoriteColor0,glCmdFavoriteColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x3_=int(_x2_/3))+(_y3_=_x3_)+(_y5_=int(_y2_/5))+(_y12_=int(_y2_/12))+(_r1_=6)+(_r2_=2)+(_fi_=1)+(_rt_=_fi_)+(_st_=pi/5)
echo (_Cl_=isbit(v,glButtonBit)*glCmdFavoriteColor1+not(isbit(v,glButtonBit))*glCmdFavoriteColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(clWhite,bsSolid)+drawBar(_xc_-_x3_,_yc_-_y3_,_xc_+_x3_+1,_yc_+_y3_+1) ; Draw window
echo setBrush(_Cl_,bsSolid)+drawPoly(_xc_-_x3_,_yc_-_y3_,plAddPoint)+drawPoly(_xc_-_x3_,_yc_-_y5_,plAddPoint)+drawPoly(_xc_+_x3_,_yc_-_y5_,plAddPoint)+drawPoly(_xc_+_x3_,_yc_-_y3_,plAddPoint) ; Draw window title
echo drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)+setPen(clRed,psSolid,pmCopy,1)+setBrush(clRed,bsSolid)+drawPoly(0,0,plClear)
echo drawPoly(_xc_+cos(_rt_)*_r1_,_yc_+_y12_+sin(_rt_)*_r1_,plAddPoint)+(_rt_=_rt_+_st_)+drawPoly(_xc_+cos(_rt_)*_r2_,_yc_+_y12_+sin(_rt_)*_r2_,plAddPoint)+(_rt_=_rt_+_st_)
echo drawPoly(_xc_+cos(_rt_)*_r1_,_yc_+_y12_+sin(_rt_)*_r1_,plAddPoint)+(_rt_=_rt_+_st_)+drawPoly(_xc_+cos(_rt_)*_r2_,_yc_+_y12_+sin(_rt_)*_r2_,plAddPoint)+(_rt_=_rt_+_st_)
echo drawPoly(_xc_+cos(_rt_)*_r1_,_yc_+_y12_+sin(_rt_)*_r1_,plAddPoint)+(_rt_=_rt_+_st_)+drawPoly(_xc_+cos(_rt_)*_r2_,_yc_+_y12_+sin(_rt_)*_r2_,plAddPoint)+(_rt_=_rt_+_st_)
echo drawPoly(_xc_+cos(_rt_)*_r1_,_yc_+_y12_+sin(_rt_)*_r1_,plAddPoint)+(_rt_=_rt_+_st_)+drawPoly(_xc_+cos(_rt_)*_r2_,_yc_+_y12_+sin(_rt_)*_r2_,plAddPoint)+(_rt_=_rt_+_st_)
echo drawPoly(_xc_+cos(_rt_)*_r1_,_yc_+_y12_+sin(_rt_)*_r1_,plAddPoint)+(_rt_=_rt_+_st_)+drawPoly(_xc_+cos(_rt_)*_r2_,_yc_+_y12_+sin(_rt_)*_r2_,plAddPoint)+(_rt_=_rt_+_st_)
echo drawPoly(_xc_+cos(_fi_)*_r1_,_yc_+_y12_+sin(_fi_)*_r1_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdFavoriteColor0=clAqua)+(glCmdFavoriteColor1=clTeal)
call :Profiler CmdFavorite
echo []
echo [Circuit.StartupScript]
echo (glCmdFavoriteColor0=clAqua)+(glCmdFavoriteColor1=clTeal)
echo []
echo.
goto :EOF

:Cmd.Lock
echo [Painter(v).%NameLib%.Cmd.Lock]
call :Profiler Start
echo var glCmdLockColor0,glCmdLockColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x4_=int(_x2_/4))+(_x5_=int(_x2_/5))+(_x6_=int(_x2_/6))+(_x8_=int(_x2_/8))+(_x24_=int(_x2_/24))+(_y3_=int(_y2_/3))+(_y4_=_x4_)
echo (_y6_=_x6_)+(_Cl_=isbit(v,glButtonBit)*glCmdLockColor1+not(isbit(v,glButtonBit))*glCmdLockColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsClear)+drawArc(_xc_-_x5_,_yc_-_y4_-1,_xc_+_x5_,_yc_+_y6_+1,_xc_+_x5_,_yc_-_y4_+1,_xc_-_x5_,_yc_-_y4_+1) ; Draw lock arc
echo setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawBar(_xc_-_x4_,_yc_,_xc_+_x4_+1,_yc_+_y3_+1)+drawLine(_xc_+_x8_+1,_yc_,_xc_+_x8_+1,_yc_-_y6_) ; Draw lock case
echo setPen(clBlack,(not(isbit(v,glButtonBit))*psClear),pmCopy,2)+drawLine(_xc_-_x6_,_yc_,_xc_-_x6_,_yc_-_y6_)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(clSilver,bsSolid)+drawBar(_xc_-_x24_,_y2_-_y3_,_xc_+_x24_,_y2_-_y4_) ; Lock/Unlock line ; Draw keyhole
echo (glCmdLockColor0=clYellow)+(glCmdLockColor1=clYellow)
call :Profiler CmdLock
echo []
echo [Circuit.StartupScript]
echo (glCmdLockColor0=clYellow)+(glCmdLockColor1=clYellow)
echo []
echo.
goto :EOF

:Cmd.Key
echo [Painter(v).%NameLib%.Cmd.Key]
call :Profiler Start
echo var glCmdKeyColor0,glCmdKeyColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x3_=int(_x2_/3))+(_x4_=int(_x2_/4))+(_y3_=_x3_)+(_y6_=int(_y2_/6))
echo (_Cl_=isbit(v,glButtonBit)*glCmdKeyColor1+not(isbit(v,glButtonBit))*glCmdKeyColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawBar(_xc_-_x3_,_yc_-_y3_,_xc_+_x3_+1,_yc_+_y3_+1) ; Draw border
echo setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawEllipse(_xc_,_yc_-_y6_,_xc_+_x4_,_yc_+_y6_)+drawLine(_xc_-_x4_,_yc_,_xc_,_yc_)+setBrush(clBlack,bsSolid)+drawBar(_xc_-int(_x2_/5),_yc_,_xc_-int(_x2_/9),_yc_+_y6_) ; Draw key
echo (glCmdKeyColor0=clGray)+(glCmdKeyColor1=clLime)
call :Profiler CmdKey
echo []
echo [Circuit.StartupScript]
echo (glCmdKeyColor0=clGray)+(glCmdKeyColor1=clLime)
echo []
echo.
goto :EOF

:Cmd.Calculator
echo [Painter(v).%NameLib%.Cmd.Calculator]
call :Profiler Start
echo var glCmdCalculatorColor0,glCmdCalculatorColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))
echo (_x3_=int(_x2_/3))+(_x4_=int(_x2_/4))+(_x8_=int(_x2_/8))+(_x15_=int(_x2_/15))+(_y3_=_x3_)+(_y8_=_x8_)+(_y15_=_x15_)+(_xb_=_xc_+_x8_)+(_yb_=_yc_+_y8_)
echo (_Cl_=isbit(v,glButtonBit)*glCmdCalculatorColor1+not(isbit(v,glButtonBit))*glCmdCalculatorColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawBar(_xc_-_x3_,_yc_-_y3_,_xc_+_x3_+1,_yc_+_y3_+1) ; Draw border
echo setPen(clBlack,psSolid,pmCopy,1)+setBrush(clBlack,bsSolid)+drawBar(_xc_-_x4_,_yc_-_x4_,_xc_+_x4_,_yc_-_y8_)+drawBar(_xc_-_x4_,_yc_-_y15_,_xb_-_x4_,_yb_-_y15_)+drawBar(_xc_+_x8_,_yc_-_y15_,_xb_+_x8_,_yb_-_y15_) ; Draw calculator display ; Draw calc buttons
echo drawBar(_xc_-_x15_,_yc_-_y15_,_xb_-_x15_,_yb_-_y15_)+drawBar(_xc_-_x4_,_yc_+_y8_,_xb_-_x4_,_yb_+_y8_)+drawBar(_xc_+_x8_,_yc_+_y8_,_xb_+_x8_,_yb_+_y8_)+drawBar(_xc_-_x15_,_yc_+_y8_,_xb_-_x15_,_yb_+_y8_)
echo (glCmdCalculatorColor0=clAqua)+(glCmdCalculatorColor1=clLime)
call :Profiler CmdCalculator
echo []
echo [Circuit.StartupScript]
echo (glCmdCalculatorColor0=clAqua)+(glCmdCalculatorColor1=clLime)
echo []
echo.
goto :EOF

:Cmd.Erase
echo [Painter(v).%NameLib%.Cmd.Erase]
call :Profiler Start
echo var glCmdEraseColor0,glCmdEraseColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x4_=int(_x2_/4))+(_x5_=int(_x2_/5))+(_y3_=int(_y2_/3))+(_y4_=_x4_)
echo (_Cl_=isbit(v,glButtonBit)*glCmdEraseColor1+not(isbit(v,glButtonBit))*glCmdEraseColor0)+setPen(clBlack,psclear,pmCopy,1)+setBrush(_Cl_,bsSolid)+drawBar(_xc_-_x5_,_yc_-_y4_,_xc_+_x5_,_yc_) ; Draw fill eraser
echo setBrush(clWhite,bsSolid)+drawBar(_xc_-_x5_,_yc_,_xc_+_x5_,_yc_+_y4_)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsClear)+drawRoundBar(_xc_-_x5_,_yc_-_y4_,_xc_+_x5_,_yc_+_y4_,2,1) ; Draw eraser body
echo setPen(clBlack,psSolid,pmCopy,2)+drawLine(_xc_-_x5_,_yc_,_xc_+int(_x2_/6),_yc_)+drawLine(_xc_-_x4_-1,_yc_+_y3_,_xc_+_x4_,_yc_+_y3_) ; Draw separator eraser ; Draw under eraser line
echo (glCmdEraseColor0=clGray)+(glCmdEraseColor1=clLime)
call :Profiler CmdErase
echo []
echo [Circuit.StartupScript]
echo (glCmdEraseColor0=clGray)+(glCmdEraseColor1=clLime)
echo []
echo.
goto :EOF

:Cmd.Setting
echo [Painter(v).%NameLib%.Cmd.Setting]
call :Profiler Start
echo var glCmdSettingColor0,glCmdSettingColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))
echo (_x3_=int(_x2_/3))+(_x4_=int(_x2_/4))+(_x5_=int(_x2_/5))+(_x12_=int(_x2_/12))+(_y3_=_x3_)+(_y4_=_x4_)+(_y6_=int(_y2_/6))+(_y7_=int(_y2_/7))+(_y12_=_x12_)
echo (_Cl_=isbit(v,glButtonBit)*glCmdSettingColor1+not(isbit(v,glButtonBit))*glCmdSettingColor0)+setPen(clBlack,psSolid,pmCopy,1)+setBrush(_Cl_,bsSolid)+drawBar(_xc_-_x3_,_yc_-_y3_,_xc_+_x3_,_yc_+_y3_) ; Draw background
echo setBrush(clBlack,bsSolid)+drawEllipse(_xc_-_x4_+1,_yc_-_y4_+1,_xc_+_x4_-1,_yc_+_y4_-1)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(clBlack,bsSolid)+drawBar(_xc_-int(_x2_/15),_yc_-_y4_,_xc_+_x12_,_yc_+_y4_+1) ; Draw gear disk ; Draw ^|
echo drawPoly(_xc_-_x4_-1,_yc_+_y7_-1,plAddPoint)+drawPoly(_xc_-_x5_-1,_yc_+_y6_+1,plAddPoint)+drawPoly(_xc_+_x4_-0,_yc_-_y7_+1,plAddPoint)+drawPoly(_xc_+_x5_-0,_yc_-_y6_-1,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear) ; L-U ; L-D ; R-D ; R-U
echo drawPoly(_xc_-_x5_-1,_yc_-_y6_-1,plAddPoint)+drawPoly(_xc_-_x4_-1,_yc_-_y7_+1,plAddPoint)+drawPoly(_xc_+_x5_-0,_yc_+_y6_+1,plAddPoint)+drawPoly(_xc_+_x4_-0,_yc_+_y7_-1,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear) ; L-U ; L-D ; R-D ; R-U
echo setPen(_Cl_,psSolid,pmCopy,1)+setBrush(_Cl_,bsSolid)+drawEllipse(_xc_-_x12_,_yc_-_y12_,_xc_+_x12_,_yc_+_y12_)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsClear)+drawBar(_xc_-_x3_,_yc_-_y3_,_xc_+_x3_+1,_yc_+_y3_+1) ; Draw center hole ; Draw border
echo (glCmdSettingColor0=clYellow)+(glCmdSettingColor1=clOlive)
call :Profiler CmdSetting
echo []
echo [Circuit.StartupScript]
echo (glCmdSettingColor0=clYellow)+(glCmdSettingColor1=clOlive)
echo []
echo.
goto :EOF

:Cmd.Console
echo [Painter(v).%NameLib%.Cmd.Console]
call :Profiler Start
echo var glCmdConsoleColor0,glCmdConsoleColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x3_=int(_x2_/3))+(_x8_=int(_x2_/8))+(_y3_=_x3_)+(_y8_=_x8_)
echo (_Cl_=isbit(v,glButtonBit)*glCmdConsoleColor1+not(isbit(v,glButtonBit))*glCmdConsoleColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawBar(_xc_-_x3_,_yc_-_y3_,_xc_+_x3_+1,_yc_+_y3_+1)
echo setPen(clBlack,psSolid,pmCopy,2)+drawLine(_xc_-_x8_,_yc_-2*_y8_,_xc_+_x8_,_yc_)+drawLine(_xc_-_x8_,_yc_+2*_y8_-1,_xc_+_x8_,_yc_-1)
echo (glCmdConsoleColor0=clGray)+(glCmdConsoleColor1=clAqua)
call :Profiler CmdConsole
echo []
echo [Circuit.StartupScript]
echo (glCmdConsoleColor0=clGray)+(glCmdConsoleColor1=clAqua)
echo []
echo.
goto :EOF

:Cmd.Flash
echo ;     a
echo ;    /^|
echo ;   / ^|
echo ;  / f--e
echo ; b--c /
echo ;   ^| /
echo ;   ^|/
echo ;   d
echo [Painter(v).GuiLib.Cmd.Flash]
call :Profiler Start
echo var glCmdFlashColor0,glCmdFlashColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x5_=int(_x2_/5))+(_x12_=int(_x2_/12))+(_x15_=int(_x2_/15))+(_y5_=_x5_)+(_y15_=_x15_)
echo (_Cl_=isbit(v,glButtonBit)*glCmdFlashColor1+not(isbit(v,glButtonBit))*glCmdFlashColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)
echo drawPoly(_xc_+_x5_,_yc_-2*_y5_,plAddPoint)+drawPoly(_xc_-_x5_-_x15_,_yc_+_y15_,plAddPoint)+drawPoly(_xc_-_x12_,_yc_+_y15_,plAddPoint)+drawPoly(_xc_-_x5_+1,_yc_+2*_y5_-1,plAddPoint)
echo drawPoly(_xc_+_x5_+_x15_+1,_yc_-_y15_-1,plAddPoint)+drawPoly(_xc_+_x12_,_yc_-_y15_,plAddPoint)+drawPoly(_xc_+_x5_,_yc_-2*_y5_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdFlashColor0=clWhite)+(glCmdFlashColor1=clAqua)
call :Profiler CmdFlash
echo []
echo [Circuit.StartupScript]
echo (glCmdFlashColor0=clWhite)+(glCmdFlashColor1=clAqua)
echo []
echo.
goto :EOF

:Cmd.FlashAlt
echo [Painter(v).GuiLib.Cmd.FlashAlt]
call :Profiler Start
echo var glCmdFlashColor0,glCmdFlashColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x5_=int(_x2_/5))+(_x12_=int(_x2_/12))+(_x15_=int(_x2_/15))+(_y5_=_x5_)+(_y15_=_x15_)
echo (_Cl_=isbit(v,glButtonBit)*glCmdFlashColor1+not(isbit(v,glButtonBit))*glCmdFlashColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)
echo drawPoly(_xc_+_x12_,_yc_-2*_y5_,plAddPoint)+drawPoly(_xc_-_x5_-_x12_,_yc_+_y15_,plAddPoint)+drawPoly(_xc_-_x12_+1,_yc_+_y15_,plAddPoint)+drawPoly(_xc_-_x12_+1,_yc_+2*_y5_-1,plAddPoint)
echo drawPoly(_xc_+_x5_+_x12_+1,_yc_-_y15_-1,plAddPoint)+drawPoly(_xc_+_x12_,_yc_-_y15_,plAddPoint)+drawPoly(_xc_+_x12_,_yc_-2*_y5_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdFlashColor0=clWhite)+(glCmdFlashColor1=clAqua)
call :Profiler CmdFlashAlt
echo []
echo [Circuit.StartupScript]
echo (glCmdFlashColor0=clWhite)+(glCmdFlashColor1=clAqua)
echo []
echo.
goto :EOF

:Cmd.Lightning
echo ;  a  g
echo ;  ^|--^|
echo ;  ^|  ^|
echo ;  ^| f--e
echo ; b--c /
echo ;   ^| /
echo ;   ^|/
echo ;   d
echo [Painter(v).GuiLib.Cmd.Lightning]
call :Profiler Start
echo var glCmdLightningColor0,glCmdLightningColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x5_=int(_x2_/5))+(_x12_=int(_x2_/12))+(_x15_=int(_x2_/15))+(_y5_=_x5_)+(_y15_=_x15_)
echo (_Cl_=isbit(v,glButtonBit)*glCmdLightningColor1+not(isbit(v,glButtonBit))*glCmdLightningColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_-_x5_+1,_yc_-2*_y5_,plAddPoint)
echo drawPoly(_xc_-_x5_-_x15_,_yc_+_y15_,plAddPoint)+drawPoly(_xc_-_x12_,_yc_+_y15_,plAddPoint)+drawPoly(_xc_-_x5_+1,_yc_+2*_y5_-1,plAddPoint)+drawPoly(_xc_+_x5_+_x15_+1,_yc_-_y15_-1,plAddPoint)
echo drawPoly(_xc_+_x12_,_yc_-_y15_,plAddPoint)+drawPoly(_xc_+_x5_+_x15_+1,_yc_-2*_y5_-1,plAddPoint)+drawPoly(_xc_-_x5_+1,_yc_-2*_y5_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdLightningColor0=clWhite)+(glCmdLightningColor1=clAqua)
call :Profiler CmdLightning
echo []
echo [Circuit.StartupScript]
echo (glCmdLightningColor0=clWhite)+(glCmdLightningColor1=clAqua)
echo []
echo.
goto :EOF

:Cmd.LightningAlt
echo [Painter(v).GuiLib.Cmd.LightningAlt]
call :Profiler Start
echo var glCmdLightningColor0,glCmdLightningColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x5_=int(_x2_/5))+(_x12_=int(_x2_/12))+(_y5_=_x5_)+(_y15_=int(_y2_/15))
echo (_Cl_=isbit(v,glButtonBit)*glCmdLightningColor1+not(isbit(v,glButtonBit))*glCmdLightningColor0)+setPen(clBlack,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_-_x5_,_yc_-2*_y5_,plAddPoint)
echo drawPoly(_xc_-_x5_,_yc_+_y15_,plAddPoint)+drawPoly(_xc_-_x12_+1,_yc_+_y15_,plAddPoint)+drawPoly(_xc_-_x12_+1,_yc_+2*_y5_,plAddPoint)+drawPoly(_xc_+_x5_+_x12_+1,_yc_-_y15_-1,plAddPoint)
echo drawPoly(_xc_+_x12_,_yc_-_y15_,plAddPoint)+drawPoly(_xc_+_x5_+_x12_+1,_yc_-2*_y5_-1,plAddPoint)+drawPoly(_xc_-_x5_-1,_yc_-2*_y5_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdLightningColor0=clWhite)+(glCmdLightningColor1=clAqua)
call :Profiler CmdLightningAlt
echo []
echo [Circuit.StartupScript]
echo (glCmdLightningColor0=clWhite)+(glCmdLightningColor1=clAqua)
echo []
echo.
goto :EOF

:Cmd.Ok
echo ;          e
echo ;   a     /\
echo ; b/\    / /d
echo ;  \ \  / /
echo ;   \ \/ /
echo ;    \f /
echo ;     \/
echo ;     c
echo [Painter(v).GuiLib.Cmd.Ok]
call :Profiler Start
echo var glCmdOkLineWidth,glCmdOkLineColor,glCmdOkFillColor,glCmdOkAlignment
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_al_=glCmdOkAlignment)
echo (_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)+(_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)
echo (_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)
echo (_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))+(_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))
echo (_xc_=_xc_+_ha_)+(_yc_=_yc_+_va_)+(_x10_=int(_x2_/10))+(_x15_=int(_x2_/15))+(_lw_=ge(glCmdOkLineWidth,2)*2+le(glCmdOkLineWidth,1)*1)+setPen(glCmdOkLineColor,psSolid,pmCopy,_lw_)+setBrush(glCmdOkFillColor,bsSolid)
echo drawPoly(_xc_-_x10_-_x10_-_x15_,_yc_-_x10_,plAddPoint)+drawPoly(_xc_-_x10_-_x10_-_x10_-_x15_,_yc_,plAddPoint)+drawPoly(_xc_-_x15_,_yc_+_x10_+_x10_+_x10_,plAddPoint)+drawPoly(_xc_+_x10_+_x10_+_x10_+_x10_-_x15_,_yc_-_x10_,plAddPoint)
echo drawPoly(_xc_+_x10_+_x10_+_x10_-_x15_,_yc_-_x10_-_x10_,plAddPoint)+drawPoly(_xc_-_x15_,_yc_+_x10_,plAddPoint)+drawPoly(_xc_-_x10_-_x10_-_x15_,_yc_-_x10_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdOkLineWidth=1)+(glCmdOkLineColor=clGreen)+(glCmdOkFillColor=clLime)+(glCmdOkAlignment=1)
call :Profiler CmdOk
echo []
echo [Circuit.StartupScript]
echo (glCmdOkLineWidth=1)+(glCmdOkLineColor=clGreen)+(glCmdOkFillColor=clLime)+(glCmdOkAlignment=1)
echo []
echo.
goto :EOF

:Cmd.Cancel
echo ;   a   k
echo ; b/\  /\j
echo ;  \ \/ /
echo ;   \ l/
echo ;  c/f \i
echo ;  / /\ \
echo ; d\/  \/h
echo ;   e   g
echo [Painter(v).GuiLib.Cmd.Cancel]
call :Profiler Start
echo var glCmdCancelLineWidth,glCmdCancelLineColor,glCmdCancelFillColor,glCmdCancelAlignment
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_al_=glCmdCancelAlignment)
echo (_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)+(_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)
echo (_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)
echo (_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))+(_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))
echo (_xc_=_xc_+_ha_)+(_yc_=_yc_+_va_)+(_x10_=int(_x2_/10))+(_x15_=int(_x2_/15))+(_lw_=ge(glCmdCancelLineWidth,2)*2+le(glCmdCancelLineWidth,1)*1)+setPen(glCmdCancelLineColor,psSolid,pmCopy,_lw_)+setBrush(glCmdCancelFillColor,bsSolid)
echo drawPoly(_xc_-2*_x10_,_yc_-3*_x10_,plAddPoint)+drawPoly(_xc_-3*_x10_,_yc_-2*_x10_,plAddPoint)+drawPoly(_xc_-_x10_,_yc_,plAddPoint)+drawPoly(_xc_-3*_x10_,_yc_+2*_x10_,plAddPoint)
echo drawPoly(_xc_-2*_x10_,_yc_+3*_x10_,plAddPoint)+drawPoly(_xc_,_yc_+_x10_,plAddPoint)+drawPoly(_xc_+2*_x10_,_yc_+3*_x10_,plAddPoint)+drawPoly(_xc_+3*_x10_,_yc_+2*_x10_,plAddPoint)+drawPoly(_xc_+_x10_,_yc_,plAddPoint)
echo drawPoly(_xc_+3*_x10_,_yc_-2*_x10_,plAddPoint)+drawPoly(_xc_+2*_x10_,_yc_-3*_x10_,plAddPoint)+drawPoly(_xc_,_yc_-_x10_,plAddPoint)+drawPoly(_xc_-2*_x10_,_yc_-3*_x10_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdCancelLineWidth=1)+(glCmdCancelLineColor=clMaroon)+(glCmdCancelFillColor=clRed)+(glCmdCancelAlignment=1)
call :Profiler CmdCancel
echo []
echo [Circuit.StartupScript]
echo (glCmdCancelLineWidth=1)+(glCmdCancelLineColor=clMaroon)+(glCmdCancelFillColor=clRed)+(glCmdCancelAlignment=1)
echo []
echo.
goto :EOF

:Cmd.Snowflake
echo ; Draw snowflake image
echo ;               s g
echo ;   f  a   ;  r_^| ^|_h
echo ;   \ /    ; q\ \ / /i
echo ; e--o--b  ;   --o--
echo ;   / \    ; p/ / \ \j
echo ;   d  c   ;  n-^| ^|-k
echo ;               m l
echo [Painter(v).GuiLib.Cmd.Snowflake]
call :Profiler Start
echo var glCmdSnowflakeColor0, glCmdSnowflakeColor1
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_x5_=int(_x2_/5))+(_x8_=int(_x2_/8))
echo (_x5cos0_=cos(0)*_x5_)+(_x5sin0_=sin(0)*_x5_)+(_x5cos3_=_x5_*cos(pi/3))+(_x5sin3_=_x5_*sin(pi/3))+(_Cl_=isbit(v,glButtonBit)*glCmdSnowflakeColor1+not(isbit(v,glButtonBit))*glCmdSnowflakeColor0)
echo ; Draw snowflake arms: eb, oc, oa, of, od:
echo setPen(_Cl_,psSolid,pmCopy,2)+setBrush(_Cl_,bsSolid)+drawLine(_xc_-_x5cos0_-1,_yc_-_x5sin0_,_xc_+_x5cos0_,_yc_+_x5sin0_)+drawLine(_xc_,_yc_,_xc_+_x5cos3_,_yc_+_x5sin3_)
echo drawLine(_xc_,_yc_-1,_xc_+_x5cos3_,_yc_-_x5sin3_-1)+drawLine(_xc_-1,_yc_-1,_xc_-_x5cos3_-1,_yc_-_x5sin3_-1)+drawLine(_xc_-1,_yc_,_xc_-_x5cos3_-1,_yc_+_x5sin3_)
echo ; Draw additional arms: ag, ah, bi, bj, ck, cl, dm, dn, ep, eq, fr, fs:
echo drawLine(_xc_+_x5cos3_,_yc_-_x5sin3_-1,_xc_+_x5cos3_,_yc_-_x5sin3_-_x8_-1)+drawLine(_xc_+_x5cos3_,_yc_-_x5sin3_-1,_xc_+_x5cos3_+_x8_,_yc_-_x5sin3_-1)+drawLine(_xc_+_x5cos0_-1,_yc_+_x5sin0_,_xc_+_x5cos0_+_x8_-1,_yc_+_x5sin0_-_x8_)
echo drawLine(_xc_+_x5cos0_,_yc_+_x5sin0_,_xc_+_x5cos0_+_x8_-1,_yc_+_x5sin0_+_x8_-1)+drawLine(_xc_+_x5cos3_,_yc_+_x5sin3_+1,_xc_+_x5cos3_+_x8_,_yc_+_x5sin3_+1)+drawLine(_xc_+_x5cos3_,_yc_+_x5sin3_,_xc_+_x5cos3_,_yc_+_x5sin3_+_x8_)
echo drawLine(_xc_-_x5cos3_-1,_yc_+_x5sin3_,_xc_-_x5cos3_-1,_yc_+_x5sin3_+_x8_)+drawLine(_xc_-_x5cos3_-1,_yc_+_x5sin3_+1,_xc_-_x5cos3_-_x8_-1,_yc_+_x5sin3_+1)+drawLine(_xc_-_x5cos0_-1,_yc_-_x5sin0_,_xc_-_x5cos0_-_x8_,_yc_-_x5sin0_+_x8_-1)
echo drawLine(_xc_-_x5cos0_,_yc_-_x5sin0_,_xc_-_x5cos0_-_x8_,_yc_-_x5sin0_-_x8_)+drawLine(_xc_-_x5cos3_-1,_yc_-_x5sin3_-1,_xc_-_x5cos3_-_x8_-1,_yc_-_x5sin3_-1)+drawLine(_xc_-_x5cos3_-1,_yc_-_x5sin3_-1,_xc_-_x5cos3_-1,_yc_-_x5sin3_-_x8_-1)
echo (glCmdSnowflakeColor0=clBlue)+(glCmdSnowflakeColor1=clAqua)
call :Profiler CmdSnowflake
echo []
echo [Circuit.StartupScript]
echo (glCmdSnowflakeColor0=clBlue)+(glCmdSnowflakeColor1=clAqua)
echo []
echo.
goto :EOF

:Cmd.Menu
echo [Painter(v).GuiLib.Cmd.Menu]
call :Profiler Start
echo var glCmdMenuColor0, glCmdMenuColor1, glCmdMenuAlignment
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_Cl_=isbit(v,glButtonBit)*glCmdMenuColor1+not(isbit(v,glButtonBit))*glCmdMenuColor0)
echo (_al_=glCmdMenuAlignment)+(_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)+(_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)
echo (_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)+(_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))
echo (_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))+(_xc_=_xc_+_ha_)+(_yc_=_yc_+_va_)+(_pw_=2-lt(_x2_,22))+(_kc_=_pw_-1)+(_x4_=int(_x2_/4))+(_x7_=int(_x2_/7))
echo setPen(_Cl_,psSolid,pmCopy,_pw_)+drawLine(_xc_-_x4_,_yc_-_kc_,_xc_+_x4_-1,_yc_)+drawLine(_xc_-_x4_,_yc_-_x7_-_kc_,_xc_+_x4_-1,_yc_-_x7_)+drawLine(_xc_-_x4_,_yc_+_x7_-_kc_,_xc_+_x4_-1,_yc_+_x7_)
echo (glCmdMenuColor0=clBlack)+(glCmdMenuColor1=clGray)+(glCmdMenuAlignment=1)
call :Profiler CmdMenu
echo []
echo [Circuit.StartupScript]
echo (glCmdMenuColor0=clBlack)+(glCmdMenuColor1=clGray)+(glCmdMenuAlignment=1)
echo []
echo.
goto :EOF

:Cmd.Options
echo [Painter(v).GuiLib.Cmd.Options]
call :Profiler Start
echo var glCmdOptionsColor0, glCmdOptionsColor1, glCmdOptionsAlignment
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_Cl_=isbit(v,glButtonBit)*glCmdOptionsColor1+not(isbit(v,glButtonBit))*glCmdOptionsColor0)
echo (_al_=glCmdOptionsAlignment)+(_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)+(_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)
echo (_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)+(_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))
echo (_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))+(_xc_=_xc_+_ha_)+(_x4_=int(_x2_/4))+(_x15_=int(_x2_/15))+(_fh_=-round(1.33*(int(_x2_/2)-_x2_/25)))+setCursor(_xc_-_x4_,_va_-_x15_)+setBrush(clRed,bsClear)
echo @font height %%_fh_
echo @font color %%_Cl_
echo @font style 1
echo @font name PT Sans
echo @print ...
echo (glCmdOptionsColor0=clBlack)+(glCmdOptionsColor1=clGray)+(glCmdOptionsAlignment=1)
call :Profiler CmdOptions
echo []
echo [Circuit.StartupScript]
echo (glCmdOptionsColor0=clBlack)+(glCmdOptionsColor1=clGray)+(glCmdOptionsAlignment=1)
echo []
echo.
goto :EOF

:Cmd.ArrowCircCW
echo [Painter(v).GuiLib.Cmd.ArrowCircCW]
call :Profiler Start
echo var glCmdArrowCircCWColor0, glCmdArrowCircCWColor1, glCmdArrowCircCWAlignment, glCmdArrowCircCWLineWidth
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_Cl_=isbit(v,glButtonBit)*glCmdArrowCircCWColor1+not(isbit(v,glButtonBit))*glCmdArrowCircCWColor0)
echo (_Cm_=clGray*eq(_Cl_,clBlack)+_Cl_*ne(_Cl_,clBlack))+(_al_=glCmdArrowCircCWAlignment)+(_lw_=glCmdArrowCircCWLineWidth)+(_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)
echo (_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)+(_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)
echo (_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))+(_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))+(_xc_=_xc_+_ha_)+(_yc_=_yc_+_va_)
echo (_lw_=le(_lw_,1)+ge(_lw_,2)*2-lt(_x2_,22))+(_pw_=ne(_lw_,0)*_lw_+eq(_lw_,0))+(_kc_=_pw_-1)+(_x4_=int(_x2_/4))+(_x15_=int(_x2_/15))+setPen(_Cm_,psSolid,pmMask,_pw_+1)+drawArc(_xc_-_x4_,_yc_-_x4_,_xc_+_x4_,_yc_+_x4_,_xc_+_x4_,_yc_,_xc_,_yc_+_x4_)
echo setPen(_Cl_,psSolid,pmCopy,_pw_)+drawArc(_xc_-_x4_,_yc_-_x4_,_xc_+_x4_,_yc_+_x4_,_xc_+_x4_,_yc_,_xc_,_yc_+_x4_)+setPen(_Cl_,psSolid,pmCopy,1)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_+_x4_+_x15_,_yc_,plAddPoint)
echo drawPoly(_xc_+_x4_-_x15_-_pw_-_kc_-1,_yc_,plAddPoint)+drawPoly(_xc_+_x4_-_pw_,_yc_+_x15_+_pw_,plAddPoint)+drawPoly(_xc_+_x4_+_x15_,_yc_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdArrowCircCWColor0=clBlack)+(glCmdArrowCircCWColor1=clBlack)+(glCmdArrowCircCWAlignment=1)+(glCmdArrowCircCWLineWidth=2)
call :Profiler CmdArrowCircCW
echo []
echo [Circuit.StartupScript]
echo (glCmdArrowCircCWColor0=clBlack)+(glCmdArrowCircCWColor1=clBlack)+(glCmdArrowCircCWAlignment=1)+(glCmdArrowCircCWLineWidth=2)
echo []
echo.
goto :EOF

:Cmd.ArrowCircCCW
echo [Painter(v).GuiLib.Cmd.ArrowCircCCW]
call :Profiler Start
echo var glCmdArrowCircCCWColor0, glCmdArrowCircCCWColor1, glCmdArrowCircCCWAlignment, glCmdArrowCircCCWLineWidth
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_Cl_=isbit(v,glButtonBit)*glCmdArrowCircCCWColor1+not(isbit(v,glButtonBit))*glCmdArrowCircCCWColor0)
echo (_Cm_=clGray*eq(_Cl_,clBlack)+_Cl_*ne(_Cl_,clBlack))+(_al_=glCmdArrowCircCCWAlignment)+(_lw_=glCmdArrowCircCCWLineWidth)+(_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)
echo (_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)+(_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)
echo (_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))+(_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))+(_xc_=_xc_+_ha_)+(_yc_=_yc_+_va_)
echo (_lw_=le(_lw_,1)+ge(_lw_,2)*2-lt(_x2_,22))+(_pw_=ne(_lw_,0)*_lw_+eq(_lw_,0))+(_kc_=_pw_-1)+(_x4_=int(_x2_/4))+(_x15_=int(_x2_/15))+setPen(_Cm_,psSolid,pmMask,_pw_+1)+drawArc(_xc_-_x4_,_yc_-_x4_,_xc_+_x4_,_yc_+_x4_,_xc_,_yc_+_x4_,_xc_-_x4_,_yc_)
echo setPen(_Cl_,psSolid,pmCopy,_pw_)+drawArc(_xc_-_x4_,_yc_-_x4_,_xc_+_x4_,_yc_+_x4_,_xc_,_yc_+_x4_,_xc_-_x4_,_yc_)+setPen(_Cl_,psSolid,pmCopy,1)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_-_x4_+_x15_+_pw_,_yc_,plAddPoint)
echo drawPoly(_xc_-_x4_-_x15_-_kc_-1,_yc_,plAddPoint)+drawPoly(_xc_-_x4_+_pw_-_kc_-1,_yc_+_x15_+_pw_,plAddPoint)+drawPoly(_xc_-_x4_+_x15_+_pw_,_yc_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdArrowCircCCWColor0=clBlack)+(glCmdArrowCircCCWColor1=clBlack)+(glCmdArrowCircCCWAlignment=1)+(glCmdArrowCircCCWLineWidth=2)
call :Profiler CmdArrowCircCCW
echo []
echo [Circuit.StartupScript]
echo (glCmdArrowCircCCWColor0=clBlack)+(glCmdArrowCircCCWColor1=clBlack)+(glCmdArrowCircCCWAlignment=1)+(glCmdArrowCircCCWLineWidth=2)
echo []
echo.
goto :EOF

:Cmd.ArrowCW
echo [Painter(v).GuiLib.Cmd.ArrowCW]
call :Profiler Start
echo var glCmdArrowCWColor0, glCmdArrowCWColor1, glCmdArrowCWAlignment, glCmdArrowCWLineWidth
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_Cl_=isbit(v,glButtonBit)*glCmdArrowCWColor1+not(isbit(v,glButtonBit))*glCmdArrowCWColor0)
echo (_Cm_=clGray*eq(_Cl_,clBlack)+_Cl_*ne(_Cl_,clBlack))+(_al_=glCmdArrowCWAlignment)+(_lw_=glCmdArrowCWLineWidth)+(_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)
echo (_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)+(_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)
echo (_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))+(_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))+(_xc_=_xc_+_ha_)+(_yc_=_yc_+_va_)
echo (_lw_=le(_lw_,1)+ge(_lw_,2)*2-lt(_x2_,22))+(_pw_=ne(_lw_,0)*_lw_+eq(_lw_,0))+(_kc_=_pw_-1)+(_x4_=int(_x2_/4))+(_x15_=int(_x2_/15))+setPen(_Cm_,psSolid,pmMask,_pw_+1)+drawArc(_xc_-_x4_,_yc_-_x4_,_xc_+_x4_,_yc_+_x4_,_xc_+_x4_,_yc_,_xc_-_x4_,_yc_)
echo setPen(_Cl_,psSolid,pmCopy,_pw_)+drawArc(_xc_-_x4_,_yc_-_x4_,_xc_+_x4_,_yc_+_x4_,_xc_+_x4_,_yc_,_xc_-_x4_,_yc_)+setPen(_Cl_,psSolid,pmCopy,1)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_+_x4_+_x15_,_yc_,plAddPoint)
echo drawPoly(_xc_+_x4_-_x15_-_pw_-_kc_-1,_yc_,plAddPoint)+drawPoly(_xc_+_x4_-_pw_,_yc_+_x15_+_pw_,plAddPoint)+drawPoly(_xc_+_x4_+_x15_,_yc_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdArrowCWColor0=clBlack)+(glCmdArrowCWColor1=clBlack)+(glCmdArrowCWAlignment=1)+(glCmdArrowCWLineWidth=2)
call :Profiler CmdArrowCW
echo []
echo [Circuit.StartupScript]
echo (glCmdArrowCWColor0=clBlack)+(glCmdArrowCWColor1=clBlack)+(glCmdArrowCWAlignment=1)+(glCmdArrowCWLineWidth=2)
echo []
echo.
goto :EOF

:Cmd.ArrowCCW
echo [Painter(v).GuiLib.Cmd.ArrowCCW]
call :Profiler Start
echo var glCmdArrowCCWColor0, glCmdArrowCCWColor1, glCmdArrowCCWAlignment, glCmdArrowCCWLineWidth
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_Cl_=isbit(v,glButtonBit)*glCmdArrowCCWColor1+not(isbit(v,glButtonBit))*glCmdArrowCCWColor0)
echo (_Cm_=clGray*eq(_Cl_,clBlack)+_Cl_*ne(_Cl_,clBlack))+(_al_=glCmdArrowCCWAlignment)+(_lw_=glCmdArrowCCWLineWidth)+(_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)
echo (_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)+(_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)
echo (_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))+(_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))+(_xc_=_xc_+_ha_)+(_yc_=_yc_+_va_)
echo (_lw_=le(_lw_,1)+ge(_lw_,2)*2-lt(_x2_,22))+(_pw_=ne(_lw_,0)*_lw_+eq(_lw_,0))+(_kc_=_pw_-1)+(_x4_=int(_x2_/4))+(_x15_=int(_x2_/15))+setPen(_Cm_,psSolid,pmMask,_pw_+1)+drawArc(_xc_-_x4_,_yc_-_x4_,_xc_+_x4_,_yc_+_x4_,_xc_+_x4_,_yc_,_xc_-_x4_,_yc_)
echo setPen(_Cl_,psSolid,pmCopy,_pw_)+drawArc(_xc_-_x4_,_yc_-_x4_,_xc_+_x4_,_yc_+_x4_,_xc_+_x4_,_yc_,_xc_-_x4_,_yc_)+setPen(_Cl_,psSolid,pmCopy,1)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_-_x4_+_x15_+_pw_,_yc_,plAddPoint)
echo drawPoly(_xc_-_x4_-_x15_-_kc_-1,_yc_,plAddPoint)+drawPoly(_xc_-_x4_+_pw_-_kc_-1,_yc_+_x15_+_pw_,plAddPoint)+drawPoly(_xc_-_x4_+_x15_+_pw_,_yc_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdArrowCCWColor0=clBlack)+(glCmdArrowCCWColor1=clBlack)+(glCmdArrowCCWAlignment=1)+(glCmdArrowCCWLineWidth=2)
call :Profiler CmdArrowCCW
echo []
echo [Circuit.StartupScript]
echo (glCmdArrowCCWColor0=clBlack)+(glCmdArrowCCWColor1=clBlack)+(glCmdArrowCCWAlignment=1)+(glCmdArrowCCWLineWidth=2)
echo []
echo.
goto :EOF

:Cmd.ArrowUp
echo [Painter(v).GuiLib.Cmd.ArrowUp]
call :Profiler Start
echo var glCmdArrowUpColor0, glCmdArrowUpColor1, glCmdArrowUpAlignment, glCmdArrowUpLineWidth
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_Cl_=isbit(v,glButtonBit)*glCmdArrowUpColor1+not(isbit(v,glButtonBit))*glCmdArrowUpColor0)
echo (_Cm_=clGray*eq(_Cl_,clBlack)+_Cl_*ne(_Cl_,clBlack))+(_al_=glCmdArrowUpAlignment)+(_lw_=glCmdArrowUpLineWidth)+(_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)
echo (_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)+(_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)
echo (_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))+(_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))+(_xc_=_xc_+_ha_)+(_yc_=_yc_+_va_)
echo (_lw_=le(_lw_,1)+ge(_lw_,2)*2-lt(_x2_,22))+(_pw_=ne(_lw_,0)*_lw_+eq(_lw_,0))+(_kc_=_pw_-1)+(_x4_=int(_x2_/4))+(_x15_=int(_x2_/15))+setPen(_Cm_,psSolid,pmMask,_pw_+_kc_)+drawLine(_xc_,_yc_-_x4_+_x15_,_xc_,_yc_+_x4_)+setPen(_Cl_,psSolid,pmCopy,_pw_)
echo drawLine(_xc_,_yc_-_x4_+_x15_,_xc_,_yc_+_x4_)+setPen(_Cl_,psSolid,pmCopy,1)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_+_x15_+_pw_,_yc_-_x4_+_x15_,plAddPoint)+drawPoly(_xc_-_x15_-_kc_-1,_yc_-_x4_+_x15_,plAddPoint)+drawPoly(_xc_,_yc_-_x4_-_pw_,plAddPoint)
echo drawPoly(_xc_+_x15_+_pw_,_yc_-_x4_+_x15_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdArrowUpColor0=clBlack)+(glCmdArrowUpColor1=clBlack)+(glCmdArrowUpAlignment=1)+(glCmdArrowUpLineWidth=2)
call :Profiler CmdArrowUp
echo []
echo [Circuit.StartupScript]
echo (glCmdArrowUpColor0=clBlack)+(glCmdArrowUpColor1=clBlack)+(glCmdArrowUpAlignment=1)+(glCmdArrowUpLineWidth=2)
echo []
echo.
goto :EOF

:Cmd.ArrowDown
echo [Painter(v).GuiLib.Cmd.ArrowDown]
call :Profiler Start
echo var glCmdArrowDownColor0, glCmdArrowDownColor1, glCmdArrowDownAlignment, glCmdArrowDownLineWidth
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_Cl_=isbit(v,glButtonBit)*glCmdArrowDownColor1+not(isbit(v,glButtonBit))*glCmdArrowDownColor0)
echo (_Cm_=clGray*eq(_Cl_,clBlack)+_Cl_*ne(_Cl_,clBlack))+(_al_=glCmdArrowDownAlignment)+(_lw_=glCmdArrowDownLineWidth)+(_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)
echo (_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)+(_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)
echo (_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))+(_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))+(_xc_=_xc_+_ha_)+(_yc_=_yc_+_va_)
echo (_lw_=le(_lw_,1)+ge(_lw_,2)*2-lt(_x2_,22))+(_pw_=ne(_lw_,0)*_lw_+eq(_lw_,0))+(_kc_=_pw_-1)+(_x4_=int(_x2_/4))+(_x15_=int(_x2_/15))+setPen(_Cm_,psSolid,pmMask,_pw_+_kc_)+drawLine(_xc_,_yc_-_x4_,_xc_,_yc_+_x4_-_x15_)+setPen(_Cl_,psSolid,pmCopy,_pw_)
echo drawLine(_xc_,_yc_-_x4_,_xc_,_yc_+_x4_-_x15_)+setPen(_Cl_,psSolid,pmCopy,1)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_+_x15_+_pw_,_yc_+_x4_-_x15_,plAddPoint)+drawPoly(_xc_-_x15_-_kc_-1,_yc_+_x4_-_x15_,plAddPoint)+drawPoly(_xc_,_yc_+_x4_+_pw_,plAddPoint)
echo drawPoly(_xc_+_x15_+_pw_,_yc_+_x4_-_x15_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdArrowDownColor0=clBlack)+(glCmdArrowDownColor1=clBlack)+(glCmdArrowDownAlignment=1)+(glCmdArrowDownLineWidth=2)
call :Profiler CmdArrowDown
echo []
echo [Circuit.StartupScript]
echo (glCmdArrowDownColor0=clBlack)+(glCmdArrowDownColor1=clBlack)+(glCmdArrowDownAlignment=1)+(glCmdArrowDownLineWidth=2)
echo []
echo.
goto :EOF

:Cmd.ArrowLeft
echo [Painter(v).GuiLib.Cmd.ArrowLeft]
call :Profiler Start
echo var glCmdArrowLeftColor0, glCmdArrowLeftColor1, glCmdArrowLeftAlignment, glCmdArrowLeftLineWidth
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_Cl_=isbit(v,glButtonBit)*glCmdArrowLeftColor1+not(isbit(v,glButtonBit))*glCmdArrowLeftColor0)
echo (_Cm_=clGray*eq(_Cl_,clBlack)+_Cl_*ne(_Cl_,clBlack))+(_al_=glCmdArrowLeftAlignment)+(_lw_=glCmdArrowLeftLineWidth)+(_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)
echo (_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)+(_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)
echo (_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))+(_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))+(_xc_=_xc_+_ha_)+(_yc_=_yc_+_va_)
echo (_lw_=le(_lw_,1)+ge(_lw_,2)*2-lt(_x2_,22))+(_pw_=ne(_lw_,0)*_lw_+eq(_lw_,0))+(_kc_=_pw_-1)+(_x4_=int(_x2_/4))+(_x15_=int(_x2_/15))+setPen(_Cm_,psSolid,pmMask,_pw_+_kc_)+drawLine(_xc_-_x4_+_x15_,_yc_,_xc_+_x4_,_yc_)+setPen(_Cl_,psSolid,pmCopy,_pw_)
echo drawLine(_xc_-_x4_+_x15_,_yc_,_xc_+_x4_,_yc_)+setPen(_Cl_,psSolid,pmCopy,1)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_-_x4_+_x15_,_yc_-_x15_-_pw_,plAddPoint)+drawPoly(_xc_-_x4_+_x15_,_yc_+_x15_+_pw_,plAddPoint)+drawPoly(_xc_-_x4_-_pw_,_yc_,plAddPoint)
echo drawPoly(_xc_-_x4_+_x15_,_yc_-_x15_-_pw_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdArrowLeftColor0=clBlack)+(glCmdArrowLeftColor1=clBlack)+(glCmdArrowLeftAlignment=1)+(glCmdArrowLeftLineWidth=2)
call :Profiler CmdArrowLeft
echo []
echo [Circuit.StartupScript]
echo (glCmdArrowLeftColor0=clBlack)+(glCmdArrowLeftColor1=clBlack)+(glCmdArrowLeftAlignment=1)+(glCmdArrowLeftLineWidth=2)
echo []
echo.
goto :EOF

:Cmd.ArrowRight
echo [Painter(v).GuiLib.Cmd.ArrowRight]
call :Profiler Start
echo var glCmdArrowRightColor0, glCmdArrowRightColor1, glCmdArrowRightAlignment, glCmdArrowRightLineWidth
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_Cl_=isbit(v,glButtonBit)*glCmdArrowRightColor1+not(isbit(v,glButtonBit))*glCmdArrowRightColor0)
echo (_Cm_=clGray*eq(_Cl_,clBlack)+_Cl_*ne(_Cl_,clBlack))+(_al_=glCmdArrowRightAlignment)+(_lw_=glCmdArrowRightLineWidth)+(_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)
echo (_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)+(_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)
echo (_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))+(_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))+(_xc_=_xc_+_ha_)+(_yc_=_yc_+_va_)
echo (_lw_=le(_lw_,1)+ge(_lw_,2)*2-lt(_x2_,22))+(_pw_=ne(_lw_,0)*_lw_+eq(_lw_,0))+(_kc_=_pw_-1)+(_x4_=int(_x2_/4))+(_x15_=int(_x2_/15))+setPen(_Cm_,psSolid,pmMask,_pw_+_kc_)+drawLine(_xc_-_x4_,_yc_,_xc_+_x4_-_x15_,_yc_)+setPen(_Cl_,psSolid,pmCopy,_pw_)
echo drawLine(_xc_-_x4_,_yc_-_kc_,_xc_+_x4_-_x15_,_yc_)+setPen(_Cl_,psSolid,pmCopy,1)+setBrush(_Cl_,bsSolid)+drawPoly(_xc_+_x4_-_x15_,_yc_-_x15_-_pw_,plAddPoint)+drawPoly(_xc_+_x4_-_x15_,_yc_+_x15_+_pw_,plAddPoint)+drawPoly(_xc_+_x4_+_pw_,_yc_,plAddPoint)
echo drawPoly(_xc_+_x4_-_x15_,_yc_-_x15_-_pw_,plAddPoint)+drawPoly(0,0,plPolygon)+drawPoly(0,0,plClear)
echo (glCmdArrowRightColor0=clBlack)+(glCmdArrowRightColor1=clBlack)+(glCmdArrowRightAlignment=1)+(glCmdArrowRightLineWidth=2)
call :Profiler CmdArrowRight
echo []
echo [Circuit.StartupScript]
echo (glCmdArrowRightColor0=clBlack)+(glCmdArrowRightColor1=clBlack)+(glCmdArrowRightAlignment=1)+(glCmdArrowRightLineWidth=2)
echo []
echo.
goto :EOF

:Cmd.PowerOn
echo [Painter(v).GuiLib.Cmd.PowerOn]
call :Profiler Start
echo var glCmdPowerOnColor0, glCmdPowerOnColor1, glCmdPowerOnAlignment, glCmdPowerOnLineWidth
echo (_x2_=min(sensorWidth(),sensorHeight()))+(_x2_=_x2_+eq(frac(_x2_/2),0))+(_y2_=_x2_)+(_xc_=int(_x2_/2))+(_yc_=int(_y2_/2))+(_Cl_=isbit(v,glButtonBit)*glCmdPowerOnColor1+not(isbit(v,glButtonBit))*glCmdPowerOnColor0)
echo (_Cm_=clGray*eq(_Cl_,clBlack)+_Cl_*ne(_Cl_,clBlack))+(_al_=glCmdPowerOnAlignment)+(_lw_=glCmdPowerOnLineWidth)+(_al_=(isbit(_al_,0)*(bitand(_al_,1)))+not(isbit(_al_,0))*_al_)+(_al_=(isbit(_al_,1)*(bitand(_al_,2)))+not(isbit(_al_,1))*_al_)
echo (_al_=(isbit(_al_,2)*(bitand(_al_,4)))+not(isbit(_al_,2))*_al_)+(_al_=(isbit(_al_,3)*(bitand(_al_,8)))+not(isbit(_al_,3))*_al_)+(_al_=(isbit(_al_,4)*(bitand(_al_,16)))+not(isbit(_al_,4))*_al_)
echo (_ha_=(isbit(_al_,1)*(int(sensorWidth()/2)-_xc_))+(isbit(_al_,2)*(sensorWidth()-_x2_)))+(_va_=(isbit(_al_,3)*(int(sensorHeight()/2)-_yc_))+(isbit(_al_,4)*(sensorHeight()-_y2_)))
echo (_xc_=_xc_+_ha_)+(_yc_=_yc_+_va_)+(_lw_=le(_lw_,1)+ge(_lw_,2)*2-lt(_x2_,20))+(_pw_=ne(_lw_,0)*_lw_+eq(_lw_,0))+(_x4_=int(_x2_/4))+(_x7_=int(_x2_/7))+(_x15_=int(_x2_/15))+setPen(_Cm_,psSolid,pmMask,_pw_+1)
echo drawArc(_xc_-_x4_,_yc_-_x4_,_xc_+_x4_,_yc_+_x4_,_xc_-_x4_,_x7_,_xc_+_x4_,_x7_)+setPen(_Cl_,psSolid,pmCopy,_pw_)+drawArc(_xc_-_x4_,_yc_-_x4_,_xc_+_x4_,_yc_+_x4_,_xc_-_x4_,_x7_,_xc_+_x4_,_x7_)+drawLine(_xc_,_yc_-_x4_-_x15_,_xc_,_yc_-_x15_)
echo (glCmdPowerOnColor0=clBlack)+(glCmdPowerOnColor1=clBlack)+(glCmdPowerOnAlignment=1)+(glCmdPowerOnLineWidth=2)
call :Profiler CmdPowerOn
echo []
echo [Circuit.StartupScript]
echo (glCmdPowerOnColor0=clBlack)+(glCmdPowerOnColor1=clBlack)+(glCmdPowerOnAlignment=1)+(glCmdPowerOnLineWidth=2)
echo []
echo.
goto :EOF
