 {
 ***********************************************************************
 MODBUS Proxy (Master). At the moment IP,RTU,ASCII clients implemented.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Port port prot decl
|  Open logical MODBUS port to connect device nodes.
|  port (1..16) is logical № (i.e. port identifier).
|  prot (IP,RTU,ASCII) is MODBUS transport protocol.
|  decl is port detail declaration, looks like that:
|   @Port 1 IP  tcp port 502 client locahost 
|   @Port 2 RTU com port 1 baudrate 9600 parity even databits 8 stopbits 1
|   @Port 3 ASCII com port 2 baudrate 115200 parity even databits 8 stopbits 1
|   See help on function pipe_init() for details.
| @PortPollRates Rx Tx
| @PortByteRates Rx Tx
| @PortPollCounters Rx Tx
| @PortByteCounters Rx Tx
| @PortErrorRates Rx Tx Ex
| @PortErrorCounters Rx Tx Ex
| @ZeroPortCounters n - Zero all stat. counters on port n (0 mean all).
|  Set polls/bypes/errors counter/rate tag names of type Integer or Real
|  to count errors and rate (per second) on this port:
|  Rx - Receiver polls/bytes/errors (errors is bad request, no answer).
|  Tx - Transmitter polls/bytes/errors (errors is fail to send answer).
|  Ex - MODBUS Exceptions              (errors is bad address or data).
| @View n
|  Print information about specified port n (0 mean all).
| @Modbus.Poll ref cid tot port uid fid $$dat
|  ref  = sender device reference or device name
|  cid  = command id (user defined parameter)  
|  tot  = timeout, ms: 1..MaxInt
|  port = port number: 1..16
|  uid  = unit id: 1..247
|  fid  = function id: 1,2,3,4,5,6,15,16.  
|  dat  = data unit, hex_encoded; PDU=(fid+dat)
|  Reply to sender may be one of:
|   @Modbus.Reply   ref cid tim port uid fid $$ans - reply   successfully with answer data hex(ans)
|   @Modbus.TimeOut ref cid tim port uid fid $$req - timeout on request with original data hex(req)
|   @Modbus.Refuse  ref cid tim port uid fid   msg - refuse  request with error message msg
|  where:
|   ref is &ModbusProxy reference; tim is response time, ms.
|   cid,port,uid,fid should be the same as in request (fid also may include exception bit).
|  Example:
|   @Modbus.Poll &Demo.Driver 33 100 1 1 3 $$00000003       Request to poll from &Demo.Driver command 33
|   @Modbus.Reply &ModbusProxy 33 10 1 1 3 $$064129EC250000 Success reply    send to &Demo.Driver
|   @Modbus.Timeout &ModbusProxy 33 110 1 1 3 $$00000003    Timeout detected send to &Demo.Driver
|   @Modbus.Refuse &ModbusProxy 33 Port closed 1            Refuse notifier  send to &Demo.Driver
| @CheckOpt c
|  Protocol check options:
|   L = check PDU length
|   P = check Protocol ID
|   T = check Transaction ID
| @TimeGap port gap
|  Time gap (time of silence) between i/o transactions
|  port = ModbusProxy logical port
|  gap  = time gap, ms
| @Skip n
| @Modbus.Reply ...
| @Modbus.Refuse ...
| @Modbus.TimeOut ...
|  Uses just for testing and debugging only.
| @ModScan32  - Run ModScan32  program to test MODBUS.
| @ModBusPoll - Run ModBusPoll program to test MODBUS.
| @ModbusHelp - Open manual - help file on &ModbusSrv.
| Implemented MODBUS protocols: TCP/IP, RTU and ASCII.
| Implemented MODBUS functions: 1,2,3,4,5,6,15,16.
|********************************************************
[]
 }
{
[Compiler.Options]            ; Size of table for ... 
Compiler.dtabmax = 1024*40    ; -Data segment ( number of virtual machine data items )
Compiler.stabmax = 1024*16    ; -Strings      ( number of available string var+const )
Compiler.dtabmin = 1024*4     ; Min stack  space at start ( error if free space less )
Compiler.stabmin = 1024*1     ; Min string space at start ( error if free space less )
[]
}
program ModbusProxy;             { MODBUS Proxy (Master)            }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_NetLibrary}            { NetLibrary constants             }
 MaxPortNum = 16;                { Max.number of logical ports      }
 MaxItemNum = 256;               { Max.number of items in fifo      }
 MaxBuffer  = 8192;              { Maximum size of buffer to read   }
 RatePeriod = 1000;              { Statistics poll period           }
 DefCheckOpt= 'LTUF';            { Default checking options         }

type
 TTagRef    = record tag:Integer; val:Real; end;  { Tag ref. & val. }
 TMBIORec   = record             { ModBus I/O record                }
  ref       : Integer;           { Reference of sender device       }
  tot       : Integer;           { Timeout, ms                      }
  cid       : Integer;           { Command Id                       }
  uid       : Integer;           { Unit Id                          }
  fid       : Integer;           { Function Id                      }
  dat       : String;            { PDU data; PDU=(fid+dat)          }
  adu       : String;            { Application Data Unit            }
  tim       : Real;              { Time stamp                       }
 end;                            {                                  }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_NetLibrary}            { NetLibrary variables             }
 modbus     : record             { MODBUS related data              }
  Port      : array[1..MaxPortNum] of record { TCP/COM ports        }
   Decl     : String;            { Port declaration                 }
   Pipe     : Integer;           { TCP/COM port pipe                }
   Prot     : Integer;           { Protocol 1/2/3=ASCII/RTU/IP      }
   Tran     : Integer;           { Transaction Id                   }
   Req      : TMBIORec;          { Request to port                  }
   Ans      : TMBIORec;          { Answer from port                 }
   Last     : record             { Last poll data                   }
    Poll    : Real;              { Last poll time, ms               }
    Rate    : Real;              { Last rate time, ms               }
   end;                          {                                  }
   Stat     : record             { Traffic Statistics               }
    Rate,                        { Rate                             }
    Count   : record             { Count                            }
     Bugs,                       { Errors                           }
     Bytes,                      { Bytes                            }
     Polls  : record             { Polls                            }
      Rx    : TTagRef;           { Received                         }
      Tx    : TTagRef;           { Transmitted                      }
      Ex    : TTagRef;           { MODBUS Exceptions, for bugs only }
     end;                        {                                  }
    end;                         {                                  }
   end;
   FIFO     : record             { FIFO buffer                      }
    Count   : Integer;           { Count of items                   }
    Head    : Integer;           { Head index                       }
    Item    : array[0..MaxItemNum] of TMBIORec; { Data items        }
   end;                          {                                  }
   TimeGap  : Integer;           { Gap between poll transactions,ms }
   CheckOpt : String;            { Checkig option                   }
  end;                           {                                  }
 end;                            {                                  }
 cmd_View            : Integer;  { Command @View                    }
 cmd_Skip            : Integer;  { Command @Skip                    }
 cmd_Reset           : Integer;  { Command @Reset                   }
 cmd_CheckOpt        : Integer;  { Command @CheckOpt                }
 cmd_TimeGap         : Integer;  { Command @TimeGap                 }
 cmd_Port            : Integer;  { Command @Port                    }
 cmd_PortErrorCounters :Integer; { Command @PortErrorCounters       }
 cmd_PortErrorRates  : Integer;  { Command @PortErrorRates          }
 cmd_PortByteCounters : Integer; { Command @PortByteCounters        }
 cmd_PortByteRates    : Integer; { Command @PortByteRates           }
 cmd_PortPollCounters : Integer; { Command @PortPollCounters        }
 cmd_PortPollRates   : Integer;  { Command @PortPollRates           }
 cmd_ZeroPortCounters : Integer; { Command @ZeroPortCounters        }
 cmd_ModBusPollExe   : Integer;  { Command @ModBusPoll              }
 cmd_ModScan32       : Integer;  { Command @ModScan32               }
 cmd_ModBusHelp      : Integer;  { Command @ModBusHelp              }
 cmd_ModBusTesting   : Integer;  { Command @ModBusTesting           }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_NetLibrary}            { NetLibrary functions             }

 //
 // Check port is good to use.
 //
 function modbus_port_ok(port:Integer):Boolean;
 begin
  modbus_port_ok:=(1<=port) and (port<=MaxPortNum);
 end;
 //
 // Return string like TCP[1], RTU[1] or ASC[1].
 //
 function modbus_port_alias(port:Integer):String;
 var prot:Integer;
 begin
  if modbus_port_ok(port) then prot:=modbus.Port[port].Prot else prot:=0;
  modbus_port_alias:=ExtractWord(prot,modbus_pr_ALIAS)+'['+Str(port)+']';
 end;
 //
 // modbus routine uses to send refuse message and fix error.
 //
 procedure modbus_refuse(tag,code,ref,cid,tot,port,uid,fid:Integer; msg:String);
 begin
  if ref<>0 then DevSendCmd(ref,modbus_proxy_nice('@Modbus.Refuse',devMySelf,cid,tot,port,uid,fid,msg,0));
  modbus_fixerror(tag,code,msg);
 end;
 //
 // ModBus I/O record routines. D=Destination, S=Source.
 //
 procedure MBIORec_Assign(var D:TMBIORec; ref,cid,tot,uid,fid:Integer; dat,adu:String; tim:Real);
 begin
  D.ref:=ref; D.cid:=cid; D.tot:=tot; D.uid:=uid; D.fid:=fid; D.dat:=dat; D.adu:=adu; D.tim:=tim;
 end;
 procedure MBIORec_Clear(var D:TMBIORec);
 begin
  MBIORec_Assign(D,0,0,0,0,0,'','',0);
 end;
 //
 // Zero statistics for specified port (0=all ports).
 //
 procedure modbus_zero_stat(port:Integer);
 begin
  if port=0 then begin
   for port:=1 to MaxPortNum do modbus_zero_stat(port);
  end else
  if modbus_port_ok(port) then begin
   bNul(modbus_set_tag(modbus.Port[port].Stat.Rate.Bugs.Rx.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Rate.Bugs.Tx.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Rate.Bugs.Ex.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Rate.Bytes.Rx.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Rate.Bytes.Tx.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Rate.Bytes.Ex.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Rate.Polls.Rx.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Rate.Polls.Tx.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Rate.Polls.Ex.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Count.Bugs.Rx.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Count.Bugs.Tx.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Count.Bugs.Ex.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Count.Bytes.Rx.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Count.Bytes.Tx.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Count.Bytes.Ex.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Count.Polls.Rx.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Count.Polls.Tx.tag,0));
   bNul(modbus_set_tag(modbus.Port[port].Stat.Count.Polls.Ex.tag,0));
   modbus.Port[port].Stat.Rate.Bugs.Rx.val:=0;
   modbus.Port[port].Stat.Rate.Bugs.Tx.val:=0;
   modbus.Port[port].Stat.Rate.Bugs.Ex.val:=0;
   modbus.Port[port].Stat.Rate.Bytes.Rx.val:=0;
   modbus.Port[port].Stat.Rate.Bytes.Tx.val:=0;
   modbus.Port[port].Stat.Rate.Bytes.Ex.val:=0;
   modbus.Port[port].Stat.Rate.Polls.Rx.val:=0;
   modbus.Port[port].Stat.Rate.Polls.Tx.val:=0;
   modbus.Port[port].Stat.Rate.Polls.Ex.val:=0;
   modbus.Port[port].Stat.Count.Bugs.Rx.val:=0;
   modbus.Port[port].Stat.Count.Bugs.Tx.val:=0;
   modbus.Port[port].Stat.Count.Bugs.Ex.val:=0;
   modbus.Port[port].Stat.Count.Bytes.Rx.val:=0;
   modbus.Port[port].Stat.Count.Bytes.Tx.val:=0;
   modbus.Port[port].Stat.Count.Bytes.Ex.val:=0;
   modbus.Port[port].Stat.Count.Polls.Rx.val:=0;
   modbus.Port[port].Stat.Count.Polls.Tx.val:=0;
   modbus.Port[port].Stat.Count.Polls.Ex.val:=0;
  end;
 end;
 //
 // Clear modbus variables for specified port (0=all ports).
 //
 procedure modbus_clear(port:Integer);
 var item:Integer;
 begin
  if port=0 then begin
   for port:=1 to MaxPortNum do modbus_clear(port);
  end else
  if modbus_port_ok(port) then begin
   modbus.Port[port].Decl:='';
   modbus.Port[port].Pipe:=0;
   modbus.Port[port].Prot:=0;
   modbus.Port[port].Tran:=0;
   modbus.Port[port].Last.Poll:=0;
   modbus.Port[port].Last.Rate:=0;
   MBIORec_Clear(modbus.Port[port].Req);
   MBIORec_Clear(modbus.Port[port].Ans);
   modbus.Port[port].Stat.Rate.Bugs.Rx.tag:=0;
   modbus.Port[port].Stat.Rate.Bugs.Tx.tag:=0;
   modbus.Port[port].Stat.Rate.Bugs.Ex.tag:=0;
   modbus.Port[port].Stat.Rate.Bytes.Rx.tag:=0;
   modbus.Port[port].Stat.Rate.Bytes.Tx.tag:=0;
   modbus.Port[port].Stat.Rate.Bytes.Ex.tag:=0;
   modbus.Port[port].Stat.Rate.Polls.Rx.tag:=0;
   modbus.Port[port].Stat.Rate.Polls.Tx.tag:=0;
   modbus.Port[port].Stat.Rate.Polls.Ex.tag:=0;
   modbus.Port[port].Stat.Count.Bugs.Rx.tag:=0;
   modbus.Port[port].Stat.Count.Bugs.Tx.tag:=0;
   modbus.Port[port].Stat.Count.Bugs.Ex.tag:=0;
   modbus.Port[port].Stat.Count.Bytes.Rx.tag:=0;
   modbus.Port[port].Stat.Count.Bytes.Tx.tag:=0;
   modbus.Port[port].Stat.Count.Bytes.Ex.tag:=0;
   modbus.Port[port].Stat.Count.Polls.Rx.tag:=0;
   modbus.Port[port].Stat.Count.Polls.Tx.tag:=0;
   modbus.Port[port].Stat.Count.Polls.Ex.tag:=0;
   modbus_zero_stat(port);
   modbus.Port[port].Fifo.Count:=0;
   modbus.Port[port].Fifo.Head:=0;
   for item:=0 to MaxItemNum do MBIORec_Clear(modbus.Port[port].Fifo.Item[item]);
   modbus.Port[port].CheckOpt:='';
   modbus.Port[port].TimeGap:=0;
  end;
 end;
 //
 // Set checkopt for specified port (0=all ports).
 //
 procedure modbus_set_checkopt(port:Integer; opt:String);
 begin
  if port=0 then begin
   for port:=1 to MaxPortNum do modbus_set_checkopt(port,opt);
  end else
  if modbus_port_ok(port) then begin
   modbus.Port[port].CheckOpt:=Trim(opt);
  end;
 end;
 //
 // Close specified port (0=all ports).
 //
 procedure modbus_close(port:Integer);
 begin
  if port=0 then begin
   for port:=1 to MaxPortNum do modbus_close(port);
  end else
  if modbus_port_ok(port) then begin
   if modbus.Port[port].Pipe<>0 then
   if pipe_free(modbus.Port[port].Pipe)
   then Success('PORT CLOSE SUCCESS: '+Str(port)
               +' '+modbus_prot_name(modbus.Port[port].Prot)
               +' '+modbus.Port[port].Decl)
   else Trouble('PORT CLOSE FAILURE: '+Str(port)
               +' '+modbus_prot_name(modbus.Port[port].Prot)
               +' '+modbus.Port[port].Decl);
   modbus_clear(port);
  end;
 end;
 //
 // Open MODBUS port
 //  arg = Port Prot  Decl
 //  arg = 1    IP    tcp port 502 client localhost
 //  arg = 2    RTU   com port 1 baudrate 9600 parity even databits 8 stopbits 1
 //  arg = 3    ASCII com port 2 baudrate 9600 parity even databits 8 stopbits 1
 //
 function modbus_open(arg:String):Integer;
 var Port,Prot,Pipe:Integer; Decl:String;
 begin
  Port:=Val(ExtractWord(1,arg));
  Prot:=modbus_prot_byname(UpCaseStr(ExtractWord(2,arg)));
  Decl:=Trim(SkipWords(2,arg));
  if modbus_port_ok(Port) and modbus_prot_ok(Prot) and not IsEmptyStr(Decl) then begin
   Pipe:=pipe_init(Decl);
   if Pipe<>0 then begin
    modbus_close(Port);
    modbus.Port[Port].Decl:=Decl;
    modbus.Port[Port].Prot:=Prot;
    modbus.Port[Port].Pipe:=Pipe;
    modbus.Port[Port].CheckOpt:=DefCheckOpt;
   end else Port:=0;
  end else Port:=0;
  modbus_open:=Port;
  Decl:='';
 end;
 //
 // Initialize modbus variables.
 //
 procedure modbus_init;
 begin
  modbus_clear(0);
 end;
 //
 // Finalize modbus variables.
 //
 procedure modbus_free;
 begin
  modbus_close(0);
  modbus_clear(0);
 end;
 //
 // Reset modbus to initial state.
 //
 procedure modbus_reset;
 begin
  modbus_free;
  modbus_init;
 end;
 //
 // Calculate FIFO item index.
 //
 function modbus_item_index(i,L,H:Integer):Integer;
 begin
  if i<L then i:=L;
  modbus_item_index:=L+(i-L) mod (H-L+1);
 end;
 //
 // Put message to modbus FIFO. Return 1=OK, 0=FAIL.
 //
 function modbus_fifo_poke(ref,cid,tot,port,uid,fid:Integer; dat:String; tim:Real):Integer;
 var i,item,poke:Integer;
 begin
  poke:=0;
  if (ref<>0) then if (tot>0) then
  if modbus_port_ok(port) then begin
   for i:=0 to modbus.Port[port].FIFO.Count-1 do if poke=0 then begin
    item:=modbus_item_index(modbus.Port[port].FIFO.Head+i,0,MaxItemNum);
    if modbus.Port[port].FIFO.Item[item].ref = ref then begin
     MBIORec_Assign(modbus.Port[port].FIFO.Item[item],ref,cid,tot,uid,fid,dat,'',tim);
     poke:=1;
    end;
   end;
   if poke=0 then
   if modbus.Port[port].FIFO.Count<=MaxItemNum then begin
    item:=modbus_item_index(modbus.Port[port].FIFO.Head+modbus.Port[port].FIFO.Count,0,MaxItemNum);
    MBIORec_Assign(modbus.Port[port].FIFO.Item[item],ref,cid,tot,uid,fid,dat,'',tim);
    modbus.Port[port].FIFO.Count:=modbus.Port[port].FIFO.Count+1;
    poke:=1;
   end;
  end;
  modbus_fifo_poke:=poke;
 end;
 //
 // Get message from modbus FIFO.
 //
 function modbus_fifo_peek(var ref,cid,tot:Integer; port:Integer; var uid,fid:Integer; var dat:String;
                           var tim:Real):Integer;
 var i,item,peek:Integer;
 begin
  peek:=0;
  if modbus_port_ok(port) then
  if modbus.Port[port].FIFO.Count>0 then begin
   item:=modbus_item_index(modbus.Port[port].FIFO.Head,0,MaxItemNum);
   modbus.Port[port].FIFO.Head:=modbus_item_index(item+1,0,MaxItemNum);
   modbus.Port[port].FIFO.Count:=modbus.Port[port].FIFO.Count-1;
   ref:=modbus.Port[port].FIFO.Item[item].ref;
   cid:=modbus.Port[port].FIFO.Item[item].cid;
   tot:=modbus.Port[port].FIFO.Item[item].tot;
   uid:=modbus.Port[port].FIFO.Item[item].uid;
   fid:=modbus.Port[port].FIFO.Item[item].fid;
   dat:=modbus.Port[port].FIFO.Item[item].dat;
   tim:=modbus.Port[port].FIFO.Item[item].tim;
   peek:=1;
  end;
  if peek=0 then begin ref:=0; cid:=0; tot:=0; uid:=0; fid:=0; dat:=''; tim:=0; end;
  modbus_fifo_peek:=peek;
 end;
 //
 // Delete message from modbus FIFO.
 //
 function modbus_fifo_skip(port:Integer):Integer;
 var ref,cid,tot,uid,fid:Integer; tim:Real; dat:String;
 begin
  dat:='';
  modbus_fifo_skip:=modbus_fifo_peek(ref,cid,tot,port,uid,fid,dat,tim);
  dat:='';
 end;
 //
 // View specified port (0=all ports).
 //
 procedure modbus_view(port:Integer);
 var item,i,ref,cid,tot,uid,fid:Integer; dat:String; tim:Real;
 begin
  if port=0 then begin
   for port:=1 to MaxPortNum do modbus_view(port);
  end else
  if modbus_port_ok(port) then
  if modbus.Port[port].Pipe<>0 then begin
   Success('@Port '+Str(port)
          +' '+modbus_prot_name(modbus.Port[port].Prot)
          +' '+modbus.Port[port].Decl);
   Success(' Bugs Rate/Count'
          +' Rx='+Str(modbus.Port[port].Stat.Rate.Bugs.Rx.val)
          +'/'+Str(modbus.Port[port].Stat.Count.Bugs.Rx.val)
          +' Tx='+Str(modbus.Port[port].Stat.Rate.Bugs.Tx.val)
          +'/'+Str(modbus.Port[port].Stat.Count.Bugs.Tx.val)
          +' Ex='+Str(modbus.Port[port].Stat.Rate.Bugs.Ex.val)
          +'/'+Str(modbus.Port[port].Stat.Count.Bugs.Ex.val));
   Success(' Byte Rate/Count'
          +' Rx='+Str(modbus.Port[port].Stat.Rate.Bytes.Rx.val)
          +'/'+Str(modbus.Port[port].Stat.Count.Bytes.Rx.val)
          +' Tx='+Str(modbus.Port[port].Stat.Rate.Bytes.Tx.val)
          +'/'+Str(modbus.Port[port].Stat.Count.Bytes.Tx.val)
          +' Ex='+Str(modbus.Port[port].Stat.Rate.Bytes.Ex.val)
          +'/'+Str(modbus.Port[port].Stat.Count.Bytes.Ex.val));
   Success(' Poll Rate/Count'
          +' Rx='+Str(modbus.Port[port].Stat.Rate.Polls.Rx.val)
          +'/'+Str(modbus.Port[port].Stat.Count.Polls.Rx.val)
          +' Tx='+Str(modbus.Port[port].Stat.Rate.Polls.Tx.val)
          +'/'+Str(modbus.Port[port].Stat.Count.Polls.Tx.val)
          +' Ex='+Str(modbus.Port[port].Stat.Rate.Polls.Ex.val)
          +'/'+Str(modbus.Port[port].Stat.Count.Polls.Ex.val));
   Success(' CheckOpt '+modbus.Port[port].CheckOpt);
   Success(' TimeGap '+Str(modbus.Port[port].TimeGap)+' ms');
   Success(' FIFO.Count '+Str(modbus.Port[port].FIFO.Count));
   Success(' FIFO.Head  '+Str(modbus.Port[port].FIFO.Head));
   for i:=0 to modbus.Port[port].FIFO.Count-1 do begin
    item:=modbus_item_index(modbus.Port[port].FIFO.Head+i,0,MaxItemNum);
    ref:=modbus.Port[port].FIFO.Item[item].ref;
    cid:=modbus.Port[port].FIFO.Item[item].cid;
    tot:=modbus.Port[port].FIFO.Item[item].tot;
    uid:=modbus.Port[port].FIFO.Item[item].uid;
    fid:=modbus.Port[port].FIFO.Item[item].fid;
    dat:=modbus.Port[port].FIFO.Item[item].dat;
    tim:=modbus.Port[port].FIFO.Item[item].tim;
    Success(modbus_proxy_nice(' FIFO['+Str(i)+']:',ref,cid,tot,port,uid,fid,dat,64)+' '+Str(tim));
   end;
  end;
  dat:='';
 end;
 //
 // Poll modbus pipe
 //
 procedure modbus_poll;
 const Word16Mask=65535;
 var port,pipe,sid,ref,cid,tot,tim,uid,fid,tid,pid,saddr,quant,pdulen1,pdulen2:Integer;
     ms,dt,reqtim:Real; dat,raw,adu:String; acceptable:Boolean;
  procedure CalcRate(rtag:Integer; ctag:Integer; var cval:Real; dt:Real);
  var c:Real;
  begin
   if dt>0 then begin
    c:=modbus_get_tag(ctag,0);
    bNul(modbus_set_tag(rtag,1000*(c-cval)/dt));
    cval:=c;
   end;
  end;
  procedure ClearPoll(port:Integer; ms:Real; sid:Integer);
  begin
   if modbus_port_ok(port) then begin
    MBIORec_Clear(modbus.Port[port].Req);
    MBIORec_Clear(modbus.Port[port].Ans);
    modbus.Port[port].Last.Poll:=ms;
   end;
   if pipe_ref(sid)<>0 then begin
    bNul(pipe_txclear(sid));
    bNul(pipe_rxclear(sid));
   end;
  end;
  procedure Response(ref:Integer; msg:String);
  begin
   if DebugFlagEnabled(dfViewExp) then ViewExp(modbus_port_alias(port)+' > '+msg);
   DevSendCmd(ref,msg);  
  end;
  function IsCheckOpt(port:Integer; Opt:Char):Boolean;
  begin
   if modbus_port_ok(port)
   then IsCheckOpt:=Pos(Opt,modbus.Port[port].CheckOpt)>0
   else IsCheckOpt:=false;
  end;
 begin
  //
  // Poll modbus ports: MODBUS IP/RTU/ASCII client.
  //
  ms:=mSecNow;
  dat:=''; raw:=''; adu:='';
  for port:=1 to MaxPortNum do begin
   pipe:=modbus.Port[port].Pipe;
   if pipe<>0 then if pipe_connected(pipe)>0 then
   if modbus_prot_ok(modbus.Port[port].Prot) then begin
    sid:=pipe_stream(pipe,0);
    if pipe_connected(sid)=1 then begin
     if modbus.Port[port].Req.ref=0 then begin
      // Create and sent new request from FIFO
      if ms-modbus.Port[port].Last.Poll>=modbus.Port[port].TimeGap then
      if modbus_fifo_peek(ref,cid,tot,port,uid,fid,dat,reqtim)<>0 then begin
       ClearPoll(port,ms,sid);
       if modbus.Port[port].Prot=modbus_pr_IP
       then modbus.Port[port].Tran:=iAnd(modbus.Port[port].Tran+1,Word16Mask)
       else modbus.Port[port].Tran:=0; // RTU,ASCII don't use transaction id.
       adu:=modbus_encode_adu(modbus.Port[port].Tran,modbus.Port[port].Prot,uid,fid,dat);
       MBIORec_Assign(modbus.Port[port].Req,ref,cid,tot,uid,fid,dat,adu,ms);
       MBIORec_Assign(modbus.Port[port].Ans,ref,cid,tot,uid,fid,'','',0);
       if pipe_send(sid,modbus.Port[port].Req.adu)=Length(modbus.Port[port].Req.adu) then begin
        bNul(modbus_inc_tag(modbus.Port[port].Stat.Count.Polls.Tx.tag,1));
        bNul(modbus_inc_tag(modbus.Port[port].Stat.Count.Bytes.Tx.tag,Length(modbus.Port[port].Req.adu)));
        if DebugFlagEnabled(dfDetails)
        then Details('Sent '+Str(Length(modbus.Port[port].Req.adu))+' bytes to '+modbus_port_alias(port));
       end else begin
        modbus_refuse(modbus.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,ref,cid,tot,port,uid,fid,
                              modbus_port_alias(port)+' fail to send');
        ClearPoll(port,ms,sid);
       end;
      end;
     end else begin
      // Read and process device answer
      if pipe_rxcount(sid)>0 then begin // Read data from port
       dat:=pipe_recv(sid,MaxBuffer);
       bNul(modbus_inc_tag(modbus.Port[port].Stat.Count.Bytes.Rx.tag,Length(dat)));
       if DebugFlagEnabled(dfViewImp) then ViewImp(modbus_port_alias(port)+' < '+Hex_Encode(dat));
       modbus.Port[port].Ans.adu:=modbus.Port[port].Ans.adu+dat; dat:='';
       if Length(modbus.Port[port].Ans.adu)>MaxBuffer then begin
        modbus_refuse(modbus.Port[port].Stat.Count.Bugs.Rx.tag,ErrorCode,modbus.Port[port].Req.ref,
                      modbus.Port[port].Req.cid,modbus.Port[port].Req.tot,port,
                      modbus.Port[port].Req.uid,modbus.Port[port].Req.fid,
                      modbus_port_alias(port)+' Rx fifo over');
        ClearPoll(port,ms,sid);
       end;
      end;
      if modbus.Port[port].Req.ref<>0 then // Process received data
      if Length(modbus.Port[port].Ans.adu)>0 then begin
       pdulen1:=modbus_decode_adu(modbus.Port[port].Ans.adu,modbus.Port[port].Prot,tid,pid,uid,fid,dat);
       if pdulen1>0 then pdulen2:=modbus_decode_pdu('A',fid,dat,saddr,quant,raw) else pdulen2:=0;
       if DebugFlagEnabled(dfDetails) then Details('Decode ADU:'
                          +' l:'+Str(pdulen1)+'/'+Str(pdulen2)
                          +' t:'+Str(tid)+'/'+Str(modbus.Port[port].Tran)
                          +' p:'+Str(pid)+'/'+Str(modbus.Port[port].Prot)
                          +' u:'+Str(uid)+'/'+Str(modbus.Port[port].Req.uid)
                          +' f:'+Str(fid)+'/'+Str(modbus.Port[port].Req.fid)
                          +' $$'+Hex_Encode(dat));
       acceptable:=(pdulen1>0) and (pdulen2>0);
       if IsCheckOpt(port,'L') then acceptable:=acceptable and (pdulen2=pdulen1);
       if (modbus.Port[port].Prot=modbus_pr_IP) then
       if IsCheckOpt(port,'P') then acceptable:=acceptable and (pid=modbus.Port[port].Prot);
       if (modbus.Port[port].Prot=modbus_pr_IP) then
       if IsCheckOpt(port,'T') then acceptable:=acceptable and (tid=modbus.Port[port].Tran);
       if IsCheckOpt(port,'U') then acceptable:=acceptable and (uid=modbus.Port[port].Req.uid);
       if IsCheckOpt(port,'F') then acceptable:=acceptable and (modbus_un_except(fid)=modbus.Port[port].Req.fid); 
       if acceptable then begin
        Response(modbus.Port[port].Req.ref,modbus_proxy_poll('@Modbus.Reply',devMySelf,
                 modbus.Port[port].Req.cid,Round(ms-modbus.Port[port].Req.tim),port,uid,fid,dat));
        if modbus_is_except(fid)
        then bNul(modbus_inc_tag(modbus.Port[port].Stat.Count.Bugs.Ex.tag,1))
        else bNul(modbus_inc_tag(modbus.Port[port].Stat.Count.Polls.Rx.tag,1));
        ClearPoll(port,ms,sid);
       end;
      end;
      if modbus.Port[port].Req.ref<>0 then // Check for TimeOut
      if ms>modbus.Port[port].Req.tim+modbus.Port[port].Req.tot then begin
       Response(modbus.Port[port].Req.ref,modbus_proxy_poll('@Modbus.TimeOut',devMySelf,
                modbus.Port[port].Req.cid,Round(ms-modbus.Port[port].Req.tim),port,
                modbus.Port[port].Req.uid,modbus.Port[port].Req.fid,modbus.Port[port].Req.dat));
       bNul(modbus_inc_tag(modbus.Port[port].Stat.Count.Bugs.Rx.tag,1));
       ClearPoll(port,ms,sid);
      end;
     end;
    end;
   end;
  end;
  //
  // Rate modbus ports.
  //
  if SysTimer_Pulse(RatePeriod)>0 then begin
   ms:=mSecNow;
   for port:=1 to MaxPortNum do begin
    dt:=ms-modbus.Port[port].Last.Rate;
    CalcRate(modbus.Port[port].Stat.Rate.Polls.Rx.tag,
             modbus.Port[port].Stat.Count.Polls.Rx.tag,
             modbus.Port[port].Stat.Count.Polls.Rx.val,dt);
    CalcRate(modbus.Port[port].Stat.Rate.Bytes.Rx.tag,
             modbus.Port[port].Stat.Count.Bytes.Rx.tag,
             modbus.Port[port].Stat.Count.Bytes.Rx.val,dt);
    CalcRate(modbus.Port[port].Stat.Rate.Bugs.Rx.tag,
             modbus.Port[port].Stat.Count.Bugs.Rx.tag,
             modbus.Port[port].Stat.Count.Bugs.Rx.val,dt);
    CalcRate(modbus.Port[port].Stat.Rate.Polls.Tx.tag,
             modbus.Port[port].Stat.Count.Polls.Tx.tag,
             modbus.Port[port].Stat.Count.Polls.Tx.val,dt);
    CalcRate(modbus.Port[port].Stat.Rate.Bytes.Tx.tag,
             modbus.Port[port].Stat.Count.Bytes.Tx.tag,
             modbus.Port[port].Stat.Count.Bytes.Tx.val,dt);
    CalcRate(modbus.Port[port].Stat.Rate.Bugs.Tx.tag,
             modbus.Port[port].Stat.Count.Bugs.Tx.tag,
             modbus.Port[port].Stat.Count.Bugs.Tx.val,dt);
    CalcRate(modbus.Port[port].Stat.Rate.Bugs.Ex.tag,
             modbus.Port[port].Stat.Count.Bugs.Ex.tag,
             modbus.Port[port].Stat.Count.Bugs.Ex.val,dt);
    modbus.Port[port].Last.Rate:=ms;
   end;
  end;
  dat:=''; raw:=''; adu:='';
 end;
 //
 // Test modbus routines.
 //
 procedure modbus_testing;
 begin
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearNetLibrary;
  modbus_clear(0);
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  InitNetLibrary;
  modbus_init;
  StdIn_SetScripts('@StartupScript','');
  StdIn_SetTimeouts(0,0,MaxInt,0);
  cmd_View              := RegisterStdInCmd('@View',              '');
  cmd_Skip              := RegisterStdInCmd('@Skip',              '');
  cmd_Reset             := RegisterStdInCmd('@Reset',             '');
  cmd_CheckOpt          := RegisterStdInCmd('@CheckOpt',          '');
  cmd_TimeGap           := RegisterStdInCmd('@TimeGap',           '');
  cmd_Port              := RegisterStdInCmd('@Port',              '');
  cmd_PortErrorCounters := RegisterStdInCmd('@PortErrorCounters', '');
  cmd_PortErrorRates    := RegisterStdInCmd('@PortErrorRates',    '');
  cmd_PortByteCounters  := RegisterStdInCmd('@PortByteCounters',  '');
  cmd_PortByteRates     := RegisterStdInCmd('@PortByteRates',     '');
  cmd_PortPollCounters  := RegisterStdInCmd('@PortPollCounters',  '');
  cmd_PortPollRates     := RegisterStdInCmd('@PortPollRates',     '');
  cmd_ZeroPortCounters  := RegisterStdInCmd('@ZeroPortCounters',  '');
  cmd_ModBusPollExe     := RegisterStdInCmd('@ModBusPoll',        '');
  cmd_ModScan32         := RegisterStdInCmd('@ModScan32',         '');
  cmd_ModBusHelp        := RegisterStdInCmd('@ModBusHelp',        '');
  cmd_ModBusTesting     := RegisterStdInCmd('@ModBusTesting',     '');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  FreeNetLibrary;
  modbus_free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  PollNetLibrary;
  modbus_poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer; dat,raw:String;
     ref,cid,tot,tim,port,uid,fid,poke,peek,tag,saddr,quant,p:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   dat:='';
   raw:='';
   {
   @Modbus.Poll &Sender 0 100 1 1 3 $$00000003
   }
   if (cmdid = cmd_NetModbusPoll) then begin
    cid:=0; tot:=0; port:=0; uid:=0; fid:=0;
    p:=Pos(' $$',arg);
    if p>1 then begin
     dat:=Copy(arg,p+1);
     arg:=Copy(arg,1,p-1);
     ref:=Val(ExtractWord(1,arg));
     if ref=0 then ref:=RefFind('Device '+ExtractWord(1,arg)); 
     if IsRefDevice(ref) then begin
      cid:=Val(ExtractWord(2,arg));
      tot:=Val(ExtractWord(3,arg));
      if tot>0 then begin
       port:=Val(ExtractWord(4,arg));
       if modbus_port_ok(port) then begin
        if pipe_ref(modbus.Port[port].Pipe)<>0 then begin
         uid:=Val(ExtractWord(5,arg));
         if modbus_addr_ok(uid) then begin
          fid:=Val(ExtractWord(6,arg));
          if modbus_func_ok(fid) then begin
           dat:=Hex_Decode(dat);
           if modbus_decode_pdu('R',fid,dat,saddr,quant,raw)>0 then begin
            poke:=modbus_fifo_poke(ref,cid,tot,port,uid,fid,dat,mSecNow);
            if poke=0 then modbus_refuse(modbus.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,
                                         ref,cid,tot,port,uid,fid,'FIFO OVER');
            if poke>0 then if DebugFlagEnabled(dfDetails) then Details(Cmd+'='+Str(poke));
           end else modbus_refuse(modbus.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,
                                  ref,cid,tot,port,uid,fid,'Bad Data $$'+Hex_Encode(dat));
          end else modbus_refuse(modbus.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,
                                 ref,cid,tot,port,uid,fid,'Bad Func '+ExtractWord(6,arg));
         end else modbus_refuse(modbus.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,
                                ref,cid,tot,port,uid,fid,'Bad Unit '+ExtractWord(5,arg));
        end else modbus_refuse(modbus.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,
                               ref,cid,tot,port,uid,fid,'Port closed '+ExtractWord(4,arg));
       end else modbus_refuse(0,ErrorCode,ref,cid,tot,port,uid,fid,'Bad Port '+ExtractWord(4,arg));
      end else modbus_refuse(0,ErrorCode,ref,cid,tot,port,uid,fid,'Bad Timeout '+ExtractWord(3,arg));
     end else modbus_refuse(0,ErrorCode,ref,cid,tot,port,uid,fid,'Bad Device '+ExtractWord(1,arg));
    end else modbus_refuse(0,ErrorCode,ref,cid,tot,port,uid,fid,'Bad Marker $$');
    Data:='';
   end else
   {
   @Modbus.Refuse ...
   }
   if (cmdid = cmd_NetModbusRefuse) then begin
    if modbus_proxy_reply(cmd,arg,ref,cid,tim,port,uid,fid,dat)
    then Problem(modbus_proxy_nice(cmd,ref,cid,tim,port,uid,fid,dat,0))
    else Problem(cmd+' '+arg);
    Data:='';
   end else
   {
   @Modbus.Reply ...
   }
   if (cmdid = cmd_NetModbusReply) then begin
    if modbus_proxy_reply(cmd,arg,ref,cid,tim,port,uid,fid,dat)
    then Success(modbus_proxy_nice(cmd,ref,cid,tim,port,uid,fid,dat,MaxInt))
    else Success(cmd+' '+arg);
    Data:='';
   end else
   {
   @Modbus.TimeOut ...
   }
   if (cmdid = cmd_NetModbusTimeOut) then begin
    if modbus_proxy_reply(cmd,arg,ref,cid,tim,port,uid,fid,dat)
    then Problem(modbus_proxy_nice(cmd,ref,cid,tim,port,uid,fid,dat,MaxInt))
    else Problem(cmd+' '+arg);
    Data:='';
   end else
   {
   @View 1
   }
   if (cmdid = cmd_View) then begin
    modbus_view(iValDef(arg,0));
    Data:='';
   end else
   {
   @Skip 1
   }
   if (cmdid = cmd_Skip) then begin
    port:=iValDef(arg,0);
    peek:=modbus_fifo_skip(port);
    Success(cmd+'='+Str(peek));
    Data:='';
   end else
   {
   @Reset
   }
   if (cmdid = cmd_Reset) then begin
    modbus_reset;
    Success(cmd);
    Data:='';
   end else
   {
   @CheckOpt 0 *       Set all ports to default values
   @CheckOpt 1 LPTUF   Set port 1 checkopt as specified
   }
   if (cmdid = cmd_CheckOpt) then begin
    port:=iValDef(ExtractWord(1,arg),-1);
    if (port>=0) then
    if (WordCount(arg)>1) then
    if IsSameText(ExtractWord(2,arg),'*')
    then modbus_set_checkopt(port,DefCheckOpt)
    else modbus_set_checkopt(port,UpCaseStr(ExtractWord(2,arg)));
    Data:='';
   end else
   {
   @TimeGap 1 10
   }
   if (cmdid = cmd_TimeGap) then begin
    port:=iValDef(ExtractWord(1,arg),-1);
    if modbus_port_ok(port) then begin
     modbus.Port[port].TimeGap:=iValDef(ExtractWord(2,arg),modbus.Port[port].TimeGap);
    end;
    Data:='';
   end else
   {
   @Port 1 ip  tcp port 502 client localhost
   @Port 2 rtu com port 1 baudrate 9600 parity even databits 8 stopbits 1
   @Port 3 rtu com port 2 baudrate 9600 parity even databits 8 stopbits 1
   @Port PortNum[1..16] Protocol[IP,RTU,ASCII] Description[see pipe_init()]
   }
   if (cmdid = cmd_Port) then begin
    port:=modbus_open(Trim(arg));
    if modbus_port_ok(port)
    then Success(cmd+' '+Str(port)+' '+modbus_prot_name(modbus.Port[port].Prot)+' '+modbus.Port[port].Decl)
    else Trouble('Failed: '+Trim(Data));
    Data:='';
   end else
   {
   @PortErrorCounters 1 Modbus.BugsCount.Rx Modbus.BugsCount.Tx Modbus.BugsCount.Ex
   }
   if (cmdid = cmd_PortErrorCounters) then begin
    port:=Val(ExtractWord(1,arg));
    if modbus_port_ok(port) then begin
     modbus.Port[port].Stat.Count.Bugs.Rx.tag:=FindTag(ExtractWord(2,arg));
     modbus.Port[port].Stat.Count.Bugs.Tx.tag:=FindTag(ExtractWord(3,arg));
     modbus.Port[port].Stat.Count.Bugs.Ex.tag:=FindTag(ExtractWord(4,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Count.Bugs.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Count.Bugs.Tx.tag),'"')
                              +' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Count.Bugs.Ex.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortErrorRates 1 Modbus.ErrorRates.Rx Modbus.ErrorRates.Tx Modbus.ErrorRates.Ex
   }
   if (cmdid = cmd_PortErrorRates) then begin
    port:=Val(ExtractWord(1,arg));
    if modbus_port_ok(port) then begin
     modbus.Port[port].Stat.Rate.Bugs.Rx.tag:=FindTag(ExtractWord(2,arg));
     modbus.Port[port].Stat.Rate.Bugs.Tx.tag:=FindTag(ExtractWord(3,arg));
     modbus.Port[port].Stat.Rate.Bugs.Ex.tag:=FindTag(ExtractWord(4,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Rate.Bugs.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Rate.Bugs.Tx.tag),'"')
                              +' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Rate.Bugs.Ex.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortByteCounters 1 Modbus.Bytes.Rx Modbus.Bytes.Tx
   }
   if (cmdid = cmd_PortByteCounters) then begin
    port:=Val(ExtractWord(1,arg));
    if modbus_port_ok(port) then begin
     modbus.Port[port].Stat.Count.Bytes.Rx.tag:=FindTag(ExtractWord(2,arg));
     modbus.Port[port].Stat.Count.Bytes.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Count.Bytes.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Count.Bytes.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortByteRates 1 Modbus.ByteRates.Rx Modbus.ByteRates.Tx
   }
   if (cmdid = cmd_PortByteRates) then begin
    port:=Val(ExtractWord(1,arg));
    if modbus_port_ok(port) then begin
     modbus.Port[port].Stat.Rate.Bytes.Rx.tag:=FindTag(ExtractWord(2,arg));
     modbus.Port[port].Stat.Rate.Bytes.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Rate.Bytes.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Rate.Bytes.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortPollCounters 1 Modbus.Polls.Rx Modbus.Polls.Tx
   }
   if (cmdid = cmd_PortPollCounters) then begin
    port:=Val(ExtractWord(1,arg));
    if modbus_port_ok(port) then begin
     modbus.Port[port].Stat.Count.Polls.Rx.tag:=FindTag(ExtractWord(2,arg));
     modbus.Port[port].Stat.Count.Polls.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Count.Polls.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Count.Polls.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortPollRates 1 Modbus.PollRates.Rx Modbus.PollRates.Tx
   }
   if (cmdid = cmd_PortPollRates) then begin
    port:=Val(ExtractWord(1,arg));
    if modbus_port_ok(port) then begin
     modbus.Port[port].Stat.Rate.Polls.Rx.tag:=FindTag(ExtractWord(2,arg));
     modbus.Port[port].Stat.Rate.Polls.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Rate.Polls.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(modbus.Port[port].Stat.Rate.Polls.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @ZeroPortCounters 1
   }
   if (cmdid = cmd_ZeroPortCounters) then begin
    modbus_zero_stat(Val(Trim(arg)));
    Data:='';
   end else
   {
   @ModBusPoll demo
   }
   if (cmdid = cmd_ModBusPollExe) then begin
    rNul(Eval('@system @async @run -hide '+AdaptExeFileName('modbuspoll.bat')+' '+Trim(arg)));
    Data:='';
   end else
   {
   @ModScan32 demo
   }
   if (cmdid = cmd_ModScan32) then begin
    rNul(Eval('@system @async @run -hide '+AdaptExeFileName('modscan32.bat')+' '+Trim(arg)));
    Data:='';
   end else
   {
   @ModBusHelp
   }
   if (cmdid = cmd_ModBusHelp) then begin
    rNul(Eval('@system @async @run WebBrowser '+ForceExtension(ProgramSourcePas,'.htm')));
    rNul(Eval('@system @async @run -hide '+AdaptExeFileName('modbushelp.bat')+' '+Trim(arg)));
    Data:='';
   end else
   {
   @ModBusTesting
   }
   if (cmdid = cmd_ModBusTesting) then begin
    modbus_testing;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
  dat:='';
  raw:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
