﻿---

[[toc]]

---

# &FdbSrv - сервер сохранения данных в формате Firebird

---

**&FdbSrv** - сервер - для сохранения данных в формате **Firebird** (файлы __*.fdb__).
Он расположен в каталоге **[~~/resource/daqsite/fdbserver](./)**.
Кроме кода самого сервера **[fdbsrv.pas](fdbsrv.pas)**, там находится файл
стандартной конфигурации **[fdbsrv.cfg](fdbsrv.cfg)** и эта справка.

Сервер основан на библиотеке функций **[DbApi](../../manual/daqpascalapi.htm#db_connection)**
и библиотеке **[DbLibrary](../stdlib/include/_man_dblibrary.htm)**.

---

## Краткое описание сервера &FdbSrv

Стандартный сервер **&FdbSrv** служит для сохранения данных (кривых) в формате
**СУБД** **Firebird** - файлы __*.fdb__. Файлы располагаются локально, причем на
физическом жестком диске. Базы данных в сетевых каталогах не допускаются, т.к.
все **СУБД**, включая **Firebird**, работают только с локальными файлами **БД**.
При этом удаленный доступ к файлам **БД** для клиентов, разумеется, возможен.
Сохранение идет в суточных файлах (подобно серверу **DatSrv**),
Например, **demo_20221205.fdb** - файл с префиксом **demo_** от **2022.12.05**.

Сервер **Firebird** должен быть установлен локально (на этом компьютере), т.к.
подключение идет к **localhost**. Предполагается стандартная настройка сервера
**Firebird**, включая пользователя и пароль по умолчанию. При других настройках
 сервера **Firebird** надо указать в конфигурации соответствующие параметры
 (**Account_uid**, **Account_pwd**, **Account_mode**).

---

## Структура таблиц сервера &FdbSrv

Каждая кривая сохраняется в отдельной таблице:

| ID          | X_TIME    | Y_VALUE  |
|-------------|-----------|----------|
| Integer     | TimeStamp | Double   |
| Номер точки | Время     | Значение |

Нумерация точек поддерживается автоматически (автогенератор).
Время при записи имеет номинальную точность (квант) **1 ms**, хотя реально функция
времени **mSecNow** имеет квант **10** или **16** **ms** (зависит от системы).
В принципе тип **TimeStamp** в **Firebird** имеет точность до **0.1 ms**.
Но в текущей версии **&FdbSrv** десятые доли миллисекунд заполняется нулем.
Реальный квант времени задается параметром **`TimeQuantum`**, как описано ниже.

При обращении к таблицам кривых в **SQL** имена таблиц надо "кавычить".
Это связано в тем, что имена кривых содержат небуквенные символы.
Все имена кривых заданы в верхнем регистре (и это существенно).
Также рекомендуется сортировать данные по времени **`X_TIME`**.
Например: **`select * from "DEMO.CURVE" order by X_TIME`**.

Список кривых можно прочитать в специальной таблице **`[CRW-DAQ DATA FILE]`**:

| ID              | PAR_NAME      | PAR_VALUE  |
|-----------------|---------------|------------|
| Integer         | VarChar       | VarChar    |
| Номер параметра | Имя параметра | и Значение |

Нумерация параметров поддерживается автоматически (автогенератор).
Имена кривых содержатся в параметрах, у которых **PAR_NAME=CurveList**,
так что список кривых получается запросом:
```
select * from "[CRW-DAQ DATA FILE]" where PAR_NAME = 'CurveList'
```
В ответе на запрос имена кривых будут в полях **PAR_VALUE**.

---

## Подключение &FdbSrv к проекту DAQ

Для подключения **&FdbSrv** надо включить в конфигурацию файл **[fdbsrv.cfg](fdbsrv.cfg)**.
Лучше всего это сделать через стандартную заголовочную конфигурацию "по умолчанию"
**[~~/resource/daqsite/default/fdbsrv.cfg](../default/fdbsrv.cfg)**,
которая включаает нужные файлы и задает параметрам разумные значения по умолчанию:

```
[ConfigFileList] 
ConfigFile = ~~\resource\daqsite\default\fdbsrv.cfg
[]
```
Для большинства параметров (кроме указанных ниже) подойдут значения по умолчанию.

---

## Конфигурирование &FdbSrv в проекте

В проекте **DAQ** необходимо (пере)определить каталог данных **DataPath**,
префикс файла **FilePrefix**, периодичность сохранения **SavePeriod**
и другие параметры (большинство других можно не менять):

```
[&FdbSrv]
SavePeriod      = 300               ; Период сохранения, секунд
FilePrefix      = DEMO_             ; Префикс именования файлов
DataPath        = ..\..\demo_data   ; Каталог сохранения данных
[]
```
Необходимо также задать набор сохраняемых кривых в списке **CurveList**:

```
[&FdbSrv]
CurveList = Curve1, Curve2, ...
CurveList = [Section1], [Section3], ...
[]
```
Кривые в списке **[&FdbSrv] CurveList** задаются перечислением (через пробел
или запятую) имен кривых, либо имен секций, содержащих список имен кривых.
В списке **CurveList = ...** можно помещать имена кривых и секций,
разделенные пробелами и/или запятыми. Размер списка не ограничен.
При необходимости можно повторять выражение **CurveList = ...**
столько раз, сколько потребуется. Для читабельности лучше использовать
отдельное выражение **CurveList = Name** для каждой кривой или секции.
Также можно размещать список в разных файлах, если помещать его
в одноименные секции  **[&FdbSrv]**. Это придает конфигурации сервера
большую гибкость, позволяя размещать список кривых там, где удобно.

В конфигурации "по умолчанию" **[~~/resource/daqsite/default/fdbsrv.cfg](../default/fdbsrv.cfg)**
также определены теги **FDBSRV.GATE**, **FDBSRV.BUGS**, содержащие
флаг "*разрешить сохранять данные в файл*" и счетчик "*ошибок ввода-вывода*".
Эти теги можно использовать для включения/отключения записи данных в файл,
а также для анализа ошибок.

Для управления процессом сохранения данных можно задавать дополнительные
параметры: **`TimeQuantum`**, **`FastTransfer`**, **`TimeQuata`**,
**`AssertMode`**. Эти параметры имеют разумные значения по умолчанию
и меняются лишь при необходимости.

Параметр **`TimeQuantum`** задает квант времени сохранения данных (миллисекунд).
Если новые данные в кривой отличаются по времени от уже сохраненных менее чем на
этот квант, то их сохранение игнорируется. Это значит, что сохраненные данные
будут иметь шаг по времени не меньше заданного кванта. Промежутьчные данные
между квантами будут отброшены. С одной стороны, это может сократить объем
сохраняемых данных, с другой - понижает точность данных по времени.
Значение кванта по умолчанию (**1000** мс) рассчитано на задачи, не очень
требовательные к точности данных по времени, где точность в **1** секунду
является приемлемой. Если время надо сохранять более точно (с миллисекундами),
то надо соответственно уменьшить значение **`TimeQuantum`**. Это можно сделать
через параметр конфигурации или командой **`@TimeQuantum`**. Допустимый диапазон
значений кванта - от **1** (миллисекунда) до **60000** (минута).

Параметр **`FastTransfer`** задает флаг (**0/1**) разрешения режима быстрой
передачи данных через **recordset** процедуры (**AddNew,Update**). Этот режим
работает быстрее, чем посылка **SQL** запросов, т.к. данные передаются в
двоичном виде без преобразования в текст и обратно. Однако надо учитывать, что
при работе с движкком **ADO** в силу особенностей реализации этого движка
**recordset** округляет время **TimeStamp** до секунд (просто удаляет
миллисекунды), поэтому режим быстрой передачи допустимо использовать, если квант
времени **`TimeQuantum`** равен секунде или больше. При меньшем кванте времени
используется передача данных через **SQL** блок команд **insert** (c использованием
блочных операций **execute block as begin ... end**). Это снижает скорость
передачи (точнее, увеличивает накладные расходы на преобразование данных
в текст запроса и обратно), но позволяет избежать потери точности при передаче
меток времени **TimeStamp**. Менять режим быстрой передачи можно либо через
конфигурацию, либо командой **`@FastTransfer`**.
По умолчанию режим **`FastTransfer`** разрешен. Однако задействуется он только
в случае, если квант времени **`TimeQuantum`** равен секунде или более.  
Заметим, что в движках **SQLDB**, **ZEOS** проблемы с округлением времени не обнаружено.  
Поэтому в этих движках **`FastTransfer`** работает независимо от **`TimeQuantum`**.


Параметр **`TimeQuata`** задает квоту времени (миллисекунд) на операцию
передачи данных в одном прогоне (*RunCount*) программы. Если сервер не успел
передать все данные, он посылает самому себе в консоль команду **`@Awake`**,
чтобы продолжить передачу данных в следующем прогоне. Это сделано для того,
чтобы не срабатывал сторожевой таймер (**Watchdog**), который может посчитать
сервер зависшим, если он долго не отдает управление. Значение **`TimeQuata`**
по умолчанию (**2000** мс) является разумным и обычно нет смысла его менять.
Квота времени, кроме всего прочего, позволяет разумно "размазать" нагрузку
процессора по времени. Сохранение данных займет больше времени, но потребует
меньшей загрузки процессора в единицу времени. То есть сервер не будет мешать
прикладным программам управления решать свои задачи.

Параметр **`AssertMode`** управляет режимом вывода и обработки ошибок.
Это битовая маска **1+2+4**. Маска **1** задает режим генерации ошибок
(**Trouble**) вместо простой печати сообщений (**Problem**) при ошибках.
Маска **2** задает режим накопления счетчика ошибок, заданного в теге
**WriteErrorsTag** - по умолчанию это тег **FDBSRV.BUGS**. Маска **4**
задает режим подробной печати успешных операций (**Success**) вместо
скрытых сообщений (**Details**). Параметр режима можно менять через
конфигурацию или (в процессе отладки) командой **`@AssertMode`**.
Значение параметра по умолчанию (**3=1+2**) является разумным и
менять его обычно не требуется (разве что в процессе отладки).
Для подробной печати в процессе отладки также можно использовать
**`@DebugFlags 31`** для включения флагов вывода подробностей.

---

## Консольные команды &FdbSrv

Сервер **&FdbSrv** принимает (кроме стандартных команд) следующие команды:

- **`@Awake`** - команда пробуждения, т.е. досрочного сохранения данных.  
  Обычно данные сохраняются периодически, по таймеру **SavePeriod**.

- **`@AssertMode m`** - задание режима **m** обработки и отображения ошибок.
  Это битовая маска **1+2+4**:
  + **1** - генерировать ошибки (**Trouble**), а не просто сообщать (**Problem**);
  + **2** - использовать при ошибках счетчик ошибок, обычно в теге **FDBSRV.BUGS**;
  + **4** - многословный режим вывода (успешные операции тоже отображать через **Success**).
    Обычно для вывода используется **Details**.

- **`@FastTransfer m`** - задание режима **m** (0/1) для разрешения быстрой
  передачи данных, выполняемой с помощью **recordset** (*addnew/update*).
  Этот режим применяется для ускорения передачи данных (которые передаются в двоичном виде).
  Если флаг **FastTransfer=0**, применяется передача данных с помощью **SQL** запроса **insert**
  (в котором данные передаются в текстовом виде).
  Для передачи многих запросов **insert** одной командой применяется
  блок **`EXECUTE BLOCK AS BEGIN insert ..; insert ..; END`**.

- **`@TimeQuantum m`** - задание кванта времени данных **m**, миллисекунд.
  Сервер сохраняет очередную точку данных, только если её время отличается
  на квант или более. Таким образом, квант времени определяет период (шаг
  по времени в миллисекундах) для сохраняемых данных. В силу ограничений
  реализации **recordset** (она округляет время до секунд) режим
  **FastTransfer** не задействуется, если квант времени меньше секунды.
  Квант времени меняется в диапазоне (**1..60000**) миллисекунд.

---

Желаю успешного использования **FdbSrv**!

---

> **CRW-DAQ** Copyright(c) 2001-2024 Alexey Kuryakin <daqgroup@mail.ru>

---
