 {
 ***********************************************************************
 Daq Pascal application program _DimCrvIo.
 Program to transmit/receive curves thru DIM.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
|********************************************************
[]
 Configuration DEMO:
 ;******************************************************************************
 ; Следующий фрагмент обеспечивает прием двух кривых (sin_wave1,sin_wave2)
 ; по сети через DIM при помощи стандартной программы _dimcrvio.
 ; На стороне клиента работает зеркальная ко отношению к серверу конфигурация.
 ; После приема данных в теги посылается сообщение для уведомления, что надо
 ; записать принятые данные в кривые.
 ;******************************************************************************
 [&DimSrv.ServiceList]
 SIN_WAVES_RX= dic_info SIN/WAVES
 [SIN_WAVES_RX]
 tag sin_wave1.x, sin_wave1.y ; Пара тегов c.x,c.y на каждую кривую c
 tag sin_wave2.x, sin_wave2.y ; Пара тегов c.x,c.y на каждую кривую c
 devmsg &SIN_WAVES_RX #SIN_WAVES_RX
 []
 [DeviceList]
 &SIN_WAVES_RX = device software program
 [&SIN_WAVES_RX]
 Comment        = Передача кривых по Ethernet
 InquiryPeriod  = 1
 DevicePolling  = 10, tpTimeCritical
 ProgramSource  = ~~\resource\daqsite\dimserver\_dimcrvio.pas
 msgTxUpdate    = #SIN_WAVES_TX  ; сообщение форсирует передачу
 msgRxUpdate    = #SIN_WAVES_RX  ; сообщение форсирует прием
 tagTxEnable    = SIN_TxEnable   ; разрешает передачу
 tagRxEnable    = SIN_RxEnable   ; разрешает прием
 tagTxErrors    = SIN_IoErrors   ; счетчик ошибок передачи
 tagRxErrors    = SIN_IoErrors   ; счетчик ошибок приема
 StdInFifo      = 32             ; Размер FIFO StdIn, kB
 DebugFlags     = 3
 OpenConsole    = 2
 AnalogOutputs  = 2
 Link AnalogOutput 0 with curve sin_wave1 history 1000
 Link AnalogOutput 1 with curve sin_wave2 history 1000
 []
 ;******************************************************************************
 ; Следующий фрагмент обеспечивает передачу двух кривых (sin_wave1,sin_wave2)
 ; по сети через DIM при помощи стандартной программы _dimcrvio.
 ; На стороне клиента работает та же самая программа с зеркальной конфигурацией.
 ; Передача кривых осуществляется автоматически после добавления новых точек.
 ;******************************************************************************
 [&DimSrv.ServiceList]
 SIN_WAVES_TX = dis_info SIN/WAVES
 [SIN_WAVES_TX]
 tag sin_wave1.x, sin_wave1.y ; Пара тегов c.x,c.y на каждую кривую c
 tag sin_wave2.x, sin_wave2.y ; Пара тегов c.x,c.y на каждую кривую c
 []
 [DeviceList]
 &SIN_WAVES_TX = device software program
 [&SIN_WAVES_TX]
 Comment        = Передача кривых по Ethernet
 InquiryPeriod  = 1
 DevicePolling  = 10, tpTimeCritical
 ProgramSource  = ~~\resource\daqsite\dimserver\_dimcrvio.pas
 msgTxUpdate    = #SIN_WAVES_TX  ; сообщение форсирует передачу
 msgRxUpdate    = #SIN_WAVES_RX  ; сообщение форсирует прием
 tagTxEnable    = SIN_TxEnable   ; разрешает передачу
 tagRxEnable    = SIN_RxEnable   ; разрешает прием
 tagTxErrors    = SIN_IoErrors   ; счетчик ошибок передачи
 tagRxErrors    = SIN_IoErrors   ; счетчик ошибок приема
 StdInFifo      = 32             ; Размер FIFO StdIn, kB
 DebugFlags     = 3
 OpenConsole    = 2
 AnalogInputs   = 2
 Link AnalogInput 0 with curve sin_wave1
 Link AnalogInput 1 with curve sin_wave2
 []
 }
program _dimcrvio;               { DIM curve I/O                    }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 MaxChan     = 100;              { Max. number of I/O channels      }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 Tx,Rx       : record            { Transmitter & receiver data      }
  tagX       : array[0..MaxChan] of Integer;{ Last curve X          }
  tagY       : array[0..MaxChan] of Integer;{ Last curve Y          }
  LastX      : array[0..MaxChan] of Real;   { Last curve X          }
  tagEnable  : Integer;          { Enable transmitter or receiver   }
  tagErrors  : Integer;          { Error counter                    }
  Cnt        : Integer;          { Number of messages/curve changes }
  Msg        : String;           { Message to transmit or receive   }
  Tmp        : String;           { Temporary data string            }
 end;
 TimeOfStart : Real;             { Global DAQ start time            }
 TimeDelta   : Real;             { Current Tx-Rx time delta,[ms]    }
 x,y         : Real;             { Temporary                        }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Fix Tx error
 }
 procedure TxError(msg:String);
 var b:boolean;
 begin
  b:=rSetTag(Tx.tagErrors,rGetTag(Tx.tagErrors)+1);
  Trouble(msg);
 end;
 {
 Fix Rx error
 }
 procedure RxError(msg:String);
 var b:boolean;
 begin
  b:=rSetTag(Rx.tagErrors,rGetTag(Rx.tagErrors)+1);
  Trouble(msg);
 end;
 {
 Find global time of start.
 }
 function GetTimeOfStart:Real;
 var x,y:Real; i:Integer;
 begin
  i:=0;
  x:=int(msecnow-time*timeunits);
  y:=int(msecnow-time*timeunits);
  while (x<>y) and (i<10) do begin
   x:=y;
   y:=int(msecnow-time*timeunits);
   i:=i+1;
  end;
  GetTimeOfStart:=x;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  Tx.Msg:=''; Tx.Tmp:='';
  Rx.Msg:=''; Rx.Tmp:='';
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 var i:Integer;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,MaxInt,0);
  {
  Read parameters from config file.
  }
  Tx.Msg:=readini('msgTxUpdate');
  if Length(Tx.Msg)=0 then Trouble('Invalid msgTxUpdate');
  Rx.Msg:=readini('msgRxUpdate');
  if Length(Rx.Msg)=0 then Trouble('Invalid msgRxUpdate');
  InitTag(Tx.tagEnable,readini('tagTxEnable'),1);
  InitTag(Rx.tagEnable,readini('tagRxEnable'),1);
  InitTag(Tx.tagErrors,readini('tagTxErrors'),2);
  InitTag(Rx.tagErrors,readini('tagRxErrors'),2);
  for i:=0 to numais-1 do begin
   if refai(i)<>0 then begin
    InitTag(Tx.tagX[i],RefInfo(refai(i),'Name')+'.X',2);
    InitTag(Tx.tagY[i],RefInfo(refai(i),'Name')+'.Y',2);
    bNul(rSetTag(Tx.tagX[i],0));
    bNul(rSetTag(Tx.tagY[i],0));
   end else begin
    Tx.tagX[i]:=0;
    Tx.tagY[i]:=0;
   end;
   Tx.LastX[i]:=0;
  end;
  bNul(rSetTag(Tx.tagErrors,0));
  for i:=0 to numaos-1 do begin
   if refao(i)<>0 then begin
    InitTag(Rx.tagX[i],RefInfo(refao(i),'Name')+'.X',2);
    InitTag(Rx.tagY[i],RefInfo(refao(i),'Name')+'.Y',2);
    bNul(rSetTag(Rx.tagX[i],0));
    bNul(rSetTag(Rx.tagY[i],0));
   end else begin
    Rx.tagX[i]:=0;
    Rx.tagY[i]:=0;
   end;
   Rx.LastX[i]:=0;
  end;
  bNul(rSetTag(Rx.tagErrors,0));
  TimeOfStart:=GetTimeOfStart;
  Tx.Cnt:=0;
  Rx.Cnt:=0;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 var i:Integer;
 begin
  {
  If transmitter enabled, transmit data to DIM server via devPost.
  Data will be transmitted only if enabled and msgTxUpdate received or X[i] changed.
  Time data X should be converted to global milliseconds.
  }
  if iGetTag(Tx.tagEnable)>0 then begin
   for i:=0 to numais-1 do
   if refai(i)<>0 then begin
    x:=getai_xn(i);
    x:=int(TimeOfStart+x*timeunits);
    if x<>Tx.LastX[i] then begin
     y:=getai_yn(i);
     bNul(rSetTag(Tx.tagX[i],x));
     bNul(rSetTag(Tx.tagY[i],y));
     Tx.Cnt:=Tx.Cnt+1;
     Tx.LastX[i]:=x;
    end;
   end;
   if Tx.Cnt>0 then begin
    Tx.Tmp:='##'+str(Tx.tagX[0])+EOL;
    if (devPost(devDimSrv,Tx.Tmp)=0)
    then TxError('Failed devPost to '+refinfo(devDimSrv,'Name'))
    else if DebugFlagEnabled(dfViewExp) then ViewExp(Tx.Tmp);
   end;
  end;
  {
  Receive data if enabled and msgRxUpdate message received from DIM server.
  }
  if iGetTag(Rx.tagEnable)>0 then begin
   if Rx.Cnt>0 then
   for i:=0 to numaos-1 do
   if refao(i)<>0 then begin
    x:=rGetTag(Rx.tagX[i]);
    if x<>Rx.LastX[i] then begin
     y:=rGetTag(Rx.tagY[i]);
     UpdateAo(i,time,y);
     UpdateDo(i,time,msecnow-x);
     Rx.LastX[i]:=x;
    end;
   end;
  end;
  {
  Handle sensor click
  }
  if clickbutton=1 then begin
   {
   Transmitter enable button
   }
   if clicktag=Tx.tagEnable then begin
    bNul(iSetTag(clicktag,ord(iGetTag(clicktag)=0)));
    bNul(voice(snd_Click));
   end;
   {
   Receiver enable button
   }
   if clicktag=Rx.tagEnable then begin
    bNul(iSetTag(clicktag,ord(iGetTag(clicktag)=0)));
    bNul(voice(snd_Click));
   end;
   {
   Clear I/O error counter
   }
   if (clicktag=Tx.tagErrors)
   or (clicktag=Rx.tagErrors) then begin
    bNul(rSetTag(clicktag,0));
    bNul(voice(snd_Click));
   end;
  end;
  Tx.Cnt:=0;
  Rx.Cnt:=0;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; i:Integer; r:Real;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Tx.Cnt/Rx.Cnt should be >0 if if msgTxUpdate/msgRxUpdate received.
  }
  if IsSameText(Data,Rx.Msg) then Rx.Cnt:=Rx.Cnt+1;
  if IsSameText(Data,Tx.Msg) then Tx.Cnt:=Tx.Cnt+1;
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
