
---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Стандартные (default) DAQ конфигурации

**[Здесь](./)** находятся файлы стандартных (**default**) конфигураций для часто
используемых настроек **DAQ**-системы и конфигурации стандартных **DAQ**-серверов,
а также коды для их включения в пользовательские **DAQ**-конфигурации прикладных
разработчиков и пользователей пакета **crwdaq**.

Конфигурацию **DAQ**-системы проще всего строить на основе готовых (стандартных)
конфигурационных файлов с настройками "по умолчанию", которые (при необходимости)
уточняются (переопределяются) в файле конфигурации.

Имейте в виду, что **порядок включения файлов имеет значение**.
При чтении параметров значение параметра берется из **первого** встретившегося выражения,
подходящего под **шаблон** поиска (поиск ведется по имени файла, секции и параметра).
При этом текст **текущего** файла конфигурации оказывается **впереди** (в приоритете)
по отношению к включаемым в него файлам, поскольку тексты секций включаемых файлов
добавляется **в конец** текста конфигурации **в порядке включения** файлов в секции **[ConfigFileList]**.
Поэтому есть возможность **переопределять** параметры, заданные по умолчанию, если это необходимо.
Для этого секция и параметр с его значением включается в текущий файл конфигурации, а значения
по умолчанию - во включаемый файл.
Наличие включаемой стандартной конфигурации позволяет избежать громоздких описаний
в пользовательских конфигурациях, т.к. для большей части параметров задаются значения по умолчанию.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Настройки DAQ по умолчанию

---

### Часто используемые DAQ настройки

Коды для включения в прикладную конфигурацию:

``` ini
[ConfigFileList] ; Default DAQ settings
ConfigFile = ~~\resource\daqsite\default\daq.cfg
ConfigFile = ~~\resource\daqsite\default\integrity.cfg
ConfigFile = ~~\resource\daqsite\default\dimdnslocal.cfg
ConfigFile = ~~\resource\daqsite\default\dimaccesslocal.cfg
ConfigFile = ~~\resource\daqsite\default\dimaccesstoall.cfg
[]
```

- Файл **[daq.cfg](daq.cfg)** содержит значения по умолчанию для секции **[DAQ]**
  с описанием основных параметров **DAQ**-системы.  
- Файл **[integrity.cfg](integrity.cfg)** содержит стандартные настройки для системы контроля целостности (**integrity**),  
  которая отвечает за проверку целостности файлов, ведение журналов, вывод предупреждающих сообщений и т.д.
- Файл **[dimdnslocal.cfg](dimdnslocal.cfg)** служит для указания **[значения](../dimserver/dimdnslocal.cfg)** по умолчанию
  для сервера имен **DIM DNS**.  
  По умолчанию это точка, что означает **localhost**.  
- Файл **[dimaccesslocal.cfg](dimaccesslocal.cfg)** служит для указания **[значения](../dimserver/dimaccesslocal.cfg)** по умолчанию
  для таблицы прав доступа **DIM** сервера для локального компьютера.  
  По умолчанию таблица дает полный доступ для **localhost**.  
- Файл **[dimaccesstoall.cfg](dimaccesstoall.cfg)** служит для указания **[значения](../dimserver/dimaccesstoall.cfg)** по умолчанию
  для таблицы прав доступа **DIM** сервера для удаленных компьютеров.  
  По умолчанию таблица дает полный доступ для всех компьютеров и пользователей.  
  Если полный доступ не нужен, файл нужно отключить (закомментировать).  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Реже используемые DAQ настройки

Коды для включения в прикладную конфигурацию:

``` ini
[ConfigFileList] ; Default DAQ settings
ConfigFile = ~~\resource\daqsite\default\hidelogo.cfg
ConfigFile = ~~\resource\daqsite\default\integrityoff.cfg
[]
```

- Файл **[hidelogo.cfg](hidelogo.cfg)** отключает окно - заставку, которое появляется при загрузке **DAQ**-системы.  
- Файл **[integrityoff.cfg](integrityoff.cfg)** отключает систему контроля целостности **integrity**.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Настройки Painter для мнемосхем

Коды для включения в прикладную мнемосхему:

``` ini
[ConfigFileList] ; Include the Painter GUI Library
ConfigFile = ~~\resource\daqsite\default\painter.crc
[]
```

Интерпретатор **[Painter](../painter/painter.htm)** - основной инструмент для рисования мнемосхем.
Для его использования в файл описания мнемосхемы **`*.crc`** надо включить
библиотечный **[файл](painter.crc)** **[painter.crc](../painter/painter.crc)**.
В его состав входит большой набор констант (цветов, режимов работы), а также библиотеку
процедур для рисования визуальных элементов (кнопок, графических элементов и т.д.).

Если сценарии **Painter** в окне мнемосхем используют (дополнительные) переменные, их надо
определить в секции **[Circuit.StartupScript]**, например:

``` ini
[Circuit.StartupScript] ; Default startup script section
amplitude=1.23
frequency=3.14
[]
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Серверы общего назначения

В пакете **crwdaq** значительную часть работы систем управления выполняют серверы, т.е.
устройства **DAQ**-системы, выполняющие четко определенную задачу в отдельном программном
потоке или процессе.
Серверы общего назначения отличаются тем, что могут работать в составе самых разных прикладных
систем, выполняя общие, наиболее часто используемые функции.
Большая часть серверов общего назначения требует минимальных усилий для конфигурации, если
использовать готовые конфигурации по умолчанию.
Следует лишь правильно включить их и (возможно) переопределить отдельные параметры.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Часто используемые серверы: CronSrv, DatSrv, DimSrv, SpeakSrv

Коды для включения в прикладную конфигурацию:

``` ini
[ConfigFileList] ; General Purpose Servers
ConfigFile = ~~\resource\daqsite\default\cronsrv.cfg
ConfigFile = ~~\resource\daqsite\default\datsrv.cfg
ConfigFile = ~~\resource\daqsite\default\dimsrv.cfg
ConfigFile = ~~\resource\daqsite\default\speaksrv.cfg
[]
```

- Файл **[cronsrv.cfg](cronsrv.cfg)** включает стандартную конфигурацию сервера **[CronSrv](../cronserver/cronsrv.cfg)**.  
  Сервер **[CronSrv](../cronserver/cronsrv.htm)** служит для организации различных **действий по расписанию**.  
- Файл **[datsrv.cfg](datsrv.cfg)** включает стандартную конфигурацию сервера **[DatSrv](../datserver/datsrv.cfg)**.  
  Сервер **[DatSrv](../datserver/datsrv.htm)** служит для сохранения измеряемых данных в файлах формата **.dat**.  
- Файл **[dimsrv.cfg](dimsrv.cfg)** включает стандартную конфигурацию сервера **[DimSrv](../dimserver/dimsrv.cfg)**.  
  Сервер **[DimSrv](../dimserver/dimsrv.htm)** служит для создания распределенных систем управления и связи по сетевому протоколу **DIM**.  
- Файл **[speaksrv.cfg](speaksrv.cfg)** включает стандартную конфигурацию сервера **[SpeakSrv](../speakserver/speaksrv.cfg)**.  
  Сервер **[SpeakSrv](../speakserver/speaksrv.htm)** служит для генерации речевых сообщений (от **speak** - говорить).  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Реже используемые серверы: PlotSrv, WebSrv

Коды для включения в прикладную конфигурацию:

``` ini
[ConfigFileList] ; Addon Standard Servers
ConfigFile = ~~\resource\daqsite\default\plotsrv.cfg
ConfigFile = ~~\resource\daqsite\default\websrv.cfg
[]
```

- Файл **[plotsrv.cfg](plotsrv.cfg)** включает стандартную конфигурацию сервера **[PlotSrv](../plotserver/plotsrv.cfg)**.  
  Сервер **[PlotSrv](../plotserver/plotsrv.htm)** служит для рисования графиков с помощью пакета **GnuPlot**.  
  Графики рисуются в файлах, позволяя использовать их для мнемосхем или для **Web** сервера.  
- Файл **[websrv.cfg](websrv.cfg)** включает стандартную конфигурацию сервера **[WebSrv](../webserver/websrv.cfg)**.  
  Сервер **[WebSrv](../webserver/websrv.htm)** служит для организации удаленного доступа с помощью **Web** сервера.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Протокольные серверы: ModbusProxy, ModbusSrv, OpcuaMon, OpcuaSrv, PfeifferProxy, SmiProxy, SmiSrv

Коды для включения в прикладную конфигурацию:

``` ini
[ConfigFileList] ; Addon Standard Servers
ConfigFile = ~~\resource\daqsite\default\modbusproxy.cfg
ConfigFile = ~~\resource\daqsite\default\modbussrv.cfg
ConfigFile = ~~\resource\daqsite\default\opcuamon.cfg
ConfigFile = ~~\resource\daqsite\default\opcuamon1.cfg
ConfigFile = ~~\resource\daqsite\default\opcuamon2.cfg
ConfigFile = ~~\resource\daqsite\default\opcuamon3.cfg
ConfigFile = ~~\resource\daqsite\default\opcuasrv.cfg
ConfigFile = ~~\resource\daqsite\default\pfeifferproxy.cfg
ConfigFile = ~~\resource\daqsite\default\smiproxy.cfg
ConfigFile = ~~\resource\daqsite\default\smisrv.cfg
[]
```

- Файл **[modbusproxy.cfg](modbusproxy.cfg)** включает стандартную конфигурацию сервера **[ModbusProxy](../modbusserver/modbusproxy.cfg)**.  
  Сервер **[ModbusProxy](../modbusserver/modbusproxy.htm)** служит прокси-сервером для протокола **Modbus**.  
  Он используется для организации работы драйверов устройств с протоколом **Modbus**.  
- Файл **[modbussrv.cfg](modbussrv.cfg)** включает стандартную конфигурацию сервера **[ModbusSrv](../modbusserver/modbussrv.cfg)**.  
  Сервер **[ModbusSrv](../modbusserver/modbussrv.htm)** служит для организации удаленного доступа к данным с помощью **Modbus** сервера.  
- Файл **[opcuamon.cfg](opcuamon.cfg)** включает стандартную конфигурацию сервера **[OpcuaMon](../opcuaserver/opcuamon.cfg)**.  
  Сервер **[OpcuaMon](../opcuaserver/opcuamon.htm)** служит для удаленного доступа к данным с помощью **OPCUA** клиента (**монитора**).  
  Поскольку мониторов может несколько, серверы **OpcuaMon1**, **OpcuaMon2**, **OpcuaMon3** служат   
  для включения дополнительных мониторов.  
- Файл **[opcuasrv.cfg](opcuasrv.cfg)** включает стандартную конфигурацию сервера **[OpcuaSrv](../opcuaserver/opcuasrv.cfg)**.  
  Сервер **[OpcuaSrv](../opcuaserver/opcuasrv.htm)** служит для публикации данных с помощью **OPCUA** сервера.  
- Файл **[pfeifferproxy.cfg](pfeifferproxy.cfg)** включает стандартную конфигурацию сервера **[PfeifferProxy](../pfeifferproxy/pfeifferproxy.cfg)**.  
  Сервер **[PfeifferProxy](../pfeifferproxy/pfeifferproxy.htm)** служит прокси-сервером для протокола **Pfeiffer**.  
  Он используется для организации работы драйверов устройств с протоколом **Pfeiffer**.  
- Файл **[smiproxy.cfg](smiproxy.cfg)** включает стандартную конфигурацию для серверов **[SmiProxy](../smiserver/smiproxy.cfg)**.  
  Серверы служат для организации работы прокси-объектов для конечных автоматов с протоколом **SMI**.  
  Файл конфигурации содержит пути поиска и другие данные, нужные для работы прокси-объектов **SMI**.  
- Файл **[smisrv.cfg](smisrv.cfg)** включает стандартную конфигурацию для серверов **[SmiSrv](../smiserver/smisrv.cfg)**.  
  Сервер **[SmiSrv](../smiserver/smisrv.htm)** служит для организации работы распределенной системы  
  конечных автоматов с протоколом **SMI**.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Редко используемые серверы: EmlSrv, FdbSrv, VkbdSrv

Коды для включения в прикладную конфигурацию:

``` ini
[ConfigFileList] ; Addon Standard Servers
ConfigFile = ~~\resource\daqsite\default\emlsrv.cfg
ConfigFile = ~~\resource\daqsite\default\fdbsrv.cfg
ConfigFile = ~~\resource\daqsite\default\vkbdsrv.cfg
[]
```
- Файл **[emlsrv.cfg](emlsrv.cfg)** включает стандартную конфигурацию сервера **[EmlSrv](../emailserver/emlsrv.cfg)**.  
  Сервер **[EmlSrv](../emailserver/emlsrv.htm)** служит для организации автоматическойй рассылки электронной почты **email**.  
- Файл **[fdbsrv.cfg](fdbsrv.cfg)** включает стандартную конфигурацию сервера **[FdbSrv](../fdbserver/fdbsrv.cfg)**.  
  Сервер **[FdbSrv](../fdbserver/fdbsrv.htm)** служит для сохраниения измеряемых данных в файлах формата **.fdb** баз данных **Firebird**.  
- Файл **[vkbdsrv.cfg](vkbdsrv.cfg)** включает стандартную конфигурацию сервера **[VkbdSrv](../vkbdserver/vkbdsrv.cfg)**.  
  Сервер **[VkbdSrv](../vkbdserver/vkbdsrv.htm)** служит для ввода параметров в режиме сенсорной клавиатуры.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

### Часто используемые настройки некоторых серверов

Коды для включения в прикладную конфигурацию:

``` ini
[&SpeakSrv]
Engine = Adult Female #1 Russian (L&H)
[]

[&DimSrv]
DIM_DNS_NODE = localhost
[]
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

 <img height=16 width=16 src="data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAABGdBTUEAALGPC/xhBQAAAAlwSFlzAAAOwwAADsMBx2+oZAAAAQhJREFUSEvtljEOgzAUQ3MvbsUJOA9XYMmJ2qFbp5q+YH2VINQSlgorjRz//+3QKSkvePT9reuaLFkV05xLwEdHk4XzHGBJyc9xPLjiPzEH+KzavRFkhafMk1kpNoLvXQIaXh/4I66ALVwBu9gMmKZpGIaUknZxRHHDIj1wQ4p0kXqAhlWOwK4cFlj8OoAy84RhYVIVhUiki9QD4kxE1NcBpHKtQwGyiF5u1g7gPwYYuAtvzzkVkR1R1XqAarZghm4IVZTYINja4/UAZiLoFtGwCBZwH+lh1qV6gKA+uzAprE3hNMOFOLIZ0ApXwC7+L+DEZ4tZw4/w9WV+/tNRv5jRcOF88vM95xfHjbs66Lo86gAAAABJRU5ErkJggg=="/>
 CRW-DAQ Copyright (c) 2001-2025 Alexey Kuryakin <daqgroup@mail.ru>.

---
