﻿---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# &DatSrv - сервер сохранения данных в формате DAT

Сервер **[&DatSrv](datsrv.pas)** служит для сохранения данных (кривых) в файлах **`*.dat`**.  
Его обслуживает программа **[datsrv.pas](datsrv.pas)**.
Старое имя этой программы **[_datsave.pas](../stdlib/daqpas/_datsave.pas)**.


<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Подключение &DatSrv к прикладной DAQ-конфигурации

Для подключения **&DatSrv** надо:

1. Включить в **DAQ**-конфигурацию стандартный заголовочный файл **[default/datsrv.cfg](../default/datsrv.cfg)**:

``` ini
[ConfigFileList] 
ConfigFile = ~~\resource\daqsite\default\datsrv.cfg
[]
```

   либо (в особых случаях) напрямую конфигурационный файл **[datsrv.cfg](datsrv.cfg)**:

``` ini
[ConfigFileList] 
ConfigFile = ~~\resource\daqsite\datserver\datsrv.cfg
[]
```

2. (Пере)определить каталог данных **DataPath**, префикс файла **FilePrefix**,
   периодичность сохранения **SavePeriod** и другие параметры:

``` ini
[&DatSrv]
IntegrityMode   = 2                 ; 0:off, 1:@integrity -a, 2:@run TextMetaData -a
SavePeriod      = 300               ; Data save period, seconds
FilePrefix      = DEMO_             ; File prefix
DataPath        = ..\..\DEMO_DATA   ; Data path
[]
```

3. Задать список сохраняемых кривых **[&DatSrv] CurveList**:

``` ini
[&DatSrv]
CurveList = Curve1, Curve2, ...
CurveList = [Section1], [Section3], ...
[]
```

   Кривые в списке **[&DatSrv] CurveList** задаются списком по именам кривых, либо по именам секций, содержащих список кривых.  
   Размер списка не ограничен.

4. В конфигурации определены теги **DATSRV.GATE**, **DATSRV.BUGS**,
  содержащие флаг "разрешить сохранять данные в файл" и счетчик ошибок.
  Эти теги можно использовать для включения/отключения записи данных в файл,
  а также для анализа ошибок.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

Желаем успешного использования **&DatSrv**.

---

> **CRW-DAQ** *Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru*

---
