@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem ****************************
rem UART Configuration generator
rem ****************************
::: PipeLine configure template:
::: PipeLine = Com Port 1 Baudrate 9600 Parity NONE DataBits 8 StopBits 1  ; COM port
::: PipeLine = Pipe DEMO Polling 4 Priority tpHighest                      ; Pipe DEMO (server)
::: PipeLine = Pipe .\DEMO Polling 4 Priority tpHighest                    ; Pipe DEMO (client)
::: PipeLine = Tcp Port 1234 Server 1 Polling 4 Priority tpHighest         ; Socket TCP:1234 (server)
::: PipeLine = Tcp Port 1234 Client localhost Polling 4 Priority tpHighest ; Socket TCP:1234 (client)
rem ****************************

:Main
call :InitializeVariables
pushd "%~dp0" && call :ComPort
popd
goto :EOF

:InitializeVariables
set uart_cfg=%~n0.cfg
goto :EOF

:ComPort
call :DeleteFiles %uart_cfg%
call :AddHeader %* > %uart_cfg%
rem              Port  BdRate Parity DataBits StopBits PipeLine
call :AddComPort COM1  115200 NONE   8        1        "Com Port 1 Baudrate 115200 Parity NONE DataBits 8 StopBits 1"
call :AddComPort COM2  115200 NONE   8        1        "Com Port 2 Baudrate 115200 Parity NONE DataBits 8 StopBits 1"
call :AddComPort COM3  115200 NONE   8        1        "Com Port 3 Baudrate 115200 Parity NONE DataBits 8 StopBits 1"
call :AddComPort COM4  115200 NONE   8        1        
call :AddComPort COM5  115200 NONE   8        1        
call :AddComPort COM6  115200 NONE   8        1        
call :AddComPort COM7  115200 NONE   8        1        
call :AddComPort COM8  115200 NONE   8        1        
call :AddComPort COM9  115200 NONE   8        1        
call :AddComPort COM10 115200 NONE   8        1        
call :AddComPort COM11 115200 NONE   8        1        
call :AddComPort COM12 115200 NONE   8        1        
call :AddComPort COM13 115200 NONE   8        1        
call :AddComPort COM14 115200 NONE   8        1        
call :AddComPort COM15 115200 NONE   8        1        
call :AddComPort COM16 115200 NONE   8        1        
call :AddComPort COM17 115200 NONE   8        1        
call :AddComPort COM18 115200 NONE   8        1        
call :AddComPort COM19 115200 NONE   8        1        
call :AddComPort COM20 115200 NONE   8        1        
call :AddComPort COM21 115200 NONE   8        1        
call :AddComPort COM22 115200 NONE   8        1        
call :AddComPort COM23 115200 NONE   8        1        
call :AddComPort COM24 115200 NONE   8        1        
call :AddComPort COM25 115200 NONE   8        1        
call :AddComPort COM26 115200 NONE   8        1        
call :AddComPort COM27 115200 NONE   8        1        
call :AddComPort COM28 115200 NONE   8        1        
call :AddComPort COM29 115200 NONE   8        1        
call :AddComPort COM30 115200 NONE   8        1        
call :AddComPort COM31 115200 NONE   8        1        
call :AddComPort COM32 115200 NONE   8        1        
goto :EOF

:AddHeader
echo ;**************
echo ; UART Settings
echo ;**************
goto :EOF

:AddComPort
call :AddPort %* >> %uart_cfg%
goto :EOF

:AddPort
set Port=%~1&shift
set BaudRate=%~1&shift
set Parity=%~1&shift
set DataBits=%~1&shift
set StopBits=%~1&shift
set PipeLine=%~1&shift
echo [SerialPort-%Port%]
if "%PipeLine%" NEQ "" echo PipeLine = %PipeLine%
echo Port     = %Port%
echo BaudRate = %BaudRate%
echo Parity   = %Parity%
echo DataBits = %DataBits%
echo StopBits = %StopBits%
echo []
echo.
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
