@echo off
SetLocal EnableExtensions EnableDelayedExpansion

echo.
echo ***************************************************
echo CRW-DAQ script to edit DaqPascal program code text.
echo The script expected location is Crw32exe\Resource\.
echo Param[1] - program source file name (full path).
echo Param[2] - DAQ program device name.
echo ***************************************************
echo.

if not defined CRW_DAQ_SYS_HOME_DIR ( echo The script should be called from CRW-DAQ system only. & goto :EOF )

:AcceptParameters
set "SourceFileName=%~1"
set "DeviceName=%~2"

:Main
call :SearchEditor
call :StartEditor
call :ShowTooltip
goto :EOF

:SearchEditor
set "editor=%ProgramFiles%\Total Commander XP\AddOn\Alex\Notepad++\notepad++.exe"
if not exist "%editor%" set "editor=%ProgramFiles%\UnixUtils\add\npp\notepad++.exe"
if not exist "%editor%" set "editor=%UnixRoot%\add\npp\notepad++.exe"
if not exist "%editor%" set "editor=notepad.exe"
goto :EOF

:StartEditor
if defined editor if exist "%editor%" call :WriteEditorConfig "%editor%"
if defined editor if exist "%editor%" start "Editor" "%editor%" "%SourceFileName%"
goto :EOF

:WriteEditorConfig
if "%~1" == "" goto :EOF
if not defined DeviceName goto :EOF
if not defined SourceFileName goto :EOF
if not defined CRW_DAQ_SYS_EXE_PID goto :EOF
if not exist "%~dp1\plugins\Config\" goto :EOF
unix printc "SET CRW_PID = %CRW_DAQ_SYS_EXE_PID%" -n "SET CRW_DEVICE = %DeviceName%" -n "SET CRW_FILE = %SourceFileName%" -n > "%~dp1\plugins\Config\npes_env.txt"
goto :EOF

:DetectRussian
set /a russian=0
if /i "%CRW_DAQ_SYS_LANG:~0,7%" == "RUSSIAN" set /a russian=1
goto :EOF

:ShowTooltip
call :DetectRussian
set "msgFile=Edit file"
set "msgDevice=DAQ-device"
if "%russian%" == "1" chcp 1251
if "%russian%" == "1" set "msgFile=Открыт файл"
if "%russian%" == "1" set "msgDevice=DAQ-устройство"
unix fpquitip guid DaqPasEditor preset stdNotify text "%msgFile%: %SourceFileName%, %msgDevice%: &%DeviceName%." delay 15000 fontSize 12
goto :EOF