@echo off
SetLocal EnableExtensions EnableDelayedExpansion

call :DetectLanguage
chcp 65001
goto :Start

:About
echo.
echo #####################################################
echo CRW-DAQ tool to clone ^(make from sample^) a project.
echo Param[1]  - sample project ^(*.lpr^) to copy from.   
echo Param[2]  - target directory for projects.           
echo Param[3]  - target project rename ^(optional^).      
echo #####################################################
echo.
goto :EOF

:Start

call :About

:ScriptIdentification
set "scriptfile=%~f0"
set "scriptbase=%~n0"
set "scriptname=%~nx0"
for %%i in ( "%~dp0\." ) do set "scripthome=%%~fi"


:CheckArgumentsExists
if "%~1" == "" goto :MissedArguments
if "%~2" == "" goto :MissedArguments

:ParseProjectArguments
set "projectTYPE=%~x1"
set "projectTYPE=%projectTYPE:.=%"
set "projectNAME=%~n1"
set "projectSAMPLE=%~f1"
if not exist "%projectSAMPLE%" goto :SampleNotFound
set "targetHOMEDIR=%~f2"
if not exist "%targetHOMEDIR%\" goto :TargetDirNotFound
set "projectRENAME=%~n1"
if not "%~3" == "" set "projectRENAME=%~3"
set "projectTARGET=%targetHOMEDIR%\%projectRENAME%\%projectRENAME%.%projectTYPE%"

:CheckTargetDirIsNotSource
for %%i in ( "%projectSAMPLE%" ) do set "sourceDir=%%~dpi"
for %%j in ( "%projectTARGET%" ) do set "targetDir=%%~dpi"
if /i "%projectSAMPLE%" == "%projectTARGET%" goto :ErrorTargetDirIsSource

:ReportProjectArguments
echo Sample: %projectSAMPLE%
echo Locate: %targetHOMEDIR%
echo P.Type: %projectTYPE%
echo P.Name: %projectNAME%
echo Rename: %projectRENAME%
echo Target: %projectTARGET%
echo LangID: %LangID%

:SelectProjectType
if /i "%projectTYPE%" == "lpr" goto :MakeProjectLpr

goto :BadProjectType
exit /b 1
goto :EOF



:MakeProjectLpr
call :IsRelevantDanProjectLpr || goto :ErrorNotRelevantDanProjectLpr
for %%i in ( "%projectSAMPLE%" ) do set "sdir=%%~dpi"
for %%i in ( "%projectTARGET%" ) do set "tdir=%%~dpi"
for %%i in ( "%sdir%\." ) do set "sdir=%%~fi"
for %%i in ( "%tdir%\." ) do set "tdir=%%~fi"
if not exist "%tdir%\" goto :MakeTargetDir
set "title=Confirmation required …"
if /i "%LangID%" == "ru" set "title=Требуется подтверждение …"
set "quest=<big>Directory\n\n<b><span fgcolor='green'>%projectRENAME%</span></b>\n\nis already exists.\n\n<b><span fgcolor='red'>Delete and continue?</span></b></big>"
if /i "%LangID%" == "ru" set "quest=<big>Каталог\n\n<b><span fgcolor='green'>%projectRENAME%</span></b>\n\nуже существует.\n\n<b><span fgcolor='red'>Удалить и продолжить?</span></b></big>" 
unix zenity --timeout 180 --question --title "%title%" --text "%quest%" || goto :UserCancel
rmdir /q /s "%tdir%"
:MakeTargetDir
mkdir "%tdir%"
pushd "%sdir%"
for /f "tokens=* delims=" %%i in ('dir /a-d /b .') do call :CopyFileLpr "%%i"
popd
if exist "%projectTARGET%" call :OpenTargetProjectLpr
if exist "%projectTARGET%" goto :ProjectSucceedLpr
goto :EOF

:IsRelevantDanProjectLpr
set /a isdan=0 & set /a islib=0 & set /a isexp=0 & set /a isplug & set /a fordan=0
for /f "tokens=* delims=" %%i in ('echo %targetHOMEDIR% ^| findstr /i /c:"resource\plugin\dan"') do set /a isdan=1
for /f "tokens=* delims=" %%i in ('type %projectSAMPLE% ^| findstr /i /c:"Library"') do set /a islib=1
for /f "tokens=* delims=" %%i in ('type %projectSAMPLE% ^| findstr /i /c:"Exports"') do set /a isexp=1
for /f "tokens=* delims=" %%i in ('type %projectSAMPLE% ^| findstr /i /c:"CRWDAQ_PLUGIN"') do set /a isplug=1
for /f "tokens=* delims=" %%i in ('type %projectSAMPLE% ^| findstr /i /c:"ForDataAnalysis"') do set /a fordan=1
if "%isdan%" == "1" if not "%islib% %isexp% %isplug% %fordan%" == "1 1 1 1" exit /b 1
exit /b 0
goto :EOF

:OpenTargetProjectLpr
if not defined CRW_DAQ_SYS_EXE_PID goto :EOF
%scripthome%\shell\send2crwdaq.exe -c @open -e %projectTARGET%
rem echo @open -e %projectTARGET% | %scripthome%\shell\send2crwdaq.exe
goto :EOF

:CopyFileLpr
if "%~1" == "" goto :EOF
set "fn=%~1"
set "sf=%~f1"
set "tn=!fn:%projectNAME%=%projectRENAME%!"
set "tf=%tdir%\%tn%"
copy /v /b /y "%sf%" "%tf%" > nul && echo copy "%sf%" "%tf%"
call :ReplaceFileStringsLpr "%tf%"
goto :EOF

:ReplaceFileStringsLpr
if "%~1" == "" goto :EOF
if not exist "%~f1" goto :EOF
pushd "%~dp1"
if /i "%~x1" == ".lps" call :ReplaceProjectDirInFile %1
if /i "%~x1" == ".lpi" call :ReplaceCopyrightYearInFile %1
if /i "%~x1" == ".lpr" call :ReplaceCopyrightYearInFile %1
if /i "%~x1" == ".lps" if not "%projectNAME%" == "%projectRENAME%" call :ReplaceProjectNameInFile %1
if /i "%~x1" == ".lpr" if not "%projectNAME%" == "%projectRENAME%" call :ReplaceProjectNameInFile %1
if /i "%~x1" == ".lpi" if not "%projectNAME%" == "%projectRENAME%" call :ReplaceProjectNameInFile %1
popd
goto :EOF

:ReplaceProjectNameInFile
if "%~1" == "" goto :EOF
unix sed -i "%~nx1" -e "s|%projectNAME%|%projectRENAME%|g"
goto :EOF

:ReplaceProjectDirInFile
if "%~1" == "" goto :EOF
unix sed -i "%~nx1" -e "s|%sdir%|%tdir%|ig"
goto :EOF

:ReplaceCopyrightYearInFile
if "%~1" == "" goto :EOF
set "Year=" & rem Replace current Year
for /f "tokens=* delims=" %%i in ('date /t ^| unix sed -r -e "s/.*([0-9]{4}).*/\1/"') do set "Year=%%i"
if defined Year unix sed -i "%~nx1" -e "s/Copyright (c) [0-9\-]* /Copyright (c) 2001-%Year% /gi"
goto :EOF

:ErrorNotRelevantDanProjectLpr
call :NotifyErrorRusEng "Ошибка: Шаблон проекта не подходит для плагина «dan»." "Error: Project Sample is not relevant for «dan» plugin."
exit /b 1
goto :EOF

:ErrorTargetDirIsSource
call :NotifyErrorRusEng "Ошибка: Источник = Приемник …" "Error: Source = Target …"
exit /b 1
goto :EOF

:MissedArguments
call :NotifyErrorRusEng "Ошибка: Недостаточно аргументов …" "Error: Missed arguments …"
exit /b 1
goto :EOF

:SampleNotFound
call :NotifyErrorRusEng "Ошибка: Файл Образца не найден: %projectSAMPLE% …" "Error: Sample file not found: %projectSAMPLE% …"
exit /b 1
goto :EOF

:TargetDirNotFound
call :NotifyErrorRusEng "Ошибка: Целевой каталог не найден: %targetHOMEDIR% …" "Error: Targer directory not found: %targetHOMEDIR% …"
exit /b 1
goto :EOF

:BadProjectType
call :NotifyErrorRusEng "Недопустимый тип проекта: %projectTYPE% …" "Invalid project type: %projectTYPE% …"
exit /b 1
goto :EOF

:UserCancel
call :NotifyErrorRusEng "Пользователь отменил …" "User Cancel …"
exit /b 1
goto :EOF

:ProjectSucceedLpr
call :NotifySuccessRusEng "Проект %projectRENAME%.%projectTYPE% создан." "Project %projectRENAME%.%projectTYPE% created."
exit /b 0
goto :EOF

:NotifyErrorRusEng
if /i not "%LangID%" == "ru" shift /1
if "%~1" == "" goto :EOF
call :NotifyCrwdaq "%~1"
echo.
set /p "_=%~1" < nul
echo.
echo.
unix tooltip-notifier text "%scriptname%: %~1" preset stdError delay 180000 fontsize 12
goto :EOF

:NotifySuccessRusEng
if /i not "%LangID%" == "ru" shift /1
if "%~1" == "" goto :EOF
call :NotifyCrwdaq "%~1"
echo.
set /p "_=%~1" < nul
echo.
echo.
unix tooltip-notifier text "%scriptname%: %~1" preset stdSuccess delay 30000 fontsize 12
goto :EOF

:NotifyCrwdaq
if not defined CRW_DAQ_SYS_EXE_PID goto :EOF
<nul set /p "_=@silent @echo %date: =0%-%time: =0% => %scriptname%: %~1" | cmd /c %scripthome%\shell\send2crwdaq.exe
goto :EOF

:DetectLanguage
set LangID=en
for /f "tokens=* delims=" %%i in ('chcp ^| findstr /c:866') do set LangID=ru
for /f "tokens=* delims=" %%i in ('chcp ^| findstr /c:1251') do set LangID=ru
goto :EOF

::::::::::::::
:: END OF FILE
::::::::::::::
