@echo off
SetLocal EnableExtensions EnableDelayedExpansion

echo.
echo ****************************************************
echo CRW-DAQ Tuning script.  Run on CRW-DAQ Installation.
echo The script expected location is  Crw32exe\Resource\.
echo ****************************************************
echo.

chcp 65001

if "%CRW_DAQ_SYS_HOME_DIR%" == "" ( echo The script should be called from CRW-DAQ system only. & goto :EOF )
if "%CRW_DAQ_VAR_TMP_DIR%" == "" ( echo The script should be called from CRW-DAQ system only. & goto :EOF )

set MySelf=%~f0

pushd "%~dp0.." && call :Tuning %*
popd

goto :EOF

:Tuning
call :EnterLogFile
call :ClearTempDir
call :RunTuningTools
call :LeaveLogFile
goto :EOF

:EnterLogFile
set "logFile=%CRW_DAQ_VAR_TMP_DIR%\%~n0.log"
echo %Date%-%Time%: >> "%logFile%"
echo Enter "%MySelf%" >> "%logFile%"
goto :EOF

:LeaveLogFile
echo %Date%-%Time%: >> "%logFile%"
echo Leave "%MySelf%" >> "%logFile%"
goto :EOF

:ClearTempDir
echo ClearTempDir: >> "%logFile%"
pushd "%CRW_DAQ_VAR_TMP_DIR%" && call :DoClearTempDir
popd
goto :EOF

:DoClearTempDir
del /F /S /Q *.lst >> "%logFile%"
del /F /S /Q *.tmp >> "%logFile%"
set /a sizeKeep=1024*512
unix purger -ra !sizeKeep! *.* >> "%logFile%"
goto :EOF

:RunTuningTools
echo RunTuningTools: >> "%logFile%"
echo reg import Resource\Shell\wintail.reg >> "%logFile%"
call reg import Resource\Shell\wintail.reg >> "%logFile%" 2>&1
goto :EOF
