@echo off
SetLocal EnableExtensions EnableDelayedExpansion

echo.
echo ***************************************************
echo CRW-DAQ Finalization script. Run on CRW-DAQ logout.
echo The script expected location is   crwdaq\resource\.
echo ***************************************************
echo.

chcp 65001

if "%CRW_DAQ_SYS_HOME_DIR%" == "" ( echo This script should be called from CRW-DAQ system only. & goto :EOF )
if "%CRW_DAQ_VAR_TMP_DIR%" == "" ( echo The script should be called from CRW-DAQ system only. & goto :EOF )

:Identification
set "scriptfile=%~f0"
set "scriptbase=%~n0"
set "scriptname=%~nx0"
for %%i in ( "%~dp0\." ) do set "scripthome=%%~fi"

set MySelf=%~f0

pushd "%~dp0.." && call :Logout %*
popd

goto :EOF

:Logout
call :EnterLogFile
call :ClearTempDir
call :CheckFpQuiEnv
call :SetFileAttrib -R Resource\DieselPascal\External\dp*.pas
call :SetFileAttrib -R Resource\DieselPascal\External\dp*.md
call :VerifyIntegrity
call :LeaveLogFile
goto :EOF

:EnterLogFile
set "logFile=%CRW_DAQ_VAR_TMP_DIR%\%~n0.log"
echo %Date%-%Time%: >> "%logFile%"
echo Enter "%MySelf%" >> "%logFile%"
goto :EOF

:LeaveLogFile
echo %Date%-%Time%: >> "%logFile%"
echo Leave "%MySelf%" >> "%logFile%"
goto :EOF

:ClearTempDir
echo ClearTempDir: >> "%logFile%"
pushd "%CRW_DAQ_VAR_TMP_DIR%" && call :DoClearTempDir
popd
goto :EOF

:DoClearTempDir
del /F /S /Q *.LST >> "%logFile%"
del /F /S /Q *.TMP >> "%logFile%"
unix %scripthome%\crwdaqlogroll.cmd & goto :EOF & rem skip obsolete log files cleaner
set /a sizeKeep=1024*512
unix purger -ra !sizeKeep! *.* >> "%logFile%"
goto :EOF

:CheckFpQuiEnv
if exist "%ProgramFiles%\FP-QUI\FP-QUICore.exe" goto :EOF
if not exist "%CRW_DAQ_SYS_HOME_DIR%\Resource\CrwToolkit\add\fp-qui\FP-QUICore.exe" goto :EOF
set FPQUI_DIR=%CRW_DAQ_SYS_HOME_DIR%\Resource\CrwToolkit\add\fp-qui
set FPQUI_COREEXE=FP-QUICore.exe
set FPQUI_EXE=FP-QUI.exe
goto :EOF

:SetFileAttrib
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if not exist %2 goto :EOF
call attrib %1 %2
goto :EOF

:VerifyIntegrity
call "%CRW_DAQ_SYS_HOME_DIR%\Resource\crwdaq.verify.cmd" >> "%logFile%"
goto :EOF
