@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion
:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright(c) 2021 Alexey Kuryakin kouriakine@mail.ru
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Install Q-Dir into %SystemDrive%\Programs\Portable\
:: Option [--targetdir dir] uses for another directory
:::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Q-Dir is free for all users without restrictions
:: Q-Dir is the Quad-Directory-Explorer (file manager)
:: Q-Dir home site: http://www.softwareok.com/?Freeware
:::::::::::::::::::::::::::::::::::::::::::::::::::::::

:Main
:SetSelfInfo
set SelfArgs=%*
set "SelfExt=%~x0"
set "SelfBase=%~n0"
set "SelfName=%~nx0"
set "SelfFile=%~f0"
set "SelfDir=%~dp0"
set "SelfDir=%SelfDir:~0,-1%"
for %%i in ("%~dp0\.") do set "SelfDir=%%~fi"

:StartProcessing
call :SetTargetDir %*
call :DeleteTargetDirOld || exit /b 1
call :BackupTargetDir    || exit /b 1
call :MakeTargetDir      || exit /b 1
pushd "%TargetDir%" && call :InstallTarget
popd
call :Sleep 4
if not "%ErrorCode%" == "0" ( call :RecoverTargetDir   & exit /b 1 )
if     "%ErrorCode%" == "0" ( call :DeleteTargetDirOld & exit /b 0 )
goto :EOF

:Sleep
if "%~1" == "" goto :EOF
ping -n %1 localhost 1>nul 2>nul
goto :EOF

:SetTargetDir
set "TargetDir=%SystemDrive%\Programs\Portable\SoftwareOK.com\Q-Dir"
set "SourcePortable=Q-Dir_Portable.7z"
set "SourceSettings=Q-Dir_Settings.7z"
set "ErrorCode=0"
call :ExtractTargetDir %*
echo TargetDir = %TargetDir%
goto :EOF

:ExtractTargetDir
if "%~1" == "" goto :EOF
if /i "%~1" == "--targetdir" if not "%~2" == "" ( set "TargetDir=%~2" & shift /1 )
shift /1 & goto :ExtractTargetDir
goto :EOF

:CheckSourceFiles
if not defined TargetDir                  ( call :PrintToStdErr "Error: undefined TargetDir."               & exit /b 1 )
if not defined SourcePortable             ( call :PrintToStdErr "Error: undefined SourcePortable."          & exit /b 1 )
if not defined SourceSettings             ( call :PrintToStdErr "Error: undefined SourceSettings."          & exit /b 1 )
if not exist "%SelfDir%\%SourcePortable%" ( call :PrintToStdErr "Error: file not found - %SourcePortable%." & exit /b 1 )
if not exist "%SelfDir%\%SourceSettings%" ( call :PrintToStdErr "Error: file not found - %SourceSettings%." & exit /b 1 )
exit /b 0
goto :EOF

:DeleteTargetDirOld
if not defined TargetDir   ( call :PrintToStdErr "Error: undefined TargetDir."              & exit /b 1 )
if exist "%TargetDir%.OLD" rmdir /s /q "%TargetDir%.OLD"
if exist "%TargetDir%.OLD" ( call :PrintToStdErr "Error: could not delete %TargetDir%.OLD." & exit /b 1 )
exit /b 0
goto :EOF

:BackupTargetDir
if not defined TargetDir   ( call :PrintToStdErr "Error: undefined TargetDir."              & exit /b 1 )
if not exist "%TargetDir%" ( exit /b 0 )
for %%i in ("%TargetDir%") do rename "%%~fi" "%%~ni.OLD"
if exist "%TargetDir%"     ( call :PrintToStdErr "Error: could not rename %TargetDir%."     & exit /b 1 )
exit /b 0
goto :EOF

:MakeTargetDir
if not defined TargetDir   ( call :PrintToStdErr "Error: undefined TargetDir."              & exit /b 1 )
if not exist "%TargetDir%" mkdir "%TargetDir%"
if not exist "%TargetDir%" ( call :PrintToStdErr "Error: could not create %TargetDir%."     & exit /b 1 )
exit /b 0
goto :EOF

:Check7z
for %%i in ( "%SelfDir%\..\..\Resource\Shell" ) do if exist "%%i\7za.exe" set "PATH=%%~fi;%PATH%"
call 7za 1>nul 2>nul || ( call :PrintToStdErr "Error: packer (7za.exe) is not found."       & exit /b 1 )
exit /b 0
goto :EOF

:Unpack7z
if "%~1" == "" goto :EOF
if not exist %1     ( call :PrintToStdErr "Error: file not found - %~1."   & exit /b 1 )
call 7za x -y %1 || ( call :PrintToStdErr "Error: could not unpack - %~1." & exit /b 1 )
exit /b 0
goto :EOF

:InstallTarget
set /a "ErrorCode=1"
call :CheckSourceFiles                        || exit /b 1
call :Check7z                                 || exit /b 1
call :Unpack7z "%SelfDir%\%SourcePortable%"   || exit /b 1
call :Unpack7z "%SelfDir%\%SourceSettings%"   || exit /b 1
set /a "ErrorCode=0"
exit /b 0
goto :EOF

:RecoverTargetDir
if not defined TargetDir   ( call :PrintToStdErr "Error: undefined TargetDir." & exit /b 1 )
if exist "%TargetDir%"  rmdir /s /q "%TargetDir%"
xcopy /Y /C /I /S /R "%TargetDir%.OLD\*" "%TargetDir%"
exit /b 0
goto :EOF

:PrintToStdErr
if not "%~1" == "" echo %~1 1>&2
goto :EOF

:SetErrorLevel
exit /b %1
goto :EOF
