 {
 ***********************************************************************
 Daq Pascal application program test_utf8.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @demo_utf8 s   - Demo to test and learn UTF8 functions.
|********************************************************
[]
 }
program test_utf8;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 cmd_Demo_Utf8     : Integer;    { Command @demo_utf8               }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Demo for UTF8 functions.
 Example: demo_utf8('Привет Мир!');
 }
 procedure demo_utf8(test:string);
 var su,sa:string; i:Integer;
 begin
  su:=''; sa:='';
  writeln('Execute utf8_demo("'+test+'"):');
  su:=utf8_encode_ansi(test);
  sa:=utf8_decode_ansi(su);
  writeln('Test string = ',test);
  writeln('UTF8 encode = ',su);
  writeln('UTF8 decode = ',sa);
  writeln('Test Status = ',(test=sa):1);
  writeln('Test Length = ',length(test):1);
  writeln('UTF8 Length = ',length(su):1);
  writeln('Char Length = ',utf8_length(su):1);
  writeln('UTF8 Upper  = ',strconv('utf8-ansi',utf8_uppercase(ExtractWord(1,su))));
  writeln('UTF8 Lower  = ',strconv('utf8-ansi',utf8_lowercase(ExtractWord(2,su))));
  writeln('Test Copy   = ',utf8_decode_ansi(utf8_copy(su,2,utf8_length(su)-2)));
  writeln('UTF8 BOM    = ',utf8_bom);
  for i:=1 to length(test) do begin
   write(' Index ',i:3);
   write(' Ansi ',StrFetch(test,i));
   write(' Code ',Ord(StrFetch(test,i)):3);
   write(' UTF8 ',utf8_copy(su,i,1):4);
   write(' Code ',utf8_ord(su,i):5);
   write(' Char ',utf8_chr(utf8_ord(su,i)):4);
   write(' Test ',(StrFetch(test,i)=utf8_decode_ansi(utf8_chr(utf8_ord(su,i)))):1);
   writeln;
  end;
  su:=''; sa:='';
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  cmd_Demo_Utf8:=RegisterStdInCmd('@demo_utf8','');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  if RunCount=2 then begin
   Success('Для тестирования функций UTF8 используйте команду:');
   Success('@demo_utf8 Привет Мир!');
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer; i:Integer; r:Real;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @demo_utf8 Привет Мир!
   }
   if (cmdid = cmd_Demo_Utf8) then begin
    if not IsEmptyStr(arg) then demo_utf8(arg);
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
