 {
 Demo program: how to plot 3D - surface with add3d,plot3d functions.
 }
program _plot3d;
var
 b         : Boolean;
 Ok        : Boolean;
 errors    : Integer;
 errorcode : Integer;
 tagNx,tagNy,tagX1,tagY1,tagX2,tagY2,tagFormula,tagDlgNotify:Integer;
 {
 Initialize and check tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
 {
 Evaluate and plot
 } 
 procedure show3d(nx,ny:integer; x1,y1,x2,y2:real; formula:string);
 var ix,iy:integer; x,y,z:real;
 begin
  for ix:=0 to nx-1 do
  for iy:=0 to ny-1 do begin
   x:=x1+(x2-x1)*ix/(nx-1);
   y:=y1+(y2-y1)*iy/(ny-1);
   {z:=1-exp(-(sqr(x)+sqr(y-2.5))/2)+2*exp(-(sqr(x-2.5)+sqr(y))/2);}
   b:=evar('x',x);
   b:=evar('y',y);
   z:=eval(formula);
   b:=add3d(x,y,z);
  end;
  b:=plot3d(nx,ny,x1,y1,x2,y2,'Caption=Demo plot3d'+
                              '|Title=Заголовок'+
                              '|Legend=Легенда'+
                              '|top=100|left=100'+
                              '|width=600|height=400'+
                              '|phi=60|psi=85'+
                              '|scalex=1|scaley=1|scalez=2'+
                              '|replace=1');
  b:=plot3d(0,0,0,0,0,0,'');
 end;
begin
 {
 Initialization actions on Start
 }
 if runcount=1 then begin
  errors:=0;
  errorcode:=registererr(devname+'-'+progname);
  writeln(devname+' start');
  InitTag(tagNx,        'Nx',        1);
  InitTag(tagNy,        'Ny',        1);
  InitTag(tagX1,        'X1',        2);
  InitTag(tagY1,        'Y1',        2);
  InitTag(tagX2,        'X2',        2);
  InitTag(tagY2,        'Y2',        2);
  InitTag(tagFormula,   'Formula',   3);
  InitTag(tagDlgNotify, 'DlgNotify', 1);
  b:=ssettag(tagFormula,locasestr(sgettag(tagFormula)));
  b:=action('&Dialog');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop
 }
 if isinf(runcount) then begin
  writeln(devname+' stop');
 end else

 {
 Actions on Poll
 }
 if Ok then begin
  writeln(devname+' RunCount=',runcount:7:0);
  if igettag(tagDlgNotify)<>0 then begin
   if igettag(tagDlgNotify)=1 
   then Show3d(igettag(tagNx),igettag(tagNy),
               rgettag(tagX1),rgettag(tagY1),
               rgettag(tagX2),rgettag(tagY2),
               sgettag(tagFormula));
   b:=isettag(tagDlgNotify,0);
  end;
 end;
end.
