// *****************************************************************************
//   c  , ,   ..  
//      "L-Kard"   Borland Delphi 6.0.
//  : E14-140, E14-440  E20-10.
// *****************************************************************************

unit Lusbapi;

interface

uses
	windows;

//  
const
	NAME_LINE_LENGTH_LUSBAPI				=	25;
	COMMENT_LINE_LENGTH_LUSBAPI			=	256;
	ADC_CALIBR_COEFS_QUANTITY_LUSBAPI	=	128;
	DAC_CALIBR_COEFS_QUANTITY_LUSBAPI	=	128;

//     
type
	pBYTE			= ^BYTE;
	pSHORT		= ^SHORT;
	pWORD			= ^WORD;
	pDWORD		= ^DWORD;
	pOVERLAPPED = ^OVERLAPPED;

	// ,      DSP
	IO_REQUEST_LUSBAPI = packed record
		Buffer : pSHORT;			 							//	   
		NumberOfWordsToPass : DWORD;			 			// - ,   
		NumberOfWordsPassed : DWORD;						//  -  
		Overlapped : pOVERLAPPED;							//    -     OVERLAPPED
		TimeOut : DWORD;										//    -   
	end;
	pIO_REQUEST_LUSBAPI = ^IO_REQUEST_LUSBAPI;

	//        
	LAST_ERROR_INFO_LUSBAPI = packed record
		ErrorString : array [0..255] of BYTE;			//    
		ErrorNumber : DWORD;	  								//   
	end;
	pLAST_ERROR_INFO_LUSBAPI = ^LAST_ERROR_INFO_LUSBAPI;

	//   ,    : MCU, DSP, PLD  ..
	VERSION_INFO_LUSBAPI = packed record
		Version : array [0..9] of BYTE;				  	//     
		Date : array [0..13] of BYTE;					  	//   
		Manufacturer : array [0..(NAME_LINE_LENGTH_LUSBAPI-1)] of BYTE;	//  
		Author : array [0..(NAME_LINE_LENGTH_LUSBAPI-1)] of BYTE;	  		//  
		Comment : array [0..(COMMENT_LINE_LENGTH_LUSBAPI-1)] of BYTE;		//  
	end;

	//    MCU,       
	//   ,   
	MCU_VERSION_INFO_LUSBAPI = packed record
		FwVersion : VERSION_INFO_LUSBAPI;				//       ''(Application) 
		BlVersion : VERSION_INFO_LUSBAPI;				//     ''(BootLoader) 
	end;

	//    
	MODULE_INFO_LUSBAPI = packed record
		CompanyName : array [0..(NAME_LINE_LENGTH_LUSBAPI-1)] of BYTE;		//  - 
		DeviceName : array [0..(NAME_LINE_LENGTH_LUSBAPI-1)] of BYTE; 		//  
		SerialNumber : array [0..15] of BYTE;			//   
		Revision : BYTE;										//  
		Comment : array [0..(COMMENT_LINE_LENGTH_LUSBAPI-1)] of BYTE;		//  
	end;

	//   DSP
	DSP_INFO_LUSBAPI = packed record
		Active : BOOL;											//     
		Name : array [0..(NAME_LINE_LENGTH_LUSBAPI-1)] of BYTE;				//  DSP
		ClockRate : double;									//    DSP  
		Version : VERSION_INFO_LUSBAPI;					//    DSP
		Comment : array [0..(COMMENT_LINE_LENGTH_LUSBAPI-1)] of BYTE;		//  
	end;

	//    ( '')
	MCU_INFO_LUSBAPI = packed record
		Active : BOOL;										  	//     
		Name : array [0..(NAME_LINE_LENGTH_LUSBAPI-1)] of BYTE;				//  
		ClockRate : double;								  	//      
		Version : VERSION_INFO_LUSBAPI;				  	//     
		Comment : array [0..(COMMENT_LINE_LENGTH_LUSBAPI-1)] of BYTE;		//  
	end;

	//    ( '')
	MCU1_INFO_LUSBAPI = packed record
		Active : BOOL;										  	//     
		Name : array [0..(NAME_LINE_LENGTH_LUSBAPI-1)] of BYTE;				//  
		ClockRate : double;								  	//      
		Version : MCU_VERSION_INFO_LUSBAPI;		 	  	//       ,    ''
		Comment : array [0..(COMMENT_LINE_LENGTH_LUSBAPI-1)] of BYTE;		//  
	end;

	//    (PLD)
	PLD_INFO_LUSBAPI = packed record				 		// PLD - Programmable Logic Device
		Active : BOOL;									 		//     
		Name : array [0..(NAME_LINE_LENGTH_LUSBAPI-1)] of BYTE;		  		//  
		ClockRate : double;							 		//      
		Version : VERSION_INFO_LUSBAPI;			  		//     
		Comment : array [0..(COMMENT_LINE_LENGTH_LUSBAPI-1)] of BYTE;		//  
	end;

	//   
	ADC_INFO_LUSBAPI = packed record
		Active : BOOL;									 		//     
		Name : array [0..(NAME_LINE_LENGTH_LUSBAPI-1)] of BYTE;				//   
		OffsetCalibration : array [0..(ADC_CALIBR_COEFS_QUANTITY_LUSBAPI-1)] of double;	//    
		ScaleCalibration : array [0..(ADC_CALIBR_COEFS_QUANTITY_LUSBAPI-1)] of double; 	//   
		Comment : array [0..(COMMENT_LINE_LENGTH_LUSBAPI-1)] of BYTE;		//  
	end;

	//   
	DAC_INFO_LUSBAPI = packed record
		Active : BOOL;									 		//     
		Name : array [0..(NAME_LINE_LENGTH_LUSBAPI-1)] of BYTE;				//   
		OffsetCalibration : array [0..(DAC_CALIBR_COEFS_QUANTITY_LUSBAPI-1)] of double;	//  
		ScaleCalibration : array [0..(DAC_CALIBR_COEFS_QUANTITY_LUSBAPI-1)] of double;  	//  
		Comment : array [0..(COMMENT_LINE_LENGTH_LUSBAPI-1)] of BYTE;		//  
	end;

	//    -
	DIGITAL_IO_INFO_LUSBAPI = packed record
		Active : BOOL;											//     
		Name : array [0..(NAME_LINE_LENGTH_LUSBAPI-1)] of BYTE;				//   
		InLinesQuantity : WORD;	 							// -  
		OutLinesQuantity : WORD; 							// -  
		Comment : array [0..(COMMENT_LINE_LENGTH_LUSBAPI-1)] of BYTE;		//  
	end;

	//        
	INTERFACE_INFO_LUSBAPI = packed record
		Active : BOOL;										 	//     
		Name : array [0..(NAME_LINE_LENGTH_LUSBAPI-1)] of BYTE;			 	// 
		Comment : array [0..(COMMENT_LINE_LENGTH_LUSBAPI-1)] of BYTE;		//  
	end;

	
//   Lusbbase
// *****************************************************************************
//     USB   L-Card
// *****************************************************************************

type
	Lusbbase = class
		//       USB 
		Function OpenLDevice(VirtualSlot : WORD) : BOOL; virtual; stdcall; abstract;
		Function CloseLDevice : BOOL; virtual; stdcall; abstract;
		Function ReleaseLInstance : BOOL; virtual; stdcall; abstract;
		//    USB
		Function GetModuleHandle : THandle; virtual; stdcall; abstract;
		//    
		Function GetModuleName(ModuleName : pCHAR) : BOOL; virtual; stdcall; abstract;
		//      USB
		Function GetUsbSpeed(UsbSpeed : pBYTE) : BOOL; virtual; stdcall; abstract;
		//      
		Function GetLastErrorInfo(LastErrorInfo : pLAST_ERROR_INFO_LUSBAPI) : BOOL; virtual; stdcall; abstract;
	end;

	
//     E14-140
// *****************************************************************************
// ******************           E 1 4 - 1 4 0  ***************************
// *****************************************************************************

// 
const
	//       E14-440
	ADC_INPUT_RANGE_10000mV_E140			=	($00);
	ADC_INPUT_RANGE_2500mV_E140			=	($01);
	ADC_INPUT_RANGE_625mV_E140				=	($02);
	ADC_INPUT_RANGE_156mV_E140				=	($03);
	INVALID_ADC_INPUT_RANGE_E140			=	($04);

	//       
	INT_ADC_CLOCK_E140						=	($00);
	EXT_ADC_CLOCK_E140						=	($01);
	INVALID_ADC_CLOCK_E140				  	=	($02);

	//       
	//   SYN    (  
	//    )
	ADC_CLOCK_TRANS_DISABLED_E140		  	=	($00);
	ADC_CLOCK_TRANS_ENABLED_E140		  	=	($01);
	INVALID_ADC_CLOCK_TRANS_E140		  	=	($02);

	//      E14-440
	NO_SYNC_E140								=	($00);
	TTL_START_SYNC_E140						=	($01);
	TTL_KADR_SYNC_E140						=	($02);
	ANALOG_SYNC_E140							=	($03);
	INVALID_SYNC_E140							=	($04);

	//      
	DAC_INACCESSIBLED_E140					=	($00);
	DAC_ACCESSIBLED_E140						=	($01);
	INVALID_DAC_OPTION_E140					=	($02);

	//     E14-440
	REVISION_A_E140 							=	($00);
	INVALID_REVISION_E140					=	($01);

	//     
	MAX_CONTROL_TABLE_LENGTH_E140			=	(128);
	ADC_INPUT_RANGES_QUANTITY_E140		=	(INVALID_ADC_INPUT_RANGE_E140);
	ADC_CALIBR_COEFS_QUANTITY_E140		=	(ADC_INPUT_RANGES_QUANTITY_E140);
	DAC_CHANNELS_QUANTITY_E140				=	($02);
	DAC_CALIBR_COEFS_QUANTITY_E140		=	(DAC_CHANNELS_QUANTITY_E140);
	TTL_LINES_QUANTITY_E140					=	($10);							// -  
	REVISIONS_QUANTITY_E140 				=	(INVALID_REVISION_E140);	// -  () 

	//      
	ADC_INPUT_RANGES_E140 : array [0..(ADC_INPUT_RANGES_QUANTITY_E140-1)]  of double =	( 10.0, 10.0/4.0, 10.0/16.0, 10.0/64.0 );
	//      
	DAC_OUTPUT_RANGE_E140					=	5.0;
	//   
	REVISIONS_E140 : array [0..(REVISIONS_QUANTITY_E140-1)] of char = ( 'A' );


// 
type
	//      E14-440
	MODULE_DESCRIPTION_E140 = packed record
		Module 		: MODULE_INFO_LUSBAPI;		  	//    
		DevInterface	: INTERFACE_INFO_LUSBAPI;	//     
		Mcu			: MCU_INFO_LUSBAPI;				//   
		Adc			: ADC_INFO_LUSBAPI;				//   
		Dac			: DAC_INFO_LUSBAPI;				//   
		DigitalIo	: DIGITAL_IO_INFO_LUSBAPI;		//    -
	end;
	pMODULE_DESCRIPTION_E140 = ^MODULE_DESCRIPTION_E140;

	//       E14-440
	ADC_PARS_E140 = packed record
		ClkSource : WORD;			  							//      
		EnableClkOutput : WORD; 							//      
		InputMode : WORD;										//     
		SynchroAdType : WORD;								//   
		SynchroAdMode : WORD; 								//   
		SynchroAdChannel : WORD;  							//     
		SynchroAdPorog : SHORT;								//      
		ChannelsQuantity : WORD;							//    
		ControlTable : array [0..(MAX_CONTROL_TABLE_LENGTH_E140-1)] of WORD;	//      
		AdcRate : double;	  			  						//     
		InterKadrDelay : double;		  					//    
		KadrRate : double;									//     
	end;
	pADC_PARS_E140 = ^ADC_PARS_E140;

//   E14-440
ILE140 = class(Lusbbase)
  public
		//     
		Function GET_ADC_PARS(ap : pADC_PARS_E140) : BOOL; virtual; stdcall; abstract;
		Function SET_ADC_PARS(ap : pADC_PARS_E140) : BOOL; virtual; stdcall; abstract;
		Function START_ADC : BOOL; virtual; stdcall; abstract;
		Function STOP_ADC : BOOL; virtual; stdcall; abstract;
		Function ADC_KADR(Data : pSHORT) : BOOL; virtual; stdcall; abstract;
		Function ADC_SAMPLE(AdcData : pSHORT; AdcChannel : WORD) : BOOL; virtual; stdcall; abstract;
		Function ReadData(ReadRequest : pIO_REQUEST_LUSBAPI) : BOOL; virtual; stdcall; abstract;

		//     
		Function DAC_SAMPLE(DacData : pSHORT; DacChannel : WORD) : BOOL; virtual; stdcall; abstract;

		//      
		Function ENABLE_TTL_OUT(EnableTtlOut : BOOL) : BOOL; virtual; stdcall; abstract;
		Function TTL_IN(TtlIn : pWORD) : BOOL; virtual; stdcall; abstract;
		Function TTL_OUT(TtlOut : WORD) : BOOL; virtual; stdcall; abstract;

		//       
		Function ENABLE_FLASH_WRITE(IsFlashWriteEnabled : BOOL) : BOOL; virtual; stdcall; abstract;
		Function READ_FLASH_WORD(FlashAddress : WORD; FlashWord : pSHORT) : BOOL; virtual; stdcall; abstract;
		Function WRITE_FLASH_WORD(FlashAddress : WORD; FlashWord : SHORT) : BOOL; virtual; stdcall; abstract;

		//       
		Function GET_MODULE_DESCRIPTION(ModuleDescription : pMODULE_DESCRIPTION_E140) : BOOL; virtual; stdcall; abstract;
		Function SAVE_MODULE_DESCRIPTION(ModuleDescription : pMODULE_DESCRIPTION_E140) : BOOL; virtual; stdcall; abstract;

	end;
	pILE140 = ^ILE140;

	
//     E-154
// *****************************************************************************
// ******************           E - 1 5 4      ***************************
// *****************************************************************************

// 
const
	//       E-154
	ADC_INPUT_RANGE_5000mV_E154			=	($00);
	ADC_INPUT_RANGE_1600mV_E154			=	($01);
	ADC_INPUT_RANGE_500mV_E154				=	($02);
	ADC_INPUT_RANGE_160mV_E154				=	($03);
	INVALID_ADC_INPUT_RANGE_E154			=	($04);

	//       
	INT_ADC_CLOCK_E154						=	($00);
	EXT_ADC_CLOCK_E154						=	($01);
	INVALID_ADC_CLOCK_E154				  	=	($02);

	//       
	//   SYN    (  
	//    )
	ADC_CLOCK_TRANS_DISABLED_E154		  	=	($00);
	ADC_CLOCK_TRANS_ENABLED_E154		  	=	($01);
	INVALID_ADC_CLOCK_TRANS_E154		  	=	($02);

	//      E-154
	NO_SYNC_E154								=	($00);
	TTL_START_SYNC_E154						=	($01);
	TTL_KADR_SYNC_E154						=	($02);
	ANALOG_SYNC_E154							=	($03);
	INVALID_SYNC_E154							=	($04);

	//      
	DAC_INACCESSIBLED_E154					=	($00);
	DAC_ACCESSIBLED_E154						=	($01);
	INVALID_DAC_OPTION_E154					=	($02);

	//     E-154
	REVISION_A_E154 							=	($00);
	INVALID_REVISION_E154					=	($01);

	//     
	MAX_CONTROL_TABLE_LENGTH_E154			=	(16);
	ADC_INPUT_RANGES_QUANTITY_E154		=	(INVALID_ADC_INPUT_RANGE_E154);
	ADC_CALIBR_COEFS_QUANTITY_E154		=	(ADC_INPUT_RANGES_QUANTITY_E154);
	DAC_CHANNELS_QUANTITY_E154				=	($01);
	DAC_CALIBR_COEFS_QUANTITY_E154		=	(DAC_CHANNELS_QUANTITY_E154);
	TTL_LINES_QUANTITY_E154					=	($10);							// -  
	REVISIONS_QUANTITY_E154 				=	(INVALID_REVISION_E154);	// -  () 

	//      
	ADC_INPUT_RANGES_E154 : array [0..(ADC_INPUT_RANGES_QUANTITY_E154-1)]  of double =	( 5.0, 1.6, 0.5, 0.16);
	//      
	DAC_OUTPUT_RANGE_E154					=	5.0;
	//   
	REVISIONS_E154 : array [0..(REVISIONS_QUANTITY_E154-1)] of char = ( 'A' );


// 
type
	//      E-154
	MODULE_DESCRIPTION_E154 = packed record
		Module 		: MODULE_INFO_LUSBAPI;		  	//    
		DevInterface	: INTERFACE_INFO_LUSBAPI;	//     
		Mcu			: MCU_INFO_LUSBAPI;				//   
		Adc			: ADC_INFO_LUSBAPI;				//   
		Dac			: DAC_INFO_LUSBAPI;				//   
		DigitalIo	: DIGITAL_IO_INFO_LUSBAPI;		//    -
	end;
	pMODULE_DESCRIPTION_E154 = ^MODULE_DESCRIPTION_E154;

	//       E-154
	ADC_PARS_E154 = packed record
		ClkSource : WORD;			  							//      
		EnableClkOutput : WORD; 							//      
		InputMode : WORD;										//     
		SynchroAdType : WORD;								//   
		SynchroAdMode : WORD; 								//   
		SynchroAdChannel : WORD;  							//     
		SynchroAdPorog : SHORT;								//      
		ChannelsQuantity : WORD;							//    
		ControlTable : array [0..(MAX_CONTROL_TABLE_LENGTH_E154-1)] of WORD;	//      
		AdcRate : double;	  			  						//     
		InterKadrDelay : double;		  					//    
		KadrRate : double;									//     
	end;
	pADC_PARS_E154 = ^ADC_PARS_E154;

//   E-154
ILE154 = class(Lusbbase)
  public
		//     
		Function GET_ADC_PARS(ap : pADC_PARS_E154) : BOOL; virtual; stdcall; abstract;
		Function SET_ADC_PARS(ap : pADC_PARS_E154) : BOOL; virtual; stdcall; abstract;
		Function START_ADC : BOOL; virtual; stdcall; abstract;
		Function STOP_ADC : BOOL; virtual; stdcall; abstract;
		Function ADC_KADR(Data : pSHORT) : BOOL; virtual; stdcall; abstract;
		Function ADC_SAMPLE(AdcData : pSHORT; AdcChannel : WORD) : BOOL; virtual; stdcall; abstract;
		Function ReadData(ReadRequest : pIO_REQUEST_LUSBAPI) : BOOL; virtual; stdcall; abstract;
		Function ProcessArray(src : pSHORT; dest : pDOUBLE; size : DWORD; calibr : BOOL; volt : BOOL) : BOOL; virtual; stdcall; abstract;
		Function ProcessOnePoint(src : SHORT; dest : pDOUBLE; channel : DWORD; calibr : BOOL; volt : BOOL) : BOOL; virtual; stdcall; abstract;
		Function FIFO_STATUS(FifoOverflowFlag : pDWORD; FifoMaxPercentLoad : pDOUBLE; FifoSize : pDWORD; MaxFifoBytesUsed : pDWORD) : BOOL; virtual; stdcall; abstract;

		//     
		Function DAC_SAMPLE(DacData : pSHORT; DacChannel : WORD) : BOOL; virtual; stdcall; abstract;
 		Function DAC_SAMPLE_VOLT(DacData : DOUBLE; calibr : BOOL) : BOOL; virtual; stdcall; abstract;

		//      
		Function ENABLE_TTL_OUT(EnableTtlOut : BOOL) : BOOL; virtual; stdcall; abstract;
		Function TTL_IN(TtlIn : pWORD) : BOOL; virtual; stdcall; abstract;
		Function TTL_OUT(TtlOut : WORD) : BOOL; virtual; stdcall; abstract;

		//       
		Function ENABLE_FLASH_WRITE(IsFlashWriteEnabled : BOOL) : BOOL; virtual; stdcall; abstract;
 		Function READ_FLASH_ARRAY(UserFlash : pBYTE) : BOOL; virtual; stdcall; abstract;
		Function WRITE_FLASH_ARRAY(UserFlash : pBYTE) : BOOL; virtual; stdcall; abstract;

		//       
		Function GET_MODULE_DESCRIPTION(ModuleDescription : pMODULE_DESCRIPTION_E154) : BOOL; virtual; stdcall; abstract;
		Function SAVE_MODULE_DESCRIPTION(ModuleDescription : pMODULE_DESCRIPTION_E154) : BOOL; virtual; stdcall; abstract;

		//      ARM
		Function GetArray (Buffer : pSHORT; Size : WORD; Address : WORD)  : BOOL; virtual; stdcall; abstract;
  		Function PutArray(Buffer : pSHORT; Size : WORD; Address : WORD)  : BOOL; virtual; stdcall; abstract;

	end;
	pILE154 = ^ILE154;
	
	
//     E14-440
// *****************************************************************************
// ******************           E 1 4 - 4 4 0  ***************************
// *****************************************************************************

// 
const
	//     LBIOS (     DSP )
	VarsBaseAddress_E440 					= $30;

	//    LBIOS   E14-440 (    DSP )
	L_PROGRAM_BASE_ADDRESS_E440		  	= 	(VarsBaseAddress_E440 + $0);
	L_READY_E440   							= 	(VarsBaseAddress_E440 + $1);
	L_TMODE1_E440   							= 	(VarsBaseAddress_E440 + $2);
	L_TMODE2_E440	   						= 	(VarsBaseAddress_E440 + $3);
	L_TEST_LOAD_E440	 						= 	(VarsBaseAddress_E440 + $4);
	L_COMMAND_E440		 						= 	(VarsBaseAddress_E440 + $5);

	L_DAC_SCLK_DIV_E440 						= 	(VarsBaseAddress_E440 + $7);
	L_DAC_RATE_E440	 						= 	(VarsBaseAddress_E440 + $8);
	L_ADC_RATE_E440	 						= 	(VarsBaseAddress_E440 + $9);
	L_ADC_ENABLED_E440 						= 	(VarsBaseAddress_E440 + $A);
	L_ADC_FIFO_BASE_ADDRESS_E440			= 	(VarsBaseAddress_E440 + $B);
	L_CUR_ADC_FIFO_LENGTH_E440				= 	(VarsBaseAddress_E440 + $C);
	L_ADC_FIFO_LENGTH_E440					= 	(VarsBaseAddress_E440 + $E);
	L_CORRECTION_ENABLED_E440				= 	(VarsBaseAddress_E440 + $F);

	L_ADC_SAMPLE_E440							= 	(VarsBaseAddress_E440 + $11);
	L_ADC_CHANNEL_E440	 					= 	(VarsBaseAddress_E440 + $12);
	L_INPUT_MODE_E440							= 	(VarsBaseAddress_E440 + $13);

	L_SYNCHRO_AD_CHANNEL_E440				= 	(VarsBaseAddress_E440 + $16);
	L_SYNCHRO_AD_POROG_E440					= 	(VarsBaseAddress_E440 + $17);
	L_SYNCHRO_AD_MODE_E440 					= 	(VarsBaseAddress_E440 + $18);
	L_SYNCHRO_AD_TYPE_E440 					= 	(VarsBaseAddress_E440 + $19);

	L_CONTROL_TABLE_LENGHT_E440			= 	(VarsBaseAddress_E440 + $1B);
	L_FIRST_SAMPLE_DELAY_E440				= 	(VarsBaseAddress_E440 + $1C);
	L_INTER_KADR_DELAY_E440					= 	(VarsBaseAddress_E440 + $1D);

	L_DAC_SAMPLE_E440							= 	(VarsBaseAddress_E440 + $20);
	L_DAC_ENABLED_E440					 	= 	(VarsBaseAddress_E440 + $21);
	L_DAC_FIFO_BASE_ADDRESS_E440			= 	(VarsBaseAddress_E440 + $22);
	L_CUR_DAC_FIFO_LENGTH_E440				= 	(VarsBaseAddress_E440 + $24);
	L_DAC_FIFO_LENGTH_E440					= 	(VarsBaseAddress_E440 + $25);

	L_FLASH_ENABLED_E440 					= 	(VarsBaseAddress_E440 + $26);
	L_FLASH_ADDRESS_E440 					= 	(VarsBaseAddress_E440 + $27);
	L_FLASH_DATA_E440 						= 	(VarsBaseAddress_E440 + $28);

	L_ENABLE_TTL_OUT_E440					= 	(VarsBaseAddress_E440 + $29);
	L_TTL_OUT_E440								= 	(VarsBaseAddress_E440 + $2A);
	L_TTL_IN_E440								= 	(VarsBaseAddress_E440 + $2B);

	L_SCALE_E440								= 	(VarsBaseAddress_E440 + $30);
	L_ZERO_E440									= 	(VarsBaseAddress_E440 + $34);

	L_CONTROL_TABLE_E440						=	($80);

	L_DSP_INFO_STUCTURE_E440				=	($200);

	//      E14-440
	INIT_E440									=	($00);
	RESET_E440									=	($01);
	INVALID_RESET_TYPE_E440					=	($02);

	//       E14-440
	ADC_INPUT_RANGE_10000mV_E440			=	($00);
	ADC_INPUT_RANGE_2500mV_E440			=	($01);
	ADC_INPUT_RANGE_625mV_E440				=	($02);
	ADC_INPUT_RANGE_156mV_E440				=	($03);
	INVALID_ADC_INPUT_RANGE_E440			=	($04);

	//      E14-440
	NO_SYNC_E440								=	($00);
	TTL_START_SYNC_E440						=	($01);
	TTL_KADR_SYNC_E440						=	($02);
	ANALOG_SYNC_E440							=	($03);
	INVALID_SYNC_E440							=	($04);

	//      
	DAC_INACCESSIBLED_E440					=	($00);
	DAC_ACCESSIBLED_E440						=	($01);
	INVALID_DAC_OPTION_E440					=	($02);

	//    DSP (  ADSP-2185)
	ADSP2184_E440								=	($00);
	ADSP2185_E440								=	($01);
	ADSP2186_E440								=	($02);
	INVALID_DSP_TYPE_E440					=	($03);

	//      (  24000 )
	F14745_E440									=	($00);
	F16667_E440									=	($01);
	F20000_E440									=	($02);
	F24000_E440									=	($03);
	INVALID_QUARTZ_FREQ_E440				=	($04);

	//     E14-440
	REVISION_A_E440	  						=	($00);
	REVISION_B_E440	  						=	($01);
	REVISION_C_E440	  						=	($02);
	REVISION_D_E440							=	($03);
	REVISION_E_E440							=	($04);
	INVALID_REVISION_E440					=	($05);

	//     
	MAX_CONTROL_TABLE_LENGTH_E440			=	(128);
	ADC_INPUT_RANGES_QUANTITY_E440		=	(INVALID_ADC_INPUT_RANGE_E440);
	ADC_CALIBR_COEFS_QUANTITY_E440		=	(ADC_INPUT_RANGES_QUANTITY_E440);
	MAX_ADC_FIFO_SIZE_E440					=	($3000);			// 12288
	DAC_CHANNELS_QUANTITY_E440				=	($02);
	DAC_CALIBR_COEFS_QUANTITY_E440		=	(DAC_CHANNELS_QUANTITY_E440);
	MAX_DAC_FIFO_SIZE_E440					=	($0FC0);			// 4032
	TTL_LINES_QUANTITY_E440					=	($10);							// -  
	REVISIONS_QUANTITY_E440 				=	(INVALID_REVISION_E440);	// -  () 

	//      
	ADC_INPUT_RANGES_E440 : array [0..(ADC_INPUT_RANGES_QUANTITY_E440-1)]  of double =	( 10.0, 10.0/4.0, 10.0/16.0, 10.0/64.0 );
	//      
	DAC_OUTPUT_RANGE_E440					=	5.0;
	//   
	REVISIONS_E440 : array [0..(REVISIONS_QUANTITY_E440-1)] of char = ( 'A', 'B', 'C', 'D', 'E'  );

   
// 
type
	//      E14-440
	MODULE_DESCRIPTION_E440 = packed record
		Module 		: MODULE_INFO_LUSBAPI;		  	//    
		DevInterface	: INTERFACE_INFO_LUSBAPI;	//     
		Mcu			: MCU_INFO_LUSBAPI;				//   
		Dsp			: DSP_INFO_LUSBAPI;				//   DSP
		Adc			: ADC_INFO_LUSBAPI;				//   
		Dac			: DAC_INFO_LUSBAPI;				//   
		DigitalIo	: DIGITAL_IO_INFO_LUSBAPI;		//    -
	end;
	pMODULE_DESCRIPTION_E440 = ^MODULE_DESCRIPTION_E440;

	//       E14-440
	ADC_PARS_E440 = packed record
		IsAdcEnabled : BOOL;			  						//  /   (  )
		IsCorrectionEnabled : BOOL;						//        DSP
		InputMode : WORD;										//     
		SynchroAdType : WORD;								//   
		SynchroAdMode : WORD; 								//   
		SynchroAdChannel : WORD;  							//     
		SynchroAdPorog : SHORT;								//      
		ChannelsQuantity : WORD;							//    
		ControlTable : array [0..(MAX_CONTROL_TABLE_LENGTH_E440-1)] of WORD;	//      
		AdcRate : double;	  			  						//     
		InterKadrDelay : double;		  					//    
		KadrRate : double;									//    
		AdcFifoBaseAddress : WORD;							//   FIFO  
		AdcFifoLength : WORD;	  							//  FIFO  
		AdcOffsetCoefs : array [0..3] of double; 		//  .    
		AdcScaleCoefs : array [0..3] of double; 		//  .   
	end;
	pADC_PARS_E440 = ^ADC_PARS_E440;

	//      E14-440
	DAC_PARS_E440 = packed record
		DacEnabled : BOOL;									// /  
		DacRate : double;	  		  							//     
		DacFifoBaseAddress : WORD;  						//   FIFO  
		DacFifoLength : WORD;								//  FIFO  
	end;
	pDAC_PARS_E440 = ^DAC_PARS_E440;

//   E14-440
ILE440 = class(Lusbbase)
  public
		//     DSP 
		Function RESET_MODULE(ResetFlag : BYTE = INIT_E440) : BOOL; virtual; stdcall; abstract;
		Function LOAD_MODULE(FileName : pCHAR = nil) : BOOL; virtual; stdcall; abstract;
		Function TEST_MODULE : BOOL; virtual; stdcall; abstract;
		Function SEND_COMMAND(Command : WORD) : BOOL; virtual; stdcall; abstract;

		//     
		Function GET_ADC_PARS(ap : pADC_PARS_E440) : BOOL; virtual; stdcall; abstract;
		Function SET_ADC_PARS(ap : pADC_PARS_E440) : BOOL; virtual; stdcall; abstract;
		Function START_ADC : BOOL; virtual; stdcall; abstract;
		Function STOP_ADC : BOOL; virtual; stdcall; abstract;
		Function ADC_KADR(Data : pSHORT) : BOOL; virtual; stdcall; abstract;
		Function ADC_SAMPLE(AdcData : pSHORT; AdcChannel : WORD) : BOOL; virtual; stdcall; abstract;
		Function ReadData(ReadRequest : pIO_REQUEST_LUSBAPI) : BOOL; virtual; stdcall; abstract;

		//     
		Function GET_DAC_PARS(dm : pDAC_PARS_E440) : BOOL; virtual; stdcall; abstract;
		Function SET_DAC_PARS(dm : pDAC_PARS_E440) : BOOL; virtual; stdcall; abstract;
		Function START_DAC : BOOL; virtual; stdcall; abstract;
		Function STOP_DAC : BOOL; virtual; stdcall; abstract;
		Function WriteData(WriteRequest : pIO_REQUEST_LUSBAPI) : BOOL; virtual; stdcall; abstract;
		Function DAC_SAMPLE(DacData : pSHORT; DacChannel : WORD) : BOOL; virtual; stdcall; abstract;

		//      
		Function ENABLE_TTL_OUT(EnableTtlOut : BOOL) : BOOL; virtual; stdcall; abstract;
		Function TTL_IN(TtlIn : pWORD) : BOOL; virtual; stdcall; abstract;
		Function TTL_OUT(TtlOut : WORD) : BOOL; virtual; stdcall; abstract;

		//    
		Function ENABLE_FLASH_WRITE(EnableFlashWrite : BOOL) : BOOL; virtual; stdcall; abstract;
		Function READ_FLASH_WORD(FlashAddress : WORD; FlashWord : pSHORT) : BOOL; virtual; stdcall; abstract;
		Function WRITE_FLASH_WORD(FlashAddress : WORD; FlashWord : SHORT) : BOOL; virtual; stdcall; abstract;

		//        
		Function GET_MODULE_DESCRIPTION(ModuleDescription : pMODULE_DESCRIPTION_E440) : BOOL; virtual; stdcall; abstract;
		Function SAVE_MODULE_DESCRIPTION(ModuleDescription : pMODULE_DESCRIPTION_E440) : BOOL; virtual; stdcall; abstract;

		//      DSP
		Function PUT_LBIOS_WORD(Address : WORD; Data : SHORT) : BOOL; virtual; stdcall; abstract;
		Function GET_LBIOS_WORD(Address : WORD; Data : pSHORT) : BOOL; virtual; stdcall; abstract;
		Function PUT_DM_WORD(Address : WORD; Data : SHORT) : BOOL; virtual; stdcall; abstract;
		Function GET_DM_WORD(Address : WORD; Data : pSHORT) : BOOL; virtual; stdcall; abstract;
		Function PUT_PM_WORD(Address : WORD; Data : DWORD) : BOOL; virtual; stdcall; abstract;
		Function GET_PM_WORD(Address : WORD; Data : pDWORD) : BOOL; virtual; stdcall; abstract;
		Function PUT_DM_ARRAY(BaseAddress, NPoints : WORD; Data : pSHORT) : BOOL; virtual; stdcall; abstract;
		Function GET_DM_ARRAY(BaseAddress, NPoints : WORD; Data : pSHORT) : BOOL; virtual; stdcall; abstract;
		Function PUT_PM_ARRAY(BaseAddress, NPoints : WORD; Data : pDWORD) : BOOL; virtual; stdcall; abstract;
		Function GET_PM_ARRAY(BaseAddress, NPoints : WORD; Data : pDWORD) : BOOL; virtual; stdcall; abstract;
	end;
	pILE440 = ^ILE440;


//     E20-10
// *****************************************************************************
// ******************           E 2 0 - 1 0  *****************************
// *****************************************************************************

// 
const
	//       
	INT_ADC_START_E2010							=	($00);
	INT_ADC_START_WITH_TRANS_E2010			=	($01);
	EXT_ADC_START_ON_RISING_EDGE_E2010	 	=	($02);
	EXT_ADC_START_ON_FALLING_EDGE_E2010		=	($03);
	INVALID_ADC_START_E2010						=	($04);

	//       
	INT_ADC_CLOCK_E2010							=	($00);
	INT_ADC_CLOCK_WITH_TRANS_E2010			=	($01);
	EXT_ADC_CLOCK_ON_RISING_EDGE_E2010	 	=	($02);
	EXT_ADC_CLOCK_ON_FALLING_EDGE_E2010		=	($03);
	INVALID_ADC_CLOCK_E2010						=	($04);

	//       ( Rev.B  )
	NO_ANALOG_SYNCHRO_E2010					 		=	($00); 	//   
	ANALOG_SYNCHRO_ON_RISING_CROSSING_E2010	=	($01);	//     -
   ANALOG_SYNCHRO_ON_FALLING_CROSSING_E2010	=	($02);	//     -
	ANALOG_SYNCHRO_ON_HIGH_LEVEL_E2010			=	($03);	//     
   ANALOG_SYNCHRO_ON_LOW_LEVEL_E2010			=	($04);	//     
	INVALID_ANALOG_SYNCHRO_E2010					=	($05);

	//       E20-10
	ADC_INPUT_RANGE_3000mV_E2010				=	($00);
	ADC_INPUT_RANGE_1000mV_E2010				=	($01);
	ADC_INPUT_RANGE_300mV_E2010				=	($02);
	INVALID_ADC_INPUT_RANGE_E2010				=	($03);

	//        E20-10
	ADC_INPUT_ZERO_E2010							=	($00);
	ADC_INPUT_SIGNAL_E2010					 	=	($01);
	INVALID_ADC_INPUT_E2010						=	($02);

	//         E20-10 ( Rev.B  )
	INPUT_CURRENT_OFF_E2010						=	($00);
	INPUT_CURRENT_ON_E2010						=	($01);
	INVALID_INPUT_CURRENT_E2010				=	($02);

	//           (  Rev.A)
	CLIPPING_OVERLOAD_E2010		 				=	($00);
   MARKER_OVERLOAD_E2010		 				=	($01);
   INVALID_OVERLOAD_E2010		 				=	($02);

	//          
		//  BufferOverrun  DATA_STATE_E2010
		BUFFER_OVERRUN_E2010	 					=	($00);	//    
		//  ChannelsOverFlow  DATA_STATE_E2010
		OVERFLOW_OF_CHANNEL_1_E2010	 		=	($00);	//   
	   OVERFLOW_OF_CHANNEL_2_E2010			=	($01);	//    
	   OVERFLOW_OF_CHANNEL_3_E2010	 		=	($03);	//     
	   OVERFLOW_OF_CHANNEL_4_E2010	 		=	($04);	//   ReadData()
		OVERFLOW_E2010	 							=	($07);	//      
																		//         START_ADC()  STOP_ADC()

	//         E20-10 ( Rev.B  )
	//    TEST_MODULE()   
	NO_TEST_MODE_E2010	 						=	($00); 	//     
   TEST_MODE_1_E2010		 						=	($01); 	//  ,    START_ADC()   
																		//    : 0, 1, 2, 3, ...

	//      
	DAC_INACCESSIBLED_E2010						=	($00);
	DAC_ACCESSIBLED_E2010						=	($01);
	INVALID_DAC_OPTION_E2010					=	($02);

	//     E20-10
	REVISION_A_E2010								=	($00);
	REVISION_B_E2010								=	($01);
	INVALID_REVISION_E2010						=	($02);

	//     
	MAX_CONTROL_TABLE_LENGTH_E2010 			=	(256);
	ADC_CHANNELS_QUANTITY_E2010				=	($04);
	ADC_INPUT_RANGES_QUANTITY_E2010			=	(INVALID_ADC_INPUT_RANGE_E2010);
	ADC_INPUT_TYPES_QUANTITY_E2010			=	(INVALID_ADC_INPUT_E2010);
	ADC_CALIBR_COEFS_QUANTITY_E2010			=	(ADC_CHANNELS_QUANTITY_E2010 * ADC_INPUT_RANGES_QUANTITY_E2010);
	DAC_CHANNELS_QUANTITY_E2010				=	($02);
	DAC_CALIBR_COEFS_QUANTITY_E2010			=	(DAC_CHANNELS_QUANTITY_E2010);
	TTL_LINES_QUANTITY_E2010					=	($10);	// -     
	USER_FLASH_SIZE_E2010 						=	($200);	//      
	REVISIONS_QUANTITY_E2010 					=	(INVALID_REVISION_E2010);	// -  () 
	ADC_PLUS_OVERLOAD_MARKER_E2010			=	($5FFF);	//  ''     (  Rev.A)
	ADC_MINUS_OVERLOAD_MARKER_E2010			=	($A000);	//  ''     (  Rev.A)

	//      
	ADC_INPUT_RANGES_E2010 : array [0..(ADC_INPUT_RANGES_QUANTITY_E2010-1)]  of double =	( 3.0, 1.0, 0.3 );
	//      
	DAC_OUTPUT_RANGE_E2010	  					=	5.0;
	//   
	REVISIONS_E2010 : array [0..(REVISIONS_QUANTITY_E2010-1)] of char = ( 'A', 'B' );


// 
type
	//      E20-10
	MODULE_DESCRIPTION_E2010 = packed record
		Module 		: MODULE_INFO_LUSBAPI;		  	//    
		DevInterface	: INTERFACE_INFO_LUSBAPI;	//     
		Mcu			: MCU1_INFO_LUSBAPI;				//    ( '')
		Pld			: PLD_INFO_LUSBAPI;				//   
		Adc			: ADC_INFO_LUSBAPI;				//   
		Dac			: DAC_INFO_LUSBAPI;				//   
		DigitalIo	: DIGITAL_IO_INFO_LUSBAPI;		//    -
	end;
	pMODULE_DESCRIPTION_E2010 = ^MODULE_DESCRIPTION_E2010;

	//   
	USER_FLASH_E2010 = packed record
		Buffer : array [0..(USER_FLASH_SIZE_E2010-1)] of BYTE;
	end;
	pUSER_FLASH_E2010 = ^USER_FLASH_E2010;

	//        
	SYNCHRO_PARS_E2010 = packed record
		StartSource		: WORD;				  	//          (    ..)
		StartDelay		: DWORD;					//        c  ( Rev.B  )
		SynhroSource	: WORD;					//      (    ..)
		StopAfterNKadrs: DWORD;					//       -     ( Rev.B  )
		SynchroAdMode	: WORD;   				//   :    ( Rev.B  )
		SynchroAdChannel	: WORD;				//       ( Rev.B  )
		SynchroAdPorog		: SHORT;				//      ( Rev.B  )
		IsBlockDataMarkerEnabled : BYTE;		//     (, ,      ) ( Rev.B  )
	end;

	//       E20-10
	ADC_PARS_E2010 = packed record
		IsAdcCorrectionEnabled : BOOL;		//          ( Rev.B  )
		OverloadMode : WORD;	  					//        (  Rev.A)
		InputCurrentControl: WORD;				//     ( Rev.B  )
		SynchroPars : SYNCHRO_PARS_E2010;	//      
		ChannelsQuantity : WORD; 		//    
		ControlTable : array [0..(MAX_CONTROL_TABLE_LENGTH_E2010-1)] of WORD;	//      
		InputRange : array [0..(ADC_CHANNELS_QUANTITY_E2010-1)] of WORD;	//    : 3.0, 1.0  0.3
		InputSwitch : array [0..(ADC_CHANNELS_QUANTITY_E2010-1)] of WORD;	//     :   
		AdcRate : double;	  		 		//     
		InterKadrDelay : double; 		//    
		KadrRate : double;		 		//    
		AdcOffsetCoefs : array [0..(ADC_INPUT_RANGES_QUANTITY_E2010-1)] of array[0..(ADC_CHANNELS_QUANTITY_E2010-1)] of double;	//   	: (3 )*(4 ) ( Rev.B  )
		AdcScaleCoefs	: array [0..(ADC_INPUT_RANGES_QUANTITY_E2010-1)] of array[0..(ADC_CHANNELS_QUANTITY_E2010-1)] of double;	//    : (3 )*(4 ) ( Rev.B  )
	end;
	pADC_PARS_E2010 = ^ADC_PARS_E2010;

	//         
	DATA_STATE_E2010 = packed record
		ChannelsOverFlow : BYTE;				//         Rev.B  
		BufferOverrun : BYTE;					//      
		CurBufferFilling : DWORD;				//      Rev.B  ,  
		MaxOfBufferFilling : DWORD;			//          Rev.B  ,  
		BufferSize : DWORD;						//      Rev.B  ,  
		CurBufferFillingPercent : double;	//        Rev.B  ,  %
		MaxOfBufferFillingPercent : double;	//            Rev.B  ,  %
	end;
	pDATA_STATE_E2010 = ^DATA_STATE_E2010;

//   E20-10
ILE2010 = class(Lusbbase)
  public
		//   
		Function LOAD_MODULE(FileName : pCHAR = nil) : BOOL; virtual; stdcall; abstract;
		Function TEST_MODULE(TestModeMask : WORD = 0) : BOOL; virtual; stdcall; abstract;

		//     
		Function GET_ADC_PARS(ap : pADC_PARS_E2010) : BOOL; virtual; stdcall; abstract;
		Function SET_ADC_PARS(ap : pADC_PARS_E2010) : BOOL; virtual; stdcall; abstract;
		Function START_ADC : BOOL; virtual; stdcall; abstract;
		Function STOP_ADC : BOOL; virtual; stdcall; abstract;
		Function GET_DATA_STATE(DataState : pDATA_STATE_E2010) : BOOL; virtual; stdcall; abstract;
		Function ReadData(ReadRequest : pIO_REQUEST_LUSBAPI) : BOOL; virtual; stdcall; abstract;

		//     
		Function DAC_SAMPLE(DacData : pSHORT; DacChannel : WORD) : BOOL; virtual; stdcall; abstract;

		//      
		Function ENABLE_TTL_OUT(EnableTtlOut : BOOL) : BOOL; virtual; stdcall; abstract;
		Function TTL_IN(TtlIn : pWORD) : BOOL; virtual; stdcall; abstract;
		Function TTL_OUT(TtlOut : WORD) : BOOL; virtual; stdcall; abstract;

		//       
		Function ENABLE_FLASH_WRITE(IsUserFlashWriteEnabled : BOOL) : BOOL; virtual; stdcall; abstract;
		Function READ_FLASH_ARRAY(UserFlash : pUSER_FLASH_E2010) : BOOL; virtual; stdcall; abstract;
		Function WRITE_FLASH_ARRAY(UserFlash : pUSER_FLASH_E2010) : BOOL; virtual; stdcall; abstract;

		//        
		Function GET_MODULE_DESCRIPTION(ModuleDescription : pMODULE_DESCRIPTION_E2010) : BOOL; virtual; stdcall; abstract;
		Function SAVE_MODULE_DESCRIPTION(ModuleDescription : pMODULE_DESCRIPTION_E2010) : BOOL; virtual; stdcall; abstract;
	end;
	pILE2010 = ^ILE2010;


const
	//     Lusbapi.dll
	VERSION_MAJOR_LUSBAPI 			=	($03);
	VERSION_MINOR_LUSBAPI 			=	($02);
	CURRENT_VERSION_LUSBAPI			=	((VERSION_MAJOR_LUSBAPI shl 16) or VERSION_MINOR_LUSBAPI);

	//        USB
	USB11_LUSBAPI						=	($00);
	USB20_LUSBAPI						=	($01);
	INVALID_USB_SPEED_LUSBAPI		=	($02);

	//   -   
	MAX_VIRTUAL_SLOTS_QUANTITY_LUSBAPI	= 127;

//    Lusbapi.dll 
Function GetDllVersion : DWORD; stdcall;
Function CreateLInstance(DeviceName : PChar) : Pointer; stdcall;

Function InitLusbapiDll(const name:String='Lusbapi.dll'):Boolean;
Function FreeLusbapiDll:Boolean;

implementation

const
 dll              : THandle = 0;
 _GetDllVersion   : Function : DWORD; stdcall = nil;
 _CreateLInstance : Function(DeviceName : PChar) : Pointer; stdcall = nil;

Function GetDllVersion : DWORD;
begin
 if dll<>0 then Result:=_GetDllVersion else Result:=0;
end;

Function CreateLInstance(DeviceName : PChar) : Pointer;
begin
 if dll<>0 then Result:=_CreateLInstance(DeviceName) else Result:=nil;
end;

Function InitLusbapiDll(const name:String='Lusbapi.dll'):Boolean;
begin
 if dll = 0 then begin
  dll:=LoadLibrary(PChar(name));
  if dll <> 0 then begin
   _GetDllVersion:=GetProcAddress(dll,'GetDllVersion');
   _CreateLInstance:=GetProcAddress(dll,'CreateLInstance');
   if not Assigned(_GetDllVersion) then FreeLusbapiDll;
   if not Assigned(_CreateLInstance) then FreeLusbapiDll;
  end;
 end;
 Result:=(dll<>0); 
end;

Function FreeLusbapiDll:Boolean;
begin
 if dll<>0
 then Result:=FreeLibrary(dll)
 else Result:=True;
 dll:=0;
end;

initialization

 InitLusbapiDll;
 
finalization
 
 FreeLusbapiDll;

end.
