 //////////////////////////////////////////////////////////////////////////////
 // L-CARD E14-140 driver for CRW-DAQ: shared memory data.
 // Last release: 20101112 by Kuruakin Alexey <kouriakine@mail.ru>
 //////////////////////////////////////////////////////////////////////////////
unit E140_SHM;

{$I _sysdef}

interface

uses SysUtils, Math, Lusbapi;

const                            // Shared memory buffer:
 E140BuffFactor   = 2;           // To calculate buf.size
 E140NumBuffers   = 64;          // Number of I/O buffers
 E140BuffAdjust   = 32;          // Buf.length adjustment
 E140MinBuffLen   = 32;          // Minimal buffer length
 E140MaxBuffLen   = 1024*1024;   // Maximal buffer length
 E140HeaderSize   = 1024*16;     // Size of buffer header
 E140DefTimeout   = 1000;        // Default timeout in ms
 E140DefBufTime   = 50;          // Default buff.time, ms
 E140DefBuffLen   = E140MaxBuffLen div E140NumBuffers;

 //
 // Next record uses for shared memory buffer to transfer data.
 //
type
 PE140_SHARED_BUFFER = ^TE140_SHARED_BUFFER;
 TE140_SHARED_BUFFER = packed record
  case Integer of
   0: ( 
        Header : packed array[0..E140HeaderSize-1] of Char;
        Buffer : packed array[0..E140BuffFactor*E140MaxBuffLen*SizeOf(SmallInt)-1] of SmallInt;
       );
   1: (
        Description : MODULE_DESCRIPTION_E140;
        AdcInited   : ADC_PARS_E140;
        AdcWanted   : ADC_PARS_E140;
        AdcActual   : ADC_PARS_E140;
        LastError   : LAST_ERROR_INFO_LUSBAPI;
        StartTime   : Double;
       );
 end;

function GetE140SerialNumber(const aDescr:MODULE_DESCRIPTION_E140):AnsiString;
function GetE140Description(const aDescr:MODULE_DESCRIPTION_E140; const Prefix:AnsiString=''):AnsiString;
function GetE140AdcPars(const aAdc:ADC_PARS_E140; const Prefix:AnsiString=''):AnsiString;

implementation

function GetE140SerialNumber(const aDescr:MODULE_DESCRIPTION_E140):AnsiString;
var Buff : array[0..255] of Char;
begin
 with aDescr.Module do 
 Result:=Trim(Format('%s',[StrLCopy(Buff,@SerialNumber,SizeOf(SerialNumber))]));
end;

function GetE140Description(const aDescr:MODULE_DESCRIPTION_E140; const Prefix:AnsiString=''):AnsiString;
var
 i    : Integer; 
 Buff : array[0..255] of Char;
 procedure Add(s:AnsiString);
 begin
  if Length(Result)=0
  then Result:=Prefix+s
  else Result:=Result+#13#10+Prefix+s; 
 end;
begin
 Result:='';
 with aDescr.Module do begin
  Add(Format('Module.CompanyName = %s',[StrLCopy(Buff,@CompanyName,Sizeof(CompanyName))]));
  Add(Format('Module.DeviceName = %s',[StrLCopy(Buff,@DeviceName,SizeOf(DeviceName))]));
  Add(Format('Module.SerialNum = %s',[StrLCopy(Buff,@SerialNumber,SizeOf(SerialNumber))]));
  Add(Format('Module.Revision = %s',[Char(Revision)]));
  Add(Format('Module.Comment = %s',[StrLCopy(Buff,@Comment,SizeOf(Comment))]));
 end;
 with aDescr.DevInterface do if Active then begin
  Add(Format('DevInterface.Name = %s',[StrLCopy(Buff,@Name,Sizeof(Name))]));
  Add(Format('DevInterface.Comment = %s',[StrLCopy(Buff,@Comment,SizeOf(Comment))]));
 end;
 with aDescr.Mcu do if Active then begin
  Add(Format('Mcu.Name = %s',[StrLCopy(Buff,@Name,Sizeof(Name))]));
  Add(Format('Mcu.ClockRate = %g kHz',[ClockRate]));
  with Version do begin
   Add(Format('Mcu.Version.Version = %s',[StrLCopy(Buff,@Version,SizeOf(Version))]));
   Add(Format('Mcu.Version.Date = %s',[StrLCopy(Buff,@Date,SizeOf(Date))]));
   Add(Format('Mcu.Version.Manufacturer = %s',[StrLCopy(Buff,@Manufacturer,SizeOf(Manufacturer))]));
   Add(Format('Mcu.Version.Author = %s',[StrLCopy(Buff,@Author,SizeOf(Author))]));
   Add(Format('Mcu.Version.Comment = %s',[StrLCopy(Buff,@Comment,SizeOf(Comment))]));
  end;
  Add(Format('Mcu.Comment = %s',[StrLCopy(Buff,@Comment,SizeOf(Comment))]));
 end;
 with aDescr.Adc do if Active then begin
  Add(Format('Adc.Name = %s',[StrLCopy(Buff,@Name,Sizeof(Name))]));
  for i:=Low(OffsetCalibration) to High(OffsetCalibration) do
  if abs(OffsetCalibration[i])+abs(ScaleCalibration[i])>0 then
  Add(Format ('Adc.OffsetCalibration[%d] = %g',[i,OffsetCalibration[i]]));
  for i:=Low(OffsetCalibration) to High(OffsetCalibration) do
  if abs(OffsetCalibration[i])+abs(ScaleCalibration[i])>0 then
  Add(Format('Adc.ScaleCalibration[%d] = %g',[i,ScaleCalibration[i]]));
  Add(Format('Adc.Comment = %s',[StrLCopy(Buff,@Comment,SizeOf(Comment))]));
 end;
 with aDescr.Dac do if Active then begin
  Add(Format('Dac.Name = %s',[StrLCopy(Buff,@Name,Sizeof(Name))]));
  for i:=Low(OffsetCalibration) to High(OffsetCalibration) do
  if abs(OffsetCalibration[i])+abs(ScaleCalibration[i])>0 then
  Add(Format('Dac.OffsetCalibration[%d] = %g',[i,OffsetCalibration[i]]));
  for i:=Low(OffsetCalibration) to High(OffsetCalibration) do
  if abs(OffsetCalibration[i])+abs(ScaleCalibration[i])>0 then
  Add(Format('Dac.ScaleCalibration[%d] = %g',[i,ScaleCalibration[i]]));
  Add(Format('Dac.Comment = %s',[StrLCopy(Buff,@Comment,SizeOf(Comment))]));
 end;
 with aDescr.DigitalIo do if Active then begin
  Add(Format('DigitalIo.Name = %s',[StrLCopy(Buff,@Name,Sizeof(Name))]));
  Add(Format('DigitalIo.InLinesQuantity = %d',[InLinesQuantity]));
  Add(Format('DigitalIo.OutLinesQuantity = %d',[OutLinesQuantity]));
  Add(Format('DigitalIo.Comment = %s',[StrLCopy(Buff,@Comment,SizeOf(Comment))]));
 end;
end;

function GetE140AdcPars(const aAdc:ADC_PARS_E140; const Prefix:AnsiString):AnsiString;
var
 i : Integer; 
 procedure Add(s:AnsiString);
 begin
  if Length(Result)=0
  then Result:=Prefix+s
  else Result:=Result+#13#10+Prefix+s; 
 end;
begin
 Result:='';
 with aAdc do begin
  Add(Format('ClkSource = %d',[ClkSource]));
  Add(Format('EnableClkOutput = %d',[EnableClkOutput]));
  Add(Format('InputMode = %d',[InputMode]));
  Add(Format('SynchroAdType = %d',[SynchroAdType]));
  Add(Format('SynchroAdMode = %d',[SynchroAdMode]));
  Add(Format('SynchroAdChannel = %d',[SynchroAdChannel]));
  Add(Format('SynchroAdPorog = %d',[SynchroAdPorog]));
  Add(Format('ChannelsQuantity = %d',[ChannelsQuantity]));
  for i:=Low(ControlTable) to Min(Integer(ChannelsQuantity)-1,High(ControlTable)) do
  Add(Format('ControlTable[%d] = %d',[i,ControlTable[i]]));
  Add(Format('AdcRate = %g kHz',[AdcRate]));
  Add(Format('InterKadrDelay = %g ms',[InterKadrDelay]));
  Add(Format('KadrRate = %g kHz',[KadrRate]));
 end;
end;

end.
