#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

##########################################################
## Script to call on DAQ configuration integrity check. ##
##########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

if [ -z "$CRW_DAQ_SYS_HOME_DIR" ];    then fatal 1 "The script should be called from CRW-DAQ system only."; fi;
if [ -z "$CRW_DAQ_CONFIG_HOME_DIR" ]; then fatal 1 "The script should be called from DAQ system only."; fi;

function verify_integrity(){
 if [ -e "$PWD/checksum.md5" ]; then
  echo "VerifyIntegrity: ";
  if unix checksum > "$PWD/temp/checksum.log"; then
   cat "$PWD/temp/checksum.log";
   integrity_success_detected "$PWD: $(langstr ru "Целостность в норме." en "Integrity Check is Successful.")" \
   "$(langstr ru "см. Журнал" en "view Log")";
   true;
  else
   cat "$PWD/temp/checksum.log";
   integrity_failure_detected "$PWD: $(langstr ru "Целостность НАРУШЕНА." en "Integrity Check is Failed.")" \
   "$(langstr ru "см. Журнал" en "view Log")";
   false;
  fi;
 fi;
};

function integrity_success_detected(){
 if [ -n "$1" ] && [ -n "$2" ]; then
  tooltip text "$1" preset stdSuccess delay 15000    btn1 "$2" cmd1 "unix grun lister $PWD/temp/checksum.log";
 fi;
};

function integrity_failure_detected(){
 if [ -n "$1" ] && [ -n "$2" ]; then
  tooltip text "$1" preset stdSiren   delay 86400000 btn1 "$2" cmd1 "unix grun lister $PWD/temp/checksum.log";
 fi;
};

function tooltip(){
 if [ -n "$1" ];  then
  unix tooltip-notifier "$@";
 fi;
};

function main(){
 verify_integrity "$@";
};

main "$@";

##############
## END OF FILE
##############
