!title: ДЕМО
!busy_title: &ЗАНЯТ
!busy_color: FwStateAttention1

class: AUTO_PILOT_CLASS
!title: АВТОПИЛОТ
    state: OFF                                              !color: FwStateOKNotPhysics
    !title: ОТКЛЮЧЕН
        action: ACTIVATE
        !title: АКТИВИРОВАТЬ
        !confirm: 1
            REPORT(INFO,"doing ACTIVATE")
            if (RUN in_state ERROR) then
                do RECOVER RUN
            endif
            do START_RUN RUN
            wait(RUN)
            do START(N=10) TIMER
            move_to ON
        action: TEST_EXCLUDE
        !title: ТЕСТ_ИСКЛЮЧЕНИЕ
            REPORT(ERROR,"doing TEST_EXCLUDE")
            remove_all from PROXY_SET
        action: TEST_INCLUDE
        !title: ТЕСТ_ВКЛЮЧЕНИЕ
            REPORT(WARNING,"doing TEST_INCLUDE")
            insert LOGGER in PROXY_SET
            insert EVT_BUILDER in PROXY_SET
    state: ON                                               !color: FwStateOkPhysics
    !title: ВКЛЮЧЕН
    when (RUN not_in_state RUNNING) do X_ACTIVATE
        action: DISACTIVATE
        !title: ДЕАКТИВИРОВАТЬ
            REPORT(INFO,"doing DISACTIVATE")
            move_to OFF
        action: X_ACTIVATE
        !title: X_АКТИВИРОВАТЬ
            REPORT(INFO,"doing X_ACTIVATE")
            if (RUN in_state ERROR) then
                do RECOVER RUN
            endif
            do START_RUN RUN
            wait(RUN)
            do START(N=10) TIMER
            move_to ON

object: AUTO_PILOT is_of_class AUTO_PILOT_CLASS
            
class: RUN_TYPE_CLASS
!title: РЕЖИМ_РАБОТ
    state: TEST                                             !color: FwStateOKNotPhysics
    !title: ТЕСТОВЫЙ
        action: PHYSICS
        !title: ФИЗИЧЕСКИЕ_ИЗМЕРЕНИЯ
            do LOG LOGGER
            if (LOGGER in_state LOGGING) then
                move_to PHYSICS
            endif
            move_to TEST
    state: PHYSICS                                          !color: FwStateOkPhysics
    !title: ФИЗИЧЕСКИЙ
        action: TEST
        !title: ТЕСТОВЫЙ_РЕЖИМ
            do NOLOG LOGGER
            if (LOGGER in_state NOT_LOGGING) then
                move_to TEST
            endif
            move_to PHYSICS

object: RUN_TYPE is_of_class RUN_TYPE_CLASS            
            
class: RUN_CLASS
!title: ИЗМЕРЕНИЕ
    parameters: int NUMBER_T = 0,
                int NUMBER_P = 0,
                RUN_MODE = "DEMO"
    state: STOPPED                                          !color: FwStateOKNotPhysics
    !title: ОСТАНОВЛЕНО
        action: START_RUN
        !title: НАЧАТЬ_ИЗМЕРЕНИЕ
            set NUMBER_T = EVT_BUILDER<NUMBER_T>
            set NUMBER_P = EVT_BUILDER<NUMBER_P>
            if (not EVT_BUILDER in_state READY) then
                move_to STOPPED
            endif
            if (RUN_TYPE in_state PHYSICS) then
                do LOG LOGGER
                if (not LOGGER in_state LOGGING) then
                    move_to STOPPED
                endif
            endif
            if (LOGGER in_state LOGGING) then
                do X_OPEN_FILE LOGGER
            endif
            if (RUN_TYPE in_state PHYSICS) then
                set RUN_MODE = "PHYSICS"
                do START (TYPE="PHYSICS",NR=NUMBER_P) EVT_BUILDER
            else
                set RUN_MODE = "TEST"
                do START (TYPE="TEST",NR=NUMBER_T) EVT_BUILDER
            endif
            if (EVT_BUILDER in_state RUNNING) then
                move_to RUNNING
            endif
            move_to STOPPED
    state: RUNNING                                          !color: FwStateOkPhysics
    !title: ИДЕТ_РАБОТА
    when (EVT_BUILDER in_state ERROR) do X_SET_ERROR
        action: STOP_RUN
        !title: ОСТАНОВИТЬ_ИЗМЕРЕНИЕ
            do STOP EVT_BUILDER
            if (LOGGER in_state WRITING) then
                do X_CLOSE_FILE LOGGER
            endif
            move_to STOPPED
        action: X_SET_ERROR
        !title: X_ЗАДАТЬ_ОШИБКУ
            if (LOGGER in_state WRITING) then
                do X_CLOSE_FILE LOGGER
            endif
            move_to ERROR
    state: ERROR                                            !color: FwAlarmFatalAck
    !title: ОШИБКА
        action: RECOVER
        !title: ВОССТАНОВИТЬ
            do RECOVER EVT_BUILDER
            do STOP EVT_BUILDER
            move_to STOPPED

object: RUN is_of_class RUN_CLASS

class: LOGGER_CLASS # /associated
!title: ЖУРНАЛ
  # state: DEAD /dead_state                                 !color: FwDead
    state: NOT_LOGGING                                      !color: FwCorporateColor
    !title: БЕЗ_ЗАПИСИ
        action: LOG
        !title: ВКЛЮЧИТЬ_ЗАПИСЬ
            REPORT(INFO,"doing LOG")
            move_to LOGGING
    state: LOGGING                                          !color: FwStateOkNotPhysics
    !title: ГОТОВ_К_ЗАПИСИ
        action: NOLOG
        !title: ОТКЛЮЧИТЬ_ЗАПИСЬ
            REPORT(INFO,"doing NOLOG")
            move_to NOT_LOGGING
        action: X_OPEN_FILE
        !title: X_ОТКРЫТЬ_ФАЙЛ
            REPORT(INFO,"doing X_OPEN_FILE")
            move_to WRITING
        
    state: WRITING                                          !color: FwStateOkPhysics
    !title: ИДЕТ_ЗАПИСЬ
        action: X_CLOSE_FILE
        !title: Х_ЗАКРЫТЬ_ФАЙЛ
            REPORT(INFO,"doing X_CLOSE_FILE")
            move_to LOGGING
        
object: LOGGER is_of_class LOGGER_CLASS
        
class: EVT_BUILDER_CLASS # /associated
!title: СБОРЩИК
    parameters: int NUMBER_T = 0, int NUMBER_P = 0
  # state: DEAD /dead_state                                 !color: FwDead
    state: READY                                            !color: FwStateOKNotPhysics
    !title: ГОТОВ_К_РАБОТЕ
        action: START(TYPE, int NR)
        !title: НАЧАТЬ_ИЗМЕРЕНИЕ
            if (TYPE == "PHYSICS") then
                set NUMBER_P = NR + 1
                sleep 1
            endif
            if (TYPE == "TEST") then
                set NUMBER_T = NR + 1
                sleep 1
            endif
            move_to RUNNING
    state: RUNNING                                          !color: FwStateOkPhysics
    !title: ИДЕТ_РАБОТА
        action: STOP
        !title: ОСТАНОВИТЬ_ИЗМЕРЕНИЕ
            sleep 1
            move_to READY
    state: ERROR                                            !color: FwAlarmFatalAck
    !title: ОШИБКА
        action: RECOVER
        !title: ВОССТАНОВИТЬ
            move_to READY

object: EVT_BUILDER is_of_class EVT_BUILDER_CLASS

object: TIMER
    parameters: int NTIMES = 0
    state: OFF                                              !color: FwStateOKNotPhysics
        action: START(int N)                                !visible: 1
            set NTIMES = N
            move_to ON
    state: ON                                               !color: FwStateOKPhysics
        when ((TIMER in_state ON) and (NTIMES > 0)) do TICK
        action: STOP                                        !visible: 1
            set NTIMES = 0
            move_to OFF
        action: TICK                                        !visible: 0
            if (NTIMES > 0) then
                set NTIMES = NTIMES - 1
                sleep 1
            endif
            if (NTIMES <= 0) then
                set NTIMES = 0
                do X_SET_ERROR RUN
                move_to OFF
            endif

objectset: PROXY_SET is_of_class VOID {LOGGER,EVT_BUILDER}
objectset: LOGIC_SET is_of_class VOID {AUTO_PILOT,RUN_TYPE,RUN}
