 {
 ***********************************************************************
 DEMO_SHM main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @MenuToolsOpen - open Menu Tools dialog.
|********************************************************
[]
 }
program demo_shm_main_ctrl;       { DEMO_SHM main control program   }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SmilePeriod = 1000;             { Polling period for smile face    }
 AwakePeriod = 100;              { Period of checks to awake DatSrv }
 {$I shm_block_wave.inc}         { Shared Memory Block - WAVE       }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 TDEMO_SHMMainRec = record       { Main control & GUI               }
  CMD    : record                { Commands to control GUI          }
   OPEN  : TTagRef;              { Open DAT file(s)                 }
   SAVE  : TTagRef;              { Save DAT file(s)                 }
   SOUND : TTagRef;              { Sound menu                       }
   SMILE : TTagRef;              { Smile menu                       }
   CLOSE : TTagRef;              { Close DAQ/CRW/WIN                }
  end;                           {                                  }
 end;                            {                                  }
 TDEMO_SHMWaveRec = record       { Wave simulator                   }
  STARTED   : TTagRef;           {                                  }
  FREQUENCY : TTagRef;           {                                  }
  AMPLITUDE : TTagRef;           {                                  }
  NOISE     : TTagRef;           {                                  }
  SIN       : TTagRef;           {                                  }
  COS       : TTagRef;           {                                  }
 end;                            {                                  }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 DEMO_SHM    : record            { All DEMO_SHM data                }
  MAIN       : TDEMO_SHMMainRec; { Main control & GUI               }
  WAVE       : TDEMO_SHMWaveRec; { Wave simulator                   }
  AwokeTime  : Real;             { Time when DatSrv last awoke      }
  DatSrvGate : TTagRef;          { Save data to DatSrv              }
 end;                            {                                  }
 cmd_MenuToolsOpen : Integer;    { @MenuToolsOpen                   }
 ShmLastRefreshTime : Real;      {                                  }
 shm         : Integer;          { Shared memory block              }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {
 Shared memory routines.
 }
 function ShmName:String;
 begin
  ShmName:='DEMO_SHM_WAVE';
 end;
 function ShmClientExe(Mode:Integer):String;
 const ClientExe='DEMO_SHM_CLIENT.EXE';
 begin
  if HasFlags(Mode,1)
  then ShmClientExe:=AdaptExeFileName(ClientExe)
  else ShmClientExe:=ParamStr('FileSearch '+AdaptExeFileName(ClientExe));
 end;
 procedure ShmClear;
 begin
  shm:=0;
 end;
 procedure ShmInit;
 begin
  shm:=shm_init(ShmName,sz_WAVE,0);
  if (shm_ref(shm)<>0) then begin
   writeln(Trim(shm_ctrl(shm,'?')));
  end;
 end;
 procedure ShmFree;
 begin
  FreeAndZero(shm);
 end;
 // Refresh tags from/to shared memory
 procedure ShmRefreshTags;
 var IoCounter1,IoCounter2,Started,itmp:Integer; wSin,wCos,rtmp:Real;
     dirty:Boolean; sv,stmp,sample:String;
 begin
  sv:=''; sample:=''; stmp:='';
  if (shm<>0) then begin
   sample:=dump(0.0);
   // Write tags to Shared Memory
   if ShouldRefresh(ShmLastRefreshTime,Int(SecNow))
     +ShouldRefresh(DEMO_SHM.WAVE.STARTED.val,GetStampOfTag(DEMO_SHM.WAVE.STARTED.tag,0))
     +ShouldRefresh(DEMO_SHM.WAVE.FREQUENCY.val,GetStampOfTag(DEMO_SHM.WAVE.FREQUENCY.tag,0))
     +ShouldRefresh(DEMO_SHM.WAVE.AMPLITUDE.val,GetStampOfTag(DEMO_SHM.WAVE.AMPLITUDE.tag,0))
     +ShouldRefresh(DEMO_SHM.WAVE.NOISE.val,GetStampOfTag(DEMO_SHM.WAVE.NOISE.tag,0))>0
   then begin
    sv:=dump(rGetTag(DEMO_SHM.WAVE.NOISE.tag));
    itmp:=shm_iop(shm,of_IOCOUNTER,'+',1); // Notify begin updates
    itmp:=shm_iop(shm,of_STARTED,'w',iGetTag(DEMO_SHM.WAVE.STARTED.tag));
    rtmp:=shm_rop(shm,of_FREQUENCY,'w',rGetTag(DEMO_SHM.WAVE.FREQUENCY.tag));
    rtmp:=shm_rop(shm,of_AMPLITUDE,'w',rGetTag(DEMO_SHM.WAVE.AMPLITUDE.tag));
    stmp:=shm_sop(shm,of_NOISE,'w',sv); // Write as string dump (just for test)
    itmp:=shm_iop(shm,of_IOCOUNTER,'+',1); // Notify end updates
   end;
   // Preparing...
                                   // Data sample need to set data size
   // Read tags from Shared Memory
   IoCounter1:=shm_iop(shm,of_IOCOUNTER,'+',0); // Read IO Counter BEFORE read
   wSin:=shm_rop(shm,of_SIN,'r',0);             // Read SIN as real (double)
   sv:=shm_sop(shm,of_COS,'r',sample);          // Read COS as string dump (just for test)
   wCos:=dump2r(sv);                            // Extract COS from string dump
   IoCounter2:=shm_iop(shm,of_IOCOUNTER,'+',0); // Read IO Counter AFTER read
   dirty:=(IoCounter1<>IoCounter2);             // Data updated during read
   dirty:=dirty or Odd(IoCounter1);             // Client write during read
   started:=iGetTag(DEMO_SHM.WAVE.STARTED.tag); // 1/0/-1=ON/OFF/EXIT
   if (started>0) and not dirty then begin      // Skip "dirty" data
    bNul(rSetTag(DEMO_SHM.WAVE.SIN.tag,wSin));  // Write shared data to tag
    bNul(rSetTag(DEMO_SHM.WAVE.COS.tag,wCos));  // Write shared data to tag
    UpdateAo(0,time,wSin);                      // And to curves
    UpdateAo(1,time,wCos);                      // And to curves
   end;
  end;
  sv:=''; sample:=''; stmp:='';
 end;
 // Start demo_shm_client
 procedure ShmStartWave;
 var cmd:String;
 begin
  cmd:=ShmClientExe(0);
  if (cmd<>'') then begin
   if IsWindows then begin
    cmd:='@system @async @run cmd /c title '+ShmName+'&'
      +'color 0A&mode con: cols=40 lines=25&'
      +'unix movewindow '+ShmName+' 410 120&'
      +'unix setclosemenu -d&'
      +cmd+' '+ShmName;
   end;
   if IsUnix then begin
    cmd:='@system @async @run xterm -fa "PT Mono" -fs 12 -geometry 40x40+410+100 -e '
      +cmd+' '+ShmName; 
   end;
   rNul(eval(cmd));
  end;
  cmd:='';
 end;
 // Stop demo_shm_client
 procedure ShmStopWave;
 var cmd:String;
 begin
  cmd:='';
  if IsWindows then begin
   cmd:='@system @async @run -sw7 cmd /c title Stop: '+ShmClientExe(1)+'&'
                    +' unix closewindow '+ShmName+' ConsoleWindowClass &'
                    +' unix sleep 1 & taskkill /f /im '+ShmClientExe(1);
  end;
  if IsUnix then begin
   cmd:='@system @async @run pkill '+ShmClientExe(1);
  end; 
  rNul(eval(cmd));
  cmd:='';
 end;
 // Check shared memory IO result
 procedure ShmCheckIo;
 var code:Integer;
 begin
  code:=shm_ioresult(0);
  if (code<>0) then Trouble('SHM Error '+Str(code));
 end;
 procedure ShmPoll;
 begin
  ShmCheckIo;
  ShmRefreshTags;
 end;
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Initilize DEMO_SHM.MAIN record tags
 }
 procedure TDEMO_SHMMainRec_Init(var Rec:TDEMO_SHMMainRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.CMD.OPEN.tag,  TagPrefix+'.CMD.OPEN',  1);
   InitTag(Rec.CMD.SAVE.tag,  TagPrefix+'.CMD.SAVE',  1);
   InitTag(Rec.CMD.SOUND.tag, TagPrefix+'.CMD.SOUND', 1);
   InitTag(Rec.CMD.SMILE.tag, TagPrefix+'.CMD.SMILE', 1);
   InitTag(Rec.CMD.CLOSE.tag, TagPrefix+'.CMD.CLOSE', 1);
   Rec.CMD.SMILE.val:=GetErrCount(-2);
  end;
 end;
 {
 Initilize DEMO_SHM.WAVE record tags
 }
 procedure TDEMO_SHMWaveRec_Init(var Rec:TDEMO_SHMWaveRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.STARTED.tag,   TagPrefix+'.STARTED',   1);
   InitTag(Rec.FREQUENCY.tag, TagPrefix+'.FREQUENCY', 2);
   InitTag(Rec.AMPLITUDE.tag, TagPrefix+'.AMPLITUDE', 2);
   InitTag(Rec.NOISE.tag,     TagPrefix+'.NOISE',     2);
   InitTag(Rec.SIN.tag,       TagPrefix+'.SIN',       2);
   InitTag(Rec.COS.tag,       TagPrefix+'.COS',       2);
   Rec.STARTED.val:=MaxReal;
   Rec.FREQUENCY.val:=MaxReal;
   Rec.AMPLITUDE.val:=MaxReal;
   Rec.NOISE.val:=MaxReal;
   Rec.SIN.val:=0;
   Rec.COS.val:=0;
  end;
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,15000);
 end;
 {
 Menu CLOSE Starter to start editing.
 }
 procedure MenuCloseStarter;
 var i,n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Закрыть"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Продолжить работу текущего сеанса АСУ');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@tooltip text "Желаю успешной работы" preset stdNotify delay 15000');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и закрыть программу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Crw Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и продолжить работу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить сеанс АСУ и начать заново');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Restart');
   //////////////////////////////////////////
   for i:=1 to WordCount(EditGetWellKnownDevices(DevName)) do
   if (RefFind('device '+ExtractWord(i,EditGetWellKnownDevices(DevName)))<>0) then begin
    n:=n+EditAddInputLn('Перезапустить сервер '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
    n:=n+EditAddConfirm(EditGetLastInputLn);
    n:=n+EditAddCommand('@SysEval @Daq Compile '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
   end;
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс Windows');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Logout');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Restart');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Выключить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Exit');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 530 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CLOSE'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu CLOSE Handler to handle editing.
 }
 procedure MenuCloseHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_CLOSE'));
 end;
 {
 Menu TOOLS Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Загрузить параметры из INI файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@LoadIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сохранить параметры в  INI файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SaveIni');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 375 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu TOOLS Handler to handle editing.
 }
 procedure MenuToolsHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
 end;
 {
 Awake DatSrv to enforce data save.
 }
 procedure AwakeDatSrv;
 begin
  DEMO_SHM.AwokeTime:=mSecNow;
  DevPostCmd(devDatSrv,'  ');
 end;
 {
 DEMO_SHM clear strings
 }
 procedure DEMO_SHM_CLEAR;
 begin
  ShmClear;
 end;
 {
 DEMO_SHM initialization
 }
 procedure DEMO_SHM_INIT;
 begin
  //
  // Initialize tags & devices...
  //
  TDEMO_SHMMainRec_Init(DEMO_SHM.MAIN,ReadIni('tagDEMO_SHM')+'.MAIN');
  TDEMO_SHMWaveRec_Init(DEMO_SHM.WAVE,ReadIni('tagDEMO_SHM')+'.WAVE');
  InitTag(DEMO_SHM.DatSrvGate.tag,'DATSRV.GATE',-1);
  //
  // Initialize values...
  //
  DEMO_SHM.AwokeTime:=0;
  DEMO_SHM.WAVE.STARTED.dat:=iGetTag(DEMO_SHM.WAVE.STARTED.tag);
  //
  // Init SharedMemory block.
  //
  ShmInit;
  //
  // Test
  //
  Success('ProgramSource = '+ReadIniVar('ProgramSource',4+8+16));
  Success('ProgramSource = '+ReadIniStr(4+8+16,ParamStr('DaqConfigFile'),'['+DevName+']','ProgramSource'));
 end;
 {
 DEMO_SHM finalization
 }
 procedure DEMO_SHM_FREE;
 begin
  ShmFree;
 end;
 {
 DEMO_SHM polling
 }
 procedure DEMO_SHM_POLL;
 var s:String; ClickCurve:Integer; nerrors:Real;
  procedure Cleanup;
  begin
   s:=''; ClickCurve:=0;
  end;
 begin
  Cleanup;
  {
  Shared memory polling.
  }
  ShmPoll;
  {
  Start/stop Wave
  }
  if ShouldRefresh(DEMO_SHM.WAVE.STARTED.dat,iGetTag(DEMO_SHM.WAVE.STARTED.tag))>0 then begin
   if (DEMO_SHM.WAVE.STARTED.dat>0) then ShmStartWave else ShmStopWave;
  end;
  {
  Awake DatSrv to enforce data save.
  }
  if (SysTimer_Pulse(AwakePeriod)>0) then bNul(iSetTag(DEMO_SHM.DatSrvGate.tag,Ord(iGetTag(DEMO_SHM.MAIN.CMD.SAVE.tag)<>0)));
  {
  Execute GUI commands
  }
  if (iGetTag(DEMO_SHM.MAIN.CMD.OPEN.tag)<>0) then begin
   Cron('@FileOpenDialog '+URL_Packed(AddBackSlash(DaqFileRef(ReadIni('['+DatSrv+'] DataPath'),''))+'*.dat;*.crw'));
   bNul(iSetTag(DEMO_SHM.MAIN.CMD.OPEN.tag,0));
  end;
  if (iGetTag(DEMO_SHM.MAIN.CMD.CLOSE.tag)<>0) then begin
   bNul(iSetTag(DEMO_SHM.MAIN.CMD.CLOSE.tag,0));
   MenuCloseStarter;
  end;
  {
  Handle Smile button state
  }
  if (SysTimer_Pulse(SmilePeriod)>0) then begin
   nerrors:=GetErrCount(-2);
   if nerrors>DEMO_SHM.MAIN.CMD.SMILE.val then bNul(iSetTag(DEMO_SHM.MAIN.CMD.SMILE.tag,2)) else
   if iGetTag(DEMO_SHM.MAIN.CMD.SMILE.tag)>1 then bNul(iSetTag(DEMO_SHM.MAIN.CMD.SMILE.tag,1));
   DEMO_SHM.MAIN.CMD.SMILE.val:=nerrors;
  end;
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Menu CLOSE.
   }
   MenuCloseHandler;
   {
   Menu TOOLS.
   }
   MenuToolsHandler;
   {
   Warning, Information dialog completion.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
   {
   Accept edit tags.
   }
   CheckEditTagUpdate(DEMO_SHM.WAVE.AMPLITUDE.tag,-100,100);
   CheckEditTagUpdate(DEMO_SHM.WAVE.FREQUENCY.tag,1e-6,100);
   CheckEditTagUpdate(DEMO_SHM.WAVE.NOISE.tag,-100,100);
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     //
     // Toolbar buttons...
     //
     ClickBitXorLocal(DEMO_SHM.WAVE.STARTED.tag,1);
     ClickBitXorLocal(DEMO_SHM.MAIN.CMD.OPEN.tag,1);
     ClickBitXorLocal(DEMO_SHM.MAIN.CMD.SAVE.tag,1);
     ClickBitXorLocal(DEMO_SHM.MAIN.CMD.SOUND.tag,1);
     ClickBitXorLocal(DEMO_SHM.MAIN.CMD.CLOSE.tag,1);
     if (ClickTag=DEMO_SHM.MAIN.CMD.SAVE.tag) then begin
      bNul(iSetTag(DEMO_SHM.DatSrvGate.tag,Ord(iGetTag(DEMO_SHM.MAIN.CMD.SAVE.tag)<>0)));
      if iGetTag(DEMO_SHM.MAIN.CMD.SAVE.tag)<>0 then AwakeDatSrv;
     end;
     if IsSameText(ClickSensor,'DEMO_SHM.MAIN.CMD.HOME') then begin
      DevPostCmdLocal('@Cron @Cron.Run DEMO_SHM.MAIN.CTRL.HOME');
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'DEMO_SHM.MAIN.CMD.HELP') then begin
      DevPostCmdLocal('@BrowseHelp');
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'DEMO_SHM.MAIN.CMD.TOOLS') then begin
      DevPostCmdLocal('@MenuToolsOpen');
      bNul(Voice(snd_Click));
     end;
     //
     // Start edit tags...
     //
     if (ClickTag=DEMO_SHM.WAVE.AMPLITUDE.tag) then begin
      StartEditTag(ClickTag,'Wave Amplitude');
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DEMO_SHM.WAVE.FREQUENCY.tag) then begin
      StartEditTag(ClickTag,'Wave Frequency, Hz');
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DEMO_SHM.WAVE.NOISE.tag) then begin
      StartEditTag(ClickTag,'Wave Noise');
      bNul(Voice(snd_Click));
     end;
     //
     // Smile face button...
     //
     if (ClickTag=DEMO_SHM.MAIN.CMD.SMILE.tag) then begin
      bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
      bNul(iSetTag(DEMO_SHM.MAIN.CMD.SMILE.tag,0));
      bNul(Voice(snd_Click));
     end;
     //
     // Select Plot & Tab windows by curve...
     //
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     //
     // Console commands: @url_encoded_sensor ...
     //
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
     //
     // Calibrations
     //
     if IsSameText(ExtractFileExt(ClickSensor),'.CAL') then begin
      bNul(CalibrOpenByCurve(RefFind('Curve '+ExtractFileName(ClickSensor))));
      bNul(Voice(snd_Click));
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
  Cleanup;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  DEMO_SHM_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  DEMO_SHM_INIT;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then DevPostCmdLocal('@LoadIni');
  cmd_MenuToolsOpen := RegisterStdInCmd('@MenuToolsOpen', '');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then DevPostCmdLocal('@SaveIni');
  DEMO_SHM_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  DEMO_SHM_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
  procedure Cleanup;
  begin
   cmd:=''; arg:='';
  end;
 begin
  Cleanup;
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @MenuToolsOpen
   }
   if (cmdid=cmd_MenuToolsOpen) then begin
    MenuToolsStarter;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  Cleanup;
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
