﻿# Справка по системе SCE.BACC.BSTR.VACS

---

**SCE.BACC.BSTR.VACS**{.maroon} - Вакуумная система Бустера Синхротронного Комплекса

**SCE.BACC.BSTR.VACS**{.maroon} ==> [Synchrotron Complex Experimental].[Booster Accelerator].[Booster].[Vacuum System]

---

Документация:
**[Worksheet/](worksheet/)**  
**[SMI](../../../../resource/smisite/readme.htm)** - State Manager Interface  
**[DIM](../../../../resource/dimsite/readme.htm)** - Distrubuted Information Manager System

---

Возможности системы:

1. Управление вакуумной системой бустерного ускорителя на основе Конечных Автоматов (**FSM - Finite State Machine**);
2. Управление насосами и вакуумной арматурой (вентилями, клапанами и т.д.);
3. Измерение уровня давления вакуума с помощью датчиков вакуума;
4. Протоколирование результатов измерений.

Система управления вакуумом бустера основана на технологии **SMI** и использует библиотеку **SmiProxy**,
которая берет на себя всю рутину по запуску сервера, приемо-передаче данных и т.д.
**SMI** базируется на технологии **[DIM](../../../../resource/dimsite/readme.htm)**
как на коммуникационной технологии для передачи сообщений.  
Графический интерфейс пользователя использует библиотечный модуль **SmiuiSrv** в котором реализованы функции для работы
с распределенными Конечными Автоматами (**FSM**).

В качестве исходного файла для создания конфигурации системы управления вакуумом бустера на основе Конечных Автоматов
(**FSM - Finite State Machine**) служит файл **sce_bacc_bstr_vacs.sml**, написанный на языке **SML (State Manager Language)**.
Для генерации конфигурационных файлов **CFG** и файлов описания мнемосхем **CRC** используется утилита **SmiGenGUI.lm9**.
В утилите **SmiGenGUI**, на вкладке **SML** задается имя **SML-файла**, затем (на вкладке **DAQ**) выполняется разбор файла (**Parse SML**).
При этом заполняются списки обнаруженных обьектов (objects), параметров (parameters) и наборов объектов (objectsets).
Надо выбрать (select) те из них, которые войдут в конфигурацию. При этом также можно указать главный (main) и ведущий (lead) объект.
Затем на вкладке параметров (parameters) нужно задать параметры генератора - префикс тегов, имя устройства - обработчика GUI,
имя окна, параметры шрифтов, геометрические параметры кнопок и полей. После этого можно выполнить генерцию конфиграции (**Make CFG**)
и мнемосхем (**Make CRC**), и сохранить их в файл.

Система включает в себя серверную часть **!sce_bacc_bstr_vacs_server.cfg**, загружаемую по умолчанию и работающую с аппаратурой.
И клиентскую часть **!sce_bacc_bstr_vacs_client.cfg**, которая реализует удаленного клиента с возможностью управления системой
используя общий с сервером графический пользовательский интерфейс.

Список **объектов FSM** вакуумной системы бустера:
- **SCE_BACC_BSTR_VACS::VACS** - Вакуумная система (главный объект)
- **SCE_BACC_BSTR_VACS::SEC1** - Вакуумная секция 1
- **SCE_BACC_BSTR_VACS::SEC2** - Вакуумная секция 2
- **SCE_BACC_BSTR_VACS::SEC3** - Вакуумная секция 3
- **SCE_BACC_BSTR_VACS::SEC4** - Вакуумная секция 4
- **SCE_BACC_BSTR_VACS::SEC5** - Вакуумная секция 5
- **SCE_BACC_BSTR_VACS::SEC6** - Вакуумная секция 6

### Список состояний **FSM** вакуумной системы бустера:
**Состояния** главного объекта:
```
   OFF     - Вакуумная система выключена
   STANDBY - Вакуумная система в режиме ожидания
   MIXED   - Вакуумные секции имеют разные состояния
   MANUAL  - Вакуумная система в режиме ручного управления
   PUMPING - Вакуумная система в режиме откачки вакуума
   READY   - Вакуумная система готова к работе (вакуум откачан, секции открыты)
   WARNING - Вакуумная система в режиме предупреждения (плохой вакуум и прочее)
   ERROR   - Вакуумная система в режиме ошибки (плохой вакуум, неисправность оборудования и прочее)
```

**Состояния** вакуумных секций:
```
   DEAD    - Процесс, связанный с объектом прерван или не выполняется
   OFF     - Вакуумная секция выключена (питание с исполнительных устройств снято)
   STANDBY - Вакуумная секция в режиме ожидания (питание исполнительных устройств включено)
   MANUAL  - Вакуумная секция в режиме ручного управления
   PUMPING - Вакуумная секция в режиме откачки вакуума
   READY   - Вакуумная секция готова к работе (вакуум откачан, секция открыта)
   WARNING - Вакуумная секция в режиме предупреждения (плохой вакуум и прочее)
   ERROR   - Вакуумная секция в режиме ошибки (плохой вакуум, неисправность оборудования и прочее)
```

---

## Список сокращений и аббревиатур

---

Для именования кривых, тегов, сенсоров, окон и других программных объектов используются следующие **соглашения о наименовании**:

```
   Все имена  - составные (состоят из частей).
   Части имен тегов, кривых разделяются точкой:     СИСТЕМА.ПОДСИСТЕМА.ПОДСИСТЕМА.ПАРАМЕТР
   Части имен DIM сервисов разделяются слешем (/):  СИСТЕМА/ПОДСИСТЕМА/ПОДСИСТЕМА/ПАРАМЕТР
   Части имен файлов разделяются подчеркиванием (_): система_подсистема_подсистема_параметр.расширение
   Например: тег            SCE.BACC.BSTR.VACS.SEC1.PS2.MBAR
             DIM сервис     SCE/BACC/BSTR/VACS/SEC2/PS2/MBAR
             файл           smi_sce_bacc_bstr_vacs_sml.cfg
    
   СИСТЕМА:
    SCE                 Synchrotron Complex Experimental (СКИ = Синхротронный Комплекс Испытательный)
    SMI                 State Manager Interface (менеджер Конечных Автоматов)
    
   ПОДСИСТЕМЫ:
    BACC                Booster Accelerator (Бустерный Ускоритель)
    BSTR                Booster (Бустер)
    VACS                Vacuum System (Вакуумная система)
    SEC1                Section 1 (Секция 1)
    SEC2                Section 2 (Секция 2)
    SEC3                Section 3 (Секция 3)
    SEC4                Section 4 (Секция 4)
    SEC5                Section 5 (Секция 5)
    SEC6                Section 6 (Секция 6)
    FSM                 Finite State Machine (Конечный Автомат)
    SML                 State Manager Language (язык описания Конечных Автоматов)
    
   ПАРАМЕТРЫ:
    BT                  Button (Кнопка)
    MBAR                millibar (давление в миллибарах)
    VPn                 Вентиль номер n
    NMn                 Насос  магниторазрядный (ионный) номер n
    NGn                 Насос сублимационный испаритально геттерный номер n
    PSn                 Датчик вакуума номер n
    CLOCK               Время по часам сервера
    DATETIME            Время по часам сервера
    HOSTNAME            Имя сервера (сетевое имя компьютера)
    SERVID              Имя DIM сервера вида pid@hostname
    NORMPS              Рабочий порог вакуума
    WARNPS              Предупредительный порог вакуума
    FAILPS              Аварийный порог вакуума
    ObjectName          Имя       объекта FSM (прокси)
    StateName           Состояние объекта FSM (прокси)
    OBJECT_NAME         Имя       объекта FSM (реальное)
    OBJECT_TITLE        Имя       объекта FSM (отображаемое)
    OBJECT_PARAM        Параметры объекта FSM (список имен и значений)
    STATE_NAME          Состояние объекта FSM (реальное)
    STATE_TITLE         Состояние объекта FSM (отображаемое)
    BUSY_ACTION         Выполняемое действие объекта FSM
    
   Например:
    SCE.BACC.BSTR.VACS.SEC1.VP1.BT - кнопка вентиля VP1 вакуумной системы бустера в бустерном ускорителе комплекса СКИ
```

---

**SCE.BACC.BSTR.VACS** Copyright © 2001-2024 DaqGroup <daqgroup@mail.ru>.  
**CRW-DAQ** Copyright © 2001-2024 Alexey Kuryakin <daqgroup@mail.ru>.

---
