///////////////////////////////////////////////////////////////////// BSTR types:
 TButtonRec = record BT:TTagRef; end;                              // Button
 TStatusRec = record ST:TTagRef; end;                              // Status
 TButStaRec = record BT,ST:TTagRef; end;                           // Button and status
 TPowerRec  = record BT,PW:TTagRef; end;                           // Button and power
 TBtStPwRec = record BT,ST,PW:TTagRef; end;                        // Button,status and power
 TValvesRec = record BT:TTagRef; OPEN,CLOS:Real; end;              // Valves button and open/close time
 TPumpsRec  = record BT,ST,PW:TTagRef; SBIT,EBIT:Integer; end;     // Pumps  button,status,power and speed/error bit number
 TUnitsRec  = record MBAR:TTagRef; end;                            // Measuring unit: millibar
/////////////////////////////////////////////////////////////////////
 TVACSRec = record               { All VACS data:                   }
  SERVID  : TTagRef;             {  Server Identifier pid@hostname  }
  CLOCK   : TTagRef;             {  Server Date-Time                }
  SelfId  : String;              {  Self pid@hostname               }
  SEC1    : record               {  Section 1:                      }
   VP1    : TButtonRec;          {                                  }
   VP2    : TButtonRec;          {                                  }
   NG1    : TButtonRec;          {                                  }
   NG2    : TButtonRec;          {                                  }
   NG3    : TButtonRec;          {                                  }
   NM1    : TButtonRec;          {                                  }
   NM2    : TButtonRec;          {                                  }
   NM3    : TButtonRec;          {                                  }
   NM4    : TButtonRec;          {                                  }
   PS1    : TUnitsRec;           {                                  }
   NORMPS : TTagRef;             {                                  }
   WARNPS : TTagRef;             {                                  }
   FAILPS : TTagRef;             {                                  }
  end;                           {                                  }
  SEC2    : record               {  Section 2:                      }
   VP3    : TButtonRec;          {                                  }
   VP4    : TButtonRec;          {                                  }
   NG4    : TButtonRec;          {                                  }
   NG5    : TButtonRec;          {                                  }
   NG6    : TButtonRec;          {                                  }
   NG7    : TButtonRec;          {                                  }
   NM5    : TButtonRec;          {                                  }
   NM6    : TButtonRec;          {                                  }
   NM7    : TButtonRec;          {                                  }
   NM8    : TButtonRec;          {                                  }
   PS2    : TUnitsRec;           {                                  }
   NORMPS : TTagRef;             {                                  }
   WARNPS : TTagRef;             {                                  }
   FAILPS : TTagRef;             {                                  }
  end;                           {                                  }
  SEC3    : record               {  Section 3:                      }
   VP5    : TButtonRec;          {                                  }
   VP6    : TButtonRec;          {                                  }
   NG8    : TButtonRec;          {                                  }
   NG9    : TButtonRec;          {                                  }
   NG10   : TButtonRec;          {                                  }
   NM9    : TButtonRec;          {                                  }
   NM10   : TButtonRec;          {                                  }
   NM11   : TButtonRec;          {                                  }
   NM12   : TButtonRec;          {                                  }
   PS3    : TUnitsRec;           {                                  }
   NORMPS : TTagRef;             {                                  }
   WARNPS : TTagRef;             {                                  }
   FAILPS : TTagRef;             {                                  }
  end;                           {                                  }
  SEC4    : record               {  Section 4:                      }
   VP8    : TButtonRec;          {                                  }
   VP9    : TButtonRec;          {                                  }
   NG11   : TButtonRec;          {                                  }
   NG12   : TButtonRec;          {                                  }
   NG13   : TButtonRec;          {                                  }
   NM13   : TButtonRec;          {                                  }
   NM14   : TButtonRec;          {                                  }
   NM15   : TButtonRec;          {                                  }
   NM16   : TButtonRec;          {                                  }
   PS4    : TUnitsRec;           {                                  }
   NORMPS : TTagRef;             {                                  }
   WARNPS : TTagRef;             {                                  }
   FAILPS : TTagRef;             {                                  }
  end;                           {                                  }
  SEC5    : record               {  Section 5:                      }
   VP10   : TButtonRec;          {                                  }
   VP11   : TButtonRec;          {                                  }
   NG14   : TButtonRec;          {                                  }
   NG15   : TButtonRec;          {                                  }
   NG16   : TButtonRec;          {                                  }
   NG17   : TButtonRec;          {                                  }
   NM17   : TButtonRec;          {                                  }
   NM18   : TButtonRec;          {                                  }
   NM19   : TButtonRec;          {                                  }
   NM20   : TButtonRec;          {                                  }
   PS5    : TUnitsRec;           {                                  }
   NORMPS : TTagRef;             {                                  }
   WARNPS : TTagRef;             {                                  }
   FAILPS : TTagRef;             {                                  }
  end;                           {                                  }
  SEC6    : record               {  Section 6:                      }
   VP12   : TButtonRec;          {                                  }
   VP13   : TButtonRec;          {                                  }
   NG18   : TButtonRec;          {                                  }
   NG19   : TButtonRec;          {                                  }
   NG20   : TButtonRec;          {                                  }
   NM21   : TButtonRec;          {                                  }
   NM22   : TButtonRec;          {                                  }
   NM23   : TButtonRec;          {                                  }
   NM24   : TButtonRec;          {                                  }
   PS6    : TUnitsRec;           {                                  }
   NORMPS : TTagRef;             {                                  }
   WARNPS : TTagRef;             {                                  }
   FAILPS : TTagRef;             {                                  }
  end;                           {                                  }
  ECOL    : record               {                                  }
   VP7    : TButtonRec;          {                                  }
  end;                           {                                  }
 end;                            {                                  }
/////////////////////////////////////////////////////////////////////
 TBSTRRec = record               { All BSTR data                    }
  VACS    : TVACSRec;            { All VACS data                    }
 end;                            {                                  }
/////////////////////////////////////////////////////////////////////