 {
 ***********************************************************************
 Daq Pascal application program sce_bacc_bstr_vacs.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @AssignTag t v - Assign tag t to value v
| @DimTagUpdate  - Update tag from DIM
| @EditParams    - Show edit parameters dialog
| @Edit s        - Start edit tag s
| @SimulateSmallLeak n - simulate small leak in section n
| @SimulateLargeLeak n - simulate large leak in section n
|********************************************************
[]
 }
program sce_bacc_bstr_vacs;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_SmiuiSrv}              { Include SmiuiSrv     constants   }
 {$I sce_bacc_bstr_vacs_const}   { Include all BSTR VACS constants  }
 ao_VACS_SEC1_PS1_MBAR = 0;      { Analog outputs:                  }
 ao_VACS_SEC2_PS2_MBAR = 1;      {                                  }
 ao_VACS_SEC3_PS3_MBAR = 2;      {                                  }
 ao_VACS_SEC4_PS4_MBAR = 3;      {                                  }
 ao_VACS_SEC5_PS5_MBAR = 4;      {                                  }
 ao_VACS_SEC6_PS6_MBAR = 5;      {                                  }
 ao_VACS_SEC1_NORMPS   = 6;      {                                  }
 ao_VACS_SEC2_NORMPS   = 7;      {                                  }
 ao_VACS_SEC3_NORMPS   = 8;      {                                  }
 ao_VACS_SEC4_NORMPS   = 9;      {                                  }
 ao_VACS_SEC5_NORMPS   = 10;     {                                  }
 ao_VACS_SEC6_NORMPS   = 11;     {                                  }
 ao_VACS_SEC1_WARNPS   = 12;     {                                  }
 ao_VACS_SEC2_WARNPS   = 13;     {                                  }
 ao_VACS_SEC3_WARNPS   = 14;     {                                  }
 ao_VACS_SEC4_WARNPS   = 15;     {                                  }
 ao_VACS_SEC5_WARNPS   = 16;     {                                  }
 ao_VACS_SEC6_WARNPS   = 17;     {                                  }
 ao_VACS_SEC1_FAILPS   = 18;     {                                  }
 ao_VACS_SEC2_FAILPS   = 19;     {                                  }
 ao_VACS_SEC3_FAILPS   = 20;     {                                  }
 ao_VACS_SEC4_FAILPS   = 21;     {                                  }
 ao_VACS_SEC5_FAILPS   = 22;     {                                  }
 ao_VACS_SEC6_FAILPS   = 23;     {                                  }
 do_VACS_SEC1_VP1_BT   = 0;      { Digital outputs:                 }
 do_VACS_SEC1_VP2_BT   = 1;      {                                  }
 do_VACS_SEC1_NG1_BT   = 2;      {                                  }
 do_VACS_SEC1_NG2_BT   = 3;      {                                  }
 do_VACS_SEC1_NG3_BT   = 4;      {                                  }
 do_VACS_SEC1_NM1_BT   = 5;      {                                  }
 do_VACS_SEC1_NM2_BT   = 6;      {                                  }
 do_VACS_SEC1_NM3_BT   = 7;      {                                  }
 do_VACS_SEC1_NM4_BT   = 8;      {                                  }
 do_VACS_SEC2_VP3_BT   = 9;      {                                  }
 do_VACS_SEC2_VP4_BT   = 10;     {                                  }
 do_VACS_SEC2_NG4_BT   = 11;     {                                  }
 do_VACS_SEC2_NG5_BT   = 12;     {                                  }
 do_VACS_SEC2_NG6_BT   = 13;     {                                  }
 do_VACS_SEC2_NG7_BT   = 14;     {                                  }
 do_VACS_SEC2_NM5_BT   = 15;     {                                  }
 do_VACS_SEC2_NM6_BT   = 16;     {                                  }
 do_VACS_SEC2_NM7_BT   = 17;     {                                  }
 do_VACS_SEC2_NM8_BT   = 18;     {                                  }
 do_VACS_SEC3_VP5_BT   = 19;     {                                  }
 do_VACS_SEC3_VP6_BT   = 20;     {                                  }
 do_VACS_SEC3_NG8_BT   = 21;     {                                  }
 do_VACS_SEC3_NG9_BT   = 22;     {                                  }
 do_VACS_SEC3_NG10_BT  = 23;     {                                  }
 do_VACS_SEC3_NM9_BT   = 24;     {                                  }
 do_VACS_SEC3_NM10_BT  = 25;     {                                  }
 do_VACS_SEC3_NM11_BT  = 26;     {                                  }
 do_VACS_SEC3_NM12_BT  = 27;     {                                  }
 do_VACS_SEC4_VP8_BT   = 28;     {                                  }
 do_VACS_SEC4_VP9_BT   = 29;     {                                  }
 do_VACS_SEC4_NG11_BT  = 30;     {                                  }
 do_VACS_SEC4_NG12_BT  = 31;     {                                  }
 do_VACS_SEC4_NG13_BT  = 32;     {                                  }
 do_VACS_SEC4_NM13_BT  = 33;     {                                  }
 do_VACS_SEC4_NM14_BT  = 34;     {                                  }
 do_VACS_SEC4_NM15_BT  = 35;     {                                  }
 do_VACS_SEC4_NM16_BT  = 36;     {                                  }
 do_VACS_SEC5_VP10_BT  = 37;     {                                  }
 do_VACS_SEC5_VP11_BT  = 38;     {                                  }
 do_VACS_SEC5_NG14_BT  = 39;     {                                  }
 do_VACS_SEC5_NG15_BT  = 40;     {                                  }
 do_VACS_SEC5_NG16_BT  = 41;     {                                  }
 do_VACS_SEC5_NG17_BT  = 42;     {                                  }
 do_VACS_SEC5_NM17_BT  = 43;     {                                  }
 do_VACS_SEC5_NM18_BT  = 44;     {                                  }
 do_VACS_SEC5_NM19_BT  = 45;     {                                  }
 do_VACS_SEC5_NM20_BT  = 46;     {                                  }
 do_VACS_SEC6_VP12_BT  = 47;     {                                  }
 do_VACS_SEC6_VP13_BT  = 48;     {                                  }
 do_VACS_SEC6_NG18_BT  = 49;     {                                  }
 do_VACS_SEC6_NG19_BT  = 50;     {                                  }
 do_VACS_SEC6_NG20_BT  = 51;     {                                  }
 do_VACS_SEC6_NM21_BT  = 52;     {                                  }
 do_VACS_SEC6_NM22_BT  = 53;     {                                  }
 do_VACS_SEC6_NM23_BT  = 54;     {                                  }
 do_VACS_SEC6_NM24_BT  = 55;     {                                  }
 do_VACS_ECOL_VP7_BT   = 56;     {                                  }
 DimDeadline           = 5000;   { Detect DIM server is dead        }
 Sim_MediumVac         = 33.3305;{ Simulator: medium vacuum         }
 Sim_UltraHigh         = 1e-12;  { Ultrahigh vacuum                 }
 Sim_HighVac           = 9e-8;   { High vacuum                      }
 Sim_SmallLeak         = 5e-6;   { Simulate Small Leak              }
 Sim_LargeLeak         = 5e-5;   { Simulate Large Leak              }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 {$I sce_bacc_bstr_vacs_types}   { Include all BSTR VACS types      }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_SmiuiSrv}              { Include SmiuiSrv     variables   }
 BSTR : TBSTRRec;                { All BSTR VACS data...            }
 SIM  : record                   { Simulator data...                }
  PS1,PS2,PS3,PS4,PS5,PS6:TUnitsRec; {                              }
 end;                            {                                  }
 ColorNorm             : Integer;{ Color in normal state: lime,aqua }
 ColorWarn             : Integer;{ Color in warning state: yellow   }
 cmd_AssignTag         : Integer;{ @AssignTag                       }
 cmd_DimTagUpdate      : Integer;{ @DimTagUpdate                    }
 cmd_EditParams        : Integer;{ @EditParams                      }
 cmd_Edit              : Integer;{ @Edit                            }
 cmd_SimulateSmallLeak : Integer;{ @SimulateSmallLeak               }
 cmd_SimulateLargeLeak : Integer;{ @SimulateLargeLeak               }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_SmiuiSrv}              { Include SmiuiSrv     functions   }
 {$I sce_bacc_bstr_vacs_funcs}   { Include all BSTR VACS functions  }

 {
 Write AO,DO state
 }
 procedure WriteAoDoState;
  //
  // Write AO state.
  //
  procedure WriteAoState;
  begin
   if NumAos<>0 then begin
    UpdateAo(ao_VACS_SEC1_PS1_MBAR,time,rGetTag(BSTR.VACS.SEC1.PS1.MBAR.tag));
    UpdateAo(ao_VACS_SEC2_PS2_MBAR,time,rGetTag(BSTR.VACS.SEC2.PS2.MBAR.tag));
    UpdateAo(ao_VACS_SEC3_PS3_MBAR,time,rGetTag(BSTR.VACS.SEC3.PS3.MBAR.tag));
    UpdateAo(ao_VACS_SEC4_PS4_MBAR,time,rGetTag(BSTR.VACS.SEC4.PS4.MBAR.tag));
    UpdateAo(ao_VACS_SEC5_PS5_MBAR,time,rGetTag(BSTR.VACS.SEC5.PS5.MBAR.tag));
    UpdateAo(ao_VACS_SEC6_PS6_MBAR,time,rGetTag(BSTR.VACS.SEC6.PS6.MBAR.tag));
    UpdateAo(ao_VACS_SEC1_NORMPS,  time,rGetTag(BSTR.VACS.SEC1.NORMPS.tag));
    UpdateAo(ao_VACS_SEC2_NORMPS,  time,rGetTag(BSTR.VACS.SEC2.NORMPS.tag));
    UpdateAo(ao_VACS_SEC3_NORMPS,  time,rGetTag(BSTR.VACS.SEC3.NORMPS.tag));
    UpdateAo(ao_VACS_SEC4_NORMPS,  time,rGetTag(BSTR.VACS.SEC4.NORMPS.tag));
    UpdateAo(ao_VACS_SEC5_NORMPS,  time,rGetTag(BSTR.VACS.SEC5.NORMPS.tag));
    UpdateAo(ao_VACS_SEC6_NORMPS,  time,rGetTag(BSTR.VACS.SEC6.NORMPS.tag));
    UpdateAo(ao_VACS_SEC1_WARNPS,  time,rGetTag(BSTR.VACS.SEC1.WARNPS.tag));
    UpdateAo(ao_VACS_SEC2_WARNPS,  time,rGetTag(BSTR.VACS.SEC2.WARNPS.tag));
    UpdateAo(ao_VACS_SEC3_WARNPS,  time,rGetTag(BSTR.VACS.SEC3.WARNPS.tag));
    UpdateAo(ao_VACS_SEC4_WARNPS,  time,rGetTag(BSTR.VACS.SEC4.WARNPS.tag));
    UpdateAo(ao_VACS_SEC5_WARNPS,  time,rGetTag(BSTR.VACS.SEC5.WARNPS.tag));
    UpdateAo(ao_VACS_SEC6_WARNPS,  time,rGetTag(BSTR.VACS.SEC6.WARNPS.tag));
    UpdateAo(ao_VACS_SEC1_FAILPS,  time,rGetTag(BSTR.VACS.SEC1.FAILPS.tag));
    UpdateAo(ao_VACS_SEC2_FAILPS,  time,rGetTag(BSTR.VACS.SEC2.FAILPS.tag));
    UpdateAo(ao_VACS_SEC3_FAILPS,  time,rGetTag(BSTR.VACS.SEC3.FAILPS.tag));
    UpdateAo(ao_VACS_SEC4_FAILPS,  time,rGetTag(BSTR.VACS.SEC4.FAILPS.tag));
    UpdateAo(ao_VACS_SEC5_FAILPS,  time,rGetTag(BSTR.VACS.SEC5.FAILPS.tag));
    UpdateAo(ao_VACS_SEC6_FAILPS,  time,rGetTag(BSTR.VACS.SEC6.FAILPS.tag));
   end;
  end;
  //
  // Write Digital Output state
  //
  procedure WriteDoState;
  begin
   if NumDos<>0 then begin
    //
    // Update curves from tags
    //
    UpdateDo(do_VACS_SEC1_VP1_BT, time,iGetTag(BSTR.VACS.SEC1.VP1.BT.tag));
    UpdateDo(do_VACS_SEC1_VP2_BT, time,iGetTag(BSTR.VACS.SEC1.VP2.BT.tag));
    UpdateDo(do_VACS_SEC1_NG1_BT, time,iGetTag(BSTR.VACS.SEC1.NG1.BT.tag));
    UpdateDo(do_VACS_SEC1_NG2_BT, time,iGetTag(BSTR.VACS.SEC1.NG2.BT.tag));
    UpdateDo(do_VACS_SEC1_NG3_BT, time,iGetTag(BSTR.VACS.SEC1.NG3.BT.tag));
    UpdateDo(do_VACS_SEC1_NM1_BT, time,iGetTag(BSTR.VACS.SEC1.NM1.BT.tag));
    UpdateDo(do_VACS_SEC1_NM2_BT, time,iGetTag(BSTR.VACS.SEC1.NM2.BT.tag));
    UpdateDo(do_VACS_SEC1_NM3_BT, time,iGetTag(BSTR.VACS.SEC1.NM3.BT.tag));
    UpdateDo(do_VACS_SEC1_NM4_BT, time,iGetTag(BSTR.VACS.SEC1.NM4.BT.tag));
    UpdateDo(do_VACS_SEC2_VP3_BT, time,iGetTag(BSTR.VACS.SEC2.VP3.BT.tag));
    UpdateDo(do_VACS_SEC2_VP4_BT, time,iGetTag(BSTR.VACS.SEC2.VP4.BT.tag));
    UpdateDo(do_VACS_SEC2_NG4_BT, time,iGetTag(BSTR.VACS.SEC2.NG4.BT.tag));
    UpdateDo(do_VACS_SEC2_NG5_BT, time,iGetTag(BSTR.VACS.SEC2.NG5.BT.tag));
    UpdateDo(do_VACS_SEC2_NG6_BT, time,iGetTag(BSTR.VACS.SEC2.NG6.BT.tag));
    UpdateDo(do_VACS_SEC2_NG7_BT, time,iGetTag(BSTR.VACS.SEC2.NG7.BT.tag));
    UpdateDo(do_VACS_SEC2_NM5_BT, time,iGetTag(BSTR.VACS.SEC2.NM5.BT.tag));
    UpdateDo(do_VACS_SEC2_NM6_BT, time,iGetTag(BSTR.VACS.SEC2.NM6.BT.tag));
    UpdateDo(do_VACS_SEC2_NM7_BT, time,iGetTag(BSTR.VACS.SEC2.NM7.BT.tag));
    UpdateDo(do_VACS_SEC2_NM8_BT, time,iGetTag(BSTR.VACS.SEC2.NM8.BT.tag));
    UpdateDo(do_VACS_SEC3_VP5_BT, time,iGetTag(BSTR.VACS.SEC3.VP5.BT.tag));
    UpdateDo(do_VACS_SEC3_VP6_BT, time,iGetTag(BSTR.VACS.SEC3.VP6.BT.tag));
    UpdateDo(do_VACS_SEC3_NG8_BT, time,iGetTag(BSTR.VACS.SEC3.NG8.BT.tag));
    UpdateDo(do_VACS_SEC3_NG9_BT, time,iGetTag(BSTR.VACS.SEC3.NG9.BT.tag));
    UpdateDo(do_VACS_SEC3_NG10_BT,time,iGetTag(BSTR.VACS.SEC3.NG10.BT.tag));
    UpdateDo(do_VACS_SEC3_NM9_BT, time,iGetTag(BSTR.VACS.SEC3.NM9.BT.tag));
    UpdateDo(do_VACS_SEC3_NM10_BT,time,iGetTag(BSTR.VACS.SEC3.NM10.BT.tag));
    UpdateDo(do_VACS_SEC3_NM11_BT,time,iGetTag(BSTR.VACS.SEC3.NM11.BT.tag));
    UpdateDo(do_VACS_SEC3_NM12_BT,time,iGetTag(BSTR.VACS.SEC3.NM12.BT.tag));
    UpdateDo(do_VACS_SEC4_VP8_BT, time,iGetTag(BSTR.VACS.SEC4.VP8.BT.tag));
    UpdateDo(do_VACS_SEC4_VP9_BT, time,iGetTag(BSTR.VACS.SEC4.VP9.BT.tag));
    UpdateDo(do_VACS_SEC4_NG11_BT,time,iGetTag(BSTR.VACS.SEC4.NG11.BT.tag));
    UpdateDo(do_VACS_SEC4_NG12_BT,time,iGetTag(BSTR.VACS.SEC4.NG12.BT.tag));
    UpdateDo(do_VACS_SEC4_NG13_BT,time,iGetTag(BSTR.VACS.SEC4.NG13.BT.tag));
    UpdateDo(do_VACS_SEC4_NM13_BT,time,iGetTag(BSTR.VACS.SEC4.NM13.BT.tag));
    UpdateDo(do_VACS_SEC4_NM14_BT,time,iGetTag(BSTR.VACS.SEC4.NM14.BT.tag));
    UpdateDo(do_VACS_SEC4_NM15_BT,time,iGetTag(BSTR.VACS.SEC4.NM15.BT.tag));
    UpdateDo(do_VACS_SEC4_NM16_BT,time,iGetTag(BSTR.VACS.SEC4.NM16.BT.tag));
    UpdateDo(do_VACS_SEC5_VP10_BT,time,iGetTag(BSTR.VACS.SEC5.VP10.BT.tag));
    UpdateDo(do_VACS_SEC5_VP11_BT,time,iGetTag(BSTR.VACS.SEC5.VP11.BT.tag));
    UpdateDo(do_VACS_SEC5_NG14_BT,time,iGetTag(BSTR.VACS.SEC5.NG14.BT.tag));
    UpdateDo(do_VACS_SEC5_NG15_BT,time,iGetTag(BSTR.VACS.SEC5.NG15.BT.tag));
    UpdateDo(do_VACS_SEC5_NG16_BT,time,iGetTag(BSTR.VACS.SEC5.NG16.BT.tag));
    UpdateDo(do_VACS_SEC5_NG17_BT,time,iGetTag(BSTR.VACS.SEC5.NG17.BT.tag));
    UpdateDo(do_VACS_SEC5_NM17_BT,time,iGetTag(BSTR.VACS.SEC5.NM17.BT.tag));
    UpdateDo(do_VACS_SEC5_NM18_BT,time,iGetTag(BSTR.VACS.SEC5.NM18.BT.tag));
    UpdateDo(do_VACS_SEC5_NM19_BT,time,iGetTag(BSTR.VACS.SEC5.NM19.BT.tag));
    UpdateDo(do_VACS_SEC5_NM20_BT,time,iGetTag(BSTR.VACS.SEC5.NM20.BT.tag));
    UpdateDo(do_VACS_SEC6_VP12_BT,time,iGetTag(BSTR.VACS.SEC6.VP12.BT.tag));
    UpdateDo(do_VACS_SEC6_VP13_BT,time,iGetTag(BSTR.VACS.SEC6.VP13.BT.tag));
    UpdateDo(do_VACS_SEC6_NG18_BT,time,iGetTag(BSTR.VACS.SEC6.NG18.BT.tag));
    UpdateDo(do_VACS_SEC6_NG19_BT,time,iGetTag(BSTR.VACS.SEC6.NG19.BT.tag));
    UpdateDo(do_VACS_SEC6_NG20_BT,time,iGetTag(BSTR.VACS.SEC6.NG20.BT.tag));
    UpdateDo(do_VACS_SEC6_NM21_BT,time,iGetTag(BSTR.VACS.SEC6.NM21.BT.tag));
    UpdateDo(do_VACS_SEC6_NM22_BT,time,iGetTag(BSTR.VACS.SEC6.NM22.BT.tag));
    UpdateDo(do_VACS_SEC6_NM23_BT,time,iGetTag(BSTR.VACS.SEC6.NM23.BT.tag));
    UpdateDo(do_VACS_SEC6_NM24_BT,time,iGetTag(BSTR.VACS.SEC6.NM24.BT.tag));
    UpdateDo(do_VACS_ECOL_VP7_BT, time,iGetTag(BSTR.VACS.ECOL.VP7.BT.tag));
   end;
  end;
 begin
  if DIM_IsServerMode then begin
   WriteDoState;
   WriteAoState;
  end;
 end;
 {
 Logical control algorithms
 }
 procedure LogicalControl;
  //
  // Poll DIM Client
  //
  procedure UpdateDateTime_Client;
  begin
   if DIM_IsClientMode then begin
    if (ShouldRefresh(BSTR.VACS.CLOCK.dat,GetStampOfTag(BSTR.VACS.CLOCK.tag,0))>0) then begin
     bNul(SetTagColor(BSTR.VACS.SERVID.tag,ColorNorm));
     bNul(SetTagColor(BSTR.VACS.CLOCK.tag,ColorNorm));
     BSTR.VACS.CLOCK.tim:=mSecNow;
    end;
    if (SysTimer_Pulse(1000)>0) then if (mSecNow-BSTR.VACS.CLOCK.tim>DimDeadline) then begin
     bNul(sSetTag(BSTR.VACS.SERVID.tag,'Server Disconnected'));
     bNul(SetTagColor(BSTR.VACS.SERVID.tag,ColorWarn));
     bNul(SetTagColor(BSTR.VACS.CLOCK.tag,ColorWarn));
    end;
   end;
  end;
  //
  // Poll DIM Server
  //
  procedure UpdateDateTime_Server;
  begin
   {
   Update Host Date-Time
   }
   if (SysTimer_Pulse(1000)>0) then begin
    bNul(sSetTag(BSTR.VACS.SERVID.tag,BSTR.VACS.SelfId));
    bNul(sSetTag(BSTR.VACS.CLOCK.tag,GetDateTime(mSecNow)));
    bNul(SetTagColor(BSTR.VACS.SERVID.tag,ColorNorm));
    bNul(SetTagColor(BSTR.VACS.CLOCK.tag,ColorNorm));
   end;
  end;
 begin
  if DIM_IsServerMode then UpdateDateTime_Server else UpdateDateTime_Client;
 end;
 {
 Menu EditParams Starter to start editing.
 }
 procedure MenuEditParamsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Параметры установки"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Рабочий           порог вакуума секции 1 = '+Str(rGetTag(BSTR.VACS.SEC1.NORMPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC1.NORMPS');
   n:=n+EditAddInputLn('Рабочий           порог вакуума секции 2 = '+Str(rGetTag(BSTR.VACS.SEC2.NORMPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC2.NORMPS');
   n:=n+EditAddInputLn('Рабочий           порог вакуума секции 3 = '+Str(rGetTag(BSTR.VACS.SEC3.NORMPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC3.NORMPS');
   n:=n+EditAddInputLn('Рабочий           порог вакуума секции 4 = '+Str(rGetTag(BSTR.VACS.SEC4.NORMPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC4.NORMPS');
   n:=n+EditAddInputLn('Рабочий           порог вакуума секции 5 = '+Str(rGetTag(BSTR.VACS.SEC5.NORMPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC5.NORMPS');
   n:=n+EditAddInputLn('Рабочий           порог вакуума секции 6 = '+Str(rGetTag(BSTR.VACS.SEC6.NORMPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC6.NORMPS');
   n:=n+EditAddInputLn('----------------------------------------------------');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('');
   n:=n+EditAddInputLn('Предупредительный порог вакуума секции 1 = '+Str(rGetTag(BSTR.VACS.SEC1.WARNPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC1.WARNPS');
   n:=n+EditAddInputLn('Предупредительный порог вакуума секции 2 = '+Str(rGetTag(BSTR.VACS.SEC2.WARNPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC2.WARNPS');
   n:=n+EditAddInputLn('Предупредительный порог вакуума секции 3 = '+Str(rGetTag(BSTR.VACS.SEC3.WARNPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC3.WARNPS');
   n:=n+EditAddInputLn('Предупредительный порог вакуума секции 4 = '+Str(rGetTag(BSTR.VACS.SEC4.WARNPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC4.WARNPS');
   n:=n+EditAddInputLn('Предупредительный порог вакуума секции 5 = '+Str(rGetTag(BSTR.VACS.SEC5.WARNPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC5.WARNPS');
   n:=n+EditAddInputLn('Предупредительный порог вакуума секции 6 = '+Str(rGetTag(BSTR.VACS.SEC6.WARNPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC6.WARNPS');
   n:=n+EditAddInputLn('----------------------------------------------------');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('');
   n:=n+EditAddInputLn('Аварийный         порог вакуума секции 1 = '+Str(rGetTag(BSTR.VACS.SEC1.FAILPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC1.FAILPS');
   n:=n+EditAddInputLn('Аварийный         порог вакуума секции 2 = '+Str(rGetTag(BSTR.VACS.SEC2.FAILPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC2.FAILPS');
   n:=n+EditAddInputLn('Аварийный         порог вакуума секции 3 = '+Str(rGetTag(BSTR.VACS.SEC3.FAILPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC3.FAILPS');
   n:=n+EditAddInputLn('Аварийный         порог вакуума секции 4 = '+Str(rGetTag(BSTR.VACS.SEC4.FAILPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC4.FAILPS');
   n:=n+EditAddInputLn('Аварийный         порог вакуума секции 5 = '+Str(rGetTag(BSTR.VACS.SEC5.FAILPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC5.FAILPS');
   n:=n+EditAddInputLn('Аварийный         порог вакуума секции 6 = '+Str(rGetTag(BSTR.VACS.SEC6.FAILPS.tag))+' мбар');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@Edit SEC6.FAILPS');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[Bold]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_EDIT_PARAMS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu EditParams Handler to handle editing.
 }
 procedure MenuEditParamsHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_EDIT_PARAMS'));
 end;
 {
 GUI Handler to process user input...
 }
 procedure GUIHandler;
 var ClickCurve:Integer; s:String;
  procedure Cleanup;
  begin
   s:='';
  end;
 begin
  Cleanup;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Copy GUI click to DIM buffer for remote execution.
   }
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Handle local clicks
     }
     if ClickIsLocal then begin
      {
      Handle tag clicks...
      }
      if ClickTag<>0 then begin
       ClickTagXorRemote(BSTR.VACS.SEC1.VP1.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC1.VP2.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC1.NG1.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC1.NG2.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC1.NG3.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC1.NM1.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC1.NM2.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC1.NM3.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC1.NM4.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC2.VP3.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC2.VP4.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC2.NG4.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC2.NG5.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC2.NG6.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC2.NG7.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC2.NM5.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC2.NM6.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC2.NM7.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC2.NM8.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC3.VP5.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC3.VP6.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC3.NG8.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC3.NG9.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC3.NG10.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC3.NM9.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC3.NM10.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC3.NM11.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC3.NM12.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC4.VP8.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC4.VP9.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC4.NG11.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC4.NG12.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC4.NG13.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC4.NM13.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC4.NM14.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC4.NM15.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC4.NM16.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC5.VP10.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC5.VP11.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC5.NG14.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC5.NG15.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC5.NG16.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC5.NG17.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC5.NM17.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC5.NM18.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC5.NM19.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC5.NM20.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC6.VP12.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC6.VP13.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC6.NG18.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC6.NG19.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC6.NG20.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC6.NM21.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC6.NM22.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC6.NM23.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.SEC6.NM24.BT.tag,1);
       ClickTagXorRemote(BSTR.VACS.ECOL.VP7.BT.tag,1);
      end;
      {
      Handle sensor clicks...
      }
      if IsSameText(ClickSensor,'HELP') then begin
       Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
       bNul(Voice(snd_Click));
      end;
      {
      Select Plot & Tab windows by curve...
      }
      ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
      if IsRefCurve(ClickCurve) then begin
       iNul(WinSelectByCurve(ClickCurve,ClickCurve));
       bNul(Voice(snd_Wheel));
      end;
      {
      Console commands: @url_encoded_sensor ...
      }
      if LooksLikeCommand(ClickSensor) then begin
       DevSendCmdLocal(url_decode(ClickSensor));
       bNul(Voice(snd_Click));
      end;
      //
      // SMI FSM click handler...
      //
      if (smiuisrv_click_fsm<>0) then begin
       smiuisrv_click_fsm_default_handler(ClickParams(''));
      end;
     end;
     {
     Handle remote clicks comes from DIM via @DimGuiClick message.
     @DimGuiClick default handler decode and write events to FIFO,
     so we can find it as clicks and can handle it in usual way.
     }
     if ClickIsRemote then begin
      {
      Show time difference.
      }
      if DebugFlagEnabled(dfDetails) then
      Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
      {
      Handle remote console commands...
      }
      s:=Dim_GuiConsoleRecv(DevName,'');
      if LooksLikeCommand(s) then DevSendCmdLocal(s);
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   if CheckEditTag(BSTR.VACS.SEC1.NORMPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC1.NORMPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC2.NORMPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC2.NORMPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC3.NORMPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC3.NORMPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC4.NORMPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC4.NORMPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC5.NORMPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC5.NORMPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC6.NORMPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC6.NORMPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC1.WARNPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC1.WARNPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC2.WARNPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC2.WARNPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC3.WARNPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC3.WARNPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC4.WARNPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC4.WARNPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC5.WARNPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC5.WARNPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC6.WARNPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC6.WARNPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC1.FAILPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC1.FAILPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC2.FAILPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC2.FAILPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC3.FAILPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC3.FAILPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC4.FAILPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC4.FAILPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC5.FAILPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC5.FAILPS.tag)+' '+s);
   if CheckEditTag(BSTR.VACS.SEC6.FAILPS.tag,s) then DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(BSTR.VACS.SEC6.FAILPS.tag)+' '+s);
   //
   // Menu EditParams
   //
   MenuEditParamsHandler;
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  Cleanup;
 end;
 {
 Simulation state...
 }
 procedure SimulatorState;
  function calcPress(prs:Real; n:Integer):Real;
  begin
   if n<>0 then begin
    if n>7 then n:=7;
    prs:=prs-(((prs-Sim_UltraHigh))/Abs(1000-(n*100)-(n*30)));
   end else
   if prs<Sim_HighVac
   then prs:=prs+1e-10+random(-1e-10,1e-10)
   else prs:=Sim_HighVac;
   calcPress:=Sim_UltraHigh+prs+random(0,1e-15);
  end;
 begin
  SIM.PS1.MBAR.val:=calcPress(SIM.PS1.MBAR.val,iGetTag(BSTR.VACS.SEC1.NG1.BT.tag)+iGetTag(BSTR.VACS.SEC1.NG2.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC1.NG3.BT.tag)+iGetTag(BSTR.VACS.SEC1.NM1.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC1.NM2.BT.tag)+iGetTag(BSTR.VACS.SEC1.NM3.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC1.NM4.BT.tag));
  SIM.PS2.MBAR.val:=calcPress(SIM.PS2.MBAR.val,iGetTag(BSTR.VACS.SEC2.NG4.BT.tag)+iGetTag(BSTR.VACS.SEC2.NG5.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC2.NG6.BT.tag)+iGetTag(BSTR.VACS.SEC2.NG7.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC2.NM5.BT.tag)+iGetTag(BSTR.VACS.SEC2.NM6.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC2.NM7.BT.tag)+iGetTag(BSTR.VACS.SEC2.NM8.BT.tag));
  SIM.PS3.MBAR.val:=calcPress(SIM.PS3.MBAR.val,iGetTag(BSTR.VACS.SEC3.NG8.BT.tag) +iGetTag(BSTR.VACS.SEC3.NG9.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC3.NG10.BT.tag)+iGetTag(BSTR.VACS.SEC3.NM9.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC3.NM10.BT.tag)+iGetTag(BSTR.VACS.SEC3.NM11.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC3.NM12.BT.tag));
  SIM.PS4.MBAR.val:=calcPress(SIM.PS4.MBAR.val,iGetTag(BSTR.VACS.SEC4.NG11.BT.tag)+iGetTag(BSTR.VACS.SEC4.NG12.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC4.NG13.BT.tag)+iGetTag(BSTR.VACS.SEC4.NM13.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC4.NM14.BT.tag)+iGetTag(BSTR.VACS.SEC4.NM15.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC4.NM16.BT.tag));
  SIM.PS5.MBAR.val:=calcPress(SIM.PS5.MBAR.val,iGetTag(BSTR.VACS.SEC5.NG14.BT.tag)+iGetTag(BSTR.VACS.SEC5.NG15.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC5.NG16.BT.tag)+iGetTag(BSTR.VACS.SEC5.NG17.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC5.NM17.BT.tag)+iGetTag(BSTR.VACS.SEC5.NM18.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC5.NM19.BT.tag)+iGetTag(BSTR.VACS.SEC5.NM20.BT.tag));
  SIM.PS6.MBAR.val:=calcPress(SIM.PS6.MBAR.val,iGetTag(BSTR.VACS.SEC6.NG18.BT.tag)+iGetTag(BSTR.VACS.SEC6.NG19.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC6.NG20.BT.tag)+iGetTag(BSTR.VACS.SEC6.NM21.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC6.NM22.BT.tag)+iGetTag(BSTR.VACS.SEC6.NM23.BT.tag)+
                                               iGetTag(BSTR.VACS.SEC6.NM24.BT.tag));
  if SysTimer_Pulse(250)>0 then begin
   bNul(rSetTag(BSTR.VACS.SEC1.PS1.MBAR.tag,SIM.PS1.MBAR.val));
   bNul(rSetTag(BSTR.VACS.SEC2.PS2.MBAR.tag,SIM.PS2.MBAR.val));
   bNul(rSetTag(BSTR.VACS.SEC3.PS3.MBAR.tag,SIM.PS3.MBAR.val));
   bNul(rSetTag(BSTR.VACS.SEC4.PS4.MBAR.tag,SIM.PS4.MBAR.val));
   bNul(rSetTag(BSTR.VACS.SEC5.PS5.MBAR.tag,SIM.PS5.MBAR.val));
   bNul(rSetTag(BSTR.VACS.SEC6.PS6.MBAR.tag,SIM.PS6.MBAR.val));
  end;
 end;
 {
 Handle message @SimulateSmallLeak arg
 }
 procedure VACS_OnSimulateSmallLeak(arg:String);
 var SecNum:Integer;
 begin
  SecNum:=Val(Trim(arg));
  Success('Simulate Small Leak on Section '+Str(SecNum));
  case SecNum of
   1: SIM.PS1.MBAR.val:=SIM.PS1.MBAR.val+Sim_SmallLeak;
   2: SIM.PS2.MBAR.val:=SIM.PS2.MBAR.val+Sim_SmallLeak;
   3: SIM.PS3.MBAR.val:=SIM.PS3.MBAR.val+Sim_SmallLeak;
   4: SIM.PS4.MBAR.val:=SIM.PS4.MBAR.val+Sim_SmallLeak;
   5: SIM.PS5.MBAR.val:=SIM.PS5.MBAR.val+Sim_SmallLeak;
   6: SIM.PS6.MBAR.val:=SIM.PS6.MBAR.val+Sim_SmallLeak;
  end;
 end;
 {
 Handle message @SimulateLargeLeak arg
 }
 procedure VACS_OnSimulateLargeLeak(arg:String);
 var SecNum:Integer;
 begin
  SecNum:=Val(Trim(arg));
  Success('Simulate Large Leak on Section '+Str(SecNum));
  case SecNum of
   1: SIM.PS1.MBAR.val:=SIM.PS1.MBAR.val+Sim_LargeLeak;
   2: SIM.PS2.MBAR.val:=SIM.PS2.MBAR.val+Sim_LargeLeak;
   3: SIM.PS3.MBAR.val:=SIM.PS3.MBAR.val+Sim_LargeLeak;
   4: SIM.PS4.MBAR.val:=SIM.PS4.MBAR.val+Sim_LargeLeak;
   5: SIM.PS5.MBAR.val:=SIM.PS5.MBAR.val+Sim_LargeLeak;
   6: SIM.PS6.MBAR.val:=SIM.PS6.MBAR.val+Sim_LargeLeak;
  end;
 end;
 {
 Handle message @AssignTag arg
 }
 procedure VACS_OnAssignTag(arg:String);
 var tag:Integer; w1,w2:String;
  procedure Cleanup;
  begin
   w1:=''; w2:='';
  end;
 begin
  Cleanup;
  if (arg<>'') then begin
   w1:=ExtractWord(1,arg);
   tag:=FindTag(w1);
   if (tag<>0) then begin
    w2:=ExtractWord(2,arg);
    if tag=BSTR.VACS.SEC1.VP1.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC1.VP2.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC1.NG1.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC1.NG2.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC1.NG3.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC1.NM1.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC1.NM2.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC1.NM3.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC1.NM4.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC2.VP3.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC2.VP4.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC2.NG4.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC2.NG5.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC2.NG6.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC2.NG7.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC2.NM5.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC2.NM6.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC2.NM7.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC2.NM8.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC3.VP5.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC3.VP6.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC3.NG8.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC3.NG9.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC3.NG10.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC3.NM9.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC3.NM10.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC3.NM11.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC3.NM12.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC4.VP8.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC4.VP9.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC4.NG11.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC4.NG12.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC4.NG13.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC4.NM13.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC4.NM14.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC4.NM15.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC4.NM16.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC5.VP10.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC5.VP11.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC5.NG14.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC5.NG15.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC5.NG16.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC5.NG17.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC5.NM17.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC5.NM18.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC5.NM19.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC5.NM20.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC6.VP12.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC6.VP13.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC6.NG18.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC6.NG19.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC6.NG20.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC6.NM21.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC6.NM22.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC6.NM23.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC6.NM24.BT.tag then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.ECOL.VP7.BT.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC1.NORMPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC2.NORMPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC3.NORMPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC4.NORMPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC5.NORMPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC6.NORMPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC1.WARNPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC2.WARNPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC3.WARNPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC4.WARNPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC5.WARNPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC6.WARNPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC1.FAILPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC2.FAILPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC3.FAILPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC4.FAILPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC5.FAILPS.tag  then UpdateTag(tag,w2,0,MaxReal);
    if tag=BSTR.VACS.SEC6.FAILPS.tag  then UpdateTag(tag,w2,0,MaxReal);
   end;
  end;
  Cleanup;
 end;
 {
 Handle message @DimUpdateTag arg
 }
 procedure VACS_OnDimUpdateTag(arg:String);
 var tag,typ:Integer; x,y:Real;
 begin
  if (arg<>'') then begin
   if DIM_IsClientMode and not DIM_IsServerMode then begin
    tag:=FindTag(ExtractWord(1,arg));
    if (tag<>0) then begin
     typ:=TypeTag(tag);
     if (typ=1) then y:=iGetTag(tag) else
     if (typ=2) then y:=rGetTag(tag) else y:=_Nan;
     x:=time;
     if not IsNan(y) then begin
      if tag=BSTR.VACS.SEC1.VP1.BT.tag   then UpdateDo(do_VACS_SEC1_VP1_BT,x,y);
      if tag=BSTR.VACS.SEC1.VP2.BT.tag   then UpdateDo(do_VACS_SEC1_VP2_BT,x,y);
      if tag=BSTR.VACS.SEC1.NG1.BT.tag   then UpdateDo(do_VACS_SEC1_NG1_BT,x,y);
      if tag=BSTR.VACS.SEC1.NG2.BT.tag   then UpdateDo(do_VACS_SEC1_NG2_BT,x,y);
      if tag=BSTR.VACS.SEC1.NG3.BT.tag   then UpdateDo(do_VACS_SEC1_NG3_BT,x,y);
      if tag=BSTR.VACS.SEC1.NM1.BT.tag   then UpdateDo(do_VACS_SEC1_NM1_BT,x,y);
      if tag=BSTR.VACS.SEC1.NM2.BT.tag   then UpdateDo(do_VACS_SEC1_NM2_BT,x,y);
      if tag=BSTR.VACS.SEC1.NM3.BT.tag   then UpdateDo(do_VACS_SEC1_NM3_BT,x,y);
      if tag=BSTR.VACS.SEC1.NM4.BT.tag   then UpdateDo(do_VACS_SEC1_NM4_BT,x,y);
      if tag=BSTR.VACS.SEC2.VP3.BT.tag   then UpdateDo(do_VACS_SEC2_VP3_BT,x,y);
      if tag=BSTR.VACS.SEC2.VP4.BT.tag   then UpdateDo(do_VACS_SEC2_VP4_BT,x,y);
      if tag=BSTR.VACS.SEC2.NG4.BT.tag   then UpdateDo(do_VACS_SEC2_NG4_BT,x,y);
      if tag=BSTR.VACS.SEC2.NG5.BT.tag   then UpdateDo(do_VACS_SEC2_NG5_BT,x,y);
      if tag=BSTR.VACS.SEC2.NG6.BT.tag   then UpdateDo(do_VACS_SEC2_NG6_BT,x,y);
      if tag=BSTR.VACS.SEC2.NG7.BT.tag   then UpdateDo(do_VACS_SEC2_NG7_BT,x,y);
      if tag=BSTR.VACS.SEC2.NM5.BT.tag   then UpdateDo(do_VACS_SEC2_NM5_BT,x,y);
      if tag=BSTR.VACS.SEC2.NM6.BT.tag   then UpdateDo(do_VACS_SEC2_NM6_BT,x,y);
      if tag=BSTR.VACS.SEC2.NM7.BT.tag   then UpdateDo(do_VACS_SEC2_NM7_BT,x,y);
      if tag=BSTR.VACS.SEC2.NM8.BT.tag   then UpdateDo(do_VACS_SEC2_NM8_BT,x,y);
      if tag=BSTR.VACS.SEC3.VP5.BT.tag   then UpdateDo(do_VACS_SEC3_VP5_BT,x,y);
      if tag=BSTR.VACS.SEC3.VP6.BT.tag   then UpdateDo(do_VACS_SEC3_VP6_BT,x,y);
      if tag=BSTR.VACS.SEC3.NG8.BT.tag   then UpdateDo(do_VACS_SEC3_NG8_BT,x,y);
      if tag=BSTR.VACS.SEC3.NG9.BT.tag   then UpdateDo(do_VACS_SEC3_NG9_BT,x,y);
      if tag=BSTR.VACS.SEC3.NG10.BT.tag  then UpdateDo(do_VACS_SEC3_NG10_BT,x,y);
      if tag=BSTR.VACS.SEC3.NM9.BT.tag   then UpdateDo(do_VACS_SEC3_NM9_BT,x,y);
      if tag=BSTR.VACS.SEC3.NM10.BT.tag  then UpdateDo(do_VACS_SEC3_NM10_BT,x,y);
      if tag=BSTR.VACS.SEC3.NM11.BT.tag  then UpdateDo(do_VACS_SEC3_NM11_BT,x,y);
      if tag=BSTR.VACS.SEC3.NM12.BT.tag  then UpdateDo(do_VACS_SEC3_NM12_BT,x,y);
      if tag=BSTR.VACS.SEC4.VP8.BT.tag   then UpdateDo(do_VACS_SEC4_VP8_BT,x,y);
      if tag=BSTR.VACS.SEC4.VP9.BT.tag   then UpdateDo(do_VACS_SEC4_VP9_BT,x,y);
      if tag=BSTR.VACS.SEC4.NG11.BT.tag  then UpdateDo(do_VACS_SEC4_NG11_BT,x,y);
      if tag=BSTR.VACS.SEC4.NG12.BT.tag  then UpdateDo(do_VACS_SEC4_NG12_BT,x,y);
      if tag=BSTR.VACS.SEC4.NG13.BT.tag  then UpdateDo(do_VACS_SEC4_NG13_BT,x,y);
      if tag=BSTR.VACS.SEC4.NM13.BT.tag  then UpdateDo(do_VACS_SEC4_NM13_BT,x,y);
      if tag=BSTR.VACS.SEC4.NM14.BT.tag  then UpdateDo(do_VACS_SEC4_NM14_BT,x,y);
      if tag=BSTR.VACS.SEC4.NM15.BT.tag  then UpdateDo(do_VACS_SEC4_NM15_BT,x,y);
      if tag=BSTR.VACS.SEC4.NM16.BT.tag  then UpdateDo(do_VACS_SEC4_NM16_BT,x,y);
      if tag=BSTR.VACS.SEC5.VP10.BT.tag  then UpdateDo(do_VACS_SEC5_VP10_BT,x,y);
      if tag=BSTR.VACS.SEC5.VP11.BT.tag  then UpdateDo(do_VACS_SEC5_VP11_BT,x,y);
      if tag=BSTR.VACS.SEC5.NG14.BT.tag  then UpdateDo(do_VACS_SEC5_NG14_BT,x,y);
      if tag=BSTR.VACS.SEC5.NG15.BT.tag  then UpdateDo(do_VACS_SEC5_NG15_BT,x,y);
      if tag=BSTR.VACS.SEC5.NG16.BT.tag  then UpdateDo(do_VACS_SEC5_NG16_BT,x,y);
      if tag=BSTR.VACS.SEC5.NG17.BT.tag  then UpdateDo(do_VACS_SEC5_NG17_BT,x,y);
      if tag=BSTR.VACS.SEC5.NM17.BT.tag  then UpdateDo(do_VACS_SEC5_NM17_BT,x,y);
      if tag=BSTR.VACS.SEC5.NM18.BT.tag  then UpdateDo(do_VACS_SEC5_NM18_BT,x,y);
      if tag=BSTR.VACS.SEC5.NM19.BT.tag  then UpdateDo(do_VACS_SEC5_NM19_BT,x,y);
      if tag=BSTR.VACS.SEC5.NM20.BT.tag  then UpdateDo(do_VACS_SEC5_NM20_BT,x,y);
      if tag=BSTR.VACS.SEC6.VP12.BT.tag  then UpdateDo(do_VACS_SEC6_VP12_BT,x,y);
      if tag=BSTR.VACS.SEC6.VP13.BT.tag  then UpdateDo(do_VACS_SEC6_VP13_BT,x,y);
      if tag=BSTR.VACS.SEC6.NG18.BT.tag  then UpdateDo(do_VACS_SEC6_NG18_BT,x,y);
      if tag=BSTR.VACS.SEC6.NG19.BT.tag  then UpdateDo(do_VACS_SEC6_NG19_BT,x,y);
      if tag=BSTR.VACS.SEC6.NG20.BT.tag  then UpdateDo(do_VACS_SEC6_NG20_BT,x,y);
      if tag=BSTR.VACS.SEC6.NM21.BT.tag  then UpdateDo(do_VACS_SEC6_NM21_BT,x,y);
      if tag=BSTR.VACS.SEC6.NM22.BT.tag  then UpdateDo(do_VACS_SEC6_NM22_BT,x,y);
      if tag=BSTR.VACS.SEC6.NM23.BT.tag  then UpdateDo(do_VACS_SEC6_NM23_BT,x,y);
      if tag=BSTR.VACS.SEC6.NM24.BT.tag  then UpdateDo(do_VACS_SEC6_NM24_BT,x,y);
      if tag=BSTR.VACS.ECOL.VP7.BT.tag   then UpdateDo(do_VACS_ECOL_VP7_BT,x,y);
      if tag=BSTR.VACS.SEC1.PS1.MBAR.tag then UpdateAo(ao_VACS_SEC1_PS1_MBAR,x,y);
      if tag=BSTR.VACS.SEC2.PS2.MBAR.tag then UpdateAo(ao_VACS_SEC2_PS2_MBAR,x,y);
      if tag=BSTR.VACS.SEC3.PS3.MBAR.tag then UpdateAo(ao_VACS_SEC3_PS3_MBAR,x,y);
      if tag=BSTR.VACS.SEC4.PS4.MBAR.tag then UpdateAo(ao_VACS_SEC4_PS4_MBAR,x,y);
      if tag=BSTR.VACS.SEC5.PS5.MBAR.tag then UpdateAo(ao_VACS_SEC5_PS5_MBAR,x,y);
      if tag=BSTR.VACS.SEC6.PS6.MBAR.tag then UpdateAo(ao_VACS_SEC6_PS6_MBAR,x,y);
      if tag=BSTR.VACS.SEC1.NORMPS.tag   then UpdateAo(ao_VACS_SEC1_NORMPS,x,y);
      if tag=BSTR.VACS.SEC2.NORMPS.tag   then UpdateAo(ao_VACS_SEC2_NORMPS,x,y);
      if tag=BSTR.VACS.SEC3.NORMPS.tag   then UpdateAo(ao_VACS_SEC3_NORMPS,x,y);
      if tag=BSTR.VACS.SEC4.NORMPS.tag   then UpdateAo(ao_VACS_SEC4_NORMPS,x,y);
      if tag=BSTR.VACS.SEC5.NORMPS.tag   then UpdateAo(ao_VACS_SEC5_NORMPS,x,y);
      if tag=BSTR.VACS.SEC6.NORMPS.tag   then UpdateAo(ao_VACS_SEC6_NORMPS,x,y);
      if tag=BSTR.VACS.SEC1.WARNPS.tag   then UpdateAo(ao_VACS_SEC1_WARNPS,x,y);
      if tag=BSTR.VACS.SEC2.WARNPS.tag   then UpdateAo(ao_VACS_SEC2_WARNPS,x,y);
      if tag=BSTR.VACS.SEC3.WARNPS.tag   then UpdateAo(ao_VACS_SEC3_WARNPS,x,y);
      if tag=BSTR.VACS.SEC4.WARNPS.tag   then UpdateAo(ao_VACS_SEC4_WARNPS,x,y);
      if tag=BSTR.VACS.SEC5.WARNPS.tag   then UpdateAo(ao_VACS_SEC5_WARNPS,x,y);
      if tag=BSTR.VACS.SEC6.WARNPS.tag   then UpdateAo(ao_VACS_SEC6_WARNPS,x,y);
      if tag=BSTR.VACS.SEC1.FAILPS.tag   then UpdateAo(ao_VACS_SEC1_FAILPS,x,y);
      if tag=BSTR.VACS.SEC2.FAILPS.tag   then UpdateAo(ao_VACS_SEC2_FAILPS,x,y);
      if tag=BSTR.VACS.SEC3.FAILPS.tag   then UpdateAo(ao_VACS_SEC3_FAILPS,x,y);
      if tag=BSTR.VACS.SEC4.FAILPS.tag   then UpdateAo(ao_VACS_SEC4_FAILPS,x,y);
      if tag=BSTR.VACS.SEC5.FAILPS.tag   then UpdateAo(ao_VACS_SEC5_FAILPS,x,y);
      if tag=BSTR.VACS.SEC6.FAILPS.tag   then UpdateAo(ao_VACS_SEC6_FAILPS,x,y);
     end;
    end;
   end;
  end;
 end;
 {
 VACS Initialization...
 }
 procedure VACS_Init;
 begin
  //
  // Initialize tags & devices...
  //
  TBSTRRec_Init(BSTR,ReadIni('tagVACS'));
  if DIM_IsServerMode then Success('Run as Server') else
  if DIM_IsClientMode then Success('Run as Client');
  //
  // Server Identifier
  //
  if DIM_IsServerMode
  then BSTR.VACS.SelfId:=Str(getpid)+'@'+ParamStr('HostName')
  else BSTR.VACS.SelfId:=Str(getpid)+'@'+ParamStr('ComputerName');
  //
  // Colors
  //
  ColorNorm:=clAqua;
  ColorWarn:=clYellow;
  if DIM_IsServerMode then ColorNorm:=clLime;
  if DIM_IsClientMode then ColorNorm:=clLime;
  bNul(SetTagColor(BSTR.VACS.CLOCK.tag,ColorNorm));
  bNul(SetTagColor(BSTR.VACS.SERVID.tag,ColorNorm));
  //
  // Initialize timers
  //
  BSTR.VACS.CLOCK.tim:=mSecNow;
  //
  // Initialize simulator value
  //
  SIM.PS1.MBAR.val:=Sim_HighVac;
  SIM.PS2.MBAR.val:=Sim_HighVac;
  SIM.PS2.MBAR.val:=Sim_HighVac;
  SIM.PS3.MBAR.val:=Sim_HighVac;
  SIM.PS4.MBAR.val:=Sim_HighVac;
  SIM.PS5.MBAR.val:=Sim_HighVac;
  SIM.PS6.MBAR.val:=Sim_HighVac;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearSmiuiSrv;
  VACS_FillTags(-MaxReal);
  TVACSRec_Clear(BSTR.VACS);
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  InitSmiuiSrv;
  VACS_Init;
  cmd_AssignTag:=RegisterStdInCmd('@AssignTag','');
  cmd_DimTagUpdate:=RegisterStdInCmd('@DimTagUpdate','');
  cmd_EditParams:=RegisterStdInCmd('@EditParams','');
  cmd_Edit:=RegisterStdInCmd('@Edit','');
  cmd_SimulateSmallLeak:=RegisterStdInCmd('@SimulateSmallLeak','');
  cmd_SimulateLargeLeak:=RegisterStdInCmd('@SimulateLargeLeak','');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  FreeSmiuiSrv;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  if ShouldPollSmiuiSrv then PollSmiuiSrv;
  SimulatorState; // Handle Simulator.
  GUIHandler;     // Handle GUI: edit, buttons etc.
  LogicalControl; // Apply logic control algoritms.
  WriteAoDoState; // Write AO,DO state.
  DimUpdateState; // Update DIM services.
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   !!! Handle SMIUISRV by default handler !!!
   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   }
   if smiuisrv_default_handler(Data,cmd,arg,cmdid) then begin
    if (Data<>'') then Success(smiuisrv_prompt+Data);
    Data:='';
   end else
   {
   @AssignTag
   }
   if (cmdid=cmd_AssignTag) then begin
    VACS_OnAssignTag(arg);
    Data:='';
   end else
   {
   @DimTagUpdate tag
   }
   if (cmdid=cmd_DimTagUpdate) then begin
    VACS_OnDimUpdateTag(arg);
    Data:='';
   end else
   {
   @EditParams tag
   }
   if (cmdid=cmd_EditParams) then begin
    MenuEditParamsStarter;
    Data:='';
   end else
   {
   @Edit SEC1.WARNPS
   }
   if (cmdid=cmd_Edit) then begin
    if IsSameText(ExtractWord(1,arg),'SEC1.NORMPS') then StartEditTag(BSTR.VACS.SEC1.NORMPS.tag,'Задайте рабочий порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC2.NORMPS') then StartEditTag(BSTR.VACS.SEC2.NORMPS.tag,'Задайте рабочий порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC3.NORMPS') then StartEditTag(BSTR.VACS.SEC3.NORMPS.tag,'Задайте рабочий порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC4.NORMPS') then StartEditTag(BSTR.VACS.SEC4.NORMPS.tag,'Задайте рабочий порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC5.NORMPS') then StartEditTag(BSTR.VACS.SEC5.NORMPS.tag,'Задайте рабочий порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC6.NORMPS') then StartEditTag(BSTR.VACS.SEC6.NORMPS.tag,'Задайте рабочий порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC1.WARNPS') then StartEditTag(BSTR.VACS.SEC1.WARNPS.tag,'Задайте предупредительный порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC2.WARNPS') then StartEditTag(BSTR.VACS.SEC2.WARNPS.tag,'Задайте предупредительный порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC3.WARNPS') then StartEditTag(BSTR.VACS.SEC3.WARNPS.tag,'Задайте предупредительный порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC4.WARNPS') then StartEditTag(BSTR.VACS.SEC4.WARNPS.tag,'Задайте предупредительный порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC5.WARNPS') then StartEditTag(BSTR.VACS.SEC5.WARNPS.tag,'Задайте предупредительный порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC6.WARNPS') then StartEditTag(BSTR.VACS.SEC6.WARNPS.tag,'Задайте предупредительный порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC1.FAILPS') then StartEditTag(BSTR.VACS.SEC1.FAILPS.tag,'Задайте аварийный порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC2.FAILPS') then StartEditTag(BSTR.VACS.SEC2.FAILPS.tag,'Задайте аварийный порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC3.FAILPS') then StartEditTag(BSTR.VACS.SEC3.FAILPS.tag,'Задайте аварийный порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC4.FAILPS') then StartEditTag(BSTR.VACS.SEC4.FAILPS.tag,'Задайте аварийный порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC5.FAILPS') then StartEditTag(BSTR.VACS.SEC5.FAILPS.tag,'Задайте аварийный порог вакуума, мбар');
    if IsSameText(ExtractWord(1,arg),'SEC6.FAILPS') then StartEditTag(BSTR.VACS.SEC6.FAILPS.tag,'Задайте аварийный порог вакуума, мбар');
    Data:='';
   end else
   {
   @SimulateSmallLeak 1
   }
   if (cmdid=cmd_SimulateSmallLeak) then begin
    VACS_OnSimulateSmallLeak(arg);
    Data:='';
   end else
   {
   @SimulateLargeLeak 1
   }
   if (cmdid=cmd_SimulateLargeLeak) then begin
    VACS_OnSimulateLargeLeak(arg);
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
