@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem **************************************
rem I7043 devices config generator
rem **************************************

chcp 65001 >nul & rem  set UTF-8

:Main
call :InitializeVariables
pushd "%~dp0" && call :I7043Devices
popd
pause
goto :EOF

:SetUnixPath
for /f "tokens=* delims=" %%a in ('unix path') do set "%%a"
goto :EOF

:InitializeVariables
set hdwcfg=%~n0_hdw.cfg
set simcfg=%~n0_sim.cfg
set proxycfg=%~n0_proxy.cfg
set diccfg=%~n0_dic.cfg
set discfg=%~n0_dis.cfg
set devmsg=devPostMsg
set tabcrc=..\Circuits\%~n0_link.crc
set /a numhdwcfg=0
set /a numdev=0
set /a CTRL_TOP=0
set /a CTRL_LEFT=650
set /a CTRL_TOP_STEP=70
set /a TABCRC_TOP=0
set /a TABCRC_STEP=80
set /a TABCRC_LEFT=0
set fileprefix=
set mainprefix=DEMO
set lastport=0
goto :EOF

:I7043Devices
call :DeleteFiles %hdwcfg% %simcfg% %proxycfg% %tabcrc% %diccfg% %discfg%
call :I7043_PROXY_INIT %* >> %proxycfg%
REM ============================================COM PORT CONNECTION============================================================
rem      Device Connect DevLabel         Facility    ID    ComPort ComBaudrate     RS485Port UnitId Polling CheckSum WDReconnect DelayOnStart
rem call :I7043  COM     Камера 1         DEMO       P1    2       115200          1          1      10       1        1         0       
rem call :I7043  COM     Ионопровод 1     DEMO       P2    1       115200          2          2      10       1        1         0       
rem call :I7043  COM     Ионопровод 2     DEMO       P2    1       115200          2          2      10       1        1         0       
REM ============================================TCP CONNECTION============================================================
rem      Device Connect DevLabel         Facility    ID    TcpPort TcpClient    RS485Port  UnitId Polling   CheckSum WDReconnect DelayOnStart
rem call :I7043  TCP     Объем 1          DEMO       P1    5000    192.168.0.1  2          2      10        1        1           20000       
rem call :I7043  TCP     Объем 2          DEMO       P1    5000    192.168.0.1  2          2      10        1        1           20000       
rem call :I7043  TCP     Камера 2         DEMO       P2    5000    192.168.0.1  2          2      10        1        1           20000       
rem call :I7043  TCP     Камера 3         DEMO       P3    5000    192.168.0.1  2          2      10        1        1           20000       
REM ==============================================TCP CONNECTION===============================================================
rem  Device Connect DevLabel         Facilit       ID     TCPPort    TCPClient       RS485Port UnitId Polling  CheckSum WDReconnect DelayOnStart
call :I7043 TCP     I7043_1          DEMO       I7043.P1     5305    172.21.4.210    1          2      10         1        1        20000       
call :I7043 TCP     I7043_2          DEMO       I7043.P2     5305    172.21.4.210    1          4      10         1        1        20000       
call :I7043 TCP     I7043_3          DEMO       I7043.P3     5305    172.21.4.210    1          5      10         1        1        20000       
REM ===========================================================================================================================
call :I7043_PROXY_END %* >> %proxycfg%
goto :EOF

:I7043
call :I7043_SET %*
call :I7043_HDW %*   >> %hdwcfg%
call :I7043_SIM %*   >> %simcfg%
call :I7043_DIC %*   >> %diccfg%
call :I7043_DIS %*   >> %discfg%
if not %lastport% == %RS485Port% (call :I7043_PROXY)
call :I7043_TABCRC   >> %tabcrc%
set /a numdev=numdev+1
set /a CTRL_TOP+=CTRL_TOP_STEP
set /a CTRL_TOP_IO+=CTRL_TOP_STEP
if "%numdev%" == "10" ( set /a CTRL_LEFT=CTRL_LEFT+465 )
if "%numdev%" == "10" ( set /a CTRL_TOP=0 )
goto :EOF

:I7043_PROXY
if "%ConnectionType%" == "COM" (call :I7043_PROXY_COM %* >> %proxycfg%)
if "%ConnectionType%" == "TCP" (call :I7043_PROXY_TCP %* >> %proxycfg%)
goto :EOF

:I7043_SET
set "ConnectionType=%~1" & shift &
set "DevLabel=%~1"       & shift &
set "FACN=%~1"           & shift & :: FACN - Facility name
set "IDEN=%~1"           & shift & :: IDEN - Identifier
set "ComPort=%~1"        & set "TCPPort=%~1"    & shift & :: Physical COM Port number
set "ComBaudrate=%~1"    & set "TCPClient=%~1"      & shift & :: Physical COM Port baudrate or IP
set "RS485Port=%~1"      & shift & :: Logical RS485 Port number
set "RS485UnitId=%~1"    & shift & :: RS485 Unit Id
set "RS485Polling=%~1"   & shift & :: RS485 Polling period, ms
set "CheckSum=%~1"       & shift & :: Use CheckSum
set "WDReconnect=%~1"    & shift & :: Do Reset State WD if WD event
set "DelayOnStart=%~1"   & shift & :: Wait time that device connected
set "FACP=%FACN:.=/%"            & :: Facility   DIM  path, i.e. FACN name with . to / replacement
set "FACF=%FACN:.=_%"            & :: Facility   file name, i.e. FACN name with . to _ replacement
set "IDNP=%IDEN:.=/%"            & :: Identifier file name, i.e. IDEN name with . to / replacement
set "IDNF=%IDEN:.=_%"            & :: Identifier file name, i.e. IDEN name with . to _ replacement
goto :EOF

:I7043_PROXY_INIT
echo [TagList]
echo RS485PROXY.BYTERATE.RX  = Real 0
echo RS485PROXY.BYTERATE.TX  = Real 0
echo RS485PROXY.POLLRATE.RX  = Real 0
echo RS485PROXY.POLLRATE.TX  = Real 0
echo RS485PROXY.BUGSRATE.RX  = Real 0
echo RS485PROXY.BUGSRATE.TX  = Real 0
echo RS485PROXY.BUGSRATE.EX  = Real 0
echo RS485PROXY.BYTECOUNT.RX = Real 0
echo RS485PROXY.BYTECOUNT.TX = Real 0
echo RS485PROXY.POLLCOUNT.RX = Real 0
echo RS485PROXY.POLLCOUNT.TX = Real 0
echo RS485PROXY.BUGSCOUNT.RX = Real 0
echo RS485PROXY.BUGSCOUNT.TX = Real 0
echo RS485PROXY.BUGSCOUNT.EX = Real 0
echo []
echo.
echo [^&RS485Proxy.StartupScript]
echo @Reset
echo ;--- Задание таблицы портов (порт,протокол,описание)
echo ;--- Задание счетчиков приема/передачи/ошибок
goto :EOF

:I7043_PROXY_COM
echo ;--- Логический порт %RS485Port%
echo @Port %RS485Port% com port %ComPort% baudrate %ComBaudrate% parity none databits 8 stopbits 1
echo @PortByteCounters %RS485Port% RS485PROXY.BYTECOUNT.RX, RS485PROXY.BYTECOUNT.TX
echo @PortPollCounters %RS485Port% RS485PROXY.POLLCOUNT.RX, RS485PROXY.POLLCOUNT.TX
echo @PortErrorCounters %RS485Port% RS485PROXY.BUGSCOUNT.RX, RS485PROXY.BUGSCOUNT.TX, RS485PROXY.BUGSCOUNT.EX
echo @PortByteRates %RS485Port% RS485PROXY.BYTERATE.RX, RS485PROXY.BYTERATE.TX
echo @PortPollRates %RS485Port% RS485PROXY.POLLRATE.RX, RS485PROXY.POLLRATE.TX
echo @PortErrorRates %RS485Port% RS485PROXY.BUGSRATE.RX, RS485PROXY.BUGSRATE.TX, RS485PROXY.BUGSRATE.EX
echo @TimeGap %RS485Port% 0
set "lastport=%RS485Port%"
goto :EOF

:I7043_PROXY_TCP
echo ;--- Логический порт %RS485Port%
echo @Port %RS485Port% tcp port %TCPPort% client %TCPClient%
echo @PortByteCounters %RS485Port% RS485PROXY.BYTECOUNT.RX, RS485PROXY.BYTECOUNT.TX
echo @PortPollCounters %RS485Port% RS485PROXY.POLLCOUNT.RX, RS485PROXY.POLLCOUNT.TX
echo @PortErrorCounters %RS485Port% RS485PROXY.BUGSCOUNT.RX, RS485PROXY.BUGSCOUNT.TX, RS485PROXY.BUGSCOUNT.EX
echo @PortByteRates %RS485Port% RS485PROXY.BYTERATE.RX, RS485PROXY.BYTERATE.TX
echo @PortPollRates %RS485Port% RS485PROXY.POLLRATE.RX, RS485PROXY.POLLRATE.TX
echo @PortErrorRates %RS485Port% RS485PROXY.BUGSRATE.RX, RS485PROXY.BUGSRATE.TX, RS485PROXY.BUGSRATE.EX
echo @TimeGap %RS485Port% 0
set "lastport=%RS485Port%"
goto :EOF

:I7043_PROXY_END
echo ;--- 
echo @ZeroPortCounters
echo @View
echo @CpuProfiler start 1 60 7
echo []
goto :EOF

:I7043_HDW
echo ;***************************
echo ;*****Driver for I7043******
echo ;***************************
echo [DeviceList]
echo ^&%FACN%.%IDEN%.CTRL = device software Program
echo [^&%FACN%.%IDEN%.CTRL]
echo Comment = Driver for IcpCon i-7043
echo InquiryPeriod = 0
echo DevicePolling = 1, tpNormal
echo DigitalFifo   = 1024
echo AnalogFifo    = 1024
echo ProgramSource    = ..\DaqPas\i7043_drv.pas
echo tagPrefix        = %FACN%.%IDEN%
echo OpenConsole      = 2         ; 0/1/2=Close/Show/Hide
echo DebugFlags       = 3         ; 1/2/4/8=Trouble/Success/Export/Import
echo EncryptMethod    = RC6
echo TrustedUsers     = [TrustedUsers]
echo DIM_GuiClickTag  = %FACN%.%IDEN%.DIMGUICLICK
echo RS485Port        = %RS485Port%
echo RS485UnitId      = %RS485UnitId%
echo RS485Timeout     = 250
echo RS485Deadline    = 60000
echo RS485Polling     = %RS485Polling%
echo Simulator        = 0         ; Must be 0 for driver
echo Checksum         = %CheckSum%         ; Checksum 0/1
echo WDReconnect      = %WDReconnect%         ; Watchdog Reconnect
echo DelayOnStart     = %DelayOnStart%     ;
echo DigitalOutputs   = 6         ; Digital output curves
echo Link DigitalOutput 0 with curve %FACN%.%IDEN%.STATE  history 1024 ; State of device
echo Link DigitalOutput 1 with curve %FACN%.%IDEN%.DODATA history 1024 ; Digital Output Value
echo Link DigitalOutput 2 with curve %FACN%.%IDEN%.PODO   history 1024 ; Digital Output at Power on
echo Link DigitalOutput 3 with curve %FACN%.%IDEN%.WTDO   history 1024 ; Digital Output at WatchDog TimeOut
echo Link DigitalOutput 4 with curve %FACN%.%IDEN%.RX     history 1024 ; Rx
echo Link DigitalOutput 5 with curve %FACN%.%IDEN%.TX     history 1024 ; Tx
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [%IDEN%.CustomParameters.TagList]
echo CustomIniFileRef  = ..\..\DEMO_DATA\I7043\%IDNF%_custom.ini
echo CustomIniSection  = [%IDEN%.CustomParameters]
echo CustomIniBackups  = ..\..\DEMO_DATA\I7043\Custom
echo CustomIniAutoLoad = 1
echo CustomIniAutoSave = 0
echo []
echo [ConfigFileList]
echo ConfigFile = ..\..\DEMO_DATA\I7043\%IDNF%_custom.ini
echo []
echo [%IDEN%.CustomParameters.TagList]
echo TagList = DEMO.%IDEN%.POLL
echo []
echo [DataStorage]
echo %FACN%.%IDEN%.STATE  = Curve 0 1000 Black 0  1 ; State of device
echo %FACN%.%IDEN%.DODATA = Curve 0 1000 Black 0  1 ; Digital Output Value
echo %FACN%.%IDEN%.PODO   = Curve 0 1000 Black 0  1 ; Digital Output at Power on
echo %FACN%.%IDEN%.WTDO   = Curve 0 1000 Black 0  1 ; Digital Output at WatchDog TimeOut
echo %FACN%.%IDEN%.RX     = Curve 0 1000 Black 0  1 ; Rx
echo %FACN%.%IDEN%.TX     = Curve 0 1000 Black 0  1 ; Tx
echo []
echo [TagList]
echo %FACN%.%IDEN%.DIMGUICLICK = string  ? ; Обрабочик "кликов" по DIM-серверу ( The DIM click sensor data )
echo %FACN%.%IDEN%.DIMCMDMY    = string  ? ; Обработчик команд от клиента      ( The DIM command handler   )
echo %FACN%.%IDEN%.SERVMODE    = Integer 2 ; Режим работы запущенной системы
echo %FACN%.%IDEN%.POLL        = Integer 0 ; Активация окна для выбора команд для опроса
echo %FACN%.%IDEN%.POLL.NOTIFY = Integer 0 ; Тег подтверждения выбора команд для опроса
echo %FACN%.%IDEN%.RX          = Integer 0 ; Скорость получения данных
echo %FACN%.%IDEN%.TX          = Integer 0 ; Скорость отправки данных
echo %FACN%.%IDEN%.STATE       = Integer 0 ; Состояние устройства
echo %FACN%.%IDEN%.DOALL       = Integer 0 ;
echo %FACN%.%IDEN%.DODATA      = Integer 0 ; Значение цифровых выходов
echo %FACN%.%IDEN%.DO1         = Integer 0 ; Значение цифрового выхода 1
echo %FACN%.%IDEN%.DO2         = Integer 0 ; Значение цифрового выхода 2
echo %FACN%.%IDEN%.DO3         = Integer 0 ; Значение цифрового выхода 3
echo %FACN%.%IDEN%.DO4         = Integer 0 ; Значение цифрового выхода 4
echo %FACN%.%IDEN%.DO5         = Integer 0 ; Значение цифрового выхода 5
echo %FACN%.%IDEN%.DO6         = Integer 0 ; Значение цифрового выхода 6
echo %FACN%.%IDEN%.DO7         = Integer 0 ; Значение цифрового выхода 7
echo %FACN%.%IDEN%.DO8         = Integer 0 ; Значение цифрового выхода 8
echo %FACN%.%IDEN%.DO9         = Integer 0 ; Значение цифрового выхода 9
echo %FACN%.%IDEN%.DO10        = Integer 0 ; Значение цифрового выхода 10
echo %FACN%.%IDEN%.DO11        = Integer 0 ; Значение цифрового выхода 11
echo %FACN%.%IDEN%.DO12        = Integer 0 ; Значение цифрового выхода 12
echo %FACN%.%IDEN%.DO13        = Integer 0 ; Значение цифрового выхода 13
echo %FACN%.%IDEN%.DO14        = Integer 0 ; Значение цифрового выхода 14
echo %FACN%.%IDEN%.DO15        = Integer 0 ; Значение цифрового выхода 15
echo %FACN%.%IDEN%.DO16        = Integer 0 ; Значение цифрового выхода 16
echo %FACN%.%IDEN%.PODO        = Integer 0 ; Значение цифровых выходов при включении питания
echo %FACN%.%IDEN%.WTDO        = Integer 0 ; Значение цифровых выходов при WatchDog TimeOut
echo %FACN%.%IDEN%.NAME        = String  Null ; Имя устройства
echo %FACN%.%IDEN%.VERSION     = String  Null ; Версия устройства
echo %FACN%.%IDEN%.ADDRESS     = Integer 0 ; Адрес устройства
echo %FACN%.%IDEN%.BAUDRATE    = Integer 0 ; Скорость бод устройства
echo %FACN%.%IDEN%.CHECKSUM    = Integer 0 ; Производить контроль CHECKSUM?
echo %FACN%.%IDEN%.PARITY      = Integer 0 ; Параметры PARITY
echo %FACN%.%IDEN%.PODOSET     = Integer 0 ; Задать значения цифровых выходов при Power on
echo %FACN%.%IDEN%.PODOREAD    = Integer 0 ; Считать значения цифровых выходов при Power on
echo %FACN%.%IDEN%.WTDOSET     = Integer 0 ; Задать значения цифровых выходов при WatchDog TimeOut
echo %FACN%.%IDEN%.WTDOREAD    = Integer 0 ; Считать значения цифровых выходов при WatchDog TimeOut
echo %FACN%.%IDEN%.WDTIMEOUT   = Real 0    ; Значение WatchDog TimeOut
echo %FACN%.%IDEN%.WDSTATUS    = Integer 0 ;
echo %FACN%.%IDEN%.WDENDIS     = Integer 0 ; Вкл./выкл. WatchDog
echo []
echo [Windows]
echo %FACN%.%IDEN%.CTRL = Circuit_Window
echo [%FACN%.%IDEN%.CTRL]
echo Circuit = ..\Circuits\i7043_ctrl.crc
echo Link sensor I7043.POLL       with tag   %FACN%.%IDEN%.POLL          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.NAME       with tag   %FACN%.%IDEN%.NAME          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.VERSION    with tag   %FACN%.%IDEN%.VERSION       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.RX         with curve %FACN%.%IDEN%.RX            device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.TX         with curve %FACN%.%IDEN%.TX            device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.ADDRESS    with tag   %FACN%.%IDEN%.ADDRESS       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.BAUDRATE   with tag   %FACN%.%IDEN%.BAUDRATE      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.CHECKSUM   with tag   %FACN%.%IDEN%.CHECKSUM      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PARITY     with tag   %FACN%.%IDEN%.PARITY        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO1        with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO2        with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO3        with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO4        with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO5        with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO6        with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO7        with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO8        with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO9        with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO10       with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO11       with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO12       with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO13       with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO14       with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO15       with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DO16       with tag   %FACN%.%IDEN%.DODATA        device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.LABEL      with                                   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.DOALL      with tag   %FACN%.%IDEN%.DOALL         device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO1      with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO2      with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO3      with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO4      with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO5      with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO6      with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO7      with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO8      with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO9      with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO10     with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO11     with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO12     with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO13     with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO14     with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO15     with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODO16     with tag   %FACN%.%IDEN%.PODO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODOSET    with tag   %FACN%.%IDEN%.PODOSET       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.PODOREAD   with tag   %FACN%.%IDEN%.PODOREAD      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO1      with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO2      with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO3      with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO4      with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO5      with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO6      with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO7      with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO8      with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO9      with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO10     with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO11     with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO12     with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO13     with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO14     with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO15     with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDO16     with tag   %FACN%.%IDEN%.WTDO          device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDOSET    with tag   %FACN%.%IDEN%.WTDOSET       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WTDOREAD   with tag   %FACN%.%IDEN%.WTDOREAD      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WDTIMEOUT  with tag   %FACN%.%IDEN%.WDTIMEOUT     device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WDENDIS    with tag   %FACN%.%IDEN%.WDENDIS       device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.WDSTATUS   with tag   %FACN%.%IDEN%.WDSTATUS      device ^&%FACN%.%IDEN%.CTRL
echo Link sensor I7043.STATE      with curve %FACN%.%IDEN%.STATE         device ^&%FACN%.%IDEN%.CTRL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FACN%.%IDEN%.CTRL.HOME 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinShow %FACN%.%IDEN%.CTRL
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Left=%CTRL_LEFT%^|Top=%CTRL_TOP%^|Width=481^|Height=438
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.job %FACN%.%IDEN%.CTRL.HOME @WinDraw %FACN%.%IDEN%.CTRL^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FACN%.%IDEN%.CTRL.SHOW 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.SHOW @WinShow %FACN%.%IDEN%.CTRL
echo @cron.tab %FACN%.%IDEN%.CTRL.HIDE 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.HIDE @WinHide %FACN%.%IDEN%.CTRL
echo @cron.tab %FACN%.%IDEN%.CTRL.SELECT 0 0 0
echo @cron.job %FACN%.%IDEN%.CTRL.SELECT @WinSelect %FACN%.%IDEN%.CTRL
echo @cron.job %mainprefix%.MAIN.CTRL.HOME @cron.run %FACN%.%IDEN%.CTRL.HOME
echo @cron.job %mainprefix%.MAIN.CTRL.HOME @cron.run %FACN%.%IDEN%.CTRL.HIDE
echo []
echo [%mainprefix%.MAIN.CTRL]
echo Link sensor @cron+@cron.run+%FACN%.%IDEN%.CTRL.SELECT with device ^&%mainprefix%.MAIN.CTRL
echo Link Sensor SYSTEMMODE               with tag  %FACN%.%IDEN%.SERVMODE  device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.STATE  with curve %FACN%.%IDEN%.STATE  device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO1    with tag   %FACN%.%IDEN%.DO1    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO2    with tag   %FACN%.%IDEN%.DO2    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO3    with tag   %FACN%.%IDEN%.DO3    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO4    with tag   %FACN%.%IDEN%.DO4    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO5    with tag   %FACN%.%IDEN%.DO5    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO6    with tag   %FACN%.%IDEN%.DO6    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO7    with tag   %FACN%.%IDEN%.DO7    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO8    with tag   %FACN%.%IDEN%.DO8    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO9    with tag   %FACN%.%IDEN%.DO9    device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO10   with tag   %FACN%.%IDEN%.DO10   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO11   with tag   %FACN%.%IDEN%.DO11   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO12   with tag   %FACN%.%IDEN%.DO12   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO13   with tag   %FACN%.%IDEN%.DO13   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO14   with tag   %FACN%.%IDEN%.DO14   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO15   with tag   %FACN%.%IDEN%.DO15   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DO16   with tag   %FACN%.%IDEN%.DO16   device ^&%FACN%.%IDEN%.CTRL
echo Link sensor %FACN%.%IDEN%.DOALL  with tag   %FACN%.%IDEN%.DOALL  device ^&%FACN%.%IDEN%.CTRL
echo []
echo [Windows]
echo %FACN%.%IDEN%.PARAM.PLOT = Curve_Window
echo [%FACN%.%IDEN%.PARAM.PLOT]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.25
echo AxisY = ^^CState channel^^N^^L___{Status}, 0, 1000
echo CurveList = %FACN%.%IDEN%.STATE
echo CurveList = %FACN%.%IDEN%.DODATA
echo CurveList = %FACN%.%IDEN%.PODO
echo CurveList = %FACN%.%IDEN%.WTDO
echo CurveList = %FACN%.%IDEN%.RX
echo CurveList = %FACN%.%IDEN%.TX
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FACN%.%IDEN%.PARAM.PLOT.HOME 0 0 0
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HOME @WinShow %FACN%.%IDEN%.PARAM.PLOT
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FACN%.%IDEN%.PARAM.PLOT^|Left=167^|Top=120^|Height=600^|Width=1000
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FACN%.%IDEN%.PARAM.PLOT^|Options=-Min,-Max,+Close,+VScroll,-HScroll,+StatusBar
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FACN%.%IDEN%.PARAM.PLOT^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FACN%.%IDEN%.PARAM.PLOT.SHOW 0 0 0
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.SHOW @WinShow %FACN%.%IDEN%.PARAM.PLOT
echo @cron.tab %FACN%.%IDEN%.PARAM.PLOT.HIDE 0 0 0
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.HIDE @WinHide %FACN%.%IDEN%.PARAM.PLOT
echo @cron.tab %FACN%.%IDEN%.PARAM.PLOT.SELECT 0 0 0
echo @cron.job %FACN%.%IDEN%.PARAM.PLOT.SELECT @WinSelect %FACN%.%IDEN%.PARAM.PLOT
echo @cron.job %mainprefix%.MAIN.CTRL.HOME @cron.run %FACN%.%IDEN%.PARAM.PLOT.HOME
echo @cron.job %mainprefix%.MAIN.CTRL.HOME @cron.run %FACN%.%IDEN%.PARAM.PLOT.HIDE
echo []
echo [^&DATSRV]
echo CurveList = %FACN%.%IDEN%.STATE
echo CurveList = %FACN%.%IDEN%.DODATA
echo CurveList = %FACN%.%IDEN%.PODO
echo CurveList = %FACN%.%IDEN%.WTDO
echo CurveList = %FACN%.%IDEN%.RX
echo CurveList = %FACN%.%IDEN%.TX
echo []
echo [DeviceList]
echo ^&%FACN%.%IDEN%.POLL.ENABLE = device software dialog
echo [^&%FACN%.%IDEN%.POLL.ENABLE]
echo DialogSection = ^&%FACN%.%IDEN%.POLL.ENABLE.Section ; Имя секции с описанием диалога
echo CloseOnEnter = 1                 ; Закрывать диалог по Enter,Esc?
echo DebugMode = 0                    ; Выводить сообщения в файл отладки?
echo Adjustment = 1                   ; Диалог при открытии выравнивать по положению мыши?
echo NotifyTag = %FACN%.%IDEN%.POLL.NOTIFY ; Уведомление о нажатии 1=Ok,2=Cancel
echo []
echo [^&%FACN%.%IDEN%.POLL.ENABLE.Section]
echo Dialog       0   0   295 200 Выбор команд для опроса
echo CheckBoxes   5   35  285 160 %FACN%.%IDEN%.POLL 8
echo  Состояние цифровых выходов (ЦВ)
echo  Cтатус WatchDog
echo  Значение WatchDog TimeOut
echo  Состояние ЦВ при вкл.-ии питания
echo  Состояние ЦВ при WatchDog
echo  Конфигурация устройства
echo  Версия устройства
echo  Имя устройства
echo []
goto :EOF

:I7043_SIM
echo [^&%FACN%.%IDEN%.CTRL]
echo Simulator = 1
echo []
rem Include hardware config if one not done yet
if "%numhdwcfg%" == "0" ( set /a numhdwcfg=numhdwcfg+1 ) else ( goto :EOF )
echo [ConfigFileList]
echo ConfigFile = %hdwcfg%
echo []
echo.
goto :EOF

:I7043_DIS
unix dimcfg ^
  -n section "[&%FACN%.%IDEN%.CTRL]" ^
  -n print    DimServerMode = 1 ^
  -n end ^
  -n dis_cmnd   %FACP%/%IDNP%/DIMGUICLICK ^
  -n tag       %FACN%.%IDEN%.DIMGUICLICK ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DIMGUICLICK=%%**" ^
  -n end ^
  -n dis_cmnd   %FACP%/%IDNP%/DIMCMDMY ^
  -n tag       %FACN%.%IDEN%.DIMCMDMY ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DIMCMDMY=%%**" ^
  -n end ^
  -n dic_cmnd   %FACP%/%IDNP%/DIMGUICLICK ^
  -n tag       %FACN%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dic_cmnd   %FACP%/%IDNP%/DIMCMDMY ^
  -n tag       %FACN%.%IDEN%.DIMCMDMY ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/POLL ^
  -n tag       %FACN%.%IDEN%.POLL ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/STATE ^
  -n tag       %FACN%.%IDEN%.STATE ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/RX+TX ^
  -n tag       %FACN%.%IDEN%.RX ^
  -n tag       %FACN%.%IDEN%.TX ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/DOALL ^
  -n tag       %FACN%.%IDEN%.DOALL ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/DODATA+DO1+DO2+DO3+DO4+DO5+DO6+DO7+DO8+DO9+DO10+DO11+DO12+DO13+DO14+DO15+DO16 ^
  -n tag       %FACN%.%IDEN%.DODATA ^
  -n tag       %FACN%.%IDEN%.DO1 ^
  -n tag       %FACN%.%IDEN%.DO2 ^
  -n tag       %FACN%.%IDEN%.DO3 ^
  -n tag       %FACN%.%IDEN%.DO4 ^
  -n tag       %FACN%.%IDEN%.DO5 ^
  -n tag       %FACN%.%IDEN%.DO6 ^
  -n tag       %FACN%.%IDEN%.DO7 ^
  -n tag       %FACN%.%IDEN%.DO8 ^
  -n tag       %FACN%.%IDEN%.DO9 ^
  -n tag       %FACN%.%IDEN%.DO10 ^
  -n tag       %FACN%.%IDEN%.DO11 ^
  -n tag       %FACN%.%IDEN%.DO12 ^
  -n tag       %FACN%.%IDEN%.DO13 ^
  -n tag       %FACN%.%IDEN%.DO14 ^
  -n tag       %FACN%.%IDEN%.DO15 ^
  -n tag       %FACN%.%IDEN%.DO16 ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/PODO ^
  -n tag       %FACN%.%IDEN%.PODO ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/WTDO ^
  -n tag       %FACN%.%IDEN%.WTDO ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/NAME ^
  -n tag       %FACN%.%IDEN%.NAME ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/VERSION ^
  -n tag       %FACN%.%IDEN%.VERSION ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/ADDRESS ^
  -n tag       %FACN%.%IDEN%.ADDRESS ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/BAUDRATE ^
  -n tag       %FACN%.%IDEN%.BAUDRATE ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/CHECKSUM ^
  -n tag       %FACN%.%IDEN%.CHECKSUM ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/PARITY ^
  -n tag       %FACN%.%IDEN%.PARITY ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/PODOSET ^
  -n tag       %FACN%.%IDEN%.PODOSET ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/PODOREAD ^
  -n tag       %FACN%.%IDEN%.PODOREAD ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/WTDOSET ^
  -n tag       %FACN%.%IDEN%.WTDOSET ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/WTDOREAD ^
  -n tag       %FACN%.%IDEN%.WTDOREAD ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/WDTIMEOUT ^
  -n tag       %FACN%.%IDEN%.WDTIMEOUT ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/WDSTATUS ^
  -n tag       %FACN%.%IDEN%.WDSTATUS ^
  -n end ^
  -n dis_info   %FACP%/%IDNP%/WDENDIS ^
  -n tag       %FACN%.%IDEN%.WDENDIS ^
  -n end ^
echo.
goto :EOF

:I7043_DIC
unix dimcfg ^
  -n section "[&%FACN%.%IDEN%.CTRL]" ^
  -n print    DimClientMode = 1 ^
  -n end ^
  -n dic_cmnd   %FACP%/%IDNP%/DIMGUICLICK ^
  -n tag       %FACN%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/POLL ^
  -n tag       %FACN%.%IDEN%.POLL ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/STATE ^
  -n tag       %FACN%.%IDEN%.STATE ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.STATE" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/RX+TX ^
  -n tag       %FACN%.%IDEN%.RX ^
  -n tag       %FACN%.%IDEN%.TX ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.RX" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.TX" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/DOALL ^
  -n tag       %FACN%.%IDEN%.DOALL ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/DODATA+DO1+DO2+DO3+DO4+DO5+DO6+DO7+DO8+DO9+DO10+DO11+DO12+DO13+DO14+DO15+DO16 ^
  -n tag       %FACN%.%IDEN%.DODATA ^
  -n tag       %FACN%.%IDEN%.DO1 ^
  -n tag       %FACN%.%IDEN%.DO2 ^
  -n tag       %FACN%.%IDEN%.DO3 ^
  -n tag       %FACN%.%IDEN%.DO4 ^
  -n tag       %FACN%.%IDEN%.DO5 ^
  -n tag       %FACN%.%IDEN%.DO6 ^
  -n tag       %FACN%.%IDEN%.DO7 ^
  -n tag       %FACN%.%IDEN%.DO8 ^
  -n tag       %FACN%.%IDEN%.DO9 ^
  -n tag       %FACN%.%IDEN%.DO10 ^
  -n tag       %FACN%.%IDEN%.DO11 ^
  -n tag       %FACN%.%IDEN%.DO12 ^
  -n tag       %FACN%.%IDEN%.DO13 ^
  -n tag       %FACN%.%IDEN%.DO14 ^
  -n tag       %FACN%.%IDEN%.DO15 ^
  -n tag       %FACN%.%IDEN%.DO16 ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DODATA" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO1" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO2" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO3" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO4" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO5" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO6" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO7" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO8" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO9" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO10" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO11" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO12" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO13" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO14" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO15" ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.DO16" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/PODO ^
  -n tag       %FACN%.%IDEN%.PODO ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.PODO" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/WTDO ^
  -n tag       %FACN%.%IDEN%.WTDO ^
  -n %devmsg% "&%FACN%.%IDEN%.CTRL @DimTagUpdate=%FACN%.%IDEN%.WTDO" ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/NAME ^
  -n tag       %FACN%.%IDEN%.NAME ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/VERSION ^
  -n tag       %FACN%.%IDEN%.VERSION ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/ADDRESS ^
  -n tag       %FACN%.%IDEN%.ADDRESS ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/BAUDRATE ^
  -n tag       %FACN%.%IDEN%.BAUDRATE ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/CHECKSUM ^
  -n tag       %FACN%.%IDEN%.CHECKSUM ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/PARITY ^
  -n tag       %FACN%.%IDEN%.PARITY ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/PODOSET ^
  -n tag       %FACN%.%IDEN%.PODOSET ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/PODOREAD ^
  -n tag       %FACN%.%IDEN%.PODOREAD ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/WTDOSET ^
  -n tag       %FACN%.%IDEN%.WTDOSET ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/WTDOREAD ^
  -n tag       %FACN%.%IDEN%.WTDOREAD ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/WDTIMEOUT ^
  -n tag       %FACN%.%IDEN%.WDTIMEOUT ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/WDSTATUS ^
  -n tag       %FACN%.%IDEN%.WDSTATUS ^
  -n end ^
  -n dic_info   %FACP%/%IDNP%/WDENDIS ^
  -n tag       %FACN%.%IDEN%.WDENDIS ^
  -n end ^
echo.
goto :EOF

:I7043_TABCRC
set /a YPOS=TABCRC_TOP+90
set /a DOPOS=YPOS+35
echo [SensorList]
echo Sensor = @cron+@cron.run+%FACN%.%IDEN%.CTRL.SELECT
echo [@cron+@cron.run+%FACN%.%IDEN%.CTRL.SELECT]
echo Pos = 10, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:18\Color:Black
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_12_20_24_lightsteelblue1_ptmono.bmp %DevLabel%
echo Hint =%FACN%.%IDEN%.CTRL: Открыть окно управления %IDEN%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO1
echo [%FACN%.%IDEN%.DO1]
echo Pos = 10, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 1
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 1
echo Hint = Вкл/выкл канал 1 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO2
echo [%FACN%.%IDEN%.DO2]
echo Pos = 40, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 2
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 2
echo Hint = Вкл/выкл канал 2 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO3
echo [%FACN%.%IDEN%.DO3]
echo Pos = 70, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 3
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 3
echo Hint =%FACN%.%IDEN%.DO3: Вкл/выкл канал 3 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO4
echo [%FACN%.%IDEN%.DO4]
echo Pos = 100, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 4
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 4
echo Hint =%FACN%.%IDEN%.DO4: Вкл/выкл канал 4 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO5
echo [%FACN%.%IDEN%.DO5]
echo Pos = 130, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 5
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 5
echo Hint =%FACN%.%IDEN%.DO5: Вкл/выкл канал 5 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO6
echo [%FACN%.%IDEN%.DO6]
echo Pos = 160, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 6
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 6
echo Hint =%FACN%.%IDEN%.DO6: Вкл/выкл канал 6 %DevLabel%
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO7
echo [%FACN%.%IDEN%.DO7]
echo Pos = 190, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 7
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 7
echo Hint =%FACN%.%IDEN%.DO7: Вкл/выкл канал 7 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO8
echo [%FACN%.%IDEN%.DO8]
echo Pos = 220, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 8
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 8
echo Hint =%FACN%.%IDEN%.DO8: Вкл/выкл канал 8 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO9
echo [%FACN%.%IDEN%.DO9]
echo Pos = 250, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 9
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 9
echo Hint =%FACN%.%IDEN%.DO9: Вкл/выкл канал 9 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO10
echo [%FACN%.%IDEN%.DO10]
echo Pos = 280, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 10
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 10
echo Hint =%FACN%.%IDEN%.DO10: Вкл/выкл канал 10 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO11
echo [%FACN%.%IDEN%.DO11]
echo Pos = 310, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 11
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 11
echo Hint =%FACN%.%IDEN%.DO11: Вкл/выкл канал 11 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO12
echo [%FACN%.%IDEN%.DO12]
echo Pos = 340, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 12
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 12
echo Hint =%FACN%.%IDEN%.DO12: Вкл/выкл канал 12 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO13
echo [%FACN%.%IDEN%.DO13]
echo Pos = 370, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 13
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 13
echo Hint =%FACN%.%IDEN%.DO13: Вкл/выкл канал 13 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO14
echo [%FACN%.%IDEN%.DO14]
echo Pos = 400, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 14
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 14
echo Hint =%FACN%.%IDEN%.DO14: Вкл/выкл канал 14 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO15
echo [%FACN%.%IDEN%.DO15]
echo Pos = 430, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 15
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 15
echo Hint =%FACN%.%IDEN%.DO15: Вкл/выкл канал 15 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DO16
echo [%FACN%.%IDEN%.DO16]
echo Pos = 460, %DOPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_silver.bmp 16
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_20_30_24_lime.bmp 16
echo Hint =%FACN%.%IDEN%.DO16: Вкл/выкл канал 16 %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.DOALL
echo [%FACN%.%IDEN%.DOALL]
echo Pos = 380, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:14\Color:Black
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=2)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_130_30_24_silver.bmp Все+каналы
echo Hint = Управление всеми каналами %DevLabel%
echo []
echo [SensorList]
echo Sensor =%FACN%.%IDEN%.STATE
echo [%FACN%.%IDEN%.STATE]
echo Pos = 220, %YPOS%
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:18
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_silver_ptmono.bmp Выключен
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_lime_ptmono.bmp   Работает
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_red_ptmono.bmp    Timeout
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_red_ptmono.bmp    Refused
echo Tag#5 = 4, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_red_ptmono.bmp    WatchDog
echo Tag#6 = 5, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_yellow_ptmono.bmp Simulator
echo Hint = Состояние устройства %DevLabel%
echo []
set /a TABCRC_TOP+=TABCRC_STEP
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
