 {
 Demo terminal for pipe I/O
 }
program Pipe;
const
 dfTrouble      = 1;       { DebugFlags - Trouble             }
 dfSuccess      = 2;       { DebugFlags - Success             }
 dfViewExp      = 4;       { DebugFlags - ViewExp             }
 dfViewImp      = 8;       { DebugFlags - ViewImp             }
var
 b              : Boolean;
 Ok             : Boolean;
 errors         : Integer;
 errorcode      : Integer;
 DebugFlags     : Integer;
 FixMaxAvail    : Integer;
 TaskPipe       : Integer;
 TaskBuff       : String;
 PipePipe       : Integer;
 PipeBuff       : String;
 TcpPipe        : Integer;
 NumLines       : Integer;
 i              : Integer;
 r              : Real;
 s              : String;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on data import to program.
 }
 procedure ViewImp(msg:String);
 begin
  if iand(DebugFlags,dfViewImp)<>0 then
  if length(msg)>0 then writeln(devname+' < '+msg);
 end;
 {
 Report on data export from program.
 }
 procedure ViewExp(msg:String);
 begin
  if iand(DebugFlags,dfViewExp)<>0 then
  if length(msg)>0 then writeln(devname+' > '+msg);
 end;
 {
 Check I/O status.
 }
 function IoError:Boolean;
 begin
  IoError:=false;
  if ioresult<>0 then begin
   Trouble('I/O error.');
   IoError:=true;
  end;
 end;
 {
 Process standard input...
 while StdIn_Readln(StdIn_Line) do StdIn_Process(StdIn_Line);
 }
 {
 Read string line from standard input.
 }
 function StdIn_Readln(var Data:string):boolean;
 begin
  Data:='';
  if not IoError then
  if not Eof then Readln(Data);
  if IoError then Data:='';
  StdIn_Readln:=Length(Data)>0;
 end;
 {
 Show/hide device console.
 }
 procedure OpenConsole(Mode:Integer);
 var b:Boolean;
  procedure ShowWin(WinName:String);
  begin
   b:=WinShow(WinName);
   b:=WinDraw(WinName+'|top=317|left=0|width=600|height=317');
   if Mode=1 then b:=WinSelect(WinName) else b:=WinHide(WinName);
  end;
 begin
  if Mode>0 then ShowWin(ParamStr('Console '+DevName))
 end; 
 {
 Read line (Line) from pipe (pip) with CR or LF line terminator (EOL).
 Temporary buffer (Buff) should be global lifetime variable with startup initialization.
 }
 function Pipe_Readln(pip:Integer; var Line,Buff:String):Boolean;
 const MaxLeng = 16384;
 var p:Integer;
 begin
  Line:='';
  Pipe_Readln:=false;
  if (Pipe_Pid(pip)<>0) then begin
   if (Length(Buff)<MaxLeng) and (Pipe_RxCount(pip)>0)
   then Buff:=Buff+Pipe_Recv(pip,MaxLeng-Length(Buff));
   p:=PosEol(Buff,1,0);
   if (p>0) then begin
    Pipe_Readln:=True;
    if (p>1) then Line:=Copy(Buff,1,p-1);
    Buff:=Copy(Buff,PosEol(Buff,p,1),MaxInt);
   end else begin
    if (Length(Buff)>=MaxLeng) then begin
     Trouble('Received line is too long!');
     Buff:='';
    end;
   end;
  end;
 end;
 {
 Send Data and EOL to pipe with error checking.
 }
 procedure Pipe_Writeln(pipe:Integer; Data:String);
 var Leng,Sent:Integer;
 begin
  Leng:=Length(Data);
  if Leng>0 then begin
   Sent:=pipe_send(pipe,Data+EOL);
   if Sent<Leng+Length(EOL) then Trouble('Pipe send error!');
  end;
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 var i:Integer;
 begin
  s:='';
  TaskBuff:='';
  PipeBuff:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Analyse data coming from standard input.
 }
 procedure StdIn_Process(Data:string);
 var i:Integer;
 begin
  ViewImp(Data);
  // Send data to Task
  Pipe_Writeln(TaskPipe,Data);
  // Send data to Pipe
  Pipe_Writeln(PipePipe,Data);
  // Send data to all TCP clients
  for i:=0 to pipe_count(TcpPipe)-1 do
  if pipe_connected(pipe_stream(TcpPipe,i))>0
  then Pipe_Writeln(pipe_stream(TcpPipe,i),Data);
 end;
 {
 First time Pipe initialization
 }
 procedure PipeInit;
 begin
  TaskPipe:=0; TaskBuff:='';
  PipePipe:=0; PipeBuff:='';
 end;
 {
 Pipe finalization
 }
 procedure PipeFree;
 var i:Integer;
 begin
  if TaskPipe<>0 then b:=pipe_free(TaskPipe); TaskPipe:=0; TaskBuff:='';
  if PipePipe<>0 then b:=pipe_free(PipePipe); PipePipe:=0; PipeBuff:='';
  if TcpPipe<>0 then b:=pipe_free(TcpPipe);   TcpPipe:=0;
 end;
begin
 {
 Initialization actions on Start
 }
 if runcount=1 then begin
  errors:=0;
  errorcode:=registererr(devname);
  DebugFlags:=15;
  OpenConsole(1);
  ClearStrings;
  Success('Starting...');
  PipeInit;
  //
  // Open demo terminals...
  //
  r:=eval('@async @term -c  pipe .\test');
  r:=eval('@async @term -ca task ping /t localhost');
  r:=eval('@async @term -c  tcp port 1234 client localhost');
  r:=eval('@async @term -cx tcp port 1234 client '+ParamStr('ComputerName'));
  //
  // Create Task pipe - command processor
  //
  TaskPipe:=pipe_init('task '+GetComSpec);
  if pipe_run(TaskPipe)
  then Success('Run Task - Ok '+GetComSpec+' PID '+Str(task_pid(TaskPipe)))
  else Trouble('Run Task - Fails '+GetComSpec);
  //
  // Create named pipe server - test
  //
  PipePipe:=pipe_init('pipe test');
  if pipe_run(PipePipe)
  then Success('Run Pipe - Ok')
  else Trouble('Run Pipe - Fails');
  //
  // Create TCP pipe - port 1234, server for 3 clients
  //
  TcpPipe:=pipe_init('tcp port 1234 server 3');
  if pipe_run(TcpPipe)
  then Success('Run Tcp - Ok')
  else Trouble('Run Tcp - Fails');
  //
  if errors=0 then Success('Start Ok') else Trouble('Start Fails');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop
 }
 if isinf(runcount) then begin
  PipeFree;
  Success('Stop');
  ClearStrings;
 end else
 {
 Actions on Poll
 }
 if Ok then begin
  {
  Process standard input...
  }
  while StdIn_Readln(s) do StdIn_Process(s);
  {
  Read Task pipe data
  }
  NumLines:=0;
  if pipe_connected(TaskPipe)>0 then
  while Pipe_Readln(TaskPipe,s,TaskBuff) and (NumLines<100) do begin
   if IsWindows then s:=strconv('oem2ansi',s); // Convert OEM to ANSI
   ViewImp(RefInfo(TaskPipe,'Type')+': '+s);
   NumLines:=NumLines+1;
  end;
  {
  Read Pipe pipe data
  }
  NumLines:=0;
  if pipe_connected(PipePipe)>0 then
  while Pipe_Readln(PipePipe,s,PipeBuff) and (NumLines<100)  do begin
   ViewImp(RefInfo(PipePipe,'Type')+': '+s);
   NumLines:=NumLines+1;
  end;
  {
  Read TCP pipe data from all clients
  Use pipe_count and pipe_stream for that
  }
  if pipe_connected(TcpPipe)>0 then
  for i:=0 to pipe_count(TcpPipe)-1 do
  if pipe_rxcount(pipe_stream(TcpPipe,i))>0 then begin
   s:=pipe_recv(pipe_stream(TcpPipe,i),16384);
   ViewImp(RefInfo(TcpPipe,'Type')+'-'+pipe_ctrl(pipe_stream(TcpPipe,i),'PeerIP')+': '+TrimRight(s));
  end;
 end;
end.



