@echo off
SetLocal EnableExtensions EnableDelayedExpansion

echo.
echo ####################################################
echo # CRW-DAQ Initialization script. Run on DAQ logon. #
echo ####################################################
echo.

if "%CRW_DAQ_SYS_HOME_DIR%" == "" ( echo The script should be called from CRW-DAQ system only. & goto :EOF )
if "%CRW_DAQ_CONFIG_HOME_DIR%" == "" ( echo The script should be called from DAQ system only. & goto :EOF )

set MySelf=%~f0

pushd "%~dp0.." && call :Logon %*
popd

goto :EOF

:Logon
call :EnterLogFile
call :ClearTempDir
call :VerifyIntegrity
call :LeaveLogFile
goto :EOF

:EnterLogFile
set logFile="%cd%\temp\%~n0.log"
echo %Date%-%Time%: >> "%logFile%"
echo Enter "%MySelf%" >> "%logFile%"
goto :EOF

:LeaveLogFile
echo %Date%-%Time%: >> "%logFile%"
echo Leave "%MySelf%" >> "%logFile%"
goto :EOF

:ClearTempDir
echo ClearTempDir: >> "%logFile%"
pushd "%cd%\temp" && call :DoClearTempDir
popd
goto :EOF

:DoClearTempDir
del /F /S /Q *.LST >> "%logFile%"
del /F /S /Q *.TMP >> "%logFile%"
set /a sizeKeep=1024*512
unix purger -ra !sizeKeep! *.* >> "%logFile%"
goto :EOF

:VerifyIntegrity
call utility\daqsys.verify.cmd >> "%logFile%"
goto :EOF
