---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Программа &LinCorr

Программа расчета линейной корреляции для сглаживания и дифференцирования зашумленных сигналов.

---

## Назначение и краткое описание

<a name="about"></a>

Программа **&LinCorr** предназначена для выполнения расчета линейной корреляции (_Linear Correlation_),
то есть сглаживания и дифференцирования зашумленных сигналов с заданным окном.

Операция дифференцирования неустойчива к шуму, поэтому для неё сглаживание является необходимым.


Алгоритм расчета такой.  

- На входе есть зашумленный **SIGNAL**.  
- Задаем в теге **Gate** (разрешающее "окно") и **SmoothWind** (ширина окна сглаживания).  
- Находим **X** - координату последней точки сигнала - **`xb`** и точку **`xa=xb-SmootWind`**.  
- Берем интервал **`[xa,xb]`** и вычисляем коэффициенты **C0**, **C1** линейной регрессии
  **`y=C0+C1*(x-xc)`**, где **`xc=(xb+xa)/2`** - середина окна.  
- Коэффициент **C0** дает сглаженное (среднее) значение, а коэффициент **C1** - сглаженную производную.  
- Эти коэффициенты **(xc,C0)** и **(xc,C1)** и записываются в кривые **AnalogOutput(0,1)**.  


Программа **OVRTRIGGER** (_OverRange Trigger_) - триггер диапазона - служит для отслеживания
значения некоторой величины **Y** (в данном случае производной **DERIVAT1**) на входе **AI0**.
В момент нажатия кнопки **СТАРТ** значение **Y** запоминается в **Y0**. После этого, пока нажата
кнопка, выполняется расчет триггера по формуле **TRIGGER.FORMULA**, при этом любое ненулевое
значение означает **TRUE** (триггер включен).  
Например:

```
ge(y,y0*2)+le(y,y0/2)  - триггер включается если значение Y выросло или упало в 2 раза от начального Y0
ge(y,800)+le(y,200)    - триггер включается если значение Y вышло за пределы диапазона (200,800)
```

Если триггер сработал (**TRUE**), то выполняются команды **CRON**, заданные строками **TRIGGER.COMMAND1,2,3**.  
Например:

```
@Speak Фазовый переход                                               - произносит сообщение
@Run -hide unix tooltip-notifier text "Фазовый переход" delay 10000  - выводит всплывающее сообщение на 10 сек
@DevMsg &OVRTRIGGER @AssignTag TRIGGER.START 0                       - посылает сообщение выключить кнопку START
```

Параметр **TRIGGER.PERIOD** задает период повторения выполнения команд при включенном триггере.

Кнопки **SaveINI**, **LoadINI** позволяют сохранить или загрузить параметры (формулы) **OVRTRIGGER** в **INI** файле.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Польза от использования &LinCorr

<a name="benefit"></a1>

Использование  **&LinCorr** может принести пользу в следующих случаях:

1. **&LinCorr** позволяет сглаживать зашумленные данные в реальном времени.

2. **&LinCorr** позволяет дифференцировать зашумленные данные устойчивым к шуму алгоритмом в реальном времени.  
   Производные используются, например, для определения точки фазового перехода при нагревании.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Состав и конфигурирование &LinCorr

<a name="config"></a1>

1. **`AnalogInput[N]`** - входной сигнал номер **N** (**0..AnalogInputs-1**).  
2. **`AnalogOutput[2*N]`** - выходной сигнал усредненного (сглаженного) значения.  
3. **`AnalogOutput[2*N+1]`** - выходной сигнал значения сглаженной производной.  
4. **`tagGate`** или **`tagGateN`** - **Integer** тег разрешения обработки.  
5. **`tagSmoothWind`** или **`tagSmoothWindN`** - **Real** тег ширины окна сглаживания.  
   Окно сглаживания задается в единицах **[DAQ] TimeUnits**.  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Пример LinCorr-конфигурации

<a name="example"></a>

```
[TagList]
SMOOTH_GATE   = integer 1        ; Smoothing gate
SMOOTH_WINDOW = real 0.002777778 ; Smoothing window, 0.002(7)=10/3600=10 sec.
[]
[DeviceList]
&LinCorr = device software program
[&LinCorr]
Comment       = Linear Correlation calculator
InquiryPeriod = 1
DevicePolling = 1000, tpNormal
ProgramSource = ..\DaqPas\_lincorr.pas
OpenConsole   = 2
DebugFlags    = 15
AnalogInputs  = 2
Link AnalogInput  0 with curve SIGNAL1
Link AnalogInput  1 with curve SIGNAL2
AnalogOutputs = 4
Link AnalogOutput  0 with curve AVERAGE1  history 10000 ; Average (mean) value of SIGNAL1
Link AnalogOutput  1 with curve DERIVAT1  history 10000 ; Smoothed derivation of  SIGNAL1
Link AnalogOutput  2 with curve AVERAGE2  history 10000 ; Average (mean) value of SIGNAL2
Link AnalogOutput  3 with curve DERIVAT2  history 10000 ; Smoothed derivation of  SIGNAL2
tagSmoothWind = SMOOTH_WINDOW
tagGate       = SMOOTH_GATE
[]
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

**Желаем успешного использовния &LinCorr!**

---

> CRW-DAQ Copyright (c) 2001-2024 Alexey Kuryakin <kouriakine@mail.ru>.

---
