
// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the GENESYSDRV_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// GENESYSDRV_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifdef GENESYSDRV_EXPORTS
#define GENESYSDRV_API __declspec(dllexport)
#else
#define GENESYSDRV_API __declspec(dllimport)
#endif

#define GENESYS_DEVTYPE_UNKNOWN     -1
#define GENESYS_DEVTYPE_6_100       0
#define GENESYS_DEVTYPE_6_200       1
#define GENESYS_DEVTYPE_8_90        2
#define GENESYS_DEVTYPE_8_180       3
#define GENESYS_DEVTYPE_12_5_60     4
#define GENESYS_DEVTYPE_12_5_120    5
#define GENESYS_DEVTYPE_20_38       6
#define GENESYS_DEVTYPE_20_76       7
#define GENESYS_DEVTYPE_30_25       8
#define GENESYS_DEVTYPE_30_50       9
#define GENESYS_DEVTYPE_40_19       10
#define GENESYS_DEVTYPE_40_38       11
#define GENESYS_DEVTYPE_60_12_5     12
#define GENESYS_DEVTYPE_60_25       13
#define GENESYS_DEVTYPE_80_9_5      14
#define GENESYS_DEVTYPE_80_19       15
#define GENESYS_DEVTYPE_100_7_5     16
#define GENESYS_DEVTYPE_100_15      17
#define GENESYS_DEVTYPE_150_5       18
#define GENESYS_DEVTYPE_150_10      19
#define GENESYS_DEVTYPE_300_2_5     20
#define GENESYS_DEVTYPE_300_5       21
#define GENESYS_DEVTYPE_600_1_3     22
#define GENESYS_DEVTYPE_600_2_6     23
#define GENESYS_DEVTYPE_H_8_90     24
#define GENESYS_DEVTYPE_H_20_38     25
#define GENESYS_DEVTYPE_H_40_19     26
#define GENESYS_DEVTYPE_H_60_12_5     27
#define GENESYS_DEVTYPE_H_80_9_5     28
#define GENESYS_DEVTYPE_H_150_5     29
#define GENESYS_DEVTYPE_H_300_2_5     30
#define GENESYS_DEVTYPE_H_600_1_3     31
#define GENESYS_DEVTYPE_H_6_100       32
#define GENESYS_DEVTYPE_H_12_5_60     33
#define GENESYS_DEVTYPE_H_30_25       34
#define GENESYS_DEVTYPE_H_100_7_5     35
#define GENESYS_DEVTYPE_MAXUNKNOWN  36

// cb-function
typedef void (*GENESYS_CBPTR)(int);

GENESYSDRV_API BOOL genInitDll();
GENESYSDRV_API void genReleaseDll();

GENESYSDRV_API BOOL genOpenComPort(int nComPort, int nBaudrate);
GENESYSDRV_API BOOL genOpenComPort(int nComPort, int nBaudrate,int nWaitForAnswer10MS);
GENESYSDRV_API BOOL genCloseComPort();

GENESYSDRV_API BOOL genSetServiceRequestWindow(HWND hWnd, UINT nWndMsg);
GENESYSDRV_API BOOL genSetServiceCallbackFunction(GENESYS_CBPTR pCallbackFunction);
GENESYSDRV_API void genDisableServiceRequest();

GENESYSDRV_API const char* genGetLastError();

GENESYSDRV_API const char* genGetRevision();

GENESYSDRV_API int genGetNumberOfSupportedDevices();

GENESYSDRV_API const char* genDeviceIDToString(int nDeviceType);
GENESYSDRV_API int genDeviceStringToID(const char* pszDeviceString);

GENESYSDRV_API int genGetMaxCurrent(int nDeviceType);
GENESYSDRV_API int genGetMaxVoltage(int nDeviceType);
GENESYSDRV_API int genGetMaxOvp(int nDeviceType);
GENESYSDRV_API int genGetMinOvp(int nDeviceType);
GENESYSDRV_API int genGetMaxUvl(int nDeviceType);
GENESYSDRV_API int genGetMinUvl(int nDeviceType);

GENESYSDRV_API BOOL genCmdAdr(int nDeviceAddress);

GENESYSDRV_API BOOL genCmdCls();
GENESYSDRV_API BOOL genCmdRst();
GENESYSDRV_API BOOL genCmdRmtSet(int nMode, BOOL bNewFirmware);
GENESYSDRV_API BOOL genCmdRmtGet(int* pnMode);

GENESYSDRV_API BOOL genCmdIdn(char* pszBuffer);
GENESYSDRV_API BOOL genCmdRev(char* pszBuffer);
GENESYSDRV_API BOOL genCmdSn(char* pszBuffer);
GENESYSDRV_API BOOL genCmdDate(char* pszBuffer);

GENESYSDRV_API BOOL genCmdOutSet(BOOL bOn);
GENESYSDRV_API BOOL genCmdOutGet(BOOL* pbOn);
GENESYSDRV_API BOOL genCmdFldSet(BOOL bOn);
GENESYSDRV_API BOOL genCmdFldGet(BOOL* pbOn);
GENESYSDRV_API BOOL genCmdAstSet(BOOL bOn);
GENESYSDRV_API BOOL genCmdAstGet(BOOL* pbOn);

GENESYSDRV_API BOOL genCmdSav();
GENESYSDRV_API BOOL genCmdRcl();
GENESYSDRV_API BOOL genCmdMode(int* pnMode);

GENESYSDRV_API BOOL genCmdFlt(unsigned char* pucFaultCondReg);
GENESYSDRV_API BOOL genCmdFenaSet(unsigned char ucFaultEnableReg);
GENESYSDRV_API BOOL genCmdFenaGet(unsigned char* pucFaultEnableReg);
GENESYSDRV_API BOOL genCmdFeve(unsigned char* pucFaultEventReg);
GENESYSDRV_API BOOL genCmdStat(unsigned char* pucStatusCondReg);
GENESYSDRV_API BOOL genCmdSenaSet(unsigned char ucStatusEnableReg);
GENESYSDRV_API BOOL genCmdSenaGet(unsigned char* pucStatusEnableReg);
GENESYSDRV_API BOOL genCmdSeve(unsigned char* pucStatusEventReg);

GENESYSDRV_API BOOL genCmdOvm();

GENESYSDRV_API BOOL genCmdPvSet(int nVoltageMV);
GENESYSDRV_API BOOL genCmdPcSet(int nCurrentMA);
GENESYSDRV_API BOOL genCmdPvGet(int* pnVoltageMV);
GENESYSDRV_API BOOL genCmdPcGet(int* pnCurrentMA);
GENESYSDRV_API BOOL genCmdMv(int* pnVoltageMV);
GENESYSDRV_API BOOL genCmdMc(int* pnCurrentMA);

GENESYSDRV_API BOOL genCmdOvpSet(int nVoltageMV);
GENESYSDRV_API BOOL genCmdUvlSet(int nVoltageMV);
GENESYSDRV_API BOOL genCmdOvpGet(int* pnVoltageMV);
GENESYSDRV_API BOOL genCmdUvlGet(int* pnVoltageMV);

GENESYSDRV_API BOOL genCmdStt(int* pnSetVoltage, int* pnActualVoltage, int* pnSetCurrent, int* pnActualCurrent, unsigned char* pucStatusReg, unsigned char* pucFaultReg);
