 {
 Demo program to measure polling time
 i.e. time difference between consecutive program calls.
 It also demonstrate how to switch on/off fast polling
 with frequency about 1000 Hz.
 }
program fast_poll;
var
 t,dt,p:real; b:boolean;
begin
 {
 Actions on start...
 }
 if runcount=1 then begin
  {*** Open console window ***}
  b:=WinShow(ParamStr('Console '+devname));
  b:=WinSelect(ParamStr('Console '+devname));
  {*** Start fast polling ***}
  t:=eval('@system @mmtimer 1');
  b:=echo(devname+' : Start mmTimer = '+Str(t)+' [ms].');
  {*** Remember start time ***}
  p:=mksecnow;
 end else
 {
 Actions on stop...
 }
 if isinf(runcount) then begin
  {*** Stop fast polling ***}
  t:=eval('@system @mmtimer 0');
  b:=echo(devname+' : Stop mmTimer = '+Str(t)+' [ms].');
 end else
 {
 Actions on poll...
 }
 begin
  {*** Find time dt since last poll ***}
  t:=mksecnow;
  dt:=(t-p);
  p:=t;
  {*** Save to curve, print to console ***}
  writeln(runcount:5:0,' ',dt:5:0,' [mks]');
  b:=putao(0,time,dt);
  b:=(ioresult=0);
 end;
end.