---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Справка по демонстрационной системе demo_fast_poll

Демонстрационная конфигурация **demo_fast_poll** служит для иллюстрации того,
как в системе **CRW-DAQ** можно организовывать быстрый опрос устройств,
с частотой опроса порядка **1000 Hz**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Как работает программа demo_fast_poll

Программа, собственно, измеряет время в микросекундах между последовательными
вызовами процедуры опроса, затем отображает его на графике и в консольном окне.

В стартовой части программы **[fast_poll.pas](fast_poll.pas)** стоит вызов:

``` pascal
t:=eval('@system @mmtimer 1');
```

Этот вызов разрешает быстрый мультимедийный таймер, который генерирует прерывания
с частотой около **1000 Hz**.
При этом, поскольку прерывание инициирует переключение потоков,
все потоки программы начинают переключаться с той же частотой.

Сказанное выше верно для **Windows**.
В **Linux** эта команда не требуется, там быстрое переключение потоков работает
и так, надо лишь правильно сконфигурировать потоки.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Конфигурирование устройств для быстрого опроса

Чтобы воспользоваться преимуществами быстрого опроса, надо также правильно сконфигурировать
устройства **DAQ**, иначе быстрого опроса устройств не получится, даже несмотря на быстрое
переключение потоков.

В секции описания устройства **[fast_poll.cfg](fast_poll.cfg)** стоит вызов:

``` ini
InquiryPeriod = 0
DevicePolling = 1, tpTimeCritical
```

Именно так следует описывать устройства, которые надлежит опрашивать с частотой **1000 Hz**.

Наиболее важным здесь является описание **`InquiryPeriod=0`**.
Если этого не сделать, частота опроса устройства останется не выше **100 Hz**.
Это связано с тем, что квант времени функции **msecnow** остается  равным **10 ms**,
а **InquiryPeriod** зависит от вызова **msecnow**.

Значение периода **DevicePolling** может быть и другим, в этом случае период опроса
будет равен указанному периоду с квантом **1 ms**.
Следует также учесть, что установка приоритета ниже **tpTimeCritical** приведет
к деградации стабильности частоты опроса.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Отключение быстрого опроса


 В завершающей части программы **[fast_poll.pas](fast_poll.pas)** стоит вызов:
 
``` pascal
t:=eval('@system @mmtimer 0');
```

Этот вызов запрещает быстрый мультимедийный таймер, после чего частота опроса потоков
возвращается к стандартным **100 Hz**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Когда нужет быстрый опрос

Следует заметить, что при работе с режимом быстрого опроса **надо знать меру**.
Не следует инициировать опрос чаще, чем надо, чтобы не создавать лишней нагрузки для системы.
Быстрый опрос надо использовать только для тех **DAQ** программ, для которых это действительно
необходимо, остальные **DAQ** программы пусть работают на обычной частоте, с обычным приоритетом.
Иначе ускорения опроса может не получиться из-за перегрузки системы.

Надо сказать, что в некоторых случаях имеет смысл включать быстрый таймер, даже если
ни одно устройство **DAQ** не будет опрашиваться с частотой выше стандартных **100 Hz**.
Дело в том, что быстрое переключение потоков приведет к ускорению опроса **COM** портов и
диспетчера событий **DAQ**, который осуществляет запись событий в кривые.

После включения быстрого таймера под **Windows**:

- Обмен по **COM**-порту может иметь частоту до **1000 Hz**.  
  Для этого, помимо включения таймера, надо прописать:

``` ini
[DAQ]
UartPolling = 1, tpTimeCritical
AdamPolling = 1, tpTimeCritical
```

  Это, кстати, значение по умолчанию.

- Обновление данных в кривых может иметь частоту до **1000 Hz**.  
  Для этого, помимо включения таймера, надо прописать:

``` ini
[DAQ]
DispatcherPolling = 1, tpTimeCritical
```

  Это, кстати, значение по умолчанию.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Особенности изменения времени msecnow и mksecnow

Наконец, при программировании надо учитывать, что квант времени функции **msecnow** и всех зависимых
от нее функций (типа **time**, **tm_event** и т.д) остается  равным **10 ms** под **Windows**
или **4 ms** под **Linux**. При этом вызов функции времени **msecnow** и её производных
относительно быстрый и составляет порядка **20-30 нс**.

Для более точного измерения времени в этом случае имеется функция **mksecnow**.
Однако ею не надо злоупотреблять, так как вызов этой функции стоит дорого, порядка **1-2 mks**.
При частоте опроса **1000 Hz** это уже существенно.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

Желаем успешного использования тестовой программы **demo_fast_poll**.

---

> **CRW-DAQ** *Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru*

---
