 {
 ************************************************************************
 EM2RS Modbus Driver.
 ************************************************************************
 Next text uses by @Help command. Do not remove it.
 ************************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Modbus.XXX    - response come from &ModbusProxy server:
| @Modbus.Reply    ref cid tim port uid fid $$ans
| @Modbus.Refuse   ref cid tim port uid fid   msg
| @Modbus.Timeout  ref cid tim port uid fid $$req
|  ref  - sender device reference, expected &ModbusProxy.
|  cid  - command id, any user defined custom data.
|  tim  - request-response time, ms.
|  port - logical port on &ModbusProxy, expected 1..16.
|  uid  - unit id, i.e.MODBUS address, expected 1..247.
|  fid  - function id, expected 1,2,3,4,5,6,15,16.
|  ans  - answer  (response), in HEX_ENCODE format.
|  req  - request (original), in HEX_ENCODE format.
|  msg  - plain text message to explain reason of Refuse.
| @Forward          - Start moving on CW  direction
| @Backward         - Start moving on CCW direction
| @Stop             - Stop  moving
| @EStop            - Emergency Stop  moving
| @Destination XX   - Set destination
| @Speed XX         - Set speed
| @PARAM NAME VALUE - write parameter, i.e. send to MODBUS
| @Edit PARAM.XX    - edit parameter and write it
| @AssignTag t v    - Assign tag t to value v
| @DimTagUpdate     - Update tag from DIM
| @LoadIni          - locale load params from INI file.
|************************************************************************
[]

 ************************************************************************
  [DeviceList]
  &EM2RS.DRIVER = device software program
  [&EM2RS.DRIVER]
  Comment = Modbus RTU Driver for EM2RS controller.
  InquiryPeriod  = 0
  DevicePolling  = 10, tpNormal
  ProgramSource  = ..\DaqPas\em2rs_drv.pas
  DigitalFifo    = 1024
  AnalogFifo     = 1024
  DebugFlags     = 3
  OpenConsole    = 2
  Simulator      = 0
  ModbusPort     = 1
  ModbusUnitId   = 1
  ModbusTimeout  = 250
  ModbusDeadline = 60000
  ModbusPolling  = 100
  DelayOnStart   = 1000
  tagPrefix      = EM2RS
  ...etc...
 ************************************************************************
 }
program EM2RS;
const
 {-------------------------------}{ Declare uses program constants:     }
 {$I _con_StdLibrary}             { Include all Standard constants,     }
 {$I _con_NetLibrary}             { NetLibrary constants                }
 {-------------------------------}{ And add User defined constants:     }
 dfStatist          = 32;         { DebugFlags - polling statistics     }
 MaxCmdNum          = 67;         { Maximal number of commands:         }
 cm_ReadGroup1      = 1;          { Read Holding Registers UnInt 16     }
 cm_ReadGroup2      = 2;          { Read Holding Registers UnInt 16     }
 cm_ReadGroup3      = 3;          { Read Holding Registers UnInt 16     }
 cm_ReadGroup4      = 4;          { Read Holding Registers UnInt 16     }
 cm_ReadGroup5      = 5;          { Read Holding Registers UnInt 16     }
 cm_ReadGroup6      = 6;          { Read Holding Registers UnInt 16     }
 cm_ReadGroup7      = 7;          { Read Holding Registers UnInt 16     }
 cm_ReadGroup8      = 8;          { Read Holding Registers UnInt 16     }
 cm_ReadGroup9      = 9;          { Read Holding Registers UnInt 16     }
 cm_ReadGroup10     = 10;         { Read Holding Registers UnInt 16     }
 cm_ReadGroup11     = 11;         { Read Holding Registers UnInt 16     }
 cm_ReadGroup12     = 12;         { Read Holding Registers UnInt 16     }
 cm_ReadGroup13     = 13;         { Read Holding Registers UnInt 16     }
 cm_WritPulse       = 14;         { Write $0001 Pulse/Revolution        }
 cm_WritCtrlMode    = 15;         { Write $0003 Control Mode (CS2RS)    }
 cm_WritMotDirect   = 16;         { Write $0007 Motor Direction         }
 cm_WritPosError    = 17;         { Write $000B All max pos follow error}
 cm_WritForced      = 18;         { $000F Forced enable by software *   }
 cm_WritPosLoopKp   = 19;         { Write $0051 Position loop Kp *      }
 cm_WritVelLoopKi   = 20;         { Write $0053 Velocity loop Ki *      }
 cm_WritVelLoopKp   = 21;         { Write $0055 Velocity loop Kp *      }
 cm_WritPosLoopKpH  = 22;         { Write $0065 Position loop KpH *     }
 cm_WritCmdTime     = 23;         { Write $00A1 Command filter time *   }
 cm_WritVelOtoC     = 24;         { $00A3 Vel swtch pnt: O to C loop *  }
 cm_WritVelCtoO     = 25;         { $00A5 Vel swtch pnt: C to O loop *  }
 cm_WritDelayOtoC   = 26;         { $00A7 Delay of O to C loop *        }
 cm_WritDelayCtoO   = 27;         { $00A9 Delay of C to O loop *        }
 cm_WritCfgInput1   = 28;         { Write $0145 Input port DI1          }
 cm_WritCfgInput2   = 29;         { Write $0147 Input port DI2          }
 cm_WritCfgInput3   = 30;         { Write $0149 Input port DI3          }
 cm_WritCfgInput4   = 31;         { Write $014B Input port DI4          }
 cm_WritCfgInput5   = 32;         { Write $014D Input port DI5          }
 cm_WritCfgInput6   = 33;         { Write $014F Input port DI6          }
 cm_WritCfgInput7   = 34;         { Write $0151 Input port DI7          }
 cm_WritCfgOutput1  = 35;         { Write $0157 Output port DO1         }
 cm_WritCfgOutput2  = 36;         { Write $0159 Output port DO2         }
 cm_WritCfgOutput3  = 37;         { Write $015B Output port DO3         }
 cm_WritAlrmDetect  = 38;         { Write $016D Alarm detection selection     }
 cm_WritDist2Send   = 39;         { Write $0171 Dist. 2send "In Pos" Out sign }
 cm_WritBusVolt     = 40;         { Write $0177 Bus Voltage             }
 cm_WritPeakCur     = 41;         { Write $0191 Peak Current            }
 cm_WritHoldInClsd  = 42;         { $0193 % of hold curr in closed-loop }
 cm_WritHoldInOpen  = 43;         { $0195 % of hold curr in open-loop   }
 cm_WritStbCurPer   = 44;         { Write $01D3 Standby Current %       }
 cm_WritJOGvel      = 45;         { Write $01E1 JOG Velocity            }
 cm_WritJOGinter    = 46;         { Write $01E3 Interval                }
 cm_WritJOGruntime  = 47;         { Write $01E5 Running times           }
 cm_WritJOGaccDec   = 48;         { Write $01E7 Acc/Dec. time           }
 cm_WritEncodeRes   = 49;         { Write $0233 Encoder resolution      }
 cm_WritCtrlWord    = 50;         { Write $1801 Control word            }
 cm_WritPRcontrol   = 51;         { Write $6000 PR control register     }
 cm_WritSpeed       = 52;         { Write $6203 Velocity                }
 cm_WritTrigger     = 53;         { Write $6002 Trigger register        }
 cm_WritSoftLimPos  = 54;         { Write $6006+$6007 Soft limit pos    }
 cm_WritSoftLimNeg  = 55;         { Write $6008+$6009 Soft limit neg    }
 cm_WritAfterHoming = 56;         { Write $600D+$600E Move after homing }
 cm_WritHomingMode  = 57;         { Write $600A Homing mode             }
 cm_WritHomHighVel  = 58;         { Write $600F Homing hight velocit    }
 cm_WritHomLowVel   = 59;         { Write $6010 Homing low velocity     }
 cm_WritHomingAcc   = 60;         { Write $6011 Homing Acc              }
 cm_WritHomingDec   = 61;         { Write $6012 Homing Dec              }
 cm_WritLimStopTime = 62;         { Write $6016 Limit stop time         }
 cm_WritEStopTime   = 63;         { Write $6017 E-STOP time             }
 cm_WritMotPath0    = 64;         { Write $6200 Motion of path 0        }
 cm_WritPosition    = 65;         { Write $6201+$6202 Position          }
 cm_WritAccel       = 66;         { Write $6204 Acc                     }
 cm_WritDeccel      = 67;         { Write $6205 Dec                     }
 ao_PULSE           = 0;          { $0001 Pulse/Revolution              }
 ao_CTRLMODE        = 1;          { $0003 Control Mode (CS2RS)          }
 ao_MOTDIRECT       = 2;          { $0007 Motor Direction               }
 ao_POSERROR        = 3;          { $000B Allowed max pos follow error *}
 ao_FORCED          = 4;          { $000F Forced enable by software *   }
 ao_POSLOOPKP       = 5;          { $0051 Position loop Kp *            }
 ao_VELLOOPKI       = 6;          { $0053 Velocity loop Ki *            }
 ao_VELLOOPKP       = 7;          { $0055 Velocity loop Kp *            }
 ao_POSLOOPKPH      = 8;          { $0065 Position loop KpH *           }
 ao_CMDTIME         = 9;          { $00A1 Command filter time *         }
 ao_VELOTOC         = 10;         { $00A3 Vel swtch pnt: O to C loop *  }
 ao_VELCTOO         = 11;         { $00A5 Vel swtch pnt: C to O loop *  }
 ao_DELAYOTOC       = 12;         { $00A7 Delay of O to C loop *        }
 ao_DELAYCTOO       = 13;         { $00A9 Delay of C to O loop *        }
 ao_CFGINPUT1       = 14;         { $0145 Input port DI1                }
 ao_CFGINPUT2       = 15;         { $0147 Input port DI2                }
 ao_CFGINPUT3       = 16;         { $0149 Input port DI3                }
 ao_CFGINPUT4       = 17;         { $014B Input port DI4                }
 ao_CFGINPUT5       = 18;         { $014D Input port DI5                }
 ao_CFGINPUT6       = 19;         { $014F Input port DI6                }
 ao_CFGINPUT7       = 20;         { $0151 Input port DI7                }
 ao_CFGOUTPUT1      = 21;         { $0157 Output port DO1               }
 ao_CFGOUTPUT2      = 22;         { $0159 Output port DO2               }
 ao_CFGOUTPUT3      = 23;         { $015B Output port DO3               }
 ao_ALRMDETECT      = 24;         { $016D Alarm detection selection     }
 ao_DIST2SEND       = 25;         { $0171 Dist. 2send "In Pos" Out sign }
 ao_BUSVOLT         = 26;         { $0177 Bus Voltage                   }
 ao_DISTATUS        = 27;         { $0179 Digital Input Status          }
 ao_DOSTATUS        = 28;         { $017B Digital Output Status         }
 ao_PEAKCUR         = 29;         { $0191 Peak Current                  }
 ao_HOLDINCLSD      = 30;         { $0193 % of hold curr in closed-loop }
 ao_HOLDINOPEN      = 31;         { $0195 % of hold curr in open-loop   }
 ao_BAUDRATE        = 32;         { $01BD Baudrate                      }
 ao_ADDRESS         = 33;         { $01BF RS485 ID                      }
 ao_RS485TYPE       = 34;         { $01C1 Data type selection           }
 ao_STBCURPER       = 35;         { $01D3 Standby Current Percentage    }
 ao_JOGVEL          = 36;         { $01E1 JOG Velocity                  }
 ao_JOGINTER        = 37;         { $01E3 Interval                      }
 ao_JOGRUNTIME      = 38;         { $01E5 Running times                 }
 ao_JOGACCDEC       = 39;         { $01E7 Acc/Dec. time                 }
 ao_ENCODERES       = 40;         { $0233 Encoder resolution            }
 ao_MOTSTATUS       = 41;         { $1003 Motion Status                 }
 ao_SAVEWORD        = 42;         { $1901 Save parameter status word    }
 ao_CURALARM        = 43;         { $2203 Current alarm                 }
 ao_PRCONTROL       = 44;         { $6000 PR control register           }
 ao_TRIGGER         = 45;         { $6002 Trigger register              }
 ao_SOFTLIMPOS      = 46;         { $6006+$6007 Soft limit positive     }
 ao_SOFTLIMNEG      = 47;         { $6008+$6009 Soft limit negative     }
 ao_HOMINGMODE      = 48;         { $600A Homing mode                   }
 ao_AFTERHOMING     = 49;         { $600D+$600E Move after homing       }
 ao_HOMHIGHVEL      = 50;         { $600F Homing hight velocity         }
 ao_HOMLOWVEL       = 51;         { $6010 Homing low velocity           }
 ao_HOMINGACC       = 52;         { $6011 Homing Acc                    }
 ao_HOMINGDEC       = 53;         { $6012 Homing Dec                    }
 ao_LIMSTOPTIME     = 54;         { $6016 Limit stop time               }
 ao_ESTOPTIME       = 55;         { $6017 E-STOP time                   }
 ao_ACTPOS          = 56;         { $602C+$602D Actual position         }
 ao_MOTPATH0        = 57;         { $6200 Motion of path 0              }
 ao_POSITION        = 58;         { $6201+$6202 Position                }
 ao_SPEED           = 59;         { $6203 Velocity                      }
 ao_ACCELERAT       = 60;         { $6204 Acc                           }
 ao_DECCELERAT      = 61;         { $6205 Dec                           }
 ao_POSITION_MM     = 62;         {                                     }
 do_STATE_INDIC     = 0;          {  Status indicator                   }
 do_POLLRATERX      = 1;          {  Poll rate Rx                       }
 do_POLLRATETX      = 2;          {  Poll rate Tx                       }
 do_POLLRATEEX      = 3;          {  Poll rate Ex                       }
 do_ERRORCOUNT      = 4;          {  Error counter                      }
 do_POLLSUMMRX      = 5;          {  Poll summ Rx                       }
 do_POLLSUMMTX      = 6;          {  Poll summ Tx                       }
 do_POLLSUMMEX      = 7;          {  Poll summ Ex                       }
 SwapModeFloat      = 1;          { Byte swap mode for float values     }
 SwapModeInt32      = 3;          { Byte swap mode for integers         }
 st_NORMAL          = 0;          { Status: Green                       }
 st_TIMEOUT         = 1;          {  Red timeout                        }
 st_REFUSE          = 2;          {  Red refuse                         }
 st_SIMULAT         = 3;          {  Simulator mode                     }
 st_DISABLE         = 4;          {  Polling disabled                   }
 st_RUNNING         = 256;        {                                     }
 st_STOP            = 64;         {                                     }
 st_RESET           = 33;         {                                     }
 st_POSITIONING     = 16;         {                                     }
 mode_Init          = 0;          {                                     }
 mode_Absolute      = 1;          {                                     }
 mode_Speed         = 2;          {                                     }
 mode_Relative      = 65;         {                                     }
 cmd_Move           = 1;          { Movement infinite                   }
 cmd_MoveN          = 2;          { Movement infinite                   }
 cmd_MoveStep       = 3;          { Move to Step input sensor signal    }
 cmd_MoveIn1        = 9;          { Move to In1 input sensor signal     }
 cmd_MoveIn2        = 10;         { Move to In2 input sensor signal     }
 cmd_FindHome       = 11;         { Move to Home input sensor signal    }
 cmd_Reset          = 12;         { Controller reset                    }
 cmd_SavePar        = 19;         { Save controller params in NVM       }
 bit_En             = 0;          { In1 sensor bit                      }
 bit_Hide           = 1;          { In2 sensor bit                      }
 bit_Lim            = 2;          { En bit                              }
 bit_StatusFault    = 0;          { Status Fault bit                    }
 bit_StatusEnable   = 1;          { Status Enable bit                   }
 bit_StatusRunning  = 2;          { Status Running bit                  }
 bit_StatusCommand  = 4;          { Status Command bit                  }
 bit_StatusPath     = 5;          { Status Path bit                     }
 DimDeadline        = 5000;       { Detect DIM server is dead           }
 DirectionBackward  = -1;         { Moving direction backward           }
 DirectionForward   = 1;          { Moving direction forward            }
 DirectionNone      = 0;          { Moving direction none               }
 PrNormal           = 1;          { CMD poll priority normal            }
 PrHigh             = 2;          { CMD poll while movement             }
 invCalibrLimit     = 550000;     { invCalibr limit. less = faster      }

type
 {-------------------------------}{ Declare uses program types:         }
 {$I _typ_StdLibrary}             { Include all Standard types,         }
 {-------------------------------}{ And add User defined types:         }

var
 {-------------------------------}{ Declare uses program variables:     }
 {$I _var_StdLibrary}             { Include all Standard variables,     }
 {$I _var_NetLibrary}             { NetLibrary variables                }
 {-------------------------------}{ And add User defined variables:     }
 EM2RS        : record            { EM2RS Driver data record            }
  Simulator   : Boolean;          { Simulator or Driver mode            }
  SelfId      : String;           { Self pid@hostname                   }
  DevLabel    : TTagRef;          { Device description                  }
  DirFwd      : Integer;          { Forward  moving direction           }
  DirBwd      : Integer;          { Backward moving direction           }
  MovementDirection  : Integer;   { Moving direction                    }
  Position    : TTagRef;          { GUI Position in mm                  }
  SpeedUnit   : TTagRef;          {  ReadIni SpeedUnit                  }
  PosUnit     : TTagRef;          {  ReadIni PosUnit                    }
  MovUnit     : TTagRef;          {  ReadIni MovUnit                    }
  Speed       : TTagRef;          {  Speed in mm/sec                    }
  Destination : TTagRef;          {  Destination in mm                  }
  DirectFWD   : TTagRef;          {  Direct Forward                     }
  DirectBWD   : TTagRef;          {  Direct Backward                    }
  Move        : TTagRef;          {  Move                               }
  Homing      : TTagRef;          {  Homing                             }
  EStop       : TTagRef;          {  EStop                              }
  SetZero     : TTagRef;          {  SetZero                            }
  PosLimit    : TTagRef;          {  Positive Limit                     }
  NegLimit    : TTagRef;          {  Negative Limit                     }
  Modbus      : record            { Modbus data record                  }
   Port       : Integer;          { Logical Port on &ModbusProxy        }
   UnitId     : Integer;          { Modbus unit id                      }
   Timeout    : Integer;          { Modbus timeout, ms                  }
   Polling    : Integer;          { Modbus polling period, ms           }
   Deadline   : Integer;          { Modbus deadline time, ms            }
   DelayOnStart : Integer;        { Command cycle delay on start        }
   Cmd        : record            { Command cycle data record           }
    Num       : Integer;          { Current running command number      }
    Enabled   : array [1..MaxCmdNum] of Boolean; { Enable polling       }
    Priority  : array [1..MaxCmdNum] of Integer; { Command priority     }
    FuncId    : array [1..MaxCmdNum] of Integer; { Modbus Function Id   }
    SAddr     : array [1..MaxCmdNum] of Integer; { Start Address        }
    Quant     : array [1..MaxCmdNum] of Integer; { Quantity of data     }
    OpData    : array [1..MaxCmdNum] of Real;    { Operation data       }
    OpBuff    : array [1..MaxCmdNum] of Real;    { Operation buffer     }
   end;                           {                                     }
   Poll       : record            { Polling transaction data record     }
    ref       : Integer;          { Last sent device reference          }
    cid       : Integer;          { Last sent command id                }
    tim       : Real;             { Last polling time, ms               }
    port      : Integer;          { Last polling port                   }
    uid       : Integer;          { Last polling unit id                }
    fid       : Integer;          { Last sent function id               }
    saddr     : Integer;          { Last sent start address             }
    quant     : Integer;          { Last sent quantity of registers     }
    dat       : String;           { Last sent PDU=(fid+dat) data        }
    Summ,                         { Poll summ counters                  }
    Rate      : record            { Poll rate on last second            }
     Rx       : Real;             { Rx poll summ/rate - receiver        }
     Tx       : Real;             { Tx poll summ/rate - transmitter     }
     Ex       : Real;             { Ex poll summ/rate - errors          }
    end;                          {                                     }
   end;                           {                                     }
  end;                            {                                     }
  POLL        : record            { Poll parameters:                    }
   ENABLE     : TTagRef;          { Poll enable flag                    }
  end;                            {                                     }
  POLLRATE    : record            {                                     }
   RX,TX,EX   : TTagRef;          {                                     }
  end;                            {                                     }
  POLLSUMM    : record            {                                     }
   RX,TX,EX   : TTagRef;          {                                     }
  end;                            {                                     }
  ERROR       : record            {                                     }
   COUNT      : TTagRef;          {                                     }
  end;                            {                                     }
  SERVID      : TTagRef;          { Server Identifier pid@hostname      }
  CLOCK       : TTagRef;          { Server Date-Time                    }
  PARAM       : record            { Device parameters:                  }
   PULSE      : TTagRef;          { $0001 Pulse/Revolution              }
   CTRLMODE   : TTagRef;          { $0003 Control Mode (CS2RS)          }
   MOTDIRECT  : TTagRef;          { $0007 Motor Direction               }
   POSERROR   : TTagRef;          { $000B Allowed max pos follow error *}
   FORCED     : TTagRef;          { $000F Forced enable by software *   }
   POSLOOPKP  : TTagRef;          { $0051 Position loop Kp *            }
   VELLOOPKI  : TTagRef;          { $0053 Velocity loop Ki *            }
   VELLOOPKP  : TTagRef;          { $0055 Velocity loop Kp *            }
   POSLOOPKPH : TTagRef;          { $0065 Position loop KpH *           }
   CMDTIME    : TTagRef;          { $00A1 Command filter time *         }
   VELOTOC    : TTagRef;          { $00A3 Vel swtch pnt: O to C loop *  }
   VELCTOO    : TTagRef;          { $00A5 Vel swtch pnt: C to O loop *  }
   DELAYOTOC  : TTagRef;          { $00A7 Delay of O to C loop *        }
   DELAYCTOO  : TTagRef;          { $00A9 Delay of C to O loop *        }
   CFGINPUT1  : TTagRef;          { $0145 Input port DI1                }
   CFGI1_NC   : TTagRef;          { $0145 Input port DI1                }
   CFGINPUT2  : TTagRef;          { $0147 Input port DI2                }
   CFGI2_NC   : TTagRef;          { $0147 Input port DI2                }
   CFGINPUT3  : TTagRef;          { $0149 Input port DI3                }
   CFGI3_NC   : TTagRef;          { $0149 Input port DI3                }
   CFGINPUT4  : TTagRef;          { $014B Input port DI4                }
   CFGI4_NC   : TTagRef;          { $014B Input port DI4                }
   CFGINPUT5  : TTagRef;          { $014D Input port DI5                }
   CFGI5_NC   : TTagRef;          { $014D Input port DI5                }
   CFGINPUT6  : TTagRef;          { $014F Input port DI6                }
   CFGI6_NC   : TTagRef;          { $014F Input port DI6                }
   CFGINPUT7  : TTagRef;          { $0151 Input port DI7                }
   CFGI7_NC   : TTagRef;          { $0151 Input port DI7                }
   CFGOUTPUT1 : TTagRef;          { $0157 Output port DO1               }
   CFGO1_NC   : TTagRef;          { $0157 Output port DO1               }
   CFGOUTPUT2 : TTagRef;          { $0159 Output port DO2               }
   CFGO2_NC   : TTagRef;          { $0159 Output port DO2               }
   CFGOUTPUT3 : TTagRef;          { $015B Output port DO3               }
   CFGO3_NC   : TTagRef;          { $015B Output port DO3               }
   ALRMDETECT : TTagRef;          { $016D Alarm detection selection     }
   DIST2SEND  : TTagRef;          { $0171 Dist. 2send "In Pos" Out sign }
   BUSVOLT    : TTagRef;          { $0177 Bus Voltage                   }
   DISTATUS   : TTagRef;          { $0179 Digital Input Status          }
   DOSTATUS   : TTagRef;          { $017B Digital Output Status         }
   PEAKCUR    : TTagRef;          { $0191 Peak Current                  }
   HOLDINCLSD : TTagRef;          { $0193 % of hold curr in closed-loop }
   HOLDINOPEN : TTagRef;          { $0195 % of hold curr in open-loop   }
   BAUDRATE   : TTagRef;          { $01BD Baudrate                      }
   ADDRESS    : TTagRef;          { $01BF RS485 ID                      }
   RS485TYPE  : TTagRef;          { $01C1 RS485 Data type selection     }
   STBCURPER  : TTagRef;          { $01D3 Standby Current Percentage    }
   JOGVEL     : TTagRef;          { $01E1 JOG Velocity                  }
   JOGINTER   : TTagRef;          { $01E3 Interval                      }
   JOGRUNTIME : TTagRef;          { $01E5 Running times                 }
   JOGACCDEC  : TTagRef;          { $01E7 Acc/Dec. time                 }
   SOFTWARE   : TTagRef;          { $01FF Version Information           }
   FIRMWARE   : TTagRef;          { $0201 Firmare Version               }
   ENCODERES  : TTagRef;          { $0233 Encoder resolution            }
   MOTSTATUS  : TTagRef;          { $1003 Motion Status                 }
   SAVEWORD   : TTagRef;          { $1901 Save parameter status word    }
   CTRLWORD   : TTagRef;          { $1801 Control Word                  }
   CURALARM   : TTagRef;          { $2203 Current alarm                 }
   PRCONTROL  : TTagRef;          { $6000 PR control register           }
   TRIGGER    : TTagRef;          { $6002 Trigger register              }
   SOFTLIMPOS : TTagRef;          { $6006+$6007 Software limit positive }
   SOFTLIMNEG : TTagRef;          { $6008+$6009 Software limit negative }
   HOMINGMODE : TTagRef;          { $600A Homing mode                   }
   AFTERHOMING: TTagRef;          { $600D+$600E Move after homing       }
   HOMHIGHVEL : TTagRef;          { $600F Homing hight velocity         }
   HOMLOWVEL  : TTagRef;          { $6010 Homing low velocity           }
   HOMINGACC  : TTagRef;          { $6011 Homing Acc                    }
   HOMINGDEC  : TTagRef;          { $6012 Homing Dec                    }
   LIMSTOPTIME: TTagRef;          { $6016 Limit stop time               }
   ESTOPTIME  : TTagRef;          { $6017 E-STOP time                   }
   ACTPOS     : TTagRef;          { $602C+$602D Actual position         }
   MOTPATH0   : TTagRef;          { $6200 Motion of path 0              }
   POSITION   : TTagRef;          { $6201+$6202 Position                }
   SPEED      : TTagRef;          { $6203 Velocity                      }
   ACCELERAT  : TTagRef;          { $6204 Acc                           }
   DECCELERAT : TTagRef;          { $6205 Dec                           }
   STATE      : TTagRef;          { Status indicator                    }
  end;                            {                                     }
  SIM         : record            { Simulator data:                     }
   COMMAND    : Integer;          {                                     }
   STEPCOUNT  : Integer;          {                                     }
   DIRECTION  : Integer;          {                                     }
   PULSE      : Integer;          { $0001 Pulse/Revolution              }
   CTRLMODE   : Integer;          { $0003 Control Mode (CS2RS)          }
   MOTDIRECT  : Integer;          { $0007 Motor Direction               }
   POSERROR   : Integer;          { $000B Allowed max pos follow error *}
   FORCED     : Integer;          { $000F Forced enable by software *   }
   POSLOOPKP  : Integer;          { $0051 Position loop Kp *            }
   VELLOOPKI  : Integer;          { $0053 Velocity loop Ki *            }
   VELLOOPKP  : Integer;          { $0055 Velocity loop Kp *            }
   POSLOOPKPH : Integer;          { $0065 Position loop KpH *           }
   CMDTIME    : Integer;          { $00A1 Command filter time *         }
   VELOTOC    : Integer;          { $00A3 Vel swtch pnt: O to C loop *  }
   VELCTOO    : Integer;          { $00A5 Vel swtch pnt: C to O loop *  }
   DELAYOTOC  : Integer;          { $00A7 Delay of O to C loop *        }
   DELAYCTOO  : Integer;          { $00A9 Delay of C to O loop *        }
   CFGINPUT1  : Integer;          { $0145 Input port DI1                }
   CFGI1_NC   : Integer;          { $0145 Input port DI1                }
   CFGINPUT2  : Integer;          { $0147 Input port DI2                }
   CFGI2_NC   : Integer;          { $0147 Input port DI2                }
   CFGINPUT3  : Integer;          { $0149 Input port DI3                }
   CFGI3_NC   : Integer;          { $0149 Input port DI3                }
   CFGINPUT4  : Integer;          { $014B Input port DI4                }
   CFGI4_NC   : Integer;          { $014B Input port DI4                }
   CFGINPUT5  : Integer;          { $014D Input port DI5                }
   CFGI5_NC   : Integer;          { $014D Input port DI5                }
   CFGINPUT6  : Integer;          { $014F Input port DI6                }
   CFGI6_NC   : Integer;          { $014F Input port DI6                }
   CFGINPUT7  : Integer;          { $0151 Input port DI7                }
   CFGI7_NC   : Integer;          { $0151 Input port DI7                }
   CFGOUTPUT1 : Integer;          { $0157 Output port DO1               }
   CFGO1_NC   : Integer;          { $0157 Output port DO1               }
   CFGOUTPUT2 : Integer;          { $0159 Output port DO2               }
   CFGO2_NC   : Integer;          { $0159 Output port DO2               }
   CFGOUTPUT3 : Integer;          { $015B Output port DO3               }
   CFGO3_NC   : Integer;          { $015B Output port DO3               }
   ALRMDETECT : Integer;          { $016D Alarm detection selection     }
   DIST2SEND  : Integer;          { $0171 Dist. 2send "In Pos" Out sign }
   BUSVOLT    : Integer;          { $0177 Bus Voltage                   }
   DISTATUS   : Integer;          { $0179 Digital Input Status          }
   DOSTATUS   : Integer;          { $017B Digital Output Status         }
   PEAKCUR    : Real;             { $0191 Peak Current                  }
   HOLDINCLSD : Integer;          { $0193 % of hold curr in closed-loop }
   HOLDINOPEN : Integer;          { $0195 % of hold curr in open-loop   }
   BAUDRATE   : Integer;          { $01BD Baudrate                      }
   ADDRESS    : Integer;          { $01BF RS485 ID                      }
   RS485TYPE  : Integer;          { $01C1 RS485 Data type selection     }
   STBCURPER  : Integer;          { $01D3 Standby Current Percentage    }
   JOGVEL     : Integer;          { $01E1 JOG Velocity                  }
   JOGINTER   : Integer;          { $01E3 Interval                      }
   JOGRUNTIME : Integer;          { $01E5 Running times                 }
   JOGACCDEC  : Integer;          { $01E7 Acc/Dec. time                 }
   SOFTWARE   : Integer;          { $01FF Version Information           }
   FIRMWARE   : Integer;          { $0201 Firmare Version               }
   ENCODERES  : Integer;          { $0233 Encoder resolution            }
   MOTSTATUS  : Integer;          { $1003 Motion Status                 }
   SAVEWORD   : Integer;          { $1901 Save parameter status word    }
   CTRLWORD   : Integer;          { $1801 Control Word                  }
   CURALARM   : Integer;          { $2203 Current alarm                 }
   PRCONTROL  : Integer;          { $6000 PR control register           }
   TRIGGER    : Integer;          { $6002 Trigger register              }
   SOFTLIMPOS : Integer;          { $6006+$6007 Software limit positive }
   SOFTLIMNEG : Integer;          { $6008+$6009 Software limit negative }
   HOMINGMODE : Integer;          { $600A Homing mode                   }
   AFTERHOMING: Integer;          { $600D+$600E Move after homing       }
   HOMHIGHVEL : Integer;          { $600F Homing hight velocity         }
   HOMLOWVEL  : Integer;          { $6010 Homing low velocity           }
   HOMINGACC  : Integer;          { $6011 Homing Acc                    }
   HOMINGDEC  : Integer;          { $6012 Homing Dec                    }
   LIMSTOPTIME: Integer;          { $6016 Limit stop time               }
   ESTOPTIME  : Integer;          { $6017 E-STOP time                   }
   ACTPOS     : Integer;          { $602C+$602D Actual position         }
   MOTPATH0   : Integer;          { $6200 Motion of path 0              }
   POSITION   : Integer;          { $6201+$6202 Position                }
   SPEED      : Integer;          { $6203 Velocity                      }
   ACCELERAT  : Integer;          { $6204 Acc                           }
   DECCELERAT : Integer;          { $6205 Dec                           }
   STATE      : Integer;          { Status indicator                    }
   TimeOut    : Real;             {                                     }
  end;                            {                                     }
 end;                             {                                     }
 tagPrefix          : String;     { Tag Prefix                          }
 ColorNorm          : Integer;    { Color in normal state: lime,aqua    }
 ColorWarn          : Integer;    { Color in warning state: yellow      }
 cmd_mbReply        : Integer;    { Modbus commands:                    }
 cmd_mbPoll         : Integer;    {                                     }
 cmd_mbRefuse       : Integer;    {                                     }
 cmd_mbTimeout      : Integer;    {                                     }
 cmd_mbClrSumm      : Integer;    {                                     }
 cmd_param          : Integer;    { CMD: Set parameter                  }
 cmd_guiSpeed       : Integer;    { CMD: Set GUI Speed                  }
 cmd_guiDestination : Integer;    { CMD: Set GUI Step Num               }
 cmd_actForward     : Integer;    { CMD: Move (backward)                }
 cmd_actBackward    : Integer;    { CMD: Move                           }
 cmd_actMove        : Integer;    { CMD: Move (backward)                }
 cmd_actStop        : Integer;    { CMD: Stop                           }
 cmd_actEstop       : Integer;    { CMD: E-STOP                         }
 cmd_Edit           : Integer;    { Common commands:                    }
 cmd_LoadIni        : Integer;    {  Load ini                           }
 cmd_DimTagUpdate   : Integer;    {  @DimTagUpdate                      }
 cmd_AssignTag      : Integer;    {  @AssignTag                         }
 prevActPosition    : Integer;    { Prev Actual position                }
 prevSpeed          : Integer;    { Prev Speed                          }
 SetPointChckStt    : Integer;    { Set point check status              }
 SetPointChckTim    : Real;       { Set point check timer               }
 spcParEnab         : Integer;    { Set point check ENABLE parameter    }
 StartMoveStat      : Integer;    { Start moving status                 }
 StartMoveTime      : Real;       { Start moving timer                  }
 localSpeed         : Real;       {                                     }
 {-------------------------------}{ Declare procedures & functions:     }
 {$I _fun_StdLibrary}             { Include all Standard functions,     }
 {$I _fun_NetLibrary}             { NetLibrary functions                }
 {-------------------------------}{ And add User defined functions:     }
 {
 Prefix for DIM @remote commands.
 }
 function DimRemote:String;
 var CanRemote:Boolean;
 begin
  CanRemote:=DIM_IsServerMode or DIM_IsClientMode;
  if (DIM_GuiClickTag=0) then CanRemote:=false;
  if (devDimSrv=0) then CanRemote:=false;
  if CanRemote
  then DimRemote:='@remote '
  else DimRemote:='';
 end;
 {
 Xor bit on click (remote version).
 }
 procedure ClickTagXorRemote(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
  if (ClickTag=tag) then begin
   DevSendCmdLocal(DimRemote+'@AssignTag '+NameTag(tag)+' '+Str(iXor(iGetTag(tag),XorMask)));
  end;
 end;
 {
 Is engine enabled
 # check DI enabled signal
 }
 function IsEngineEnabled:boolean;
 var i,CfgInput:integer;
 begin
  CfgInput:=0;
  IsEngineEnabled:=false;
  for i:=1 to 7 do begin
   CfgInput:=iGetTag(findtag(tagPrefix+'.CFGINPUT'+str(i)));
   if ((CfgInput=8) or (CfgInput=136)) then IsEngineEnabled:=iGetTagBitState(EM2RS.PARAM.DISTATUS.tag,i-1);
  end;
 end;
 {
 Is status Fault
 }
 function IsFault:boolean;
 begin
  IsFault:=isBit(iGetTag(EM2RS.PARAM.MOTSTATUS.tag),bit_StatusFault);
 end;
 {
 Is status Enabled
 }
 function IsEnabled:boolean;
 begin
  IsEnabled:=isBit(iGetTag(EM2RS.PARAM.MOTSTATUS.tag),bit_StatusEnable);
 end;
 {
 Is status running
 }
 function IsRunning:boolean;
 begin
  IsRunning:=isBit(iGetTag(EM2RS.PARAM.MOTSTATUS.tag),bit_StatusRunning);
 end;
 {
 Is mode Absolute
 }
 function IsModeAbsolute:boolean;
 begin
  IsModeAbsolute:=(iGetTag(EM2RS.PARAM.MOTPATH0.tag)=mode_Absolute);
 end;
 {
 Is mode mode_Speed
 }
 function IsModeSpeed:boolean;
 begin
  IsModeSpeed:=(iGetTag(EM2RS.PARAM.MOTPATH0.tag)=mode_Speed);
 end;
 {
 Is mode Relative
 }
 function IsModeRelative:boolean;
 begin
  IsModeRelative:=(iGetTag(EM2RS.PARAM.MOTPATH0.tag)=mode_Relative);
 end;
 {
 Command cycle routines.
 }
 function IsValidCmdNum(Num:Integer):Boolean;
 begin
  IsValidCmdNum:=(1<=Num) and (Num<=MaxCmdNum);
 end;
 function ValidateCmdNum(Num:Integer):Integer;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then ValidateCmdNum:=Num
  else ValidateCmdNum:=1;
 end;
 function IsUsableCmdNum(Num:Integer):Boolean;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then IsUsableCmdNum:=(EM2RS.Modbus.Cmd.FuncId[Num]<>0)
  else IsUsableCmdNum:=False;
 end;
 function IsEnabledCmdNum(Num:Integer):Boolean;
 var Priority:Integer;
 begin
  if IsRunning then Priority:=PrHigh else Priority:=PrNormal;
  if (1<=Num) and (Num<=MaxCmdNum)
  then IsEnabledCmdNum:=(EM2RS.Modbus.Cmd.FuncId[Num]<>0) and EM2RS.Modbus.Cmd.Enabled[Num] and (EM2RS.Modbus.Cmd.Priority[Num]>=Priority)
  else IsEnabledCmdNum:=False;
 end;
 function NextEnabledCmdNum(Num:Integer):Integer;
 var i:Integer;
 begin
  i:=0;
  while (i<MaxCmdNum) do begin
   Num:=ValidateCmdNum(Num+1);
   if IsEnabledCmdNum(Num)
   then i:=MaxCmdNum
   else i:=i+1;
  end;
  NextEnabledCmdNum:=Num;
 end;
 procedure HoldCmdOpData(Num:Integer; OpData:Real);
 begin
  if IsUsableCmdNum(Num) then begin
   EM2RS.Modbus.Cmd.Enabled[Num]:=not IsNaN(OpData);
   EM2RS.Modbus.Cmd.OpBuff[Num]:=OpData;
  end;
 end;
 procedure ApplyCmdOpData(Num:Integer);
 begin
  if IsUsableCmdNum(Num) then
  if not IsNaN(EM2RS.Modbus.Cmd.OpBuff[Num]) then begin
   EM2RS.Modbus.Cmd.OpData[Num]:=EM2RS.Modbus.Cmd.OpBuff[Num];
   EM2RS.Modbus.Cmd.OpBuff[Num]:=_NaN;
  end;
 end;
 procedure ReleaseCmdOpData(Num:Integer);
 begin
  if IsUsableCmdNum(Num) then HoldCmdOpData(Num,EM2RS.Modbus.Cmd.OpBuff[Num]);
 end;
 function GetCmdOpData(Num:Integer):Real;
 begin
  if IsUsableCmdNum(Num)
  then GetCmdOpData:=EM2RS.Modbus.Cmd.OpData[Num]
  else GetCmdOpData:=_NaN;
 end;
 procedure InitCmdItem(Num:Integer; Enabled:Boolean; Priority,FuncId,SAddr,Quant:Integer; OpData,OpBuff:Real);
 begin
  if IsValidCmdNum(Num) then begin
   EM2RS.Modbus.Cmd.Enabled[Num]:=Enabled;
   EM2RS.Modbus.Cmd.Priority[Num]:=Priority;
   EM2RS.Modbus.Cmd.FuncId[Num]:=FuncId;
   EM2RS.Modbus.Cmd.SAddr[Num]:=SAddr;
   EM2RS.Modbus.Cmd.Quant[Num]:=Quant;
   EM2RS.Modbus.Cmd.OpData[Num]:=OpData;
   EM2RS.Modbus.Cmd.OpBuff[Num]:=OpBuff;
  end;
 end;
 //
 // Command table cleanup and initialization.
 //
 procedure ClearCmdTable;
 var Num:Integer;
 begin
  EM2RS.Modbus.Cmd.Num:=0;
  for Num:=1 to MaxCmdNum do InitCmdItem(Num,False,0,0,0,0,0,_NaN);
 end;
 procedure InitCmdTable;
 begin
  ClearCmdTable;
  // Table of CommandId           Enabled Priority  FunctionId        SAddr  Quant OpData OpBuff
  InitCmdItem(cm_ReadGroup1,      True,   PrNormal, modbus_fn_ReadHR, 1,     15,   0,     _NaN); // Read HR 0000-0015
  InitCmdItem(cm_ReadGroup2,      True,   PrNormal, modbus_fn_ReadHR, 81,    20,   0,     _NaN); // Read HR 0051-0065
  InitCmdItem(cm_ReadGroup3,      True,   PrNormal, modbus_fn_ReadHR, 161,   9,    0,     _NaN); // Read HR 00A1-00A9
  InitCmdItem(cm_ReadGroup4,      True,   PrNormal, modbus_fn_ReadHR, 325,   23,   0,     _NaN); // Read HR 0145-015B
  InitCmdItem(cm_ReadGroup5,      True,   PrHigh,   modbus_fn_ReadHR, 365,   47,   0,     _NaN); // Read HR 0177-0195
  InitCmdItem(cm_ReadGroup6,      True,   PrNormal, modbus_fn_ReadHR, 445,   43,   0,     _NaN); // Read HR 01BD-01E7
  InitCmdItem(cm_ReadGroup7,      True,   PrNormal, modbus_fn_ReadHR, 511,   3,    0,     _NaN); // Read HR 01FF-0201
  InitCmdItem(cm_ReadGroup8,      True,   PrNormal, modbus_fn_ReadHR, 563,   2,    0,     _NaN); // Read HR 0233
  InitCmdItem(cm_ReadGroup9,      True,   PrHigh,   modbus_fn_ReadHR, 4099,  2,    0,     _NaN); // Read HR 1003
  InitCmdItem(cm_ReadGroup10,     True,   PrNormal, modbus_fn_ReadHR, 6401,  1,    0,     _NaN); // Read HR 1901
  InitCmdItem(cm_ReadGroup11,     True,   PrNormal, modbus_fn_ReadHR, 8707,  1,    0,     _NaN); // Read HR 2203
  InitCmdItem(cm_ReadGroup12,     True,   PrHigh,   modbus_fn_ReadHR, 24576, 46,   0,     _NaN); // Read HR 6002-602D
  InitCmdItem(cm_ReadGroup13,     True,   PrHigh,   modbus_fn_ReadHR, 25088, 6,    0,     _NaN); // Read HR 6200-6205
  InitCmdItem(cm_WritPulse,       False,  PrNormal, modbus_fn_WritMR, 1,     1,    0,     _NaN); // $0001 Pulse/Revolution
  InitCmdItem(cm_WritCtrlMode,    False,  PrNormal, modbus_fn_WritMR, 3,     1,    0,     _NaN); // $0003 Control Mode (CS2RS)
  InitCmdItem(cm_WritMotDirect,   False,  PrNormal, modbus_fn_WritMR, 7,     1,    0,     _NaN); // $0007 Motor Direction
  InitCmdItem(cm_WritPosError,    False,  PrNormal, modbus_fn_WritMR, 11,    1,    0,     _NaN); // $000B Allowed max position following error (CS2RS)
  InitCmdItem(cm_WritForced,      False,  PrNormal, modbus_fn_WritMR, 15,    1,    0,     _NaN); // $000F Forced enable by software (CS2RS)
  InitCmdItem(cm_WritPosLoopKp,   False,  PrNormal, modbus_fn_WritMR, 81,    1,    0,     _NaN); // $0051 Position loop Kp  (CS2RS)
  InitCmdItem(cm_WritVelLoopKi,   False,  PrNormal, modbus_fn_WritMR, 83,    1,    0,     _NaN); // $0053 Velocity loop Ki  (CS2RS)
  InitCmdItem(cm_WritVelLoopKp,   False,  PrNormal, modbus_fn_WritMR, 85,    1,    0,     _NaN); // $0055 Velocity loop Kp  (CS2RS)
  InitCmdItem(cm_WritPosLoopKph,  False,  PrNormal, modbus_fn_WritMR, 101,   1,    0,     _NaN); // $0065 Position loop KpH (CS2RS)
  InitCmdItem(cm_WritCmdTime,     False,  PrNormal, modbus_fn_WritMR, 161,   1,    0,     _NaN); // $00A1 Command filter time (CS2RS)
  InitCmdItem(cm_WritVelOtoC,     False,  PrNormal, modbus_fn_WritMR, 163,   1,    0,     _NaN); // $00A3 Vel swtch pnt: O to C loop (CS2RS)
  InitCmdItem(cm_WritVelCtoO,     False,  PrNormal, modbus_fn_WritMR, 165,   1,    0,     _NaN); // $00A5 Vel swtch pnt: C to O loop (CS2RS)
  InitCmdItem(cm_WritDelayOtoC,   False,  PrNormal, modbus_fn_WritMR, 167,   1,    0,     _NaN); // $00A7 Delay of O to C loop (CS2RS)
  InitCmdItem(cm_WritDelayCtoO,   False,  PrNormal, modbus_fn_WritMR, 169,   1,    0,     _NaN); // $00A9 Delay of C to O loop (CS2RS)
  InitCmdItem(cm_WritCfgInput1,   False,  PrHigh,   modbus_fn_WritMR, 325,   1,    0,     _NaN); // $0145 Input port DI1
  InitCmdItem(cm_WritCfgInput2,   False,  PrHigh,   modbus_fn_WritMR, 327,   1,    0,     _NaN); // $0147 Input port DI2
  InitCmdItem(cm_WritCfgInput3,   False,  PrHigh,   modbus_fn_WritMR, 329,   1,    0,     _NaN); // $0149 Input port DI3
  InitCmdItem(cm_WritCfgInput4,   False,  PrHigh,   modbus_fn_WritMR, 331,   1,    0,     _NaN); // $014B Input port DI4
  InitCmdItem(cm_WritCfgInput5,   False,  PrHigh,   modbus_fn_WritMR, 333,   1,    0,     _NaN); // $014D Input port DI5
  InitCmdItem(cm_WritCfgInput6,   False,  PrHigh,   modbus_fn_WritMR, 335,   1,    0,     _NaN); // $014F Input port DI6
  InitCmdItem(cm_WritCfgInput7,   False,  PrHigh,   modbus_fn_WritMR, 337,   1,    0,     _NaN); // $0151 Input port DI7
  InitCmdItem(cm_WritCfgOutput1,  False,  PrHigh,   modbus_fn_WritMR, 343,   1,    0,     _NaN); // $0157 Output port DO1
  InitCmdItem(cm_WritCfgOutput2,  False,  PrHigh,   modbus_fn_WritMR, 345,   1,    0,     _NaN); // $0159 Output port DO2
  InitCmdItem(cm_WritCfgOutput3,  False,  PrHigh,   modbus_fn_WritMR, 347,   1,    0,     _NaN); // $015B Output port DO3
  InitCmdItem(cm_WritAlrmDetect,  False,  PrNormal, modbus_fn_WritMR, 365,   1,    0,     _NaN); // $016D Alarm detection selection
  InitCmdItem(cm_WritDist2Send,   False,  PrNormal, modbus_fn_WritMR, 369,   1,    0,     _NaN); // $0171 Dist. 2send "In Pos" Out sign
  InitCmdItem(cm_WritBusVolt,     False,  PrHigh,   modbus_fn_WritMR, 375,   1,    0,     _NaN); // $0177 Bus Voltage
  InitCmdItem(cm_WritPeakCur,     False,  PrHigh,   modbus_fn_WritMR, 401,   1,    0,     _NaN); // $0191 Peak Current
  InitCmdItem(cm_WritHoldInClsd,  False,  PrNormal, modbus_fn_WritMR, 403,   1,    0,     _NaN); // $0193 % of hold curr in closed-loop
  InitCmdItem(cm_WritHoldInOpen,  False,  PrNormal, modbus_fn_WritMR, 405,   1,    0,     _NaN); // $0195 % of hold curr in open-loop
  InitCmdItem(cm_WritStbCurPer,   False,  PrNormal, modbus_fn_WritMR, 467,   1,    0,     _NaN); // $01D3 Standby Current %
  InitCmdItem(cm_WritJOGvel,      False,  PrNormal, modbus_fn_WritMR, 481,   1,    0,     _NaN); // $01E1 JOG Velocity
  InitCmdItem(cm_WritJOGinter,    False,  PrNormal, modbus_fn_WritMR, 483,   1,    0,     _NaN); // $01E3 Interval
  InitCmdItem(cm_WritJOGruntime,  False,  PrNormal, modbus_fn_WritMR, 485,   1,    0,     _NaN); // $01E5 Running times
  InitCmdItem(cm_WritJOGaccDec,   False,  PrNormal, modbus_fn_WritMR, 487,   1,    0,     _NaN); // $01E7 Acc/Dec. time
  InitCmdItem(cm_WritEncodeRes,   False,  PrNormal, modbus_fn_WritMR, 563,   1,    0,     _NaN); // $0233 Encoder resolution
  InitCmdItem(cm_WritCtrlWord,    False,  PrNormal, modbus_fn_WritMR, 6145,  1,    0,     _NaN); // $1801 Control Word
  InitCmdItem(cm_WritPRcontrol,   False,  PrNormal, modbus_fn_WritMR, 24576, 1,    0,     _NaN); // $6000 PR control register
  InitCmdItem(cm_WritTrigger,     False,  PrHigh,   modbus_fn_WritMR, 24578, 1,    0,     _NaN); // $6002 Trigger register
  InitCmdItem(cm_WritSoftLimPos,  False,  PrHigh,   modbus_fn_WritMR, 24582, 2,    0,     _NaN); // $6006+$6007 Software limit positive
  InitCmdItem(cm_WritSoftLimNeg,  False,  PrHigh,   modbus_fn_WritMR, 24584, 2,    0,     _NaN); // $6008+$6009 Software limit negative
  InitCmdItem(cm_WritAfterHoming, False,  PrNormal, modbus_fn_WritMR, 24589, 2,    0,     _NaN); // $600D+$600E Move after homing
  InitCmdItem(cm_WritHomingMode,  False,  PrNormal, modbus_fn_WritMR, 24586, 1,    0,     _NaN); // $600A Homing mode
  InitCmdItem(cm_WritHomHighVel,  False,  PrNormal, modbus_fn_WritMR, 24591, 1,    0,     _NaN); // $600F Homing hight veloci
  InitCmdItem(cm_WritHomLowVel,   False,  PrNormal, modbus_fn_WritMR, 24592, 1,    0,     _NaN); // $6010 Homing low velocity
  InitCmdItem(cm_WritHomingAcc,   False,  PrNormal, modbus_fn_WritMR, 24593, 1,    0,     _NaN); // $6011 Homing Acc
  InitCmdItem(cm_WritHomingDec,   False,  PrNormal, modbus_fn_WritMR, 24594, 1,    0,     _NaN); // $6012 Homing Dec
  InitCmdItem(cm_WritLimStopTime, False,  PrHigh,   modbus_fn_WritMR, 24598, 1,    0,     _NaN); // $6016 Limit stop time
  InitCmdItem(cm_WritEStopTime,   False,  PrHigh,   modbus_fn_WritMR, 24599, 1,    0,     _NaN); // $6017 E-STOP time
  InitCmdItem(cm_WritMotPath0,    False,  PrHigh,   modbus_fn_WritMR, 25088, 1,    0,     _NaN); // $6200 Motion of path 0
  InitCmdItem(cm_WritPosition,    False,  PrHigh,   modbus_fn_WritMR, 25089, 2,    0,     _NaN); // $6201+$6202 Position
  InitCmdItem(cm_WritSpeed,       False,  PrHigh,   modbus_fn_WritMR, 25091, 1,    0,     _NaN); // $6203 Velocity
  InitCmdItem(cm_WritAccel,       False,  PrHigh,   modbus_fn_WritMR, 25092, 1,    0,     _NaN); // $6204 Acc
  InitCmdItem(cm_WritDeccel,      False,  PrHigh,   modbus_fn_WritMR, 25093, 1,    0,     _NaN); // $6205 Dec
 end;
 //
 // Assign modbus last sent polling request record.
 //
 procedure AssignModbusPoll(ref,cid:Integer; tim:Real; port,uid,fid,saddr,quant:Integer; dat:String);
 begin
  EM2RS.Modbus.Poll.ref:=ref;     EM2RS.Modbus.Poll.cid:=cid;     EM2RS.Modbus.Poll.tim:=tim;
  EM2RS.Modbus.Poll.port:=port;   EM2RS.Modbus.Poll.uid:=uid;     EM2RS.Modbus.Poll.fid:=fid;
  EM2RS.Modbus.Poll.saddr:=saddr; EM2RS.Modbus.Poll.quant:=quant; EM2RS.Modbus.Poll.dat:=dat;
 end;
 //
 // Clear modbus polling request to be ready for next polling.
 //
 procedure ClearModbusPoll;
 begin
  EM2RS.Modbus.Poll.cid:=0;
  EM2RS.Modbus.Poll.dat:='';
 end;
 //
 // Clear modbus poll summ counters.
 //
 procedure ClearModbusSumm;
 begin
  EM2RS.Modbus.Poll.Summ.Rx:=0;
  EM2RS.Modbus.Poll.Summ.Tx:=0;
  EM2RS.Modbus.Poll.Summ.Ex:=0;
 end;
 //
 // Clear modbus poll rate counters.
 //
 procedure ClearModbusRate;
 begin
  EM2RS.Modbus.Poll.Rate.Rx:=0;
  EM2RS.Modbus.Poll.Rate.Tx:=0;
  EM2RS.Modbus.Poll.Rate.Ex:=0;
 end;
 //
 // Increment summ and rate counters.
 //
 procedure IncSummRate(var summ,rate:Real);
 begin
  summ:=summ+1; rate:=rate+1;
 end;
 //
 // Format error message with with error counter increment.
 // Usage is like: Trouble(GotBug(...)); Problem(GotBug(...));
 //
 function GotBug(msg:String):String;
 begin
  IncSummRate(EM2RS.Modbus.Poll.Summ.Ex,EM2RS.Modbus.Poll.Rate.Ex);
  GotBug:=msg;
 end;
 {
 Command to browse help.
 }
 function BrowserCmd:String;
 var s:String;
 begin
  s:='cmd /c start';
  if IsUnix then begin
   if (ParamStr('FileSearch firefox')<>'')
   then s:='firefox' else s:='xdg-open';
  end;
  BrowserCmd:=s; s:='';
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  if Length(s)>0 then ShowTooltip('guid '+Str(getpid)+'@'+ProgName+' text "'+s+'" preset stdHelp delay 15000'
                      +' btn1 Справка cmd1 "'+BrowserCmd+' '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.html')+'"');
 end;
 {
 Select current homing mode
 }
 function HomingModeSelect(v:Integer):Integer;
 begin
  if v=2  then v:=0 else
  if v=6  then v:=1 else
  if v=10 then v:=2 else
  if v=14 then v:=3 else
  if v=32 then v:=4;
  HomingModeSelect:=v;
 end;
 {
 Select current motion path
 }
 function MotPath0Select(v:Integer):Integer;
 begin
  if v=1  then v:=0 else
  if v=65 then v:=1;
  MotPath0Select:=v;
 end;
 {
 Select current input configuration
 }
 function InputConfigurationSelect(v:Integer):Integer;
 begin
  if (v=0)  or (v=128) then v:=0 else
  if (v=7)  or (v=135) then v:=1 else
  if (v=8)  or (v=136) then v:=2 else
  if (v=32) or (v=160) then v:=3 else
  if (v=33) or (v=161) then v:=4 else
  if (v=34) or (v=162) then v:=5 else
  if (v=35) or (v=163) then v:=6 else
  if (v=36) or (v=164) then v:=7 else
  if (v=37) or (v=165) then v:=8 else
  if (v=38) or (v=166) then v:=9 else
  if (v=39) or (v=167) then v:=10;
  InputConfigurationSelect:=v;
 end;
 {
 Select current output configuration
 }
 function OutputConfigurationSelect(v:Integer):Integer;
 begin
  if (v=0)  or (v=128) then v:=0 else
  if (v=32) or (v=160) then v:=1 else
  if (v=33) or (v=161) then v:=2 else
  if (v=34) or (v=162) then v:=3 else
  if (v=35) or (v=163) then v:=4 else
  if (v=36) or (v=164) then v:=5 else
  if (v=37) or (v=165) then v:=6;
  OutputConfigurationSelect:=v;
 end;
 {
 Menu Tools Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Инструменты');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть окно: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: нормальный  (3)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: ввод-вывод (15)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: детальный  (31)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Загрузить параметры из INI файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@LoadIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сохранить параметры в  INI файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SaveIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Очистка счетчиков ошибок '+DevName);
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@ClearModbusSumm');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Очистка счетчиков ошибок '+ModbusProxy);
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@ZeroPortCounters 0');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезапустить локальный драйвер '+DevName);
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SysEval @Daq Compile '+DevName);
   //////////////////////////////////////////
   if DIM_IsClientMode then begin
    n:=n+EditAddInputLn('Перезапустить удаленный драйвер '+DevName);
    n:=n+EditAddConfirm(EditGetLastInputLn);
    n:=n+EditAddCommand(DimRemote+'@SysEval @Daq Compile '+DevName);
   end;
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Настройка параметров контроллера');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@WinSelect '+StringReplace(Copy(DevName,2,Length(DevName)),'DRV','PARAM',rfignorecase));
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu HomingMode to start editing.
 }
 procedure MenuHomingModeStarter;
 var n:Integer; s:String;
 begin
  s:='';
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Режим поиска базы');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Начальное положение по концевику');
   n:=n+EditAddCommand(DimRemote+'@PARAM HOMINGMODE 2');
   n:=n+EditAddInputLn('Заданное начальное положение');
   n:=n+EditAddCommand(DimRemote+'@PARAM HOMINGMODE 6');
   n:=n+EditAddInputLn('Начальное положение по сигналу Z');
   n:=n+EditAddCommand(DimRemote+'@PARAM HOMINGMODE 10');
   n:=n+EditAddInputLn('Начальное положение по моменту');
   n:=n+EditAddCommand(DimRemote+'@PARAM HOMINGMODE 14');
   n:=n+EditAddInputLn('Ближайшее начальное положение');
   n:=n+EditAddCommand(DimRemote+'@PARAM HOMINGMODE 34');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   s:=Str(HomingModeSelect(iGetTag(EM2RS.PARAM.HOMINGMODE.tag)));
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_HOMINGMODE'),s);
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
  s:='';
 end;
 {
 Menu CtrlWord to start editing.
 }
 procedure MenuCtrlWordStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Сохранить/Сбросить');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сброс ошибки тока');
   n:=n+EditAddCommand(DimRemote+'@PARAM CTRLWORD 4369');
   n:=n+EditAddInputLn('Сброс истории ошибок');
   n:=n+EditAddCommand(DimRemote+'@PARAM CTRLWORD 4386');
   n:=n+EditAddInputLn('Сохранение всех параметров в EEPROM');
   n:=n+EditAddCommand(DimRemote+'@PARAM CTRLWORD 8721');
   n:=n+EditAddInputLn('Сброс параметров (за исключением параметров двигателя)');
   n:=n+EditAddCommand(DimRemote+'@PARAM CTRLWORD 8738');
   n:=n+EditAddInputLn('Сброс всех параметров до стандартных значений');
   n:=n+EditAddCommand(DimRemote+'@PARAM CTRLWORD 8755');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CTRLWORD'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Trigger to start editing.
 }
 procedure MenuTriggerStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Управление');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Выполнить движение');
   n:=n+EditAddCommand(DimRemote+'@PARAM TRIGGER 16');
   n:=n+EditAddInputLn('Поиск базы');
   n:=n+EditAddCommand(DimRemote+'@PARAM TRIGGER 32');
   n:=n+EditAddInputLn('Сделать текущую позицию нулевой');
   n:=n+EditAddCommand(DimRemote+'@PARAM TRIGGER 33');
   n:=n+EditAddInputLn('Аварийная остановка');
   n:=n+EditAddCommand(DimRemote+'@PARAM TRIGGER 64');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TRIGGER'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu Motion of path 0 to start editing.
 }
 procedure MenuMotPath0Starter;
 var n:Integer; s:String;
 begin
  s:='';
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Режим движения');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Движение на заданную позицию');
   n:=n+EditAddCommand(DimRemote+'@PARAM MOTPATH0 1');
   n:=n+EditAddInputLn('Смещение на заданную позицию');
   n:=n+EditAddCommand(DimRemote+'@PARAM MOTPATH0 65');
   n:=n+EditAddInputLn('Движение с заданной скоростью');
   n:=n+EditAddCommand(DimRemote+'@PARAM MOTPATH0 2');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   s:=Str(MotPath0Select(iGetTag(EM2RS.PARAM.MOTPATH0.tag)));
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_MotPath0'),s);
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
  s:='';
 end;
 {
 Menu InputConfiguration to start editing.
 }
 procedure MenuInputConfiguration(InputNumber:integer);
 var n:Integer; s:String;
 begin
  s:='';
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Входной сигнал №'+str(InputNumber));
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Не задействован');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGINPUT'+str(InputNumber)+' 0');
   n:=n+EditAddInputLn('Очистка ошибок');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGINPUT'+str(InputNumber)+' 7');
   n:=n+EditAddInputLn('Сигнал включения');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGINPUT'+str(InputNumber)+' 8');
   n:=n+EditAddInputLn('"Триггер"');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGINPUT'+str(InputNumber)+' 32');
   n:=n+EditAddInputLn('Триггер поиска базы');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGINPUT'+str(InputNumber)+' 33');
   n:=n+EditAddInputLn('Экстренная остановка');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGINPUT'+str(InputNumber)+' 34');
   n:=n+EditAddInputLn('CW ручное управление');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGINPUT'+str(InputNumber)+' 35');
   n:=n+EditAddInputLn('CCW ручное управление');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGINPUT'+str(InputNumber)+' 36');
   n:=n+EditAddInputLn('Положительный предел');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGINPUT'+str(InputNumber)+' 37');
   n:=n+EditAddInputLn('Отрицательный предел');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGINPUT'+str(InputNumber)+' 38');
   n:=n+EditAddInputLn('Сигнал поиска базы');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGINPUT'+str(InputNumber)+' 39');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   s:=Str(InputConfigurationSelect(iGetTag(findtag(tagPrefix+'.CFGINPUT'+str(InputNumber)))));
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_INPUT'+str(InputNumber)),s);
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
  s:='';
 end;

 {
 Menu InputConfiguration to start editing.
 }
 procedure MenuOutputConfiguration(InputNumber:integer);
 var n:Integer; s:String;
 begin
  s:='';
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Выходной сигнал №'+str(InputNumber));
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Не задействован');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGOUTPUT'+str(InputNumber)+' 0');
   n:=n+EditAddInputLn('Команда завершена');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGOUTPUT'+str(InputNumber)+' 32');
   n:=n+EditAddInputLn('Перемещение завершено');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGOUTPUT'+str(InputNumber)+' 33');
   n:=n+EditAddInputLn('Поиск базы завершен');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGOUTPUT'+str(InputNumber)+' 34');
   n:=n+EditAddInputLn('Позиционирование завершено');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGOUTPUT'+str(InputNumber)+' 35');
   n:=n+EditAddInputLn('Вывод торможения');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGOUTPUT'+str(InputNumber)+' 36');
   n:=n+EditAddInputLn('Вывод ошибок');
   n:=n+EditAddCommand(DimRemote+'@PARAM CFGOUTPUT'+str(InputNumber)+' 37');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   s:=Str(OutputConfigurationSelect(iGetTag(findtag(tagPrefix+'.CFGOUTPUT'+str(InputNumber)))));
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_OUTPUT'+str(InputNumber)),s);
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
  s:='';
 end;
 {
 Menus Handler to handle editing.
 }
 procedure MenusHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
  EditMenuDefaultHandler(EditGetUID('MENU_MOTPATH0'));
  EditMenuDefaultHandler(EditGetUID('MENU_HOMINGMODE'));
  EditMenuDefaultHandler(EditGetUID('MENU_CTRLWORD'));
  EditMenuDefaultHandler(EditGetUID('MENU_TRIGGER'));
  EditMenuDefaultHandler(EditGetUID('MENU_INPUT1'));
  EditMenuDefaultHandler(EditGetUID('MENU_INPUT2'));
  EditMenuDefaultHandler(EditGetUID('MENU_INPUT3'));
  EditMenuDefaultHandler(EditGetUID('MENU_INPUT4'));
  EditMenuDefaultHandler(EditGetUID('MENU_INPUT5'));
  EditMenuDefaultHandler(EditGetUID('MENU_INPUT6'));
  EditMenuDefaultHandler(EditGetUID('MENU_INPUT7'));
  EditMenuDefaultHandler(EditGetUID('MENU_OUTPUT1'));
  EditMenuDefaultHandler(EditGetUID('MENU_OUTPUT2'));
  EditMenuDefaultHandler(EditGetUID('MENU_OUTPUT3'));
 end;
 //
 // GetSimValue
 //
 function GetSimValue(value:integer):integer;
 begin
  if value>32768 then value:=value-65536;
  GetSimValue:=value;
 end;
 //
 // Check move button state on main GUI
 //
 procedure MoveGUIHandler;
 begin
  if iGetTag(EM2RS.PARAM.CFGINPUT1.tag)  > 127 then bNul(isettag(EM2RS.PARAM.CFGI1_NC.tag,1)) else bNul(isettag(EM2RS.PARAM.CFGI1_NC.tag,0));
  if iGetTag(EM2RS.PARAM.CFGINPUT2.tag)  > 127 then bNul(isettag(EM2RS.PARAM.CFGI2_NC.tag,1)) else bNul(isettag(EM2RS.PARAM.CFGI2_NC.tag,0));
  if iGetTag(EM2RS.PARAM.CFGINPUT3.tag)  > 127 then bNul(isettag(EM2RS.PARAM.CFGI3_NC.tag,1)) else bNul(isettag(EM2RS.PARAM.CFGI3_NC.tag,0));
  if iGetTag(EM2RS.PARAM.CFGINPUT4.tag)  > 127 then bNul(isettag(EM2RS.PARAM.CFGI4_NC.tag,1)) else bNul(isettag(EM2RS.PARAM.CFGI4_NC.tag,0));
  if iGetTag(EM2RS.PARAM.CFGINPUT5.tag)  > 127 then bNul(isettag(EM2RS.PARAM.CFGI5_NC.tag,1)) else bNul(isettag(EM2RS.PARAM.CFGI5_NC.tag,0));
  if iGetTag(EM2RS.PARAM.CFGINPUT6.tag)  > 127 then bNul(isettag(EM2RS.PARAM.CFGI6_NC.tag,1)) else bNul(isettag(EM2RS.PARAM.CFGI6_NC.tag,0));
  if iGetTag(EM2RS.PARAM.CFGINPUT7.tag)  > 127 then bNul(isettag(EM2RS.PARAM.CFGI7_NC.tag,1)) else bNul(isettag(EM2RS.PARAM.CFGI7_NC.tag,0));
  if iGetTag(EM2RS.PARAM.CFGOUTPUT1.tag) > 127 then bNul(isettag(EM2RS.PARAM.CFGO1_NC.tag,1)) else bNul(isettag(EM2RS.PARAM.CFGO1_NC.tag,0));
  if iGetTag(EM2RS.PARAM.CFGOUTPUT2.tag) > 127 then bNul(isettag(EM2RS.PARAM.CFGO2_NC.tag,1)) else bNul(isettag(EM2RS.PARAM.CFGO2_NC.tag,0));
  if iGetTag(EM2RS.PARAM.CFGOUTPUT3.tag) > 127 then bNul(isettag(EM2RS.PARAM.CFGO3_NC.tag,1)) else bNul(isettag(EM2RS.PARAM.CFGO3_NC.tag,0));
 end;
 //
 // Find the current Proxy device to send @Modbus.Poll message.
 //
 function devTheProxy:Integer;
 begin
  if EM2RS.Simulator                // In simulation mode
  then devTheProxy:=devMySelf       // send messages to himself
  else devTheProxy:=devModbusProxy; // otherwise use &ModbusProxy
 end;
 //
 // Check if communication port is opened or not.
 // As long as we use Proxy device, check Port number & device reference.
 //
 function IsPortOpened:Boolean;
 begin
  IsPortOpened:=(EM2RS.Modbus.Port>0) and (devTheProxy<>0);
 end;
 //
 // Calculate Modbus request PDU by command id.
 // cid   - (in)  command id number.
 // fid   - (out) Modbus function id.
 // saddr - (out) zero-based start address of registers to read/write.
 // quant - (out) data quantity, i.e. number of r/w registers or single register r/w value.
 // dat   - (out) Modbus PDU data unit, PDU=(fid+dat).
 //
 function EM2RS_CalcPDU(cid:Integer; var fid,saddr,quant:Integer; var dat:String):Boolean;
  procedure Cleanup;
  begin
   fid:=0; saddr:=0; quant:=0; dat:='';
  end;
 begin
  Cleanup;
  if IsEnabledCmdNum(cid) then begin
   fid:=EM2RS.Modbus.Cmd.FuncId[cid];
   saddr:=EM2RS.Modbus.Cmd.SAddr[cid];
   quant:=EM2RS.Modbus.Cmd.Quant[cid];
   if (cid=cm_ReadGroup1)      then dat:=modbus_encode_pdu('R',fid,saddr,quant,'') else
   if (cid=cm_ReadGroup2)      then dat:=modbus_encode_pdu('R',fid,saddr,quant,'') else
   if (cid=cm_ReadGroup3)      then dat:=modbus_encode_pdu('R',fid,saddr,quant,'') else
   if (cid=cm_ReadGroup4)      then dat:=modbus_encode_pdu('R',fid,saddr,quant,'') else
   if (cid=cm_ReadGroup5)      then dat:=modbus_encode_pdu('R',fid,saddr,quant,'') else
   if (cid=cm_ReadGroup6)      then dat:=modbus_encode_pdu('R',fid,saddr,quant,'') else
   if (cid=cm_ReadGroup7)      then dat:=modbus_encode_pdu('R',fid,saddr,quant,'') else
   if (cid=cm_ReadGroup8)      then dat:=modbus_encode_pdu('R',fid,saddr,quant,'') else
   if (cid=cm_ReadGroup9)      then dat:=modbus_encode_pdu('R',fid,saddr,quant,'') else
   if (cid=cm_ReadGroup10)     then dat:=modbus_encode_pdu('R',fid,saddr,quant,'') else
   if (cid=cm_ReadGroup11)     then dat:=modbus_encode_pdu('R',fid,saddr,quant,'') else
   if (cid=cm_ReadGroup12)     then dat:=modbus_encode_pdu('R',fid,saddr,quant,'') else
   if (cid=cm_ReadGroup13)     then dat:=modbus_encode_pdu('R',fid,saddr,quant,'') else
   if (cid=cm_WritPulse)       then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritCtrlMode)    then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritMotDirect)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritPosError)    then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritForced)      then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritPosLoopKp)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritVelLoopKi)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritVelLoopKp)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritPosLoopKph)  then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritCmdTime)     then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritVelOtoC)     then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritVelCtoO)     then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritDelayOtoC)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritDelayCtoO)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritCfgInput1)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritCfgInput2)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritCfgInput3)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritCfgInput4)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritCfgInput5)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritCfgInput6)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritCfgInput7)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritCfgOutput1)  then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritCfgOutput2)  then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritCfgOutput3)  then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritAlrmDetect)  then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritDist2Send)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritBusVolt)     then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritPeakCur)     then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritHoldInClsd)  then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritHoldInOpen)  then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritStbCurPer)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritJOGvel)      then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritJOGinter)    then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritJOGruntime)  then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritJOGaccDec)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritEncodeRes)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritCtrlWord)    then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritPRcontrol)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritTrigger)     then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritSoftLimPos)  then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int32(round(GetCmdOpData(cid)),SwapModeInt32)) else
   if (cid=cm_WritSoftLimNeg)  then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int32(round(GetCmdOpData(cid)),SwapModeInt32)) else
   if (cid=cm_WritAfterHoming) then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int32(round(GetCmdOpData(cid)),SwapModeInt32)) else
   if (cid=cm_WritHomingMode)  then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritHomHighVel)  then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritHomLowVel)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritHomingAcc)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritHomingDec)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritLimStopTime) then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritEStopTime)   then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritMotPath0)    then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritSpeed)       then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritAccel)       then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritDeccel)      then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int16(round(GetCmdOpData(cid)),SwapModeFloat)) else
   if (cid=cm_WritPosition)    then dat:=modbus_encode_pdu('R',fid,saddr,quant,modbus_dump_int32(round(GetCmdOpData(cid)),SwapModeInt32)) else
   Trouble(GotBug('Invalid command id '+Str(cid)));
  end;
  EM2RS_CalcPDU:=modbus_func_ok(fid) and (Length(dat)>0);
 end;
 //
 // Main Modbus command handler to process Modbus device reply.
 // cid   - (in)  command id number.
 // fid   - (in)  Modbus function id.
 // saddr - (in)  zero-based start address of registers to read/write.
 // quant - (in)  data quantity, i.e. number of r/w registers or single register r/w value.
 // raw   - (in)  raw coils/registers data array.
 //
 procedure EM2RS_OnCommand(cid,fid,saddr,quant:Integer; raw:String);
 var addr,offs,indic:Integer; r:Real;
  procedure Cleanup;
  begin
   addr:=0; offs:=0; indic:=0; r:=0;
  end;
 begin
  Cleanup;
  if IsValidCmdNum(cid) then begin
   if cid=cm_ReadGroup1 then begin
    { Read HR UnsignInt16 0000-0015(hex)
    ***************************************************
    | $0001 Pulse/Revolution
    | $0003 Control Mode (CS2RS)
    | $0007 Motor Direction
    | $000B Allowed max position following error (CS2RS)
    | $000F Forced enable by software (CS2RS)
    ***************************************************
    }
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs; // PLC reg.address
     if (addr=1) and (quant-offs+1>=1) then begin // Pr0.00 Pulse/Revolution
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.PULSE.tag,round(r)));
      UpdateAo(ao_PULSE,time,r);
     end else if (addr=3) and (quant-offs+1>=1) then begin // Pr0.01 Control Mode
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.CTRLMODE.tag,round(r)));
      UpdateAo(ao_CTRLMODE,time,r);
     end else if (addr=7) and (quant-offs+1>=1) then begin // Pr0.03 Motor Direction
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.MOTDIRECT.tag,round(r)));
      UpdateAo(ao_MOTDIRECT,time,r);
     end else if (addr=11) and (quant-offs+1>=1) then begin // Pr0.05 Allowed max position following error
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.POSERROR.tag,round(r)));
      UpdateAo(ao_POSERROR,time,r);
     end else if (addr=15) and (quant-offs+1>=1) then begin // Pr0.07 Forced enable by software
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.FORCED.tag,round(r)));
      UpdateAo(ao_FORCED,time,r);
     end;
    end;
   end else if cid=cm_ReadGroup2 then begin
    { Read HR UnsignInt16 0145-015B(hex)
    ***************************************************
    | $0051 Position loop Kp
    | $0053 Velocity loop Ki
    | $0055 Velocity loop Kp
    | $0065 Position loop KpH
    ***************************************************
    }
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs; // PLC reg.address
     if (addr=81) and (quant-offs+1>=1) then begin // Position loop Kp
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.POSLOOPKP.tag,round(r)));
      UpdateAo(ao_POSLOOPKP,time,r);
     end else if (addr=83) and (quant-offs+1>=1) then begin // Velocity loop Ki
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.VELLOOPKI.tag,round(r)));
      UpdateAo(ao_VELLOOPKI,time,r);
     end else if (addr=85) and (quant-offs+1>=1) then begin // Velocity loop Kp
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.VELLOOPKP.tag,round(r)));
      UpdateAo(ao_VELLOOPKP,time,r);
     end else if (addr=101) and (quant-offs+1>=1) then begin // Position loop KpH
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.POSLOOPKPH.tag,round(r)));
      UpdateAo(ao_POSLOOPKPH,time,r);
     end;
    end;
   end else if cid=cm_ReadGroup3 then begin
    { Read HR UnsignInt16 00A1-00A9(hex)
    ***************************************************
    | $00A1 Command filter time *
    | $00A3 Vel swtch pnt: O to C loop *
    | $00A5 Vel swtch pnt: C to O loop *
    | $00A7 Delay of O to C loop *
    | $00A9 Delay of C to O loop *
    ***************************************************
    }
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs; // PLC reg.address
     if (addr=161) and (quant-offs+1>=1) then begin // Command filter time
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.CMDTIME.tag,round(r)));
      UpdateAo(ao_CMDTIME,time,r);
     end else if (addr=163) and (quant-offs+1>=1) then begin // Vel swtch pnt: O to C loop
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.VELOTOC.tag,round(r)));
      UpdateAo(ao_VELOTOC,time,r);
     end else if (addr=165) and (quant-offs+1>=1) then begin // Vel swtch pnt: C to O loop
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.VELCTOO.tag,round(r)));
      UpdateAo(ao_VELCTOO,time,r);
     end else if (addr=167) and (quant-offs+1>=1) then begin // Delay of O to C loop
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.DELAYOTOC.tag,round(r)));
      UpdateAo(ao_DELAYOTOC,time,r);
     end else if (addr=169) and (quant-offs+1>=1) then begin // Delay of C to O loop
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.DELAYCTOO.tag,round(r)));
      UpdateAo(ao_DELAYCTOO,time,r);
     end;
    end;
   end else if cid=cm_ReadGroup4 then begin
    { Read HR UnsignInt16 0145-015B(hex)
    ***************************************************
    | $0145 Input port DI1
    | $0147 Input port DI2
    | $0149 Input port DI3
    | $014B Input port DI4
    | $014D Input port DI5
    | $014F Input port DI6
    | $0151 Input port DI7
    | $0157 Output port DO1
    | $0159 Output port DO2
    | $015B Output port DO3
    ***************************************************
    }
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs; // PLC reg.address
     if (addr=325) and (quant-offs+1>=1) then begin // Input port DI1
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.CFGINPUT1.tag,round(r)));
      UpdateAo(ao_CFGINPUT1,time,r);
     end else if (addr=327) and (quant-offs+1>=1) then begin // Input port DI2
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.CFGINPUT2.tag,round(r)));
      UpdateAo(ao_CFGINPUT2,time,r);
     end else if (addr=329) and (quant-offs+1>=1) then begin // Input port DI3
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.CFGINPUT3.tag,round(r)));
      UpdateAo(ao_CFGINPUT3,time,r);
     end else if (addr=331) and (quant-offs+1>=1) then begin // Input port DI4
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.CFGINPUT4.tag,round(r)));
      UpdateAo(ao_CFGINPUT4,time,r);
     end else if (addr=333) and (quant-offs+1>=1) then begin // Input port DI5
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.CFGINPUT5.tag,round(r)));
      UpdateAo(ao_CFGINPUT5,time,r);
     end else if (addr=335) and (quant-offs+1>=1) then begin // Input port DI6
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.CFGINPUT6.tag,round(r)));
      UpdateAo(ao_CFGINPUT6,time,r);
     end else if (addr=337) and (quant-offs+1>=1) then begin // Input port DI7
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.CFGINPUT7.tag,round(r)));
      UpdateAo(ao_CFGINPUT7,time,r);
     end else if (addr=343) and (quant-offs+1>=1) then begin // Output port DO1
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.CFGOUTPUT1.tag,round(r)));
      UpdateAo(ao_CFGOUTPUT1,time,r);
     end else if (addr=345) and (quant-offs+1>=1) then begin // Output port DO2
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.CFGOUTPUT2.tag,round(r)));
      UpdateAo(ao_CFGOUTPUT2,time,r);
     end else if (addr=347) and (quant-offs+1>=1) then begin // Output port DO3
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.CFGOUTPUT3.tag,round(r)));
      UpdateAo(ao_CFGOUTPUT3,time,r);
     end;
     MoveGUIHandler;
    end;
   end else if cid=cm_ReadGroup5 then begin
    { Read HR UnsignInt16 016D-0195(hex)
    ***************************************************
    | $016D Alarm detection selection
    | $0171 Dist. 2send "In Pos" Out sign
    | $0177 Bus Voltage
    | $0179 Digital Input Status
    | $017B Digital Output Status
    | $0191 Peak Current
    | $0193 Percentage of holdting current in closed-loop mode
    | $0195 Percentage of holding current in open-loop mode
    ***************************************************
    }
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs; // PLC reg.address
     if (addr=365) and (quant-offs+1>=1) then begin // Alarm detection selection
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.ALRMDETECT.tag,round(r)));
      UpdateAo(ao_ALRMDETECT,time,r);
     end else if (addr=369) and (quant-offs+1>=1) then begin // Dist. 2send "In Pos" Out sign
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.DIST2SEND.tag,round(r)));
      UpdateAo(ao_DIST2SEND,time,r);
     end else if (addr=375) and (quant-offs+1>=1) then begin // Bus Voltage
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(rSetTag(EM2RS.PARAM.BUSVOLT.tag,r/10));
      UpdateAo(ao_BUSVOLT,time,r);
     end else if (addr=377) and (quant-offs+1>=1) then begin // Digital Input Status
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.DISTATUS.tag,round(r)));
      UpdateAo(ao_DISTATUS,time,r);
     end else if (addr=379) and (quant-offs+1>=1) then begin // Digital Output Status
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.DOSTATUS.tag,round(r)));
      UpdateAo(ao_DOSTATUS,time,r);
     end else if (addr=401) and (quant-offs+1>=1) then begin // Peak Current
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(rSetTag(EM2RS.PARAM.PEAKCUR.tag,r/10));
      UpdateAo(ao_PEAKCUR,time,r);
     end else if (addr=403) and (quant-offs+1>=1) then begin // Percentage of holdting current in closed-loop mode
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.HOLDINCLSD.tag,round(r)));
      UpdateAo(ao_HOLDINCLSD,time,r);
     end else if (addr=405) and (quant-offs+1>=1) then begin // Percentage of holding current in open-loop mode
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.HOLDINOPEN.tag,round(r)));
      UpdateAo(ao_HOLDINOPEN,time,r);
     end;
    end;
   end else if cid=cm_ReadGroup6 then begin
    { Read HR UnsignInt16 01BD-01E7(hex)
    ***************************************************
    | $01BD Baudrate
    | $01BF RS485 ID
    | $01C1 RS485 Data type selection
    | $01D3 Standby Current Percentage
    | $01E1 JOG Velocity
    | $01E3 Interval
    | $01E5 Running times
    | $01E7 Acc/Dec. time
    ***************************************************
    }
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs; // PLC reg.address
     if (addr=445) and (quant-offs+1>=1) then begin // Baudrate
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.BAUDRATE.tag,round(r)));
      UpdateAo(ao_BAUDRATE,time,r);
     end else if (addr=447) and (quant-offs+1>=1) then begin // RS485 Device Address
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.ADDRESS.tag,round(r)));
      UpdateAo(ao_ADDRESS,time,r);
     end else if (addr=449) and (quant-offs+1>=1) then begin // RS485 Data type selection
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.RS485TYPE.tag,round(r)));
      UpdateAo(ao_RS485TYPE,time,r);
     end else if (addr=467) and (quant-offs+1>=1) then begin // Standby Current Percentage
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.STBCURPER.tag,round(r)));
      UpdateAo(ao_STBCURPER,time,r);
     end else if (addr=481) and (quant-offs+1>=1) then begin // JOG Velocity
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.JOGVEL.tag,round(r)));
      UpdateAo(ao_JOGVEL,time,r);
     end else if (addr=483) and (quant-offs+1>=1) then begin // Interval
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.JOGINTER.tag,round(r)));
      UpdateAo(ao_JOGINTER,time,r);
     end else if (addr=485) and (quant-offs+1>=1) then begin // Running times
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.JOGRUNTIME.tag,round(r)));
      UpdateAo(ao_JOGRUNTIME,time,r);
     end else if (addr=487) and (quant-offs+1>=1) then begin // Acc/Dec. time
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.JOGACCDEC.tag,round(r)));
      UpdateAo(ao_JOGACCDEC,time,r);
     end;
    end;
   end else if cid=cm_ReadGroup7 then begin
    { Read HR UnsignInt16 01FF-0201(hex)
    ***************************************************
    | $01FF Version Information
    | $0201 Firmare Version
    ***************************************************
    }
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs; // PLC reg.address
     if (addr=511) and (quant-offs+1>=1) then begin // Version Information
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.SOFTWARE.tag,round(r)));
     end else if (addr=513) and (quant-offs+1>=1) then begin // Firmare Version
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.FIRMWARE.tag,round(r)));
     end;
    end;
    end else if cid=cm_ReadGroup8 then begin
    { Read HR UnsignInt16 0233(hex)
    ***************************************************
    | $0233 Encoder resolution
    ***************************************************
    }
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs; // PLC reg.address
     if (addr=563) and (quant-offs+1>=1) then begin // Encoder resolution
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.ENCODERES.tag,round(r/4)));
      UpdateAo(ao_ENCODERES,time,r);
     end;
    end;
   end else if cid=cm_ReadGroup9 then begin
    { Read HR UnsignInt16 1003(hex)
    ***************************************************
    | $1003 Motion Status
    ***************************************************
    }
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs; // PLC reg.address
     if (addr=4099) and (quant-offs+1>=1) then begin // Motion Status
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.MOTSTATUS.tag,round(r)));
      UpdateAo(ao_MOTSTATUS,time,r);
     end;
    end;
   end else if cid=cm_ReadGroup10 then begin
    { Read HR UnsignInt16 1901(hex)
    ***************************************************
    | $1901 Save parameter status word
    ***************************************************
    }
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs; // PLC reg.address
     if (addr=6401) and (quant-offs+1>=1) then begin // Save parameter status word
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.SAVEWORD.tag,round(r)));
      UpdateAo(ao_SAVEWORD,time,r);
     end;
    end;
   end else if cid=cm_ReadGroup11 then begin
    { Read HR UnsignInt16 2203(hex)
    ***************************************************
    | $2203 Current alarm
    ***************************************************
    }
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs; // PLC reg.address
     if (addr=8707) and (quant-offs+1>=1) then begin // Current alarm
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.CURALARM.tag,round(r)));
      UpdateAo(ao_CURALARM,time,r);
     end;
    end;
   end else if cid=cm_ReadGroup12 then begin
    { Read HR UnsignInt16 6002-602D(hex)
    ***************************************************
    | $6000 PR control register
    | $6002 Trigger register
    | $6006 Software limit positive hight bits
    | $6007 Software limit positive low bits
    | $6008 Software limit negative hight bits
    | $6009 Software limit negative low bits
    | $600A Homing mode
    | $600D Move to specified location after homing hight bits
    | $600E Move to specified location after homing low bits
    | $600F Homing hight velocity
    | $6010 Homing low velocity
    | $6011 Homing Acc
    | $6012 Homing Dec
    | $6016 Limit stop time
    | $6017 E-STOP time
    | $602A Profile position hight bits
    | $602B Profile position low bits
    | $602C Actual position hight bits
    | $602D Actual position low bits
    ***************************************************
    }
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs; // PLC reg.address
     if (addr=24576) and (quant-offs+1>=1) then begin // PR control register
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.PRCONTROL.tag,round(r)));
      UpdateAo(ao_PRCONTROL,time,r);
     end else if (addr=24578) and (quant-offs+1>=1) then begin // Trigger register
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.TRIGGER.tag,round(r)));
      UpdateAo(ao_TRIGGER,time,r);
      end else if (addr=24582) and (quant-offs+1>=1) then begin // Software limit positive
      r:=modbus_ext_int32(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.SOFTLIMPOS.tag,round(r)));
      UpdateAo(ao_SOFTLIMPOS,time,r);
     end else if (addr=24584) and (quant-offs+1>=1) then begin // Software limit negative
      r:=modbus_ext_int32(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.SOFTLIMNEG.tag,round(r)));
      UpdateAo(ao_SOFTLIMNEG,time,r);
     end else if (addr=24586) and (quant-offs+1>=1) then begin // Homing mode
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.HOMINGMODE.tag,round(r)));
      UpdateAo(ao_HOMINGMODE,time,r);
     end else if (addr=24589) and (quant-offs+1>=1) then begin // Move to specified location after homing
      r:=modbus_ext_int32(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.AFTERHOMING.tag,round(r)));
      UpdateAo(ao_AFTERHOMING,time,r);
     end else if (addr=24591) and (quant-offs+1>=1) then begin // Homing hight velocity
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.HOMHIGHVEL.tag,round(r)));
      UpdateAo(ao_HOMHIGHVEL,time,r);
     end else if (addr=24592) and (quant-offs+1>=1) then begin // Homing low velocity
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.HOMLOWVEL.tag,round(r)));
      UpdateAo(ao_HOMLOWVEL,time,r);
     end else if (addr=24593) and (quant-offs+1>=1) then begin // Homing Acc
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.HOMINGACC.tag,round(r)));
      UpdateAo(ao_HOMINGACC,time,r);
     end else if (addr=24594) and (quant-offs+1>=1) then begin // Homing Dec
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.HOMINGDEC.tag,round(r)));
      UpdateAo(ao_HOMINGDEC,time,r);
     end else if (addr=24598) and (quant-offs+1>=1) then begin // Limit stop time
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.LIMSTOPTIME.tag,round(r)));
      UpdateAo(ao_LIMSTOPTIME,time,r);
     end else if (addr=24599) and (quant-offs+1>=1) then begin // E-STOP time
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.ESTOPTIME.tag,round(r)));
      UpdateAo(ao_ESTOPTIME,time,r);
     end else if (addr=24620) and (quant-offs+3>=1) then begin // Actual position
      r:=modbus_ext_int32(raw,offs,SwapModeInt32); //$602C+$602D
      prevActPosition:=iGetTag(EM2RS.PARAM.ACTPOS.tag);
      bNul(iSetTag(EM2RS.PARAM.ACTPOS.tag,round(r)));
      UpdateAo(ao_ACTPOS,time,r);
      // Преобразование позиции: шаги --> mm
      bNul(rSetTag(EM2RS.POSITION.tag,calibr(0,round(r),0)));
      UpdateAo(ao_POSITION_MM,time,rGetTag(EM2RS.POSITION.tag));
     end;
    end;
   end else if cid=cm_ReadGroup13 then begin
    { Read HR UnsignInt16 6200(hex)
    ***************************************************
    | $6200 Motion of path 0
    | $6201 Position H
    | $6202 Position L
    | $6203 Velocity
    | $6204 Acc
    | $6205 Dec
    ***************************************************
    }
    for offs:=0 to quant-1 do begin
     addr:=saddr+offs; // PLC reg.address
     if (addr=25088) and (quant-offs+1>=1) then begin // Motion of path 0
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.MOTPATH0.tag,round(r)));
      UpdateAo(ao_MOTPATH0,time,r);
     end else if (addr=25089) and (quant-offs+1>=1) then begin // Position
      r:=modbus_ext_int32(raw,offs,SwapModeInt32); //$6201 + $6202
      bNul(iSetTag(EM2RS.PARAM.POSITION.tag,round(r)));
      UpdateAo(ao_POSITION,time,r);
     end else if (addr=25091) and (quant-offs+2>=1) then begin // Velocity
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      if r>32768 then r:=r-65536;
      bNul(iSetTag(EM2RS.PARAM.SPEED.tag,round(r)));
      UpdateAo(ao_SPEED,time,r);
      // Преобразование скорости RPM -> mm/sec
      bNul(rSetTag(EM2RS.SPEED.tag,r*calibr(0,iGetTag(EM2RS.PARAM.PULSE.tag),0)/60));
     end else if (addr=25092) and (quant-offs+1>=1) then begin // Acc
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.ACCELERAT.tag,round(r)));
      UpdateAo(ao_ACCELERAT,time,r);
     end else if (addr=25093) and (quant-offs+1>=1) then begin // Dec
      r:=modbus_ext_int16(raw,offs,SwapModeInt32);
      bNul(iSetTag(EM2RS.PARAM.DECCELERAT.tag,round(r)));
      UpdateAo(ao_DECCELERAT,time,r);
     end;
    end;
   end else
   if (cid=cm_WritPulse)       then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCtrlMode)    then ReleaseCmdOpData(cid) else
   if (cid=cm_WritMotDirect)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritPosError)    then ReleaseCmdOpData(cid) else
   if (cid=cm_WritForced)      then ReleaseCmdOpData(cid) else
   if (cid=cm_WritPosLoopKp)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritVelLoopKi)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritVelLoopKp)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritPosLoopKph)  then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCmdTime)     then ReleaseCmdOpData(cid) else
   if (cid=cm_WritVelOtoC)     then ReleaseCmdOpData(cid) else
   if (cid=cm_WritVelCtoO)     then ReleaseCmdOpData(cid) else
   if (cid=cm_WritDelayOtoC)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritDelayCtoO)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCfgInput1)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCfgInput2)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCfgInput3)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCfgInput4)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCfgInput5)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCfgInput6)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCfgInput7)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCfgOutput1)  then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCfgOutput2)  then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCfgOutput3)  then ReleaseCmdOpData(cid) else
   if (cid=cm_WritAlrmDetect)  then ReleaseCmdOpData(cid) else
   if (cid=cm_WritDist2Send)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritBusVolt)     then ReleaseCmdOpData(cid) else
   if (cid=cm_WritPeakCur)     then ReleaseCmdOpData(cid) else
   if (cid=cm_WritHoldInClsd)  then ReleaseCmdOpData(cid) else
   if (cid=cm_WritHoldInOpen)  then ReleaseCmdOpData(cid) else
   if (cid=cm_WritStbCurPer)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritJOGvel)      then ReleaseCmdOpData(cid) else
   if (cid=cm_WritJOGinter)    then ReleaseCmdOpData(cid) else
   if (cid=cm_WritJOGruntime)  then ReleaseCmdOpData(cid) else
   if (cid=cm_WritJOGaccDec)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritEncodeRes)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritCtrlWord)    then ReleaseCmdOpData(cid) else
   if (cid=cm_WritPRcontrol)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritTrigger)     then ReleaseCmdOpData(cid) else
   if (cid=cm_WritSoftLimPos)  then ReleaseCmdOpData(cid) else
   if (cid=cm_WritSoftLimNeg)  then ReleaseCmdOpData(cid) else
   if (cid=cm_WritAfterHoming) then ReleaseCmdOpData(cid) else
   if (cid=cm_WritHomingMode)  then ReleaseCmdOpData(cid) else
   if (cid=cm_WritHomHighVel)  then ReleaseCmdOpData(cid) else
   if (cid=cm_WritHomLowVel)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritHomingAcc)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritHomingDec)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritLimStopTime) then ReleaseCmdOpData(cid) else
   if (cid=cm_WritEStopTime)   then ReleaseCmdOpData(cid) else
   if (cid=cm_WritMotPath0)    then ReleaseCmdOpData(cid) else
   if (cid=cm_WritPosition)    then ReleaseCmdOpData(cid) else
   if (cid=cm_WritSpeed)       then ReleaseCmdOpData(cid) else
   if (cid=cm_WritAccel)       then ReleaseCmdOpData(cid) else
   if (cid=cm_WritDeccel)      then ReleaseCmdOpData(cid) else
   Trouble(GotBug('Unexpected command '+Str(cid)));
   if EM2RS.Simulator then indic:=st_SIMULAT else indic:=st_NORMAL;
   UpdateDo(do_STATE_INDIC,time,indic);
   bNul(iSetTag(EM2RS.PARAM.STATE.tag,indic));
  end;
  Cleanup;
 end;
 //
 // Data handler on @Modbus.Reply event. Process reply comes from Modbus device.
 //
 procedure EM2RS_OnReply(ref,cid,tim,port,uid,fid:Integer; dat:String);
 var raw:String; saddr,quant:Integer;
  procedure Cleanup;
  begin
   raw:=''; saddr:=0; quant:=0;
  end;
 begin
  Cleanup;
  if not IsValidCmdNum(cid) then Trouble(GotBug('Bad reply command '+Str(cid))) else
  if (port<>EM2RS.Modbus.Poll.port) then Trouble(GotBug('Bad reply port '+Str(port))) else
  if (uid<>EM2RS.Modbus.Poll.uid) then Trouble(GotBug('Bad reply unit id '+Str(uid))) else
  if (cid<>EM2RS.Modbus.Poll.cid) then Trouble(GotBug('Bad reply command id '+Str(cid))) else
  if (ref<>EM2RS.Modbus.Poll.ref) then Trouble(GotBug('Bad reply device '+RefInfo(ref,'Name'))) else
  if (modbus_un_except(fid)<>EM2RS.Modbus.Poll.fid) then Trouble(GotBug('Bad reply fid '+Str(fid))) else begin
   saddr:=EM2RS.Modbus.Poll.saddr; quant:=EM2RS.Modbus.Poll.quant;
   if modbus_decode_pdu('A',fid,dat,saddr,quant,raw)>0 then begin
    if (saddr<>EM2RS.Modbus.Poll.saddr) then Trouble(GotBug('Bad reply saddr '+Str(saddr))) else
    if (quant<>EM2RS.Modbus.Poll.quant) then Trouble(GotBug('Bad reply quant '+Str(quant))) else
    if modbus_is_except(fid) then begin
     Problem(GotBug('MODBUS EXCEPTION '+Str(modbus_ext_byte(raw,0))+' ON COMMAND '+Str(cid)));
    end else begin
     IncSummRate(EM2RS.Modbus.Poll.Summ.Rx,EM2RS.Modbus.Poll.Rate.Rx);
     EM2RS_OnCommand(cid,fid,saddr,quant,raw);
    end;
   end else Trouble(GotBug('Bad PDU format '+modbus_errmsg(modbus_errno)));
  end;
  Cleanup;
 end;
 //
 // Data handler on @Modbus.Poll event.
 // This procedure calls in simulation mode only.
 //
 procedure EM2RS_OnSimPoll(ref,cid,tim,port,uid,fid:Integer; dat:String);
 var raw:String; saddr,quant:Integer;
  procedure Cleanup;
  begin
   raw:=''; saddr:=0; quant:=0;
  end;
 begin
  Cleanup;
  if not IsValidCmdNum(cid) then Trouble(GotBug('Bad reply command '+Str(cid))) else
  if (port<>EM2RS.Modbus.Poll.port) then Trouble(GotBug('Bad reply port '+Str(port))) else
  if (uid<>EM2RS.Modbus.Poll.uid) then Trouble(GotBug('Bad reply unit id '+Str(uid))) else
  if (cid<>EM2RS.Modbus.Poll.cid) then Trouble(GotBug('Bad reply command id '+Str(cid))) else
  if (ref<>EM2RS.Modbus.Poll.ref) then Trouble(GotBug('Bad reply device '+RefInfo(ref,'Name'))) else
  if (modbus_un_except(fid)<>EM2RS.Modbus.Poll.fid) then Trouble(GotBug('Bad reply fid '+Str(fid))) else begin
   saddr:=EM2RS.Modbus.Poll.saddr; quant:=EM2RS.Modbus.Poll.quant;
   if modbus_decode_pdu('R',fid,dat,saddr,quant,raw)>0 then begin
    if (saddr<>EM2RS.Modbus.Poll.saddr) then Trouble(GotBug('Bad reply saddr '+Str(saddr))) else
    if (quant<>EM2RS.Modbus.Poll.quant) then Trouble(GotBug('Bad reply quant '+Str(quant))) else begin
     if DebugFlagEnabled(dfDetails) then Details('Simulate polling '+Str(cid));
     if (cid=cm_ReadGroup1) then begin
      raw:=modbus_dump_int16(EM2RS.SIM.PULSE,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.CTRLMODE,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.MOTDIRECT,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.POSERROR,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.FORCED,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_ReadGroup2) then begin
      raw:=modbus_dump_int16(EM2RS.SIM.POSLOOPKP,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.VELLOOPKI,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.VELLOOPKP,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.POSLOOPKPH,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_ReadGroup3) then begin
      raw:=modbus_dump_int16(EM2RS.SIM.CMDTIME,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.VELOTOC,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.VELCTOO,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.DELAYOTOC,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.DELAYCTOO,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_ReadGroup4) then begin
      raw:=modbus_dump_int16(EM2RS.SIM.CFGINPUT1,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.CFGINPUT2,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.CFGINPUT3,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.CFGINPUT4,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.CFGINPUT5,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.CFGINPUT6,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.CFGINPUT7,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.CFGOUTPUT1,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.CFGOUTPUT2,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.CFGOUTPUT3,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_ReadGroup5) then begin
      raw:=modbus_dump_int16(round(EM2RS.SIM.ALRMDETECT),SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.DIST2SEND,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.BUSVOLT,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.DISTATUS,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.DOSTATUS,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(round(EM2RS.SIM.PEAKCUR),SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(round(EM2RS.SIM.HOLDINCLSD),SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(round(EM2RS.SIM.HOLDINOPEN),SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_ReadGroup6) then begin
      raw:=modbus_dump_int16(EM2RS.SIM.BAUDRATE,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.ADDRESS,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.RS485TYPE,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.STBCURPER,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.JOGVEL,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.JOGINTER,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.JOGRUNTIME,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.JOGACCDEC,SwapModeInt32);
       dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
       DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_ReadGroup7) then begin
      raw:=modbus_dump_int16(EM2RS.SIM.SOFTWARE,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.FIRMWARE,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_ReadGroup8) then begin
      raw:=modbus_dump_int16(EM2RS.SIM.ENCODERES,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_ReadGroup9) then begin
       raw:=modbus_dump_int16(EM2RS.SIM.MOTSTATUS,SwapModeInt32)
        +modbus_dump_int16(0,SwapModeInt32);
       dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
       DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_ReadGroup10) then begin
      raw:=modbus_dump_int16(EM2RS.SIM.SAVEWORD,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_ReadGroup11) then begin
      raw:=modbus_dump_int16(EM2RS.SIM.CURALARM,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_ReadGroup12) then begin
      raw:=modbus_dump_int16(EM2RS.SIM.PRCONTROL,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.TRIGGER,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int32(EM2RS.SIM.SOFTLIMPOS,SwapModeInt32)
          +modbus_dump_int32(EM2RS.SIM.SOFTLIMNEG,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.HOMINGMODE,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int32(EM2RS.SIM.AFTERHOMING,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.HOMHIGHVEL,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.HOMLOWVEL,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.HOMINGACC,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.HOMINGDEC,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.LIMSTOPTIME,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.ESTOPTIME,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int16(0,SwapModeInt32)
          +modbus_dump_int32(0,SwapModeInt32)
          +modbus_dump_int32(EM2RS.SIM.ACTPOS,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_ReadGroup13) then begin
      raw:=modbus_dump_int16(EM2RS.SIM.MOTPATH0,SwapModeInt32)
          +modbus_dump_int32(EM2RS.SIM.POSITION,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.SPEED,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.ACCELERAT,SwapModeInt32)
          +modbus_dump_int16(EM2RS.SIM.DECCELERAT,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,raw);
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritPulse) then begin
      EM2RS.SIM.PULSE:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritCtrlMode) then begin
      EM2RS.SIM.CTRLMODE:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritMotDirect) then begin
      EM2RS.SIM.MOTDIRECT:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritPosError) then begin
      EM2RS.SIM.POSERROR:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritForced) then begin
      EM2RS.SIM.FORCED:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritPosLoopKp) then begin
      EM2RS.SIM.POSLOOPKP:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritVelLoopKi) then begin
      EM2RS.SIM.VELLOOPKI:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritVelLoopKp) then begin
      EM2RS.SIM.VELLOOPKP:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritPosLoopKph) then begin
      EM2RS.SIM.POSLOOPKPH:=modbus_ext_int16(raw,0,SwapModeInt32);;
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritCmdTime) then begin
      EM2RS.SIM.CMDTIME:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritVelOtoC) then begin
      EM2RS.SIM.VELOTOC:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritVelCtoO) then begin
      EM2RS.SIM.VELCTOO:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritDelayOtoC) then begin
      EM2RS.SIM.DELAYOTOC:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritDelayCtoO) then begin
      EM2RS.SIM.DELAYCTOO:=modbus_ext_int16(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritCfgInput1) then begin
      EM2RS.SIM.CFGINPUT1:=modbus_ext_int16(raw,0,SwapModeInt32);
      EM2RS.SIM.DISTATUS:=iSetBit(EM2RS.SIM.DISTATUS,0,iGetBit(EM2RS.SIM.CFGINPUT1,7));
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritCfgInput2) then begin
      EM2RS.SIM.CFGINPUT2:=modbus_ext_int16(raw,0,SwapModeInt32);
      EM2RS.SIM.DISTATUS:=iSetBit(EM2RS.SIM.DISTATUS,1,iGetBit(EM2RS.SIM.CFGINPUT2,7));
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritCfgInput3) then begin
      EM2RS.SIM.CFGINPUT3:=modbus_ext_int16(raw,0,SwapModeFloat);
      EM2RS.SIM.DISTATUS:=iSetBit(EM2RS.SIM.DISTATUS,2,iGetBit(EM2RS.SIM.CFGINPUT3,7));
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritCfgInput4) then begin
      EM2RS.SIM.CFGINPUT4:=modbus_ext_int16(raw,0,SwapModeFloat);
      EM2RS.SIM.DISTATUS:=iSetBit(EM2RS.SIM.DISTATUS,3,iGetBit(EM2RS.SIM.CFGINPUT4,7));
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritCfgInput5) then begin
      EM2RS.SIM.CFGINPUT5:=modbus_ext_int16(raw,0,SwapModeFloat);
      EM2RS.SIM.DISTATUS:=iSetBit(EM2RS.SIM.DISTATUS,4,iGetBit(EM2RS.SIM.CFGINPUT5,7));
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritCfgInput6) then begin
      EM2RS.SIM.CFGINPUT6:=modbus_ext_int16(raw,0,SwapModeFloat);
      EM2RS.SIM.DISTATUS:=iSetBit(EM2RS.SIM.DISTATUS,5,iGetBit(EM2RS.SIM.CFGINPUT6,7));
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritCfgInput7) then begin
      EM2RS.SIM.CFGINPUT7:=modbus_ext_int16(raw,0,SwapModeFloat);
      EM2RS.SIM.DISTATUS:=iSetBit(EM2RS.SIM.DISTATUS,6,iGetBit(EM2RS.SIM.CFGINPUT7,7));
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritCfgOutput1) then begin
      EM2RS.SIM.CFGOUTPUT1:=modbus_ext_int16(raw,0,SwapModeFloat);
      EM2RS.SIM.DOSTATUS:=iSetBit(EM2RS.SIM.DOSTATUS,0,iGetBit(EM2RS.SIM.CFGOUTPUT1,7));
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritCfgOutput2) then begin
      EM2RS.SIM.CFGOUTPUT2:=modbus_ext_int16(raw,0,SwapModeFloat);
      EM2RS.SIM.DOSTATUS:=iSetBit(EM2RS.SIM.DOSTATUS,1,iGetBit(EM2RS.SIM.CFGOUTPUT2,7));
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritCfgOutput3) then begin
      EM2RS.SIM.CFGOUTPUT3:=modbus_ext_int16(raw,0,SwapModeFloat);
      EM2RS.SIM.DOSTATUS:=iSetBit(EM2RS.SIM.DOSTATUS,2,iGetBit(EM2RS.SIM.CFGOUTPUT3,7));
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritAlrmDetect) then begin
      EM2RS.SIM.ALRMDETECT:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritDist2Send) then begin
      EM2RS.SIM.DIST2SEND:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritBusVolt) then begin
      EM2RS.SIM.BUSVOLT:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritPeakCur) then begin
      EM2RS.SIM.PEAKCUR:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritHoldInClsd) then begin
      EM2RS.SIM.HOLDINCLSD:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritHoldInOpen) then begin
      EM2RS.SIM.HOLDINOPEN:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritStbCurPer) then begin
      EM2RS.SIM.STBCURPER:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritJOGvel) then begin
      EM2RS.SIM.JOGVEL:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritJOGinter) then begin
      EM2RS.SIM.JOGINTER:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritJOGruntime) then begin
      EM2RS.SIM.JOGRUNTIME:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritJOGaccDec) then begin
      EM2RS.SIM.JOGACCDEC:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritEncodeRes) then begin
      EM2RS.SIM.ENCODERES:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritCtrlWord) then begin
      EM2RS.SIM.CTRLWORD:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritPRcontrol) then begin
      EM2RS.SIM.PRCONTROL:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritTrigger) then begin
      EM2RS.SIM.TRIGGER:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritSoftLimPos) then begin
      EM2RS.SIM.SOFTLIMPOS:=modbus_ext_int32(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritSoftLimNeg) then begin
      EM2RS.SIM.SOFTLIMNEG:=modbus_ext_int32(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritAfterHoming) then begin
      EM2RS.SIM.AFTERHOMING:=modbus_ext_int32(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritHomingMode) then begin
      EM2RS.SIM.HOMINGMODE:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritHomHighVel) then begin
      EM2RS.SIM.HOMHIGHVEL:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritHomLowVel) then begin
      EM2RS.SIM.HOMLOWVEL:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritHomingAcc) then begin
      EM2RS.SIM.HOMINGACC:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritHomingDec) then begin
      EM2RS.SIM.HOMINGDEC:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritLimStopTime) then begin
      EM2RS.SIM.LIMSTOPTIME:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritEStopTime) then begin
      EM2RS.SIM.ESTOPTIME:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritMotPath0) then begin
      EM2RS.SIM.MOTPATH0:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritPosition) then begin
      EM2RS.SIM.POSITION:=modbus_ext_int32(raw,0,SwapModeInt32);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritSpeed) then begin
      EM2RS.SIM.SPEED:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritAccel) then begin
      EM2RS.SIM.ACCELERAT:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else if (cid=cm_WritDeccel) then begin
      EM2RS.SIM.DECCELERAT:=modbus_ext_int16(raw,0,SwapModeFloat);
      dat:=modbus_encode_pdu('A',fid,saddr,quant,'');
      DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,fid,dat));
     end else DevPostCmdLocal(modbus_proxy_poll('@Modbus.Reply',devMySelf,cid,0,port,uid,
              modbus_as_except(fid,true),Dump(Chr(modbus_er_ILLFUN))));
    end;
   end else Trouble(GotBug('Bad PDU format '+modbus_errmsg(modbus_errno)));
  end;
  Cleanup;
 end;
 //
 // EM2RS Driver Simulator mode polling.
 // This procedure calls in simulation mode only.
 //
 procedure EM2RS_SIM_POLL;
  procedure EM2RSMovSim;
  var step:integer;
  begin
   if EM2RS.SIM.STEPCOUNT>0 then begin
    EM2RS.SIM.MOTSTATUS:=iSetBitState(EM2RS.SIM.MOTSTATUS,bit_StatusRunning,true);
    EM2RS.SIM.MOTSTATUS:=iSetBitState(EM2RS.SIM.MOTSTATUS,bit_StatusCommand,false);
    EM2RS.SIM.MOTSTATUS:=iSetBitState(EM2RS.SIM.MOTSTATUS,bit_StatusPath,false);
    step:=round(abs(GetSimValue(EM2RS.SIM.SPEED))*GetSimValue(EM2RS.SIM.PULSE)/(60*8)); // steps in 1/8 sec
    EM2RS.SIM.TRIGGER:=st_RUNNING;
    if mSecNow>=EM2RS.SIM.TimeOut+(1000/8) then begin // Every 1/8 sec
     if EM2RS.SIM.DIRECTION=1 then EM2RS.SIM.ACTPOS:=EM2RS.SIM.ACTPOS+step
     else if EM2RS.SIM.DIRECTION=0 then EM2RS.SIM.ACTPOS:=EM2RS.SIM.ACTPOS-step;
     if EM2RS.SIM.STEPCOUNT<>999999 then EM2RS.SIM.STEPCOUNT:=EM2RS.SIM.STEPCOUNT-step;
     if ((iGetTag(EM2RS.NEGLIMIT.tag)=1) and (EM2RS.SIM.DIRECTION=0)) then EM2RS.SIM.STEPCOUNT:=0;
     if ((iGetTag(EM2RS.POSLIMIT.tag)=1) and (EM2RS.SIM.DIRECTION=1)) then EM2RS.SIM.STEPCOUNT:=0;
     EM2RS.SIM.TimeOut:=mSecNow;
    end;
   end else begin
    EM2RS.SIM.MOTSTATUS:=iSetBitState(EM2RS.SIM.MOTSTATUS,bit_StatusRunning,false);
    EM2RS.SIM.MOTSTATUS:=iSetBitState(EM2RS.SIM.MOTSTATUS,bit_StatusCommand,true);
    EM2RS.SIM.MOTSTATUS:=iSetBitState(EM2RS.SIM.MOTSTATUS,bit_StatusPath,true);
    EM2RS.SIM.TRIGGER:=0;
   end;
  end;
 begin
  if EM2RS.Simulator then begin
   if EM2RS.SIM.TRIGGER=st_POSITIONING then begin
    if GetSimValue(EM2RS.SIM.MOTPATH0)=mode_Speed then begin
     if (GetSimValue(EM2RS.SIM.SPEED)<0) then EM2RS.SIM.DIRECTION:=0;
     if (GetSimValue(EM2RS.SIM.SPEED)>0) then EM2RS.SIM.DIRECTION:=1;
     EM2RS.SIM.STEPCOUNT:=999999;
    end else if GetSimValue(EM2RS.SIM.MOTPATH0)=mode_Absolute then begin
     if (GetSimValue(EM2RS.SIM.POSITION)<EM2RS.SIM.ACTPOS) then EM2RS.SIM.DIRECTION:=0;
     if (GetSimValue(EM2RS.SIM.POSITION)>EM2RS.SIM.ACTPOS) then EM2RS.SIM.DIRECTION:=1;
     EM2RS.SIM.STEPCOUNT:=abs(EM2RS.SIM.ACTPOS-EM2RS.SIM.POSITION); //EM2RS.SIM.ACTPOS
    end else if GetSimValue(EM2RS.SIM.MOTPATH0)=mode_Relative then begin
     if (GetSimValue(EM2RS.SIM.POSITION)<0) then EM2RS.SIM.DIRECTION:=0;
     if (GetSimValue(EM2RS.SIM.POSITION)>0) then EM2RS.SIM.DIRECTION:=1;
     EM2RS.SIM.STEPCOUNT:=abs(EM2RS.SIM.POSITION);
    end;
   end;
   if EM2RS.SIM.TRIGGER=st_RESET then begin
    EM2RS.SIM.STEPCOUNT:=0;
    EM2RS.SIM.ACTPOS:=0;
   end;
   if EM2RS.SIM.TRIGGER=st_STOP then begin
    EM2RS.SIM.STEPCOUNT:=0;
   end;
   EM2RSMovSim;
  end;
 end;
 //
 // Send to console command (cmd data) to set new tag value if one in range (min,max).
 //
 procedure SendTagCmd(tag:Integer; cmd,data:String; min,max:Real);
 var v:Real;
 begin
  if IsRefTag(tag) then
  if not IsEmptyStr(cmd) then
  if not IsEmptyStr(data) then
  if TypeTag(tag)<=2 then begin
   v:=rVal(data);
   if (v<min) then begin v:=min; data:=Str(min); end;
   if (v>max) then begin v:=max; data:=Str(max); end;
   if IsNaN(v) then Trouble(GotBug('Invalid tag edit')) else
   if TypeTag(tag)=1 then DevPostCmdLocal(cmd+' '+Str(Round(v))) else
   if TypeTag(tag)=2 then DevPostCmdLocal(cmd+' '+Trim(data));
  end else if TypeTag(tag)=3 then begin
   DevPostCmdLocal(cmd+' '+Trim(data));
  end;
 end;
 //
 // Send command (cmd) to console on tag click.
 //
 procedure SendClickTagCmd(tag:Integer; cmd,s:String);
 begin
  if Length(cmd)>0 then
  if IsRefTag(tag) then
  if ClickTag=tag then DevPostCmdLocal(cmd+' '+s);
 end;
 {
 Get limiters
 }
 procedure GetLimiters;
 var i,CfgInput,DiStatus:integer;
  procedure Cleanup;
  begin
   CfgInput:=0; DiStatus:=0;
  end;
 begin
  Cleanup;
  for i:=1 to 7 do begin
   CfgInput:=iGetTag(findtag(tagPrefix+'.CFGINPUT'+str(i)));
   DiStatus:=iGetBit(iGetTag(EM2RS.PARAM.DISTATUS.tag),i-1);
   if ((CfgInput=37) or (CfgInput=165)) then bNul(iSetTag(EM2RS.POSLIMIT.tag,DiStatus)); // Positive Limit {37, 165 (+0x80 inversed)}
   if ((CfgInput=38) or (CfgInput=166)) then bNul(iSetTag(EM2RS.NEGLIMIT.tag,DiStatus)); // Negative Limit {38, 166 (+0x80 inversed)}
  end;
  Cleanup;
 end;
 {
 Logical control.
 }
 procedure GUIControl;
  //
  // Check setpoint after TimeOut
  //
  procedure GUIModeChck;
   procedure HideGUIArrows;
   begin
    bNul(iSetTagBitState(EM2RS.DIRECTBWD.tag,bit_Hide,true));
    bNul(iSetTagBitState(EM2RS.DIRECTFWD.tag,bit_Hide,true));
    bNul(iSetTagBitState(EM2RS.MOVE.tag,bit_Hide,false));
   end;
   procedure ShowGUIArrows;
   begin
    bNul(iSetTagBitState(EM2RS.DIRECTBWD.tag,bit_Hide,false));
    bNul(iSetTagBitState(EM2RS.DIRECTFWD.tag,bit_Hide,false));
    bNul(iSetTagBitState(EM2RS.MOVE.tag,bit_Hide,true));
   end;
  begin
   if iGetTag(EM2RS.PARAM.MOTPATH0.tag)=mode_Init  then HideGUIArrows else if
   IsModeAbsolute then HideGUIArrows else if
   IsModeSpeed    then ShowGUIArrows else if
   iGetTag(EM2RS.PARAM.MOTPATH0.tag)=3             then ShowGUIArrows else if // ?? mode
   IsModeRelative then ShowGUIArrows;
  end;
  //
  // Check status is Running
  //
  procedure GUIRunningChck;
  begin
   if not IsRunning then begin
    bNul(iSetTagBitState(EM2RS.DIRECTBWD.tag,bit_En,false));
    bNul(iSetTagBitState(EM2RS.DIRECTFWD.tag,bit_En,false));
    bNul(iSetTagBitState(EM2RS.MOVE.tag,bit_En,false));
   end else begin
    if localSpeed>0 then begin
     bNul(iSetTagBitState(EM2RS.DIRECTFWD.tag,bit_En,true));
     bNul(iSetTagBitState(EM2RS.DIRECTBWD.tag,bit_En,false));
     bNul(iSetTagBitState(EM2RS.MOVE.tag,bit_En,true))
    end else if localSpeed<0 then begin
     bNul(iSetTagBitState(EM2RS.DIRECTBWD.tag,bit_En,true));
     bNul(iSetTagBitState(EM2RS.DIRECTFWD.tag,bit_En,false));
     bNul(iSetTagBitState(EM2RS.MOVE.tag,bit_En,true));
    end;
   end;
  end;
  //
  // Check motor is stopped (but status Running)
  //
  procedure GUIStoppedChck;
  begin
   if isBit(iGetTag(EM2RS.PARAM.MOTSTATUS.tag),bit_StatusPath) then begin
   // Нужно проверять что шагов не прибавилось
    bNul(iSetTagBitState(EM2RS.DIRECTBWD.tag,bit_En,false));
    bNul(iSetTagBitState(EM2RS.DIRECTFWD.tag,bit_En,false));
    bNul(iSetTagBitState(EM2RS.MOVE.tag,bit_En,false));
   end;
   if (not IsRunning and (iGetTagBitState(EM2RS.POSLIMIT.tag,0) OR (iGetTagBitState(EM2RS.NEGLIMIT.tag,0)))) then bNul(iSetTagBitState(EM2RS.MOVE.tag,bit_En,false));
   // Running & позиция не меняется
   if (IsRunning and (iGetTag(EM2RS.PARAM.SPEED.tag)=0)) then begin
    if prevActPosition=iGetTag(EM2RS.PARAM.ACTPOS.tag) then begin
     DevPostCmdLocal('@ESTOP');
     DevPostCmdLocal('@PARAM SPEED '+str(prevSpeed));
    end;
   end;
  end;
  //
  // Check Limiters Status
  //
  procedure GUILimitersChck;
  begin
   bNul(iSetTagBitState(EM2RS.DIRECTBWD.tag,bit_Lim,iGetTagBitState(EM2RS.NEGLIMIT.tag,0)));
   bNul(iSetTagBitState(EM2RS.DIRECTFWD.tag,bit_Lim,iGetTagBitState(EM2RS.POSLIMIT.tag,0)));
  end;
  //
  // Преобразование требуемая позиция: шаги --> mm
  //
  procedure GUIDestinationControl;
  var DeviceDestination,nextPosMM,nextPosStep:real;
  begin
   if not IsRunning then begin
    DeviceDestination:=calibr(0,iGetTag(EM2RS.PARAM.POSITION.tag)+iGetTag(EM2RS.PARAM.ACTPOS.tag),0)-calibr(0,iGetTag(EM2RS.PARAM.ACTPOS.tag),0);
    if (round(DeviceDestination*100)/100)<>(round(rGetTag(EM2RS.DESTINATION.tag)*100)/100) then begin
     if IsModeAbsolute then nextPosMM:=rGetTag(EM2RS.DESTINATION.tag);
     if IsModeRelative then nextPosMM:=rGetTag(EM2RS.POSITION.tag)+rGetTag(EM2RS.DESTINATION.tag);
     nextPosStep:=invCalibr(0,nextPosMM,0, -invCalibrLimit, invCalibrLimit);
     if isNan(nextPosStep) then begin
      Problem('invCalibr out of limit ERROR!');
      ShowTooltip('text "Достигнут лимит калибровки (см. документацию)." delay 15000 preset stdWarning');
     end;
     if IsModeAbsolute then if not DIM_IsClientMode then DevPostCmdLocal('@PARAM POSITION '+str(nextPosStep));
     if IsModeRelative then if not DIM_IsClientMode then DevPostCmdLocal('@PARAM POSITION '+str(nextPosStep-iGetTag(EM2RS.PARAM.ACTPOS.tag)));
    end;
   end;
  end;
  //
  // Проверка бита ошикбки & вывод оповещений
  //
  procedure GUIFaultControl;
  var DeviceDestination,nextPosMM,nextPosStep:real;
  begin
   if IsFault then begin
    Problem('New status: Device fault!');
    ShowTooltip('text "Ошибка устройства!" delay 15000 preset stdError');
   end;
  end;
 begin
  GUIModeChck;
  GUIRunningChck;
  GUIStoppedChck;
  GUILimitersChck;
  GUIDestinationControl;
  GUIFaultControl;
 end;
 {
 GUI Handler to process user input...
 }
 procedure GUIHandler;
 var ClickCurve:Integer; s:String;
  procedure Cleanup;
  begin
   DIM_GuiClickBuff:=''; s:=''; ClickCurve:=0;
  end;
 begin
  Cleanup;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Copy GUI click to DIM buffer for remote execution.
   }
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Handle local clicks
     }
     if ClickIsLocal then begin
      {
      Handle Tag clicks...
      }
      if ClickTag<>0 then begin
       ClickTagXorRemote(EM2RS.POLL.ENABLE.tag,1);
       if ClickTag=EM2RS.PARAM.CTRLMODE.tag   then DevPostCmdLocal(DimRemote+'@PARAM CTRLMODE '+str(ixor(iGetTag(EM2RS.PARAM.CTRLMODE.tag),2)));
       if ClickTag=EM2RS.PARAM.CTRLWORD.tag   then MenuCtrlWordStarter;
       if ClickTag=EM2RS.PARAM.TRIGGER.tag    then MenuTriggerStarter;
       if ClickTag=EM2RS.PARAM.MOTPATH0.tag   then MenuMotPath0Starter;
       if ClickTag=EM2RS.MOVE.tag             then DevPostCmdLocal(DimRemote+'@MOVE');
       if ClickTag=EM2RS.DIRECTBWD.tag        then DevPostCmdLocal(DimRemote+'@MOVE BACKWARD');
       if ClickTag=EM2RS.DIRECTFWD.tag        then DevPostCmdLocal(DimRemote+'@MOVE');
       if ClickTag=EM2RS.ESTOP.tag            then DevPostCmdLocal(DimRemote+'@ESTOP');
       if ClickTag=EM2RS.HOMING.tag           then DevPostCmdLocal(DimRemote+'@PARAM TRIGGER 32');
       if ClickTag=EM2RS.SETZERO.tag          then DevPostCmdLocal(DimRemote+'@PARAM TRIGGER 33');
       if ClickTag=EM2RS.PARAM.CFGINPUT1.tag  then MenuInputConfiguration(1);
       if ClickTag=EM2RS.PARAM.CFGINPUT2.tag  then MenuInputConfiguration(2);
       if ClickTag=EM2RS.PARAM.CFGINPUT3.tag  then MenuInputConfiguration(3);
       if ClickTag=EM2RS.PARAM.CFGINPUT4.tag  then MenuInputConfiguration(4);
       if ClickTag=EM2RS.PARAM.CFGINPUT5.tag  then MenuInputConfiguration(5);
       if ClickTag=EM2RS.PARAM.CFGINPUT6.tag  then MenuInputConfiguration(6);
       if ClickTag=EM2RS.PARAM.CFGINPUT7.tag  then MenuInputConfiguration(7);
       if ClickTag=EM2RS.PARAM.CFGOUTPUT1.tag then MenuOutputConfiguration(1);
       if ClickTag=EM2RS.PARAM.CFGOUTPUT2.tag then MenuOutputConfiguration(2);
       if ClickTag=EM2RS.PARAM.CFGOUTPUT3.tag then MenuOutputConfiguration(3);
       //
       // Send command to edit on Click.
       //
       s:=mime_encode(SetFormUnderSensorLeftBottom(ClickParams('')));
       SendClickTagCmd(EM2RS.PARAM.PULSE.tag,       '@Edit PARAM.PULSE',       s); // $0001 Pulse/Revolution
       { SendClickTagCmd(EM2RS.PARAM.CTRLMODE.tag,    '@Edit PARAM.CTRLMODE',    s); // $0003 Control Mode (CS2RS) }
       SendClickTagCmd(EM2RS.PARAM.POSERROR.tag,    '@Edit PARAM.POSERROR',    s); // $000B Allowed max position following error (CS2RS)
       SendClickTagCmd(EM2RS.PARAM.POSLOOPKP.tag,   '@Edit PARAM.POSLOOPKP',   s); // $0051 Position loop Kp (CS2RS)
       SendClickTagCmd(EM2RS.PARAM.VELLOOPKI.tag,   '@Edit PARAM.VELLOOPKI',   s); // $0053 Velocity loop Ki  (CS2RS)
       SendClickTagCmd(EM2RS.PARAM.VELLOOPKP.tag,   '@Edit PARAM.VELLOOPKP',   s); // $0055 Velocity loop Kp  (CS2RS)
       SendClickTagCmd(EM2RS.PARAM.POSLOOPKPH.tag,  '@Edit PARAM.POSLOOPKPH',  s); // $0065 Position loop KpH (CS2RS)
       SendClickTagCmd(EM2RS.PARAM.CMDTIME.tag,     '@Edit PARAM.CMDTIME',     s); // $00A1 Command filter time *
       SendClickTagCmd(EM2RS.PARAM.VELOTOC.tag,     '@Edit PARAM.VELOTOC',     s); // $00A3 Vel swtch pnt: O to C loop *
       SendClickTagCmd(EM2RS.PARAM.VELCTOO.tag,     '@Edit PARAM.VELCTOO',     s); // $00A5 Vel swtch pnt: C to O loop *
       SendClickTagCmd(EM2RS.PARAM.DELAYOTOC.tag,   '@Edit PARAM.DELAYOTOC',   s); // $00A7 Delay of O to C loop *
       SendClickTagCmd(EM2RS.PARAM.DELAYCTOO.tag,   '@Edit PARAM.DELAYCTOO',   s); // $00A9 Delay of C to O loop *
       SendClickTagCmd(EM2RS.PARAM.BUSVOLT.tag,     '@Edit PARAM.BUSVOLT',     s); // $0177 Bus Voltage
       SendClickTagCmd(EM2RS.PARAM.PEAKCUR.tag,     '@Edit PARAM.PEAKCUR',     s); // $0191 Peak Current
       SendClickTagCmd(EM2RS.PARAM.HOLDINCLSD.tag,  '@Edit PARAM.HOLDINCLSD',  s); // $0193 % of hold curr in closed-loop
       SendClickTagCmd(EM2RS.PARAM.HOLDINOPEN.tag,  '@Edit PARAM.HOLDINOPEN',  s); // $0195 % of hold curr in open-loop
       SendClickTagCmd(EM2RS.PARAM.STBCURPER.tag,   '@Edit PARAM.STBCURPER',   s); // $01D3 Standby Current Percentage
       SendClickTagCmd(EM2RS.PARAM.JOGVEL.tag,      '@Edit PARAM.JOGVEL',      s); // $01E1 JOG Velocity
       SendClickTagCmd(EM2RS.PARAM.JOGINTER.tag,    '@Edit PARAM.JOGINTER',    s); // $01E3 Interval
       SendClickTagCmd(EM2RS.PARAM.JOGRUNTIME.tag,  '@Edit PARAM.JOGRUNTIME',  s); // $01E5 Running times
       SendClickTagCmd(EM2RS.PARAM.JOGACCDEC.tag,   '@Edit PARAM.JOGACCDEC',   s); // $01E7 Acc/Dec. time
       SendClickTagCmd(EM2RS.PARAM.ENCODERES.tag,   '@Edit PARAM.ENCODERES',   s); // $0233 Encoder resolution
       SendClickTagCmd(EM2RS.PARAM.AFTERHOMING.tag, '@Edit PARAM.AFTERHOMING', s); // $600D+$600E Move to specified location after homing
       SendClickTagCmd(EM2RS.PARAM.SOFTLIMPOS.tag,  '@Edit PARAM.SOFTLIMPOS',  s); // $6006+$6007 Software limit positive
       SendClickTagCmd(EM2RS.PARAM.SOFTLIMNEG.tag,  '@Edit PARAM.SOFTLIMNEG',  s); // $6008+$6009 Software limit negative
       SendClickTagCmd(EM2RS.PARAM.HOMHIGHVEL.tag,  '@Edit PARAM.HOMHIGHVEL',  s); // $600F Homing hight velocity
       SendClickTagCmd(EM2RS.PARAM.HOMLOWVEL.tag,   '@Edit PARAM.HOMLOWVEL',   s); // $6010 Homing low velocity
       SendClickTagCmd(EM2RS.PARAM.HOMINGACC.tag,   '@Edit PARAM.HOMINGACC',   s); // $6011 Homing Acc
       SendClickTagCmd(EM2RS.PARAM.HOMINGDEC.tag,   '@Edit PARAM.HOMINGDEC',   s); // $6012 Homing Dec
       SendClickTagCmd(EM2RS.PARAM.LIMSTOPTIME.tag, '@Edit PARAM.LIMSTOPTIME', s); // $6016 Limit stop time
       SendClickTagCmd(EM2RS.PARAM.ESTOPTIME.tag,   '@Edit PARAM.ESTOPTIME',   s); // $6017 E-STOP time
       SendClickTagCmd(EM2RS.PARAM.POSITION.tag,    '@Edit PARAM.POSITION',    s); // $6201+$6202 Position
       SendClickTagCmd(EM2RS.PARAM.SPEED.tag,       '@Edit PARAM.SPEED',       s); // $6203 Velocity
       SendClickTagCmd(EM2RS.PARAM.ACCELERAT.tag,   '@Edit PARAM.ACCELERAT',   s); // $6204 Acc
       SendClickTagCmd(EM2RS.PARAM.DECCELERAT.tag,  '@Edit PARAM.DECCELERAT',  s); // $6205 Dec
       SendClickTagCmd(EM2RS.SPEED.tag,             '@Edit SPEED',             s); // GUI Speed in mm
       SendClickTagCmd(EM2RS.DESTINATION.tag,       '@Edit DESTINATION',       s); // GUI Destination in mm
      end;
      {
      Handle sensor clicks...
      }
      if ClickSensor<>'' then begin
       bNul(Voice(snd_Click));
       if ClickSensor='EM2RS.TOOLS'               then MenuToolsStarter;
       if ClickSensor='EM2RS.HELP'                then DevPostCmdLocal('@BrowseHelp');
       if ClickSensor='EM2RS.PARAMS'              then if not IsEmptyStr(Copy(DevName,2,Length(DevName))) then DevPostCmdLocal('@WinSelect '+StringReplace(Copy(DevName,2,Length(DevName)),'DRV','PARAM',rfignorecase));
       if ClickSensor='EM2RS.PAR.HOMINGMODE'      then MenuHomingModeStarter;
       if ClickSensor='EM2RS.PAR.MOTDIRECT'       then DevPostCmdLocal(DimRemote+'@PARAM MOTDIRECT '+str(bitxor(igettag(EM2RS.PARAM.MOTDIRECT.tag),1)));
       if ClickSensor='EM2RS.PAR.FORCED'          then DevPostCmdLocal(DimRemote+'@PARAM FORCED '+str(bitxor(igettag(EM2RS.PARAM.FORCED.tag),1)));
       if ClickSensor='EM2RS.PAR.AFTERHOMING.ENB' then DevPostCmdLocal(DimRemote+'@PARAM HOMINGMODE '+str(bitxor(igettag(EM2RS.PARAM.HOMINGMODE.tag),2)));
       if ClickSensor='EM2RS.PAR.HOMINGDIR'       then DevPostCmdLocal(DimRemote+'@PARAM HOMINGMODE '+str(bitxor(igettag(EM2RS.PARAM.HOMINGMODE.tag),1)));
       if ClickSensor='EM2RS.PAR.SOFTLIM.ENB'     then DevPostCmdLocal(DimRemote+'@PARAM PRCONTROL '+str(bitxor(igettag(EM2RS.PARAM.PRCONTROL.tag),2)));
       if ClickSensor='EM2RS.PAR.HOMINGONSTART'   then DevPostCmdLocal(DimRemote+'@PARAM PRCONTROL '+str(bitxor(igettag(EM2RS.PARAM.PRCONTROL.tag),4)));
       if ClickSensor='EM2RS.PAR.PRSTART'         then DevPostCmdLocal(DimRemote+'@MOVE');
       if ClickSensor='EM2RS.PAR.PRHOME'          then DevPostCmdLocal(DimRemote+'@PARAM TRIGGER 32');
       if ClickSensor='EM2RS.PAR.PRESTOP'         then DevPostCmdLocal(DimRemote+'@PARAM TRIGGER 64');
       if ClickSensor='EM2RS.PAR.PRSETBY0'        then DevPostCmdLocal(DimRemote+'@PARAM TRIGGER 33');
       if ClickSensor='EM2RS.PAR.JOGCW'           then DevPostCmdLocal(DimRemote+'@PARAM CTRLWORD 16385');
       if ClickSensor='EM2RS.PAR.JOGCCW'          then DevPostCmdLocal(DimRemote+'@PARAM CTRLWORD 16386');
       if ClickSensor='EM2RS.PAR.CFGINPUT1.NC'    then DevPostCmdLocal(DimRemote+'@PARAM CFGINPUT1 '+str(ixor(iGetTag(EM2RS.PARAM.CFGINPUT1.tag),128)));
       if ClickSensor='EM2RS.PAR.CFGINPUT2.NC'    then DevPostCmdLocal(DimRemote+'@PARAM CFGINPUT2 '+str(ixor(iGetTag(EM2RS.PARAM.CFGINPUT2.tag),128)));
       if ClickSensor='EM2RS.PAR.CFGINPUT3.NC'    then DevPostCmdLocal(DimRemote+'@PARAM CFGINPUT3 '+str(ixor(iGetTag(EM2RS.PARAM.CFGINPUT3.tag),128)));
       if ClickSensor='EM2RS.PAR.CFGINPUT4.NC'    then DevPostCmdLocal(DimRemote+'@PARAM CFGINPUT4 '+str(ixor(iGetTag(EM2RS.PARAM.CFGINPUT4.tag),128)));
       if ClickSensor='EM2RS.PAR.CFGINPUT5.NC'    then DevPostCmdLocal(DimRemote+'@PARAM CFGINPUT5 '+str(ixor(iGetTag(EM2RS.PARAM.CFGINPUT5.tag),128)));
       if ClickSensor='EM2RS.PAR.CFGINPUT6.NC'    then DevPostCmdLocal(DimRemote+'@PARAM CFGINPUT6 '+str(ixor(iGetTag(EM2RS.PARAM.CFGINPUT6.tag),128)));
       if ClickSensor='EM2RS.PAR.CFGINPUT7.NC'    then DevPostCmdLocal(DimRemote+'@PARAM CFGINPUT7 '+str(ixor(iGetTag(EM2RS.PARAM.CFGINPUT7.tag),128)));
       if ClickSensor='EM2RS.PAR.CFGOUTPUT1.NC'   then DevPostCmdLocal(DimRemote+'@PARAM CFGOUTPUT1 '+str(ixor(iGetTag(EM2RS.PARAM.CFGOUTPUT1.tag),128)));
       if ClickSensor='EM2RS.PAR.CFGOUTPUT2.NC'   then DevPostCmdLocal(DimRemote+'@PARAM CFGOUTPUT2 '+str(ixor(iGetTag(EM2RS.PARAM.CFGOUTPUT2.tag),128)));
       if ClickSensor='EM2RS.PAR.CFGOUTPUT3.NC'   then DevPostCmdLocal(DimRemote+'@PARAM CFGOUTPUT3 '+str(ixor(iGetTag(EM2RS.PARAM.CFGOUTPUT3.tag),128)));
      end;
      {
      Select Plot & Tab windows by curve...
      }
      ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
      if IsRefCurve(ClickCurve) then begin
       iNul(WinSelectByCurve(ClickCurve,ClickCurve));
       bNul(Voice(snd_Wheel));
      end;
      {
      Console commands: @url_encoded_sensor ...
      }
      if LooksLikeCommand(ClickSensor) then begin
       DevPostCmdLocal(url_decode(ClickSensor));
       bNul(Voice(snd_Click));
      end;
     end;
     {
     Handle remote clicks comes from DIM via @DimGuiClick message.
     @DimGuiClick default handler decode and write events to FIFO,
     so we can find it as clicks and can handle it in usual way.
     }
     if ClickIsRemote then begin
      {
      Show time difference.
      }
      if DebugFlagEnabled(dfDetails) then
      Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
      {
      Handle remote console commands...
      }
      s:=Dim_GuiConsoleRecv(DevName,'');
      if LooksLikeCommand(s) then DevSendCmdLocal(s);
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then SensorHelp(Url_Decode(ClickParams('Hint')));
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   //
   // If tag edit complete, send command to apply changes
   //
   if CheckEditTag(EM2RS.PARAM.PULSE.tag,s)       then SendTagCmd(EM2RS.PARAM.PULSE.tag,       DimRemote+'@PARAM PULSE',       s,200,51200); // $0001
   if CheckEditTag(EM2RS.PARAM.CTRLMODE.tag,s)    then SendTagCmd(EM2RS.PARAM.CTRLMODE.tag,    DimRemote+'@PARAM CTRLMODE',    s,0,255); // $0003
   if CheckEditTag(EM2RS.PARAM.POSERROR.tag,s)    then SendTagCmd(EM2RS.PARAM.POSERROR.tag,    DimRemote+'@PARAM POSERROR',    s,0,65535); // $000B
   if CheckEditTag(EM2RS.PARAM.FORCED.tag,s)      then SendTagCmd(EM2RS.PARAM.FORCED.tag,      DimRemote+'@PARAM FORCED',      s,0,1); // $000F
   if CheckEditTag(EM2RS.PARAM.POSLOOPKP.tag,s)   then SendTagCmd(EM2RS.PARAM.POSLOOPKP.tag,   DimRemote+'@PARAM POSLOOPKP',   s,0,3000); // $0051
   if CheckEditTag(EM2RS.PARAM.VELLOOPKI.tag,s)   then SendTagCmd(EM2RS.PARAM.VELLOOPKI.tag,   DimRemote+'@PARAM VELLOOPKI',   s,0,3000); // $0053
   if CheckEditTag(EM2RS.PARAM.VELLOOPKP.tag,s)   then SendTagCmd(EM2RS.PARAM.VELLOOPKP.tag,   DimRemote+'@PARAM VELLOOPKP',   s,0,3000); // $0055
   if CheckEditTag(EM2RS.PARAM.POSLOOPKPH.tag,s)  then SendTagCmd(EM2RS.PARAM.POSLOOPKPH.tag,  DimRemote+'@PARAM POSLOOPKPH',  s,0,3000); // $0065
   if CheckEditTag(EM2RS.PARAM.CMDTIME.tag,s)     then SendTagCmd(EM2RS.PARAM.CMDTIME.tag,     DimRemote+'@PARAM CMDTIME',     s,0,512); // $00A1
   if CheckEditTag(EM2RS.PARAM.VELOTOC.tag,s)     then SendTagCmd(EM2RS.PARAM.VELOTOC.tag,     DimRemote+'@PARAM VELOTOC',     s,0,200); // $00A3
   if CheckEditTag(EM2RS.PARAM.VELCTOO.tag,s)     then SendTagCmd(EM2RS.PARAM.VELCTOO.tag,     DimRemote+'@PARAM VELCTOO',     s,0,200); // $00A5
   if CheckEditTag(EM2RS.PARAM.DELAYOTOC.tag,s)   then SendTagCmd(EM2RS.PARAM.DELAYOTOC.tag,   DimRemote+'@PARAM DELAYOTOC',   s,0,32767); // $00A7
   if CheckEditTag(EM2RS.PARAM.DELAYCTOO.tag,s)   then SendTagCmd(EM2RS.PARAM.DELAYCTOO.tag,   DimRemote+'@PARAM DELAYCTOO',   s,0,32767); // $00A9
   if CheckEditTag(EM2RS.PARAM.BUSVOLT.tag,s)     then SendTagCmd(EM2RS.PARAM.BUSVOLT.tag,     DimRemote+'@PARAM BUSVOLT',     str(rVal(s)*10),0,65535); // $0177
   if CheckEditTag(EM2RS.PARAM.PEAKCUR.tag,s)     then SendTagCmd(EM2RS.PARAM.PEAKCUR.tag,     DimRemote+'@PARAM PEAKCUR',     str(rVal(s)*10),0,56); // $0191
   if CheckEditTag(EM2RS.PARAM.HOLDINCLSD.tag,s)  then SendTagCmd(EM2RS.PARAM.HOLDINCLSD.tag,  DimRemote+'@PARAM HOLDINCLSD',  s,0,100); // $0193
   if CheckEditTag(EM2RS.PARAM.HOLDINOPEN.tag,s)  then SendTagCmd(EM2RS.PARAM.HOLDINOPEN.tag,  DimRemote+'@PARAM HOLDINOPEN',  s,0,100); // $0195
   if CheckEditTag(EM2RS.PARAM.STBCURPER.tag,s)   then SendTagCmd(EM2RS.PARAM.STBCURPER.tag,   DimRemote+'@PARAM STBCURPER',   s,0,100); // $01D3
   if CheckEditTag(EM2RS.PARAM.JOGVEL.tag,s)      then SendTagCmd(EM2RS.PARAM.JOGVEL.tag,      DimRemote+'@PARAM JOGVEL',      s,0,5000); // $01E1
   if CheckEditTag(EM2RS.PARAM.JOGINTER.tag,s)    then SendTagCmd(EM2RS.PARAM.JOGINTER.tag,    DimRemote+'@PARAM JOGINTER',    s,0,10000); // $01E3
   if CheckEditTag(EM2RS.PARAM.JOGRUNTIME.tag,s)  then SendTagCmd(EM2RS.PARAM.JOGRUNTIME.tag,  DimRemote+'@PARAM JOGRUNTIME',  s,0,30000); // $01E5
   if CheckEditTag(EM2RS.PARAM.JOGACCDEC.tag,s)   then SendTagCmd(EM2RS.PARAM.JOGACCDEC.tag,   DimRemote+'@PARAM JOGACCDEC',   s,0,10000); // $01E7
   if CheckEditTag(EM2RS.PARAM.ENCODERES.tag,s)   then SendTagCmd(EM2RS.PARAM.ENCODERES.tag,   DimRemote+'@PARAM ENCODERES',   str(Val(s)*4),0,20000); // $0233
   if CheckEditTag(EM2RS.PARAM.SOFTLIMPOS.tag,s)  then SendTagCmd(EM2RS.PARAM.SOFTLIMPOS.tag,  DimRemote+'@PARAM SOFTLIMPOS',  s,_MinusInf,_PlusInf); // $6006+$6007
   if CheckEditTag(EM2RS.PARAM.SOFTLIMNEG.tag,s)  then SendTagCmd(EM2RS.PARAM.SOFTLIMNEG.tag,  DimRemote+'@PARAM SOFTLIMNEG',  s,_MinusInf,_PlusInf); // $6008+$6009
   if CheckEditTag(EM2RS.PARAM.AFTERHOMING.tag,s) then SendTagCmd(EM2RS.PARAM.AFTERHOMING.tag, DimRemote+'@PARAM AFTERHOMING', s,_MinusInf,_PlusInf); // $600D+$600E
   if CheckEditTag(EM2RS.PARAM.HOMHIGHVEL.tag,s)  then SendTagCmd(EM2RS.PARAM.HOMHIGHVEL.tag,  DimRemote+'@PARAM HOMHIGHVEL',  s,_MinusInf,_PlusInf); // $600F
   if CheckEditTag(EM2RS.PARAM.HOMLOWVEL.tag,s)   then SendTagCmd(EM2RS.PARAM.HOMLOWVEL.tag,   DimRemote+'@PARAM HOMLOWVEL',   s,_MinusInf,_PlusInf); // $6010
   if CheckEditTag(EM2RS.PARAM.HOMINGACC.tag,s)   then SendTagCmd(EM2RS.PARAM.HOMINGACC.tag,   DimRemote+'@PARAM HOMINGACC',   s,_MinusInf,_PlusInf); // $6011
   if CheckEditTag(EM2RS.PARAM.HOMINGDEC.tag,s)   then SendTagCmd(EM2RS.PARAM.HOMINGDEC.tag,   DimRemote+'@PARAM HOMINGDEC',   s,_MinusInf,_PlusInf); // $6012
   if CheckEditTag(EM2RS.PARAM.LIMSTOPTIME.tag,s) then SendTagCmd(EM2RS.PARAM.LIMSTOPTIME.tag, DimRemote+'@PARAM LIMSTOPTIME', s,_MinusInf,_PlusInf); // $6016
   if CheckEditTag(EM2RS.PARAM.ESTOPTIME.tag,s)   then SendTagCmd(EM2RS.PARAM.ESTOPTIME.tag,   DimRemote+'@PARAM ESTOPTIME',   s,_MinusInf,_PlusInf); // $6017
   if CheckEditTag(EM2RS.PARAM.POSITION.tag,s)    then SendTagCmd(EM2RS.PARAM.POSITION.tag,    DimRemote+'@PARAM POSITION',    s,_MinusInf,_PlusInf);  // $6201+$6202
   if CheckEditTag(EM2RS.PARAM.SPEED.tag,s)       then SendTagCmd(EM2RS.PARAM.SPEED.tag,       DimRemote+'@PARAM SPEED',       s,_MinusInf,_PlusInf);  // $6203
   if CheckEditTag(EM2RS.PARAM.ACCELERAT.tag,s)   then SendTagCmd(EM2RS.PARAM.ACCELERAT.tag,   DimRemote+'@PARAM ACCELERAT',   s,_MinusInf,_PlusInf); // $6204
   if CheckEditTag(EM2RS.PARAM.DECCELERAT.tag,s)  then SendTagCmd(EM2RS.PARAM.DECCELERAT.tag,  DimRemote+'@PARAM DECCELERAT',  s,_MinusInf,_PlusInf); // $6205
   if CheckEditTag(EM2RS.SPEED.tag,s)             then SendTagCmd(EM2RS.SPEED.tag,             DimRemote+'@SPEED',             s,_MinusInf,_PlusInf); // GUI Speed in mm/sec
   if CheckEditTag(EM2RS.DESTINATION.tag,s)       then SendTagCmd(EM2RS.DESTINATION.tag,       DimRemote+'@DESTINATION',       s,_MinusInf,_PlusInf); // GUI Destination in mm
   MenusHandler;
   {
   Warning, Information dialog completion.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end;
  if EditStateError then begin
   Problem('Dialog error detected!');
   EditReset;
  end;
  Cleanup;
 end;
 //
 // EM2RS Driver Command Cycle polling.
 //
 procedure EM2RS_CMD_POLL;
  //
  // Send @Modbus.Poll ... command to &ModbusProxy and save sent request data in Modbus.Poll record.
  //
  procedure PollModbusProxy(cid:Integer);
  var dev,ref,tot,port,uid,fid,saddr,quant:Integer; dat:String;
   procedure Cleanup;
   begin
    dat:=''
   end;
  begin
   Cleanup;
   ApplyCmdOpData(cid);
   if EM2RS_CalcPDU(cid,fid,saddr,quant,dat) then begin
    dev:=devTheProxy; ref:=devMySelf; tot:=EM2RS.Modbus.Timeout; port:=EM2RS.Modbus.Port; uid:=EM2RS.Modbus.UnitId;
    if DevPost(dev,modbus_proxy_poll('@Modbus.Poll',ref,cid,tot,port,uid,fid,dat)+CRLF)>0 then begin
     if DebugFlagEnabled(dfViewExp) then
     ViewExp('COM: '+modbus_proxy_nice('@Modbus.Poll',ref,cid,tot,port,uid,fid,dat,32));
     AssignModbusPoll(dev,cid,mSecNow,port,uid,fid,saddr,quant,dat);
     IncSummRate(EM2RS.Modbus.Poll.Summ.Tx,EM2RS.Modbus.Poll.Rate.Tx);
    end else begin
     Trouble(GotBug('Fail to send command '+Str(cid)));
     ClearModbusPoll;
    end;
   end else begin
    Trouble(GotBug('Fail to calc command '+Str(cid)));
    ClearModbusPoll;
   end;
   Cleanup;
  end;
 begin
  if IsPortOpened and not DIM_IsClientMode then begin
   if IsValidCmdNum(EM2RS.Modbus.Poll.cid) then begin
    //
    // Request in progress, waiting @Modbus.Reply/@Modbus.Refuse/@Modbus.Timeout.
    // Handle Deadline if was no responce for too long time: repeat polling again.
    //
    if iGetTag(EM2RS.POLL.ENABLE.tag)<>0 then begin
     if (mSecNow>EM2RS.Modbus.Poll.tim+EM2RS.Modbus.Deadline) then begin
      Trouble(GotBug('Deadline detected, repeat polling again...'));
      PollModbusProxy(EM2RS.Modbus.Poll.cid);
     end;
    end else if iGetTag(EM2RS.POLL.ENABLE.tag)=0 then begin
     UpdateDo(do_STATE_INDIC,time,st_DISABLE);
     bNul(iSetTag(EM2RS.PARAM.STATE.tag,st_DISABLE));
    end;
   end else begin
    //
    // If request is cleared, send new @Modbus.Poll request by timer.
    //
    if iGetTag(EM2RS.POLL.ENABLE.tag)<>0 then begin
     if (mSecNow>=EM2RS.Modbus.Poll.tim+EM2RS.Modbus.Polling) then begin
      EM2RS.Modbus.Cmd.Num:=NextEnabledCmdNum(EM2RS.Modbus.Cmd.Num);
      if IsEnabledCmdNum(EM2RS.Modbus.Cmd.Num)
      then PollModbusProxy(EM2RS.Modbus.Cmd.Num);
     end;
    end else begin UpdateDo(do_STATE_INDIC,time,st_DISABLE);
    bNul(iSetTag(EM2RS.PARAM.STATE.tag,st_DISABLE));
    end;
   end;
   //
   // Update Poll Rate.
   //
   if SysTimer_Pulse(1000)>0 then begin
    bNul(rSetTag(EM2RS.POLLRATE.RX.tag,EM2RS.Modbus.Poll.Rate.Rx));
    bNul(rSetTag(EM2RS.POLLRATE.TX.tag,EM2RS.Modbus.Poll.Rate.Tx));
    bNul(rSetTag(EM2RS.POLLRATE.EX.tag,EM2RS.Modbus.Poll.Rate.Ex));
    bNul(rSetTag(EM2RS.POLLSUMM.RX.tag,EM2RS.Modbus.Poll.Summ.Rx));
    bNul(rSetTag(EM2RS.POLLSUMM.TX.tag,EM2RS.Modbus.Poll.Summ.Tx));
    bNul(rSetTag(EM2RS.POLLSUMM.EX.tag,EM2RS.Modbus.Poll.Summ.Ex));
    bNul(rSetTag(EM2RS.ERROR.COUNT.tag,GetErrCount(-1)));
    UpdateDo(do_POLLRATERX,time,EM2RS.Modbus.Poll.Rate.Rx);
    UpdateDo(do_POLLRATETX,time,EM2RS.Modbus.Poll.Rate.Tx);
    UpdateDo(do_POLLRATEEX,time,EM2RS.Modbus.Poll.Rate.Ex);
    UpdateDo(do_POLLSUMMRX,time,EM2RS.Modbus.Poll.Summ.Rx);
    UpdateDo(do_POLLSUMMTX,time,EM2RS.Modbus.Poll.Summ.Tx);
    UpdateDo(do_POLLSUMMEX,time,EM2RS.Modbus.Poll.Summ.Ex);
    UpdateDo(do_ERRORCOUNT,time,GetErrCount(-1));
    if DebugFlagEnabled(dfStatist) then
    Success('PollRate: Rx='+Str(EM2RS.Modbus.Poll.Rate.Rx)
                   +'  Tx='+Str(EM2RS.Modbus.Poll.Rate.Tx)
                   +'  Ex='+Str(EM2RS.Modbus.Poll.Rate.Ex));
    ClearModbusRate;
   end;
  end;
 end;
 //
 // EM2RS Driver movement Cycle polling.
 //
 procedure EM2RS_MOVE_POLL;
  procedure Positioning;
  begin
   DevPostCmdLocal('@PARAM TRIGGER '+str(st_POSITIONING));
   EM2RS.MovementDirection:=DirectionNone;
  end;
 begin
  if EM2RS.MovementDirection<>DirectionNone then begin
   if IsModeAbsolute then Positioning;
   if IsModeSpeed then begin
    if ((EM2RS.MovementDirection=DirectionBackward) and (iGetTag(EM2RS.PARAM.SPEED.tag)<0)) then Positioning else
    if ((EM2RS.MovementDirection=DirectionForward) and (iGetTag(EM2RS.PARAM.SPEED.tag)>0)) then Positioning;
   end;
   if IsModeRelative then begin
    if ((EM2RS.MovementDirection=DirectionBackward) and (iGetTag(EM2RS.PARAM.SPEED.tag)<0)
     and (iGetTag(EM2RS.PARAM.POSITION.tag)<0)) then Positioning else
    if ((EM2RS.MovementDirection=DirectionForward) and (iGetTag(EM2RS.PARAM.SPEED.tag)>0)
     and (iGetTag(EM2RS.PARAM.POSITION.tag)>0)) then Positioning;
   end;
  end;
 end;
 {
 Handle message @AssignTag arg
 }
 procedure EM2RS_OnAssignTag(arg:String);
 var tag:Integer; w1,w2:String;
  procedure Cleanup;
  begin
   w1:=''; w2:='';
  end;
 begin
  Cleanup;
  if (arg<>'') then begin
   w1:=ExtractWord(1,arg);
   tag:=FindTag(w1);
   if (tag<>0) then begin
    w2:=ExtractWord(2,arg);
    if tag=EM2RS.POLL.ENABLE.tag then UpdateTag(tag,w2,0,1);
   end;
  end;
  Cleanup;
 end;
 {
 Handle message @DimUpdateTag arg
 }
 procedure EM2RS_OnDimUpdateTag(arg:String);
 var tag,typ:Integer; x,y:Real;
 begin
  if (arg<>'') then begin
   if DIM_IsClientMode and not DIM_IsServerMode then begin
    tag:=FindTag(ExtractWord(1,arg));
    if (tag<>0) then begin
     typ:=TypeTag(tag);
     if (typ=1) then y:=iGetTag(tag) else
     if (typ=2) then y:=rGetTag(tag) else y:=_Nan;
     x:=time;
     if not IsNan(y) then begin
      if tag=EM2RS.PARAM.PULSE.tag       then UpdateAo(ao_PULSE,x,y);
      if tag=EM2RS.PARAM.CTRLMODE.tag    then UpdateAo(ao_CTRLMODE,x,y);
      if tag=EM2RS.PARAM.MOTDIRECT.tag   then UpdateAo(ao_MOTDIRECT,x,y);
      if tag=EM2RS.PARAM.POSERROR.tag    then UpdateAo(ao_POSERROR,x,y);
      if tag=EM2RS.PARAM.FORCED.tag      then UpdateAo(ao_FORCED,x,y);
      if tag=EM2RS.PARAM.POSLOOPKP.tag   then UpdateAo(ao_POSLOOPKP,x,y);
      if tag=EM2RS.PARAM.VELLOOPKI.tag   then UpdateAo(ao_VELLOOPKI,x,y);
      if tag=EM2RS.PARAM.VELLOOPKP.tag   then UpdateAo(ao_VELLOOPKP,x,y);
      if tag=EM2RS.PARAM.POSLOOPKPH.tag  then UpdateAo(ao_POSLOOPKPH,x,y);
      if tag=EM2RS.PARAM.CMDTIME.tag     then UpdateAo(ao_CMDTIME,x,y);
      if tag=EM2RS.PARAM.VELOTOC.tag     then UpdateAo(ao_VELOTOC,x,y);
      if tag=EM2RS.PARAM.VELCTOO.tag     then UpdateAo(ao_VELCTOO,x,y);
      if tag=EM2RS.PARAM.DELAYOTOC.tag   then UpdateAo(ao_DELAYOTOC,x,y);
      if tag=EM2RS.PARAM.DELAYCTOO.tag   then UpdateAo(ao_DELAYCTOO,x,y);
      if tag=EM2RS.PARAM.CFGINPUT1.tag   then UpdateAo(ao_CFGINPUT1,x,y);
      if tag=EM2RS.PARAM.CFGINPUT2.tag   then UpdateAo(ao_CFGINPUT2,x,y);
      if tag=EM2RS.PARAM.CFGINPUT3.tag   then UpdateAo(ao_CFGINPUT3,x,y);
      if tag=EM2RS.PARAM.CFGINPUT4.tag   then UpdateAo(ao_CFGINPUT4,x,y);
      if tag=EM2RS.PARAM.CFGINPUT5.tag   then UpdateAo(ao_CFGINPUT5,x,y);
      if tag=EM2RS.PARAM.CFGINPUT6.tag   then UpdateAo(ao_CFGINPUT6,x,y);
      if tag=EM2RS.PARAM.CFGINPUT7.tag   then UpdateAo(ao_CFGINPUT7,x,y);
      if tag=EM2RS.PARAM.CFGOUTPUT1.tag  then UpdateAo(ao_CFGOUTPUT1,x,y);
      if tag=EM2RS.PARAM.CFGOUTPUT2.tag  then UpdateAo(ao_CFGOUTPUT2,x,y);
      if tag=EM2RS.PARAM.CFGOUTPUT3.tag  then UpdateAo(ao_CFGOUTPUT3,x,y);
      if tag=EM2RS.PARAM.ALRMDETECT.tag  then UpdateAo(ao_ALRMDETECT,x,y);
      if tag=EM2RS.PARAM.DIST2SEND.tag   then UpdateAo(ao_DIST2SEND,x,y);
      if tag=EM2RS.PARAM.BUSVOLT.tag     then UpdateAo(ao_BUSVOLT,x,y);
      if tag=EM2RS.PARAM.DISTATUS.tag    then UpdateAo(ao_DISTATUS,x,y);
      if tag=EM2RS.PARAM.DOSTATUS.tag    then UpdateAo(ao_DOSTATUS,x,y);
      if tag=EM2RS.PARAM.PEAKCUR.tag     then UpdateAo(ao_PEAKCUR,x,y);
      if tag=EM2RS.PARAM.HOLDINCLSD.tag  then UpdateAo(ao_HOLDINCLSD,x,y);
      if tag=EM2RS.PARAM.HOLDINOPEN.tag  then UpdateAo(ao_HOLDINOPEN,x,y);
      if tag=EM2RS.PARAM.BAUDRATE.tag    then UpdateAo(ao_BAUDRATE,x,y);
      if tag=EM2RS.PARAM.ADDRESS.tag     then UpdateAo(ao_ADDRESS,x,y);
      if tag=EM2RS.PARAM.RS485TYPE.tag   then UpdateAo(ao_RS485TYPE,x,y);
      if tag=EM2RS.PARAM.STBCURPER.tag   then UpdateAo(ao_STBCURPER,x,y);
      if tag=EM2RS.PARAM.JOGVEL.tag      then UpdateAo(ao_JOGVEL,x,y);
      if tag=EM2RS.PARAM.JOGINTER.tag    then UpdateAo(ao_JOGINTER,x,y);
      if tag=EM2RS.PARAM.JOGRUNTIME.tag  then UpdateAo(ao_JOGRUNTIME,x,y);
      if tag=EM2RS.PARAM.JOGACCDEC.tag   then UpdateAo(ao_JOGACCDEC,x,y);
      if tag=EM2RS.PARAM.ENCODERES.tag   then UpdateAo(ao_ENCODERES,x,y);
      if tag=EM2RS.PARAM.MOTSTATUS.tag   then UpdateAo(ao_MOTSTATUS,x,y);
      if tag=EM2RS.PARAM.SAVEWORD.tag    then UpdateAo(ao_SAVEWORD,x,y);
      if tag=EM2RS.PARAM.CURALARM.tag    then UpdateAo(ao_CURALARM,x,y);
      if tag=EM2RS.PARAM.PRCONTROL.tag   then UpdateAo(ao_PRCONTROL,x,y);
      if tag=EM2RS.PARAM.TRIGGER.tag     then UpdateAo(ao_TRIGGER,x,y);
      if tag=EM2RS.PARAM.SOFTLIMPOS.tag  then UpdateAo(ao_SOFTLIMPOS,x,y);
      if tag=EM2RS.PARAM.SOFTLIMNEG.tag  then UpdateAo(ao_SOFTLIMNEG,x,y);
      if tag=EM2RS.PARAM.HOMINGMODE.tag  then UpdateAo(ao_HOMINGMODE,x,y);
      if tag=EM2RS.PARAM.AFTERHOMING.tag then UpdateAo(ao_AFTERHOMING,x,y);
      if tag=EM2RS.PARAM.HOMHIGHVEL.tag  then UpdateAo(ao_HOMHIGHVEL,x,y);
      if tag=EM2RS.PARAM.HOMLOWVEL.tag   then UpdateAo(ao_HOMLOWVEL,x,y);
      if tag=EM2RS.PARAM.HOMINGACC.tag   then UpdateAo(ao_HOMINGACC,x,y);
      if tag=EM2RS.PARAM.HOMINGDEC.tag   then UpdateAo(ao_HOMINGDEC,x,y);
      if tag=EM2RS.PARAM.LIMSTOPTIME.tag then UpdateAo(ao_LIMSTOPTIME,x,y);
      if tag=EM2RS.PARAM.ESTOPTIME.tag   then UpdateAo(ao_ESTOPTIME,x,y);
      if tag=EM2RS.PARAM.ACTPOS.tag      then UpdateAo(ao_ACTPOS,x,y);
      if tag=EM2RS.PARAM.MOTPATH0.tag    then UpdateAo(ao_MOTPATH0,x,y);
      if tag=EM2RS.PARAM.POSITION.tag    then UpdateAo(ao_POSITION,x,y);
      if tag=EM2RS.PARAM.SPEED.tag       then UpdateAo(ao_SPEED,x,y);
      if tag=EM2RS.PARAM.ACCELERAT.tag   then UpdateAo(ao_ACCELERAT,x,y);
      if tag=EM2RS.PARAM.DECCELERAT.tag  then UpdateAo(ao_DECCELERAT,x,y);
      if tag=EM2RS.POSITION.tag          then UpdateAo(ao_POSITION_MM,x,y);
      if tag=EM2RS.PARAM.STATE.tag       then UpdateDo(do_STATE_INDIC,x,y);
      if tag=EM2RS.ERROR.COUNT.tag       then UpdateDo(do_ERRORCOUNT,x,y);
      if tag=EM2RS.POLLRATE.RX.tag       then UpdateDo(do_POLLRATERX,x,y);
      if tag=EM2RS.POLLRATE.TX.tag       then UpdateDo(do_POLLRATETX,x,y);
      if tag=EM2RS.POLLRATE.EX.tag       then UpdateDo(do_POLLRATEEX,x,y);
      if tag=EM2RS.POLLSUMM.RX.tag       then UpdateDo(do_POLLSUMMRX,x,y);
      if tag=EM2RS.POLLSUMM.TX.tag       then UpdateDo(do_POLLSUMMTX,x,y);
      if tag=EM2RS.POLLSUMM.EX.tag       then UpdateDo(do_POLLSUMMEX,x,y);
     end;
    end;
   end;
  end;
 end;
 //
 // Tags filling
 //
 procedure EM2RS_FillTags(InitVal:Real);
 begin
  EM2RS.POLL.ENABLE.val:=InitVal;
  EM2RS.SERVID.val:=InitVal;
  EM2RS.CLOCK.val:=InitVal;
  EM2RS.DevLabel.val:=InitVal;
  EM2RS.Position.val:=InitVal;
  EM2RS.SpeedUnit.val:=InitVal;
  EM2RS.PosUnit.val:=InitVal;
  EM2RS.MovUnit.val:=InitVal;
  EM2RS.Speed.val:=InitVal;
  EM2RS.Destination.val:=InitVal;
  EM2RS.DirectFWD.val:=InitVal;
  EM2RS.DirectBWD.val:=InitVal;
  EM2RS.Move.val:=InitVal;
  EM2RS.Homing.val:=InitVal;
  EM2RS.EStop.val:=InitVal;
  EM2RS.SetZero.val:=InitVal;
  EM2RS.PosLimit.val:=InitVal;
  EM2RS.NegLimit.val:=InitVal;
  EM2RS.PARAM.PULSE.val:=InitVal;
  EM2RS.PARAM.CTRLMODE.val:=InitVal;
  EM2RS.PARAM.MOTDIRECT.val:=InitVal;
  EM2RS.PARAM.POSERROR.val:=InitVal;
  EM2RS.PARAM.FORCED.val:=InitVal;
  EM2RS.PARAM.POSLOOPKP.val:=InitVal;
  EM2RS.PARAM.VELLOOPKI.val:=InitVal;
  EM2RS.PARAM.VELLOOPKP.val:=InitVal;
  EM2RS.PARAM.POSLOOPKPH.val:=InitVal;
  EM2RS.PARAM.CMDTIME.val:=InitVal;
  EM2RS.PARAM.VELOTOC.val:=InitVal;
  EM2RS.PARAM.VELCTOO.val:=InitVal;
  EM2RS.PARAM.DELAYOTOC.val:=InitVal;
  EM2RS.PARAM.DELAYCTOO.val:=InitVal;
  EM2RS.PARAM.CFGINPUT1.val:=InitVal;
  EM2RS.PARAM.CFGI1_NC.val:=InitVal;
  EM2RS.PARAM.CFGINPUT2.val:=InitVal;
  EM2RS.PARAM.CFGI2_NC.val:=InitVal;
  EM2RS.PARAM.CFGINPUT3.val:=InitVal;
  EM2RS.PARAM.CFGI3_NC.val:=InitVal;
  EM2RS.PARAM.CFGINPUT4.val:=InitVal;
  EM2RS.PARAM.CFGI4_NC.val:=InitVal;
  EM2RS.PARAM.CFGINPUT5.val:=InitVal;
  EM2RS.PARAM.CFGI5_NC.val:=InitVal;
  EM2RS.PARAM.CFGINPUT6.val:=InitVal;
  EM2RS.PARAM.CFGI6_NC.val:=InitVal;
  EM2RS.PARAM.CFGINPUT7.val:=InitVal;
  EM2RS.PARAM.CFGI7_NC.val:=InitVal;
  EM2RS.PARAM.CFGOUTPUT1.val:=InitVal;
  EM2RS.PARAM.CFGO1_NC.val:=InitVal;
  EM2RS.PARAM.CFGOUTPUT2.val:=InitVal;
  EM2RS.PARAM.CFGO2_NC.val:=InitVal;
  EM2RS.PARAM.CFGOUTPUT3.val:=InitVal;
  EM2RS.PARAM.CFGO3_NC.val:=InitVal;
  EM2RS.PARAM.ALRMDETECT.val:=InitVal;
  EM2RS.PARAM.DIST2SEND.val:=InitVal;
  EM2RS.PARAM.BUSVOLT.val:=InitVal;
  EM2RS.PARAM.DISTATUS.val:=InitVal;
  EM2RS.PARAM.DOSTATUS.val:=InitVal;
  EM2RS.PARAM.PEAKCUR.val:=InitVal;
  EM2RS.PARAM.HOLDINCLSD.val:=InitVal;
  EM2RS.PARAM.HOLDINOPEN.val:=InitVal;
  EM2RS.PARAM.BAUDRATE.val:=InitVal;
  EM2RS.PARAM.ADDRESS.val:=InitVal;
  EM2RS.PARAM.RS485TYPE.val:=InitVal;
  EM2RS.PARAM.STBCURPER.val:=InitVal;
  EM2RS.PARAM.JOGVEL.val:=InitVal;
  EM2RS.PARAM.JOGINTER.val:=InitVal;
  EM2RS.PARAM.JOGRUNTIME.val:=InitVal;
  EM2RS.PARAM.JOGACCDEC.val:=InitVal;
  EM2RS.PARAM.ENCODERES.val:=InitVal;
  EM2RS.PARAM.SOFTWARE.val:=InitVal;
  EM2RS.PARAM.FIRMWARE.val:=InitVal;
  EM2RS.PARAM.MOTSTATUS.val:=InitVal;
  EM2RS.PARAM.SAVEWORD.val:=InitVal;
  EM2RS.PARAM.CTRLWORD.val:=InitVal;
  EM2RS.PARAM.CURALARM.val:=InitVal;
  EM2RS.PARAM.PRCONTROL.val:=InitVal;
  EM2RS.PARAM.TRIGGER.val:=InitVal;
  EM2RS.PARAM.SOFTLIMPOS.val:=InitVal;
  EM2RS.PARAM.SOFTLIMNEG.val:=InitVal;
  EM2RS.PARAM.HOMINGMODE.val:=InitVal;
  EM2RS.PARAM.AFTERHOMING.val:=InitVal;
  EM2RS.PARAM.HOMHIGHVEL.val:=InitVal;
  EM2RS.PARAM.HOMLOWVEL.val:=InitVal;
  EM2RS.PARAM.HOMINGACC.val:=InitVal;
  EM2RS.PARAM.HOMINGDEC.val:=InitVal;
  EM2RS.PARAM.LIMSTOPTIME.val:=InitVal;
  EM2RS.PARAM.ESTOPTIME.val:=InitVal;
  EM2RS.PARAM.ACTPOS.val:=InitVal;
  EM2RS.PARAM.MOTPATH0.val:=InitVal;
  EM2RS.PARAM.POSITION.val:=InitVal;
  EM2RS.PARAM.SPEED.val:=InitVal;
  EM2RS.PARAM.ACCELERAT.val:=InitVal;
  EM2RS.PARAM.DECCELERAT.val:=InitVal;
  EM2RS.PARAM.STATE.val:=InitVal;
  EM2RS.ERROR.COUNT.val:=InitVal;
  EM2RS.POLLRATE.RX.val:=InitVal;
  EM2RS.POLLRATE.TX.val:=InitVal;
  EM2RS.POLLRATE.EX.val:=InitVal;
  EM2RS.POLLSUMM.RX.val:=InitVal;
  EM2RS.POLLSUMM.TX.val:=InitVal;
  EM2RS.POLLSUMM.EX.val:=InitVal;
 end;
 {
 Update DIM services
 }
 procedure DimUpdateState;
 begin
  if DIM_IsServerMode then begin
   // Enforce update each 10 sec
   if SysTimer_Pulse(10000)>0 then EM2RS_FillTags(-MaxReal);
   if ShouldRefresh(EM2RS.POLL.ENABLE.val,       GetStampOfTag(EM2RS.POLL.ENABLE.tag,0))>0       then DIM_UpdateTag(EM2RS.POLL.ENABLE.tag,'');
   if ShouldRefresh(EM2RS.Position.val,          GetStampOfTag(EM2RS.Position.tag,0))>0          then DIM_UpdateTag(EM2RS.Position.tag,'');
   if ShouldRefresh(EM2RS.SpeedUnit.val,         GetStampOfTag(EM2RS.SpeedUnit.tag,0))>0         then DIM_UpdateTag(EM2RS.SpeedUnit.tag,'');
   if ShouldRefresh(EM2RS.DevLabel.val,          GetStampOfTag(EM2RS.DevLabel.tag,0))>0          then DIM_UpdateTag(EM2RS.DevLabel.tag,'');
   if ShouldRefresh(EM2RS.PosUnit.val,           GetStampOfTag(EM2RS.PosUnit.tag,0))>0           then DIM_UpdateTag(EM2RS.PosUnit.tag,'');
   if ShouldRefresh(EM2RS.MovUnit.val,           GetStampOfTag(EM2RS.MovUnit.tag,0))>0           then DIM_UpdateTag(EM2RS.MovUnit.tag,'');
   if ShouldRefresh(EM2RS.Speed.val,             GetStampOfTag(EM2RS.Speed.tag,0))>0             then DIM_UpdateTag(EM2RS.Speed.tag,'');
   if ShouldRefresh(EM2RS.Destination.val,       GetStampOfTag(EM2RS.Destination.tag,0))>0       then DIM_UpdateTag(EM2RS.Destination.tag,'');
   if ShouldRefresh(EM2RS.DirectFWD.val,         GetStampOfTag(EM2RS.DirectFWD.tag,0))>0         then DIM_UpdateTag(EM2RS.DirectFWD.tag,'');
   if ShouldRefresh(EM2RS.DirectBWD.val,         GetStampOfTag(EM2RS.DirectBWD.tag,0))>0         then DIM_UpdateTag(EM2RS.DirectBWD.tag,'');
   if ShouldRefresh(EM2RS.Move.val,              GetStampOfTag(EM2RS.Move.tag,0))>0              then DIM_UpdateTag(EM2RS.Move.tag,'');
   if ShouldRefresh(EM2RS.Homing.val,            GetStampOfTag(EM2RS.Homing.tag,0))>0            then DIM_UpdateTag(EM2RS.Homing.tag,'');
   if ShouldRefresh(EM2RS.EStop.val,             GetStampOfTag(EM2RS.EStop.tag,0))>0             then DIM_UpdateTag(EM2RS.EStop.tag,'');
   if ShouldRefresh(EM2RS.SetZero.val,           GetStampOfTag(EM2RS.SetZero.tag,0))>0           then DIM_UpdateTag(EM2RS.SetZero.tag,'');
   if ShouldRefresh(EM2RS.PosLimit.val,          GetStampOfTag(EM2RS.PosLimit.tag,0))>0          then DIM_UpdateTag(EM2RS.PosLimit.tag,'');
   if ShouldRefresh(EM2RS.NegLimit.val,          GetStampOfTag(EM2RS.NegLimit.tag,0))>0          then DIM_UpdateTag(EM2RS.NegLimit.tag,'');
   if ShouldRefresh(EM2RS.PARAM.PULSE.val,       GetStampOfTag(EM2RS.PARAM.PULSE.tag,0))>0       then DIM_UpdateTag(EM2RS.PARAM.PULSE.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CTRLMODE.val,    GetStampOfTag(EM2RS.PARAM.CTRLMODE.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.CTRLMODE.tag,'');
   if ShouldRefresh(EM2RS.PARAM.MOTDIRECT.val,   GetStampOfTag(EM2RS.PARAM.MOTDIRECT.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.MOTDIRECT.tag,'');
   if ShouldRefresh(EM2RS.PARAM.POSERROR.val,    GetStampOfTag(EM2RS.PARAM.POSERROR.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.POSERROR.tag,'');
   if ShouldRefresh(EM2RS.PARAM.FORCED.val,      GetStampOfTag(EM2RS.PARAM.FORCED.tag,0))>0      then DIM_UpdateTag(EM2RS.PARAM.FORCED.tag,'');
   if ShouldRefresh(EM2RS.PARAM.POSLOOPKP.val,   GetStampOfTag(EM2RS.PARAM.POSLOOPKP.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.POSLOOPKP.tag,'');
   if ShouldRefresh(EM2RS.PARAM.VELLOOPKI.val,   GetStampOfTag(EM2RS.PARAM.VELLOOPKI.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.VELLOOPKI.tag,'');
   if ShouldRefresh(EM2RS.PARAM.VELLOOPKP.val,   GetStampOfTag(EM2RS.PARAM.VELLOOPKP.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.VELLOOPKP.tag,'');
   if ShouldRefresh(EM2RS.PARAM.POSLOOPKPH.val,  GetStampOfTag(EM2RS.PARAM.POSLOOPKPH.tag,0))>0  then DIM_UpdateTag(EM2RS.PARAM.POSLOOPKPH.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CMDTIME.val,     GetStampOfTag(EM2RS.PARAM.CMDTIME.tag,0))>0     then DIM_UpdateTag(EM2RS.PARAM.CMDTIME.tag,'');
   if ShouldRefresh(EM2RS.PARAM.VELOTOC.val,     GetStampOfTag(EM2RS.PARAM.VELOTOC.tag,0))>0     then DIM_UpdateTag(EM2RS.PARAM.VELOTOC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.VELCTOO.val,     GetStampOfTag(EM2RS.PARAM.VELCTOO.tag,0))>0     then DIM_UpdateTag(EM2RS.PARAM.VELCTOO.tag,'');
   if ShouldRefresh(EM2RS.PARAM.DELAYOTOC.val,   GetStampOfTag(EM2RS.PARAM.DELAYOTOC.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.DELAYOTOC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.DELAYCTOO.val,   GetStampOfTag(EM2RS.PARAM.DELAYCTOO.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.DELAYCTOO.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGINPUT1.val,   GetStampOfTag(EM2RS.PARAM.CFGINPUT1.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.CFGINPUT1.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGI1_NC.val,    GetStampOfTag(EM2RS.PARAM.CFGI1_NC.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.CFGI1_NC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGINPUT2.val,   GetStampOfTag(EM2RS.PARAM.CFGINPUT2.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.CFGINPUT2.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGI2_NC.val,    GetStampOfTag(EM2RS.PARAM.CFGI2_NC.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.CFGI2_NC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGINPUT3.val,   GetStampOfTag(EM2RS.PARAM.CFGINPUT3.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.CFGINPUT3.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGI3_NC.val,    GetStampOfTag(EM2RS.PARAM.CFGI3_NC.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.CFGI3_NC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGINPUT4.val,   GetStampOfTag(EM2RS.PARAM.CFGINPUT4.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.CFGINPUT4.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGI4_NC.val,    GetStampOfTag(EM2RS.PARAM.CFGI4_NC.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.CFGI4_NC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGINPUT5.val,   GetStampOfTag(EM2RS.PARAM.CFGINPUT5.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.CFGINPUT5.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGI5_NC.val,    GetStampOfTag(EM2RS.PARAM.CFGI5_NC.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.CFGI5_NC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGINPUT6.val,   GetStampOfTag(EM2RS.PARAM.CFGINPUT6.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.CFGINPUT6.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGI6_NC.val,    GetStampOfTag(EM2RS.PARAM.CFGI6_NC.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.CFGI6_NC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGINPUT7.val,   GetStampOfTag(EM2RS.PARAM.CFGINPUT7.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.CFGINPUT7.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGI7_NC.val,    GetStampOfTag(EM2RS.PARAM.CFGI7_NC.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.CFGI7_NC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGOUTPUT1.val,  GetStampOfTag(EM2RS.PARAM.CFGOUTPUT1.tag,0))>0  then DIM_UpdateTag(EM2RS.PARAM.CFGOUTPUT1.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGO1_NC.val,    GetStampOfTag(EM2RS.PARAM.CFGO1_NC.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.CFGO1_NC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGOUTPUT2.val,  GetStampOfTag(EM2RS.PARAM.CFGOUTPUT2.tag,0))>0  then DIM_UpdateTag(EM2RS.PARAM.CFGOUTPUT2.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGO2_NC.val,    GetStampOfTag(EM2RS.PARAM.CFGO2_NC.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.CFGO2_NC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGOUTPUT3.val,  GetStampOfTag(EM2RS.PARAM.CFGOUTPUT3.tag,0))>0  then DIM_UpdateTag(EM2RS.PARAM.CFGOUTPUT3.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CFGO3_NC.val,    GetStampOfTag(EM2RS.PARAM.CFGO3_NC.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.CFGO3_NC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.ALRMDETECT.val,  GetStampOfTag(EM2RS.PARAM.ALRMDETECT.tag,0))>0  then DIM_UpdateTag(EM2RS.PARAM.ALRMDETECT.tag,'');
   if ShouldRefresh(EM2RS.PARAM.DIST2SEND.val,   GetStampOfTag(EM2RS.PARAM.DIST2SEND.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.DIST2SEND.tag,'');
   if ShouldRefresh(EM2RS.PARAM.BUSVOLT.val,     GetStampOfTag(EM2RS.PARAM.BUSVOLT.tag,0))>0     then DIM_UpdateTag(EM2RS.PARAM.BUSVOLT.tag,'');
   if ShouldRefresh(EM2RS.PARAM.DISTATUS.val,    GetStampOfTag(EM2RS.PARAM.DISTATUS.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.DISTATUS.tag,'');
   if ShouldRefresh(EM2RS.PARAM.DOSTATUS.val,    GetStampOfTag(EM2RS.PARAM.DOSTATUS.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.DOSTATUS.tag,'');
   if ShouldRefresh(EM2RS.PARAM.PEAKCUR.val,     GetStampOfTag(EM2RS.PARAM.PEAKCUR.tag,0))>0     then DIM_UpdateTag(EM2RS.PARAM.PEAKCUR.tag,'');
   if ShouldRefresh(EM2RS.PARAM.HOLDINCLSD.val,  GetStampOfTag(EM2RS.PARAM.HOLDINCLSD.tag,0))>0  then DIM_UpdateTag(EM2RS.PARAM.HOLDINCLSD.tag,'');
   if ShouldRefresh(EM2RS.PARAM.HOLDINOPEN.val,  GetStampOfTag(EM2RS.PARAM.HOLDINOPEN.tag,0))>0  then DIM_UpdateTag(EM2RS.PARAM.HOLDINOPEN.tag,'');
   if ShouldRefresh(EM2RS.PARAM.BAUDRATE.val,    GetStampOfTag(EM2RS.PARAM.BAUDRATE.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.BAUDRATE.tag,'');
   if ShouldRefresh(EM2RS.PARAM.ADDRESS.val,     GetStampOfTag(EM2RS.PARAM.ADDRESS.tag,0))>0     then DIM_UpdateTag(EM2RS.PARAM.ADDRESS.tag,'');
   if ShouldRefresh(EM2RS.PARAM.RS485TYPE.val,   GetStampOfTag(EM2RS.PARAM.RS485TYPE.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.RS485TYPE.tag,'');
   if ShouldRefresh(EM2RS.PARAM.STBCURPER.val,   GetStampOfTag(EM2RS.PARAM.STBCURPER.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.STBCURPER.tag,'');
   if ShouldRefresh(EM2RS.PARAM.JOGVEL.val,      GetStampOfTag(EM2RS.PARAM.JOGVEL.tag,0))>0      then DIM_UpdateTag(EM2RS.PARAM.JOGVEL.tag,'');
   if ShouldRefresh(EM2RS.PARAM.JOGINTER.val,    GetStampOfTag(EM2RS.PARAM.JOGINTER.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.JOGINTER.tag,'');
   if ShouldRefresh(EM2RS.PARAM.JOGRUNTIME.val,  GetStampOfTag(EM2RS.PARAM.JOGRUNTIME.tag,0))>0  then DIM_UpdateTag(EM2RS.PARAM.JOGRUNTIME.tag,'');
   if ShouldRefresh(EM2RS.PARAM.JOGACCDEC.val,   GetStampOfTag(EM2RS.PARAM.JOGACCDEC.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.JOGACCDEC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.ENCODERES.val,   GetStampOfTag(EM2RS.PARAM.ENCODERES.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.ENCODERES.tag,'');
   if ShouldRefresh(EM2RS.PARAM.SOFTWARE.val,    GetStampOfTag(EM2RS.PARAM.SOFTWARE.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.SOFTWARE.tag,'');
   if ShouldRefresh(EM2RS.PARAM.FIRMWARE.val,    GetStampOfTag(EM2RS.PARAM.FIRMWARE.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.FIRMWARE.tag,'');
   if ShouldRefresh(EM2RS.PARAM.MOTSTATUS.val,   GetStampOfTag(EM2RS.PARAM.MOTSTATUS.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.MOTSTATUS.tag,'');
   if ShouldRefresh(EM2RS.PARAM.SAVEWORD.val,    GetStampOfTag(EM2RS.PARAM.SAVEWORD.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.SAVEWORD.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CTRLWORD.val,    GetStampOfTag(EM2RS.PARAM.CTRLWORD.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.CTRLWORD.tag,'');
   if ShouldRefresh(EM2RS.PARAM.CURALARM.val,    GetStampOfTag(EM2RS.PARAM.CURALARM.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.CURALARM.tag,'');
   if ShouldRefresh(EM2RS.PARAM.PRCONTROL.val,   GetStampOfTag(EM2RS.PARAM.PRCONTROL.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.PRCONTROL.tag,'');
   if ShouldRefresh(EM2RS.PARAM.TRIGGER.val,     GetStampOfTag(EM2RS.PARAM.TRIGGER.tag,0))>0     then DIM_UpdateTag(EM2RS.PARAM.TRIGGER.tag,'');
   if ShouldRefresh(EM2RS.PARAM.SOFTLIMPOS.val,  GetStampOfTag(EM2RS.PARAM.SOFTLIMPOS.tag,0))>0  then DIM_UpdateTag(EM2RS.PARAM.SOFTLIMPOS.tag,'');
   if ShouldRefresh(EM2RS.PARAM.SOFTLIMNEG.val,  GetStampOfTag(EM2RS.PARAM.SOFTLIMNEG.tag,0))>0  then DIM_UpdateTag(EM2RS.PARAM.SOFTLIMNEG.tag,'');
   if ShouldRefresh(EM2RS.PARAM.HOMINGMODE.val,  GetStampOfTag(EM2RS.PARAM.HOMINGMODE.tag,0))>0  then DIM_UpdateTag(EM2RS.PARAM.HOMINGMODE.tag,'');
   if ShouldRefresh(EM2RS.PARAM.AFTERHOMING.val, GetStampOfTag(EM2RS.PARAM.AFTERHOMING.tag,0))>0 then DIM_UpdateTag(EM2RS.PARAM.AFTERHOMING.tag,'');
   if ShouldRefresh(EM2RS.PARAM.HOMHIGHVEL.val,  GetStampOfTag(EM2RS.PARAM.HOMHIGHVEL.tag,0))>0  then DIM_UpdateTag(EM2RS.PARAM.HOMHIGHVEL.tag,'');
   if ShouldRefresh(EM2RS.PARAM.HOMLOWVEL.val,   GetStampOfTag(EM2RS.PARAM.HOMLOWVEL.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.HOMLOWVEL.tag,'');
   if ShouldRefresh(EM2RS.PARAM.HOMINGACC.val,   GetStampOfTag(EM2RS.PARAM.HOMINGACC.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.HOMINGACC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.HOMINGDEC.val,   GetStampOfTag(EM2RS.PARAM.HOMINGDEC.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.HOMINGDEC.tag,'');
   if ShouldRefresh(EM2RS.PARAM.LIMSTOPTIME.val, GetStampOfTag(EM2RS.PARAM.LIMSTOPTIME.tag,0))>0 then DIM_UpdateTag(EM2RS.PARAM.LIMSTOPTIME.tag,'');
   if ShouldRefresh(EM2RS.PARAM.ESTOPTIME.val,   GetStampOfTag(EM2RS.PARAM.ESTOPTIME.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.ESTOPTIME.tag,'');
   if ShouldRefresh(EM2RS.PARAM.ACTPOS.val,      GetStampOfTag(EM2RS.PARAM.ACTPOS.tag,0))>0      then DIM_UpdateTag(EM2RS.PARAM.ACTPOS.tag,'');
   if ShouldRefresh(EM2RS.PARAM.MOTPATH0.val,    GetStampOfTag(EM2RS.PARAM.MOTPATH0.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.MOTPATH0.tag,'');
   if ShouldRefresh(EM2RS.PARAM.POSITION.val,    GetStampOfTag(EM2RS.PARAM.POSITION.tag,0))>0    then DIM_UpdateTag(EM2RS.PARAM.POSITION.tag,'');
   if ShouldRefresh(EM2RS.PARAM.SPEED.val,       GetStampOfTag(EM2RS.PARAM.SPEED.tag,0))>0       then DIM_UpdateTag(EM2RS.PARAM.SPEED.tag,'');
   if ShouldRefresh(EM2RS.PARAM.ACCELERAT.val,   GetStampOfTag(EM2RS.PARAM.ACCELERAT.tag,0))>0   then DIM_UpdateTag(EM2RS.PARAM.ACCELERAT.tag,'');
   if ShouldRefresh(EM2RS.PARAM.DECCELERAT.val,  GetStampOfTag(EM2RS.PARAM.DECCELERAT.tag,0))>0  then DIM_UpdateTag(EM2RS.PARAM.DECCELERAT.tag,'');
   if ShouldRefresh(EM2RS.PARAM.STATE.val,       GetStampOfTag(EM2RS.PARAM.STATE.tag,0))>0       then DIM_UpdateTag(EM2RS.PARAM.STATE.tag,'');
   if ShouldRefresh(EM2RS.ERROR.COUNT.val,       GetStampOfTag(EM2RS.ERROR.COUNT.tag,0))>0       then DIM_UpdateTag(EM2RS.ERROR.COUNT.tag,'');
   if ShouldRefresh(EM2RS.POLLRATE.RX.val,       GetStampOfTag(EM2RS.POLLRATE.RX.tag,0))+
      ShouldRefresh(EM2RS.POLLRATE.TX.val,       GetStampOfTag(EM2RS.POLLRATE.TX.tag,0))+
      ShouldRefresh(EM2RS.POLLRATE.EX.val,       GetStampOfTag(EM2RS.POLLRATE.EX.tag,0))>0       then DIM_UpdateTag(EM2RS.POLLRATE.RX.tag,'');
   if ShouldRefresh(EM2RS.POLLSUMM.RX.val,       GetStampOfTag(EM2RS.POLLSUMM.RX.tag,0))+
      ShouldRefresh(EM2RS.POLLSUMM.TX.val,       GetStampOfTag(EM2RS.POLLSUMM.TX.tag,0))+
      ShouldRefresh(EM2RS.POLLSUMM.EX.val,       GetStampOfTag(EM2RS.POLLSUMM.EX.tag,0))>0       then DIM_UpdateTag(EM2RS.POLLSUMM.RX.tag,'');
   if ShouldRefresh(EM2RS.CLOCK.val,             GetStampOfTag(EM2RS.CLOCK.tag,0))>0             then DIM_UpdateTag(EM2RS.CLOCK.tag,'');
   if ShouldRefresh(EM2RS.SERVID.val,            GetStampOfTag(EM2RS.SERVID.tag,0))>0            then DIM_UpdateTag(EM2RS.SERVID.tag,'');
  end;
 end;
 //
 // EM2RS tags initialization.
 //
 procedure EM2RS_InitTags(Prefix:String);
 begin
  DIM_GuiClickInit(Prefix+'.DIMGUICLICK');
  InitTag(EM2RS.PARAM.STATE.tag,       Prefix+'.STATE',           1); { State indicator                     }
  InitTag(EM2RS.PARAM.PULSE.tag,       Prefix+'.PULSE',           1); { $0001 Pulse/Revolution              }
  InitTag(EM2RS.PARAM.CTRLMODE.tag,    Prefix+'.CTRLMODE',        1); { $0003 Control Mode (CS2RS)          }
  InitTag(EM2RS.PARAM.MOTDIRECT.tag,   Prefix+'.MOTDIRECT',       1); { $0007 Motor Direction               }
  InitTag(EM2RS.PARAM.POSERROR.tag,    Prefix+'.POSERROR',        1); { $000B Allowed max pos follow error* }
  InitTag(EM2RS.PARAM.FORCED.tag,      Prefix+'.FORCED',          1); { $000F Forced enable by software *   }
  InitTag(EM2RS.PARAM.POSLOOPKP.tag,   Prefix+'.POSLOOPKP',       1); { $0051 Position loop Kp  *           }
  InitTag(EM2RS.PARAM.VELLOOPKI.tag,   Prefix+'.VELLOOPKI',       1); { $0053 Velocity loop Ki  *           }
  InitTag(EM2RS.PARAM.VELLOOPKP.tag,   Prefix+'.VELLOOPKP',       1); { $0055 Velocity loop Kp  *           }
  InitTag(EM2RS.PARAM.POSLOOPKPH.tag,  Prefix+'.POSLOOPKPH',      1); { $0065 Position loop KpH *           }
  InitTag(EM2RS.PARAM.CMDTIME.tag,     Prefix+'.CMDTIME',         1); { $00A1 Command filter time *         }
  InitTag(EM2RS.PARAM.VELOTOC.tag,     Prefix+'.VELOTOC',         1); { $00A3 Vel swtch pnt: O to C loop *  }
  InitTag(EM2RS.PARAM.VELCTOO.tag,     Prefix+'.VELCTOO',         1); { $00A5 Vel swtch pnt: C to O loop *  }
  InitTag(EM2RS.PARAM.DELAYOTOC.tag,   Prefix+'.DELAYOTOC',       1); { $00A7 Delay of O to C loop *        }
  InitTag(EM2RS.PARAM.DELAYCTOO.tag,   Prefix+'.DELAYCTOO',       1); { $00A9 Delay of C to O loop *        }
  InitTag(EM2RS.PARAM.CFGINPUT1.tag,   Prefix+'.CFGINPUT1',       1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGI1_NC.tag,    Prefix+'.CFGINPUT1.NC',    1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGINPUT2.tag,   Prefix+'.CFGINPUT2',       1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGI2_NC.tag,    Prefix+'.CFGINPUT2.NC',    1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGINPUT3.tag,   Prefix+'.CFGINPUT3',       1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGI3_NC.tag,    Prefix+'.CFGINPUT3.NC',    1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGINPUT4.tag,   Prefix+'.CFGINPUT4',       1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGI4_NC.tag,    Prefix+'.CFGINPUT4.NC',    1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGINPUT5.tag,   Prefix+'.CFGINPUT5',       1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGI5_NC.tag,    Prefix+'.CFGINPUT5.NC',    1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGINPUT6.tag,   Prefix+'.CFGINPUT6',       1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGI6_NC.tag,    Prefix+'.CFGINPUT6.NC',    1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGINPUT7.tag,   Prefix+'.CFGINPUT7',       1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGI7_NC.tag,    Prefix+'.CFGINPUT7.NC',    1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGOUTPUT1.tag,  Prefix+'.CFGOUTPUT1',      1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGO1_NC.tag,    Prefix+'.CFGOUTPUT1.NC',   1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGOUTPUT2.tag,  Prefix+'.CFGOUTPUT2',      1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGO2_NC.tag,    Prefix+'.CFGOUTPUT2.NC',   1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGOUTPUT3.tag,  Prefix+'.CFGOUTPUT3',      1); { I/O Config                          }
  InitTag(EM2RS.PARAM.CFGO3_NC.tag,    Prefix+'.CFGOUTPUT3.NC',   1); { I/O Config                          }
  InitTag(EM2RS.PARAM.ALRMDETECT.tag,  Prefix+'.ALRMDETECT',      1); { $016D Alarm detection selection     }
  InitTag(EM2RS.PARAM.DIST2SEND.tag,   Prefix+'.DIST2SEND',       1); { $0171 Dist. 2send "In Pos" Out sign }
  InitTag(EM2RS.PARAM.BUSVOLT.tag,     Prefix+'.BUSVOLT',         2); { $0177 Bus Voltage                   }
  InitTag(EM2RS.PARAM.DISTATUS.tag,    Prefix+'.DISTATUS',        1); { $0179 Digital Input Status          }
  InitTag(EM2RS.PARAM.DOSTATUS.tag,    Prefix+'.DOSTATUS',        1); { $017B Digital Output Status         }
  InitTag(EM2RS.PARAM.PEAKCUR.tag,     Prefix+'.PEAKCUR',         2); { $0191 Peak Current                  }
  InitTag(EM2RS.PARAM.HOLDINCLSD.tag,  Prefix+'.HOLDINCLSD',      1); { $0193 % of hold curr in closed-loop }
  InitTag(EM2RS.PARAM.HOLDINOPEN.tag,  Prefix+'.HOLDINOPEN',      1); { $0195 % of hold curr in open-loop   }
  InitTag(EM2RS.PARAM.BAUDRATE.tag,    Prefix+'.BAUDRATE',        1); { $01BD Baudrate                      }
  InitTag(EM2RS.PARAM.ADDRESS.tag,     Prefix+'.ADDRESS',         1); { $01BF RS485 ID                      }
  InitTag(EM2RS.PARAM.RS485TYPE.tag,   Prefix+'.RS485TYPE',       1); { $01C1 RS485 Data type selection     }
  InitTag(EM2RS.PARAM.STBCURPER.tag,   Prefix+'.STBCURPER',       1); { $01D3 Standby Current Percentage    }
  InitTag(EM2RS.PARAM.JOGVEL.tag,      Prefix+'.JOGVEL',          1); { $01E1 JOG Velocity                  }
  InitTag(EM2RS.PARAM.JOGINTER.tag,    Prefix+'.JOGINTER',        1); { $01E3 Interval                      }
  InitTag(EM2RS.PARAM.JOGRUNTIME.tag,  Prefix+'.JOGRUNTIME',      1); { $01E5 Running times                 }
  InitTag(EM2RS.PARAM.JOGACCDEC.tag,   Prefix+'.JOGACCDEC',       1); { $01E7 Acc/Dec. time                 }
  InitTag(EM2RS.PARAM.SOFTWARE.tag,    Prefix+'.SOFTWARE',        1); { $01FF Version Information           }
  InitTag(EM2RS.PARAM.FIRMWARE.tag,    Prefix+'.FIRMWARE',        1); { $0201 Firmare Version               }
  InitTag(EM2RS.PARAM.ENCODERES.tag,   Prefix+'.ENCODERES',       1); { $0233 Encoder resolution            }
  InitTag(EM2RS.PARAM.MOTSTATUS.tag,   Prefix+'.MOTSTATUS',       1); { $1003 Motion Status                 }
  InitTag(EM2RS.PARAM.SAVEWORD.tag,    Prefix+'.SAVEWORD',        1); { $1901 Save parameter status word    }
  InitTag(EM2RS.PARAM.CTRLWORD.tag,    Prefix+'.CTRLWORD',        1); { $1801 Control word                  }
  InitTag(EM2RS.PARAM.CURALARM.tag,    Prefix+'.CURALARM',        1); { $2203 Current alarm                 }
  InitTag(EM2RS.PARAM.PRCONTROL.tag,   Prefix+'.PRCONTROL',       1); { $6000 PR control register           }
  InitTag(EM2RS.PARAM.TRIGGER.tag,     Prefix+'.TRIGGER',         1); { $6002 Trigger register              }
  InitTag(EM2RS.PARAM.SOFTLIMPOS.tag,  Prefix+'.SOFTLIMPOS',      1); { $6006+$6007 Soft limit positive     }
  InitTag(EM2RS.PARAM.SOFTLIMNEG.tag,  Prefix+'.SOFTLIMNEG',      1); { $6008+$6009 Soft limit positive     }
  InitTag(EM2RS.PARAM.HOMINGMODE.tag,  Prefix+'.HOMINGMODE',      1); { $600A Homing mode                   }
  InitTag(EM2RS.PARAM.AFTERHOMING.tag, Prefix+'.AFTERHOMING',     1); { $600D+$600E Move after homing       }
  InitTag(EM2RS.PARAM.HOMHIGHVEL.tag,  Prefix+'.HOMHIGHVEL',      1); { $600F Homing hight velocity         }
  InitTag(EM2RS.PARAM.HOMLOWVEL.tag,   Prefix+'.HOMLOWVEL',       1); { $6010 Homing low velocity           }
  InitTag(EM2RS.PARAM.HOMINGACC.tag,   Prefix+'.HOMINGACC',       1); { $6011 Homing Acc                    }
  InitTag(EM2RS.PARAM.HOMINGDEC.tag,   Prefix+'.HOMINGDEC',       1); { $6012 Homing Dec                    }
  InitTag(EM2RS.PARAM.LIMSTOPTIME.tag, Prefix+'.LIMSTOPTIME',     1); { $6016 Limit stop time               }
  InitTag(EM2RS.PARAM.ESTOPTIME.tag,   Prefix+'.ESTOPTIME',       1); { $6017 E-STOP time                   }
  InitTag(EM2RS.PARAM.ACTPOS.tag,      Prefix+'.ACTPOS',          1); { $602C+$602D Actual position         }
  InitTag(EM2RS.PARAM.MOTPATH0.tag,    Prefix+'.MOTPATH0',        1); { $6200 Motion of path 0              }
  InitTag(EM2RS.PARAM.POSITION.tag,    Prefix+'.POSITION',        1); { $6201+$6202 Position                }
  InitTag(EM2RS.PARAM.SPEED.tag,       Prefix+'.SPEED',           1); { $6203 Velocity                      }
  InitTag(EM2RS.PARAM.ACCELERAT.tag,   Prefix+'.ACCELERAT',       1); { $6204 Acc                           }
  InitTag(EM2RS.PARAM.DECCELERAT.tag,  Prefix+'.DECCELERAT',      1); { $6205 Dec                           }
  InitTag(EM2RS.DEVLABEL.tag,          Prefix+'.GUI.DEVLABEL',    3); {                                     }
  InitTag(EM2RS.SPEEDUNIT.tag,         Prefix+'.GUI.SPEEDUNIT',   3); {                                     }
  InitTag(EM2RS.POSUNIT.tag,           Prefix+'.GUI.POSUNIT',     3); {                                     }
  InitTag(EM2RS.MOVUNIT.tag,           Prefix+'.GUI.MOVUNIT',     3); {                                     }
  InitTag(EM2RS.POSITION.tag,          Prefix+'.GUI.POSITION',    2); {                                     }
  InitTag(EM2RS.SPEED.tag,             Prefix+'.GUI.SPEED',       2); {                                     }
  InitTag(EM2RS.DESTINATION.tag,       Prefix+'.GUI.DESTINATION', 2); {                                     }
  InitTag(EM2RS.DIRECTFWD.tag,         Prefix+'.GUI.DIRECTFWD',   1); {                                     }
  InitTag(EM2RS.DIRECTBWD.tag,         Prefix+'.GUI.DIRECTBWD',   1); {                                     }
  InitTag(EM2RS.MOVE.tag,              Prefix+'.GUI.MOVE',        1); {                                     }
  InitTag(EM2RS.HOMING.tag,            Prefix+'.GUI.HOMING',      1); {                                     }
  InitTag(EM2RS.ESTOP.tag,             Prefix+'.GUI.ESTOP',       1); {                                     }
  InitTag(EM2RS.SETZERO.tag,           Prefix+'.GUI.SETZERO',     1); {                                     }
  InitTag(EM2RS.POSLIMIT.tag,          Prefix+'.GUI.POSLIMIT',    1); {                                     }
  InitTag(EM2RS.NEGLIMIT.tag,          Prefix+'.GUI.NEGLIMIT',    1); {                                     }
  InitTag(EM2RS.POLL.ENABLE.tag,       Prefix+'.POLL.ENABLE',     1); {                                     }
  InitTag(EM2RS.SERVID.tag,            Prefix+'.SERVID',          3); {                                     }
  InitTag(EM2RS.CLOCK.tag,             Prefix+'.CLOCK',           3); {                                     }
  InitTag(EM2RS.POLL.ENABLE.tag,       Prefix+'.POLL.ENABLE',     1); {                                     }
  InitTag(EM2RS.POLLRATE.RX.tag,       Prefix+'.POLLRATE.RX',     2); {                                     }
  InitTag(EM2RS.POLLRATE.TX.tag,       Prefix+'.POLLRATE.TX',     2); {                                     }
  InitTag(EM2RS.POLLRATE.EX.tag,       Prefix+'.POLLRATE.EX',     2); {                                     }
  InitTag(EM2RS.ERROR.COUNT.tag,       Prefix+'.ERROR.COUNT',     2); {                                     }
  InitTag(EM2RS.POLLSUMM.RX.tag,       Prefix+'.POLLSUMM.RX',     2); {                                     }
  InitTag(EM2RS.POLLSUMM.TX.tag,       Prefix+'.POLLSUMM.TX',     2); {                                     }
  InitTag(EM2RS.POLLSUMM.EX.tag,       Prefix+'.POLLSUMM.EX',     2); {                                     }
 end;
 //
 // EM2RS Driver cleanup.
 //
 procedure EM2RS_Clear;
 begin
  EM2RS.Simulator:=False;
  EM2RS.Modbus.Port:=0;
  EM2RS.Modbus.UnitId:=0;
  EM2RS.Modbus.Timeout:=0;
  EM2RS.Modbus.Polling:=0;
  EM2RS.Modbus.Deadline:=0;
  ClearModbusPoll;
  ClearModbusSumm;
  ClearModbusRate;
  ClearCmdTable;
  tagPrefix:='';
  EM2RS.SelfId:='';
 end;
 //
 // EM2RS Driver initialization...
 //
 procedure EM2RS_Init;
  {
  Upcase first symbol in string
  }
  function CapFirstLetter(s:String):String;
  begin
   CapFirstLetter:=upcasestr(StrFetch(s,1))+Copy(s,2,Length(s)-1);
  end;
 begin
  //
  // Read ini file variables
  //
  EM2RS_InitTags(tagPrefix);
  EM2RS.Simulator:=iValDef(AdaptFileName(ReadIni('Simulator')),0)<>0; Success('Simulator='+Str(Ord(EM2RS.Simulator)));
  EM2RS.Modbus.Port:=iValDef(AdaptFileName(ReadIni('ModbusPort')),1); Success('ModbusPort='+Str(EM2RS.Modbus.Port));
  EM2RS.Modbus.UnitId:=iValDef(AdaptFileName(ReadIni('ModbusUnitId')),1); Success('ModbusUnitId='+Str(EM2RS.Modbus.UnitId));
  EM2RS.Modbus.Polling:=iValDef(AdaptFileName(ReadIni('ModbusPolling')),1000); Success('ModbusPolling='+Str(EM2RS.Modbus.Polling));
  EM2RS.Modbus.Timeout:=iValDef(AdaptFileName(ReadIni('ModbusTimeout')),250); Success('ModbusTimeout='+Str(EM2RS.Modbus.Timeout));
  EM2RS.Modbus.Deadline:=iValDef(AdaptFileName(ReadIni('ModbusDeadline')),60000); Success('ModbusDeadline='+Str(EM2RS.Modbus.Deadline));
  EM2RS.Modbus.DelayOnStart:=iValDef(AdaptFileName(ReadIni('DelayOnStart')),1000); Success('DelayOnStart='+Str(EM2RS.Modbus.DelayOnStart));
  if not DIM_IsClientMode then
  if not EM2RS.Simulator then
   if IsRefDevice(RefFind('Device '+ModbusProxy)) then Success(ModbusProxy+' device found') else Trouble(ModbusProxy+' device not found!');
  if DIM_IsServerMode then Success('Run as Server') else if DIM_IsClientMode then Success('Run as Client');
  if not DIM_IsClientMode then begin
   bNul(sSetTag(EM2RS.DEVLABEL.tag,CapFirstLetter(loCaseStr(StringReplace(RightPad(ReadIni('DevLabel'),23,' '),'_',' ',rfReplaceAll)))));
   bNul(sSetTag(EM2RS.SPEEDUNIT.tag,loCaseStr(AdaptFileName(ReadIni('SpeedUnit')))));
   bNul(sSetTag(EM2RS.POSUNIT.tag,loCaseStr(AdaptFileName(ReadIni('PosUnit')))));
   bNul(sSetTag(EM2RS.MOVUNIT.tag,loCaseStr(AdaptFileName(ReadIni('MovUnit')))));
  end;
  {
  Server Identifier.
  }
  if DIM_IsServerMode
  then EM2RS.SelfId:=Str(getpid)+'@'+ParamStr('HostName')
  else EM2RS.SelfId:=Str(getpid)+'@'+ParamStr('ComputerName');
  {
  Colors
  }
  ColorNorm:=clAqua;
  if DIM_IsServerMode then ColorNorm:=clLime;
  if DIM_IsClientMode then ColorNorm:=clLime;
  ColorWarn:=clYellow;
  bNul(SetTagColor(EM2RS.SERVID.tag,ColorNorm));
  bNul(SetTagColor(EM2RS.CLOCK.tag,ColorNorm));
  EM2RS.SIM.PULSE:=200;
  EM2RS.SIM.CTRLMODE:=2;
  EM2RS.SIM.MOTDIRECT:=1;
  EM2RS.SIM.POSERROR:=4000;
  EM2RS.SIM.FORCED:=4000;
  EM2RS.SIM.POSLOOPKP:=507;
  EM2RS.SIM.VELLOOPKI:=3;
  EM2RS.SIM.VELLOOPKP:=507;
  EM2RS.SIM.POSLOOPKPH:=0;
  EM2RS.SIM.CMDTIME:=15;
  EM2RS.SIM.VELOTOC:=18;
  EM2RS.SIM.VELCTOO:=12;
  EM2RS.SIM.DELAYOTOC:=5;
  EM2RS.SIM.DELAYCTOO:=250;
  EM2RS.SIM.CFGINPUT1:=136;
  EM2RS.SIM.CFGI1_NC:=1;
  EM2RS.SIM.CFGINPUT2:=33;
  EM2RS.SIM.CFGINPUT5:=37;
  EM2RS.SIM.CFGINPUT6:=38;
  EM2RS.SIM.BUSVOLT:=240;
  EM2RS.SIM.DISTATUS:=1;
  EM2RS.SIM.PEAKCUR:=28;
  EM2RS.SIM.HOLDINCLSD:=50;
  EM2RS.SIM.HOLDINOPEN:=50;
  EM2RS.SIM.BAUDRATE:=4;
  EM2RS.SIM.ADDRESS:=1;
  EM2RS.SIM.RS485TYPE:=4;
  EM2RS.SIM.STBCURPER:=50;
  EM2RS.SIM.JOGVEL:=60;
  EM2RS.SIM.JOGINTER:=100;
  EM2RS.SIM.JOGRUNTIME:=1;
  EM2RS.SIM.JOGACCDEC:=200;
  EM2RS.SIM.ENCODERES:=4000;
  EM2RS.SIM.SOFTWARE:=111;
  EM2RS.SIM.FIRMWARE:=12316;
  EM2RS.SIM.FIRMWARE:=12316;
  EM2RS.SIM.MOTSTATUS:=50;
  EM2RS.SIM.SAVEWORD:=4369;
  EM2RS.SIM.SOFTLIMPOS:=2147483647;
  EM2RS.SIM.SOFTLIMNEG:=-2147483647;
  EM2RS.SIM.HOMINGMODE:=2;
  EM2RS.SIM.AFTERHOMING:=1000;
  EM2RS.SIM.HOMHIGHVEL:=200;
  EM2RS.SIM.HOMLOWVEL:=50;
  EM2RS.SIM.HOMINGACC:=100;
  EM2RS.SIM.HOMINGDEC:=100;
  EM2RS.SIM.LIMSTOPTIME:=1103;
  EM2RS.SIM.ESTOPTIME:=987465;
  EM2RS.SIM.ACTPOS:=0;
  EM2RS.SIM.MOTPATH0:=mode_Speed;
  EM2RS.SIM.POSITION:=200;
  EM2RS.SIM.SPEED:=12;
  EM2RS.SIM.ACCELERAT:=100;
  EM2RS.SIM.DECCELERAT:=100;
  SetPointChckStt:=0; SetPointChckTim:=0; spcParEnab:=-1;
  StartMoveStat:=0; StartMoveTime:=0;
  //
  // Initialize Cmd command table & clear Poll record.
  //
  ClearModbusPoll;
  ClearModbusSumm;
  ClearModbusRate;
  InitCmdTable;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearNetLibrary;
  EM2RS_Clear;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  //
  // Standard initializations.
  //
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  InitNetLibrary;
  tagPrefix:=AdaptFileName(ReadIni('tagPrefix'));
  EM2RS_Init;
  if Val(AdaptFileName(ReadIni('CustomIniAutoLoad')))=1 then DevPostCmdLocal('@LoadIni');
  //
  // StdIn Command registration.
  //
  cmd_mbReply         :=RegisterStdInCmd('@Modbus.Reply','');
  cmd_mbPoll          :=RegisterStdInCmd('@Modbus.Poll','');
  cmd_mbRefuse        :=RegisterStdInCmd('@Modbus.Refuse','');
  cmd_mbTimeout       :=RegisterStdInCmd('@Modbus.Timeout','');
  cmd_mbClrSumm       :=RegisterStdInCmd('@ClearModbusSumm','');
  cmd_param           :=RegisterStdInCmd('@PARAM','');
  cmd_guiSpeed        :=RegisterStdInCmd('@SPEED','');
  cmd_guiDestination  :=RegisterStdInCmd('@DESTINATION','');
  cmd_actForward      :=RegisterStdInCmd('@FORWARD','');
  cmd_actBackward     :=RegisterStdInCmd('@BACKWARD','');
  cmd_actMove         :=RegisterStdInCmd('@MOVE','');
  cmd_actStop         :=RegisterStdInCmd('@STOP','');
  cmd_actEstop        :=RegisterStdInCmd('@ESTOP','');
  cmd_Edit            :=RegisterStdInCmd('@Edit','');
  cmd_DimTagUpdate    :=RegisterStdInCmd('@DimTagUpdate','');
  cmd_AssignTag       :=RegisterStdInCmd('@AssignTag','');
  cmd_LoadIni         :=RegisterStdInCmd('@LoadIni','');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(AdaptFileName(ReadIni('CustomIniAutoSave')))=1 then iNul(CustomIniRW('W','',2));
  FreeNetLibrary;
  ClearModbusPoll;
  ClearModbusSumm;
  ClearModbusRate;
  ClearCmdTable;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  PollNetLibrary;
  GUIHandler;
  GetLimiters;
  if (iGetTag(EM2RS.PARAM.STATE.tag)=st_NORMAL) or (iGetTag(EM2RS.PARAM.STATE.tag)=st_SIMULAT) then GUIControl;
  if mSecNow-FixmSecNow>EM2RS.Modbus.DelayOnStart then
  if IsPortOpened then begin
   if EM2RS.Simulator then EM2RS_SIM_POLL;
   EM2RS_CMD_POLL;
   EM2RS_MOVE_POLL;
  end;
  {
  Update Host Date-Time.
  }
  if DIM_IsServerMode then begin
   if (SysTimer_Pulse(1000)>0) then begin
    bNul(sSetTag(EM2RS.SERVID.tag,EM2RS.SelfId));
    bNul(sSetTag(EM2RS.CLOCK.tag,GetDateTime(mSecNow)));
    bNul(SetTagColor(EM2RS.SERVID.tag,ColorNorm));
    bNul(SetTagColor(EM2RS.CLOCK.tag,ColorNorm));
   end;
  end;
  if DIM_IsClientMode then begin
   if (ShouldRefresh(EM2RS.CLOCK.dat,GetStampOfTag(EM2RS.CLOCK.tag,0))>0) then begin
    bNul(SetTagColor(EM2RS.SERVID.tag,ColorNorm));
    bNul(SetTagColor(EM2RS.CLOCK.tag,ColorNorm));
    EM2RS.CLOCK.tim:=mSecNow;
   end;
   if (SysTimer_Pulse(1000)>0) then
   if (mSecNow-EM2RS.CLOCK.tim>DimDeadline) then begin
    bNul(sSetTag(EM2RS.SERVID.tag,'Server Disconnected'));
    bNul(SetTagColor(EM2RS.SERVID.tag,ColorWarn));
    bNul(SetTagColor(EM2RS.CLOCK.tag,ColorWarn));
   end;
  end;
  DimUpdateState;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,dat,par:String; cmdid,ref,cid,tim,port,uid,fid:Integer;
  //
  // Update device parameters by ini-file load
  //
  procedure EM2RSUpdatePar;
  begin
   DevPostCmdLocal('@PARAM PULSE '       +Str(iGetTag(EM2RS.PARAM.PULSE.tag)));
   DevPostCmdLocal('@PARAM CTRLMODE '    +Str(iGetTag(EM2RS.PARAM.CTRLMODE.tag)));
   DevPostCmdLocal('@PARAM MOTDIRECT '   +Str(iGetTag(EM2RS.PARAM.MOTDIRECT.tag)));
   DevPostCmdLocal('@PARAM POSERROR '    +Str(iGetTag(EM2RS.PARAM.POSERROR.tag)));
   DevPostCmdLocal('@PARAM FORCED '      +Str(iGetTag(EM2RS.PARAM.FORCED.tag)));
   DevPostCmdLocal('@PARAM POSLOOPKP '   +Str(iGetTag(EM2RS.PARAM.POSLOOPKP.tag)));
   DevPostCmdLocal('@PARAM VELLOOPKI '   +Str(iGetTag(EM2RS.PARAM.VELLOOPKI.tag)));
   DevPostCmdLocal('@PARAM VELLOOPKP '   +Str(iGetTag(EM2RS.PARAM.VELLOOPKP.tag)));
   DevPostCmdLocal('@PARAM POSLOOPKPH '  +Str(iGetTag(EM2RS.PARAM.POSLOOPKPH.tag)));
   DevPostCmdLocal('@PARAM CMDTIME '     +Str(iGetTag(EM2RS.PARAM.CMDTIME.tag)));
   DevPostCmdLocal('@PARAM VELOTOC '     +Str(iGetTag(EM2RS.PARAM.VELOTOC.tag)));
   DevPostCmdLocal('@PARAM VELCTOO '     +Str(iGetTag(EM2RS.PARAM.VELCTOO.tag)));
   DevPostCmdLocal('@PARAM DELAYOTOC '   +Str(iGetTag(EM2RS.PARAM.DELAYOTOC.tag)));
   DevPostCmdLocal('@PARAM DELAYCTOO '   +Str(iGetTag(EM2RS.PARAM.DELAYCTOO.tag)));
   DevPostCmdLocal('@PARAM CFGINPUT1 '   +Str(iGetTag(EM2RS.PARAM.CFGINPUT1.tag)));
   DevPostCmdLocal('@PARAM CFGINPUT2 '   +Str(iGetTag(EM2RS.PARAM.CFGINPUT2.tag)));
   DevPostCmdLocal('@PARAM CFGINPUT3 '   +Str(iGetTag(EM2RS.PARAM.CFGINPUT3.tag)));
   DevPostCmdLocal('@PARAM CFGINPUT4 '   +Str(iGetTag(EM2RS.PARAM.CFGINPUT4.tag)));
   DevPostCmdLocal('@PARAM CFGINPUT5 '   +Str(iGetTag(EM2RS.PARAM.CFGINPUT5.tag)));
   DevPostCmdLocal('@PARAM CFGINPUT6 '   +Str(iGetTag(EM2RS.PARAM.CFGINPUT6.tag)));
   DevPostCmdLocal('@PARAM CFGINPUT7 '   +Str(iGetTag(EM2RS.PARAM.CFGINPUT7.tag)));
   DevPostCmdLocal('@PARAM CFGOUTPUT1 '  +Str(iGetTag(EM2RS.PARAM.CFGOUTPUT1.tag)));
   DevPostCmdLocal('@PARAM CFGOUTPUT2 '  +Str(iGetTag(EM2RS.PARAM.CFGOUTPUT2.tag)));
   DevPostCmdLocal('@PARAM CFGOUTPUT3 '  +Str(iGetTag(EM2RS.PARAM.CFGOUTPUT3.tag)));
   DevPostCmdLocal('@PARAM ALRMDETECT '  +Str(iGetTag(EM2RS.PARAM.ALRMDETECT.tag)));
   DevPostCmdLocal('@PARAM DIST2SEND '   +Str(iGetTag(EM2RS.PARAM.DIST2SEND.tag)));
   DevPostCmdLocal('@PARAM BUSVOLT '     +Str(iGetTag(EM2RS.PARAM.BUSVOLT.tag)));
   DevPostCmdLocal('@PARAM PEAKCUR '     +Str(rGetTag(EM2RS.PARAM.PEAKCUR.tag)));
   DevPostCmdLocal('@PARAM HOLDINCLSD '  +Str(rGetTag(EM2RS.PARAM.HOLDINCLSD.tag)));
   DevPostCmdLocal('@PARAM HOLDINOPEN '  +Str(rGetTag(EM2RS.PARAM.HOLDINOPEN.tag)));
   DevPostCmdLocal('@PARAM STBCURPER '   +Str(iGetTag(EM2RS.PARAM.STBCURPER.tag)));
   DevPostCmdLocal('@PARAM JOGVEL '      +Str(iGetTag(EM2RS.PARAM.JOGVEL.tag)));
   DevPostCmdLocal('@PARAM JOGINTER '    +Str(iGetTag(EM2RS.PARAM.JOGINTER.tag)));
   DevPostCmdLocal('@PARAM JOGRUNTIME '  +Str(iGetTag(EM2RS.PARAM.JOGRUNTIME.tag)));
   DevPostCmdLocal('@PARAM JOGACCDEC '   +Str(iGetTag(EM2RS.PARAM.JOGACCDEC.tag)));
   DevPostCmdLocal('@PARAM ENCODERES '   +Str(iGetTag(EM2RS.PARAM.ENCODERES.tag)));
   DevPostCmdLocal('@PARAM CTRLWORD '    +Str(iGetTag(EM2RS.PARAM.CTRLWORD.tag)));
   DevPostCmdLocal('@PARAM PRCONTROL '   +Str(iGetTag(EM2RS.PARAM.PRCONTROL.tag)));
   DevPostCmdLocal('@PARAM TRIGGER '     +Str(iGetTag(EM2RS.PARAM.TRIGGER.tag)));
   DevPostCmdLocal('@PARAM SOFTLIMPOS '  +Str(iGetTag(EM2RS.PARAM.SOFTLIMPOS.tag)));
   DevPostCmdLocal('@PARAM SOFTLIMNEG '  +Str(iGetTag(EM2RS.PARAM.SOFTLIMNEG.tag)));
   DevPostCmdLocal('@PARAM HOMINGMODE '  +Str(iGetTag(EM2RS.PARAM.HOMINGMODE.tag)));
   DevPostCmdLocal('@PARAM AFTERHOMING ' +Str(iGetTag(EM2RS.PARAM.AFTERHOMING.tag)));
   DevPostCmdLocal('@PARAM HOMHIGHVEL '  +Str(iGetTag(EM2RS.PARAM.HOMHIGHVEL.tag)));
   DevPostCmdLocal('@PARAM HOMLOWVEL '   +Str(iGetTag(EM2RS.PARAM.HOMLOWVEL.tag)));
   DevPostCmdLocal('@PARAM HOMINGACC '   +Str(iGetTag(EM2RS.PARAM.HOMINGACC.tag)));
   DevPostCmdLocal('@PARAM HOMINGDEC '   +Str(iGetTag(EM2RS.PARAM.HOMINGDEC.tag)));
   DevPostCmdLocal('@PARAM LIMSTOPTIME ' +Str(iGetTag(EM2RS.PARAM.LIMSTOPTIME.tag)));
   DevPostCmdLocal('@PARAM ESTOPTIME '   +Str(iGetTag(EM2RS.PARAM.ESTOPTIME.tag)));
   DevPostCmdLocal('@PARAM MOTPATH0 '    +Str(iGetTag(EM2RS.PARAM.MOTPATH0.tag)));
   DevPostCmdLocal('@PARAM POSITION '    +Str(iGetTag(EM2RS.PARAM.POSITION.tag)));
   DevPostCmdLocal('@PARAM SPEED '       +Str(iGetTag(EM2RS.PARAM.SPEED.tag)));
   DevPostCmdLocal('@PARAM ACCELERAT '   +Str(iGetTag(EM2RS.PARAM.ACCELERAT.tag)));
   DevPostCmdLocal('@PARAM DECCELERAT '  +Str(iGetTag(EM2RS.PARAM.DECCELERAT.tag)));
  end;
  procedure Cleanup;
  begin
   cmd:=''; arg:=''; dat:=''; par:='';
  end;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  Cleanup;
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @Modbus.Reply ref cid tim port uid fid $$dat
   }
   if (cmdid = cmd_mbReply) then begin
    if modbus_proxy_reply(cmd,arg,ref,cid,tim,port,uid,fid,dat)
    then EM2RS_OnReply(ref,cid,tim,port,uid,fid,dat)
    else Trouble(GotBug('Bad '+cmd+' format'));
    ClearModbusPoll;
    Data:='';
   end else
   {
   @Modbus.Poll ref cid tim port uid fid $$dat
   This message uses in simulation mode only
   }
   if (cmdid = cmd_mbPoll) then begin
    if modbus_proxy_reply(cmd,arg,ref,cid,tim,port,uid,fid,dat)
    then EM2RS_OnSimPoll(ref,cid,tim,port,uid,fid,dat)
    else Trouble(GotBug('Bad '+cmd+' format'));
    Data:='';
   end else
   {
   @Modbus.Refuse ...
   }
   if (cmdid = cmd_mbRefuse) then begin
    if modbus_proxy_reply(cmd,arg,ref,cid,tim,port,uid,fid,dat)
    then Trouble(GotBug(modbus_proxy_nice(cmd,ref,cid,tim,port,uid,fid,dat,0)))
    else Trouble(GotBug(cmd+' '+arg));
    UpdateDo(do_STATE_INDIC,time,st_REFUSE); bNul(iSetTag(EM2RS.PARAM.STATE.tag,st_REFUSE));
    ClearModbusPoll;
    SetPointChckStt:=1;
    SetPointChckTim:=mSecNow;
    Data:='';
   end else
   {
   @Modbus.Timeout ...
   }
   if (cmdid = cmd_mbTimeout) then begin
    if modbus_proxy_reply(cmd,arg,ref,cid,tim,port,uid,fid,dat)
    then Problem(GotBug(modbus_proxy_nice(cmd,ref,cid,tim,port,uid,fid,dat,64)))
    else Trouble(GotBug(cmd+' '+arg));
    UpdateDo(do_STATE_INDIC,time,st_TIMEOUT); bNul(iSetTag(EM2RS.PARAM.STATE.tag,st_TIMEOUT));
    ClearModbusPoll;
    SetPointChckStt:=1;
    SetPointChckTim:=mSecNow;
    Data:='';
   end else
   {
   @ClearModbusSumm
   }
   if (cmdid = cmd_mbClrSumm) then begin
    if not DIM_IsClientMode then ClearModbusSumm;
    Data:='';
   end else
   {
   @PARAM NAME VALUE
   }
   if (cmdid = cmd_param) then begin
    if isSameText(ExtractWord(1,arg),'SPEED')        then localSpeed:=rVal(ExtractWord(2,arg));
    if isSameText(ExtractWord(1,arg),'POSITION')     then localSpeed:=rVal(ExtractWord(2,arg));
    if not DIM_IsClientMode then begin
     if isSameText(ExtractWord(1,arg),'PULSE') then begin
      HoldCmdOpData(cm_WritPulse,rVal(ExtractWord(2,arg)));
      // Это костыль: параметр $0001 Pulse/Revolution применяется на контроллере только при перезаписи регистра $6201
      HoldCmdOpData(cm_WritPosition,iGetTag(EM2RS.PARAM.POSITION.tag));
     end else
     if isSameText(ExtractWord(1,arg),'CTRLMODE')    then HoldCmdOpData(cm_WritCtrlMode,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'MOTDIRECT')   then HoldCmdOpData(cm_WritMotDirect,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'POSERROR')    then HoldCmdOpData(cm_WritPosError,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'FORCED')      then HoldCmdOpData(cm_WritForced,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'POSLOOPKP')   then HoldCmdOpData(cm_WritPosLoopKp,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'VELLOOPKI')   then HoldCmdOpData(cm_WritVelLoopKi,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'VELLOOPKP')   then HoldCmdOpData(cm_WritVelLoopKp,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'POSLOOPKPH')  then HoldCmdOpData(cm_WritPosLoopKph,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'CMDTIME')     then HoldCmdOpData(cm_WritCmdTime,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'VELOTOC')     then HoldCmdOpData(cm_WritVelOtoC,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'VELCTOO')     then HoldCmdOpData(cm_WritVelCtoO,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'DELAYOTOC')   then HoldCmdOpData(cm_WritDelayOtoC,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'DELAYCTOO')   then HoldCmdOpData(cm_WritDelayCtoO,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'CFGINPUT1')   then HoldCmdOpData(cm_WritCfgInput1,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'CFGINPUT2')   then HoldCmdOpData(cm_WritCfgInput2,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'CFGINPUT3')   then HoldCmdOpData(cm_WritCfgInput3,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'CFGINPUT4')   then HoldCmdOpData(cm_WritCfgInput4,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'CFGINPUT5')   then HoldCmdOpData(cm_WritCfgInput5,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'CFGINPUT6')   then HoldCmdOpData(cm_WritCfgInput6,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'CFGINPUT7')   then HoldCmdOpData(cm_WritCfgInput7,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'CFGOUTPUT1')  then HoldCmdOpData(cm_WritCfgOutput1,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'CFGOUTPUT2')  then HoldCmdOpData(cm_WritCfgOutput2,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'CFGOUTPUT3')  then HoldCmdOpData(cm_WritCfgOutput3,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'ALRMDETECT')  then HoldCmdOpData(cm_WritAlrmDetect,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'DIST2SEND')   then HoldCmdOpData(cm_WritDist2Send,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'BUSVOLT')     then HoldCmdOpData(cm_WritBusVolt,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'PEAKCUR')     then HoldCmdOpData(cm_WritPeakCur,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'HOLDINCLSD')  then HoldCmdOpData(cm_WritHoldInClsd,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'HOLDINOPEN')  then HoldCmdOpData(cm_WritHoldInOpen,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'STBCURPER')   then HoldCmdOpData(cm_WritStbCurPer,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'JOGVEL')      then HoldCmdOpData(cm_WritJOGvel,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'JOGINTER')    then HoldCmdOpData(cm_WritJOGinter,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'JOGRUNTIME')  then HoldCmdOpData(cm_WritJOGruntime,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'JOGACCDEC')   then HoldCmdOpData(cm_WritJOGaccDec,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'ENCODERES')   then HoldCmdOpData(cm_WritEncodeRes,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'CTRLWORD')    then HoldCmdOpData(cm_WritCtrlWord,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'PRCONTROL')   then HoldCmdOpData(cm_WritPRcontrol,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'TRIGGER')     then HoldCmdOpData(cm_WritTrigger,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'SOFTLIMPOS')  then HoldCmdOpData(cm_WritSoftLimPos,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'SOFTLIMNEG')  then HoldCmdOpData(cm_WritSoftLimNeg,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'AFTERHOMING') then HoldCmdOpData(cm_WritAfterHoming,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'HOMINGMODE')  then HoldCmdOpData(cm_WritHomingMode,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'HOMHIGHVEL')  then HoldCmdOpData(cm_WritHomHighVel,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'HOMLOWVEL')   then HoldCmdOpData(cm_WritHomLowVel,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'HOMINGACC')   then HoldCmdOpData(cm_WritHomingAcc,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'HOMINGDEC')   then HoldCmdOpData(cm_WritHomingDec,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'LIMSTOPTIME') then HoldCmdOpData(cm_WritLimStopTime,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'ESTOPTIME')   then HoldCmdOpData(cm_WritEStopTime,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'MOTPATH0')    then HoldCmdOpData(cm_WritMotPath0,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'POSITION')    then HoldCmdOpData(cm_WritPosition,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'SPEED')       then HoldCmdOpData(cm_WritSpeed,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'ACCELERAT')   then HoldCmdOpData(cm_WritAccel,rVal(ExtractWord(2,arg))) else
     if isSameText(ExtractWord(1,arg),'DECCELERAT')  then HoldCmdOpData(cm_WritDeccel,rVal(ExtractWord(2,arg)));
    end;
    Data:='';
   end else
   {
   @SPEED 1
   }
   if (cmdid = cmd_guiSpeed) then begin
    if not DIM_IsClientMode then HoldCmdOpData(cm_WritSpeed,rVal(ExtractWord(1,arg))*60/calibr(0,iGetTag(EM2RS.PARAM.PULSE.tag),0));
    Data:='';
   end else
   {
   @DESTINATION 1
   }
   if (cmdid = cmd_guiDestination) then begin
    bNul(rSetTag(EM2RS.DESTINATION.tag,rVal(ExtractWord(1,arg))));
    Data:='';
   end else
   {
   @FORWARD
   }
   if (cmdid = cmd_actForward) then begin
    DevPostCmdLocal('@MOVE');
    Data:='';
   end else
   {
   @BACKWARD
   }
   if (cmdid = cmd_actBackward) then begin
    DevPostCmdLocal('@MOVE BACKWARD');
    Data:='';
   end else
   {
   @MOVE (BACKWARD)
   }
   if (cmdid = cmd_actMove) then begin
    if IsEnabled then begin
     if (ExtractWord(1,arg)='BACKWARD') then begin
      if ((iGetTag(EM2RS.PARAM.SPEED.tag)<0) and IsRunning) then DevPostCmdLocal('@STOP')
      else begin
       if IsModeRelative then
       if iGetTag(EM2RS.PARAM.POSITION.tag)>0 then bNul(rSetTag(EM2RS.DESTINATION.tag, -rGetTag(EM2RS.DESTINATION.tag)));
       if iGetTag(EM2RS.PARAM.SPEED.tag)>0 then DevPostCmdLocal('@PARAM SPEED -'+str(abs(iGetTag(EM2RS.PARAM.SPEED.tag))));
       EM2RS.MovementDirection:=DirectionBackward;
      end;
     end else begin
      if ((iGetTag(EM2RS.PARAM.SPEED.tag)>0) and IsRunning) then DevPostCmdLocal('@STOP')
      else begin
       if IsModeRelative then
       if iGetTag(EM2RS.PARAM.POSITION.tag)<0 then bNul(rSetTag(EM2RS.DESTINATION.tag, abs(rGetTag(EM2RS.DESTINATION.tag))));
       if iGetTag(EM2RS.PARAM.SPEED.tag)<0 then DevPostCmdLocal('@PARAM SPEED '+str(abs(iGetTag(EM2RS.PARAM.SPEED.tag))));
       EM2RS.MovementDirection:=DirectionForward;
      end;
     end;
    end else ShowTooltip('text "Двигатель не включен (Включается активацией цифрового входа 1 (DI1))." delay 15000 preset stdWarning');
    if not DIM_IsClientMode then HoldCmdOpData(cm_WritPosition,
     rVal(ExtractWord(1,arg))*iGetTag(EM2RS.PARAM.PULSE.tag)/calibr(0,iGetTag(EM2RS.PARAM.PULSE.tag),0));
    Data:='';
   end else
   {
   @STOP
   }
   if (cmdid = cmd_actStop) then begin
    prevSpeed:=iGetTag(EM2RS.PARAM.SPEED.tag);
    DevPostCmdLocal('@PARAM SPEED 0');
    DevPostCmdLocal('@PARAM TRIGGER '+str(st_POSITIONING));
    Data:='';
   end else
   {
   @ESTOP
   }
   if (cmdid = cmd_actEstop) then begin
    DevPostCmdLocal('@PARAM TRIGGER '+str(st_STOP));
    Data:='';
   end else
   {
   @Edit PARAM.SPEED 1000
   @Edit PARAM.ACCELERAT 2800
   }
   if (cmdid = cmd_Edit) then begin
    par:=mime_decode(ExtractWord(2,arg));
    if IsSameText(ExtractWord(1,arg),'PARAM.PULSE')       then StartEditTagEx(EM2RS.PARAM.PULSE.tag,'Шагов в обороте',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.CTRLMODE')    then StartEditTagEx(EM2RS.PARAM.CTRLMODE.tag,'Режим контроля (энкодер)',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.POSERROR')    then StartEditTagEx(EM2RS.PARAM.POSERROR.tag,'Максимальное количество импульсов позиционной ошибки',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.BUSVOLT')     then StartEditTagEx(EM2RS.PARAM.BUSVOLT.tag,'Напряжение шины, Вольт',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.PEAKCUR')     then StartEditTagEx(EM2RS.PARAM.PEAKCUR.tag,'Пиковый ток, Ампер',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.HOLDINCLSD')  then StartEditTagEx(EM2RS.PARAM.HOLDINCLSD.tag,'Holding current, %',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.HOLDINOPEN')  then StartEditTagEx(EM2RS.PARAM.HOLDINOPEN.tag,'Holding current, %',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.STBCURPER')   then StartEditTagEx(EM2RS.PARAM.STBCURPER.tag,'Ток блокировки вала, %',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.JOGVEL')      then StartEditTagEx(EM2RS.PARAM.JOGVEL.tag,'Скорость ручного режима, об/мин',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.JOGINTER')    then StartEditTagEx(EM2RS.PARAM.JOGINTER.tag,'Интервал ручного режима, мс',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.JOGRUNTIME')  then StartEditTagEx(EM2RS.PARAM.JOGRUNTIME.tag,'Время работы ручного режима',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.JOGACCDEC')   then StartEditTagEx(EM2RS.PARAM.JOGACCDEC.tag,'Ускорение/замедление ручного режима',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.ENCODERES')   then StartEditTagEx(EM2RS.PARAM.ENCODERES.tag,'Разрешение энкодера, точек/об',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.AFTERHOMING') then StartEditTagEx(EM2RS.PARAM.AFTERHOMING.tag,'Двигаться к заданной позиции после нахождения базы',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.SOFTLIMPOS')  then StartEditTagEx(EM2RS.PARAM.SOFTLIMPOS.tag,'Програмное граничение максимальной позиции',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.SOFTLIMNEG')  then StartEditTagEx(EM2RS.PARAM.SOFTLIMNEG.tag,'Програмное ограничение минимальной позиции',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.HOMHIGHVEL')  then StartEditTagEx(EM2RS.PARAM.HOMHIGHVEL.tag,'Скорость первого сегмента, об/мин',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.HOMLOWVEL')   then StartEditTagEx(EM2RS.PARAM.HOMLOWVEL.tag,'Скорость второго сегмента, об/мин',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.HOMINGACC')   then StartEditTagEx(EM2RS.PARAM.HOMINGACC.tag,'Ускорение при поиске базы, мс/1000об/мин',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.HOMINGDEC')   then StartEditTagEx(EM2RS.PARAM.HOMINGDEC.tag,'Замедление при поиске базы, мс/1000об/мин',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.LIMSTOPTIME') then StartEditTagEx(EM2RS.PARAM.LIMSTOPTIME.tag,'Время останов. при достижении ограничения, мс',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.ESTOPTIME')   then StartEditTagEx(EM2RS.PARAM.ESTOPTIME.tag,'Время экстренной остановки, мс',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.POSITION')    then StartEditTagEx(EM2RS.PARAM.POSITION.tag,'Позиция, шаг',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.SPEED')       then StartEditTagEx(EM2RS.PARAM.SPEED.tag,'Скорость, об/мин',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.ACCELERAT')   then StartEditTagEx(EM2RS.PARAM.ACCELERAT.tag,'Ускорение, мс/1000об/мин',par);
    if IsSameText(ExtractWord(1,arg),'PARAM.DECCELERAT')  then StartEditTagEx(EM2RS.PARAM.DECCELERAT.tag,'Замедление, мс/1000об/мин',par);
    if IsSameText(ExtractWord(1,arg),'SPEED')             then StartEditTagEx(EM2RS.SPEED.tag,'Скорость, '+sGetTag(EM2RS.SPEEDUNIT.tag),par);
    if IsSameText(ExtractWord(1,arg),'DESTINATION')       then StartEditTagEx(EM2RS.DESTINATION.tag,'Перемещение, '+sGetTag(EM2RS.MOVUNIT.tag),par);
    Data:='';
   end else
   {
   @DimTagUpdate tag
   }
   if (cmdid = cmd_DimTagUpdate) then begin
    EM2RS_OnDimUpdateTag(arg);
    Data:='';
   end else
   {
   @AssignTag
   }
   if (cmdid = cmd_AssignTag) then begin
    EM2RS_OnAssignTag(arg);
    Data:='';
   end else
   {
   @LoadIni
   }
   if (cmdid = cmd_LoadIni) then begin
    if not EM2RS.Simulator then
    if CustomIniRW('R',arg,2*Ord(not IsEmptyStr(arg)))>0 then EM2RSUpdatePar;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  Cleanup;
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
