 {
 ***********************************************************************
 Daq Pascal application program _dllhost.
 ***********************************************************************
 * The purpose of _dllhost program is to handle DAQ plugin DLL: load,
 * initialize, call plugin on DAQ polling loop, and finally unload.
 * Program based on Standard Library functions: calls STD_DLL_INIT
 * directly, also STD_DLL_POLL and STD_DLL_FREE will be called
 * automatically by library code when needed.
 * The program code looks "empty", because most code hidden inside the
 * Standard Library, so user's code needs only STD_DLL_INIT call.
 ***********************************************************************
 * Algorithm:
 * 1) On application start:
 *    Initialize DLL  by call STD_DLL_INIT (directly).
 * 2) On each polling loop:
 *    Call DLL plugin by call STD_DLL_POLL (automatically).
 *    If StdIn_EnablePoll is set, process StdIn in DaqPascal,
 *    otherwise DLL plugin have to process StdIn itself.
 * 3) On application stop:
 *    Free DLL plugin by call STD_DLL_FREE (automatically).
 ***********************************************************************
 * Configuration:
 *  [DeviceList]
 *  &DEMO_DLL_HOST = device software program
 *  [&DEMO_DLL_HOST]
 *  ProgramSource = ~~/resource/daqsite/stdlib/daqpas/_dllhost.pas  ; Location of DLL host program
 *  DLL_FILE_PATH = demo_dll_min_plugin\demo_dll_min_plugin.dll     ; Location of DAQ plugin DLL
 *  StdIn_EnablePoll = 1 ; Enable StdIn polling in DaqPascal code, otherwise do it in plugin code
 *  … other parameters …
 *  []
 ***********************************************************************
 }
program _dllhost; { The HOST program to Load & Poll DAQ plugin DLL. }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 
type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  // Initialize DAQ plugin DLL:
  STD_DLL_INIT('DLL_FILE_PATH');
  // Enable StdIn polling in DaqPascal, otherwise in plugin code
  StdIn_EnablePoll:=(iValDef(ReadIni('StdIn_EnablePoll'),1)<>0);
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
  procedure Cleanup;
  begin
   cmd:=''; arg:='';
  end;
 begin
  Cleanup;
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  Cleanup;
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
