 {
 ***********************************************************************
 DIM_PING main control program.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @MenuToolsOpen - open Menu Tools dialog.
| @MenuConsolesOpen - open consoles menu.
| @MenuEditProgramOpen - open edit program menu.
| @MenuDeviceRestartOpen - open device restart menu.
| @DIM_CMND n,c  - receive ping number n with command c.
| @DIM_INFO n,d  - receive ping number n with informtion d.
| @RESET_COUNTS  - clear all counters.
| @PING_CONFIGS  - run DIM_PING configurator.
| @PING_REPORT c - ping report command c=(new,open,add,edit).
|********************************************************
[]
 }
 {
 [Compiler.Options]
 Compiler.dtabmax = 1024*48  ; Data segment
 Compiler.stabmax = 1024*8   ; String table
 Compiler.dtabmin = 1024*1   ; Min stack  space
 Compiler.stabmin = 512*1    ; Min string space
 []
 }
program dim_ping_main_ctrl;      { DIM_PING main control program    }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 SmilePeriod = 1000;             { Polling period for smile face    }
 AwakePeriod = 100;              { Period of checks to awake DatSrv }
 MaxNumServ  = 1000;             { Max number of services           }
 MinDataLen  = 16;               { Min DATALEN value                }
 MaxDataLen  = 8192;             { Max DATALEN value                }
 {------------------------------}{ Analog Outputs:                  }
 ao_PingHist        = 0;         { Ping time histogram              }
 ao_PingTime        = 1;         { Ping time ms                     }
 ao_dic_cmnd_rate   = 2;         { DIC_CMND_RATE                    }
 ao_dis_cmnd_rate   = 3;         { DIS_CMND_RATE                    }
 ao_dic_info_rate   = 4;         { DIC_INFO_RATE                    }
 ao_dis_info_rate   = 5;         { DIS_INFO_RATE                    }
 ao_dic_cmnd_b_rate = 6;         { DIC_CMND_B_RATE                  }
 ao_dis_cmnd_b_rate = 7;         { DIS_CMND_B_RATE                  }
 ao_dic_info_b_rate = 8;         { DIC_INFO_B_RATE                  }
 ao_dis_info_b_rate = 9;         { DIS_INFO_B_RATE                  }
 ao_cpu_load        = 10;        { CPU_LOAD                         }
 ao_PingTime_Mean   = 11;        { Ping time mean value, ms         }
 ao_PingTime_Rmsd   = 12;        { Ping time rmsd, ms               }

type
 TTagRef = record tag,nai,nao,ndi,ndo:Integer; val:Real; end;
 TDIM_PINGMainRec = record       { Main control & GUI               }
  CMD    : record                { Commands to control GUI          }
   OPEN  : TTagRef;              { Open DAT file(s)                 }
   SAVE  : TTagRef;              { Save DAT file(s)                 }
   SOUND : TTagRef;              { Sound menu                       }
   SMILE : TTagRef;              { Smile menu                       }
   CLOSE : TTagRef;              { Close DAQ/CRW/WIN                }
  end;                           {                                  }
 end;                            {                                  }
 TStatSumm1D = record            { To collect 1D statistics         }
  N         : Integer;           { Number of entries                }
  SX,SXX    : Real;              { Summ of x, x*x                   }
  LastPoll  : Real;              { Time of last statictics poll     }
  Duration  : Real;              { Last statistics collect duration }
  MEAN,RMSD : Real;              { Mean and RootMeanSquareDeviation }
 end;                            {                                  }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 DIM_PING          : record      { All DIM_PING data                }
  MAIN             : TDIM_PINGMainRec; { Main control & GUI         }
  AwokeTime        : Real;       { Time when DatSrv last awoke      }
  DatSrvGate       : TTagRef;    { Save data to DatSrv              }
  FdbSrvGate       : TTagRef;    { Save data to FdbSrv              }
  DIC_CMND_RATE    : TTagRef;    {                                  }
  DIS_CMND_RATE    : TTagRef;    {                                  }
  DIC_INFO_RATE    : TTagRef;    {                                  }
  DIS_INFO_RATE    : TTagRef;    {                                  }
  DIC_CMND_COUNT   : TTagRef;    {                                  }
  DIS_CMND_COUNT   : TTagRef;    {                                  }
  DIC_INFO_COUNT   : TTagRef;    {                                  }
  DIS_INFO_COUNT   : TTagRef;    {                                  }
  DIC_CMND_B_RATE  : TTagRef;    {                                  }
  DIS_CMND_B_RATE  : TTagRef;    {                                  }
  DIC_INFO_B_RATE  : TTagRef;    {                                  }
  DIS_INFO_B_RATE  : TTagRef;    {                                  }
  DIC_CMND_B_COUNT : TTagRef;    {                                  }
  DIS_CMND_B_COUNT : TTagRef;    {                                  }
  DIC_INFO_B_COUNT : TTagRef;    {                                  }
  DIS_INFO_B_COUNT : TTagRef;    {                                  }
  PING_SEND_BTN    : TTagRef;    {                                  }
  PING_SEND_CYCLE  : TTagRef;    {                                  }
  PING_SEND_COUNT  : TTagRef;    {                                  }
  PING_SEND_PERIOD : TTagRef;    {                                  }
  PING_SERVER_ON   : TTagRef;    {                                  }
  PING_CLIENT_ON   : TTagRef;    {                                  }
  PING_TIME        : TTagRef;    {                                  }
  PING_TIME_MEAN   : TTagRef;    {                                  }
  PING_TIME_RMSD   : TTagRef;    {                                  }
  PING_STAT_PERIOD : TTagRef;    {                                  }
  NUMSERV          : TTagRef;    {                                  }
  DATALEN          : TTagRef;    {                                  }
  DIM_DNS_NODE     : TTagRef;    {                                  }
  DIM_TASK         : TTagRef;    {                                  }
  DIM_MODE         : TTagRef;    {                                  }
  CPU_LOAD         : TTagRef;    {                                  }
  DIC_CMND         : array[1..MaxNumServ] of TTagRef; {             }
  DIS_CMND         : array[1..MaxNumServ] of TTagRef; {             }
  DIC_INFO         : array[1..MaxNumServ] of TTagRef; {             }
  DIS_INFO         : array[1..MaxNumServ] of TTagRef; {             }
  PING_TIME_STAT   : TStatSumm1D;{ Ping time statistics collector   }
  REPORT           : record      { Report generator                 }
   FileName        : String;     { File name                        }
   NumLines        : Integer;    { Num lines written                }
  end;
 end;                            {                                  }
 cmd_MenuToolsOpen : Integer;    { @MenuToolsOpen                   }
 cmd_MenuConsolesOpen : Integer; { @MenuConsolesOpen                }
 cmd_MenuEditProgramOpen : Integer; { @MenuEditProgramOpen          }
 cmd_MenuDeviceRestartOpen : Integer; { @MenuDeviceRestartOpen      }
 cmd_dim_cmnd      : Integer;    { @DIM_CMND                        }
 cmd_dim_info      : Integer;    { @DIM_INFO                        }
 cmd_reset_counts  : Integer;    { @RESET_COUNTS                    }
 cmd_ping_configs  : Integer;    { @PING_CONFIGS                    }
 cmd_ping_report   : Integer;    { @PING_REPORT                     }
 cmd_dim_gui       : Integer;    { @DIM_GUI                         }
 cmd_dim_tree      : Integer;    { @DIM_TREE                        }
 NumServ           : Integer;    { Number of services               }
 LastRateTime      : Real;       { Timer to calculate rate          }
 LastPingTime      : Real;       { Timer to send pings              }
 LastCpuTimes      : Real;       { CPU times to calculate CPU Load  }
 winHistogram      : String;     { Histogram window name            }
 winPingTime       : String;     { Ping time window name            }
 winPingRate       : String;     { Ping rate window name            }
 winPingBRate      : String;     { Ping byte rate window name       }
 winCpuLoad        : String;     { CPU Load window name             }
 winPingTab        : String;     { Ping table window name           }
 IsServerMode      : Boolean;    { DIM_MODE = SERVER                }
 IsClientMode      : Boolean;    { DIM_MODE = CLIENT                }
 IsNormalMode      : Boolean;    { DIM_MODE = SERVER|CLIENT         }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_StdMenuTools}          { Standard Menu Tools  functions,  }

 {
 Statistics collecting routites
 }
 procedure ClearStatSumm1D(var S:TStatSumm1D);
 begin
  S.N:=0;
  S.SX:=0.0; S.SXX:=0.0;
  S.MEAN:=0.0; S.RMSD:=0.0;
  S.LastPoll:=0.0; S.Duration:=0;
 end;
 procedure AddStatSumm1D(var S:TStatSumm1D; X:Real);
 begin
  S.N:=S.N+1;
  S.SX:=S.SX+X;
  S.SXX:=S.SXX+X*X;
 end;
 procedure CalcStatSumm1D(var S:TStatSumm1D);
 begin
  S.MEAN:=0.0; if (S.N>0) then S.MEAN:=S.SX/S.N;
  S.RMSD:=0.0; if (S.N>0) then S.RMSD:=sqrt(S.SXX/S.N-sqr(S.MEAN));
 end;
 procedure ResetStatSumm1D(var S:TStatSumm1D; ms,dt:Real);
 begin
  S.N:=0; S.SX:=0.0; S.SXX:=0.0; S.LastPoll:=ms; S.Duration:=dt;
 end;
 function PollStatSumm1D(var S:TStatSumm1D; Period:Real):boolean;
 var ms,dt:Real; poll:Boolean;
 begin
  ms:=msecnow;
  dt:=ms-S.LastPoll;
  poll:=(Period>0) and (dt>=Period);
  if poll then begin
   CalcStatSumm1D(S);
   ResetStatSumm1D(S,ms,dt);
  end;
  PollStatSumm1D:=poll; 
 end;
 {
 Report routines.
 }
 function GetCpuName:String;
 var s:String; code:Integer;
 begin
  s:='';
  if IsWindows then begin
   if (s='') then s:=ParamStr('Registry HKLM HARDWARE\Description\System\CentralProcessor\0 ProcessorNameString');
   if (s='') then s:=GetEnv('PROCESSOR_IDENTIFIER');
  end;
  if IsUnix then begin
   s:=RunSysCommandAsText('cat /proc/cpuinfo','','',code,2000);
   s:=StringReplace(s,': ','= ',rfReplaceAll);
   s:=CookieScan(s,'model name',0);
  end;
  GetCpuName:=Trim(s);
  s:='';
 end;
 function GetCpuMhz:Real;
 var mhz:Real;
 begin
  mhz:=cpu_mhz;
  if IsWindows then mhz:=Dump2i(ParamStr('Registry HKLM HARDWARE\Description\System\CentralProcessor\0 ~MHz'));
  if IsNan(mhz) or IsInf(mhz) or (mhz<=0) then mhz:=cpu_mhz;
  GetCpuMhz:=mhz;
 end;
 function GetOsName:String;
 var s:String; code:Integer;
 begin
  s:='';
  if IsWindows then s:=RunSysCommandAsText('unix detectwindows','','',code,3000);
  if IsUnix then s:=Trim(RunSysCommandAsText('uname -snorm','','',code,3000));
  if IsUnix then s:=s+' '+Trim(RunSysCommandAsText('lsb_release -sd','','',code,3000));
  GetOsName:=Trim(s);
  s:='';
 end;
 function GetWantedPollRate:Real;
 begin
  GetWantedPollRate:=iGetTag(DIM_PING.NUMSERV.tag)*iGetTag(DIM_PING.PING_SEND_COUNT.tag)*1e3/iGetTag(DIM_PING.PING_SEND_PERIOD.tag);
 end;
 procedure DimPingReportWriteln(arg:String);
 begin
  if not IsEmptyStr(DIM_PING.REPORT.FileName) then begin
   Cron('@FileWriteln '+Trim(DIM_PING.REPORT.FileName)+' '+arg);
   DIM_PING.REPORT.NumLines:=DIM_PING.REPORT.NumLines+1;
  end;   
 end;
 procedure DimPingReport(arg:String);
 var s:String; fr:Real;
 begin
  s:='';
  arg:=Trim(arg);
  if IsSameText(ExtractWord(1,arg),'add') then begin
   if IsEmptyStr(DIM_PING.REPORT.FileName) then DimPingReport('new'); 
   if not IsEmptyStr(DIM_PING.REPORT.FileName) then begin
    s:=s+StrFmt('%-7s',  'NUMSERV');        s:=s+Chr(_HT);
    s:=s+StrFmt('%-7s',  'PERIOD');         s:=s+Chr(_HT);
    s:=s+StrFmt('%-7s',  'COUNT');          s:=s+Chr(_HT);
    s:=s+StrFmt('%-7s',  'DATALEN');        s:=s+Chr(_HT);
    s:=s+StrFmt('%-14s', 'WANT_POLL_RATE'); s:=s+Chr(_HT);
    s:=s+StrFmt('%-14s', 'POLL_RATE');      s:=s+Chr(_HT);
    s:=s+StrFmt('%-14s', 'BYTE_RATE');      s:=s+Chr(_HT);
    s:=s+StrFmt('%-10s', 'PING_MEAN');      s:=s+Chr(_HT);
    s:=s+StrFmt('%-10s', 'PING_RMSD');      s:=s+Chr(_HT);
    s:=s+StrFmt('%-8s',  'CPU_LOAD');       s:=s+Chr(_HT);
    s:=s+StrFmt('%-6s',  'ERRORS');
    if (DIM_PING.REPORT.NumLines=0) then begin
     DimPingReportWriteln(s); DIM_PING.REPORT.NumLines:=0;
    end;
    s:='';
    s:=s+StrFmt('%-7d',iGetTag(DIM_PING.NUMSERV.tag));             s:=s+Chr(_HT);
    s:=s+StrFmt('%-7d',iGetTag(DIM_PING.PING_SEND_PERIOD.tag));    s:=s+Chr(_HT);
    s:=s+StrFmt('%-7d',iGetTag(DIM_PING.PING_SEND_COUNT.tag));     s:=s+Chr(_HT);
    s:=s+StrFmt('%-7d',iGetTag(DIM_PING.DATALEN.tag));             s:=s+Chr(_HT);
    s:=s+StrFmt('%-14.3f',GetWantedPollRate);                      s:=s+Chr(_HT);
    s:=s+StrFmt('%-14.3f',rGetTag(DIM_PING.DIC_CMND_RATE.tag));    s:=s+Chr(_HT);
    s:=s+StrFmt('%-14.3f',rGetTag(DIM_PING.DIC_INFO_B_RATE.tag));  s:=s+Chr(_HT);
    s:=s+StrFmt('%-10.3f',rGetTag(DIM_PING.PING_TIME_MEAN.tag));   s:=s+Chr(_HT);
    s:=s+StrFmt('%-10.3f',rGetTag(DIM_PING.PING_TIME_RMSD.tag));   s:=s+Chr(_HT);
    s:=s+StrFmt('%-8.2f',rGetTag(DIM_PING.CPU_LOAD.tag));         s:=s+Chr(_HT);
    s:=s+StrFmt('%-6.0f',GetErrCount(-1));
    DimPingReportWriteln(s);
    s:=StrFmt('New record (%d) added to ',DIM_PING.REPORT.NumLines);
    s:=s+ExtractFileName(DIM_PING.REPORT.FileName)+ExtractFileExt(DIM_PING.REPORT.FileName);
    ShowTooltip(StrFmt('guid #%d@ping_report_add ',GetPid)+StrFmt('text "%s" preset stdOk delay 15000',s));
   end;   
  end else
  if IsSameText(ExtractWord(1,arg),'see') then begin
   if not IsEmptyStr(DIM_PING.REPORT.FileName) then begin
    if IsWindows then Cron('@run LogViewer '+DIM_PING.REPORT.FileName);
    if IsUnix then Cron('@run unix lister '+DIM_PING.REPORT.FileName);
   end;
  end else
  if IsSameText(ExtractWord(1,arg),'edit') then begin
   if not IsEmptyStr(DIM_PING.REPORT.FileName)
   then Cron('@FileOpenDialog '+DIM_PING.REPORT.FileName)
   else Cron('@FileOpenDialog '+AddPathDelim(ParamStr('DAQDATAPATH'))+'*.log');   
  end else
  if IsSameText(ExtractWord(1,arg),'new') then begin
   DIM_PING.REPORT.FileName:=GetDateTime(mSecNow);
   DIM_PING.REPORT.FileName:=StringReplace(DIM_PING.REPORT.FileName,'.','',rfReplaceAll);
   DIM_PING.REPORT.FileName:=StringReplace(DIM_PING.REPORT.FileName,':','',rfReplaceAll);
   DIM_PING.REPORT.FileName:=DefaultExtension('DIM_PING_'+DIM_PING.REPORT.FileName,'.log');
   DIM_PING.REPORT.FileName:=AdaptFileName(DIM_PING.REPORT.FileName);
   DIM_PING.REPORT.FileName:=AddPathDelim(ParamStr('DAQDATAPATH'))+DIM_PING.REPORT.FileName;
   DimPingReportWriteln(GetDateTime(mSecNow)+' => '+ParamStr('UserName')+'@'+ParamStr('HostName 1'));
   DimPingReportWriteln('Platform: '+GetOsName);
   DimPingReportWriteln('CPU: '+StrFmt('%d  CPU',cpu_count)+StrFmt(' at %1.3fGHz - ',GetCpuMhz/1000)+GetCpuName);
   s:='New report opened: '+ExtractFileName(DIM_PING.REPORT.FileName)+ExtractFileExt(DIM_PING.REPORT.FileName);
   ShowTooltip(StrFmt('guid #%d@ping_report_new ',GetPid)+StrFmt('text "%s" preset stdOk delay 15000',s));
   Success('@ping_report new '+DIM_PING.REPORT.FileName);
   DIM_PING.REPORT.NumLines:=0;
  end;
  s:='';
 end;
 {
 Xor bit on click (local version)
 }
 procedure ClickBitXorLocal(tag,XorMask:Integer);
 begin
  if ClickTag=tag then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,15000);
 end;
 {
 Menu CLOSE Starter to start editing.
 }
 procedure MenuCloseStarter;
 var i,n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Закрыть"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Продолжить работу текущего сеанса АСУ');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@tooltip text "Желаю успешной работы" preset stdNotify delay 15000');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и закрыть программу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Crw Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс АСУ и продолжить работу');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Exit');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить сеанс АСУ и начать заново');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Daq Restart');
   //////////////////////////////////////////
   for i:=1 to WordCount(EditGetWellKnownDevices(DevName)) do
   if (RefFind('device '+ExtractWord(i,EditGetWellKnownDevices(DevName)))<>0) then begin
    n:=n+EditAddInputLn('Перезапустить сервер '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
    n:=n+EditAddConfirm(EditGetLastInputLn);
    n:=n+EditAddCommand('@SysEval @Daq Compile '+ExtractWord(i,EditGetWellKnownDevices(DevName)));
   end;
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Завершить сеанс '+ParamStr('System Os Platform'));
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Logout');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезагрузить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Restart');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Выключить компьютер');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@Cron @Shutdown Win Exit');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 530 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CLOSE'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu CLOSE Handler to handle editing.
 }
 procedure MenuCloseHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_CLOSE'));
 end;
 {
 Menu TOOLS Starter to start editing.
 }
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть окно: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: нормальный  (3)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: ввод-вывод (15)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: детальный  (31)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Загрузить параметры из INI файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@LoadIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сохранить параметры в  INI файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SaveIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть Консольное Окно …');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@MenuConsolesOpen');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Отредактировать Программу …');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@MenuEditProgramOpen');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Перезапустить Устройство …');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@MenuDeviceRestartOpen');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:14\Style:[Bold]');
   n:=n+EditAddSetting('@set Form.Left 375 relative '+Copy(DevName,2)+' PaintBox');
   n:=n+EditAddSetting('@set Form.Top  0   relative '+Copy(DevName,2)+' PaintBox');
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 {
 Menu TOOLS Handler to handle editing.
 }
 procedure MenuToolsHandler;
 begin
  EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
 end;
 {
 Awake DatSrv to enforce data save.
 }
 procedure AwakeDatSrv;
 begin
  DIM_PING.AwokeTime:=mSecNow;
  DevPostCmd(devDatSrv,'   ');
  DevPostCmd(devFdbSrv,'@Awake');
 end;
 {
 Check Service index (i) is valid.
 }
 function IsValidServNum(i:Integer):Boolean;
 begin
  if (i<1) then IsValidServNum:=false else
  if (i>NumServ) then IsValidServNum:=false else
  if (i>MaxNumServ) then IsValidServNum:=false else
  IsValidServNum:=true;
 end;
 {
 Send DIM ping command DEMO/DIM_PING/CMND_i as string.
 }
 procedure SendDimPing(i:Integer; pid:Integer; tim:Real; siz:Integer);
 var msg:String;
 begin
  msg:='';
  if IsValidServNum(i) then begin
   msg:=Str(pid)+', '+Str(tim)+', '+Str(siz);
   DIM_UpdateTag(DIM_PING.DIC_CMND[i].tag,msg);
   bNul(rAtomicTagOp(DIM_PING.DIC_CMND_COUNT.tag,'+',1));
   bNul(rAtomicTagOp(DIM_PING.DIC_CMND_B_COUNT.tag,'+',Length(msg)+1));
  end;
  msg:='';
 end;
 procedure SendDimPings(Count:Integer);
 var i,n,siz:Integer;
 begin
  siz:=imax(MinDataLen,imin(iGetTag(DIM_PING.DATALEN.tag),MaxDataLen));
  for n:=1 to Count do
  for i:=1 to NumServ do SendDimPing(i,CurrentProcessId,mSecNow,siz);
 end;
 {
 Handle DIM ping command (arg) from client(s).
 arg = i, mime_encode('pid ms size') 
 }
 procedure HandleDimPingCmnd(var arg:String);
 var i,siz,pid:Integer; tim,dt:Real; dat:String;
 begin
  dat:='';
  i:=Val(ExtractWord(1,arg));
  dat:=mime_decode(SkipWords(1,arg));
  pid:=Val(ExtractWord(1,dat));
  tim:=rVal(ExtractWord(2,dat));
  siz:=Val(ExtractWord(3,dat));
  bNul(rAtomicTagOp(DIM_PING.DIS_CMND_COUNT.tag,'+',1));
  bNul(rAtomicTagOp(DIM_PING.DIS_CMND_B_COUNT.tag,'+',Length(dat)));
  if DebugFlagEnabled(dfDetails) then Details('CMND '+Str(i)+', '+Str(pid)+', '+Str(tim)+', '+Str(siz));
  if IsValidServNum(i) and (pid>0) and (tim>0) and not IsNan(tim) and not IsInf(tim) and (siz>0) then begin
   dat:=Str(pid)+', '+Str(tim)+', '+Str(siz);
   if (siz>Length(dat)+1) then dat:=dat+StringOfChar(' ',imax(0,siz-Length(dat)-1));
   DIM_UpdateTag(DIM_PING.DIS_INFO[i].tag,dat);
   bNul(rAtomicTagOp(DIM_PING.DIS_INFO_COUNT.tag,'+',1));
   bNul(rAtomicTagOp(DIM_PING.DIS_INFO_B_COUNT.tag,'+',Length(dat)+1));
   if DebugFlagEnabled(dfDetails) then Details('SEND '+Str(i)+', '+Str(Length(dat)));
  end else Trouble('Error: Invalid @DIM_CMND '+arg);
  dat:='';
 end;
 {
 Handle DIM ping answer (arg) from server.
 arg = i, mime_encode(pid ms size)
 }
 procedure HandleDimPingInfo(var arg:String);
 var i,siz,pid,chan,crv:Integer; tim,dt,ch,mi,ma:Real; dat:String;
 begin
  dat:='';
  i:=Val(ExtractWord(1,arg));
  dat:=mime_decode(SkipWords(1,arg));
  pid:=Val(ExtractWord(1,dat));
  tim:=rVal(ExtractWord(2,dat));
  siz:=Val(ExtractWord(3,dat));
  if DebugFlagEnabled(dfDetails) then Details('INFO '+Str(i)+', '+Str(pid)+', '+Str(tim)+', '+Str(siz));
  if (Length(dat)>SizeOfInteger) then begin
   if IsValidServNum(i) and (pid>0) and (tim>0) and not IsNan(tim) and not IsInf(tim) and (siz>0) then begin
    bNul(rAtomicTagOp(DIM_PING.DIC_INFO_COUNT.tag,'+',1));
    bNul(rAtomicTagOp(DIM_PING.DIC_INFO_B_COUNT.tag,'+',Length(dat)));
    if DebugFlagEnabled(dfDetails) then Details('READ '+Str(i)+', '+Str(Length(dat)));
    if (pid=CurrentProcessId) then begin
     crv:=RefAo(ao_PingHist);
     mi:=0; ma:=crvlen(crv)-1;
     dt:=msecnow-tim; ch:=Ceil(dt/10);
     ch:=max(mi,min(ma,ch)); chan:=Round(ch);
     bNul(rSetTag(DIM_PING.PING_TIME.tag,dt));
     bNul(putev(8,ao_PingHist,time,chan,1));
     UpdateAo(ao_PingTime,time,dt);
     AddStatSumm1D(DIM_PING.PING_TIME_STAT,dt);
    end;
   end else Trouble('Error: Invalid @DIM_INFO '+arg);
  end;
  dat:='';
 end;
 {
 Update CPU_LOAD.
 }
 procedure UpdateCpuLoad(var Rate:TTagRef; dt:Real; ao:Integer; tm:Real);
 var s:String; kts,uts,pts,dts,rt:Real;
 begin
  s:='';
  s:=ParamStr('SYSTEM PROCESS Times');
  kts:=rVal(ExtractWord(3,s)); uts:=rVal(ExtractWord(4,s)); pts:=kts+uts;
  dts:=pts-Rate.val; Rate.val:=pts; rt:=dts/dt*1e-2; rt:=max(0,rt);
  bNul(rSetTag(Rate.tag,rt)); UpdateAo(ao,tm,rt);
  s:='';
 end;
 {
 Update rate and count. 
 }
 procedure UpdateRate(var Rate,Count:TTagRef; dt:Real; ao:Integer; tm:Real);
 var v,dv,rt:Real;
 begin
  v:=rGetTag(Count.tag); dv:=max(0,v-Count.val); Count.val:=v; rt:=1000*dv/dt;
  bNul(rSetTag(Rate.tag,rt)); UpdateAo(ao,tm,rt);
 end;
 {
 Update rate values.
 }
 procedure UpdateDimPingRate;
 var ms,dt,tm:Real;
 begin
  tm:=time;
  ms:=mSecNow;
  dt:=ms-LastRateTime;
  if (dt>=1000) then begin
   UpdateRate(DIM_PING.DIC_CMND_RATE,DIM_PING.DIC_CMND_COUNT,dt,ao_dic_cmnd_rate,tm);
   UpdateRate(DIM_PING.DIS_CMND_RATE,DIM_PING.DIS_CMND_COUNT,dt,ao_dis_cmnd_rate,tm);
   UpdateRate(DIM_PING.DIC_INFO_RATE,DIM_PING.DIC_INFO_COUNT,dt,ao_dic_info_rate,tm);
   UpdateRate(DIM_PING.DIS_INFO_RATE,DIM_PING.DIS_INFO_COUNT,dt,ao_dis_info_rate,tm);
   UpdateRate(DIM_PING.DIC_CMND_B_RATE,DIM_PING.DIC_CMND_B_COUNT,dt,ao_dic_cmnd_b_rate,tm);
   UpdateRate(DIM_PING.DIS_CMND_B_RATE,DIM_PING.DIS_CMND_B_COUNT,dt,ao_dis_cmnd_b_rate,tm);
   UpdateRate(DIM_PING.DIC_INFO_B_RATE,DIM_PING.DIC_INFO_B_COUNT,dt,ao_dic_info_b_rate,tm);
   UpdateRate(DIM_PING.DIS_INFO_B_RATE,DIM_PING.DIS_INFO_B_COUNT,dt,ao_dis_info_b_rate,tm);
   UpdateCpuLoad(DIM_PING.CPU_LOAD,dt,ao_cpu_load,tm);
   LastRateTime:=ms;
  end;
 end;
 {
 Procedure to reset (clear all counters).
 }
 procedure ResetCounts;
 var i,crv:Integer;
 begin
  bNul(rSetTag(DIM_PING.PING_TIME.tag,0));
  bNul(rSetTag(DIM_PING.DIC_CMND_COUNT.tag,0));
  bNul(rSetTag(DIM_PING.DIS_CMND_COUNT.tag,0));
  bNul(rSetTag(DIM_PING.DIC_INFO_COUNT.tag,0));
  bNul(rSetTag(DIM_PING.DIS_INFO_COUNT.tag,0));
  bNul(rSetTag(DIM_PING.DIC_CMND_B_COUNT.tag,0));
  bNul(rSetTag(DIM_PING.DIS_CMND_B_COUNT.tag,0));
  bNul(rSetTag(DIM_PING.DIC_INFO_B_COUNT.tag,0));
  bNul(rSetTag(DIM_PING.DIS_INFO_B_COUNT.tag,0));
  ClearStatSumm1D(DIM_PING.PING_TIME_STAT);
  crv:=RefAo(ao_PingHist);
  for i:=1 to Round(crvlen(crv)) do bNul(crvput(crv,i,crvx(crv,i),0));
  DevPostCmdLocal('@windraw '+winHistogram);
  ClearCurveData(RefAo(ao_cpu_load));
  ClearCurveData(RefAo(ao_PingTime));
  ClearCurveData(RefAo(ao_dic_cmnd_rate));
  ClearCurveData(RefAo(ao_dis_cmnd_rate));
  ClearCurveData(RefAo(ao_dic_info_rate));
  ClearCurveData(RefAo(ao_dis_info_rate));
  ClearCurveData(RefAo(ao_dic_cmnd_b_rate));
  ClearCurveData(RefAo(ao_dis_cmnd_b_rate));
  ClearCurveData(RefAo(ao_dic_info_b_rate));
  ClearCurveData(RefAo(ao_dis_info_b_rate));
  DevPostCmdLocal('@windraw '+winPingTime);
  DevPostCmdLocal('@windraw '+winPingRate);
  DevPostCmdLocal('@windraw '+winPingBRate);
  DevPostCmdLocal('@windraw '+winCpuLoad);
 end;
 {
 Run DIM_PING Configurator.
 }
 procedure DimPingConfigs;
 begin
  Cron('@run '+AdaptFileName('Resource\DaqSite\DimServer\dim_benchmark.lm9')
      +' --dim_ping_dir='+ExtractFilePath(ParamStr('DaqConfigPath')));
 end;
 {
 Initilize DIM_PING.MAIN record tags
 }
 procedure TDIM_PINGMainRec_Init(var Rec:TDIM_PINGMainRec; TagPrefix:String);
 begin
  TagPrefix:=Trim(TagPrefix);
  if not IsEmptyStr(TagPrefix) then begin
   InitTag(Rec.CMD.OPEN.tag,  TagPrefix+'.CMD.OPEN',  1);
   InitTag(Rec.CMD.SAVE.tag,  TagPrefix+'.CMD.SAVE',  1);
   InitTag(Rec.CMD.SOUND.tag, TagPrefix+'.CMD.SOUND', 1);
   InitTag(Rec.CMD.SMILE.tag, TagPrefix+'.CMD.SMILE', 1);
   InitTag(Rec.CMD.CLOSE.tag, TagPrefix+'.CMD.CLOSE', 1);
   Rec.CMD.SMILE.val:=GetErrCount(-2);
  end;
 end;
 {
 Initialize DIM_PING tags.
 }
 procedure InitDimPingTags(tagPrefix:String);
 var i:Integer;
 begin
  TagPrefix:=Trim(TagPrefix);
  InitTag(DIM_PING.DIC_CMND_RATE.tag,    TagPrefix+'.DIC_CMND_RATE',    2);
  InitTag(DIM_PING.DIS_CMND_RATE.tag,    TagPrefix+'.DIS_CMND_RATE',    2);
  InitTag(DIM_PING.DIC_INFO_RATE.tag,    TagPrefix+'.DIC_INFO_RATE',    2);
  InitTag(DIM_PING.DIS_INFO_RATE.tag,    TagPrefix+'.DIS_INFO_RATE',    2);
  InitTag(DIM_PING.DIC_CMND_COUNT.tag,   TagPrefix+'.DIC_CMND_COUNT',   2);
  InitTag(DIM_PING.DIS_CMND_COUNT.tag,   TagPrefix+'.DIS_CMND_COUNT',   2);
  InitTag(DIM_PING.DIC_INFO_COUNT.tag,   TagPrefix+'.DIC_INFO_COUNT',   2);
  InitTag(DIM_PING.DIS_INFO_COUNT.tag,   TagPrefix+'.DIS_INFO_COUNT',   2);
  InitTag(DIM_PING.DIC_CMND_B_RATE.tag,  TagPrefix+'.DIC_CMND_B_RATE',  2);
  InitTag(DIM_PING.DIS_CMND_B_RATE.tag,  TagPrefix+'.DIS_CMND_B_RATE',  2);
  InitTag(DIM_PING.DIC_INFO_B_RATE.tag,  TagPrefix+'.DIC_INFO_B_RATE',  2);
  InitTag(DIM_PING.DIS_INFO_B_RATE.tag,  TagPrefix+'.DIS_INFO_B_RATE',  2);
  InitTag(DIM_PING.DIC_CMND_B_COUNT.tag, TagPrefix+'.DIC_CMND_B_COUNT', 2);
  InitTag(DIM_PING.DIS_CMND_B_COUNT.tag, TagPrefix+'.DIS_CMND_B_COUNT', 2);
  InitTag(DIM_PING.DIC_INFO_B_COUNT.tag, TagPrefix+'.DIC_INFO_B_COUNT', 2);
  InitTag(DIM_PING.DIS_INFO_B_COUNT.tag, TagPrefix+'.DIS_INFO_B_COUNT', 2);
  InitTag(DIM_PING.PING_SEND_BTN.tag,    TagPrefix+'.PING_SEND_BTN',    1);
  InitTag(DIM_PING.PING_SEND_CYCLE.tag,  TagPrefix+'.PING_SEND_CYCLE',  1);
  InitTag(DIM_PING.PING_SEND_COUNT.tag,  TagPrefix+'.PING_SEND_COUNT',  1);
  InitTag(DIM_PING.PING_SEND_PERIOD.tag, TagPrefix+'.PING_SEND_PERIOD', 1);
  InitTag(DIM_PING.PING_SERVER_ON.tag,   TagPrefix+'.PING_SERVER_ON',   1);
  InitTag(DIM_PING.PING_CLIENT_ON.tag,   TagPrefix+'.PING_CLIENT_ON',   1);
  InitTag(DIM_PING.PING_TIME.tag,        TagPrefix+'.PING_TIME',        2);
  InitTag(DIM_PING.PING_TIME_MEAN.tag,   TagPrefix+'.PING_TIME_MEAN',   2);
  InitTag(DIM_PING.PING_TIME_RMSD.tag,   TagPrefix+'.PING_TIME_RMSD',   2);
  InitTag(DIM_PING.PING_STAT_PERIOD.tag, TagPrefix+'.PING_STAT_PERIOD', 1);
  InitTag(DIM_PING.NUMSERV.tag,          TagPrefix+'.NUMSERV',          1);
  InitTag(DIM_PING.DATALEN.tag,          TagPrefix+'.DATALEN',          1);
  InitTag(DIM_PING.DIM_DNS_NODE.tag,     TagPrefix+'.DIM_DNS_NODE',     3);
  InitTag(DIM_PING.DIM_TASK.tag,         TagPrefix+'.DIM_TASK',         3);
  InitTag(DIM_PING.DIM_MODE.tag,         TagPrefix+'.DIM_MODE',         3);
  InitTag(DIM_PING.CPU_LOAD.tag,         TagPrefix+'.CPU_LOAD',         2);
  for i:=1 to NumServ do InitTag(DIM_PING.DIC_CMND[i].tag,TagPrefix+StrFmt('.DIC_CMND_%d',i),3);
  for i:=1 to NumServ do InitTag(DIM_PING.DIS_CMND[i].tag,TagPrefix+StrFmt('.DIS_CMND_%d',i),3);
  for i:=1 to NumServ do InitTag(DIM_PING.DIC_INFO[i].tag,TagPrefix+StrFmt('.DIC_INFO_%d',i),3);
  for i:=1 to NumServ do InitTag(DIM_PING.DIS_INFO[i].tag,TagPrefix+StrFmt('.DIS_INFO_%d',i),3);
 end;
 {
 Clear tag reference record.
 }
 procedure ClearTagRef(var R:TTagRef);
 begin
  R.tag:=0;  R.val:=0;
  R.nai:=-1; R.ndi:=-1;
  R.nao:=-1; R.ndo:=-1;
 end;
 {
 DIM_PING clear strings
 }
 procedure DIM_PING_CLEAR;
 var i:Integer;
 begin
  winHistogram:=''; winPingTime:=''; winPingRate:='';
  winPingBRate:=''; winCpuLoad:='';  winPingTab:='';
  for i:=1 to MaxNumServ do ClearTagRef(DIM_PING.DIC_CMND[i]);
  for i:=1 to MaxNumServ do ClearTagRef(DIM_PING.DIC_INFO[i]);
  for i:=1 to MaxNumServ do ClearTagRef(DIM_PING.DIS_CMND[i]);
  for i:=1 to MaxNumServ do ClearTagRef(DIM_PING.DIS_INFO[i]);
  ClearStatSumm1D(DIM_PING.PING_TIME_STAT);
  DIM_PING.Report.FileName:='';
  DIM_PING.REPORT.NumLines:=0;
 end;
 {
 DIM_PING initialization
 }
 procedure DIM_PING_INIT;
 begin
  //
  // Initialize tags & devices...
  //
  TDIM_PINGMainRec_Init(DIM_PING.MAIN,ReadIni('tagDIM_PING')+'.MAIN');
  InitTag(DIM_PING.DatSrvGate.tag,'DATSRV.GATE',-1);
  InitTag(DIM_PING.FdbSrvGate.tag,'FDBSRV.GATE',-1);
  NumServ:=Val(ReadIni('NumServ'));
  NumServ:=imax(1,imin(MaxNumServ,NumServ));
  if (NumServ<1) or (NumServ>MaxNumServ)
  then Problem('Invalid NumServ='+Str(NumServ))
  else Success('NumServ = '+Str(NumServ));
  InitDimPingTags(ReadIni('tagDimPing'));
  bNul(iSetTag(DIM_PING.NUMSERV.tag,NumServ));
  winHistogram:=ReadIni('winHistogram'); Success('winHistogram = '+winHistogram);
  winPingTime:=ReadIni('winPingTime');   Success('winPingTime  = '+winPingTime);
  winPingRate:=ReadIni('winPingRate');   Success('winPingRate  = '+winPingRate);
  winPingBRate:=ReadIni('winPingBRate'); Success('winPingBRate = '+winPingBRate);
  winPingTab:=ReadIni('winPingTab');     Success('winPingTab   = '+winPingTab);
  winCpuLoad:=ReadIni('winCpuLoad');     Success('winCpuLoad   = '+winCpuLoad);
  bNul(sSetTag(DIM_PING.DIM_DNS_NODE.tag,ReadIni('['+DimSrv+'] DIM_DNS_NODE')));
  bNul(sSetTag(DIM_PING.DIM_TASK.tag,ReadIni('['+DimSrv+'] DIM_TASK')));
  IsServerMode:=IsSameText(ReadIni('DIM_MODE'),'SERVER');
  IsClientMode:=IsSameText(ReadIni('DIM_MODE'),'CLIENT');
  IsNormalMode:=IsServerMode or IsClientMode;
  //
  // Initialize values...
  //
  DIM_PING.AwokeTime:=0;
  LastRateTime:=0;
  LastPingTime:=0;
  ClearStatSumm1D(DIM_PING.PING_TIME_STAT);
 end;
 {
 DIM_PING finalization
 }
 procedure DIM_PING_FREE;
 begin
 end;
 {
 DIM_PING polling
 }
 procedure DIM_PING_POLL;
 var nerrors:Real; ClickCurve:Integer;
 begin
  {
  Awake DatSrv to enforce data save.
  }
  if (SysTimer_Pulse(AwakePeriod)>0) then begin
   bNul(iSetTag(DIM_PING.DatSrvGate.tag,Ord(iGetTag(DIM_PING.MAIN.CMD.SAVE.tag)<>0)));
   bNul(iSetTag(DIM_PING.FdbSrvGate.tag,Ord(iGetTag(DIM_PING.MAIN.CMD.SAVE.tag)<>0)));
  end;
  {
  Execute GUI commands
  }
  if (iGetTag(DIM_PING.MAIN.CMD.OPEN.tag)<>0) then begin
   Cron('@FileOpenDialog '+URL_Packed(AddBackSlash(DaqFileRef(ReadIni('['+DatSrv+'] DataPath'),''))+'*.dat;*.crw'));
   bNul(iSetTag(DIM_PING.MAIN.CMD.OPEN.tag,0));
  end;
  if (iGetTag(DIM_PING.MAIN.CMD.CLOSE.tag)<>0) then begin
   bNul(iSetTag(DIM_PING.MAIN.CMD.CLOSE.tag,0));
   MenuCloseStarter;
  end;
  {
  Handle Smile button state
  }
  if (SysTimer_Pulse(SmilePeriod)>0) then begin
   nerrors:=GetErrCount(-2);
   if nerrors>DIM_PING.MAIN.CMD.SMILE.val then bNul(iSetTag(DIM_PING.MAIN.CMD.SMILE.tag,2)) else
   if iGetTag(DIM_PING.MAIN.CMD.SMILE.tag)>1 then bNul(iSetTag(DIM_PING.MAIN.CMD.SMILE.tag,1));
   DIM_PING.MAIN.CMD.SMILE.val:=nerrors;
  end;
  {
  Button Send Ping.
  }
  if (iGetTag(DIM_PING.PING_SEND_BTN.tag)<>0) then begin
   if (iGetTag(DIM_PING.PING_SEND_CYCLE.tag)=0) then begin
    bNul(iSetTag(DIM_PING.PING_SEND_BTN.tag,0));
    LastPingTime:=0;
   end;
   if (mSecNow-LastPingTime>iGetTag(DIM_PING.PING_SEND_PERIOD.tag)) then begin
    SendDimPings(imax(1,iGetTag(DIM_PING.PING_SEND_COUNT.tag)));
    LastPingTime:=mSecNow;
   end;
  end;
  {
  Check DIM_MODE, switch SERVER off if not IsServerMode.
  }
  if not IsServerMode then bNul(iSetTag(DIM_PING.PING_SERVER_ON.tag,0));
  {
  Calculate and update ping rate. Statistics collecting for PING_TIME.
  }
  if PollStatSumm1D(DIM_PING.PING_TIME_STAT,iGetTag(DIM_PING.PING_STAT_PERIOD.tag)) then begin
   bNul(rSetTag(DIM_PING.PING_TIME_MEAN.tag,DIM_PING.PING_TIME_STAT.MEAN));
   bNul(rSetTag(DIM_PING.PING_TIME_RMSD.tag,DIM_PING.PING_TIME_STAT.RMSD));
   UpdateAo(ao_PingTime_Mean,time,DIM_PING.PING_TIME_STAT.MEAN);
   UpdateAo(ao_PingTime_Rmsd,time,DIM_PING.PING_TIME_STAT.RMSD);
   UpdateDimPingRate;
  end;
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Menu CLOSE.
   }
   MenuCloseHandler;
   {
   Menu TOOLS.
   }
   MenuToolsHandler;
   {
   Menu CONSOLES
   }
   MenuConsolesHandler;
   {
   Menu EDITPROGRAM
   }
   MenuEditProgramHandler;
   {
   Menu DEVICERESTART
   }
   MenuDeviceRestartHandler;
   {
   Warning, Information dialog completion.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
   {
   Edit tags.
   }
   CheckEditTagUpdate(DIM_PING.PING_SEND_COUNT.tag,1,100);
   CheckEditTagUpdate(DIM_PING.PING_SEND_PERIOD.tag,0,60000);
   CheckEditTagUpdate(DIM_PING.DATALEN.tag,MinDataLen,MaxDataLen);
   CheckEditTagUpdate(DIM_PING.PING_STAT_PERIOD.tag,1000,60000);
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     //
     // Toolbar buttons...
     //
     ClickBitXorLocal(DIM_PING.MAIN.CMD.OPEN.tag,1);
     ClickBitXorLocal(DIM_PING.MAIN.CMD.SAVE.tag,1);
     ClickBitXorLocal(DIM_PING.MAIN.CMD.SOUND.tag,1);
     ClickBitXorLocal(DIM_PING.MAIN.CMD.CLOSE.tag,1);
     if (ClickTag=DIM_PING.MAIN.CMD.SAVE.tag) then begin
      bNul(iSetTag(DIM_PING.DatSrvGate.tag,Ord(iGetTag(DIM_PING.MAIN.CMD.SAVE.tag)<>0)));
      if iGetTag(DIM_PING.MAIN.CMD.SAVE.tag)<>0 then AwakeDatSrv;
     end;
     if IsSameText(ClickSensor,'DIM_PING.MAIN.CMD.HOME') then begin
      DevPostCmdLocal('@Cron @Cron.Run DIM_PING.MAIN.CTRL.HOME');
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'DIM_PING.MAIN.CMD.HELP') then begin
      DevPostCmdLocal('@BrowseHelp');
      bNul(Voice(snd_Click));
     end;
     if IsSameText(ClickSensor,'DIM_PING.MAIN.CMD.TOOLS') then begin
      DevPostCmdLocal('@MenuToolsOpen');
      bNul(Voice(snd_Click));
     end;
     //
     // Smile face button...
     //
     if (ClickTag=DIM_PING.MAIN.CMD.SMILE.tag) then begin
      bNul(Eval('@System @Async @Menu run FormDaqControlDialog.ActionDaqStatus')>0);
      bNul(iSetTag(DIM_PING.MAIN.CMD.SMILE.tag,0));
      bNul(Voice(snd_Click));
     end;
     //
     // Button PING_SEND_BTN
     //
     ClickBitXorLocal(DIM_PING.PING_SEND_BTN.tag,1);
     ClickBitXorLocal(DIM_PING.PING_SEND_CYCLE.tag,1);
     if IsServerMode then ClickBitXorLocal(DIM_PING.PING_SERVER_ON.tag,1);
     if IsNormalMode then ClickBitXorLocal(DIM_PING.PING_CLIENT_ON.tag,1);
     if (ClickTag=DIM_PING.PING_SEND_PERIOD.tag) then begin
      StartEditTagEx(DIM_PING.PING_SEND_PERIOD.tag,'Period to Send DIM Pings , ms',
      '@set StringGrid.Font Name:PT_Mono\Size:14\Color:Black\Style:[Bold]'+EOL+
      '@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox'+EOL+
      '@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox'+EOL);
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DIM_PING.PING_SEND_COUNT.tag) then begin
      StartEditTagEx(DIM_PING.PING_SEND_COUNT.tag,'Iteration Count to Send DIM Pings',
      '@set StringGrid.Font Name:PT_Mono\Size:14\Color:Black\Style:[Bold]'+EOL+
      '@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox'+EOL+
      '@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox'+EOL);
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DIM_PING.DATALEN.tag) then begin
      StartEditTagEx(DIM_PING.DATALEN.tag,'Data Length (bytes) for DIM Pings',
      '@set StringGrid.Font Name:PT_Mono\Size:14\Color:Black\Style:[Bold]'+EOL+
      '@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox'+EOL+
      '@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox'+EOL);
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DIM_PING.PING_STAT_PERIOD.tag) then begin
      StartEditTagEx(DIM_PING.PING_STAT_PERIOD.tag,'Period to Collect Ping Time Statistics , ms',
      '@set StringGrid.Font Name:PT_Mono\Size:14\Color:Black\Style:[Bold]'+EOL+
      '@set Form.Left '+ExtractWord(1,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox'+EOL+
      '@set Form.Top  '+ExtractWord(4,ClickParams('Bounds'))+' relative '+ClickParams('Window')+' PaintBox'+EOL);
      bNul(Voice(snd_Click));
     end;
     if (ClickTag=DIM_PING.DIC_CMND_COUNT.tag) then begin
      bNul(WinSelect(winPingTab));
      bNul(Voice(snd_Wheel));
     end;
     if (ClickTag=DIM_PING.DIS_CMND_COUNT.tag) then begin
      bNul(WinSelect(winPingTab));
      bNul(Voice(snd_Wheel));
     end;
     if (ClickTag=DIM_PING.DIC_INFO_COUNT.tag) then begin
      bNul(WinSelect(winPingTab));
      bNul(Voice(snd_Wheel));
     end;
     if (ClickTag=DIM_PING.DIS_INFO_COUNT.tag) then begin
      bNul(WinSelect(winPingTab));
      bNul(Voice(snd_Wheel));
     end;
     if IsSameText(ClickSensor,'DIM_DATAFLOW_DIAGRAM') then begin
      DevPostCmdLocal('@BrowseHelp');
      bNul(Voice(snd_Click));
     end;
     //
     // Select Plot & Tab windows by curve...
     //
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     //
     // Console commands: @url_encoded_sensor ...
     //
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
     //
     // Calibrations
     //
     if IsSameText(ExtractFileExt(ClickSensor),'.CAL') then begin
      bNul(CalibrOpenByCurve(RefFind('Curve '+ExtractFileName(ClickSensor))));
      bNul(Voice(snd_Click));
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  DIM_PING_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  if Val(ReadIni('CustomIniAutoLoad'))=1 then DevPostCmdLocal('@LoadIni');
  cmd_MenuToolsOpen := RegisterStdInCmd('@MenuToolsOpen', '');
  cmd_MenuConsolesOpen:=RegisterStdInCmd('@MenuConsolesOpen','');
  cmd_MenuEditProgramOpen:=RegisterStdInCmd('@MenuEditProgramOpen','');
  cmd_MenuDeviceRestartOpen:=RegisterStdInCmd('@MenuDeviceRestartOpen','');
  cmd_dim_cmnd      := RegisterStdInCmd('@DIM_CMND',      '');
  cmd_dim_info      := RegisterStdInCmd('@DIM_INFO',      '');
  cmd_reset_counts  := RegisterStdInCmd('@RESET_COUNTS',  '');
  cmd_ping_configs  := RegisterStdInCmd('@PING_CONFIGS',  '');
  cmd_ping_report   := RegisterStdInCmd('@PING_REPORT',   '');
  cmd_dim_gui       := RegisterStdInCmd('@DIM_GUI',       '');
  cmd_dim_tree      := RegisterStdInCmd('@DIM_TREE',      '');
  DIM_PING_INIT;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then DevPostCmdLocal('@SaveIni');
  DIM_PING_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  DIM_PING_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @dim_cmnd 1, 0ahjkndscds/--
   }
   if (cmdid=cmd_dim_cmnd) then begin
    if (iGetTag(DIM_PING.PING_SERVER_ON.tag)<>0) then HandleDimPingCmnd(arg);
    Data:='';
   end else
   {
   @dim_info 1, 0ahjkndscds/--
   }
   if (cmdid=cmd_dim_info) then begin
    if (iGetTag(DIM_PING.PING_CLIENT_ON.tag)<>0) then HandleDimPingInfo(arg);
    Data:='';
   end else
   {
   @reset_counts
   }
   if (cmdid=cmd_reset_counts) then begin
    ResetCounts;
    Data:='';
   end else
   {
   @ping_configs
   }
   if (cmdid=cmd_ping_configs) then begin
    DimPingConfigs;
    Data:='';
   end else
   {
   @ping_report new
   }
   if (cmdid=cmd_ping_report) then begin
    DimPingReport(arg);
    Data:='';
   end else
   {
   @dim_gui
   }
   if (cmdid=cmd_dim_gui) then begin
    if IsWindows then Cron('@run -hide dim gui');
    if IsUnix then Cron('@run terminal -e unix dim-cpl menu');
    Data:='';
   end else
   {
   @dim_tree
   }
   if (cmdid=cmd_dim_tree) then begin
    if IsWindows then Cron('@run dimtree');
    if IsUnix then Cron('@run unix dimtree');
    Data:='';
   end else
   {
   @MenuToolsOpen
   }
   if (cmdid=cmd_MenuToolsOpen) then begin
    MenuToolsStarter;
    Data:='';
   end else
   {
   @MenuConsolesOpen
   }
   if (cmdid=cmd_MenuConsolesOpen) then begin
    MenuConsolesStarter;
    Data:='';
   end else
   {
   @MenuEditProgramOpen
   }
   if (cmdid=cmd_MenuEditProgramOpen) then begin
    if HasUserAccessLevelTip('root',cmd,7,7000) then MenuEditProgramStarter;
    Data:='';
   end else
   {
   @MenuDeviceRestartOpen
   }
   if (cmdid=cmd_MenuDeviceRestartOpen) then begin 
    if HasUserAccessLevelTip('root',cmd,7,7000) then MenuDeviceRestartStarter;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
